/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.util.regex.Pattern;
import kafka.api.BaseConsumerTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.NoOffsetForPartitionException;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.OffsetOutOfRangeException;
import org.apache.kafka.clients.consumer.RoundRobinAssignor;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005eg\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0003\u00157bS:$X\r\u001f;D_:\u001cX/\\3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019\u0011\r]5\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0011\u0005\u0006\u001cXmQ8ogVlWM\u001d+fgRDQ!\u0004\u0001\u0005\u00029\ta\u0001P5oSRtD#A\b\u0011\u0005%\u0001\u0001\"B\t\u0001\t\u0003\u0011\u0012!\u0006;fgR\fU\u000f^8D_6l\u0017\u000e^(o\u00072|7/\u001a\u000b\u0002'A\u0011AcF\u0007\u0002+)\ta#A\u0003tG\u0006d\u0017-\u0003\u0002\u0019+\t!QK\\5uQ\t\u0001\"\u0004\u0005\u0002\u001cA5\tAD\u0003\u0002\u001e=\u0005)!.\u001e8ji*\tq$A\u0002pe\u001eL!!\t\u000f\u0003\tQ+7\u000f\u001e\u0005\u0006G\u0001!\tAE\u0001!i\u0016\u001cH/Q;u_\u000e{W.\\5u\u001f:\u001cEn\\:f\u0003\u001a$XM],bW\u0016,\b\u000f\u000b\u0002#5!)a\u0005\u0001C\u0001%\u0005\u0019B/Z:u\u0003V$xn\u00144gg\u0016$(+Z:fi\"\u0012QE\u0007\u0005\u0006S\u0001!\tAE\u0001\u0015i\u0016\u001cHo\u0012:pkB\u001cuN\\:v[B$\u0018n\u001c8)\u0005!R\u0002\"\u0002\u0017\u0001\t\u0003\u0011\u0012a\u0006;fgR\u0004\u0016\r\u001e;fe:\u001cVOY:de&\u0004H/[8oQ\tY#\u0004C\u00030\u0001\u0011\u0005!#A\ruKN$\b+\u0019;uKJtWK\\:vEN\u001c'/\u001b9uS>t\u0007F\u0001\u0018\u001b\u0011\u0015\u0011\u0004\u0001\"\u0001\u0013\u0003I!Xm\u001d;D_6l\u0017\u000e^'fi\u0006$\u0017\r^1)\u0005ER\u0002\"B\u001b\u0001\t\u0003\u0011\u0012a\b;fgR,\u0005\u0010]1oI&tw\rV8qS\u000e\u001cVOY:de&\u0004H/[8og\"\u0012AG\u0007\u0005\u0006q\u0001!\tAE\u0001 i\u0016\u001cHo\u00155sS:\\\u0017N\\4U_BL7mU;cg\u000e\u0014\u0018\u000e\u001d;j_:\u001c\bFA\u001c\u001b\u0011\u0015Y\u0004\u0001\"\u0001\u0013\u0003E!Xm\u001d;QCJ$\u0018\u000e^5p]N4uN\u001d\u0015\u0003uiAQA\u0010\u0001\u0005\u0002I\t\u0001\u0002^3tiN+Wm\u001b\u0015\u0003{iAQ!\u0011\u0001\u0005\u0002I\tQ\u0003^3tiB{7/\u001b;j_:\fe\u000eZ\"p[6LG\u000fC\u0003D\u0001\u0011\u0005!#A\u000euKN$\b+\u0019:uSRLwN\u001c)bkN,\u0017I\u001c3SKN,X.\u001a\u0015\u0003\u0005jAQA\u0012\u0001\u0005\u0002I\ta\u0003^3ti\u001a+Go\u00195J]Z\fG.\u001b3PM\u001a\u001cX\r\u001e\u0015\u0003\u000bjAQ!\u0013\u0001\u0005\u0002I\tq\u0003^3ti\u001a+Go\u00195SK\u000e|'\u000f\u001a+p_2\u000b'oZ3)\u0005!S\u0002\"\u0002'\u0001\t\u0003\u0011\u0012\u0001\u0007;fgR\u0014v.\u001e8e%>\u0014\u0017N\\!tg&<g.\\3oi\"\u00121J\u0007\u0005\u0006\u001f\u0002!\tAE\u0001&i\u0016\u001cH/T;mi&\u001cuN\\:v[\u0016\u0014(k\\;oIJ{'-\u001b8BgNLwM\\7f]RD#A\u0014\u000e\t\u000bI\u0003A\u0011\u0001\n\u0002EQ,7\u000f^'vYRL7i\u001c8tk6,'\u000fR3gCVdG/Q:tS\u001etW.\u001a8uQ\t\t&\u0004C\u0003V\u0001\u0011\u0005!#\u0001\u0017uKN$X*\u001e7uS\u000e{gn];nKJ\u001cVm]:j_:$\u0016.\\3pkR|en\u0015;paB{G\u000e\\5oO\"\u0012AK\u0007\u0005\u00061\u0002!\tAE\u0001'i\u0016\u001cH/T;mi&\u001cuN\\:v[\u0016\u00148+Z:tS>tG+[7f_V$xJ\\\"m_N,\u0007FA,\u001b\u0011\u0015Y\u0006\u0001\"\u0001]\u0003\t\u0012XO\\'vYRL7i\u001c8tk6,'oU3tg&|g\u000eV5nK>,H\u000fV3tiR\u00111#\u0018\u0005\u0006=j\u0003\raX\u0001\u000eG2|7/Z\"p]N,X.\u001a:\u0011\u0005Q\u0001\u0017BA1\u0016\u0005\u001d\u0011un\u001c7fC:DQa\u0019\u0001\u0005\u0002\u0011\f\u0011d\u0019:fCR,Gk\u001c9jG\u0006sGmU3oIJ+7m\u001c:egR!Q-\u001e>\u0000!\r1\u0017\u000e\u001c\b\u0003)\u001dL!\u0001[\u000b\u0002\rA\u0013X\rZ3g\u0013\tQ7NA\u0002TKRT!\u0001[\u000b\u0011\u00055\u001cX\"\u00018\u000b\u0005=\u0004\u0018AB2p[6|gN\u0003\u0002\u0006c*\u0011!OH\u0001\u0007CB\f7\r[3\n\u0005Qt'A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0006m\n\u0004\ra^\u0001\ni>\u0004\u0018n\u0019(b[\u0016\u0004\"A\u001a=\n\u0005e\\'AB*ue&tw\rC\u0003|E\u0002\u0007A0A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\t\u0003)uL!A`\u000b\u0003\u0007%sG\u000f\u0003\u0004\u0002\u0002\t\u0004\r\u0001`\u0001\u0014e\u0016\u001cwN\u001d3t!\u0016\u0014\b+\u0019:uSRLwN\u001c\u0005\b\u0003\u000b\u0001A\u0011AA\u0004\u0003\u0001\u001aXOY:de&\u0014WmQ8ogVlWM]!oIN#\u0018M\u001d;Q_2d\u0017N\\4\u0015\r\u0005%\u0011\u0011CA\u0018!\u0011\tY!!\u0004\u000e\u0003\u0001I1!a\u0004\u000b\u0005a\u0019uN\\:v[\u0016\u0014\u0018i]:jO:lWM\u001c;Q_2dWM\u001d\u0005\t\u0003'\t\u0019\u00011\u0001\u0002\u0016\u0005A1m\u001c8tk6,'\u000f\u0005\u0005\u0002\u0018\u0005}\u00111EA\u0012\u001b\t\tIB\u0003\u0003\u0002\u0014\u0005m!bAA\u000fa\u000691\r\\5f]R\u001c\u0018\u0002BA\u0011\u00033\u0011\u0001bQ8ogVlWM\u001d\t\u0006)\u0005\u0015\u0012\u0011F\u0005\u0004\u0003O)\"!B!se\u0006L\bc\u0001\u000b\u0002,%\u0019\u0011QF\u000b\u0003\t\tKH/\u001a\u0005\t\u0003c\t\u0019\u00011\u0001\u00024\u0005\tBo\u001c9jGN$vnU;cg\u000e\u0014\u0018NY3\u0011\u000b\u0005U\u0012QI<\u000f\t\u0005]\u0012\u0011\t\b\u0005\u0003s\ty$\u0004\u0002\u0002<)\u0019\u0011Q\b\u0004\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0012bAA\"+\u00059\u0001/Y2lC\u001e,\u0017\u0002BA$\u0003\u0013\u0012A\u0001T5ti*\u0019\u00111I\u000b\t\u000f\u00055\u0003\u0001\"\u0001\u0002P\u000513/\u001e2tGJL'-Z\"p]N,X.\u001a:t\u0003:$w+Y5u\r>\u0014\u0018i]:jO:lWM\u001c;\u0015\u0011\u0005E\u0013\u0011MA7\u0003_\u0002b!a\u0015\u0002^\u0005%QBAA+\u0015\u0011\t9&!\u0017\u0002\u000f5,H/\u00192mK*\u0019\u00111L\u000b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002`\u0005U#A\u0002\"vM\u001a,'\u000f\u0003\u0005\u0002d\u0005-\u0003\u0019AA3\u00035\u0019wN\\:v[\u0016\u0014xI]8vaB1\u00111KA/\u0003O\u0002\u0002\"a\u0006\u0002j\u0005\r\u00121E\u0005\u0005\u0003W\nIBA\u0007LC\u001a\\\u0017mQ8ogVlWM\u001d\u0005\t\u0003c\tY\u00051\u0001\u00024!9\u0011\u0011OA&\u0001\u0004)\u0017!D:vEN\u001c'/\u001b9uS>t7\u000fC\u0004\u0002v\u0001!\t!a\u001e\u0002O\r\u0014X-\u0019;f\u0007>t7/^7fe\u001e\u0013x.\u001e9B]\u0012<\u0016-\u001b;G_J\f5o]5h]6,g\u000e\u001e\u000b\t\u0003s\ny(a!\u0002\u0006B9A#a\u001f\u0002f\u0005E\u0013bAA?+\t1A+\u001e9mKJBq!!!\u0002t\u0001\u0007A0A\u0007d_:\u001cX/\\3s\u0007>,h\u000e\u001e\u0005\t\u0003c\t\u0019\b1\u0001\u00024!9\u0011\u0011OA:\u0001\u0004)\u0007bBAE\u0001\u0011\u0005\u00111R\u0001-C\u0012$7i\u001c8tk6,'o\u001d+p\u000fJ|W\u000f]!oI^\u000b\u0017\u000e\u001e$pe\u001e\u0013x.\u001e9BgNLwM\\7f]R$2bEAG\u0003#\u000b\u0019*a&\u0002\u001a\"9\u0011qRAD\u0001\u0004a\u0018a\u00058v[>37i\u001c8tk6,'o\u001d+p\u0003\u0012$\u0007\u0002CA2\u0003\u000f\u0003\r!!\u001a\t\u0011\u0005U\u0015q\u0011a\u0001\u0003#\nqbY8ogVlWM\u001d)pY2,'o\u001d\u0005\t\u0003c\t9\t1\u0001\u00024!9\u0011\u0011OAD\u0001\u0004)\u0007bBAO\u0001\u0011\u0005\u0011qT\u0001\u0018m\u0006d\u0017\u000eZ1uK\u001e\u0013x.\u001e9BgNLwM\\7f]R$\u0012bEAQ\u0003G\u000b)+!+\t\u0011\u0005U\u00151\u0014a\u0001\u0003#Bq!!\u001d\u0002\u001c\u0002\u0007Q\rC\u0004\u0002(\u0006m\u0005\u0019A<\u0002\u00075\u001cx\r\u0003\u0006\u0002,\u0006m\u0005\u0013!a\u0001\u0003[\u000b\u0001b^1jiRKW.\u001a\t\u0004)\u0005=\u0016bAAY+\t!Aj\u001c8h\u0011\u001d\t)\f\u0001C\u0001\u0003o\u000bAg\u00195b]\u001e,7i\u001c8tk6,'o\u0012:pkB\u001cVOY:de&\u0004H/[8o\u0003:$g+\u00197jI\u0006$X-Q:tS\u001etW.\u001a8u)\u001d\u0019\u0012\u0011XA^\u0003{C\u0001\"!&\u00024\u0002\u0007\u0011\u0011\u000b\u0005\t\u0003c\t\u0019\f1\u0001\u00024!9\u0011\u0011OAZ\u0001\u0004)\u0007\"CAa\u0001E\u0005I\u0011AAb\u0003\u00052\u0018\r\\5eCR,wI]8va\u0006\u001b8/[4o[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\t)M\u000b\u0003\u0002.\u0006\u001d7FAAe!\u0011\tY-!6\u000e\u0005\u00055'\u0002BAh\u0003#\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005MW#\u0001\u0006b]:|G/\u0019;j_:LA!a6\u0002N\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class PlaintextConsumerTest
extends BaseConsumerTest {
    @Test
    public void testAutoCommitOnClose() {
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        int numRecords = 10000;
        this.sendRecords(numRecords);
        consumer0.subscribe((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        scala.collection.immutable.Set assignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, assignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$1;
            private final scala.collection.immutable.Set assignment$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer0$1.poll(50L);
                java.util.Set set = this.consumer0$1.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.assignment$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$1 = consumer0$1;
                this.assignment$1 = assignment$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)assignment).asJava(), consumer0.assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        consumer0.seek(this.tp(), 300L);
        consumer0.seek(this.tp2(), 500L);
        consumer0.close();
        Assert.assertEquals((long)300L, (long)((KafkaConsumer)this.consumers().apply(0)).committed(this.tp()).offset());
        Assert.assertEquals((long)500L, (long)((KafkaConsumer)this.consumers().apply(0)).committed(this.tp2()).offset());
    }

    @Test
    public void testAutoCommitOnCloseAfterWakeup() {
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        int numRecords = 10000;
        this.sendRecords(numRecords);
        consumer0.subscribe((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        scala.collection.immutable.Set assignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, assignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$2;
            private final scala.collection.immutable.Set assignment$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer0$2.poll(50L);
                java.util.Set set = this.consumer0$2.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.assignment$2).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$2 = consumer0$2;
                this.assignment$2 = assignment$2;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)assignment).asJava(), consumer0.assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        consumer0.seek(this.tp(), 300L);
        consumer0.seek(this.tp2(), 500L);
        consumer0.wakeup();
        consumer0.close();
        Assert.assertEquals((long)300L, (long)((KafkaConsumer)this.consumers().apply(0)).committed(this.tp()).offset());
        Assert.assertEquals((long)500L, (long)((KafkaConsumer)this.consumers().apply(0)).committed(this.tp2()).offset());
    }

    @Test
    public void testAutoOffsetReset() {
        this.sendRecords(1);
        ((KafkaConsumer)this.consumers().apply(0)).assign((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().apply(0)), 1, 0, this.consumeAndVerifyRecords$default$4());
    }

    @Test
    public void testGroupConsumption() {
        this.sendRecords(10);
        ((KafkaConsumer)this.consumers().apply(0)).subscribe((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().apply(0)), 1, 0, this.consumeAndVerifyRecords$default$4());
    }

    @Test
    public void testPatternSubscription() {
        int numRecords = 10000;
        this.sendRecords(numRecords);
        String topic1 = "tblablac";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic1, 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.sendRecords(1000, new TopicPartition(topic1, 0));
        this.sendRecords(1000, new TopicPartition(topic1, 1));
        String topic2 = "tblablak";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic2, 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.sendRecords(1000, new TopicPartition(topic2, 0));
        this.sendRecords(1000, new TopicPartition(topic2, 1));
        String topic3 = "tblab1";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic3, 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.sendRecords(1000, new TopicPartition(topic3, 0));
        this.sendRecords(1000, new TopicPartition(topic3, 1));
        Assert.assertEquals((long)0L, (long)((KafkaConsumer)this.consumers().apply(0)).assignment().size());
        Pattern pattern = Pattern.compile("t.*c");
        ((KafkaConsumer)this.consumers().apply(0)).subscribe(pattern, (ConsumerRebalanceListener)new BaseConsumerTest.TestConsumerReassignmentListener());
        ((KafkaConsumer)this.consumers().apply(0)).poll(50L);
        ObjectRef subscriptions = new ObjectRef((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(topic1, 0), new TopicPartition(topic1, 1)}))));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final ObjectRef subscriptions$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().apply(0)).poll(50L);
                java.util.Set set = ((KafkaConsumer)this.$outer.consumers().apply(0)).assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)this.subscriptions$1.elem)).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.subscriptions$1 = subscriptions$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)subscriptions.elem)).asJava(), ((KafkaConsumer)this.consumers().apply(0)).assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        String topic4 = "tsomec";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic4, 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.sendRecords(1000, new TopicPartition(topic4, 0));
        this.sendRecords(1000, new TopicPartition(topic4, 1));
        subscriptions.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)subscriptions.elem).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic4, 0), new TopicPartition(topic4, 1)})));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final ObjectRef subscriptions$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().apply(0)).poll(50L);
                java.util.Set set = ((KafkaConsumer)this.$outer.consumers().apply(0)).assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)this.subscriptions$1.elem)).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.subscriptions$1 = subscriptions$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)subscriptions.elem)).asJava(), ((KafkaConsumer)this.consumers().apply(0)).assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        ((KafkaConsumer)this.consumers().apply(0)).unsubscribe();
        Assert.assertEquals((long)0L, (long)((KafkaConsumer)this.consumers().apply(0)).assignment().size());
    }

    @Test
    public void testPatternUnsubscription() {
        int numRecords = 10000;
        this.sendRecords(numRecords);
        String topic1 = "tblablac";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic1, 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.sendRecords(1000, new TopicPartition(topic1, 0));
        this.sendRecords(1000, new TopicPartition(topic1, 1));
        Assert.assertEquals((long)0L, (long)((KafkaConsumer)this.consumers().apply(0)).assignment().size());
        ((KafkaConsumer)this.consumers().apply(0)).subscribe(Pattern.compile("t.*c"), (ConsumerRebalanceListener)new BaseConsumerTest.TestConsumerReassignmentListener());
        ((KafkaConsumer)this.consumers().apply(0)).poll(50L);
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(topic1, 0), new TopicPartition(topic1, 1)}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final scala.collection.immutable.Set subscriptions$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().apply(0)).poll(50L);
                java.util.Set set = ((KafkaConsumer)this.$outer.consumers().apply(0)).assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.subscriptions$2).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.subscriptions$2 = subscriptions$2;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava(), ((KafkaConsumer)this.consumers().apply(0)).assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        ((KafkaConsumer)this.consumers().apply(0)).unsubscribe();
        Assert.assertEquals((long)0L, (long)((KafkaConsumer)this.consumers().apply(0)).assignment().size());
    }

    @Test
    public void testCommitMetadata() {
        ((KafkaConsumer)this.consumers().apply(0)).assign((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        OffsetAndMetadata syncMetadata = new OffsetAndMetadata(5L, "foo");
        ((KafkaConsumer)this.consumers().apply(0)).commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)syncMetadata)}))).asJava());
        Assert.assertEquals((Object)syncMetadata, (Object)((KafkaConsumer)this.consumers().apply(0)).committed(this.tp()));
        OffsetAndMetadata asyncMetadata = new OffsetAndMetadata(10L, "bar");
        BaseConsumerTest.CountConsumerCommitCallback callback = new BaseConsumerTest.CountConsumerCommitCallback();
        ((KafkaConsumer)this.consumers().apply(0)).commitAsync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)asyncMetadata)}))).asJava(), (OffsetCommitCallback)callback);
        this.awaitCommitCallback((Consumer<byte[], byte[]>)((Consumer)this.consumers().apply(0)), callback);
        Assert.assertEquals((Object)asyncMetadata, (Object)((KafkaConsumer)this.consumers().apply(0)).committed(this.tp()));
    }

    @Test
    public void testExpandingTopicSubscriptions() {
        String otherTopic = "other";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)}));
        scala.collection.immutable.Set expandedSubscriptions = (scala.collection.immutable.Set)subscriptions.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(otherTopic, 0), new TopicPartition(otherTopic, 1)})));
        ((KafkaConsumer)this.consumers().apply(0)).subscribe((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final scala.collection.immutable.Set subscriptions$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().apply(0)).poll(50L);
                java.util.Set set = ((KafkaConsumer)this.$outer.consumers().apply(0)).assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.subscriptions$3).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.subscriptions$3 = subscriptions$3;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava(), ((KafkaConsumer)this.consumers().apply(0)).assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), otherTopic, 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        ((KafkaConsumer)this.consumers().apply(0)).subscribe((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), otherTopic}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, expandedSubscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final scala.collection.immutable.Set expandedSubscriptions$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().apply(0)).poll(50L);
                java.util.Set set = ((KafkaConsumer)this.$outer.consumers().apply(0)).assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.expandedSubscriptions$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.expandedSubscriptions$1 = expandedSubscriptions$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)expandedSubscriptions).asJava(), ((KafkaConsumer)this.consumers().apply(0)).assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
    }

    @Test
    public void testShrinkingTopicSubscriptions() {
        String otherTopic = "other";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), otherTopic, 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(otherTopic, 0), new TopicPartition(otherTopic, 1)}));
        scala.collection.immutable.Set shrunkenSubscriptions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)}));
        ((KafkaConsumer)this.consumers().apply(0)).subscribe((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), otherTopic}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final scala.collection.immutable.Set subscriptions$4;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().apply(0)).poll(50L);
                java.util.Set set = ((KafkaConsumer)this.$outer.consumers().apply(0)).assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.subscriptions$4).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.subscriptions$4 = subscriptions$4;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava(), ((KafkaConsumer)this.consumers().apply(0)).assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        ((KafkaConsumer)this.consumers().apply(0)).subscribe((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, shrunkenSubscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final scala.collection.immutable.Set shrunkenSubscriptions$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().apply(0)).poll(50L);
                java.util.Set set = ((KafkaConsumer)this.$outer.consumers().apply(0)).assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.shrunkenSubscriptions$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.shrunkenSubscriptions$1 = shrunkenSubscriptions$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)shrunkenSubscriptions).asJava(), ((KafkaConsumer)this.consumers().apply(0)).assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
    }

    @Test
    public void testPartitionsFor() {
        int numParts = 2;
        TestUtils$.MODULE$.createTopic(this.zkUtils(), "part-test", numParts, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        java.util.List parts = ((KafkaConsumer)this.consumers().apply(0)).partitionsFor("part-test");
        Assert.assertNotNull((Object)parts);
        Assert.assertEquals((long)2L, (long)parts.size());
        Assert.assertNull((Object)((KafkaConsumer)this.consumers().apply(0)).partitionsFor("non-exist-topic"));
    }

    @Test
    public void testSeek() {
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().apply(0);
        long totalRecords = 50L;
        this.sendRecords((int)totalRecords);
        consumer.assign((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        consumer.seekToEnd(new TopicPartition[]{this.tp()});
        Assert.assertEquals((long)totalRecords, (long)consumer.position(this.tp()));
        Assert.assertFalse((boolean)consumer.poll(totalRecords).iterator().hasNext());
        consumer.seekToBeginning(new TopicPartition[]{this.tp()});
        Assert.assertEquals((float)0.0f, (float)consumer.position(this.tp()), (float)0.0f);
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, 0, this.consumeAndVerifyRecords$default$4());
        long mid = totalRecords / 2L;
        consumer.seek(this.tp(), mid);
        Assert.assertEquals((long)mid, (long)consumer.position(this.tp()));
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, (int)mid, (int)mid);
    }

    public void testPositionAndCommit() {
        this.sendRecords(5);
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public final OffsetAndMetadata apply() {
                return ((KafkaConsumer)this.$outer.consumers().apply(0)).committed(new TopicPartition(this.$outer.topic(), 15));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ManifestFactory$.MODULE$.classType(NoOffsetForPartitionException.class));
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return ((KafkaConsumer)this.$outer.consumers().apply(0)).position(new TopicPartition(this.$outer.topic(), 15));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
        ((KafkaConsumer)this.consumers().apply(0)).assign((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assert.assertEquals((String)"position() on a partition that we are subscribed to should reset the offset", (long)0L, (long)((KafkaConsumer)this.consumers().apply(0)).position(this.tp()));
        ((KafkaConsumer)this.consumers().apply(0)).commitSync();
        Assert.assertEquals((long)0L, (long)((KafkaConsumer)this.consumers().apply(0)).committed(this.tp()).offset());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().apply(0)), 5, 0, this.consumeAndVerifyRecords$default$4());
        Assert.assertEquals((String)"After consuming 5 records, position should be 5", (long)5L, (long)((KafkaConsumer)this.consumers().apply(0)).position(this.tp()));
        ((KafkaConsumer)this.consumers().apply(0)).commitSync();
        Assert.assertEquals((String)"Committed offset should be returned", (long)5L, (long)((KafkaConsumer)this.consumers().apply(0)).committed(this.tp()).offset());
        this.sendRecords(1);
        ((KafkaConsumer)this.consumers().apply(1)).assign((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().apply(1)), 1, 5, this.consumeAndVerifyRecords$default$4());
    }

    @Test
    public void testPartitionPauseAndResume() {
        this.sendRecords(5);
        ((KafkaConsumer)this.consumers().apply(0)).assign((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().apply(0)), 5, 0, this.consumeAndVerifyRecords$default$4());
        ((KafkaConsumer)this.consumers().apply(0)).pause(new TopicPartition[]{this.tp()});
        this.sendRecords(5);
        Assert.assertTrue((boolean)((KafkaConsumer)this.consumers().apply(0)).poll(0L).isEmpty());
        ((KafkaConsumer)this.consumers().apply(0)).resume(new TopicPartition[]{this.tp()});
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().apply(0)), 5, 5, this.consumeAndVerifyRecords$default$4());
    }

    @Test
    public void testFetchInvalidOffset() {
        this.consumerConfig().setProperty("auto.offset.reset", "none");
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        int totalRecords = 2;
        this.sendRecords(totalRecords, this.tp());
        consumer0.assign((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.intercept((Function0)new Serializable(this, consumer0){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$3;

            public final ConsumerRecords<byte[], byte[]> apply() {
                return this.consumer0$3.poll(50L);
            }
            {
                this.consumer0$3 = consumer0$3;
            }
        }, ManifestFactory$.MODULE$.classType(NoOffsetForPartitionException.class));
        int outOfRangePos = totalRecords + 1;
        consumer0.seek(this.tp(), (long)outOfRangePos);
        OffsetOutOfRangeException e = (OffsetOutOfRangeException)this.intercept((Function0)new Serializable(this, consumer0){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$3;

            public final ConsumerRecords<byte[], byte[]> apply() {
                return this.consumer0$3.poll(20000L);
            }
            {
                this.consumer0$3 = consumer0$3;
            }
        }, ManifestFactory$.MODULE$.classType(OffsetOutOfRangeException.class));
        java.util.Map outOfRangePartitions = e.offsetOutOfRangePartitions();
        Assert.assertNotNull((Object)outOfRangePartitions);
        Assert.assertEquals((long)1L, (long)outOfRangePartitions.size());
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)outOfRangePos), outOfRangePartitions.get(this.tp()));
        consumer0.close();
    }

    @Test
    public void testFetchRecordTooLarge() {
        int maxFetchBytes = 10240;
        this.consumerConfig().setProperty("max.partition.fetch.bytes", ((Object)BoxesRunTime.boxToInteger((int)maxFetchBytes)).toString());
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"key".getBytes(), (Object)new byte[maxFetchBytes + 1]);
        ((KafkaProducer)this.producers().apply(0)).send(record);
        consumer0.assign((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        RecordTooLargeException e = (RecordTooLargeException)this.intercept((Function0)new Serializable(this, consumer0){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$4;

            public final ConsumerRecords<byte[], byte[]> apply() {
                return this.consumer0$4.poll(20000L);
            }
            {
                this.consumer0$4 = consumer0$4;
            }
        }, ManifestFactory$.MODULE$.classType(RecordTooLargeException.class));
        java.util.Map oversizedPartitions = e.recordTooLargePartitions();
        Assert.assertNotNull((Object)oversizedPartitions);
        Assert.assertEquals((long)1L, (long)oversizedPartitions.size());
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), oversizedPartitions.get(this.tp()));
        consumer0.close();
    }

    @Test
    public void testRoundRobinAssignment() {
        this.consumerConfig().setProperty("group.id", "roundrobin-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", RoundRobinAssignor.class.getName());
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        String topic1 = "topic1";
        String topic2 = "topic2";
        scala.collection.immutable.Set expectedAssignment = (scala.collection.immutable.Set)this.createTopicAndSendRecords(topic1, 2, 100).$plus$plus(this.createTopicAndSendRecords(topic2, 2, 100));
        Assert.assertEquals((long)0L, (long)consumer0.assignment().size());
        consumer0.subscribe((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, expectedAssignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$5;
            private final scala.collection.immutable.Set expectedAssignment$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer0$5.poll(50L);
                java.util.Set set = this.consumer0$5.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.expectedAssignment$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$5 = consumer0$5;
                this.expectedAssignment$1 = expectedAssignment$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)expectedAssignment).asJava(), consumer0.assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        String topic3 = "topic3";
        this.createTopicAndSendRecords(topic3, 2, 100);
        scala.collection.immutable.Set newExpectedAssignment = (scala.collection.immutable.Set)expectedAssignment.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic3, 0), new TopicPartition(topic3, 1)})));
        consumer0.subscribe((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2, topic3}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, newExpectedAssignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$5;
            private final scala.collection.immutable.Set newExpectedAssignment$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer0$5.poll(50L);
                java.util.Set set = this.consumer0$5.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.newExpectedAssignment$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$5 = consumer0$5;
                this.newExpectedAssignment$1 = newExpectedAssignment$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)newExpectedAssignment).asJava(), consumer0.assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        consumer0.subscribe((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, expectedAssignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$5;
            private final scala.collection.immutable.Set expectedAssignment$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer0$5.poll(50L);
                java.util.Set set = this.consumer0$5.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.expectedAssignment$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$5 = consumer0$5;
                this.expectedAssignment$1 = expectedAssignment$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)expectedAssignment).asJava(), consumer0.assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        consumer0.unsubscribe();
        Assert.assertEquals((long)0L, (long)consumer0.assignment().size());
    }

    @Test
    public void testMultiConsumerRoundRobinAssignment() {
        this.consumerConfig().setProperty("group.id", "roundrobin-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", RoundRobinAssignor.class.getName());
        String topic1 = "topic1";
        String topic2 = "topic2";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)this.createTopicAndSendRecords(topic1, 5, 100).$plus$plus(this.createTopicAndSendRecords(topic2, 8, 100));
        Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<BaseConsumerTest.ConsumerAssignmentPoller>> tuple2 = this.createConsumerGroupAndWaitForAssignment(10, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2})), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Buffer rrConsumers = (Buffer)tuple2._1();
            Buffer consumerPollers = (Buffer)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)rrConsumers, (Object)consumerPollers);
            Buffer rrConsumers2 = (Buffer)tuple23._1();
            Buffer consumerPollers2 = (Buffer)tuple23._2();
            this.addConsumersToGroupAndWaitForGroupAssignment(1, (Buffer<KafkaConsumer<byte[], byte[]>>)rrConsumers2, (Buffer<BaseConsumerTest.ConsumerAssignmentPoller>)consumerPollers2, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2})), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
            consumerPollers2.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(BaseConsumerTest.ConsumerAssignmentPoller poller) {
                    poller.shutdown();
                }
            });
            rrConsumers2.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(KafkaConsumer<byte[], byte[]> consumer) {
                    consumer.unsubscribe();
                }
            });
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testMultiConsumerDefaultAssignment() {
        this.sendRecords(100, this.tp());
        this.sendRecords(100, this.tp2());
        String topic1 = "topic1";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).$plus$plus(this.createTopicAndSendRecords(topic1, 5, 100));
        Buffer<BaseConsumerTest.ConsumerAssignmentPoller> consumerPollers = this.subscribeConsumersAndWaitForAssignment(this.consumers(), (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1})), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        this.addConsumersToGroupAndWaitForGroupAssignment(2, this.consumers(), consumerPollers, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1})), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        String topic2 = "topic2";
        scala.collection.immutable.Set expandedSubscriptions = (scala.collection.immutable.Set)subscriptions.$plus$plus(this.createTopicAndSendRecords(topic2, 3, 100));
        this.changeConsumerGroupSubscriptionAndValidateAssignment(consumerPollers, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1, topic2})), (scala.collection.immutable.Set<TopicPartition>)expandedSubscriptions);
        this.changeConsumerGroupSubscriptionAndValidateAssignment(consumerPollers, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1})), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        consumerPollers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(BaseConsumerTest.ConsumerAssignmentPoller poller) {
                poller.shutdown();
            }
        });
        this.consumers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaConsumer<byte[], byte[]> consumer) {
                consumer.unsubscribe();
            }
        });
    }

    @Test
    public void testMultiConsumerSessionTimeoutOnStopPolling() {
        this.runMultiConsumerSessionTimeoutTest(false);
    }

    @Test
    public void testMultiConsumerSessionTimeoutOnClose() {
        this.runMultiConsumerSessionTimeoutTest(true);
    }

    public void runMultiConsumerSessionTimeoutTest(boolean closeConsumer) {
        this.sendRecords(100, this.tp());
        this.sendRecords(100, this.tp2());
        String topic1 = "topic1";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).$plus$plus(this.createTopicAndSendRecords(topic1, 6, 100));
        Buffer consumerPollers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.consumers().foreach((Function1)new Serializable(this, topic1, consumerPollers){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final String topic1$1;
            private final Buffer consumerPollers$3;

            public final Buffer<BaseConsumerTest.ConsumerAssignmentPoller> apply(KafkaConsumer<byte[], byte[]> consumer) {
                return this.consumerPollers$3.$plus$eq((Object)((Object)this.$outer.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.topic(), this.topic1$1})))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topic1$1 = topic1$1;
                this.consumerPollers$3 = consumerPollers$3;
            }
        });
        KafkaConsumer timeoutConsumer = new KafkaConsumer(this.consumerConfig());
        Buffer expandedConsumers = this.consumers().$plus$plus((GenTraversableOnce)Buffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[]{timeoutConsumer})));
        BaseConsumerTest.ConsumerAssignmentPoller timeoutPoller = this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)timeoutConsumer, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1})));
        Buffer expandedPollers = consumerPollers.$plus$plus((GenTraversableOnce)Buffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BaseConsumerTest.ConsumerAssignmentPoller[]{timeoutPoller})));
        this.validateGroupAssignment((Buffer<BaseConsumerTest.ConsumerAssignmentPoller>)expandedPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid initial assignment for partitions ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava()})), this.validateGroupAssignment$default$4());
        timeoutPoller.shutdown();
        if (closeConsumer) {
            timeoutConsumer.close();
        }
        long maxSessionTimeout = new StringOps(Predef$.MODULE$.augmentString(this.serverConfig().getProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp()))).toLong();
        this.validateGroupAssignment((Buffer<BaseConsumerTest.ConsumerAssignmentPoller>)consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid assignment for partitions ", " after one consumer left"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava()})), 3L * maxSessionTimeout);
        consumerPollers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(BaseConsumerTest.ConsumerAssignmentPoller poller) {
                poller.shutdown();
            }
        });
    }

    public scala.collection.immutable.Set<TopicPartition> createTopicAndSendRecords(String topicName, int numPartitions, int recordsPerPartition) {
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topicName, numPartitions, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        ObjectRef parts = new ObjectRef((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)new Serializable(this, topicName, recordsPerPartition, parts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final String topicName$1;
            private final int recordsPerPartition$1;
            private final ObjectRef parts$1;

            public final void apply(int partition) {
                this.apply$mcVI$sp(partition);
            }

            public void apply$mcVI$sp(int partition) {
                TopicPartition tp = new TopicPartition(this.topicName$1, partition);
                this.$outer.sendRecords(this.recordsPerPartition$1, tp);
                this.parts$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)this.parts$1.elem).$plus((Object)tp);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topicName$1 = topicName$1;
                this.recordsPerPartition$1 = recordsPerPartition$1;
                this.parts$1 = parts$1;
            }
        });
        return (scala.collection.immutable.Set)parts.elem;
    }

    /*
     * WARNING - void declaration
     */
    public BaseConsumerTest.ConsumerAssignmentPoller subscribeConsumerAndStartPolling(Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe) {
        void var3_3;
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
        BaseConsumerTest.ConsumerAssignmentPoller consumerPoller = new BaseConsumerTest.ConsumerAssignmentPoller(this, consumer, topicsToSubscribe);
        consumerPoller.start();
        return var3_3;
    }

    public Buffer<BaseConsumerTest.ConsumerAssignmentPoller> subscribeConsumersAndWaitForAssignment(Buffer<KafkaConsumer<byte[], byte[]>> consumerGroup, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions) {
        Buffer consumerPollers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        consumerGroup.foreach((Function1)new Serializable(this, topicsToSubscribe, consumerPollers){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final List topicsToSubscribe$2;
            private final Buffer consumerPollers$5;

            public final Buffer<BaseConsumerTest.ConsumerAssignmentPoller> apply(KafkaConsumer<byte[], byte[]> consumer) {
                return this.consumerPollers$5.$plus$eq((Object)((Object)this.$outer.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, (List<String>)this.topicsToSubscribe$2)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topicsToSubscribe$2 = topicsToSubscribe$2;
                this.consumerPollers$5 = consumerPollers$5;
            }
        });
        this.validateGroupAssignment((Buffer<BaseConsumerTest.ConsumerAssignmentPoller>)consumerPollers, subscriptions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid initial assignment for partitions ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter(subscriptions).asJava()})), this.validateGroupAssignment$default$4());
        return consumerPollers;
    }

    public Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<BaseConsumerTest.ConsumerAssignmentPoller>> createConsumerGroupAndWaitForAssignment(int consumerCount, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions) {
        Assert.assertTrue((consumerCount <= subscriptions.size() ? 1 : 0) != 0);
        Buffer consumerGroup = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), consumerCount).foreach((Function1)new Serializable(this, consumerGroup){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final Buffer consumerGroup$2;

            public final Buffer<KafkaConsumer<byte[], byte[]>> apply(int i) {
                return this.consumerGroup$2.$plus$eq((Object)new KafkaConsumer(this.$outer.consumerConfig()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.consumerGroup$2 = consumerGroup$2;
            }
        });
        Buffer<BaseConsumerTest.ConsumerAssignmentPoller> consumerPollers = this.subscribeConsumersAndWaitForAssignment((Buffer<KafkaConsumer<byte[], byte[]>>)consumerGroup, topicsToSubscribe, subscriptions);
        return new Tuple2((Object)consumerGroup, consumerPollers);
    }

    public void addConsumersToGroupAndWaitForGroupAssignment(int numOfConsumersToAdd, Buffer<KafkaConsumer<byte[], byte[]>> consumerGroup, Buffer<BaseConsumerTest.ConsumerAssignmentPoller> consumerPollers, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions) {
        Assert.assertTrue((consumerGroup.size() + numOfConsumersToAdd <= subscriptions.size() ? 1 : 0) != 0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numOfConsumersToAdd).foreach((Function1)new Serializable(this, consumerGroup, consumerPollers, topicsToSubscribe){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final Buffer consumerGroup$1;
            private final Buffer consumerPollers$1;
            private final List topicsToSubscribe$1;

            public final Buffer<BaseConsumerTest.ConsumerAssignmentPoller> apply(int i) {
                KafkaConsumer newConsumer = new KafkaConsumer(this.$outer.consumerConfig());
                this.consumerGroup$1.$plus$eq((Object)newConsumer);
                return this.consumerPollers$1.$plus$eq((Object)((Object)this.$outer.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)newConsumer, (List<String>)this.topicsToSubscribe$1)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.consumerGroup$1 = consumerGroup$1;
                this.consumerPollers$1 = consumerPollers$1;
                this.topicsToSubscribe$1 = topicsToSubscribe$1;
            }
        });
        this.validateGroupAssignment(consumerPollers, subscriptions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid assignment for partitions ", " after we added ", " consumer(s)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter(subscriptions).asJava(), BoxesRunTime.boxToInteger((int)numOfConsumersToAdd)})), this.validateGroupAssignment$default$4());
    }

    public void validateGroupAssignment(Buffer<BaseConsumerTest.ConsumerAssignmentPoller> consumerPollers, scala.collection.immutable.Set<TopicPartition> subscriptions, String msg, long waitTime) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumerPollers, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final Buffer consumerPollers$4;
            private final scala.collection.immutable.Set subscriptions$5;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Buffer assignments = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                this.consumerPollers$4.foreach((Function1)new Serializable(this, assignments){
                    public static final long serialVersionUID = 0L;
                    private final Buffer assignments$1;

                    public final Buffer<scala.collection.immutable.Set<TopicPartition>> apply(BaseConsumerTest.ConsumerAssignmentPoller x$2) {
                        return this.assignments$1.$plus$eq(x$2.consumerAssignment());
                    }
                    {
                        this.assignments$1 = assignments$1;
                    }
                });
                return this.$outer.isPartitionAssignmentValid((Buffer<scala.collection.immutable.Set<TopicPartition>>)assignments, (scala.collection.immutable.Set<TopicPartition>)this.subscriptions$5);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.consumerPollers$4 = consumerPollers$4;
                this.subscriptions$5 = subscriptions$5;
            }
        }, msg, waitTime);
    }

    public long validateGroupAssignment$default$4() {
        return 10000L;
    }

    public void changeConsumerGroupSubscriptionAndValidateAssignment(Buffer<BaseConsumerTest.ConsumerAssignmentPoller> consumerPollers, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions) {
        consumerPollers.foreach((Function1)new Serializable(this, topicsToSubscribe){
            public static final long serialVersionUID = 0L;
            private final List topicsToSubscribe$3;

            public final void apply(BaseConsumerTest.ConsumerAssignmentPoller poller) {
                poller.subscribe((List<String>)this.topicsToSubscribe$3);
            }
            {
                this.topicsToSubscribe$3 = topicsToSubscribe$3;
            }
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumerPollers){
            public static final long serialVersionUID = 0L;
            private final Buffer consumerPollers$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.consumerPollers$2.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(BaseConsumerTest.ConsumerAssignmentPoller poller) {
                        return poller.isSubscribeRequestProcessed();
                    }
                });
            }
            {
                this.consumerPollers$2 = consumerPollers$2;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to call subscribe on all consumers in the group for subscription ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{subscriptions})), 1000L);
        this.validateGroupAssignment(consumerPollers, subscriptions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid assignment for partitions ", " after we changed subscription"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter(subscriptions).asJava()})), this.validateGroupAssignment$default$4());
    }
}

