/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.nio.ByteBuffer;
import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.BrokerEndPoint$;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.log4j.Logger;
import org.junit.Test;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001]2A!\u0001\u0002\u0001\u000f\t\u0011\"I]8lKJ,e\u000e\u001a)pS:$H+Z:u\u0015\t\u0019A!A\u0004dYV\u001cH/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u000bU\u0001A\u0011\u0001\f\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0011\u0001\"\u0002\u000e\u0001\t\u0003Y\u0012!\u0003;fgR\u001cVM\u001d#f)\u0005a\u0002CA\u0005\u001e\u0013\tq\"B\u0001\u0003V]&$\bFA\r!!\t\tc%D\u0001#\u0015\t\u0019C%A\u0003kk:LGOC\u0001&\u0003\ry'oZ\u0005\u0003O\t\u0012A\u0001V3ti\")\u0011\u0006\u0001C\u00017\u0005\tB/Z:u\u0011\u0006\u001c\b.\u00118e\u000bF,\u0018\r\\:)\u0005!\u0002\u0003\"\u0002\u0017\u0001\t\u0003Y\u0012\u0001\u0004;fgR4%o\\7K'>s\u0005FA\u0016!\u0011\u0015y\u0003\u0001\"\u0001\u001c\u0003=!Xm\u001d;Ge>lw\n\u001c3K'>s\u0005F\u0001\u0018!\u0011\u0015\u0011\u0004\u0001\"\u0001\u001c\u0003e!Xm\u001d;Ce>\\WM]#oIB|\u0017N\u001c;Ge>lWKU%)\u0005E\u0002\u0003\"B\u001b\u0001\t\u0003Y\u0012a\u0005;fgR,e\u000e\u001a9pS:$hI]8n+JK\u0005F\u0001\u001b!\u0001")
public class BrokerEndPointTest
implements Logging {
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        BrokerEndPointTest brokerEndPointTest = this;
        synchronized (brokerEndPointTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    @Test
    public void testSerDe() {
        EndPoint endpoint = new EndPoint("myhost", 9092, SecurityProtocol.PLAINTEXT);
        Map listEndPoints = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)SecurityProtocol.PLAINTEXT), (Object)endpoint)}));
        Broker origBroker = new Broker(1, listEndPoints);
        ByteBuffer brokerBytes = ByteBuffer.allocate(origBroker.sizeInBytes());
        origBroker.writeTo(brokerBytes);
        Broker newBroker = Broker$.MODULE$.readFrom((ByteBuffer)brokerBytes.flip());
        Broker broker = origBroker;
        Broker broker2 = newBroker;
        Predef$.MODULE$.assert(!(broker != null ? !broker.equals(broker2) : broker2 != null));
    }

    @Test
    public void testHashAndEquals() {
        EndPoint endpoint1 = new EndPoint("myhost", 9092, SecurityProtocol.PLAINTEXT);
        EndPoint endpoint2 = new EndPoint("myhost", 9092, SecurityProtocol.PLAINTEXT);
        EndPoint endpoint3 = new EndPoint("myhost", 1111, SecurityProtocol.PLAINTEXT);
        EndPoint endpoint4 = new EndPoint("other", 1111, SecurityProtocol.PLAINTEXT);
        Broker broker1 = new Broker(1, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)SecurityProtocol.PLAINTEXT), (Object)endpoint1)})));
        Broker broker2 = new Broker(1, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)SecurityProtocol.PLAINTEXT), (Object)endpoint2)})));
        Broker broker3 = new Broker(2, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)SecurityProtocol.PLAINTEXT), (Object)endpoint3)})));
        Broker broker4 = new Broker(1, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)SecurityProtocol.PLAINTEXT), (Object)endpoint4)})));
        Broker broker = broker1;
        Broker broker5 = broker2;
        Predef$.MODULE$.assert(!(broker != null ? !broker.equals(broker5) : broker5 != null));
        Broker broker6 = broker1;
        Broker broker7 = broker3;
        Predef$.MODULE$.assert(broker6 != null ? !broker6.equals(broker7) : broker7 != null);
        Broker broker8 = broker1;
        Broker broker9 = broker4;
        Predef$.MODULE$.assert(broker8 != null ? !broker8.equals(broker9) : broker9 != null);
        Predef$.MODULE$.assert(broker1.hashCode() == broker2.hashCode());
        Predef$.MODULE$.assert(broker1.hashCode() != broker3.hashCode());
        Predef$.MODULE$.assert(broker1.hashCode() != broker4.hashCode());
        HashMap hashmap = new HashMap();
        hashmap.put((Object)broker1, (Object)BoxesRunTime.boxToInteger((int)1));
        Predef$.MODULE$.assert(BoxesRunTime.unboxToInt((Object)hashmap.getOrElse((Object)broker1, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })) == 1);
    }

    @Test
    public void testFromJSON() {
        String brokerInfoStr = "{\"version\":2,\"host\":\"localhost\",\"port\":9092,\"jmx_port\":9999,\"timestamp\":\"1416974968782\",\"endpoints\":[\"PLAINTEXT://localhost:9092\"]}";
        Broker broker = Broker$.MODULE$.createBroker(1, brokerInfoStr);
        Predef$.MODULE$.assert(broker.id() == 1);
        String string = broker.getBrokerEndPoint(SecurityProtocol.PLAINTEXT).host();
        String string2 = "localhost";
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null));
        Predef$.MODULE$.assert(broker.getBrokerEndPoint(SecurityProtocol.PLAINTEXT).port() == 9092);
    }

    @Test
    public void testFromOldJSON() {
        String brokerInfoStr = "{\"jmx_port\":-1,\"timestamp\":\"1420485325400\",\"host\":\"172.16.8.243\",\"version\":1,\"port\":9091}";
        Broker broker = Broker$.MODULE$.createBroker(1, brokerInfoStr);
        Predef$.MODULE$.assert(broker.id() == 1);
        String string = broker.getBrokerEndPoint(SecurityProtocol.PLAINTEXT).host();
        String string2 = "172.16.8.243";
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null));
        Predef$.MODULE$.assert(broker.getBrokerEndPoint(SecurityProtocol.PLAINTEXT).port() == 9091);
    }

    @Test
    public void testBrokerEndpointFromURI() {
        String connectionString = "localhost:9092";
        BrokerEndPoint endpoint = BrokerEndPoint$.MODULE$.createBrokerEndPoint(1, connectionString);
        String string = endpoint.host();
        String string2 = "localhost";
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null));
        Predef$.MODULE$.assert(endpoint.port() == 9092);
        connectionString = "[::1]:9092";
        endpoint = BrokerEndPoint$.MODULE$.createBrokerEndPoint(1, connectionString);
        String string3 = endpoint.host();
        String string4 = "::1";
        Predef$.MODULE$.assert(!(string3 != null ? !string3.equals(string4) : string4 != null));
        Predef$.MODULE$.assert(endpoint.port() == 9092);
        connectionString = "MyHostname:9092";
        endpoint = BrokerEndPoint$.MODULE$.createBrokerEndPoint(1, connectionString);
        String string5 = endpoint.host();
        String string6 = "MyHostname";
        Predef$.MODULE$.assert(!(string5 != null ? !string5.equals(string6) : string6 != null));
        Predef$.MODULE$.assert(endpoint.port() == 9092);
    }

    @Test
    public void testEndpointFromURI() {
        String connectionString = "PLAINTEXT://localhost:9092";
        EndPoint endpoint = EndPoint$.MODULE$.createEndPoint(connectionString);
        String string = endpoint.host();
        String string2 = "localhost";
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null));
        Predef$.MODULE$.assert(endpoint.port() == 9092);
        String string3 = endpoint.connectionString();
        String string4 = "PLAINTEXT://localhost:9092";
        Predef$.MODULE$.assert(!(string3 != null ? !string3.equals(string4) : string4 != null));
        connectionString = "PLAINTEXT://:9092";
        endpoint = EndPoint$.MODULE$.createEndPoint(connectionString);
        Predef$.MODULE$.assert(endpoint.host() == null);
        Predef$.MODULE$.assert(endpoint.port() == 9092);
        String string5 = endpoint.connectionString();
        String string6 = "PLAINTEXT://:9092";
        Predef$.MODULE$.assert(!(string5 != null ? !string5.equals(string6) : string6 != null));
        connectionString = "PLAINTEXT://[::1]:9092";
        endpoint = EndPoint$.MODULE$.createEndPoint(connectionString);
        String string7 = endpoint.host();
        String string8 = "::1";
        Predef$.MODULE$.assert(!(string7 != null ? !string7.equals(string8) : string8 != null));
        Predef$.MODULE$.assert(endpoint.port() == 9092);
        String string9 = endpoint.connectionString();
        String string10 = "PLAINTEXT://[::1]:9092";
        Predef$.MODULE$.assert(!(string9 != null ? !string9.equals(string10) : string10 != null));
        connectionString = "PLAINTEXT://MyHostname:9092";
        endpoint = EndPoint$.MODULE$.createEndPoint(connectionString);
        String string11 = endpoint.host();
        String string12 = "MyHostname";
        Predef$.MODULE$.assert(!(string11 != null ? !string11.equals(string12) : string12 != null));
        Predef$.MODULE$.assert(endpoint.port() == 9092);
        String string13 = endpoint.connectionString();
        String string14 = "PLAINTEXT://MyHostname:9092";
        Predef$.MODULE$.assert(!(string13 != null ? !string13.equals(string14) : string14 != null));
    }

    public BrokerEndPointTest() {
        Logging.class.$init$((Logging)this);
    }
}

