/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.LZ4CompressionCodec$;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.message.SnappyCompressionCodec$;
import net.jpountz.lz4.LZ4BlockOutputStream;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import org.xerial.snappy.SnappyError;
import org.xerial.snappy.SnappyOutputStream;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001U2A!\u0001\u0002\u0001\u000f\t1R*Z:tC\u001e,7i\\7qe\u0016\u001c8/[8o)\u0016\u001cHO\u0003\u0002\u0004\t\u00059Q.Z:tC\u001e,'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u0013Ai\u0011A\u0003\u0006\u0003\u00171\tQA[;oSRT!!\u0004\b\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\b\u0002\u0007=\u0014x-\u0003\u0002\u0012\u0015\tQ!*\u00168jiN+\u0018\u000e^3\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005\u0011\u0001\"\u0002\r\u0001\t\u0003I\u0012\u0001\b;fgR\u001c\u0016.\u001c9mK\u000e{W\u000e\u001d:fgN$UmY8naJ,7o\u001d\u000b\u00025A\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t!QK\\5uQ\t9\u0012\u0005\u0005\u0002#I5\t1E\u0003\u0002\f\u001d%\u0011Qe\t\u0002\u0005)\u0016\u001cH\u000fC\u0003\u0019\u0001\u0011\u0005q\u0005\u0006\u0002\u001bQ!)\u0011F\na\u0001U\u0005\u00012m\\7qe\u0016\u001c8/[8o\u0007>$Wm\u0019\t\u0003--J!\u0001\f\u0002\u0003!\r{W\u000e\u001d:fgNLwN\\\"pI\u0016\u001c\u0007\"\u0002\u0018\u0001\t\u0003y\u0013!E5t':\f\u0007\u000f]=Bm\u0006LG.\u00192mKR\t\u0001\u0007\u0005\u0002\u001cc%\u0011!\u0007\b\u0002\b\u0005>|G.Z1o\u0011\u0015!\u0004\u0001\"\u00010\u00039I7\u000f\u0014.5\u0003Z\f\u0017\u000e\\1cY\u0016\u0004")
public class MessageCompressionTest
extends JUnitSuite {
    @Test
    public void testSimpleCompressDecompress() {
        ArrayBuffer codecs = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CompressionCodec[]{GZIPCompressionCodec$.MODULE$}));
        Object object = this.isSnappyAvailable() ? codecs.$plus$eq((Object)SnappyCompressionCodec$.MODULE$) : BoxedUnit.UNIT;
        Object object2 = this.isLZ4Available() ? codecs.$plus$eq((Object)LZ4CompressionCodec$.MODULE$) : BoxedUnit.UNIT;
        codecs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MessageCompressionTest $outer;

            public final void apply(CompressionCodec codec) {
                this.$outer.testSimpleCompressDecompress(codec);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void testSimpleCompressDecompress(CompressionCodec compressionCodec) {
        List messages2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hi there".getBytes()), new Message("I am fine".getBytes()), new Message("I am not so well today".getBytes())}));
        ByteBufferMessageSet messageSet = new ByteBufferMessageSet(compressionCodec, (Seq)messages2);
        Assert.assertEquals((Object)compressionCodec, (Object)((MessageAndOffset)messageSet.shallowIterator().next()).message().compressionCodec());
        List decompressed = messageSet.iterator().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Message apply(MessageAndOffset x$1) {
                return x$1.message();
            }
        }).toList();
        Assert.assertEquals((Object)messages2, (Object)decompressed);
    }

    public boolean isSnappyAvailable() {
        boolean bl;
        try {
            SnappyOutputStream snappy = new SnappyOutputStream((OutputStream)new ByteArrayOutputStream());
            bl = true;
        }
        catch (SnappyError snappyError) {
            bl = false;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            bl = false;
        }
        return bl;
    }

    public boolean isLZ4Available() {
        boolean bl;
        try {
            LZ4BlockOutputStream lz4 = new LZ4BlockOutputStream((OutputStream)new ByteArrayOutputStream());
            bl = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            bl = false;
        }
        return bl;
    }
}

