/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import kafka.consumer.BaseConsumer;
import kafka.consumer.BaseConsumerRecord;
import kafka.tools.ConsoleConsumer;
import kafka.tools.ConsoleConsumer$;
import kafka.tools.MessageFormatter;
import kafka.utils.TestUtils$;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001E2A!\u0001\u0002\u0001\u0013\t\u00192i\u001c8t_2,7i\u001c8tk6,'\u000fV3ti*\u00111\u0001B\u0001\u0006i>|Gn\u001d\u0006\u0003\u000b\u0019\tQa[1gW\u0006T\u0011aB\u0001\u0005k:LGo\u0001\u0001\u0014\u0005\u0001Q\u0001CA\u0006\u0013\u001b\u0005a!BA\u0007\u000f\u0003\u0015QWO\\5u\u0015\ty\u0001#A\u0005tG\u0006d\u0017\r^3ti*\t\u0011#A\u0002pe\u001eL!a\u0005\u0007\u0003\u0015)+f.\u001b;Tk&$X\rC\u0003\u0016\u0001\u0011\u0005a#\u0001\u0004=S:LGO\u0010\u000b\u0002/A\u0011\u0001\u0004A\u0007\u0002\u0005!)!\u0004\u0001C\u00017\u0005\t3\u000f[8vY\u0012d\u0015.\\5u%\u0016\fGm\u001d+p\u001b\u0006DX*Z:tC\u001e,G*[7jiR\tA\u0004\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcD\u0001\u0003V]&$\bFA\r$!\t!c%D\u0001&\u0015\ti\u0001#\u0003\u0002(K\t!A+Z:u\u0011\u0015I\u0003\u0001\"\u0001\u001c\u0003\u0019\u001a\bn\\;mIB\u000b'o]3WC2LGm\u00147e\u0007>t7/^7feZ\u000bG.\u001b3D_:4\u0017n\u001a\u0015\u0003Q\rBQ\u0001\f\u0001\u0005\u0002m\tae\u001d5pk2$\u0007+\u0019:tKZ\u000bG.\u001b3OK^\u001cuN\\:v[\u0016\u0014h+\u00197jI\u000e{gNZ5hQ\tY3\u0005C\u00030\u0001\u0011\u00051$\u0001\u000etQ>,H\u000e\u001a)beN,7i\u001c8gS\u001e\u001chI]8n\r&dW\r\u000b\u0002/G\u0001")
public class ConsoleConsumerTest
extends JUnitSuite {
    @Test
    public void shouldLimitReadsToMaxMessageLimit() {
        BaseConsumer consumer = (BaseConsumer)EasyMock.createNiceMock(BaseConsumer.class);
        MessageFormatter formatter = (MessageFormatter)EasyMock.createNiceMock(MessageFormatter.class);
        BaseConsumerRecord record = new BaseConsumerRecord("foo", 1, 1L, (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()), (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()));
        int messageLimit = 10;
        formatter.writeTo((byte[])EasyMock.anyObject(), (byte[])EasyMock.anyObject(), (PrintStream)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).times(messageLimit);
        EasyMock.expect((Object)consumer.receive()).andReturn((Object)record).times(messageLimit);
        EasyMock.replay((Object[])new Object[]{consumer});
        EasyMock.replay((Object[])new Object[]{formatter});
        ConsoleConsumer$.MODULE$.process(Predef$.MODULE$.int2Integer(messageLimit), formatter, consumer, true);
    }

    @Test
    public void shouldParseValidOldConsumerValidConfig() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:2181", "--topic", "test", "--from-beginning"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertFalse((boolean)config.useNewConsumer());
        Assert.assertEquals((Object)"localhost:2181", (Object)config.zkConnectionStr());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
    }

    @Test
    public void shouldParseValidNewConsumerValidConfig() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--from-beginning", "--new-consumer"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertTrue((boolean)config.useNewConsumer());
        Assert.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
    }

    @Test
    public void shouldParseConfigsFromFile() {
        File propsFile = TestUtils$.MODULE$.tempFile();
        FileOutputStream propsStream = new FileOutputStream(propsFile);
        propsStream.write("consumer.timeout.ms=1000".getBytes());
        propsStream.close();
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:2181", "--topic", "test", "--consumer.config", propsFile.getAbsolutePath()});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertEquals((Object)"1000", (Object)config.consumerProps().getProperty("consumer.timeout.ms"));
    }
}

