/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.nio.ByteBuffer;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.common.BrokerNotAvailableException;
import kafka.common.KafkaException;
import kafka.utils.Json$;
import org.apache.kafka.common.protocol.SecurityProtocol;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Integral;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;

public final class Broker$
implements Serializable {
    public static final Broker$ MODULE$;

    static {
        new Broker$();
    }

    public Broker createBroker(int id, String brokerInfoString) {
        if (brokerInfoString == null) {
            throw new BrokerNotAvailableException(new StringOps(Predef$.MODULE$.augmentString("Broker id %s does not exist")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id)})));
        }
        try {
            Option<Object> option = Json$.MODULE$.parseFull(brokerInfoString);
            if (option instanceof Some) {
                Map map;
                int version;
                Some some = (Some)option;
                Object m = some.x();
                Map brokerInfo = (Map)m;
                int n = version = BoxesRunTime.unboxToInt((Object)brokerInfo.apply((Object)"version"));
                switch (n) {
                    default: {
                        throw new KafkaException(new StringBuilder().append((Object)"Unknown version of broker registration. Only versions 1 and 2 are supported.").append((Object)brokerInfoString).toString());
                    }
                    case 2: {
                        List listeners = (List)brokerInfo.apply((Object)"endpoints");
                        map = ((TraversableOnce)listeners.map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<SecurityProtocol, EndPoint> apply(String listener) {
                                EndPoint ep = EndPoint$.MODULE$.createEndPoint(listener);
                                return new Tuple2((Object)ep.protocolType(), (Object)ep);
                            }
                        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
                        break;
                    }
                    case 1: {
                        String host = (String)brokerInfo.apply((Object)"host");
                        int port = BoxesRunTime.unboxToInt((Object)brokerInfo.apply((Object)"port"));
                        map = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)SecurityProtocol.PLAINTEXT), (Object)new EndPoint(host, port, SecurityProtocol.PLAINTEXT))}));
                    }
                }
                Map endpoints = map;
                Broker broker = new Broker(id, (Map<SecurityProtocol, EndPoint>)endpoints);
                return broker;
            }
            None$ none$ = None$.MODULE$;
            Option<Object> option2 = option;
            if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                throw new BrokerNotAvailableException(new StringOps(Predef$.MODULE$.augmentString("Broker id %d does not exist")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id)})));
            }
            throw new MatchError(option);
        }
        catch (Throwable throwable) {
            throw new KafkaException(new StringBuilder().append((Object)"Failed to parse the broker info from zookeeper: ").append((Object)brokerInfoString).toString(), throwable);
        }
    }

    public Broker readFrom(ByteBuffer buffer) {
        int id = buffer.getInt();
        int numEndpoints = buffer.getInt();
        Map endpoints = ((TraversableOnce)((TraversableLike)((TraversableLike)List$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)numEndpoints), (Integral)Numeric.IntIsIntegral$.MODULE$)).map((Function1)new Serializable(buffer){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer buffer$1;

            public final EndPoint apply(int i) {
                return EndPoint$.MODULE$.readFrom(this.buffer$1);
            }
            {
                this.buffer$1 = buffer$1;
            }
        }, List$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<SecurityProtocol, EndPoint> apply(EndPoint ep) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)ep.protocolType()), (Object)ep);
            }
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        return new Broker(id, (Map<SecurityProtocol, EndPoint>)endpoints);
    }

    public Broker apply(int id, Map<SecurityProtocol, EndPoint> endPoints) {
        return new Broker(id, endPoints);
    }

    public Option<Tuple2<Object, Map<SecurityProtocol, EndPoint>>> unapply(Broker x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)x$0.id()), x$0.endPoints()));
    }

    public SecurityProtocol $lessinit$greater$default$4() {
        return SecurityProtocol.PLAINTEXT;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Broker$() {
        MODULE$ = this;
    }
}

