/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.admin.ZkSecurityMigrator;
import kafka.server.KafkaConfig$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.zookeeper.client.ZKClientConfig;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;

public final class ZkSecurityMigrator$
implements Logging {
    public static ZkSecurityMigrator$ MODULE$;
    private final String usageMessage;
    private final String tlsConfigFileOption;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ZkSecurityMigrator$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String usageMessage() {
        return this.usageMessage;
    }

    public String tlsConfigFileOption() {
        return this.tlsConfigFileOption;
    }

    public void run(String[] args) {
        boolean bl;
        String jaasFile = System.getProperty("java.security.auth.login.config");
        ZkSecurityMigrator.ZkSecurityMigratorOptions opts = new ZkSecurityMigrator.ZkSecurityMigratorOptions(args);
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, this.usageMessage());
        Option<ZKClientConfig> option = this.createZkClientConfigFromOption(opts.options(), opts.zkTlsConfigFile());
        if (option == null) {
            throw null;
        }
        Option<ZKClientConfig> getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? ZkSecurityMigrator$.$anonfun$run$1() : getOrElse_this.get();
        Object zkClientConfig = object;
        boolean tlsClientAuthEnabled = KafkaConfig$.MODULE$.zkTlsClientAuthEnabled((ZKClientConfig)zkClientConfig);
        if (jaasFile == null && !tlsClientAuthEnabled) {
            String errorMsg = new StringBuilder(273).append("No JAAS configuration file has been specified and no TLS client certificate has been specified. Please make sure that you set ").append("the system property ").append("java.security.auth.login.config").append(" or provide a ZooKeeper client TLS configuration via --").append(this.tlsConfigFileOption()).append(" <filename> ").append("identifying at least ").append(KafkaConfig$.MODULE$.ZkSslClientEnableProp()).append(", ").append(KafkaConfig$.MODULE$.ZkClientCnxnSocketProp()).append(", and ").append(KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp()).toString();
            String string = "ERROR: %s";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            System.err.println(new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errorMsg})));
            throw new IllegalArgumentException("Incorrect configuration");
        }
        if (!tlsClientAuthEnabled && !JaasUtils.isZkSaslEnabled()) {
            String string = "Security isn't enabled, most likely the file isn't set properly: %s";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            String errorMsg = new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jaasFile}));
            String string2 = "ERROR: %s";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            System.out.println(new StringOps(string2).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errorMsg})));
            throw new IllegalArgumentException("Incorrect configuration");
        }
        String string = (String)opts.options().valueOf(opts.zkAclOpt());
        if ("secure".equals(string)) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(this.msgWithLogIdent(ZkSecurityMigrator$.$anonfun$run$2()));
            }
            bl = true;
        } else if ("unsecure".equals(string)) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(this.msgWithLogIdent(ZkSecurityMigrator$.$anonfun$run$3()));
            }
            bl = false;
        } else {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), this.usageMessage());
        }
        String zkUrl = (String)opts.options().valueOf(opts.zkUrlOpt());
        int zkSessionTimeout = (Integer)opts.options().valueOf(opts.zkSessionTimeoutOpt());
        int zkConnectionTimeout = (Integer)opts.options().valueOf(opts.zkConnectionTimeoutOpt());
        int x$5 = Integer.MAX_VALUE;
        Time x$6 = Time.SYSTEM;
        Some x$7 = new Some(zkClientConfig);
        String x$8 = KafkaZkClient$.MODULE$.apply$default$7();
        String x$9 = KafkaZkClient$.MODULE$.apply$default$8();
        Option<String> x$10 = KafkaZkClient$.MODULE$.apply$default$9();
        KafkaZkClient zkClient = KafkaZkClient$.MODULE$.apply(zkUrl, bl, zkSessionTimeout, zkConnectionTimeout, x$5, x$6, x$8, x$9, x$10, (Option<ZKClientConfig>)x$7);
        boolean enablePathCheck = opts.options().has((OptionSpec)opts.enablePathCheckOpt());
        new ZkSecurityMigrator(zkClient).kafka$admin$ZkSecurityMigrator$$run(enablePathCheck);
    }

    public void main(String[] args) {
        try {
            this.run(args);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
    }

    /*
     * WARNING - void declaration
     */
    public ZKClientConfig createZkClientConfigFromFile(String filename) {
        void var3_3;
        Properties zkTlsConfigFileProps = Utils.loadProps((String)filename, (List)((List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().toList()).asJava()));
        ZKClientConfig zkClientConfig = new ZKClientConfig();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(this.msgWithLogIdent(ZkSecurityMigrator$.$anonfun$createZkClientConfigFromFile$1(zkTlsConfigFileProps, filename)));
        }
        ((IterableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(zkTlsConfigFileProps).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ZkSecurityMigrator$.$anonfun$createZkClientConfigFromFile$2(zkClientConfig, x0$1);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    public Option<ZKClientConfig> createZkClientConfigFromOption(OptionSet options, ArgumentAcceptingOptionSpec<String> option) {
        if (!options.has(option)) {
            return None$.MODULE$;
        }
        return new Some((Object)this.createZkClientConfigFromFile((String)options.valueOf(option)));
    }

    public static final /* synthetic */ ZKClientConfig $anonfun$run$1() {
        return new ZKClientConfig();
    }

    public static final /* synthetic */ String $anonfun$run$2() {
        return "zookeeper.acl option is secure";
    }

    public static final /* synthetic */ String $anonfun$run$3() {
        return "zookeeper.acl option is unsecure";
    }

    public static final /* synthetic */ String $anonfun$createZkClientConfigFromFile$1(Properties zkTlsConfigFileProps$1, String filename$1) {
        return new StringBuilder(57).append("Found ").append(zkTlsConfigFileProps$1.size()).append(" ZooKeeper client configuration properties in file ").append(filename$1).toString();
    }

    public static final /* synthetic */ String $anonfun$createZkClientConfigFromFile$3(String key$1) {
        return new StringBuilder(8).append("Setting ").append(key$1).toString();
    }

    public static final /* synthetic */ void $anonfun$createZkClientConfigFromFile$2(ZKClientConfig zkClientConfig$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String key = (String)x0$1._1();
            String value = (String)x0$1._2();
            ZkSecurityMigrator$ zkSecurityMigrator$ = MODULE$;
            if (zkSecurityMigrator$ == null) {
                throw null;
            }
            ZkSecurityMigrator$ info_this = zkSecurityMigrator$;
            if (info_this.logger().underlying().isInfoEnabled()) {
                info_this.logger().underlying().info(info_this.msgWithLogIdent(ZkSecurityMigrator$.$anonfun$createZkClientConfigFromFile$3(key)));
            }
            KafkaConfig$.MODULE$.setZooKeeperClientProperty(zkClientConfig$1, key, value);
            return;
        }
        throw new MatchError(null);
    }

    private ZkSecurityMigrator$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.usageMessage = "ZooKeeper Migration Tool Help. This tool updates the ACLs of znodes as part of the process of setting up ZooKeeper authentication.";
        this.tlsConfigFileOption = "zk-tls-config-file";
    }
}

