/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.AbstractServerThread;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor$;
import kafka.network.Processor$ConnectionId$;
import kafka.network.RequestChannel;
import kafka.network.SocketServer$;
import kafka.security.CredentialProvider;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\u0011MtA\u00026l\u0011\u0003iwN\u0002\u0004rW\"\u0005QN\u001d\u0005\u0006s\u0006!\ta\u001f\u0005\by\u0006\u0011\r\u0011\"\u0001~\u0011\u001d\ti!\u0001Q\u0001\nyD\u0001\"a\u0004\u0002\u0005\u0004%\t! \u0005\b\u0003#\t\u0001\u0015!\u0003\u007f\u0011!\t\u0019\"\u0001b\u0001\n\u0003i\bbBA\u000b\u0003\u0001\u0006IA \u0005\n\u0003/\t!\u0019!C\u0001\u00033A\u0001\"!\t\u0002A\u0003%\u00111\u0004\u0005\n\u0003G\t\u0011\u0013!C\u0001\u0003K1a!]6\u0001[\u0006m\u0002BCA(\u0019\t\u0015\r\u0011\"\u0001\u0002\u001a!Q\u0011\u0011\u000b\u0007\u0003\u0002\u0003\u0006I!a\u0007\t\u0015\u0005MCB!A!\u0002\u0013\t)\u0006\u0003\u0006\u0002p1\u0011\t\u0011)A\u0005\u00037A!\"!\u001d\r\u0005\u0003\u0005\u000b\u0011BA:\u0011)\tI\b\u0004B\u0001B\u0003%\u00111\u0010\u0005\u000b\u0003\u0003c!\u0011!Q\u0001\n\u0005\r\u0005BCAE\u0019\t\u0005\t\u0015!\u0003\u0002\u001c!Q\u00111\u0012\u0007\u0003\u0002\u0003\u0006I!!$\t\u0015\u0005]EB!A!\u0002\u0013\tI\n\u0003\u0006\u0002*2\u0011\t\u0011)A\u0005\u0003WC!\"!\u0013\r\u0005\u0003\u0005\u000b\u0011BA\\\u0011)\t\t\r\u0004B\u0001B\u0003%\u00111\u0019\u0005\u000b\u0003\u001bd!\u0011!Q\u0001\n\u0005=\u0007BCAn\u0019\t\u0005\t\u0015!\u0003\u0002^\"Q\u00111\u001d\u0007\u0003\u0002\u0003\u0006I!a\u0007\t\redA\u0011AAs\u000f\u001d\u00119\u0001\u0004E\u0005\u0005\u00131qA!\u0004\r\u0011\u0013\u0011y\u0001\u0003\u0004z?\u0011\u0005!q\u0003\u0005\b\u00053yB\u0011\u0001B\u000e\u0011%\u0011ylHA\u0001\n\u0003\u0013\t\rC\u0005\u0003N~\t\t\u0011\"!\u0003P\u001a9!Q\u0002\u0007AW\n\u0015\u0002B\u0003B\u0017I\tU\r\u0011\"\u0001\u00030!Q!Q\t\u0013\u0003\u0012\u0003\u0006IA!\r\t\u0015\t\u001dCE!f\u0001\n\u0003\tI\u0002\u0003\u0006\u0003J\u0011\u0012\t\u0012)A\u0005\u00037A!Ba\u0013%\u0005+\u0007I\u0011\u0001B\u0018\u0011)\u0011i\u0005\nB\tB\u0003%!\u0011\u0007\u0005\u000b\u0005\u001f\"#Q3A\u0005\u0002\u0005e\u0001B\u0003B)I\tE\t\u0015!\u0003\u0002\u001c!Q!1\u000b\u0013\u0003\u0016\u0004%\t!!\u0007\t\u0015\tUCE!E!\u0002\u0013\tY\u0002\u0003\u0004zI\u0011\u0005!q\u000b\u0005\b\u0005G\"C\u0011\tB3\u0011%\u00119\u0007JA\u0001\n\u0003\u0011I\u0007C\u0005\u0003v\u0011\n\n\u0011\"\u0001\u0003x!I!1\u0010\u0013\u0012\u0002\u0013\u0005\u0011Q\u0005\u0005\n\u0005{\"\u0013\u0013!C\u0001\u0005oB\u0011Ba %#\u0003%\t!!\n\t\u0013\t\u0005E%%A\u0005\u0002\u0005\u0015\u0002\u0002\u0003BBI\u0005\u0005I\u0011I?\t\u0013\t\u0015E%!A\u0005\u0002\u0005e\u0001\"\u0003BDI\u0005\u0005I\u0011\u0001BE\u0011%\u0011)\nJA\u0001\n\u0003\u00129\nC\u0005\u0003&\u0012\n\t\u0011\"\u0001\u0003(\"I!\u0011\u0017\u0013\u0002\u0002\u0013\u0005#1\u0017\u0005\n\u0005k#\u0013\u0011!C!\u0005oC\u0011B!8\r\u0005\u0004%IAa8\t\u0011\r\u0005A\u0002)A\u0005\u0005CD\u0011ba\u0001\r\u0005\u0004%Ia!\u0002\t\u0011\r\u0005B\u0002)A\u0005\u0007\u000fA\u0011ba\t\r\u0005\u0004%Ia!\n\t\u0011\r5B\u0002)A\u0005\u0007OA!ba\f\r\u0005\u0004%\t!\\B\u0019\u0011!\u0019I\u0004\u0004Q\u0001\n\rM\u0002\"CB\u001e\u0019\t\u0007I\u0011AB\u001f\u0011!\u0019Y\u0005\u0004Q\u0001\n\r}\u0002\"CB'\u0019\t\u0007I\u0011BB(\u0011!\u0019I\u0006\u0004Q\u0001\n\rE\u0003\"CB.\u0019\t\u0007I\u0011BB/\u0011!\u0019)\u0007\u0004Q\u0001\n\r}\u0003\u0002CB4\u0019\u0011E1n!\u001b\t\u0013\rUD\u00021A\u0005\n\u0005e\u0001\"CB<\u0019\u0001\u0007I\u0011BB=\u0011!\u0019\u0019\t\u0004Q!\n\u0005m\u0001bBBC\u0019\u0011\u00053q\u0011\u0005\t\u0007\u0013cA\u0011A6\u0004\f\"91q\u0015\u0007\u0005\n\r%\u0006bBBZ\u0019\u0011%1q\u0011\u0005\t\u0007kcA\u0011C6\u00048\"91q\u0019\u0007\u0005\n\r\u001d\u0005bBBe\u0019\u0011%1q\u0011\u0005\b\u0007\u0017dA\u0011BBD\u0011\u001d\u0019i\r\u0004C\u0005\u0007\u001fDqaa5\r\t\u0013\u00199\tC\u0004\u0004V2!Iaa\"\t\u000f\r]G\u0002\"\u0003\u0004Z\"91q\u001c\u0007\u0005\u0002\r\u0005\bb\u0002C\u0003\u0019\u0011%1q\u0011\u0005\b\t\u000faA\u0011BBD\u0011!\u0019i\u000e\u0004C\tW\u0012%\u0001\u0002\u0003C\u000e\u0019\u0011\u00051\u000e\"\b\t\u000f\u0011\u0005B\u0002\"\u0003\u0005$!AAQ\u0005\u0007\u0005\u0002-\fI\u0002\u0003\u0005\u0005(1!\ta[A\r\u0011!!I\u0003\u0004C\u0001W\u0012-\u0002b\u0002C\u001c\u0019\u0011%A\u0011\b\u0005\b\tGbA\u0011\u0002C3\u0011!!I\u0007\u0004C\u0001W\u0012-\u0004b\u0002C8\u0019\u0011\u00053q\u0011\u0005\b\tcbA\u0011IBD\u0003%\u0001&o\\2fgN|'O\u0003\u0002m[\u00069a.\u001a;x_J\\'\"\u00018\u0002\u000b-\fgm[1\u0011\u0005A\fQ\"A6\u0003\u0013A\u0013xnY3tg>\u00148CA\u0001t!\t!x/D\u0001v\u0015\u00051\u0018!B:dC2\f\u0017B\u0001=v\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001p\u0003UIE\r\\3QKJ\u001cWM\u001c;NKR\u0014\u0018n\u0019(b[\u0016,\u0012A \t\u0004\u007f\u0006%QBAA\u0001\u0015\u0011\t\u0019!!\u0002\u0002\t1\fgn\u001a\u0006\u0003\u0003\u000f\tAA[1wC&!\u00111BA\u0001\u0005\u0019\u0019FO]5oO\u00061\u0012\n\u001a7f!\u0016\u00148-\u001a8u\u001b\u0016$(/[2OC6,\u0007%A\rOKR<xN]6Qe>\u001cWm]:pe6+GO]5d)\u0006<\u0017A\u0007(fi^|'o\u001b)s_\u000e,7o]8s\u001b\u0016$(/[2UC\u001e\u0004\u0013!\u0005'jgR,g.\u001a:NKR\u0014\u0018n\u0019+bO\u0006\u0011B*[:uK:,'/T3ue&\u001cG+Y4!\u0003M\u0019uN\u001c8fGRLwN\\)vKV,7+\u001b>f+\t\tY\u0002E\u0002u\u0003;I1!a\bv\u0005\rIe\u000e^\u0001\u0015\u0007>tg.Z2uS>t\u0017+^3vKNK'0\u001a\u0011\u00029\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132kU\u0011\u0011q\u0005\u0016\u0005\u00037\tIc\u000b\u0002\u0002,A!\u0011QFA\u001c\u001b\t\tyC\u0003\u0003\u00022\u0005M\u0012!C;oG\",7m[3e\u0015\r\t)$^\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u001d\u0003_\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f'\u0015a\u0011QHA\"!\r\u0001\u0018qH\u0005\u0004\u0003\u0003Z'\u0001F!cgR\u0014\u0018m\u0019;TKJ4XM\u001d+ie\u0016\fG\r\u0005\u0003\u0002F\u0005-SBAA$\u0015\r\tI%\\\u0001\b[\u0016$(/[2t\u0013\u0011\ti%a\u0012\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b/\u0001\u0002jI\u0006\u0019\u0011\u000e\u001a\u0011\u0002\tQLW.\u001a\t\u0005\u0003/\nY'\u0004\u0002\u0002Z)!\u00111LA/\u0003\u0015)H/\u001b7t\u0015\u0011\ty&!\u0019\u0002\r\r|W.\\8o\u0015\rq\u00171\r\u0006\u0005\u0003K\n9'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003S\n1a\u001c:h\u0013\u0011\ti'!\u0017\u0003\tQKW.Z\u0001\u000f[\u0006D(+Z9vKN$8+\u001b>f\u00039\u0011X-];fgR\u001c\u0005.\u00198oK2\u00042\u0001]A;\u0013\r\t9h\u001b\u0002\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0003A\u0019wN\u001c8fGRLwN\\)v_R\f7\u000fE\u0002q\u0003{J1!a l\u0005A\u0019uN\u001c8fGRLwN\\)v_R\f7/\u0001\u000bd_:tWm\u0019;j_:\u001cX*\u0019=JI2,Wj\u001d\t\u0004i\u0006\u0015\u0015bAADk\n!Aj\u001c8h\u0003m1\u0017-\u001b7fI\u0006+H\u000f[3oi&\u001c\u0017\r^5p]\u0012+G.Y=Ng\u0006aA.[:uK:,'OT1nKB!\u0011qRAJ\u001b\t\t\tJC\u0002m\u0003;JA!!&\u0002\u0012\naA*[:uK:,'OT1nK\u0006\u00012/Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\u001c\t\u0005\u00037\u000b)+\u0004\u0002\u0002\u001e*!\u0011qTAQ\u0003\u0011\tW\u000f\u001e5\u000b\t\u0005\r\u0016QL\u0001\tg\u0016\u001cWO]5us&!\u0011qUAO\u0005A\u0019VmY;sSRL\bK]8u_\u000e|G.\u0001\u0004d_:4\u0017n\u001a\t\u0005\u0003[\u000b\u0019,\u0004\u0002\u00020*\u0019\u0011\u0011W7\u0002\rM,'O^3s\u0013\u0011\t),a,\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\t\u0005\u0003s\u000bi,\u0004\u0002\u0002<*!\u0011\u0011JA/\u0013\u0011\ty,a/\u0003\u000f5+GO]5dg\u0006\u00112M]3eK:$\u0018.\u00197Qe>4\u0018\u000eZ3s!\u0011\t)-!3\u000e\u0005\u0005\u001d'bAAR[&!\u00111ZAd\u0005I\u0019%/\u001a3f]RL\u0017\r\u001c)s_ZLG-\u001a:\u0002\u00155,Wn\u001c:z!>|G\u000e\u0005\u0003\u0002R\u0006]WBAAj\u0015\u0011\t).!\u0018\u0002\r5,Wn\u001c:z\u0013\u0011\tI.a5\u0003\u00155+Wn\u001c:z!>|G.\u0001\u0006m_\u001e\u001cuN\u001c;fqR\u0004B!a\u0016\u0002`&!\u0011\u0011]A-\u0005)aunZ\"p]R,\u0007\u0010^\u0001\u0014G>tg.Z2uS>t\u0017+^3vKNK'0\u001a\u000b!\u0003O\fI/a;\u0002n\u0006=\u0018\u0011_Az\u0003k\f90!?\u0002|\u0006u\u0018q B\u0001\u0005\u0007\u0011)\u0001\u0005\u0002q\u0019!9\u0011qJ\u000fA\u0002\u0005m\u0001bBA*;\u0001\u0007\u0011Q\u000b\u0005\b\u0003_j\u0002\u0019AA\u000e\u0011\u001d\t\t(\ba\u0001\u0003gBq!!\u001f\u001e\u0001\u0004\tY\bC\u0004\u0002\u0002v\u0001\r!a!\t\u000f\u0005%U\u00041\u0001\u0002\u001c!9\u00111R\u000fA\u0002\u00055\u0005bBAL;\u0001\u0007\u0011\u0011\u0014\u0005\b\u0003Sk\u0002\u0019AAV\u0011\u001d\tI%\ba\u0001\u0003oCq!!1\u001e\u0001\u0004\t\u0019\rC\u0004\u0002Nv\u0001\r!a4\t\u000f\u0005mW\u00041\u0001\u0002^\"I\u00111]\u000f\u0011\u0002\u0003\u0007\u00111D\u0001\r\u0007>tg.Z2uS>t\u0017\n\u001a\t\u0004\u0005\u0017yR\"\u0001\u0007\u0003\u0019\r{gN\\3di&|g.\u00133\u0014\t}\u0019(\u0011\u0003\t\u0004i\nM\u0011b\u0001B\u000bk\na1+\u001a:jC2L'0\u00192mKR\u0011!\u0011B\u0001\u000bMJ|Wn\u0015;sS:<G\u0003\u0002B\u000f\u0005w\u0003R\u0001\u001eB\u0010\u0005GI1A!\tv\u0005\u0019y\u0005\u000f^5p]B\u0019!1\u0002\u0013\u0014\r\u0011\u001a(q\u0005B\t!\r!(\u0011F\u0005\u0004\u0005W)(a\u0002)s_\u0012,8\r^\u0001\nY>\u001c\u0017\r\u001c%pgR,\"A!\r\u0011\t\tM\"\u0011\t\b\u0005\u0005k\u0011i\u0004E\u0002\u00038Ul!A!\u000f\u000b\u0007\tm\"0\u0001\u0004=e>|GOP\u0005\u0004\u0005\u007f)\u0018A\u0002)sK\u0012,g-\u0003\u0003\u0002\f\t\r#b\u0001B k\u0006QAn\\2bY\"{7\u000f\u001e\u0011\u0002\u00131|7-\u00197Q_J$\u0018A\u00037pG\u0006d\u0007k\u001c:uA\u0005Q!/Z7pi\u0016Dun\u001d;\u0002\u0017I,Wn\u001c;f\u0011>\u001cH\u000fI\u0001\u000be\u0016lw\u000e^3Q_J$\u0018a\u0003:f[>$X\rU8si\u0002\nQ!\u001b8eKb\fa!\u001b8eKb\u0004C\u0003\u0004B\u0012\u00053\u0012YF!\u0018\u0003`\t\u0005\u0004b\u0002B\u0017_\u0001\u0007!\u0011\u0007\u0005\b\u0005\u000fz\u0003\u0019AA\u000e\u0011\u001d\u0011Ye\fa\u0001\u0005cAqAa\u00140\u0001\u0004\tY\u0002C\u0004\u0003T=\u0002\r!a\u0007\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!\r\u0002\t\r|\u0007/\u001f\u000b\r\u0005G\u0011YG!\u001c\u0003p\tE$1\u000f\u0005\n\u0005[\t\u0004\u0013!a\u0001\u0005cA\u0011Ba\u00122!\u0003\u0005\r!a\u0007\t\u0013\t-\u0013\u0007%AA\u0002\tE\u0002\"\u0003B(cA\u0005\t\u0019AA\u000e\u0011%\u0011\u0019&\rI\u0001\u0002\u0004\tY\"\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\te$\u0006\u0002B\u0019\u0003S\tabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\t-%\u0011\u0013\t\u0004i\n5\u0015b\u0001BHk\n\u0019\u0011I\\=\t\u0013\tM\u0015(!AA\u0002\u0005m\u0011a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\u001aB1!1\u0014BQ\u0005\u0017k!A!(\u000b\u0007\t}U/\u0001\u0006d_2dWm\u0019;j_:LAAa)\u0003\u001e\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011IKa,\u0011\u0007Q\u0014Y+C\u0002\u0003.V\u0014qAQ8pY\u0016\fg\u000eC\u0005\u0003\u0014n\n\t\u00111\u0001\u0003\f\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002\u001c\u00051Q-];bYN$BA!+\u0003:\"I!1S\u001f\u0002\u0002\u0003\u0007!1\u0012\u0005\b\u0005{\u000b\u0003\u0019\u0001B\u0019\u0003\u0005\u0019\u0018!B1qa2LH\u0003\u0004B\u0012\u0005\u0007\u0014)Ma2\u0003J\n-\u0007b\u0002B\u0017E\u0001\u0007!\u0011\u0007\u0005\b\u0005\u000f\u0012\u0003\u0019AA\u000e\u0011\u001d\u0011YE\ta\u0001\u0005cAqAa\u0014#\u0001\u0004\tY\u0002C\u0004\u0003T\t\u0002\r!a\u0007\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\u001bBm!\u0015!(q\u0004Bj!5!(Q\u001bB\u0019\u00037\u0011\t$a\u0007\u0002\u001c%\u0019!q[;\u0003\rQ+\b\u000f\\36\u0011%\u0011YnIA\u0001\u0002\u0004\u0011\u0019#A\u0002yIA\naB\\3x\u0007>tg.Z2uS>t7/\u0006\u0002\u0003bB1!1\u001dBw\u0005cl!A!:\u000b\t\t\u001d(\u0011^\u0001\u000bG>t7-\u001e:sK:$(\u0002\u0002Bv\u0003\u000b\tA!\u001e;jY&!!q\u001eBs\u0005I\t%O]1z\u00052|7m[5oOF+X-^3\u0011\t\tM(Q`\u0007\u0003\u0005kTAAa>\u0003z\u0006A1\r[1o]\u0016d7O\u0003\u0003\u0003|\u0006\u0015\u0011a\u00018j_&!!q B{\u00055\u0019vnY6fi\u000eC\u0017M\u001c8fY\u0006ya.Z<D_:tWm\u0019;j_:\u001c\b%A\tj]\u001ad\u0017n\u001a5u%\u0016\u001c\bo\u001c8tKN,\"aa\u0002\u0011\u0011\r%1q\u0002B\u0019\u0007'i!aa\u0003\u000b\t\r5!QT\u0001\b[V$\u0018M\u00197f\u0013\u0011\u0019\tba\u0003\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0004\u0016\rmab\u00019\u0004\u0018%\u00191\u0011D6\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY&!1QDB\u0010\u0005!\u0011Vm\u001d9p]N,'bAB\rW\u0006\u0011\u0012N\u001c4mS\u001eDGOU3ta>t7/Z:!\u00035\u0011Xm\u001d9p]N,\u0017+^3vKV\u00111q\u0005\t\u0007\u0005G\u001cIca\u0005\n\t\r-\"Q\u001d\u0002\u0014\u0019&t7.\u001a3CY>\u001c7.\u001b8h\t\u0016\fX/Z\u0001\u000fe\u0016\u001c\bo\u001c8tKF+X-^3!\u0003)iW\r\u001e:jGR\u000bwm]\u000b\u0003\u0007g\u0001ba!\u000e\u00048ytXB\u0001Bu\u0013\u0011\u0019\tB!;\u0002\u00175,GO]5d)\u0006<7\u000fI\u0001\u001eKb\u0004\u0018N]3e\u0007>tg.Z2uS>t7oS5mY\u0016$7i\\;oiV\u00111q\b\t\u0005\u0007\u0003\u001a9%\u0004\u0002\u0004D)!1QIA^\u0003\u0015\u0019H/\u0019;t\u0013\u0011\u0019Iea\u0011\u0003\u001b\r+X.\u001e7bi&4XmU;n\u0003y)\u0007\u0010]5sK\u0012\u001cuN\u001c8fGRLwN\\:LS2dW\rZ\"pk:$\b%A\u0014fqBL'/\u001a3D_:tWm\u0019;j_:\u001c8*\u001b7mK\u0012\u001cu.\u001e8u\u001b\u0016$(/[2OC6,WCAB)!\u0011\u0019\u0019f!\u0016\u000e\u0005\u0005u\u0013\u0002BB,\u0003;\u0012!\"T3ue&\u001cg*Y7f\u0003!*\u0007\u0010]5sK\u0012\u001cuN\u001c8fGRLwN\\:LS2dW\rZ\"pk:$X*\u001a;sS\u000et\u0015-\\3!\u0003!\u0019X\r\\3di>\u0014XCAB0!\u0011\tyi!\u0019\n\t\r\r\u0014\u0011\u0013\u0002\t'\u0016dWm\u0019;pe\u0006I1/\u001a7fGR|'\u000fI\u0001\u000fGJ,\u0017\r^3TK2,7\r^8s)\u0011\u0019yfa\u001b\t\u000f\r5D\n1\u0001\u0004p\u0005q1\r[1o]\u0016d')^5mI\u0016\u0014\b\u0003BAH\u0007cJAaa\u001d\u0002\u0012\nq1\t[1o]\u0016d')^5mI\u0016\u0014\u0018a\u00058fqR\u001cuN\u001c8fGRLwN\\%oI\u0016D\u0018a\u00068fqR\u001cuN\u001c8fGRLwN\\%oI\u0016Dx\fJ3r)\u0011\u0019Yh!!\u0011\u0007Q\u001ci(C\u0002\u0004\u0000U\u0014A!\u00168ji\"I!1\u0013(\u0002\u0002\u0003\u0007\u00111D\u0001\u0015]\u0016DHoQ8o]\u0016\u001cG/[8o\u0013:$W\r\u001f\u0011\u0002\u0007I,h\u000e\u0006\u0002\u0004|\u0005\u0001\u0002O]8dKN\u001cX\t_2faRLwN\u001c\u000b\u0007\u0007w\u001aii!%\t\u000f\r=\u0015\u000b1\u0001\u00032\u0005aQM\u001d:pe6+7o]1hK\"911S)A\u0002\rU\u0015!\u0003;ie><\u0018M\u00197f!\u0011\u00199j!)\u000f\t\re5Q\u0014\b\u0005\u0005o\u0019Y*C\u0001w\u0013\r\u0019y*^\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0019\u0019k!*\u0003\u0013QC'o\\<bE2,'bABPk\u00069\u0002O]8dKN\u001c8\t[1o]\u0016dW\t_2faRLwN\u001c\u000b\t\u0007w\u001aYka,\u00042\"91Q\u0016*A\u0002\tE\u0012!C2iC:tW\r\\%e\u0011\u001d\u0019yI\u0015a\u0001\u0005cAqaa%S\u0001\u0004\u0019)*A\nqe>\u001cWm]:OK^\u0014Vm\u001d9p]N,7/\u0001\u0007tK:$'+Z:q_:\u001cX\r\u0006\u0004\u0004|\re6Q\u0018\u0005\b\u0007w#\u0006\u0019AB\n\u0003!\u0011Xm\u001d9p]N,\u0007bBB`)\u0002\u00071\u0011Y\u0001\re\u0016\u001c\bo\u001c8tKN+g\u000e\u001a\t\u0005\u0003\u001f\u001b\u0019-\u0003\u0003\u0004F\u0006E%\u0001B*f]\u0012\fA\u0001]8mY\u0006A\u0002O]8dKN\u001c8i\\7qY\u0016$X\r\u001a*fG\u0016Lg/Z:\u0002+A\u0014xnY3tg\u000e{W\u000e\u001d7fi\u0016$7+\u001a8eg\u0006!R\u000f\u001d3bi\u0016\u0014V-];fgRlU\r\u001e:jGN$Baa\u001f\u0004R\"911\u0018-A\u0002\rM\u0011a\u00059s_\u000e,7o\u001d#jg\u000e|gN\\3di\u0016$\u0017AF2m_N,W\t_2fgN\u001cuN\u001c8fGRLwN\\:\u0002\u000b\rdwn]3\u0015\t\rm41\u001c\u0005\b\u0007;\\\u0006\u0019\u0001B\u0019\u00031\u0019wN\u001c8fGRLwN\\%e\u0003\u0019\t7mY3qiRA!\u0011VBr\u0007O\u001cY\u000fC\u0004\u0004fr\u0003\rA!=\u0002\u001bM|7m[3u\u0007\"\fgN\\3m\u0011\u001d\u0019I\u000f\u0018a\u0001\u0005S\u000b\u0001\"\\1z\u00052|7m\u001b\u0005\b\u0007[d\u0006\u0019ABx\u0003a\t7mY3qi>\u0014\u0018\n\u001a7f!\u0016\u00148-\u001a8u\u001b\u0016$XM\u001d\t\u0005\u0007c$\t!\u0004\u0002\u0004t*!1Q_B|\u0003\u0011\u0019wN]3\u000b\t\u0005%3\u0011 \u0006\u0005\u0007w\u001ci0\u0001\u0004zC6lWM\u001d\u0006\u0003\u0007\u007f\f1aY8n\u0013\u0011!\u0019aa=\u0003\u000b5+G/\u001a:\u0002/\r|gNZ5hkJ,g*Z<D_:tWm\u0019;j_:\u001c\u0018\u0001C2m_N,\u0017\t\u001c7\u0015\t\tEB1\u0002\u0005\b\t\u001by\u0006\u0019\u0001C\b\u0003\u0019\u0019xnY6fiB!A\u0011\u0003C\f\u001b\t!\u0019B\u0003\u0003\u0005\u0016\u0005\u0015\u0011a\u00018fi&!A\u0011\u0004C\n\u0005\u0019\u0019vnY6fi\u0006yQM\\9vKV,'+Z:q_:\u001cX\r\u0006\u0003\u0004|\u0011}\u0001bBB^A\u0002\u000711C\u0001\u0010I\u0016\fX/Z;f%\u0016\u001c\bo\u001c8tKR\u001111C\u0001\u0012e\u0016\u001c\bo\u001c8tKF+X-^3TSj,\u0017!F5oM2Lw\r\u001b;SKN\u0004xN\\:f\u0007>,h\u000e^\u0001\u0015_B,gn\u0014:DY>\u001c\u0018N\\4DQ\u0006tg.\u001a7\u0015\t\u00115BQ\u0007\t\u0006i\n}Aq\u0006\t\u0005\u0003\u001f#\t$\u0003\u0003\u00054\u0005E%\u0001D&bM.\f7\t[1o]\u0016d\u0007bBBoI\u0002\u0007!\u0011G\u0001\u0017Q\u0006tG\r\\3DQ\u0006tg.\u001a7NkR,WI^3oiR111\u0010C\u001e\t{Aqa!8f\u0001\u0004\u0011\t\u0004C\u0004\u0005@\u0015\u0004\r\u0001\"\u0011\u0002\u000b\u00154XM\u001c;\u0011\t\u0011\rCQ\f\b\u0005\t\u000b\"IF\u0004\u0003\u0005H\u0011]c\u0002\u0002C%\t+rA\u0001b\u0013\u0005T9!AQ\nC)\u001d\u0011\u00119\u0004b\u0014\n\u0005\u0005%\u0014\u0002BA3\u0003OJ1A\\A2\u0013\u0011\ty&!\u0019\n\u00071\fi&\u0003\u0003\u0005\\\u0005E\u0015\u0001D&bM.\f7\t[1o]\u0016d\u0017\u0002\u0002C0\tC\u0012\u0001c\u00115b]:,G.T;uK\u00163XM\u001c;\u000b\t\u0011m\u0013\u0011S\u0001\u0011iJLXK\\7vi\u0016\u001c\u0005.\u00198oK2$Baa\u001f\u0005h!91Q\u001c4A\u0002\tE\u0012aB2iC:tW\r\u001c\u000b\u0005\t[!i\u0007C\u0004\u0004^\u001e\u0004\rA!\r\u0002\r]\f7.Z;q\u0003AIg.\u001b;jCR,7\u000b[;uI><h\u000e")
public class Processor
extends AbstractServerThread
implements KafkaMetricsGroup {
    private volatile Processor$ConnectionId$ ConnectionId$module;
    private final int id;
    private final Time time;
    private final int maxRequestSize;
    private final RequestChannel requestChannel;
    private final ConnectionQuotas connectionQuotas;
    private final long connectionsMaxIdleMs;
    private final int failedAuthenticationDelayMs;
    private final ListenerName listenerName;
    private final SecurityProtocol securityProtocol;
    private final KafkaConfig config;
    private final Metrics metrics;
    private final MemoryPool memoryPool;
    private final LogContext logContext;
    private final int connectionQueueSize;
    private final ArrayBlockingQueue<SocketChannel> newConnections;
    private final scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses;
    private final LinkedBlockingDeque<RequestChannel.Response> responseQueue;
    private final java.util.Map<String, String> metricTags;
    private final CumulativeSum expiredConnectionsKilledCount;
    private final MetricName expiredConnectionsKilledCountMetricName;
    private final Selector selector;
    private int nextConnectionIndex;

    public static int $lessinit$greater$default$15() {
        return Processor$.MODULE$.$lessinit$greater$default$15();
    }

    public static int ConnectionQueueSize() {
        return Processor$.MODULE$.ConnectionQueueSize();
    }

    public static String ListenerMetricTag() {
        return Processor$.MODULE$.ListenerMetricTag();
    }

    public static String NetworkProcessorMetricTag() {
        return Processor$.MODULE$.NetworkProcessorMetricTag();
    }

    public static String IdlePercentMetricName() {
        return Processor$.MODULE$.IdlePercentMetricName();
    }

    @Override
    public com.yammer.metrics.core.MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public com.yammer.metrics.core.MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    private Processor$ConnectionId$ ConnectionId() {
        if (this.ConnectionId$module == null) {
            this.ConnectionId$lzycompute$1();
        }
        return this.ConnectionId$module;
    }

    public int id() {
        return this.id;
    }

    private ArrayBlockingQueue<SocketChannel> newConnections() {
        return this.newConnections;
    }

    private scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses() {
        return this.inflightResponses;
    }

    private LinkedBlockingDeque<RequestChannel.Response> responseQueue() {
        return this.responseQueue;
    }

    public java.util.Map<String, String> metricTags() {
        return this.metricTags;
    }

    public CumulativeSum expiredConnectionsKilledCount() {
        return this.expiredConnectionsKilledCount;
    }

    private MetricName expiredConnectionsKilledCountMetricName() {
        return this.expiredConnectionsKilledCountMetricName;
    }

    private Selector selector() {
        return this.selector;
    }

    public Selector createSelector(ChannelBuilder channelBuilder) {
        if (channelBuilder instanceof Reconfigurable) {
            this.config.addReconfigurable((Reconfigurable)channelBuilder);
        }
        return new Selector(this.maxRequestSize, this.connectionsMaxIdleMs, this.failedAuthenticationDelayMs, this.metrics, this.time, "socket-server", this.metricTags(), false, true, channelBuilder, this.memoryPool, this.logContext);
    }

    private int nextConnectionIndex() {
        return this.nextConnectionIndex;
    }

    private void nextConnectionIndex_$eq(int x$1) {
        this.nextConnectionIndex = x$1;
    }

    @Override
    public void run() {
        this.startupComplete();
        try {
            while (this.isRunning()) {
                try {
                    this.configureNewConnections();
                    this.processNewResponses();
                    this.poll();
                    this.processCompletedReceives();
                    this.processCompletedSends();
                    this.processDisconnected();
                    this.closeExcessConnections();
                }
                catch (Throwable e) {
                    this.processException("Processor got uncaught exception.", e);
                }
            }
        }
        finally {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Closing selector - processor ").append(this.id()).toString());
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.closeAll(), this, Level.ERROR);
            this.shutdownComplete();
        }
    }

    public void processException(String errorMessage, Throwable throwable) {
        if (throwable instanceof ControlThrowable) {
            throw (Throwable)((ControlThrowable)throwable);
        }
        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMessage, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
    }

    private void processChannelException(String channelId, String errorMessage, Throwable throwable) {
        if (this.openOrClosingChannel(channelId).isDefined()) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Closing socket for ").append(channelId).append(" because of error").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
            this.close(channelId);
        }
        this.processException(errorMessage, throwable);
    }

    private void processNewResponses() {
        RequestChannel.Response currentResponse;
        while ((currentResponse = this.dequeueResponse()) != null) {
            String channelId = currentResponse.request().context().connectionId;
            try {
                if (currentResponse instanceof RequestChannel.NoOpResponse) {
                    RequestChannel.NoOpResponse noOpResponse = (RequestChannel.NoOpResponse)currentResponse;
                    this.updateRequestMetrics(noOpResponse);
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Socket server received empty response to send, registering for read: ").append(noOpResponse).toString());
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.RESPONSE_SENT);
                    this.tryUnmuteChannel(channelId);
                    continue;
                }
                if (currentResponse instanceof RequestChannel.SendResponse) {
                    RequestChannel.SendResponse sendResponse = (RequestChannel.SendResponse)currentResponse;
                    this.sendResponse(sendResponse, sendResponse.responseSend());
                    continue;
                }
                if (currentResponse instanceof RequestChannel.CloseConnectionResponse) {
                    RequestChannel.CloseConnectionResponse closeConnectionResponse = (RequestChannel.CloseConnectionResponse)currentResponse;
                    this.updateRequestMetrics(closeConnectionResponse);
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing socket connection actively according to the response code.");
                    this.close(channelId);
                    continue;
                }
                if (currentResponse instanceof RequestChannel.StartThrottlingResponse) {
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.THROTTLE_STARTED);
                    continue;
                }
                if (currentResponse instanceof RequestChannel.EndThrottlingResponse) {
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.THROTTLE_ENDED);
                    this.tryUnmuteChannel(channelId);
                    continue;
                }
                throw new IllegalArgumentException(new StringBuilder(23).append("Unknown response type: ").append(currentResponse.getClass()).toString());
            }
            catch (Throwable e) {
                this.processChannelException(channelId, new StringBuilder(40).append("Exception while processing response for ").append(channelId).toString(), e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void sendResponse(RequestChannel.Response response, Send responseSend) {
        String connectionId = response.request().context().connectionId;
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(85).append("Socket server received response to send to ").append(connectionId).append(", registering for write and sending data: ").append(response).toString());
        if (this.channel(connectionId).isEmpty()) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(93).append("Attempting to send response via channel for which there is no open connection, connection id ").append(connectionId).toString());
            response.request().updateRequestMetrics(0L, response);
        }
        if (this.openOrClosingChannel(connectionId).isDefined()) {
            void $minus$greater$extension_$this;
            this.selector().send(responseSend);
            Object object = Predef$.MODULE$.ArrowAssoc((Object)connectionId);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            this.inflightResponses().$plus$eq(new Tuple2((Object)$minus$greater$extension_$this, (Object)response));
        }
    }

    private void poll() {
        int pollTimeout = this.newConnections().isEmpty() ? 300 : 0;
        try {
            this.selector().poll((long)pollTimeout);
            return;
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof IllegalStateException ? true : throwable instanceof IOException;
            if (bl) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Processor ").append(this.id()).append(" poll failed").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
                return;
            }
            throw throwable;
        }
    }

    private void processCompletedReceives() {
        this.selector().completedReceives().forEach(receive -> {
            block9: {
                try {
                    Option<KafkaChannel> option = this.openOrClosingChannel(receive.source());
                    if (option instanceof Some) {
                        KafkaChannel channel = (KafkaChannel)((Some)option).value();
                        RequestHeader header = RequestHeader.parse((ByteBuffer)receive.payload());
                        ApiKeys apiKeys = header.apiKey();
                        ApiKeys apiKeys2 = ApiKeys.SASL_HANDSHAKE;
                        if (!(apiKeys != null ? !apiKeys.equals(apiKeys2) : apiKeys2 != null) && channel.maybeBeginServerReauthentication(receive, () -> Predef$.MODULE$.long2Long($this.time.nanoseconds()))) {
                            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Begin re-authentication: ").append(channel).toString());
                        } else {
                            long nowNanos = $this.time.nanoseconds();
                            if (channel.serverAuthenticationSessionExpired(nowNanos)) {
                                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Disconnecting expired channel: ").append(channel).append(" : ").append(header).toString());
                                this.close(channel.id());
                                this.expiredConnectionsKilledCount().record(null, 1.0, 0L);
                            } else {
                                ApiVersionsRequest apiVersionsRequest;
                                String connectionId = receive.source();
                                RequestContext context = new RequestContext(header, connectionId, channel.socketAddress(), channel.principal(), $this.listenerName, $this.securityProtocol, channel.channelMetadataRegistry().clientInformation());
                                RequestChannel.Request req = new RequestChannel.Request(this.id(), context, nowNanos, $this.memoryPool, receive.payload(), $this.requestChannel.metrics());
                                ApiKeys apiKeys3 = header.apiKey();
                                ApiKeys apiKeys4 = ApiKeys.API_VERSIONS;
                                if (!(apiKeys3 != null ? !apiKeys3.equals(apiKeys4) : apiKeys4 != null) && (apiVersionsRequest = (ApiVersionsRequest)req.body(ClassTag$.MODULE$.apply(ApiVersionsRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()))).isValid()) {
                                    channel.channelMetadataRegistry().registerClientInformation(new ClientInformation(apiVersionsRequest.data.clientSoftwareName(), apiVersionsRequest.data.clientSoftwareVersion()));
                                }
                                $this.requestChannel.sendRequest(req);
                                this.selector().mute(connectionId);
                                this.handleChannelMuteEvent(connectionId, KafkaChannel.ChannelMuteEvent.REQUEST_RECEIVED);
                            }
                        }
                        break block9;
                    }
                    if (None$.MODULE$.equals(option)) {
                        throw new IllegalStateException(new StringBuilder(66).append("Channel ").append(receive.source()).append(" removed from selector before processing completed receive").toString());
                    }
                    throw new MatchError(option);
                }
                catch (Throwable e) {
                    this.processChannelException(receive.source(), new StringBuilder(40).append("Exception while processing request from ").append(receive.source()).toString(), e);
                }
            }
        });
        this.selector().clearCompletedReceives();
    }

    private void processCompletedSends() {
        this.selector().completedSends().forEach(send -> {
            try {
                Option option = this.inflightResponses().remove((Object)send.destination());
                if (option == null) {
                    throw null;
                }
                Option getOrElse_this = option;
                if (getOrElse_this.isEmpty()) {
                    throw Processor.$anonfun$processCompletedSends$2(send);
                }
                RequestChannel.Response response = (RequestChannel.Response)getOrElse_this.get();
                this.updateRequestMetrics(response);
                Option<Function1<Send, BoxedUnit>> option2 = response.onComplete();
                if (option2 == null) {
                    throw null;
                }
                Option<Function1<Send, BoxedUnit>> foreach_this = option2;
                if (!foreach_this.isEmpty()) {
                    ((Function1)foreach_this.get()).apply(send);
                }
                this.handleChannelMuteEvent(send.destination(), KafkaChannel.ChannelMuteEvent.RESPONSE_SENT);
                this.tryUnmuteChannel(send.destination());
                return;
            }
            catch (Throwable e) {
                this.processChannelException(send.destination(), new StringBuilder(45).append("Exception while processing completed send to ").append(send.destination()).toString(), e);
                return;
            }
        });
        this.selector().clearCompletedSends();
    }

    private void updateRequestMetrics(RequestChannel.Response response) {
        RequestChannel.Request request = response.request();
        Option<KafkaChannel> option = this.openOrClosingChannel(request.context().connectionId);
        if (option == null) {
            throw null;
        }
        Option<KafkaChannel> fold_this = option;
        long l = fold_this.isEmpty() ? Processor.$anonfun$updateRequestMetrics$1() : ((KafkaChannel)fold_this.get()).getAndResetNetworkThreadTimeNanos();
        request.updateRequestMetrics(l, response);
    }

    private void processDisconnected() {
        this.selector().disconnected().keySet().forEach(connectionId -> {
            try {
                Option<ConnectionId> option = this.ConnectionId().fromString((String)connectionId);
                if (option == null) {
                    throw null;
                }
                Option<ConnectionId> getOrElse_this = option;
                if (getOrElse_this.isEmpty()) {
                    throw Processor.$anonfun$processDisconnected$2(connectionId);
                }
                String remoteHost = ((ConnectionId)getOrElse_this.get()).remoteHost();
                Option option2 = this.inflightResponses().remove(connectionId);
                if (option2 == null) {
                    throw null;
                }
                Option foreach_this = option2;
                if (!foreach_this.isEmpty()) {
                    RequestChannel.Response response = (RequestChannel.Response)foreach_this.get();
                    this.updateRequestMetrics(response);
                }
                $this.connectionQuotas.dec($this.listenerName, InetAddress.getByName(remoteHost));
                return;
            }
            catch (Throwable e) {
                this.processException(new StringBuilder(44).append("Exception while processing disconnection of ").append((String)connectionId).toString(), e);
                return;
            }
        });
    }

    private void closeExcessConnections() {
        KafkaChannel channel;
        if (this.connectionQuotas.maxConnectionsExceeded(this.listenerName) && (channel = this.selector().lowestPriorityChannel()) != null) {
            this.close(channel.id());
            return;
        }
    }

    private void close(String connectionId) {
        Option<KafkaChannel> option = this.openOrClosingChannel(connectionId);
        if (option == null) {
            throw null;
        }
        Option<KafkaChannel> foreach_this = option;
        if (!foreach_this.isEmpty()) {
            KafkaChannel kafkaChannel = (KafkaChannel)foreach_this.get();
            Processor.$anonfun$close$4(this, connectionId, kafkaChannel);
            return;
        }
    }

    public boolean accept(SocketChannel socketChannel, boolean mayBlock, Meter acceptorIdlePercentMeter) {
        boolean accepted;
        boolean bl;
        if (this.newConnections().offer(socketChannel)) {
            bl = true;
        } else if (mayBlock) {
            long startNs = this.time.nanoseconds();
            this.newConnections().put(socketChannel);
            acceptorIdlePercentMeter.mark(this.time.nanoseconds() - startNs);
            bl = true;
        } else {
            bl = accepted = false;
        }
        if (accepted) {
            this.wakeup();
        }
        return accepted;
    }

    private void configureNewConnections() {
        int connectionsProcessed = 0;
        while (connectionsProcessed < this.connectionQueueSize && !this.newConnections().isEmpty()) {
            SocketChannel channel = this.newConnections().poll();
            try {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Processor ").append(this.id()).append(" listening to new connection from ").append(channel.socket().getRemoteSocketAddress()).toString());
                this.selector().register(this.connectionId(channel.socket()), channel);
                ++connectionsProcessed;
            }
            catch (Throwable e) {
                SocketAddress remoteAddress = channel.socket().getRemoteSocketAddress();
                this.close(this.listenerName, channel);
                this.processException(new StringBuilder(34).append("Processor ").append(this.id()).append(" closed connection from ").append(remoteAddress).toString(), e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void closeAll() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        while (!this.newConnections().isEmpty()) {
            ((AbstractInterruptibleChannel)this.newConnections().poll()).close();
        }
        this.selector().channels().forEach(channel -> this.close(channel.id()));
        this.selector().close();
        Tuple2[] tuple2Array = new Tuple2[1];
        String string = ((Object)BoxesRunTime.boxToInteger((int)this.id())).toString();
        Object object = Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.removeMetric(Processor$.MODULE$.IdlePercentMetricName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))));
    }

    public String connectionId(Socket socket) {
        String localHost = socket.getLocalAddress().getHostAddress();
        int localPort = socket.getLocalPort();
        String remoteHost = socket.getInetAddress().getHostAddress();
        int remotePort = socket.getPort();
        String connId = new ConnectionId(this, localHost, localPort, remoteHost, remotePort, this.nextConnectionIndex()).toString();
        this.nextConnectionIndex_$eq(this.nextConnectionIndex() == Integer.MAX_VALUE ? 0 : this.nextConnectionIndex() + 1);
        return connId;
    }

    public void enqueueResponse(RequestChannel.Response response) {
        this.responseQueue().put(response);
        this.wakeup();
    }

    /*
     * WARNING - void declaration
     */
    private RequestChannel.Response dequeueResponse() {
        void var1_1;
        RequestChannel.Response response = this.responseQueue().poll();
        if (response != null) {
            response.request().responseDequeueTimeNanos_$eq(Time.SYSTEM.nanoseconds());
        }
        return var1_1;
    }

    public int responseQueueSize() {
        return this.responseQueue().size();
    }

    public int inflightResponseCount() {
        return this.inflightResponses().size();
    }

    public Option<KafkaChannel> openOrClosingChannel(String connectionId) {
        Option option = Option$.MODULE$.apply((Object)this.selector().channel(connectionId));
        if (option == null) {
            throw null;
        }
        Option orElse_this = option;
        Option option2 = orElse_this.isEmpty() ? Option$.MODULE$.apply((Object)this.selector().closingChannel(connectionId)) : orElse_this;
        return option2;
    }

    private void handleChannelMuteEvent(String connectionId, KafkaChannel.ChannelMuteEvent event) {
        Option<KafkaChannel> option = this.openOrClosingChannel(connectionId);
        if (option == null) {
            throw null;
        }
        Option<KafkaChannel> foreach_this = option;
        if (!foreach_this.isEmpty()) {
            KafkaChannel kafkaChannel = (KafkaChannel)foreach_this.get();
            kafkaChannel.handleChannelMuteEvent(event);
            return;
        }
    }

    private void tryUnmuteChannel(String connectionId) {
        Option<KafkaChannel> option = this.openOrClosingChannel(connectionId);
        if (option == null) {
            throw null;
        }
        Option<KafkaChannel> foreach_this = option;
        if (!foreach_this.isEmpty()) {
            KafkaChannel kafkaChannel = (KafkaChannel)foreach_this.get();
            Processor.$anonfun$tryUnmuteChannel$1(this, kafkaChannel);
            return;
        }
    }

    public Option<KafkaChannel> channel(String connectionId) {
        return Option$.MODULE$.apply((Object)this.selector().channel(connectionId));
    }

    @Override
    public void wakeup() {
        this.selector().wakeup();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initiateShutdown() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        super.initiateShutdown();
        Tuple2[] tuple2Array = new Tuple2[1];
        String string = ((Object)BoxesRunTime.boxToInteger((int)this.id())).toString();
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"networkProcessor");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.removeMetric("IdlePercent", (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))));
        this.metrics.removeMetric(this.expiredConnectionsKilledCountMetricName());
    }

    private final void ConnectionId$lzycompute$1() {
        synchronized (this) {
            if (this.ConnectionId$module == null) {
                this.ConnectionId$module = new Processor$ConnectionId$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ double $anonfun$new$2() {
        return 0.0;
    }

    public static final /* synthetic */ double $anonfun$new$3(KafkaMetric m) {
        return Math.min(BoxesRunTime.unboxToDouble((Object)m.metricValue()), 1.0);
    }

    public final /* synthetic */ double kafka$network$Processor$$$anonfun$new$1() {
        Option option = Option$.MODULE$.apply((Object)this.metrics.metric(this.metrics.metricName("io-wait-ratio", SocketServer$.MODULE$.MetricsGroup(), this.metricTags())));
        if (option == null) {
            throw null;
        }
        Option fold_this = option;
        double d = fold_this.isEmpty() ? Processor.$anonfun$new$2() : Processor.$anonfun$new$3((KafkaMetric)fold_this.get());
        return d;
    }

    public static final /* synthetic */ Nothing$ $anonfun$processCompletedSends$2(Send send$1) {
        throw new IllegalStateException(new StringBuilder(51).append("Send for ").append(send$1.destination()).append(" completed, but not in `inflightResponses`").toString());
    }

    public static final /* synthetic */ void $anonfun$processCompletedSends$3(Send send$1, Function1 onComplete) {
        onComplete.apply((Object)send$1);
    }

    public static final /* synthetic */ long $anonfun$updateRequestMetrics$1() {
        return 0L;
    }

    public static final /* synthetic */ Nothing$ $anonfun$processDisconnected$2(String connectionId$2) {
        throw new IllegalStateException(new StringBuilder(36).append("connectionId has unexpected format: ").append(connectionId$2).toString());
    }

    public static final /* synthetic */ void $anonfun$close$4(Processor $this, String connectionId$3, KafkaChannel channel) {
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Closing selector connection ").append(connectionId$3).toString());
        InetAddress address = channel.socketAddress();
        if (address != null) {
            $this.connectionQuotas.dec($this.listenerName, address);
        }
        $this.selector().close(connectionId$3);
        Option option = $this.inflightResponses().remove((Object)connectionId$3);
        if (option == null) {
            throw null;
        }
        Option foreach_this = option;
        if (!foreach_this.isEmpty()) {
            RequestChannel.Response response = (RequestChannel.Response)foreach_this.get();
            $this.updateRequestMetrics(response);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$tryUnmuteChannel$1(Processor $this, KafkaChannel c) {
        $this.selector().unmute(c.id());
    }

    /*
     * WARNING - void declaration
     */
    public Processor(int id, Time time, int maxRequestSize, RequestChannel requestChannel, ConnectionQuotas connectionQuotas, long connectionsMaxIdleMs, int failedAuthenticationDelayMs, ListenerName listenerName, SecurityProtocol securityProtocol, KafkaConfig config, Metrics metrics, CredentialProvider credentialProvider, MemoryPool memoryPool, LogContext logContext, int connectionQueueSize) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        this.id = id;
        this.time = time;
        this.maxRequestSize = maxRequestSize;
        this.requestChannel = requestChannel;
        this.connectionQuotas = connectionQuotas;
        this.connectionsMaxIdleMs = connectionsMaxIdleMs;
        this.failedAuthenticationDelayMs = failedAuthenticationDelayMs;
        this.listenerName = listenerName;
        this.securityProtocol = securityProtocol;
        this.config = config;
        this.metrics = metrics;
        this.memoryPool = memoryPool;
        this.logContext = logContext;
        this.connectionQueueSize = connectionQueueSize;
        super(connectionQuotas);
        KafkaMetricsGroup.$init$(this);
        this.newConnections = new ArrayBlockingQueue(connectionQueueSize);
        this.inflightResponses = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.responseQueue = new LinkedBlockingDeque();
        Tuple2[] tuple2Array = new Tuple2[2];
        String string = listenerName.value();
        Object object = Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        String string2 = ((Object)BoxesRunTime.boxToInteger((int)id)).toString();
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        this.metricTags = (java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)LinkedHashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava();
        Tuple2[] tuple2Array2 = new Tuple2[1];
        String string3 = ((Object)BoxesRunTime.boxToInteger((int)id)).toString();
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.newGauge(Processor$.MODULE$.IdlePercentMetricName(), new Gauge<Object>(this){
            private final /* synthetic */ Processor $outer;

            public final double value() {
                return this.$outer.kafka$network$Processor$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))));
        this.expiredConnectionsKilledCount = new CumulativeSum();
        this.expiredConnectionsKilledCountMetricName = metrics.metricName("expired-connections-killed-count", "socket-server-metrics", this.metricTags());
        metrics.addMetric(this.expiredConnectionsKilledCountMetricName(), (Measurable)this.expiredConnectionsKilledCount());
        this.selector = this.createSelector(ChannelBuilders.serverChannelBuilder((ListenerName)listenerName, (listenerName.equals(config.interBrokerListenerName()) ? 1 : 0) != 0, (SecurityProtocol)securityProtocol, (AbstractConfig)config, (CredentialCache)credentialProvider.credentialCache(), (DelegationTokenCache)credentialProvider.tokenCache(), (Time)time, (LogContext)logContext));
        this.nextConnectionIndex = 0;
    }

    public static final /* synthetic */ Object $anonfun$updateRequestMetrics$2$adapted(KafkaChannel x$17) {
        return BoxesRunTime.boxToLong((long)x$17.getAndResetNetworkThreadTimeNanos());
    }

    public static final /* synthetic */ Object $anonfun$close$4$adapted(Processor $this, String connectionId$3, KafkaChannel channel) {
        Processor.$anonfun$close$4($this, connectionId$3, channel);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$handleChannelMuteEvent$1$adapted(KafkaChannel.ChannelMuteEvent event$1, KafkaChannel c) {
        c.handleChannelMuteEvent(event$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$tryUnmuteChannel$1$adapted(Processor $this, KafkaChannel c) {
        Processor.$anonfun$tryUnmuteChannel$1($this, c);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$new$3$adapted(KafkaMetric m) {
        return BoxesRunTime.boxToDouble((double)Processor.$anonfun$new$3(m));
    }

    public static final /* synthetic */ Object $anonfun$processCompletedSends$3$adapted(Send send$1, Function1 onComplete) {
        onComplete.apply((Object)send$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$processDisconnected$3$adapted(Processor $this, RequestChannel.Response response) {
        $this.updateRequestMetrics(response);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$close$6$adapted(Processor $this, RequestChannel.Response response) {
        $this.updateRequestMetrics(response);
        return BoxedUnit.UNIT;
    }

    public class ConnectionId
    implements Product,
    scala.Serializable {
        private final String localHost;
        private final int localPort;
        private final String remoteHost;
        private final int remotePort;
        private final int index;
        public final /* synthetic */ Processor $outer;

        public String localHost() {
            return this.localHost;
        }

        public int localPort() {
            return this.localPort;
        }

        public String remoteHost() {
            return this.remoteHost;
        }

        public int remotePort() {
            return this.remotePort;
        }

        public int index() {
            return this.index;
        }

        public String toString() {
            return new StringBuilder(4).append(this.localHost()).append(":").append(this.localPort()).append("-").append(this.remoteHost()).append(":").append(this.remotePort()).append("-").append(this.index()).toString();
        }

        public ConnectionId copy(String localHost, int localPort, String remoteHost, int remotePort, int index) {
            return new ConnectionId(this.kafka$network$Processor$ConnectionId$$$outer(), localHost, localPort, remoteHost, remotePort, index);
        }

        public String copy$default$1() {
            return this.localHost();
        }

        public int copy$default$2() {
            return this.localPort();
        }

        public String copy$default$3() {
            return this.remoteHost();
        }

        public int copy$default$4() {
            return this.remotePort();
        }

        public int copy$default$5() {
            return this.index();
        }

        public String productPrefix() {
            return "ConnectionId";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.localHost();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.localPort());
                }
                case 2: {
                    return this.remoteHost();
                }
                case 3: {
                    return BoxesRunTime.boxToInteger((int)this.remotePort());
                }
                case 4: {
                    return BoxesRunTime.boxToInteger((int)this.index());
                }
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ConnectionId;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.anyHash((Object)this.localHost())), (int)this.localPort()), (int)Statics.anyHash((Object)this.remoteHost())), (int)this.remotePort()), (int)this.index()), (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof ConnectionId)) return false;
            if (((ConnectionId)x$1).kafka$network$Processor$ConnectionId$$$outer() != this.kafka$network$Processor$ConnectionId$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ConnectionId connectionId = (ConnectionId)x$1;
            String string = this.localHost();
            String string2 = connectionId.localHost();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.localPort() != connectionId.localPort()) return false;
            String string3 = this.remoteHost();
            String string4 = connectionId.remoteHost();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (this.remotePort() != connectionId.remotePort()) return false;
            if (this.index() != connectionId.index()) return false;
            if (!connectionId.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Processor kafka$network$Processor$ConnectionId$$$outer() {
            return this.$outer;
        }

        public ConnectionId(Processor $outer, String localHost, int localPort, String remoteHost, int remotePort, int index) {
            this.localHost = localHost;
            this.localPort = localPort;
            this.remoteHost = remoteHost;
            this.remotePort = remotePort;
            this.index = index;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

