/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.cluster.BrokerEndPoint;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerAndFetcherId;
import kafka.server.BrokerIdAndFetcherId;
import kafka.server.FailedPartitions;
import kafka.server.InitialFetchState;
import kafka.server.PartitionFetchState;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005eg!\u0002\u0010 \u0003\u0003!\u0003\u0002\u0003\u001d\u0001\u0005\u000b\u0007I\u0011A\u001d\t\u0011\u0015\u0003!\u0011!Q\u0001\niB\u0001B\u0012\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\")1\n\u0001C\u0001\u0019\"AQ\f\u0001b\u0001\n\u0003yb\f\u0003\u0004k\u0001\u0001\u0006Ia\u0018\u0005\bW\u0002\u0011\r\u0011\"\u0003m\u0011\u0019)\b\u0001)A\u0005[\"9a\u000f\u0001a\u0001\n\u00139\bb\u0002=\u0001\u0001\u0004%I!\u001f\u0005\u0007\u007f\u0002\u0001\u000b\u0015\u0002%\t\u0013\u0005\u0005\u0001A1A\u0005\u0002\u0005\r\u0001\u0002CA\u0006\u0001\u0001\u0006I!!\u0002\t\u0013\u00055\u0001A1A\u0005\n\u0005=\u0001\u0002CA\u000f\u0001\u0001\u0006I!!\u0005\t\u000f\u0005}\u0001\u0001\"\u0001 o\"9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0002\u0002CA\u0015\u0001\u0011\u0005q$a\u000b\t\u0011\u00055\u0003\u0001\"\u0001 \u0003\u001fBq!a\u0015\u0001\t\u0003\t)\u0006C\u0004\u0002h\u00011\t!!\u001b\t\u000f\u0005}\u0004\u0001\"\u0001\u0002\u0002\"9\u0011q\u0012\u0001\u0005\u0002\u0005E\u0005bBAK\u0001\u0011E\u0011q\u0013\u0005\b\u0003C\u0003A\u0011AAR\u0011\u001d\ti\f\u0001C\u0001\u0003\u007fCq!a5\u0001\t\u0003\t)\u000eC\u0004\u0002X\u0002!\t!!6\u0003-\u0005\u00137\u000f\u001e:bGR4U\r^2iKJl\u0015M\\1hKJT!\u0001I\u0011\u0002\rM,'O^3s\u0015\u0005\u0011\u0013!B6bM.\f7\u0001A\u000b\u0003KE\u001bB\u0001\u0001\u0014-eA\u0011qEK\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\t1\u0011I\\=SK\u001a\u0004\"!\f\u0019\u000e\u00039R!aL\u0011\u0002\u000bU$\u0018\u000e\\:\n\u0005Er#a\u0002'pO\u001eLgn\u001a\t\u0003gYj\u0011\u0001\u000e\u0006\u0003k\u0005\nq!\\3ue&\u001c7/\u0003\u00028i\t\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\u0002\t9\fW.Z\u000b\u0002uA\u00111H\u0011\b\u0003y\u0001\u0003\"!\u0010\u0015\u000e\u0003yR!aP\u0012\u0002\rq\u0012xn\u001c;?\u0013\t\t\u0005&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0007\u0012\u0013aa\u0015;sS:<'BA!)\u0003\u0015q\u0017-\\3!\u0003!\u0019G.[3oi&#\u0017a\u00038v[\u001a+Go\u00195feN\u0004\"aJ%\n\u0005)C#aA%oi\u00061A(\u001b8jiz\"B!\u0014.\\9B\u0019a\nA(\u000e\u0003}\u0001\"\u0001U)\r\u0001\u0011)!\u000b\u0001b\u0001'\n\tA+\u0005\u0002U/B\u0011q%V\u0005\u0003-\"\u0012qAT8uQ&tw\r\u0005\u0002O1&\u0011\u0011l\b\u0002\u0016\u0003\n\u001cHO]1di\u001a+Go\u00195feRC'/Z1e\u0011\u0015AT\u00011\u0001;\u0011\u00151U\u00011\u0001;\u0011\u00159U\u00011\u0001I\u0003A1W\r^2iKJ$\u0006N]3bI6\u000b\u0007/F\u0001`!\u0011\u0001WmZ(\u000e\u0003\u0005T!AY2\u0002\u000f5,H/\u00192mK*\u0011A\rK\u0001\u000bG>dG.Z2uS>t\u0017B\u00014b\u0005\u001dA\u0015m\u001d5NCB\u0004\"A\u00145\n\u0005%|\"\u0001\u0006\"s_.,'/\u00133B]\u00124U\r^2iKJLE-A\tgKR\u001c\u0007.\u001a:UQJ,\u0017\rZ'ba\u0002\nA\u0001\\8dWV\tQ\u000e\u0005\u0002og6\tqN\u0003\u0002qc\u0006!A.\u00198h\u0015\u0005\u0011\u0018\u0001\u00026bm\u0006L!\u0001^8\u0003\r=\u0013'.Z2u\u0003\u0015awnY6!\u0003QqW/\u001c$fi\u000eDWM]:QKJ\u0014%o\\6feV\t\u0001*\u0001\rok64U\r^2iKJ\u001c\b+\u001a:Ce>\\WM]0%KF$\"A_?\u0011\u0005\u001dZ\u0018B\u0001?)\u0005\u0011)f.\u001b;\t\u000fy\\\u0011\u0011!a\u0001\u0011\u0006\u0019\u0001\u0010J\u0019\u0002+9,XNR3uG\",'o\u001d)fe\n\u0013xn[3sA\u0005\u0001b-Y5mK\u0012\u0004\u0016M\u001d;ji&|gn]\u000b\u0003\u0003\u000b\u00012ATA\u0004\u0013\r\tIa\b\u0002\u0011\r\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N\f\u0011CZ1jY\u0016$\u0007+\u0019:uSRLwN\\:!\u0003\u0011!\u0018mZ:\u0016\u0005\u0005E\u0001cBA\n\u0003+\tIBO\u0007\u0002G&\u0019\u0011qC2\u0003\u00075\u000b\u0007\u000fE\u0002o\u00037I!aQ8\u0002\u000bQ\fwm\u001d\u0011\u0002\u001f\u0011,\u0017\r\u001a+ie\u0016\fGmQ8v]R\f\u0001C]3tSj,G\u000b\u001b:fC\u0012\u0004vn\u001c7\u0015\u0007i\f)\u0003\u0003\u0004\u0002(I\u0001\r\u0001S\u0001\b]\u0016<8+\u001b>f\u0003)9W\r\u001e$fi\u000eDWM\u001d\u000b\u0005\u0003[\t\u0019\u0004\u0005\u0003(\u0003_y\u0015bAA\u0019Q\t1q\n\u001d;j_:Dq!!\u000e\u0014\u0001\u0004\t9$\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0011\t\u0005e\u0012\u0011J\u0007\u0003\u0003wQA!!\u0010\u0002@\u000511m\\7n_:T1AIA!\u0015\u0011\t\u0019%!\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t9%A\u0002pe\u001eLA!a\u0013\u0002<\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017\u0001D4fi\u001a+Go\u00195fe&#Gc\u0001%\u0002R!9\u0011Q\u0007\u000bA\u0002\u0005]\u0012aG7be.\u0004\u0016M\u001d;ji&|gn\u001d$peR\u0013XO\\2bi&|g\u000eF\u0004{\u0003/\nY&!\u0018\t\r\u0005eS\u00031\u0001I\u0003!\u0011'o\\6fe&#\u0007bBA\u001b+\u0001\u0007\u0011q\u0007\u0005\b\u0003?*\u0002\u0019AA1\u0003A!(/\u001e8dCRLwN\\(gMN,G\u000fE\u0002(\u0003GJ1!!\u001a)\u0005\u0011auN\\4\u0002'\r\u0014X-\u0019;f\r\u0016$8\r[3s)\"\u0014X-\u00193\u0015\u000b=\u000bY'a\u001c\t\r\u00055d\u00031\u0001I\u0003%1W\r^2iKJLE\rC\u0004\u0002rY\u0001\r!a\u001d\u0002\u0019M|WO]2f\u0005J|7.\u001a:\u0011\t\u0005U\u00141P\u0007\u0003\u0003oR1!!\u001f\"\u0003\u001d\u0019G.^:uKJLA!! \u0002x\tq!I]8lKJ,e\u000e\u001a)pS:$\u0018aF1eI\u001a+Go\u00195fe\u001a{'\u000fU1si&$\u0018n\u001c8t)\rQ\u00181\u0011\u0005\b\u0003\u000b;\u0002\u0019AAD\u0003M\u0001\u0018M\u001d;ji&|g.\u00118e\u001f\u001a47/\u001a;t!!\t\u0019\"!\u0006\u00028\u0005%\u0005c\u0001(\u0002\f&\u0019\u0011QR\u0010\u0003#%s\u0017\u000e^5bY\u001a+Go\u00195Ti\u0006$X-\u0001\nbI\u00124\u0015-\u001b7fIB\u000b'\u000f^5uS>tGc\u0001>\u0002\u0014\"9\u0011Q\u0007\rA\u0002\u0005]\u0012\u0001H1eIB\u000b'\u000f^5uS>t7\u000fV8GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\u000b\u0006u\u0006e\u0015Q\u0014\u0005\u0007\u00037K\u0002\u0019A(\u0002\u001b\u0019,Go\u00195feRC'/Z1e\u0011\u001d\ty*\u0007a\u0001\u0003\u000f\u000ba#\u001b8ji&\fGn\u00144gg\u0016$\u0018I\u001c3Fa>\u001c\u0007n]\u0001\u0014[\u0006L(-Z+qI\u0006$X\rV8qS\u000eLEm\u001d\u000b\u0006u\u0006\u0015\u00161\u0016\u0005\b\u0003OS\u0002\u0019AAU\u0003I\u0001\u0018M\u001d;ji&|gn\u001d+p+B$\u0017\r^3\u0011\u000f\u0005M\u0011QCA\u001c\u0011\"9\u0011Q\u0016\u000eA\u0002\u0005=\u0016\u0001\u0003;pa&\u001c\u0017\nZ:\u0011\r\u001d\n\tLOA[\u0013\r\t\u0019\f\u000b\u0002\n\rVt7\r^5p]F\u0002RaJA\u0018\u0003o\u0003B!!\u000f\u0002:&!\u00111XA\u001e\u0005\u0011)V/\u001b3\u00025I,Wn\u001c<f\r\u0016$8\r[3s\r>\u0014\b+\u0019:uSRLwN\\:\u0015\t\u0005\u0005\u0017\u0011\u001a\t\t\u0003'\t)\"a\u000e\u0002DB\u0019a*!2\n\u0007\u0005\u001dwDA\nQCJ$\u0018\u000e^5p]\u001a+Go\u00195Ti\u0006$X\rC\u0004\u0002Ln\u0001\r!!4\u0002\u0015A\f'\u000f^5uS>t7\u000f\u0005\u0004\u0002\u0014\u0005=\u0017qG\u0005\u0004\u0003#\u001c'aA*fi\u0006Q2\u000f[;uI><h.\u00133mK\u001a+Go\u00195feRC'/Z1egR\t!0\u0001\tdY>\u001cX-\u00117m\r\u0016$8\r[3sg\u0002")
public abstract class AbstractFetcherManager<T extends AbstractFetcherThread>
implements KafkaMetricsGroup {
    private final String name;
    private final HashMap<BrokerIdAndFetcherId, T> fetcherThreadMap;
    private final Object lock;
    private int numFetchersPerBroker;
    private final FailedPartitions failedPartitions;
    private final Map<String, String> tags;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String name() {
        return this.name;
    }

    public HashMap<BrokerIdAndFetcherId, T> fetcherThreadMap() {
        return this.fetcherThreadMap;
    }

    private Object lock() {
        return this.lock;
    }

    private int numFetchersPerBroker() {
        return this.numFetchersPerBroker;
    }

    private void numFetchersPerBroker_$eq(int x$1) {
        this.numFetchersPerBroker = x$1;
    }

    public FailedPartitions failedPartitions() {
        return this.failedPartitions;
    }

    private Map<String, String> tags() {
        return this.tags;
    }

    public int deadThreadCount() {
        Object object = this.lock();
        synchronized (object) {
            int n = this.fetcherThreadMap().values().count((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isThreadFailed()));
            return n;
        }
    }

    public void resizeThreadPool(int newSize) {
        Object object = this.lock();
        synchronized (object) {
            int currentSize = this.numFetchersPerBroker();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Resizing fetcher thread pool size from ").append(currentSize).append(" to ").append(newSize).toString());
            this.numFetchersPerBroker_$eq(newSize);
            if (newSize != currentSize) {
                this.migratePartitions$1(newSize);
            }
            this.shutdownIdleFetcherThreads();
            return;
        }
    }

    public Option<T> getFetcher(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            Option option = this.fetcherThreadMap().values().find((Function1 & Serializable & scala.Serializable)fetcherThread -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$getFetcher$1(topicPartition, fetcherThread)));
            return option;
        }
    }

    public int getFetcherId(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            int n = Utils.abs((int)(31 * topicPartition.topic().hashCode() + topicPartition.partition())) % this.numFetchersPerBroker();
            return n;
        }
    }

    public void markPartitionsForTruncation(int brokerId, TopicPartition topicPartition, long truncationOffset) {
        Object object = this.lock();
        synchronized (object) {
            int fetcherId = this.getFetcherId(topicPartition);
            BrokerIdAndFetcherId brokerIdAndFetcherId = new BrokerIdAndFetcherId(brokerId, fetcherId);
            this.fetcherThreadMap().get((Object)brokerIdAndFetcherId).foreach((Function1 & Serializable & scala.Serializable)thread -> {
                thread.markPartitionsForTruncation(topicPartition, truncationOffset);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public abstract T createFetcherThread(int var1, BrokerEndPoint var2);

    public void addFetcherForPartitions(Map<TopicPartition, InitialFetchState> partitionAndOffsets) {
        Object object = this.lock();
        synchronized (object) {
            partitionAndOffsets.groupBy((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                TopicPartition topicPartition = (TopicPartition)x0$1._1();
                InitialFetchState brokerAndInitialFetchOffset = (InitialFetchState)x0$1._2();
                BrokerAndFetcherId brokerAndFetcherId = new BrokerAndFetcherId(brokerAndInitialFetchOffset.leader(), this.getFetcherId(topicPartition));
                return brokerAndFetcherId;
            }).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                AbstractFetcherManager.$anonfun$addFetcherForPartitions$3(this, x$3);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void addFailedPartition(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            this.failedPartitions().add(topicPartition);
            return;
        }
    }

    public void addPartitionsToFetcherThread(T fetcherThread, Map<TopicPartition, InitialFetchState> initialOffsetAndEpochs) {
        ((AbstractFetcherThread)fetcherThread).addPartitions(initialOffsetAndEpochs);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Added fetcher to broker ").append(fetcherThread.sourceBroker().id()).append(" for partitions ").append(initialOffsetAndEpochs).toString());
    }

    public void maybeUpdateTopicIds(Map<TopicPartition, Object> partitionsToUpdate, Function1<String, Option<Uuid>> topicIds) {
        Object object = this.lock();
        synchronized (object) {
            ((scala.collection.immutable.Map)partitionsToUpdate.groupBy((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                TopicPartition topicPartition = (TopicPartition)x0$1._1();
                int leaderId = x0$1._2$mcI$sp();
                BrokerIdAndFetcherId brokerIdAndFetcherId = new BrokerIdAndFetcherId(leaderId, this.getFetcherId(topicPartition));
                return brokerIdAndFetcherId;
            }).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                if (x0$2 == null) {
                    throw new MatchError(null);
                }
                BrokerIdAndFetcherId brokerAndFetcherId = (BrokerIdAndFetcherId)x0$2._1();
                Map partitionsToUpdate = (Map)x0$2._2();
                Tuple2 tuple2 = new Tuple2((Object)brokerAndFetcherId, (Object)partitionsToUpdate.keySet());
                return tuple2;
            }, scala.collection.immutable.Map$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$2 != null))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                if (x$5 == null) {
                    throw new MatchError(null);
                }
                BrokerIdAndFetcherId $anonfun$maybeUpdateTopicIds$4_brokerIdAndFetcherId = (BrokerIdAndFetcherId)x$5._1();
                Set $anonfun$maybeUpdateTopicIds$4_partitions = (Set)x$5._2();
                this.fetcherThreadMap().get((Object)$anonfun$maybeUpdateTopicIds$4_brokerIdAndFetcherId).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                    x$4.maybeUpdateTopicIds((Set<TopicPartition>)partitions, topicIds);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Map<TopicPartition, PartitionFetchState> removeFetcherForPartitions(Set<TopicPartition> partitions) {
        void var2_2;
        scala.collection.mutable.Map fetchStates = Map$.MODULE$.empty();
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().values().foreach((Function1 & Serializable & scala.Serializable)fetcher -> (scala.collection.mutable.Map)fetchStates.$plus$plus$eq(fetcher.removePartitions(partitions)));
            this.failedPartitions().removeAll(partitions);
        }
        if (partitions.nonEmpty()) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Removed fetcher for partitions ").append(partitions).toString());
        }
        return var2_2;
    }

    public void shutdownIdleFetcherThreads() {
        Object object = this.lock();
        synchronized (object) {
            HashSet keysToBeRemoved = new HashSet();
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$3 != null))).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                BoxedUnit boxedUnit;
                if (x$6 != null) {
                    BrokerIdAndFetcherId key = (BrokerIdAndFetcherId)x$6._1();
                    AbstractFetcherThread fetcher = (AbstractFetcherThread)x$6._2();
                    if (fetcher.partitionCount() <= 0) {
                        fetcher.shutdown();
                        boxedUnit = keysToBeRemoved.$plus$eq((Object)key);
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw new MatchError(null);
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return boxedUnit2;
            });
            HashMap cfr_ignored_0 = (HashMap)this.fetcherThreadMap().$minus$minus$eq((TraversableOnce)keysToBeRemoved);
            return;
        }
    }

    public void closeAllFetchers() {
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$4 != null))).foreach((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$2(x$7)));
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$5 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$5 != null))).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                AbstractFetcherManager.$anonfun$closeAllFetchers$4(x$8);
                return BoxedUnit.UNIT;
            });
            this.fetcherThreadMap().clear();
            return;
        }
    }

    public static final /* synthetic */ long $anonfun$new$2(long curMaxLagAll, AbstractFetcherThread fetcherThread) {
        long maxLagThread = BoxesRunTime.unboxToLong((Object)fetcherThread.fetcherLagStats().stats().values().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(curMaxLagThread, lagMetrics) -> BoxesRunTime.boxToLong((long)scala.math.package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)curMaxLagThread), lagMetrics.lag()))));
        return scala.math.package$.MODULE$.max(curMaxLagAll, maxLagThread);
    }

    public final /* synthetic */ long kafka$server$AbstractFetcherManager$$$anonfun$new$1() {
        return BoxesRunTime.unboxToLong((Object)this.fetcherThreadMap().values().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(curMaxLagAll, fetcherThread) -> BoxesRunTime.boxToLong((long)AbstractFetcherManager.$anonfun$new$2(BoxesRunTime.unboxToLong((Object)curMaxLagAll), fetcherThread))));
    }

    public static final /* synthetic */ double $anonfun$new$5(AbstractFetcherThread x$1) {
        return x$1.fetcherStats().requestRate().oneMinuteRate();
    }

    public final /* synthetic */ double kafka$server$AbstractFetcherManager$$$anonfun$new$4() {
        double headRate = BoxesRunTime.unboxToDouble((Object)this.fetcherThreadMap().values().headOption().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)AbstractFetcherManager.$anonfun$new$5(x$1))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0));
        return BoxesRunTime.unboxToDouble((Object)this.fetcherThreadMap().values().foldLeft((Object)BoxesRunTime.boxToDouble((double)headRate), (Function2 & Serializable & scala.Serializable)(curMinAll, fetcherThread) -> BoxesRunTime.boxToDouble((double)scala.math.package$.MODULE$.min(BoxesRunTime.unboxToDouble((Object)curMinAll), fetcherThread.fetcherStats().requestRate().oneMinuteRate()))));
    }

    public final /* synthetic */ int kafka$server$AbstractFetcherManager$$$anonfun$new$8() {
        return this.failedPartitions().size();
    }

    public final /* synthetic */ int kafka$server$AbstractFetcherManager$$$anonfun$new$9() {
        return this.deadThreadCount();
    }

    public static final /* synthetic */ void $anonfun$resizeThreadPool$1(AbstractFetcherManager $this, int newSize$1, BrokerIdAndFetcherId id, AbstractFetcherThread thread) {
        Map<TopicPartition, PartitionFetchState> partitionStates = $this.removeFetcherForPartitions(thread.partitions());
        if (id.fetcherId() >= newSize$1) {
            thread.shutdown();
        }
        Map fetchStates = (Map)partitionStates.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            PartitionFetchState currentFetchState = (PartitionFetchState)x0$1._2();
            InitialFetchState initialFetchState = new InitialFetchState(currentFetchState.topicId(), thread.sourceBroker(), currentFetchState.currentLeaderEpoch(), currentFetchState.fetchOffset());
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)initialFetchState);
            return tuple2;
        }, scala.collection.Map$.MODULE$.canBuildFrom());
        $this.addFetcherForPartitions((Map<TopicPartition, InitialFetchState>)fetchStates);
    }

    /*
     * WARNING - void declaration
     */
    private final void migratePartitions$1(int newSize) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(id, thread) -> {
            AbstractFetcherManager.$anonfun$resizeThreadPool$1(this, newSize, id, thread);
            return BoxedUnit.UNIT;
        };
        Map<BrokerIdAndFetcherId, T> map = Implicits$.MODULE$.MapExtensionMethods(this.fetcherThreadMap());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
    }

    public static final /* synthetic */ boolean $anonfun$getFetcher$1(TopicPartition topicPartition$1, AbstractFetcherThread fetcherThread) {
        return fetcherThread.fetchState(topicPartition$1).isDefined();
    }

    /*
     * WARNING - void declaration
     */
    private final AbstractFetcherThread addAndStartFetcherThread$1(BrokerAndFetcherId brokerAndFetcherId, BrokerIdAndFetcherId brokerIdAndFetcherId) {
        void var3_3;
        T fetcherThread = this.createFetcherThread(brokerAndFetcherId.fetcherId(), brokerAndFetcherId.broker());
        this.fetcherThreadMap().put((Object)brokerIdAndFetcherId, fetcherThread);
        ((Thread)fetcherThread).start();
        return var3_3;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$addFetcherForPartitions$3(AbstractFetcherManager $this, Tuple2 x$3) {
        block6: {
            if (x$3 == null) break block6;
            brokerAndFetcherId = (BrokerAndFetcherId)x$3._1();
            initialFetchOffsets = (Map)x$3._2();
            brokerIdAndFetcherId = new BrokerIdAndFetcherId(brokerAndFetcherId.broker().id(), brokerAndFetcherId.fetcherId());
            var6_5 = false;
            var7_6 = null;
            var8_7 = $this.fetcherThreadMap().get((Object)brokerIdAndFetcherId);
            if (!(var8_7 instanceof Some)) ** GOTO lbl-1000
            var6_5 = true;
            var7_6 = (Some)var8_7;
            currentFetcherThread = (AbstractFetcherThread)var7_6.value();
            v0 = currentFetcherThread.sourceBroker();
            var10_9 = brokerAndFetcherId.broker();
            if (!(v0 != null ? v0.equals(var10_9) == false : var10_9 != null)) {
                var2_10 = currentFetcherThread;
            } else if (var6_5) {
                ((AbstractFetcherThread)var7_6.value()).shutdown();
                var2_10 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, brokerIdAndFetcherId);
            } else if (None$.MODULE$.equals(var8_7)) {
                var2_10 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, brokerIdAndFetcherId);
            } else {
                throw new MatchError((Object)var8_7);
            }
            $this.addPartitionsToFetcherThread(var2_10, (Map<TopicPartition, InitialFetchState>)initialFetchOffsets);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$maybeUpdateTopicIds$5(Set partitions$1, Function1 topicIds$1, AbstractFetcherThread x$4) {
        x$4.maybeUpdateTopicIds((Set<TopicPartition>)partitions$1, (Function1<String, Option<Uuid>>)topicIds$1);
    }

    public static final /* synthetic */ void $anonfun$maybeUpdateTopicIds$4(AbstractFetcherManager $this, Function1 topicIds$1, Tuple2 x$5) {
        if (x$5 != null) {
            BrokerIdAndFetcherId brokerIdAndFetcherId = (BrokerIdAndFetcherId)x$5._1();
            Set partitions = (Set)x$5._2();
            $this.fetcherThreadMap().get((Object)brokerIdAndFetcherId).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.maybeUpdateTopicIds((Set<TopicPartition>)partitions, topicIds);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$2(Tuple2 x$7) {
        if (x$7 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((AbstractFetcherThread)x$7._2()).initiateShutdown();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$closeAllFetchers$4(Tuple2 x$8) {
        if (x$8 != null) {
            ((AbstractFetcherThread)x$8._2()).shutdown();
            return;
        }
        throw new MatchError(null);
    }

    public AbstractFetcherManager(String name, String clientId, int numFetchers) {
        this.name = name;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.fetcherThreadMap = new HashMap();
        this.lock = new Object();
        this.numFetchersPerBroker = numFetchers;
        this.failedPartitions = new FailedPartitions();
        this.logIdent_$eq(new StringBuilder(3).append("[").append(name).append("] ").toString());
        this.tags = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clientId"), (Object)clientId)}));
        this.newGauge("MaxLag", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final long value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.tags());
        this.newGauge("MinFetchRate", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final double value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$4();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.tags());
        this.newGauge("FailedPartitionsCount", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final int value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$8();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.tags());
        this.newGauge("DeadThreadCount", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final int value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$9();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.tags());
    }
}

