/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import kafka.log.UnifiedLog$;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.KafkaNetworkChannel;
import kafka.raft.KafkaRaftManager$;
import kafka.raft.MetadataLogConfig$;
import kafka.raft.RaftManager;
import kafka.raft.TimingWheelExpirationService;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer;
import kafka.server.KafkaRaftServer$ControllerRole$;
import kafka.server.MetaProperties;
import kafka.utils.CoreUtils$;
import kafka.utils.FileLock;
import kafka.utils.Logging;
import kafka.utils.timer.SystemTimer;
import kafka.utils.timer.SystemTimer$;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.ExpirationService;
import org.apache.kafka.raft.FileBasedStateStore;
import org.apache.kafka.raft.KafkaRaftClient;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.NetworkChannel;
import org.apache.kafka.raft.QuorumStateStore;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.raft.RaftRequest;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.server.util.ShutdownableThread;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rer!\u0002 @\u0011\u0003!e!\u0002$@\u0011\u00039\u0005\"\u0002(\u0002\t\u0003ye\u0001\u0002)\u0002\u0001EC\u0001\"Z\u0002\u0003\u0002\u0003\u0006IA\u001a\u0005\to\u000e\u0011\t\u0011)A\u0005q\"Q\u0011qA\u0002\u0003\u0002\u0003\u0006I!!\u0003\t\r9\u001bA\u0011AA\u000b\u0011\u001d\tIc\u0001C!\u0003WAq!a\r\u0004\t\u0003\n)\u0004C\u0004\u0002>\r!\t%!\u000e\t\u000f\u0005}\u0012\u0001\"\u0003\u0002B!9\u00111L\u0001\u0005\n\u0005uc!\u0002$@\u0001\u0005%\u0004BCA=\u001b\t\u0005\t\u0015!\u0003\u0002|!Q\u0011QQ\u0007\u0003\u0002\u0003\u0006I!a\"\t\u0015\u00055UB!A!\u0002\u0013\ty\t\u0003\u0006\u0002 6\u0011\t\u0011)A\u0005\u0003CC!\"a+\u000e\u0005\u0003\u0005\u000b\u0011BAW\u0011)\t\u0019,\u0004B\u0001B\u0003%\u0011Q\u0017\u0005\u000b\u0003\u007fk!\u0011!Q\u0001\n\u0005\u0005\u0007BCAf\u001b\t\u0005\t\u0015!\u0003\u0002N\"Q\u00111[\u0007\u0003\u0006\u0004%\t!!6\t\u0015\t]QB!A!\u0002\u0013\t9\u000e\u0003\u0006\u0002\b5\u0011\t\u0011)A\u0005\u0003\u0013AaAT\u0007\u0005\u0002\te\u0001\"\u0003B\u0019\u001b\t\u0007I\u0011\u0001B\u001a\u0011!\u0011\t%\u0004Q\u0001\n\tU\u0002\"\u0003B\"\u001b\t\u0007I\u0011\u0002B#\u0011!\u0011i%\u0004Q\u0001\n\t\u001d\u0003\u0002C<\u000e\u0005\u0004%IAa\u0014\t\u000f\tES\u0002)A\u0005q\"I!1K\u0007C\u0002\u0013%!Q\u000b\u0005\t\u0005;j\u0001\u0015!\u0003\u0003X!I!qL\u0007C\u0002\u0013%!\u0011\r\u0005\t\u0005Sj\u0001\u0015!\u0003\u0003d!I\u0011qM\u0007C\u0002\u0013%!1\u000e\u0005\t\u0005[j\u0001\u0015!\u0003\u0002D!I!qN\u0007C\u0002\u0013%!\u0011\u000f\u0005\t\u0005kj\u0001\u0015!\u0003\u0003t!I!qO\u0007C\u0002\u0013\u0005#\u0011\u0010\u0005\t\u0005\u0003k\u0001\u0015!\u0003\u0003|!I!1Q\u0007C\u0002\u0013%!Q\u0011\u0005\t\u0005\u001bk\u0001\u0015!\u0003\u0003\b\"I!qR\u0007C\u0002\u0013%!\u0011\u0013\u0005\t\u0005?k\u0001\u0015!\u0003\u0003\u0014\"I!\u0011U\u0007C\u0002\u0013%!1\u0015\u0005\t\u0005Wk\u0001\u0015!\u0003\u0003&\"AQ-\u0004b\u0001\n\u0003\u0012i\u000b\u0003\u0005\u000326\u0001\u000b\u0011\u0002BX\u0011%\u0011\u0019,\u0004b\u0001\n\u0013\u0011)\f\u0003\u0005\u0003D6\u0001\u000b\u0011\u0002B\\\u0011\u001d\u0011)-\u0004C\u0001\u0003WAqAa2\u000e\t\u0003\tY\u0003C\u0004\u0003J6!\tEa3\t\u000f\t}W\u0002\"\u0011\u0003b\"91qB\u0007\u0005\n\rE\u0001bBB\n\u001b\u0011%1Q\u0003\u0005\b\u0007/iA\u0011BB\r\u0011\u001d\u0019Y\"\u0004C\u0005\u0007;Aqa!\n\u000e\t\u0013\u00199\u0003C\u0004\u000405!\te!\r\u0002!-\u000bgm[1SC\u001a$X*\u00198bO\u0016\u0014(B\u0001!B\u0003\u0011\u0011\u0018M\u001a;\u000b\u0003\t\u000bQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002F\u00035\tqH\u0001\tLC\u001a\\\u0017MU1gi6\u000bg.Y4feN\u0011\u0011\u0001\u0013\t\u0003\u00132k\u0011A\u0013\u0006\u0002\u0017\u0006)1oY1mC&\u0011QJ\u0013\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005!%\u0001\u0004*bMRLu\u000e\u00165sK\u0006$7cA\u0002S?B\u00111+X\u0007\u0002)*\u0011QKV\u0001\u0005kRLGN\u0003\u0002X1\u000611/\u001a:wKJT!AQ-\u000b\u0005i[\u0016AB1qC\u000eDWMC\u0001]\u0003\ry'oZ\u0005\u0003=R\u0013!c\u00155vi\u0012|wO\\1cY\u0016$\u0006N]3bIB\u0011\u0001mY\u0007\u0002C*\u0011!-Q\u0001\u0006kRLGn]\u0005\u0003I\u0006\u0014q\u0001T8hO&tw-\u0001\u0004dY&,g\u000e\u001e\u0019\u0003O:\u00042\u0001\u001b6m\u001b\u0005I'B\u0001!Y\u0013\tY\u0017NA\bLC\u001a\\\u0017MU1gi\u000ec\u0017.\u001a8u!\tig\u000e\u0004\u0001\u0005\u0013=$\u0011\u0011!A\u0001\u0006\u0003\u0001(aA0%cE\u0011\u0011\u000f\u001e\t\u0003\u0013JL!a\u001d&\u0003\u000f9{G\u000f[5oOB\u0011\u0011*^\u0005\u0003m*\u00131!\u00118z\u0003A!\bN]3bI:\u000bW.\u001a)sK\u001aL\u0007\u0010E\u0002z\u0003\u0003q!A\u001f@\u0011\u0005mTU\"\u0001?\u000b\u0005u\u001c\u0015A\u0002\u001fs_>$h(\u0003\u0002\u0000\u0015\u00061\u0001K]3eK\u001aLA!a\u0001\u0002\u0006\t11\u000b\u001e:j]\u001eT!a &\u0002#\u0019\fG/\u00197GCVdG\u000fS1oI2,'\u000f\u0005\u0003\u0002\f\u0005EQBAA\u0007\u0015\r\tyAV\u0001\u0006M\u0006,H\u000e^\u0005\u0005\u0003'\tiA\u0001\u0007GCVdG\u000fS1oI2,'\u000f\u0006\u0005\u0002\u0018\u0005m\u0011QEA\u0014!\r\tIbA\u0007\u0002\u0003!1Qm\u0002a\u0001\u0003;\u0001D!a\b\u0002$A!\u0001N[A\u0011!\ri\u00171\u0005\u0003\u000b_\u0006m\u0011\u0011!A\u0001\u0006\u0003\u0001\b\"B<\b\u0001\u0004A\bbBA\u0004\u000f\u0001\u0007\u0011\u0011B\u0001\u0007I><vN]6\u0015\u0005\u00055\u0002cA%\u00020%\u0019\u0011\u0011\u0007&\u0003\tUs\u0017\u000e^\u0001\u0011S:LG/[1uKNCW\u000f\u001e3po:$\"!a\u000e\u0011\u0007%\u000bI$C\u0002\u0002<)\u0013qAQ8pY\u0016\fg.A\u0005jgJ+hN\\5oO\u0006\u00112M]3bi\u0016dun\u001a#je\u0016\u001cGo\u001c:z)\u0019\t\u0019%a\u0015\u0002XA!\u0011QIA(\u001b\t\t9E\u0003\u0003\u0002J\u0005-\u0013AA5p\u0015\t\ti%\u0001\u0003kCZ\f\u0017\u0002BA)\u0003\u000f\u0012AAR5mK\"9\u0011QK\u0006A\u0002\u0005\r\u0013A\u00027pO\u0012K'\u000f\u0003\u0004\u0002Z-\u0001\r\u0001_\u0001\u000bY><G)\u001b:OC6,\u0017a\u00037pG.$\u0015\r^1ESJ$B!a\u0018\u0002fA\u0019\u0001-!\u0019\n\u0007\u0005\r\u0014M\u0001\u0005GS2,Gj\\2l\u0011\u001d\t9\u0007\u0004a\u0001\u0003\u0007\nq\u0001Z1uC\u0012K'/\u0006\u0003\u0002l\u0005U4#B\u0007I\u0003[z\u0006#B#\u0002p\u0005M\u0014bAA9\u007f\tY!+\u00194u\u001b\u0006t\u0017mZ3s!\ri\u0017Q\u000f\u0003\u0007\u0003oj!\u0019\u00019\u0003\u0003Q\u000ba\"\\3uCB\u0013x\u000e]3si&,7\u000f\u0005\u0003\u0002~\u0005\u0005UBAA@\u0015\t9\u0016)\u0003\u0003\u0002\u0004\u0006}$AD'fi\u0006\u0004&o\u001c9feRLWm]\u0001\u0007G>tg-[4\u0011\t\u0005u\u0014\u0011R\u0005\u0005\u0003\u0017\u000byHA\u0006LC\u001a\\\u0017mQ8oM&<\u0017a\u0003:fG>\u0014HmU3sI\u0016\u0004b!!%\u0002\u001c\u0006MTBAAJ\u0015\u0011\t)*a&\u0002\u001bM,'/[1mSj\fG/[8o\u0015\r\tIJV\u0001\u0007G>lWn\u001c8\n\t\u0005u\u00151\u0013\u0002\f%\u0016\u001cwN\u001d3TKJ$W-\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0011\t\u0005\r\u0016qU\u0007\u0003\u0003KS1!!'Y\u0013\u0011\tI+!*\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u00069Ao\u001c9jG&#\u0007\u0003BAR\u0003_KA!!-\u0002&\n!Q+^5e\u0003\u0011!\u0018.\\3\u0011\t\u0005]\u00161X\u0007\u0003\u0003sS1AYAS\u0013\u0011\ti,!/\u0003\tQKW.Z\u0001\b[\u0016$(/[2t!\u0011\t\u0019-a2\u000e\u0005\u0005\u0015'\u0002BA`\u0003KKA!!3\u0002F\n9Q*\u001a;sS\u000e\u001c\u0018a\u0005;ie\u0016\fGMT1nKB\u0013XMZ5y\u001fB$\b\u0003B%\u0002PbL1!!5K\u0005\u0019y\u0005\u000f^5p]\u0006a2m\u001c8ue>dG.\u001a:Rk>\u0014X/\u001c,pi\u0016\u00148OR;ukJ,WCAAl!\u0019\tI.!9\u0002f6\u0011\u00111\u001c\u0006\u0005\u0003;\fy.\u0001\u0006d_:\u001cWO\u001d:f]RT1!VA&\u0013\u0011\t\u0019/a7\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X\r\u0005\u0005\u0002h\u0006%\u0018Q^A}\u001b\t\ty.\u0003\u0003\u0002l\u0006}'aA'baB!\u0011q^A{\u001b\t\t\tP\u0003\u0003\u0002t\u0006-\u0013\u0001\u00027b]\u001eLA!a>\u0002r\n9\u0011J\u001c;fO\u0016\u0014\b\u0003BA~\u0005#qA!!@\u0003\u000e9!\u0011q B\u0006\u001d\u0011\u0011\tA!\u0003\u000f\t\t\r!q\u0001\b\u0004w\n\u0015\u0011\"\u0001/\n\u0005i[\u0016B\u0001\"Z\u0013\t\u0001\u0005,C\u0002\u0003\u0010%\f!BU1gi\u000e{gNZ5h\u0013\u0011\u0011\u0019B!\u0006\u0003\u0017\u0005#GM]3tgN\u0003Xm\u0019\u0006\u0004\u0005\u001fI\u0017!H2p]R\u0014x\u000e\u001c7feF+xN];n->$XM]:GkR,(/\u001a\u0011\u0015-\tm!Q\u0004B\u0010\u0005C\u0011\u0019C!\n\u0003(\t%\"1\u0006B\u0017\u0005_\u0001B!R\u0007\u0002t!9\u0011\u0011P\rA\u0002\u0005m\u0004bBAC3\u0001\u0007\u0011q\u0011\u0005\b\u0003\u001bK\u0002\u0019AAH\u0011\u001d\ty*\u0007a\u0001\u0003CCq!a+\u001a\u0001\u0004\ti\u000bC\u0004\u00024f\u0001\r!!.\t\u000f\u0005}\u0016\u00041\u0001\u0002B\"9\u00111Z\rA\u0002\u00055\u0007bBAj3\u0001\u0007\u0011q\u001b\u0005\b\u0003\u000fI\u0002\u0019AA\u0005\u0003-\t\u0007/\u001b,feNLwN\\:\u0016\u0005\tU\u0002\u0003\u0002B\u001c\u0005{i!A!\u000f\u000b\u0007\tm\u0002,A\u0004dY&,g\u000e^:\n\t\t}\"\u0011\b\u0002\f\u0003BLg+\u001a:tS>t7/\u0001\u0007ba&4VM]:j_:\u001c\b%\u0001\u0006sC\u001a$8i\u001c8gS\u001e,\"Aa\u0012\u0011\u0007!\u0014I%C\u0002\u0003L%\u0014!BU1gi\u000e{gNZ5h\u0003-\u0011\u0018M\u001a;D_:4\u0017n\u001a\u0011\u0016\u0003a\f\u0011\u0003\u001e5sK\u0006$g*Y7f!J,g-\u001b=!\u0003)awnZ\"p]R,\u0007\u0010^\u000b\u0003\u0005/\u0002B!a.\u0003Z%!!1LA]\u0005)aunZ\"p]R,\u0007\u0010^\u0001\fY><7i\u001c8uKb$\b%A\u0005tG\",G-\u001e7feV\u0011!1\r\t\u0004'\n\u0015\u0014b\u0001B4)\nq1*\u00194lCN\u001b\u0007.\u001a3vY\u0016\u0014\u0018AC:dQ\u0016$W\u000f\\3sAU\u0011\u00111I\u0001\tI\u0006$\u0018\rR5sA\u0005YA-\u0019;b\t&\u0014Hj\\2l+\t\u0011\u0019\bE\u0003J\u0003\u001f\fy&\u0001\u0007eCR\fG)\u001b:M_\u000e\\\u0007%A\u0007sKBd\u0017nY1uK\u0012dunZ\u000b\u0003\u0005w\u00022\u0001\u001bB?\u0013\r\u0011y(\u001b\u0002\u000e%\u0016\u0004H.[2bi\u0016$Gj\\4\u0002\u001dI,\u0007\u000f\\5dCR,G\rT8hA\u0005Qa.\u001a;DQ\u0006tg.\u001a7\u0016\u0005\t\u001d\u0005cA#\u0003\n&\u0019!1R \u0003'-\u000bgm[1OKR<xN]6DQ\u0006tg.\u001a7\u0002\u00179,Go\u00115b]:,G\u000eI\u0001\u0010Kb\u0004\u0018N]1uS>tG+[7feV\u0011!1\u0013\t\u0005\u0005+\u0013Y*\u0004\u0002\u0003\u0018*\u0019!\u0011T1\u0002\u000bQLW.\u001a:\n\t\tu%q\u0013\u0002\f'f\u001cH/Z7US6,'/\u0001\tfqBL'/\u0019;j_:$\u0016.\\3sA\u0005\tR\r\u001f9je\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0016\u0005\t\u0015\u0006cA#\u0003(&\u0019!\u0011V \u00039QKW.\u001b8h/\",W\r\\#ya&\u0014\u0018\r^5p]N+'O^5dK\u0006\u0011R\r\u001f9je\u0006$\u0018n\u001c8TKJ4\u0018nY3!+\t\u0011y\u000b\u0005\u0003iU\u0006M\u0014aB2mS\u0016tG\u000fI\u0001\re\u00064G/S8UQJ,\u0017\rZ\u000b\u0003\u0005o\u00032A!/\u0004\u001d\r\u0011Y\f\u0001\b\u0005\u0005{\u0013\tMD\u0002|\u0005\u007fK\u0011AQ\u0005\u0003\u0001\u0006\u000bQB]1gi&{G\u000b\u001b:fC\u0012\u0004\u0013aB:uCJ$X\u000f]\u0001\tg\",H\u000fZ8x]\u0006A!/Z4jgR,'\u000f\u0006\u0003\u0002.\t5\u0007b\u0002Bhm\u0001\u0007!\u0011[\u0001\tY&\u001cH/\u001a8feB1!1\u001bBm\u0003gr1\u0001\u001bBk\u0013\r\u00119.[\u0001\u000b%\u00064Go\u00117jK:$\u0018\u0002\u0002Bn\u0005;\u0014\u0001\u0002T5ti\u0016tWM\u001d\u0006\u0004\u0005/L\u0017!\u00045b]\u0012dWMU3rk\u0016\u001cH\u000f\u0006\u0005\u0003d\nE8\u0011AB\u0003!\u0019\tI.!9\u0003fB!!q\u001dBw\u001b\t\u0011IO\u0003\u0003\u0003l\u0006\u0015\u0016\u0001\u00039s_R|7m\u001c7\n\t\t=(\u0011\u001e\u0002\u000b\u0003BLW*Z:tC\u001e,\u0007b\u0002Bzo\u0001\u0007!Q_\u0001\u0007Q\u0016\fG-\u001a:\u0011\t\t](Q`\u0007\u0003\u0005sTAAa?\u0002&\u0006A!/Z9vKN$8/\u0003\u0003\u0003\u0000\ne(!\u0004*fcV,7\u000f\u001e%fC\u0012,'\u000fC\u0004\u0004\u0004]\u0002\rA!:\u0002\u000fI,\u0017/^3ti\"91qA\u001cA\u0002\r%\u0011!D2sK\u0006$X\r\u001a+j[\u0016l5\u000fE\u0002J\u0007\u0017I1a!\u0004K\u0005\u0011auN\\4\u0002\u001f\t,\u0018\u000e\u001c3SC\u001a$8\t\\5f]R$\"Aa,\u0002'\t,\u0018\u000e\u001c3OKR<xN]6DQ\u0006tg.\u001a7\u0015\u0005\t\u001d\u0015!D2sK\u0006$X\rR1uC\u0012K'\u000f\u0006\u0002\u0002D\u0005\u0001\"-^5mI6+G/\u00193bi\u0006dun\u001a\u000b\u0003\u0007?\u00012!RB\u0011\u0013\r\u0019\u0019c\u0010\u0002\u0011\u0017\u000647.Y'fi\u0006$\u0017\r^1M_\u001e\f!CY;jY\u0012tU\r^<pe.\u001cE.[3oiR\u00111\u0011\u0006\t\u0005\u0005o\u0019Y#\u0003\u0003\u0004.\te\"!\u0004(fi^|'o[\"mS\u0016tG/\u0001\bmK\u0006$WM]!oI\u0016\u0003xn\u00195\u0016\u0005\rM\u0002c\u00015\u00046%\u00191qG5\u0003\u001d1+\u0017\rZ3s\u0003:$W\t]8dQ\u0002")
public class KafkaRaftManager<T>
implements RaftManager<T>,
Logging {
    private final MetaProperties metaProperties;
    private final KafkaConfig config;
    private final RecordSerde<T> recordSerde;
    private final TopicPartition topicPartition;
    private final Uuid topicId;
    private final Time time;
    private final Metrics metrics;
    private final CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final ApiVersions apiVersions;
    private final RaftConfig raftConfig;
    private final String threadNamePrefix;
    private final LogContext logContext;
    private final KafkaScheduler scheduler;
    private final File dataDir;
    private final Option<FileLock> dataDirLock;
    private final ReplicatedLog replicatedLog;
    private final KafkaNetworkChannel netChannel;
    private final SystemTimer expirationTimer;
    private final TimingWheelExpirationService expirationService;
    private final KafkaRaftClient<T> client;
    private final RaftIoThread raftIoThread;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    public ApiVersions apiVersions() {
        return this.apiVersions;
    }

    private RaftConfig raftConfig() {
        return this.raftConfig;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private File dataDir() {
        return this.dataDir;
    }

    private Option<FileLock> dataDirLock() {
        return this.dataDirLock;
    }

    @Override
    public ReplicatedLog replicatedLog() {
        return this.replicatedLog;
    }

    private KafkaNetworkChannel netChannel() {
        return this.netChannel;
    }

    private SystemTimer expirationTimer() {
        return this.expirationTimer;
    }

    private TimingWheelExpirationService expirationService() {
        return this.expirationService;
    }

    @Override
    public KafkaRaftClient<T> client() {
        return this.client;
    }

    private RaftIoThread raftIoThread() {
        return this.raftIoThread;
    }

    public void startup() {
        java.util.Map<Integer, RaftConfig.AddressSpec> voterAddresses = this.controllerQuorumVotersFuture().get();
        ((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter(voterAddresses.entrySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)voterAddressEntry -> {
            KafkaRaftManager.$anonfun$startup$1(this, voterAddressEntry);
            return BoxedUnit.UNIT;
        });
        this.netChannel().start();
        this.raftIoThread().start();
    }

    public void shutdown() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.expirationService().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.expirationTimer().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.raftIoThread().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.client().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.scheduler().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.netChannel().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.replicatedLog().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.dataDirLock().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.destroy();
            return BoxedUnit.UNIT;
        }), this, CoreUtils$.MODULE$.swallow$default$3());
    }

    @Override
    public void register(RaftClient.Listener<T> listener) {
        this.client().register(listener);
    }

    @Override
    public CompletableFuture<ApiMessage> handleRequest(RequestHeader header, ApiMessage request, long createdTimeMs) {
        RaftRequest.Inbound inboundRequest = new RaftRequest.Inbound(header.correlationId(), request, createdTimeMs);
        this.client().handle(inboundRequest);
        return inboundRequest.completion.thenApply(response -> response.data());
    }

    /*
     * WARNING - void declaration
     */
    private KafkaRaftClient<T> buildRaftClient() {
        void var3_3;
        FileBasedStateStore quorumStateStore = new FileBasedStateStore(new File(this.dataDir(), "quorum-state"));
        OptionalInt nodeId = OptionalInt.of(this.config.nodeId());
        KafkaRaftClient client = new KafkaRaftClient(this.recordSerde, (NetworkChannel)this.netChannel(), this.replicatedLog(), (QuorumStateStore)quorumStateStore, this.time, this.metrics, (ExpirationService)this.expirationService(), this.logContext(), this.metaProperties.clusterId(), nodeId, this.raftConfig());
        client.initialize();
        return var3_3;
    }

    private KafkaNetworkChannel buildNetworkChannel() {
        NetworkClient netClient = this.buildNetworkClient();
        return new KafkaNetworkChannel(this.time, (KafkaClient)netClient, Predef$.MODULE$.Integer2int(this.config.quorumRequestTimeoutMs()), this.threadNamePrefix());
    }

    private File createDataDir() {
        String logDirName = UnifiedLog$.MODULE$.logDirName(this.topicPartition);
        return KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$createLogDirectory(new File(this.config.metadataLogDir()), logDirName);
    }

    private KafkaMetadataLog buildMetadataLog() {
        return KafkaMetadataLog$.MODULE$.apply(this.topicPartition, this.topicId, this.dataDir(), this.recordSerde, this.time, (Scheduler)this.scheduler(), MetadataLogConfig$.MODULE$.apply(this.config, 0x800000, 0x800000));
    }

    private NetworkClient buildNetworkClient() {
        ListenerName controllerListenerName = new ListenerName((String)this.config.controllerListenerNames().head());
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)((SecurityProtocol)this.config.effectiveListenerSecurityProtocolMap().getOrElse((Object)controllerListenerName, (Function0 & Serializable & scala.Serializable)() -> SecurityProtocol.forName((String)controllerListenerName.value()))), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)this.config, (ListenerName)controllerListenerName, (String)this.config.saslMechanismControllerProtocol(), (Time)this.time, (boolean)this.config.saslInterBrokerHandshakeRequestEnable(), (LogContext)this.logContext());
        String metricGroupPrefix = "raft-channel";
        boolean collectPerConnectionMetrics = false;
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(this.config.connectionsMaxIdleMs()), this.metrics, this.time, metricGroupPrefix, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava(), collectPerConnectionMetrics, channelBuilder, this.logContext());
        String clientId = new StringBuilder(12).append("raft-client-").append(this.config.nodeId()).toString();
        int maxInflightRequestsPerConnection = 1;
        int reconnectBackoffMs = 50;
        int reconnectBackoffMsMs = 500;
        boolean discoverBrokerVersions = true;
        return new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), clientId, maxInflightRequestsPerConnection, (long)reconnectBackoffMs, (long)reconnectBackoffMsMs, -1, Predef$.MODULE$.Integer2int(this.config.socketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(this.config.quorumRequestTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), this.time, discoverBrokerVersions, this.apiVersions(), this.logContext());
    }

    @Override
    public LeaderAndEpoch leaderAndEpoch() {
        return this.client().leaderAndEpoch();
    }

    public static final /* synthetic */ void $anonfun$startup$1(KafkaRaftManager $this, Map.Entry voterAddressEntry) {
        RaftConfig.AddressSpec addressSpec = (RaftConfig.AddressSpec)voterAddressEntry.getValue();
        if (addressSpec instanceof RaftConfig.InetAddressSpec) {
            RaftConfig.InetAddressSpec inetAddressSpec = (RaftConfig.InetAddressSpec)addressSpec;
            $this.netChannel().updateEndpoint(Predef$.MODULE$.Integer2int((Integer)voterAddressEntry.getKey()), inetAddressSpec);
            return;
        }
        if (addressSpec instanceof RaftConfig.UnknownAddressSpec) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("Skipping channel update for destination ID: ").append(voterAddressEntry.getKey()).append(" ").append("because of non-routable endpoint: ").append(RaftConfig.NON_ROUTABLE_ADDRESS.toString()).toString());
            return;
        }
        if (addressSpec != null) {
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Unexpected address spec (type: ").append(addressSpec.getClass()).append(") for channel update for ").append("destination ID: ").append(voterAddressEntry.getKey()).toString());
            return;
        }
        throw new MatchError(null);
    }

    public KafkaRaftManager(MetaProperties metaProperties, KafkaConfig config, RecordSerde<T> recordSerde, TopicPartition topicPartition, Uuid topicId, Time time, Metrics metrics, Option<String> threadNamePrefixOpt, CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture, FaultHandler fatalFaultHandler) {
        this.metaProperties = metaProperties;
        this.config = config;
        this.recordSerde = recordSerde;
        this.topicPartition = topicPartition;
        this.topicId = topicId;
        this.time = time;
        this.metrics = metrics;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        Logging.$init$(this);
        this.apiVersions = new ApiVersions();
        this.raftConfig = new RaftConfig((AbstractConfig)config);
        this.threadNamePrefix = (String)threadNamePrefixOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> "kafka-raft");
        this.logContext = new LogContext(new StringBuilder(18).append("[RaftManager id=").append(config.nodeId()).append("] ").toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.scheduler = new KafkaScheduler(1, true, new StringBuilder(10).append(this.threadNamePrefix()).append("-scheduler").toString());
        this.scheduler().startup();
        this.dataDir = this.createDataDir();
        boolean differentMetadataLogDir = !((SeqLike)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$2 -> Paths.get(x$2, new String[0]).toAbsolutePath(), Seq$.MODULE$.canBuildFrom())).contains((Object)Paths.get(config.metadataLogDir(), new String[0]).toAbsolutePath());
        Set<KafkaRaftServer.ProcessRole> set = config.processRoles();
        GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaRaftServer$ControllerRole$[]{KafkaRaftServer$ControllerRole$.MODULE$}));
        boolean isOnlyController = !(set != null ? !set.equals((Object)genTraversable) : genTraversable != null);
        this.dataDirLock = differentMetadataLogDir || isOnlyController ? new Some((Object)KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$lockDataDir(new File(config.metadataLogDir()))) : None$.MODULE$;
        this.replicatedLog = this.buildMetadataLog();
        this.netChannel = this.buildNetworkChannel();
        this.expirationTimer = new SystemTimer("raft-expiration-executor", SystemTimer$.MODULE$.$lessinit$greater$default$2(), SystemTimer$.MODULE$.$lessinit$greater$default$3(), SystemTimer$.MODULE$.$lessinit$greater$default$4());
        this.expirationService = new TimingWheelExpirationService(this.expirationTimer());
        this.client = this.buildRaftClient();
        this.raftIoThread = new RaftIoThread(this.client(), this.threadNamePrefix(), fatalFaultHandler);
    }

    public static class RaftIoThread
    extends ShutdownableThread
    implements Logging {
        private final KafkaRaftClient<?> client;
        private final FaultHandler fatalFaultHandler;
        private Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return Logging.loggerName$(this);
        }

        @Override
        public String msgWithLogIdent(String msg) {
            return Logging.msgWithLogIdent$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        private Logger logger$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        public void doWork() {
            try {
                this.client.poll();
                return;
            }
            catch (Throwable t) {
                throw this.fatalFaultHandler.handleFault("Unexpected error in raft IO thread", t);
            }
        }

        public boolean initiateShutdown() {
            if (super.initiateShutdown()) {
                this.client.shutdown(5000).whenComplete((x$1, exception) -> {
                    if (exception != null) {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Graceful shutdown of RaftClient failed", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> exception);
                        return;
                    }
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Completed graceful shutdown of RaftClient");
                });
                return true;
            }
            return false;
        }

        public boolean isRunning() {
            return this.client.isRunning() && !this.isThreadFailed();
        }

        public RaftIoThread(KafkaRaftClient<?> client, String threadNamePrefix, FaultHandler fatalFaultHandler) {
            this.client = client;
            this.fatalFaultHandler = fatalFaultHandler;
            super(new StringBuilder(10).append(threadNamePrefix).append("-io-thread").toString(), false);
            Logging.$init$(this);
            this.logIdent_$eq(this.logPrefix);
        }
    }
}

