/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.BrokerToControllerQueueItem;
import kafka.server.BrokerToControllerRequestThread;
import kafka.server.ControllerInformation;
import kafka.server.ControllerNodeProvider;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001\u0002\f\u0018\u0001qA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\tc\u0001\u0011\t\u0011)A\u0005e!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003F\u0011!A\u0005A!A!\u0002\u0013I\u0005\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u0011U\u0003!\u0011!Q\u0001\nYCQ!\u0017\u0001\u0005\u0002iCqa\u0019\u0001C\u0002\u0013%A\r\u0003\u0004i\u0001\u0001\u0006I!\u001a\u0005\bS\u0002\u0011\r\u0011\"\u0003k\u0011\u0019\t\b\u0001)A\u0005W\"9!\u000f\u0001b\u0001\n\u0013\u0019\bBB<\u0001A\u0003%A\u000fC\u0004y\u0001\t\u0007I\u0011B=\t\ru\u0004\u0001\u0015!\u0003{\u0011\u0015q\b\u0001\"\u0001\u0000\u0011\u0019\t9\u0001\u0001C\u0001\u007f\"9\u0011\u0011\u0002\u0001\u0005\u0002]I\bbBA\u0006\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u0003\u0013\u0002A\u0011AA&\u0005\u0011\u0012%o\\6feR{7i\u001c8ue>dG.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:J[Bd'B\u0001\r\u001a\u0003\u0019\u0019XM\u001d<fe*\t!$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001i2e\n\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0011*S\"A\f\n\u0005\u0019:\"\u0001\t\"s_.,'\u000fV8D_:$(o\u001c7mKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ\u0004\"\u0001K\u0016\u000e\u0003%R!AK\r\u0002\u000bU$\u0018\u000e\\:\n\u00051J#a\u0002'pO\u001eLgnZ\u0001\u0017G>tGO]8mY\u0016\u0014hj\u001c3f!J|g/\u001b3feB\u0011AeL\u0005\u0003a]\u0011acQ8oiJ|G\u000e\\3s\u001d>$W\r\u0015:pm&$WM]\u0001\u0005i&lW\r\u0005\u00024y5\tAG\u0003\u0002+k)\u0011agN\u0001\u0007G>lWn\u001c8\u000b\u0005iA$BA\u001d;\u0003\u0019\t\u0007/Y2iK*\t1(A\u0002pe\u001eL!!\u0010\u001b\u0003\tQKW.Z\u0001\b[\u0016$(/[2t!\t\u0001%)D\u0001B\u0015\tqT'\u0003\u0002D\u0003\n9Q*\u001a;sS\u000e\u001c\u0018AB2p]\u001aLw\r\u0005\u0002%\r&\u0011qi\u0006\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0006dQ\u0006tg.\u001a7OC6,\u0007C\u0001&R\u001d\tYu\n\u0005\u0002M?5\tQJ\u0003\u0002O7\u00051AH]8pizJ!\u0001U\u0010\u0002\rA\u0013X\rZ3g\u0013\t\u00116K\u0001\u0004TiJLgn\u001a\u0006\u0003!~\t\u0001\u0003\u001e5sK\u0006$g*Y7f!J,g-\u001b=\u0002\u001dI,GO]=US6,w.\u001e;NgB\u0011adV\u0005\u00031~\u0011A\u0001T8oO\u00061A(\u001b8jiz\"\u0002b\u0017/^=~\u0003\u0017M\u0019\t\u0003I\u0001AQ!\f\u0005A\u00029BQ!\r\u0005A\u0002IBQA\u0010\u0005A\u0002}BQ\u0001\u0012\u0005A\u0002\u0015CQ\u0001\u0013\u0005A\u0002%CQ\u0001\u0016\u0005A\u0002%CQ!\u0016\u0005A\u0002Y\u000b!\u0002\\8h\u0007>tG/\u001a=u+\u0005)\u0007CA\u001ag\u0013\t9GG\u0001\u0006M_\u001e\u001cuN\u001c;fqR\f1\u0002\\8h\u0007>tG/\u001a=uA\u0005)R.\u00198vC2lU\r^1eCR\fW\u000b\u001d3bi\u0016\u0014X#A6\u0011\u00051|W\"A7\u000b\u00059<\u0014aB2mS\u0016tGo]\u0005\u0003a6\u0014Q#T1ok\u0006dW*\u001a;bI\u0006$\u0018-\u00169eCR,'/\u0001\fnC:,\u0018\r\\'fi\u0006$\u0017\r^1Va\u0012\fG/\u001a:!\u0003-\t\u0007/\u001b,feNLwN\\:\u0016\u0003Q\u0004\"\u0001\\;\n\u0005Yl'aC!qSZ+'o]5p]N\fA\"\u00199j-\u0016\u00148/[8og\u0002\nQB]3rk\u0016\u001cH\u000f\u00165sK\u0006$W#\u0001>\u0011\u0005\u0011Z\u0018B\u0001?\u0018\u0005}\u0011%o\\6feR{7i\u001c8ue>dG.\u001a:SKF,Xm\u001d;UQJ,\u0017\rZ\u0001\u000fe\u0016\fX/Z:u)\"\u0014X-\u00193!\u0003\u0015\u0019H/\u0019:u)\t\t\t\u0001E\u0002\u001f\u0003\u0007I1!!\u0002 \u0005\u0011)f.\u001b;\u0002\u0011MDW\u000f\u001e3po:\f\u0001C\\3x%\u0016\fX/Z:u)\"\u0014X-\u00193\u0002\u0017M,g\u000e\u001a*fcV,7\u000f\u001e\u000b\u0007\u0003\u0003\ty!a\u0010\t\u000f\u0005EA\u00031\u0001\u0002\u0014\u00059!/Z9vKN$\b\u0007BA\u000b\u0003[\u0001b!a\u0006\u0002$\u0005%b\u0002BA\r\u0003?i!!a\u0007\u000b\u0007\u0005uQ'\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\t\t#a\u0007\u0002\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgRLA!!\n\u0002(\t9!)^5mI\u0016\u0014(\u0002BA\u0011\u00037\u0001B!a\u000b\u0002.1\u0001A\u0001DA\u0018\u0003\u001f\t\t\u0011!A\u0003\u0002\u0005E\"aA0%eE!\u00111GA\u001d!\rq\u0012QG\u0005\u0004\u0003oy\"a\u0002(pi\"Lgn\u001a\t\u0005\u00033\tY$\u0003\u0003\u0002>\u0005m!aD!cgR\u0014\u0018m\u0019;SKF,Xm\u001d;\t\u000f\u0005\u0005C\u00031\u0001\u0002D\u0005A1-\u00197mE\u0006\u001c7\u000eE\u0002%\u0003\u000bJ1!a\u0012\u0018\u0005\t\u001auN\u001c;s_2dWM\u001d*fcV,7\u000f^\"p[BdW\r^5p]\"\u000bg\u000e\u001a7fe\u0006)2m\u001c8ue>dG.\u001a:Ba&4VM]:j_:\u001cHCAA'!\u0015q\u0012qJA*\u0013\r\t\tf\b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00071\f)&C\u0002\u0002X5\u0014qBT8eK\u0006\u0003\u0018NV3sg&|gn\u001d")
public class BrokerToControllerChannelManagerImpl
implements BrokerToControllerChannelManager,
Logging {
    private final ControllerNodeProvider controllerNodeProvider;
    private final Time time;
    private final Metrics metrics;
    private final KafkaConfig config;
    private final String channelName;
    private final String threadNamePrefix;
    private final long retryTimeoutMs;
    private final LogContext logContext;
    private final ManualMetadataUpdater manualMetadataUpdater;
    private final ApiVersions apiVersions;
    private final BrokerToControllerRequestThread requestThread;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private ManualMetadataUpdater manualMetadataUpdater() {
        return this.manualMetadataUpdater;
    }

    private ApiVersions apiVersions() {
        return this.apiVersions;
    }

    private BrokerToControllerRequestThread requestThread() {
        return this.requestThread;
    }

    @Override
    public void start() {
        this.requestThread().start();
    }

    @Override
    public void shutdown() {
        this.requestThread().shutdown();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Broker to controller channel manager for ").append($this.channelName).append(" shutdown").toString());
    }

    public BrokerToControllerRequestThread newRequestThread() {
        String threadName = new StringBuilder(30).append(this.threadNamePrefix).append("to-controller-").append(this.channelName).append("-channel-manager").toString();
        ControllerInformation controllerInformation = this.controllerNodeProvider.getControllerInfo();
        return new BrokerToControllerRequestThread((KafkaClient)this.buildNetworkClient$1(controllerInformation), controllerInformation.isZkController(), (Function1<ControllerInformation, KafkaClient>)(Function1 & Serializable & scala.Serializable)controllerInfo -> this.buildNetworkClient$1((ControllerInformation)controllerInfo), this.manualMetadataUpdater(), this.controllerNodeProvider, this.config, this.time, threadName, this.retryTimeoutMs);
    }

    @Override
    public void sendRequest(AbstractRequest.Builder<? extends AbstractRequest> request, ControllerRequestCompletionHandler callback) {
        this.requestThread().enqueue(new BrokerToControllerQueueItem(this.time.milliseconds(), request, callback));
    }

    @Override
    public Option<NodeApiVersions> controllerApiVersions() {
        return this.requestThread().activeControllerAddress().flatMap((Function1 & Serializable & scala.Serializable)activeController -> Option$.MODULE$.apply((Object)this.apiVersions().get(activeController.idString())));
    }

    private final NetworkClient buildNetworkClient$1(ControllerInformation controllerInfo) {
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)controllerInfo.securityProtocol(), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)this.config, (ListenerName)controllerInfo.listenerName(), (String)controllerInfo.saslMechanism(), (Time)this.time, (boolean)this.config.saslInterBrokerHandshakeRequestEnable(), (LogContext)this.logContext());
        if (channelBuilder instanceof Reconfigurable) {
            this.config.addReconfigurable((Reconfigurable)channelBuilder);
        }
        Selector selector = new Selector(-1, -1L, this.metrics, this.time, this.channelName, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"BrokerId"), (Object)Integer.toString(this.config.brokerId()))}))).asJava(), false, channelBuilder, this.logContext());
        return new NetworkClient((Selectable)selector, (MetadataUpdater)this.manualMetadataUpdater(), Integer.toString(this.config.brokerId()), 1, 50L, 50L, -1, -1, (int)Math.min(Integer.MAX_VALUE, Math.min((long)this.config.controllerSocketTimeoutMs(), this.retryTimeoutMs)), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), this.time, true, this.apiVersions(), this.logContext());
    }

    public BrokerToControllerChannelManagerImpl(ControllerNodeProvider controllerNodeProvider, Time time, Metrics metrics, KafkaConfig config, String channelName, String threadNamePrefix, long retryTimeoutMs) {
        this.controllerNodeProvider = controllerNodeProvider;
        this.time = time;
        this.metrics = metrics;
        this.config = config;
        this.channelName = channelName;
        this.threadNamePrefix = threadNamePrefix;
        this.retryTimeoutMs = retryTimeoutMs;
        Logging.$init$(this);
        this.logContext = new LogContext(new StringBuilder(45).append("[BrokerToControllerChannelManager id=").append(config.brokerId()).append(" name=").append(channelName).append("] ").toString());
        this.manualMetadataUpdater = new ManualMetadataUpdater();
        this.apiVersions = new ApiVersions();
        this.requestThread = this.newRequestThread();
    }
}

