/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.controller.ConfigurationValidator;
import org.apache.kafka.storage.internals.log.LogConfig;
import scala.Predef$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U3Aa\u0002\u0005\u0001\u001b!)\u0011\u0005\u0001C\u0001E!)Q\u0005\u0001C\u0005M!)!\b\u0001C\u0005w!)Q\b\u0001C\u0005}!)\u0011\n\u0001C!\u0015\")\u0011\n\u0001C!\u0019\n\u00013i\u001c8ue>dG.\u001a:D_:4\u0017nZ;sCRLwN\u001c,bY&$\u0017\r^8s\u0015\tI!\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0017\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\u000f-A\u0011q\u0002F\u0007\u0002!)\u0011\u0011CE\u0001\u0005Y\u0006twMC\u0001\u0014\u0003\u0011Q\u0017M^1\n\u0005U\u0001\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u0018?5\t\u0001D\u0003\u0002\u001a5\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0005-Y\"B\u0001\u000f\u001e\u0003\u0019\t\u0007/Y2iK*\ta$A\u0002pe\u001eL!\u0001\t\r\u0003-\r{gNZ5hkJ\fG/[8o-\u0006d\u0017\u000eZ1u_J\fa\u0001P5oSRtD#A\u0012\u0011\u0005\u0011\u0002Q\"\u0001\u0005\u0002#Y\fG.\u001b3bi\u0016$v\u000e]5d\u001d\u0006lW\r\u0006\u0002([A\u0011\u0001fK\u0007\u0002S)\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\t!QK\\5u\u0011\u0015q#\u00011\u00010\u0003\u0011q\u0017-\\3\u0011\u0005A:dBA\u00196!\t\u0011\u0014&D\u00014\u0015\t!D\"\u0001\u0004=e>|GOP\u0005\u0003m%\na\u0001\u0015:fI\u00164\u0017B\u0001\u001d:\u0005\u0019\u0019FO]5oO*\u0011a'K\u0001\u0013m\u0006d\u0017\u000eZ1uK\n\u0013xn[3s\u001d\u0006lW\r\u0006\u0002(y!)af\u0001a\u0001_\u0005!C\u000f\u001b:po\u0016C8-\u001a9uS>tgi\u001c:V].twn\u001e8SKN|WO]2f)f\u0004X\r\u0006\u0002(\u007f!)\u0001\t\u0002a\u0001\u0003\u0006A!/Z:pkJ\u001cW\r\u0005\u0002C\u000f6\t1I\u0003\u0002E\u000b\u000611m\u001c8gS\u001eT!A\u0012\u000e\u0002\r\r|W.\\8o\u0013\tA5I\u0001\bD_:4\u0017n\u001a*fg>,(oY3\u0002\u0011Y\fG.\u001b3bi\u0016$\"aJ&\t\u000b\u0001+\u0001\u0019A!\u0015\u0007\u001dje\nC\u0003A\r\u0001\u0007\u0011\tC\u0003E\r\u0001\u0007q\n\u0005\u0003Q'>zS\"A)\u000b\u0005I\u0013\u0012\u0001B;uS2L!\u0001V)\u0003\u00075\u000b\u0007\u000f")
public class ControllerConfigurationValidator
implements ConfigurationValidator {
    private void validateTopicName(String name) {
        if (name.isEmpty()) {
            throw new InvalidRequestException("Default topic resources are not allowed.");
        }
        Topic.validate((String)name);
    }

    private void validateBrokerName(String name) {
        if (!name.isEmpty()) {
            Integer n;
            try {
                n = Integer.valueOf(name);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidRequestException("Unable to parse broker name as a base 10 number.");
            }
            Integer brokerId = n;
            if (Predef$.MODULE$.Integer2int(brokerId) < 0) {
                throw new InvalidRequestException("Invalid negative broker ID.");
            }
        }
    }

    private void throwExceptionForUnknownResourceType(ConfigResource resource) {
        throw new InvalidRequestException(new StringBuilder(22).append("Unknown resource type ").append(resource.type()).toString());
    }

    public void validate(ConfigResource resource) {
        ConfigResource.Type type = resource.type();
        if (ConfigResource.Type.TOPIC.equals(type)) {
            this.validateTopicName(resource.name());
            return;
        }
        if (ConfigResource.Type.BROKER.equals(type)) {
            this.validateBrokerName(resource.name());
            return;
        }
        this.throwExceptionForUnknownResourceType(resource);
    }

    public void validate(ConfigResource resource, Map<String, String> config) {
        ConfigResource.Type type = resource.type();
        if (ConfigResource.Type.TOPIC.equals(type)) {
            this.validateTopicName(resource.name());
            Properties properties = new Properties();
            ArrayBuffer nullTopicConfigs = new ArrayBuffer();
            config.entrySet().forEach(e -> {
                if (e.getValue() == null) {
                    nullTopicConfigs.$plus$eq(e.getKey());
                    return;
                }
                properties.setProperty((String)e.getKey(), (String)e.getValue());
            });
            if (nullTopicConfigs.nonEmpty()) {
                throw new InvalidConfigurationException(new StringBuilder(44).append("Null value not supported for topic configs: ").append(nullTopicConfigs.mkString(",")).toString());
            }
            LogConfig.validate((Properties)properties);
            return;
        }
        if (ConfigResource.Type.BROKER.equals(type)) {
            this.validateBrokerName(resource.name());
            return;
        }
        this.throwExceptionForUnknownResourceType(resource);
    }
}

