/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import kafka.controller.KafkaController;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.server.AutoTopicCreationManager;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerMutationQuota;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.ForwardingManager$;
import kafka.server.KafkaConfig;
import kafka.server.ZkAdminManager;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001\u0002\n\u0014\u0001aA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\t[\u0001\u0011\t\u0011)A\u0005]!AA\u0007\u0001B\u0001B\u0003%Q\u0007\u0003\u0005:\u0001\t\u0005\t\u0015!\u0003;\u0011!\u0001\u0005A!A!\u0002\u0013\t\u0005\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011B(\t\u000bY\u0003A\u0011A,\t\u000f}\u0003!\u0019!C\u0005A\"1A\u000f\u0001Q\u0001\n\u0005DQ!\u001e\u0001\u0005BYDq!!\u0013\u0001\t\u0013\tY\u0005C\u0004\u0002h\u0001!I!!\u001b\t\u000f\u0005=\u0004\u0001\"\u0003\u0002r!9\u00111\u0010\u0001\u0005\n\u0005u\u0004bBAB\u0001\u0011%\u0011Q\u0011\u0005\b\u0003+\u0003A\u0011BAL\u0011\u001d\t\t\u000b\u0001C\u0005\u0003G\u0013q\u0004R3gCVdG/Q;u_R{\u0007/[2De\u0016\fG/[8o\u001b\u0006t\u0017mZ3s\u0015\t!R#\u0001\u0004tKJ4XM\u001d\u0006\u0002-\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\u001a?\r\u0002\"AG\u000f\u000e\u0003mQ\u0011\u0001H\u0001\u0006g\u000e\fG.Y\u0005\u0003=m\u0011a!\u00118z%\u00164\u0007C\u0001\u0011\"\u001b\u0005\u0019\u0012B\u0001\u0012\u0014\u0005a\tU\u000f^8U_BL7m\u0011:fCRLwN\\'b]\u0006<WM\u001d\t\u0003I\u001dj\u0011!\n\u0006\u0003MU\tQ!\u001e;jYNL!\u0001K\u0013\u0003\u000f1{wmZ5oO\u000611m\u001c8gS\u001e\u0004\"\u0001I\u0016\n\u00051\u001a\"aC&bM.\f7i\u001c8gS\u001e\fab\u00195b]:,G.T1oC\u001e,'\u000fE\u0002\u001b_EJ!\u0001M\u000e\u0003\r=\u0003H/[8o!\t\u0001#'\u0003\u00024'\t\u0001#I]8lKJ$vnQ8oiJ|G\u000e\\3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s\u00031\tG-\\5o\u001b\u0006t\u0017mZ3s!\rQrF\u000e\t\u0003A]J!\u0001O\n\u0003\u001di[\u0017\tZ7j]6\u000bg.Y4fe\u0006Q1m\u001c8ue>dG.\u001a:\u0011\u0007iy3\b\u0005\u0002=}5\tQH\u0003\u0002:+%\u0011q(\u0010\u0002\u0010\u0017\u000647.Y\"p]R\u0014x\u000e\u001c7fe\u0006\u0001rM]8va\u000e{wN\u001d3j]\u0006$xN\u001d\t\u0003\u00052k\u0011a\u0011\u0006\u0003\t\u0016\u000bQa\u001a:pkBT!AR$\u0002\u0017\r|wN\u001d3j]\u0006$xN\u001d\u0006\u0003-!S!!\u0013&\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0015aA8sO&\u0011Qj\u0011\u0002\u0011\u000fJ|W\u000f]\"p_J$\u0017N\\1u_J\fa\u0002\u001e=o\u0007>|'\u000fZ5oCR|'\u000f\u0005\u0002Q)6\t\u0011K\u0003\u0002S'\u0006YAO]1og\u0006\u001cG/[8o\u0015\t1U#\u0003\u0002V#\n1BK]1og\u0006\u001cG/[8o\u0007>|'\u000fZ5oCR|'/\u0001\u0004=S:LGO\u0010\u000b\b1fS6\fX/_!\t\u0001\u0003\u0001C\u0003*\u000f\u0001\u0007!\u0006C\u0003.\u000f\u0001\u0007a\u0006C\u00035\u000f\u0001\u0007Q\u0007C\u0003:\u000f\u0001\u0007!\bC\u0003A\u000f\u0001\u0007\u0011\tC\u0003O\u000f\u0001\u0007q*\u0001\bj]\u001ad\u0017n\u001a5u)>\u0004\u0018nY:\u0016\u0003\u0005\u00042AY4j\u001b\u0005\u0019'B\u00013f\u0003\u0011)H/\u001b7\u000b\u0003\u0019\fAA[1wC&\u0011\u0001n\u0019\u0002\u0004'\u0016$\bC\u00016r\u001d\tYw\u000e\u0005\u0002m75\tQN\u0003\u0002o/\u00051AH]8pizJ!\u0001]\u000e\u0002\rA\u0013X\rZ3g\u0013\t\u00118O\u0001\u0004TiJLgn\u001a\u0006\u0003an\tq\"\u001b8gY&<\u0007\u000e\u001e+pa&\u001c7\u000fI\u0001\rGJ,\u0017\r^3U_BL7m\u001d\u000b\bo\u0006\u0015\u0012QFA\u001c!\rA80`\u0007\u0002s*\u0011!pG\u0001\u000bG>dG.Z2uS>t\u0017B\u0001?z\u0005\r\u0019V-\u001d\t\u0004}\u0006}abA@\u0002\u001a9!\u0011\u0011AA\n\u001d\u0011\t\u0019!a\u0004\u000f\t\u0005\u0015\u0011Q\u0002\b\u0005\u0003\u000f\tYAD\u0002m\u0003\u0013I\u0011aS\u0005\u0003\u0013*K!A\u0006%\n\u0007\u0005Eq)\u0001\u0004d_6lwN\\\u0005\u0005\u0003+\t9\"A\u0004nKN\u001c\u0018mZ3\u000b\u0007\u0005Eq)\u0003\u0003\u0002\u001c\u0005u\u0011\u0001F'fi\u0006$\u0017\r^1SKN\u0004xN\\:f\t\u0006$\u0018M\u0003\u0003\u0002\u0016\u0005]\u0011\u0002BA\u0011\u0003G\u0011Q#T3uC\u0012\fG/\u0019*fgB|gn]3U_BL7M\u0003\u0003\u0002\u001c\u0005u\u0001bBA\u0014\u0015\u0001\u0007\u0011\u0011F\u0001\u0007i>\u0004\u0018nY:\u0011\ta\fY#[\u0005\u0003QfDq!a\f\u000b\u0001\u0004\t\t$A\fd_:$(o\u001c7mKJlU\u000f^1uS>t\u0017+^8uCB\u0019\u0001%a\r\n\u0007\u0005U2CA\fD_:$(o\u001c7mKJlU\u000f^1uS>t\u0017+^8uC\"9\u0011\u0011\b\u0006A\u0002\u0005m\u0012AF7fi\u0006$\u0017\r^1SKF,Xm\u001d;D_:$X\r\u001f;\u0011\tiy\u0013Q\b\t\u0005\u0003\u007f\t)%\u0004\u0002\u0002B)!\u00111IA\f\u0003!\u0011X-];fgR\u001c\u0018\u0002BA$\u0003\u0003\u0012aBU3rk\u0016\u001cHoQ8oi\u0016DH/\u0001\tde\u0016\fG/\u001a+pa&\u001c7/\u00138[WR)q/!\u0014\u0002f!9\u0011qJ\u0006A\u0002\u0005E\u0013aD2sK\u0006$\u0018M\u00197f)>\u0004\u0018nY:\u0011\ra\f\u0019&[A,\u0013\r\t)&\u001f\u0002\u0004\u001b\u0006\u0004\b\u0003BA-\u0003?r1a`A.\u0013\u0011\ti&!\b\u0002/\r\u0013X-\u0019;f)>\u0004\u0018nY:SKF,Xm\u001d;ECR\f\u0017\u0002BA1\u0003G\u0012ab\u0011:fCR\f'\r\\3U_BL7M\u0003\u0003\u0002^\u0005u\u0001bBA\u0018\u0017\u0001\u0007\u0011\u0011G\u0001\u0017g\u0016tGm\u0011:fCR,Gk\u001c9jGJ+\u0017/^3tiR)q/a\u001b\u0002n!9\u0011q\n\u0007A\u0002\u0005E\u0003bBA\u001d\u0019\u0001\u0007\u00111H\u0001\u0016G2,\u0017M]%oM2Lw\r\u001b;SKF,Xm\u001d;t)\u0011\t\u0019(!\u001f\u0011\u0007i\t)(C\u0002\u0002xm\u0011A!\u00168ji\"9\u0011qJ\u0007A\u0002\u0005E\u0013AD2sK\u0006$\u0018M\u00197f)>\u0004\u0018n\u0019\u000b\u0005\u0003/\ny\b\u0003\u0004\u0002\u0002:\u0001\r![\u0001\u0006i>\u0004\u0018nY\u0001 G>tg/\u001a:u)>$v\u000e]5d\u0007>tg-[4D_2dWm\u0019;j_:\u001cH\u0003BAD\u0003\u001b\u0003B!!\u0017\u0002\n&!\u00111RA2\u0005}\u0019%/Z1uK\u0006\u0014G.\u001a+pa&\u001c7i\u001c8gS\u001e\u001cu\u000e\u001c7fGRLwN\u001c\u0005\u0007S=\u0001\r!a$\u0011\u0007\t\f\t*C\u0002\u0002\u0014\u000e\u0014!\u0002\u0015:pa\u0016\u0014H/[3t\u0003AI7OV1mS\u0012$v\u000e]5d\u001d\u0006lW\r\u0006\u0003\u0002\u001a\u0006}\u0005c\u0001\u000e\u0002\u001c&\u0019\u0011QT\u000e\u0003\u000f\t{w\u000e\\3b]\"1\u0011\u0011\u0011\tA\u0002%\fQCZ5mi\u0016\u00148I]3bi\u0006\u0014G.\u001a+pa&\u001c7\u000f\u0006\u0003\u0002&\u0006-\u0006C\u0002\u000e\u0002(\u0006Es/C\u0002\u0002*n\u0011a\u0001V;qY\u0016\u0014\u0004bBA\u0014#\u0001\u0007\u0011\u0011\u0006")
public class DefaultAutoTopicCreationManager
implements AutoTopicCreationManager,
Logging {
    private final KafkaConfig config;
    private final Option<BrokerToControllerChannelManager> channelManager;
    private final Option<ZkAdminManager> adminManager;
    private final Option<KafkaController> controller;
    private final GroupCoordinator groupCoordinator;
    private final TransactionCoordinator txnCoordinator;
    private final java.util.Set<String> inflightTopics;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private java.util.Set<String> inflightTopics() {
        return this.inflightTopics;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> createTopics(Set<String> topics, ControllerMutationQuota controllerMutationQuota, Option<RequestContext> metadataRequestContext) {
        void var6_6;
        void var5_5;
        Tuple2<Map<String, CreateTopicsRequestData.CreatableTopic>, Seq<MetadataResponseData.MetadataResponseTopic>> tuple2 = this.filterCreatableTopics(topics);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Map creatableTopics = (Map)tuple2._1();
        Seq uncreatableTopicResponses = (Seq)tuple2._2();
        void creatableTopics2 = var5_5;
        void uncreatableTopicResponses2 = var6_6;
        Seq<MetadataResponseData.MetadataResponseTopic> creatableTopicResponses = creatableTopics2.isEmpty() ? Nil$.MODULE$ : (this.controller.isEmpty() || !((KafkaController)this.controller.get()).isActive() && this.channelManager.isDefined() ? this.sendCreateTopicRequest((Map<String, CreateTopicsRequestData.CreatableTopic>)creatableTopics2, metadataRequestContext) : this.createTopicsInZk((Map<String, CreateTopicsRequestData.CreatableTopic>)creatableTopics2, controllerMutationQuota));
        return (Seq)uncreatableTopicResponses2.$plus$plus((GenTraversableOnce)creatableTopicResponses, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<MetadataResponseData.MetadataResponseTopic> createTopicsInZk(Map<String, CreateTopicsRequestData.CreatableTopic> creatableTopics, ControllerMutationQuota controllerMutationQuota) {
        Seq seq;
        AtomicReference topicErrors = new AtomicReference();
        try {
            Seq seq2;
            ((ZkAdminManager)this.adminManager.get()).createTopics(0, false, creatableTopics, (Map<String, CreateTopicsResponseData.CreatableTopicResult>)scala.collection.Map$.MODULE$.empty(), controllerMutationQuota, (Function1<Map<String, ApiError>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
                topicErrors.set(x$1);
                return BoxedUnit.UNIT;
            });
            Option option = Option$.MODULE$.apply(topicErrors.get());
            if (option instanceof Some) {
                seq2 = (Seq)((Map)((Some)option).value()).toSeq().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    if (x0$1 == null) {
                        throw new MatchError(null);
                    }
                    String topic = (String)x0$1._1();
                    Errors errors = ((ApiError)x0$1._2()).error();
                    boolean bl = Errors.TOPIC_ALREADY_EXISTS.equals(errors) ? true : Errors.REQUEST_TIMED_OUT.equals(errors);
                    Errors errors2 = bl ? Errors.LEADER_NOT_AVAILABLE : errors;
                    MetadataResponseData.MetadataResponseTopic metadataResponseTopic = new MetadataResponseData.MetadataResponseTopic().setErrorCode(errors2.code()).setName(topic).setIsInternal(Topic.isInternal((String)topic));
                    return metadataResponseTopic;
                }, Seq$.MODULE$.canBuildFrom());
            } else if (None$.MODULE$.equals(option)) {
                seq2 = (Seq)creatableTopics.keySet().toSeq().map((Function1 & Serializable & scala.Serializable)topic -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setName(topic).setIsInternal(Topic.isInternal((String)topic)), Seq$.MODULE$.canBuildFrom());
            } else {
                throw new MatchError((Object)option);
            }
            seq = seq2;
        }
        finally {
            this.kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests(creatableTopics);
        }
        return seq;
    }

    private Seq<MetadataResponseData.MetadataResponseTopic> sendCreateTopicRequest(Map<String, CreateTopicsRequestData.CreatableTopic> creatableTopics, Option<RequestContext> metadataRequestContext) {
        CreateTopicsRequestData.CreatableTopicCollection topicsToCreate = new CreateTopicsRequestData.CreatableTopicCollection(creatableTopics.size());
        topicsToCreate.addAll(CollectionConverters$.MODULE$.asJavaCollectionConverter(creatableTopics.values()).asJavaCollection());
        CreateTopicsRequest.Builder createTopicsRequest = new CreateTopicsRequest.Builder(new CreateTopicsRequestData().setTimeoutMs(Predef$.MODULE$.Integer2int(this.config.requestTimeoutMs())).setTopics(topicsToCreate));
        ControllerRequestCompletionHandler requestCompletionHandler = new ControllerRequestCompletionHandler(this, creatableTopics){
            private final /* synthetic */ DefaultAutoTopicCreationManager $outer;
            private final Map creatableTopics$1;

            public void onTimeout() {
                this.$outer.kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests((Map<String, CreateTopicsRequestData.CreatableTopic>)this.creatableTopics$1);
                this.$outer.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Auto topic creation timed out for ").append($this.creatableTopics$1.keys()).append(".").toString());
            }

            public void onComplete(ClientResponse response) {
                this.$outer.kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests((Map<String, CreateTopicsRequestData.CreatableTopic>)this.creatableTopics$1);
                if (response.authenticationException() != null) {
                    this.$outer.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Auto topic creation failed for ").append($this.creatableTopics$1.keys()).append(" with authentication exception").toString());
                    return;
                }
                if (response.versionMismatch() != null) {
                    this.$outer.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Auto topic creation failed for ").append($this.creatableTopics$1.keys()).append(" with invalid version exception").toString());
                    return;
                }
                this.$outer.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Auto topic creation completed for ").append($this.creatableTopics$1.keys()).append(" with response ").append(response.responseBody()).append(".").toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.creatableTopics$1 = creatableTopics$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onTimeout$1(kafka.server.DefaultAutoTopicCreationManager$$anon$1 ), $anonfun$onComplete$1(kafka.server.DefaultAutoTopicCreationManager$$anon$1 ), $anonfun$onComplete$2(kafka.server.DefaultAutoTopicCreationManager$$anon$1 ), $anonfun$onComplete$3(kafka.server.DefaultAutoTopicCreationManager$$anon$1 org.apache.kafka.clients.ClientResponse )}, serializedLambda);
            }
        };
        BrokerToControllerChannelManager channelManager = (BrokerToControllerChannelManager)this.channelManager.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("Channel manager must be defined in order to send CreateTopic requests.");
        });
        AbstractRequest.Builder request = (AbstractRequest.Builder)metadataRequestContext.map((Function1 & Serializable & scala.Serializable)context -> {
            short s;
            Option<NodeApiVersions> option = channelManager.controllerApiVersions();
            if (None$.MODULE$.equals(option)) {
                s = ApiKeys.CREATE_TOPICS.latestVersion();
            } else if (option instanceof Some) {
                s = ((NodeApiVersions)((Some)option).value()).latestUsableVersion(ApiKeys.CREATE_TOPICS);
            } else {
                throw new MatchError(option);
            }
            RequestHeader requestHeader = new RequestHeader(ApiKeys.CREATE_TOPICS, s, context.clientId(), context.correlationId());
            return ForwardingManager$.MODULE$.buildEnvelopeRequest((RequestContext)context, createTopicsRequest.build(s).serializeWithHeader(requestHeader));
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> createTopicsRequest);
        channelManager.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)request, requestCompletionHandler);
        Seq creatableTopicResponses = (Seq)creatableTopics.keySet().toSeq().map((Function1 & Serializable & scala.Serializable)topic -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setName(topic).setIsInternal(Topic.isInternal((String)topic)), Seq$.MODULE$.canBuildFrom());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Sent auto-creation request for ").append(creatableTopics.keys()).append(" to the active controller.").toString());
        return creatableTopicResponses;
    }

    public void kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests(Map<String, CreateTopicsRequestData.CreatableTopic> creatableTopics) {
        creatableTopics.keySet().foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DefaultAutoTopicCreationManager.$anonfun$clearInflightRequests$1(this, x$1)));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Cleared inflight topic creation state for ").append(creatableTopics).toString());
    }

    private CreateTopicsRequestData.CreatableTopic creatableTopic(String topic) {
        CreateTopicsRequestData.CreatableTopic creatableTopic = "__consumer_offsets".equals(topic) ? new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(Predef$.MODULE$.Integer2int(this.config.offsetsTopicPartitions())).setReplicationFactor(Predef$.MODULE$.Short2short(this.config.offsetsTopicReplicationFactor())).setConfigs(this.convertToTopicConfigCollections(this.groupCoordinator.groupMetadataTopicConfigs())) : ("__transaction_state".equals(topic) ? new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(Predef$.MODULE$.Integer2int(this.config.transactionTopicPartitions())).setReplicationFactor(Predef$.MODULE$.Short2short(this.config.transactionTopicReplicationFactor())).setConfigs(this.convertToTopicConfigCollections(this.txnCoordinator.transactionTopicConfigs())) : new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(Predef$.MODULE$.Integer2int(this.config.numPartitions())).setReplicationFactor((short)this.config.defaultReplicationFactor()));
        return creatableTopic;
    }

    /*
     * WARNING - void declaration
     */
    private CreateTopicsRequestData.CreateableTopicConfigCollection convertToTopicConfigCollections(Properties config) {
        void var2_2;
        CreateTopicsRequestData.CreateableTopicConfigCollection topicConfigs = new CreateTopicsRequestData.CreateableTopicConfigCollection();
        config.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(x0$1, x1$1) -> topicConfigs.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreateableTopicConfig().setName(x0$1.toString()).setValue(x1$1.toString()))));
        return var2_2;
    }

    private boolean isValidTopicName(String topic) {
        try {
            Topic.validate((String)topic);
            return true;
        }
        catch (InvalidTopicException invalidTopicException) {
            return false;
        }
    }

    private Tuple2<Map<String, CreateTopicsRequestData.CreatableTopic>, Seq<MetadataResponseData.MetadataResponseTopic>> filterCreatableTopics(Set<String> topics) {
        scala.collection.mutable.Map creatableTopics = Map$.MODULE$.empty();
        Buffer uncreatableTopics = (Buffer)Buffer$.MODULE$.empty();
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            Option option;
            Some validationError;
            Object object = !this.isValidTopicName((String)topic) ? new Some((Object)Errors.INVALID_TOPIC_EXCEPTION) : (validationError = !this.inflightTopics().add((String)topic) ? new Some((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION) : None$.MODULE$);
            if (validationError instanceof Some) {
                Errors error = (Errors)validationError.value();
                option = uncreatableTopics.$plus$eq((Object)new MetadataResponseData.MetadataResponseTopic().setErrorCode(error.code()).setName(topic).setIsInternal(Topic.isInternal((String)topic)));
            } else if (None$.MODULE$.equals(validationError)) {
                option = creatableTopics.put(topic, (Object)this.creatableTopic((String)topic));
            } else {
                throw new MatchError((Object)validationError);
            }
            return option;
        });
        return new Tuple2((Object)creatableTopics, (Object)uncreatableTopics);
    }

    public static final /* synthetic */ boolean $anonfun$clearInflightRequests$1(DefaultAutoTopicCreationManager $this, Object x$1) {
        return $this.inflightTopics().remove(x$1);
    }

    public DefaultAutoTopicCreationManager(KafkaConfig config, Option<BrokerToControllerChannelManager> channelManager, Option<ZkAdminManager> adminManager, Option<KafkaController> controller, GroupCoordinator groupCoordinator, TransactionCoordinator txnCoordinator) {
        this.config = config;
        this.channelManager = channelManager;
        this.adminManager = adminManager;
        this.controller = controller;
        this.groupCoordinator = groupCoordinator;
        this.txnCoordinator = txnCoordinator;
        Logging.$init$(this);
        if (controller.isEmpty() && channelManager.isEmpty()) {
            throw new IllegalArgumentException("Must supply a channel manager if not supplying a controller");
        }
        this.inflightTopics = Collections.newSetFromMap(new ConcurrentHashMap());
    }
}

