/*
 * Decompiled with CFR 0.152.
 */
package kafka.log.remote;

import com.typesafe.scalalogging.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import kafka.log.UnifiedLog$;
import kafka.log.remote.Entry;
import kafka.log.remote.RemoteIndexCache$;
import kafka.utils.Logging;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteStorageManager;
import org.apache.kafka.server.util.ShutdownableThread;
import org.apache.kafka.storage.internals.log.OffsetIndex;
import org.apache.kafka.storage.internals.log.TimeIndex;
import org.apache.kafka.storage.internals.log.TransactionIndex;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\u00055v!B\u0010!\u0011\u00039c!B\u0015!\u0011\u0003Q\u0003\"B\u0019\u0002\t\u0003\u0011\u0004bB\u001a\u0002\u0005\u0004%\t\u0001\u000e\u0005\u0007{\u0005\u0001\u000b\u0011B\u001b\t\u000fy\n!\u0019!C\u0001i!1q(\u0001Q\u0001\nUBq\u0001Q\u0001\u0012\u0002\u0013\u0005\u0011I\u0002\u0003*A\u0001y\u0005\u0002\u0003/\t\u0005\u0003\u0005\u000b\u0011B\"\t\u0011uC!\u0011!Q\u0001\nyC\u0001\"\u001c\u0005\u0003\u0002\u0003\u0006IA\u001c\u0005\u0006c!!\t\u0001\u001f\u0005\b{\"\u0011\r\u0011\"\u0001\u007f\u0011\u001d\t)\u0001\u0003Q\u0001\n}D\u0011\"a\u0002\t\u0001\u0004%\t!!\u0003\t\u0013\u0005E\u0001\u00021A\u0005\u0002\u0005M\u0001\u0002CA\u0010\u0011\u0001\u0006K!a\u0003\t\u0013\u0005%\u0002B1A\u0005\u0002\u0005-\u0002\u0002CA\"\u0011\u0001\u0006I!!\f\t\u0013\u0005\u0015\u0003B1A\u0005\u0002\u0005\u001d\u0003\u0002CA(\u0011\u0001\u0006I!!\u0013\t\u0013\u0005E\u0003B1A\u0005\u0002\u0005M\u0003\u0002CA5\u0011\u0001\u0006I!!\u0016\t\u000f\u0005-\u0004\u0002\"\u0003\u0002n!I\u0011q\u000e\u0005C\u0002\u0013\u0005\u0011\u0011\u000f\u0005\t\u0003{B\u0001\u0015!\u0003\u0002t!9\u0011q\u0010\u0005\u0005\u0002\u0005\u0005\u0005bBAG\u0011\u0011\u0005\u0011q\u0012\u0005\b\u0003;CA\u0011AAP\u0011\u001d\tY\u000b\u0003C\u0001\u0003[\n\u0001CU3n_R,\u0017J\u001c3fq\u000e\u000b7\r[3\u000b\u0005\u0005\u0012\u0013A\u0002:f[>$XM\u0003\u0002$I\u0005\u0019An\\4\u000b\u0003\u0015\nQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002)\u00035\t\u0001E\u0001\tSK6|G/Z%oI\u0016D8)Y2iKN\u0011\u0011a\u000b\t\u0003Y=j\u0011!\f\u0006\u0002]\u0005)1oY1mC&\u0011\u0001'\f\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00059\u0013a\u0002#je:\u000bW.Z\u000b\u0002kA\u0011agO\u0007\u0002o)\u0011\u0001(O\u0001\u0005Y\u0006twMC\u0001;\u0003\u0011Q\u0017M^1\n\u0005q:$AB*ue&tw-\u0001\u0005ESJt\u0015-\\3!\u00035!V\u000e\u001d$jY\u0016\u001cVO\u001a4jq\u0006qA+\u001c9GS2,7+\u001e4gSb\u0004\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'F\u0001CU\t\u0019e\t\u0005\u0002-\t&\u0011Q)\f\u0002\u0004\u0013:$8&A$\u0011\u0005!kU\"A%\u000b\u0005)[\u0015!C;oG\",7m[3e\u0015\taU&\u0001\u0006b]:|G/\u0019;j_:L!AT%\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cWm\u0005\u0003\tWA3\u0006CA)U\u001b\u0005\u0011&BA*%\u0003\u0015)H/\u001b7t\u0013\t)&KA\u0004M_\u001e<\u0017N\\4\u0011\u0005]SV\"\u0001-\u000b\u0005eK\u0014AA5p\u0013\tY\u0006LA\u0005DY>\u001cX-\u00192mK\u00069Q.\u0019=TSj,\u0017\u0001\u0006:f[>$Xm\u0015;pe\u0006<W-T1oC\u001e,'\u000f\u0005\u0002`W6\t\u0001M\u0003\u0002bE\u000691\u000f^8sC\u001e,'BA\u0011d\u0015\t\u0019CM\u0003\u0002fM\u000611/\u001a:wKJT!!J4\u000b\u0005!L\u0017AB1qC\u000eDWMC\u0001k\u0003\ry'oZ\u0005\u0003Y\u0002\u0014ACU3n_R,7\u000b^8sC\u001e,W*\u00198bO\u0016\u0014\u0018A\u00027pO\u0012K'\u000f\u0005\u0002pm:\u0011\u0001\u000f\u001e\t\u0003c6j\u0011A\u001d\u0006\u0003g\u001a\na\u0001\u0010:p_Rt\u0014BA;.\u0003\u0019\u0001&/\u001a3fM&\u0011Ah\u001e\u0006\u0003k6\"B!\u001f>|yB\u0011\u0001\u0006\u0003\u0005\b92\u0001\n\u00111\u0001D\u0011\u0015iF\u00021\u0001_\u0011\u0015iG\u00021\u0001o\u0003!\u0019\u0017m\u00195f\t&\u0014X#A@\u0011\u0007]\u000b\t!C\u0002\u0002\u0004a\u0013AAR5mK\u0006I1-Y2iK\u0012K'\u000fI\u0001\u0007G2|7/\u001a3\u0016\u0005\u0005-\u0001c\u0001\u0017\u0002\u000e%\u0019\u0011qB\u0017\u0003\u000f\t{w\u000e\\3b]\u0006Q1\r\\8tK\u0012|F%Z9\u0015\t\u0005U\u00111\u0004\t\u0004Y\u0005]\u0011bAA\r[\t!QK\\5u\u0011%\ti\u0002EA\u0001\u0002\u0004\tY!A\u0002yIE\nqa\u00197pg\u0016$\u0007\u0005K\u0002\u0012\u0003G\u00012\u0001LA\u0013\u0013\r\t9#\f\u0002\tm>d\u0017\r^5mK\u0006qQ\r\u001f9je\u0016$\u0017J\u001c3fq\u0016\u001cXCAA\u0017!\u0019\ty#!\u000f\u0002>5\u0011\u0011\u0011\u0007\u0006\u0005\u0003g\t)$\u0001\u0006d_:\u001cWO\u001d:f]RT1!a\u000e:\u0003\u0011)H/\u001b7\n\t\u0005m\u0012\u0011\u0007\u0002\u0014\u0019&t7.\u001a3CY>\u001c7.\u001b8h#V,W/\u001a\t\u0004Q\u0005}\u0012bAA!A\t)QI\u001c;ss\u0006yQ\r\u001f9je\u0016$\u0017J\u001c3fq\u0016\u001c\b%\u0001\u0003m_\u000e\\WCAA%!\r1\u00141J\u0005\u0004\u0003\u001b:$AB(cU\u0016\u001cG/A\u0003m_\u000e\\\u0007%A\u0004f]R\u0014\u0018.Z:\u0016\u0005\u0005U\u0003\u0003CA,\u00033\ni&!\u0010\u000e\u0005\u0005U\u0012\u0002BA.\u0003k\u00111!T1q!\u0011\ty&!\u001a\u000e\u0005\u0005\u0005$bAA2M\u000611m\\7n_:LA!a\u001a\u0002b\t!Q+^5e\u0003!)g\u000e\u001e:jKN\u0004\u0013\u0001B5oSR$\"!!\u0006\u0002\u001b\rdW-\u00198feRC'/Z1e+\t\t\u0019\b\u0005\u0003\u0002v\u0005eTBAA<\u0015\r\t9\u0004Z\u0005\u0005\u0003w\n9H\u0001\nTQV$Hm\\<oC\ndW\r\u00165sK\u0006$\u0017AD2mK\u0006tWM\u001d+ie\u0016\fG\rI\u0001\u000eO\u0016$\u0018J\u001c3fq\u0016sGO]=\u0015\t\u0005u\u00121\u0011\u0005\b\u0003\u000b[\u0002\u0019AAD\u0003a\u0011X-\\8uK2{wmU3h[\u0016tG/T3uC\u0012\fG/\u0019\t\u0004?\u0006%\u0015bAAFA\nA\"+Z7pi\u0016dunZ*fO6,g\u000e^'fi\u0006$\u0017\r^1\u0002\u00191|wn[;q\u001f\u001a47/\u001a;\u0015\u000b\r\u000b\t*a%\t\u000f\u0005\u0015E\u00041\u0001\u0002\b\"9\u0011Q\u0013\u000fA\u0002\u0005]\u0015AB8gMN,G\u000fE\u0002-\u00033K1!a'.\u0005\u0011auN\\4\u0002\u001f1|wn[;q)&lWm\u001d;b[B$raQAQ\u0003G\u000b9\u000bC\u0004\u0002\u0006v\u0001\r!a\"\t\u000f\u0005\u0015V\u00041\u0001\u0002\u0018\u0006IA/[7fgR\fW\u000e\u001d\u0005\b\u0003Sk\u0002\u0019AAL\u00039\u0019H/\u0019:uS:<wJ\u001a4tKR\fQa\u00197pg\u0016\u0004")
public class RemoteIndexCache
implements Logging,
Closeable {
    public final int kafka$log$remote$RemoteIndexCache$$maxSize;
    private final RemoteStorageManager remoteStorageManager;
    private final File cacheDir;
    private volatile boolean closed;
    private final LinkedBlockingQueue<Entry> expiredIndexes;
    private final Object lock;
    private final Map<Uuid, Entry> entries;
    private final ShutdownableThread cleanerThread;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$1() {
        return RemoteIndexCache$.MODULE$.$lessinit$greater$default$1();
    }

    public static String TmpFileSuffix() {
        return RemoteIndexCache$.MODULE$.TmpFileSuffix();
    }

    public static String DirName() {
        return RemoteIndexCache$.MODULE$.DirName();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File cacheDir() {
        return this.cacheDir;
    }

    public boolean closed() {
        return this.closed;
    }

    public void closed_$eq(boolean x$1) {
        this.closed = x$1;
    }

    public LinkedBlockingQueue<Entry> expiredIndexes() {
        return this.expiredIndexes;
    }

    public Object lock() {
        return this.lock;
    }

    public Map<Uuid, Entry> entries() {
        return this.entries;
    }

    private void init() {
        if (this.cacheDir().mkdir()) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Created ").append(this.cacheDir()).append(" successfully").toString());
        }
        Files.list(this.cacheDir().toPath()).forEach(path -> {
            if (path.endsWith(".deleted")) {
                Files.deleteIfExists(path);
            }
        });
        Files.list(this.cacheDir().toPath()).forEach(path -> {
            String pathStr = ((Object)path.getFileName()).toString();
            String name = pathStr.substring(0, pathStr.lastIndexOf("_") + 1);
            int firstIndex = name.indexOf(95);
            int offset = new StringOps(Predef$.MODULE$.augmentString(name.substring(0, firstIndex))).toInt();
            Uuid uuid = Uuid.fromString((String)name.substring(firstIndex + 1, name.lastIndexOf(95)));
            if (!this.entries().containsKey(uuid)) {
                File offsetIndexFile = new File(this.cacheDir(), new StringBuilder(0).append(name).append(UnifiedLog$.MODULE$.IndexFileSuffix()).toString());
                File timestampIndexFile = new File(this.cacheDir(), new StringBuilder(0).append(name).append(UnifiedLog$.MODULE$.TimeIndexFileSuffix()).toString());
                File txnIndexFile = new File(this.cacheDir(), new StringBuilder(0).append(name).append(UnifiedLog$.MODULE$.TxnIndexFileSuffix()).toString());
                if (offsetIndexFile.exists() && timestampIndexFile.exists() && txnIndexFile.exists()) {
                    OffsetIndex offsetIndex = new OffsetIndex(offsetIndexFile, (long)offset, Integer.MAX_VALUE, false);
                    offsetIndex.sanityCheck();
                    TimeIndex timeIndex = new TimeIndex(timestampIndexFile, (long)offset, Integer.MAX_VALUE, false);
                    timeIndex.sanityCheck();
                    TransactionIndex txnIndex = new TransactionIndex((long)offset, txnIndexFile);
                    txnIndex.sanityCheck();
                    Entry entry = new Entry(offsetIndex, timeIndex, txnIndex);
                    this.entries().put(uuid, entry);
                    return;
                }
                Files.deleteIfExists(offsetIndexFile.toPath());
                Files.deleteIfExists(timestampIndexFile.toPath());
                Files.deleteIfExists(txnIndexFile.toPath());
            }
        });
    }

    public ShutdownableThread cleanerThread() {
        return this.cleanerThread;
    }

    public Entry getIndexEntry(RemoteLogSegmentMetadata remoteLogSegmentMetadata) {
        if (this.closed()) {
            throw new IllegalStateException("Instance is already closed.");
        }
        Object object = this.lock();
        synchronized (object) {
            Entry entry = this.entries().computeIfAbsent(remoteLogSegmentMetadata.remoteLogSegmentId().id(), uuid -> {
                RemoteLogSegmentMetadata remoteLogSegmentMetadata;
                TransactionIndex transactionIndex;
                File file;
                RemoteLogSegmentMetadata remoteLogSegmentMetadata2;
                TimeIndex timeIndex;
                File file2;
                RemoteLogSegmentMetadata remoteLogSegmentMetadata3;
                OffsetIndex offsetIndex;
                File file3;
                long startOffset = remoteLogSegmentMetadata.startOffset();
                String fileName = new StringBuilder(2).append(Long.toString(startOffset)).append("_").append(uuid.toString()).append("_").toString();
                String loadIndexFile$1_suffix = UnifiedLog$.MODULE$.IndexFileSuffix();
                File loadIndexFile$1_indexFile = new File(this.cacheDir(), new StringBuilder(0).append(fileName).append(loadIndexFile$1_suffix).toString());
                if (loadIndexFile$1_indexFile.exists()) {
                    try {
                        file3 = loadIndexFile$1_indexFile;
                        offsetIndex = RemoteIndexCache.$anonfun$getIndexEntry$5(startOffset, file3);
                    }
                    catch (CorruptRecordException loadIndexFile$1_ex) {
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurred while loading the stored index", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> loadIndexFile$1_ex);
                        File loadIndexFile$1_fetchAndCreateIndex$1_tmpIndexFile = new File(this.cacheDir(), new StringBuilder(0).append(fileName).append(loadIndexFile$1_suffix).append(RemoteIndexCache$.MODULE$.TmpFileSuffix()).toString());
                        remoteLogSegmentMetadata3 = remoteLogSegmentMetadata;
                        try (InputStream loadIndexFile$1_fetchAndCreateIndex$1_inputStream = this.remoteStorageManager.fetchIndex(remoteLogSegmentMetadata3, RemoteStorageManager.IndexType.OFFSET);){
                            Files.copy(loadIndexFile$1_fetchAndCreateIndex$1_inputStream, loadIndexFile$1_fetchAndCreateIndex$1_tmpIndexFile.toPath(), new CopyOption[0]);
                        }
                        Utils.atomicMoveWithFallback((Path)loadIndexFile$1_fetchAndCreateIndex$1_tmpIndexFile.toPath(), (Path)loadIndexFile$1_indexFile.toPath(), (boolean)false);
                        file3 = loadIndexFile$1_indexFile;
                        offsetIndex = RemoteIndexCache.$anonfun$getIndexEntry$5(startOffset, file3);
                    }
                } else {
                    File loadIndexFile$1_fetchAndCreateIndex$1_tmpIndexFile = new File(this.cacheDir(), new StringBuilder(0).append(fileName).append(loadIndexFile$1_suffix).append(RemoteIndexCache$.MODULE$.TmpFileSuffix()).toString());
                    remoteLogSegmentMetadata3 = remoteLogSegmentMetadata;
                    try (InputStream loadIndexFile$1_fetchAndCreateIndex$1_inputStream = this.remoteStorageManager.fetchIndex(remoteLogSegmentMetadata3, RemoteStorageManager.IndexType.OFFSET);){
                        Files.copy(loadIndexFile$1_fetchAndCreateIndex$1_inputStream, loadIndexFile$1_fetchAndCreateIndex$1_tmpIndexFile.toPath(), new CopyOption[0]);
                    }
                    Utils.atomicMoveWithFallback((Path)loadIndexFile$1_fetchAndCreateIndex$1_tmpIndexFile.toPath(), (Path)loadIndexFile$1_indexFile.toPath(), (boolean)false);
                    file3 = loadIndexFile$1_indexFile;
                    offsetIndex = RemoteIndexCache.$anonfun$getIndexEntry$5(startOffset, file3);
                }
                OffsetIndex offsetIndex2 = offsetIndex;
                String loadIndexFile$1_suffix2 = UnifiedLog$.MODULE$.TimeIndexFileSuffix();
                File loadIndexFile$1_indexFile2 = new File(this.cacheDir(), new StringBuilder(0).append(fileName).append(loadIndexFile$1_suffix2).toString());
                if (loadIndexFile$1_indexFile2.exists()) {
                    try {
                        file2 = loadIndexFile$1_indexFile2;
                        timeIndex = RemoteIndexCache.$anonfun$getIndexEntry$7(startOffset, file2);
                    }
                    catch (CorruptRecordException loadIndexFile$1_ex) {
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurred while loading the stored index", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> loadIndexFile$1_ex);
                        File loadIndexFile$1_fetchAndCreateIndex$1_tmpIndexFile = new File(this.cacheDir(), new StringBuilder(0).append(fileName).append(loadIndexFile$1_suffix2).append(RemoteIndexCache$.MODULE$.TmpFileSuffix()).toString());
                        remoteLogSegmentMetadata2 = remoteLogSegmentMetadata;
                        try (InputStream loadIndexFile$1_fetchAndCreateIndex$1_inputStream = this.remoteStorageManager.fetchIndex(remoteLogSegmentMetadata2, RemoteStorageManager.IndexType.TIMESTAMP);){
                            Files.copy(loadIndexFile$1_fetchAndCreateIndex$1_inputStream, loadIndexFile$1_fetchAndCreateIndex$1_tmpIndexFile.toPath(), new CopyOption[0]);
                        }
                        Utils.atomicMoveWithFallback((Path)loadIndexFile$1_fetchAndCreateIndex$1_tmpIndexFile.toPath(), (Path)loadIndexFile$1_indexFile2.toPath(), (boolean)false);
                        file2 = loadIndexFile$1_indexFile2;
                        timeIndex = RemoteIndexCache.$anonfun$getIndexEntry$7(startOffset, file2);
                    }
                } else {
                    File loadIndexFile$1_fetchAndCreateIndex$1_tmpIndexFile = new File(this.cacheDir(), new StringBuilder(0).append(fileName).append(loadIndexFile$1_suffix2).append(RemoteIndexCache$.MODULE$.TmpFileSuffix()).toString());
                    remoteLogSegmentMetadata2 = remoteLogSegmentMetadata;
                    try (InputStream loadIndexFile$1_fetchAndCreateIndex$1_inputStream = this.remoteStorageManager.fetchIndex(remoteLogSegmentMetadata2, RemoteStorageManager.IndexType.TIMESTAMP);){
                        Files.copy(loadIndexFile$1_fetchAndCreateIndex$1_inputStream, loadIndexFile$1_fetchAndCreateIndex$1_tmpIndexFile.toPath(), new CopyOption[0]);
                    }
                    Utils.atomicMoveWithFallback((Path)loadIndexFile$1_fetchAndCreateIndex$1_tmpIndexFile.toPath(), (Path)loadIndexFile$1_indexFile2.toPath(), (boolean)false);
                    file2 = loadIndexFile$1_indexFile2;
                    timeIndex = RemoteIndexCache.$anonfun$getIndexEntry$7(startOffset, file2);
                }
                TimeIndex timeIndex2 = timeIndex;
                String loadIndexFile$1_suffix3 = UnifiedLog$.MODULE$.TxnIndexFileSuffix();
                File loadIndexFile$1_indexFile3 = new File(this.cacheDir(), new StringBuilder(0).append(fileName).append(loadIndexFile$1_suffix3).toString());
                if (loadIndexFile$1_indexFile3.exists()) {
                    try {
                        file = loadIndexFile$1_indexFile3;
                        transactionIndex = RemoteIndexCache.$anonfun$getIndexEntry$9(startOffset, file);
                    }
                    catch (CorruptRecordException loadIndexFile$1_ex) {
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurred while loading the stored index", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> loadIndexFile$1_ex);
                        File loadIndexFile$1_fetchAndCreateIndex$1_tmpIndexFile = new File(this.cacheDir(), new StringBuilder(0).append(fileName).append(loadIndexFile$1_suffix3).append(RemoteIndexCache$.MODULE$.TmpFileSuffix()).toString());
                        remoteLogSegmentMetadata = remoteLogSegmentMetadata;
                        try (InputStream loadIndexFile$1_fetchAndCreateIndex$1_inputStream = this.remoteStorageManager.fetchIndex(remoteLogSegmentMetadata, RemoteStorageManager.IndexType.TRANSACTION);){
                            Files.copy(loadIndexFile$1_fetchAndCreateIndex$1_inputStream, loadIndexFile$1_fetchAndCreateIndex$1_tmpIndexFile.toPath(), new CopyOption[0]);
                        }
                        Utils.atomicMoveWithFallback((Path)loadIndexFile$1_fetchAndCreateIndex$1_tmpIndexFile.toPath(), (Path)loadIndexFile$1_indexFile3.toPath(), (boolean)false);
                        file = loadIndexFile$1_indexFile3;
                        transactionIndex = RemoteIndexCache.$anonfun$getIndexEntry$9(startOffset, file);
                    }
                } else {
                    File loadIndexFile$1_fetchAndCreateIndex$1_tmpIndexFile = new File(this.cacheDir(), new StringBuilder(0).append(fileName).append(loadIndexFile$1_suffix3).append(RemoteIndexCache$.MODULE$.TmpFileSuffix()).toString());
                    remoteLogSegmentMetadata = remoteLogSegmentMetadata;
                    try (InputStream loadIndexFile$1_fetchAndCreateIndex$1_inputStream = this.remoteStorageManager.fetchIndex(remoteLogSegmentMetadata, RemoteStorageManager.IndexType.TRANSACTION);){
                        Files.copy(loadIndexFile$1_fetchAndCreateIndex$1_inputStream, loadIndexFile$1_fetchAndCreateIndex$1_tmpIndexFile.toPath(), new CopyOption[0]);
                    }
                    Utils.atomicMoveWithFallback((Path)loadIndexFile$1_fetchAndCreateIndex$1_tmpIndexFile.toPath(), (Path)loadIndexFile$1_indexFile3.toPath(), (boolean)false);
                    file = loadIndexFile$1_indexFile3;
                    transactionIndex = RemoteIndexCache.$anonfun$getIndexEntry$9(startOffset, file);
                }
                TransactionIndex txnIndex = transactionIndex;
                return new Entry(offsetIndex2, timeIndex2, txnIndex);
            });
            return entry;
        }
    }

    public int lookupOffset(RemoteLogSegmentMetadata remoteLogSegmentMetadata, long offset) {
        return this.getIndexEntry((RemoteLogSegmentMetadata)remoteLogSegmentMetadata).lookupOffset((long)offset).position;
    }

    public int lookupTimestamp(RemoteLogSegmentMetadata remoteLogSegmentMetadata, long timestamp, long startingOffset) {
        return this.getIndexEntry((RemoteLogSegmentMetadata)remoteLogSegmentMetadata).lookupTimestamp((long)timestamp, (long)startingOffset).position;
    }

    @Override
    public void close() {
        this.closed_$eq(true);
        this.cleanerThread().shutdown();
        Object object = this.lock();
        synchronized (object) {
            this.entries().values().stream().forEach(entry -> entry.close());
            return;
        }
    }

    private final Object fetchAndCreateIndex$1(String fileName$1, String suffix$1, Function1 fetchRemoteIndex$1, RemoteLogSegmentMetadata remoteLogSegmentMetadata$1, File indexFile$1, Function1 readIndex$1) {
        File tmpIndexFile = new File(this.cacheDir(), new StringBuilder(0).append(fileName$1).append(suffix$1).append(RemoteIndexCache$.MODULE$.TmpFileSuffix()).toString());
        try (InputStream inputStream = (InputStream)fetchRemoteIndex$1.apply((Object)remoteLogSegmentMetadata$1);){
            Files.copy(inputStream, tmpIndexFile.toPath(), new CopyOption[0]);
        }
        Utils.atomicMoveWithFallback((Path)tmpIndexFile.toPath(), (Path)indexFile$1.toPath(), (boolean)false);
        return readIndex$1.apply((Object)indexFile$1);
    }

    private final Object loadIndexFile$1(String fileName, String suffix, Function1 fetchRemoteIndex, Function1 readIndex, RemoteLogSegmentMetadata remoteLogSegmentMetadata$1) {
        File indexFile = new File(this.cacheDir(), new StringBuilder(0).append(fileName).append(suffix).toString());
        if (indexFile.exists()) {
            try {
                return readIndex.apply((Object)indexFile);
            }
            catch (CorruptRecordException ex) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurred while loading the stored index", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> loadIndexFile$1_ex);
                File fetchAndCreateIndex$1_tmpIndexFile = new File(this.cacheDir(), new StringBuilder(0).append(fileName).append(suffix).append(RemoteIndexCache$.MODULE$.TmpFileSuffix()).toString());
                try (InputStream fetchAndCreateIndex$1_inputStream = (InputStream)fetchRemoteIndex.apply((Object)remoteLogSegmentMetadata$1);){
                    Files.copy(fetchAndCreateIndex$1_inputStream, fetchAndCreateIndex$1_tmpIndexFile.toPath(), new CopyOption[0]);
                }
                Utils.atomicMoveWithFallback((Path)fetchAndCreateIndex$1_tmpIndexFile.toPath(), (Path)indexFile.toPath(), (boolean)false);
                return readIndex.apply((Object)indexFile);
            }
        }
        File fetchAndCreateIndex$1_tmpIndexFile = new File(this.cacheDir(), new StringBuilder(0).append(fileName).append(suffix).append(RemoteIndexCache$.MODULE$.TmpFileSuffix()).toString());
        try (InputStream fetchAndCreateIndex$1_inputStream = (InputStream)fetchRemoteIndex.apply((Object)remoteLogSegmentMetadata$1);){
            Files.copy(fetchAndCreateIndex$1_inputStream, fetchAndCreateIndex$1_tmpIndexFile.toPath(), new CopyOption[0]);
        }
        Utils.atomicMoveWithFallback((Path)fetchAndCreateIndex$1_tmpIndexFile.toPath(), (Path)indexFile.toPath(), (boolean)false);
        return readIndex.apply((Object)indexFile);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ OffsetIndex $anonfun$getIndexEntry$5(long startOffset$1, File file) {
        void var3_2;
        OffsetIndex index = new OffsetIndex(file, startOffset$1, Integer.MAX_VALUE, false);
        index.sanityCheck();
        return var3_2;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ TimeIndex $anonfun$getIndexEntry$7(long startOffset$1, File file) {
        void var3_2;
        TimeIndex index = new TimeIndex(file, startOffset$1, Integer.MAX_VALUE, false);
        index.sanityCheck();
        return var3_2;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ TransactionIndex $anonfun$getIndexEntry$9(long startOffset$1, File file) {
        void var3_2;
        TransactionIndex index = new TransactionIndex(startOffset$1, file);
        index.sanityCheck();
        return var3_2;
    }

    public RemoteIndexCache(int maxSize, RemoteStorageManager remoteStorageManager, String logDir) {
        this.kafka$log$remote$RemoteIndexCache$$maxSize = maxSize;
        this.remoteStorageManager = remoteStorageManager;
        Logging.$init$(this);
        this.cacheDir = new File(logDir, RemoteIndexCache$.MODULE$.DirName());
        this.closed = false;
        this.expiredIndexes = new LinkedBlockingQueue();
        this.lock = new Object();
        this.entries = new LinkedHashMap<Uuid, Entry>(this){
            private final /* synthetic */ RemoteIndexCache $outer;

            public boolean removeEldestEntry(Map.Entry<Uuid, Entry> eldest) {
                if (this.size() > this.$outer.kafka$log$remote$RemoteIndexCache$$maxSize) {
                    Entry entry = eldest.getValue();
                    entry.markForCleanup();
                    this.$outer.expiredIndexes().add(entry);
                    return true;
                }
                return false;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.kafka$log$remote$RemoteIndexCache$$maxSize / 2, 0.75f, true);
            }
        };
        this.init();
        this.cleanerThread = new ShutdownableThread(this){
            private final /* synthetic */ RemoteIndexCache $outer;

            public void doWork() {
                while (!this.$outer.closed()) {
                    try {
                        Entry entry = this.$outer.expiredIndexes().take();
                        this.$outer.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Cleaning up index entry ").append(entry).toString());
                        entry.cleanup();
                    }
                    catch (InterruptedException ex) {
                        this.$outer.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cleaner thread was interrupted", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> ex);
                    }
                    catch (Exception ex) {
                        this.$outer.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurred while fetching/cleaning up expired entry", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> ex);
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super("remote-log-index-cleaner");
                this.setDaemon(true);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$doWork$1(kafka.log.remote.Entry ), $anonfun$doWork$2(), $anonfun$doWork$3(java.lang.InterruptedException ), $anonfun$doWork$4(), $anonfun$doWork$5(java.lang.Exception )}, serializedLambda);
            }
        };
        this.cleanerThread().start();
    }
}

