/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientRequestQuotaManager$;
import kafka.server.QuotaType$Request$;
import kafka.utils.QuotaUtils$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005v!B\u0012%\u0011\u0003Ic!B\u0016%\u0011\u0003a\u0003\"B\u001a\u0002\t\u0003!\u0004bB\u001b\u0002\u0005\u0004%\tA\u000e\u0005\u0007u\u0005\u0001\u000b\u0011B\u001c\t\u000fm\n!\u0019!C\u0001m!1A(\u0001Q\u0001\n]Bq!P\u0001C\u0002\u0013\u0005a\b\u0003\u0004C\u0003\u0001\u0006Ia\u0010\u0005\b\u0007\u0006\u0011\r\u0011\"\u0003E\u0011\u0019i\u0015\u0001)A\u0005\u000b\u001a!1\u0006\n\u0001O\u0011!\u00116B!b\u0001\n\u0013\u0019\u0006\u0002C,\f\u0005\u0003\u0005\u000b\u0011\u0002+\t\u0011a[!Q1A\u0005\neC\u0001BZ\u0006\u0003\u0002\u0003\u0006IA\u0017\u0005\tO.\u0011)\u0019!C\u0005Q\"Aqn\u0003B\u0001B\u0003%\u0011\u000e\u0003\u0005q\u0017\t\u0015\r\u0011\"\u0003r\u0011!a8B!A!\u0002\u0013\u0011\b\u0002C?\f\u0005\u000b\u0007I\u0011\u0002@\t\u0013\u0005M1B!A!\u0002\u0013y\bBB\u001a\f\t\u0003\t)\u0002\u0003\u0005\u0002$-\u0011\r\u0011\"\u0003?\u0011\u001d\t)c\u0003Q\u0001\n}B\u0011\"a\n\f\u0005\u0004%I!!\u000b\t\u0011\u0005M2\u0002)A\u0005\u0003WA\u0011\"!\u000e\f\u0005\u0004%\t!a\u000e\t\u0011\u0005}2\u0002)A\u0005\u0003sAq!!\u0011\f\t\u0003\t\u0019\u0005C\u0004\u0002P-!\t!!\u0015\t\u000f\u0005U4\u0002\"\u0001\u0002x!9\u00111P\u0006\u0005R\u0005u\u0004bBAF\u0017\u0011E\u0013Q\u0012\u0005\b\u00033[A\u0011BAN\u0003e\u0019E.[3oiJ+\u0017/^3tiF+x\u000e^1NC:\fw-\u001a:\u000b\u0005\u00152\u0013AB:feZ,'OC\u0001(\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"AK\u0001\u000e\u0003\u0011\u0012\u0011d\u00117jK:$(+Z9vKN$\u0018+^8uC6\u000bg.Y4feN\u0011\u0011!\f\t\u0003]Ej\u0011a\f\u0006\u0002a\u0005)1oY1mC&\u0011!g\f\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005I\u0013AG)v_R\f'+Z9vKN$\b+\u001a:dK:$H)\u001a4bk2$X#A\u001c\u0011\u00059B\u0014BA\u001d0\u0005\u0019!u.\u001e2mK\u0006Y\u0012+^8uCJ+\u0017/^3tiB+'oY3oi\u0012+g-Y;mi\u0002\n!DT1o_N$v\u000eU3sG\u0016tG/Y4f!\u0016\u00148+Z2p]\u0012\f1DT1o_N$v\u000eU3sG\u0016tG/Y4f!\u0016\u00148+Z2p]\u0012\u0004\u0013\u0001\r#fM\u0006,H\u000e^%oC\u000e$\u0018N^3Fq\u0016l\u0007\u000f^*f]N|'/\u0012=qSJ\fG/[8o)&lWmU3d_:$7/F\u0001@!\tq\u0003)\u0003\u0002B_\t!Aj\u001c8h\u0003E\"UMZ1vYRLe.Y2uSZ,W\t_3naR\u001cVM\\:pe\u0016C\b/\u001b:bi&|g\u000eV5nKN+7m\u001c8eg\u0002\n\u0001#\u0012=f[B$8+\u001a8t_Jt\u0015-\\3\u0016\u0003\u0015\u0003\"AR&\u000e\u0003\u001dS!\u0001S%\u0002\t1\fgn\u001a\u0006\u0002\u0015\u0006!!.\u0019<b\u0013\tauI\u0001\u0004TiJLgnZ\u0001\u0012\u000bb,W\u000e\u001d;TK:\u001cxN\u001d(b[\u0016\u00043CA\u0006P!\tQ\u0003+\u0003\u0002RI\t\u00112\t\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0003\u0019\u0019wN\u001c4jOV\tA\u000b\u0005\u0002++&\u0011a\u000b\n\u0002\u0019\u00072LWM\u001c;Rk>$\u0018-T1oC\u001e,'oQ8oM&<\u0017aB2p]\u001aLw\rI\u0001\b[\u0016$(/[2t+\u0005Q\u0006CA.e\u001b\u0005a&B\u0001-^\u0015\tqv,\u0001\u0004d_6lwN\u001c\u0006\u0003O\u0001T!!\u00192\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0017aA8sO&\u0011Q\r\u0018\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013\u0001\u0002;j[\u0016,\u0012!\u001b\t\u0003U6l\u0011a\u001b\u0006\u0003Yv\u000bQ!\u001e;jYNL!A\\6\u0003\tQKW.Z\u0001\u0006i&lW\rI\u0001\u0011i\"\u0014X-\u00193OC6,\u0007K]3gSb,\u0012A\u001d\t\u0003gjt!\u0001\u001e=\u0011\u0005U|S\"\u0001<\u000b\u0005]D\u0013A\u0002\u001fs_>$h(\u0003\u0002z_\u00051\u0001K]3eK\u001aL!\u0001T>\u000b\u0005e|\u0013!\u0005;ie\u0016\fGMT1nKB\u0013XMZ5yA\u0005i\u0011/^8uC\u000e\u000bG\u000e\u001c2bG.,\u0012a \t\u0006]\u0005\u0005\u0011QA\u0005\u0004\u0003\u0007y#AB(qi&|g\u000e\u0005\u0003\u0002\b\u0005=QBAA\u0005\u0015\u0011\tY!!\u0004\u0002\u000bE,x\u000e^1\u000b\u0005\u0015z\u0016\u0002BA\t\u0003\u0013\u00111c\u00117jK:$\u0018+^8uC\u000e\u000bG\u000e\u001c2bG.\fa\"];pi\u0006\u001c\u0015\r\u001c7cC\u000e\\\u0007\u0005\u0006\u0007\u0002\u0018\u0005e\u00111DA\u000f\u0003?\t\t\u0003\u0005\u0002+\u0017!)!K\u0006a\u0001)\")\u0001L\u0006a\u00015\")qM\u0006a\u0001S\")\u0001O\u0006a\u0001e\")QP\u0006a\u0001\u007f\u0006\tR.\u0019=UQJ|G\u000f\u001e7f)&lW-T:\u0002%5\f\u0007\u0010\u00165s_R$H.\u001a+j[\u0016l5\u000fI\u0001\u0011Kb,W\u000e\u001d;NKR\u0014\u0018n\u0019(b[\u0016,\"!a\u000b\u0011\t\u00055\u0012qF\u0007\u0002;&\u0019\u0011\u0011G/\u0003\u00155+GO]5d\u001d\u0006lW-A\tfq\u0016l\u0007\u000f^'fiJL7MT1nK\u0002\nA\"\u001a=f[B$8+\u001a8t_J,\"!!\u000f\u0011\u0007m\u000bY$C\u0002\u0002>q\u0013aaU3og>\u0014\u0018!D3yK6\u0004HoU3og>\u0014\b%\u0001\u0007sK\u000e|'\u000fZ#yK6\u0004H\u000f\u0006\u0003\u0002F\u0005-\u0003c\u0001\u0018\u0002H%\u0019\u0011\u0011J\u0018\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003\u001bj\u0002\u0019A\u001c\u0002\u000bY\fG.^3\u0002?5\f\u0017PY3SK\u000e|'\u000fZ!oI\u001e+G\u000f\u00165s_R$H.\u001a+j[\u0016l5\u000f\u0006\u0004\u0002T\u0005e\u0013\u0011\u000f\t\u0004]\u0005U\u0013bAA,_\t\u0019\u0011J\u001c;\t\u000f\u0005mc\u00041\u0001\u0002^\u00059!/Z9vKN$\b\u0003BA0\u0003WrA!!\u0019\u0002h5\u0011\u00111\r\u0006\u0004\u0003K2\u0013a\u00028fi^|'o[\u0005\u0005\u0003S\n\u0019'\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\n\t\u00055\u0014q\u000e\u0002\b%\u0016\fX/Z:u\u0015\u0011\tI'a\u0019\t\r\u0005Md\u00041\u0001@\u0003\u0019!\u0018.\\3Ng\u0006\tR.Y=cKJ+7m\u001c:e\u000bb,W\u000e\u001d;\u0015\t\u0005\u0015\u0013\u0011\u0010\u0005\b\u00037z\u0002\u0019AA/\u00031!\bN]8ui2,G+[7f)\u0015y\u0014qPAE\u0011\u001d\t\t\t\ta\u0001\u0003\u0007\u000b\u0011!\u001a\t\u00047\u0006\u0015\u0015bAAD9\n9\u0012+^8uCZKw\u000e\\1uS>tW\t_2faRLwN\u001c\u0005\u0007\u0003g\u0002\u0003\u0019A \u0002+\rd\u0017.\u001a8u#V|G/Y'fiJL7MT1nKR!\u00111FAH\u0011\u001d\t\t*\ta\u0001\u0003'\u000bq\"];pi\u0006lU\r\u001e:jGR\u000bwm\u001d\t\u0006g\u0006U%O]\u0005\u0004\u0003/[(aA'ba\u0006\tb.\u00198pgR{\u0007+\u001a:dK:$\u0018mZ3\u0015\u0007]\ni\n\u0003\u0004\u0002 \n\u0002\raP\u0001\u0006]\u0006twn\u001d")
public class ClientRequestQuotaManager
extends ClientQuotaManager {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final Time time;
    private final String threadNamePrefix;
    private final Option<ClientQuotaCallback> quotaCallback;
    private final long maxThrottleTimeMs;
    private final MetricName exemptMetricName;
    private final Sensor exemptSensor;

    public static long DefaultInactiveExemptSensorExpirationTimeSeconds() {
        return ClientRequestQuotaManager$.MODULE$.DefaultInactiveExemptSensorExpirationTimeSeconds();
    }

    public static double NanosToPercentagePerSecond() {
        return ClientRequestQuotaManager$.MODULE$.NanosToPercentagePerSecond();
    }

    public static double QuotaRequestPercentDefault() {
        return ClientRequestQuotaManager$.MODULE$.QuotaRequestPercentDefault();
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private Time time() {
        return this.time;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private Option<ClientQuotaCallback> quotaCallback() {
        return this.quotaCallback;
    }

    private long maxThrottleTimeMs() {
        return this.maxThrottleTimeMs;
    }

    private MetricName exemptMetricName() {
        return this.exemptMetricName;
    }

    public Sensor exemptSensor() {
        return this.exemptSensor;
    }

    public void recordExempt(double value) {
        this.exemptSensor().record(value);
    }

    public int maybeRecordAndGetThrottleTimeMs(RequestChannel.Request request, long timeMs) {
        if (this.quotasEnabled()) {
            request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable & scala.Serializable)timeNanos -> this.recordNoThrottle(request.session(), request.header().clientId(), this.nanosToPercentage(timeNanos))));
            return this.recordAndGetThrottleTimeMs(request.session(), request.header().clientId(), this.nanosToPercentage(request.requestThreadTimeNanos()), timeMs);
        }
        return 0;
    }

    public void maybeRecordExempt(RequestChannel.Request request) {
        if (this.quotasEnabled()) {
            request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable & scala.Serializable)timeNanos -> this.recordExempt(this.nanosToPercentage(timeNanos))));
            this.recordExempt(this.nanosToPercentage(request.requestThreadTimeNanos()));
        }
    }

    @Override
    public long throttleTime(QuotaViolationException e, long timeMs) {
        return QuotaUtils$.MODULE$.boundedThrottleTime(e, this.maxThrottleTimeMs(), timeMs);
    }

    @Override
    public MetricName clientQuotaMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("request-time", QuotaType$Request$.MODULE$.toString(), "Tracking request-time per user/client-id", (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(quotaMetricTags).asJava());
    }

    private double nanosToPercentage(long nanos) {
        return (double)nanos * ClientRequestQuotaManager$.MODULE$.NanosToPercentagePerSecond();
    }

    public ClientRequestQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, Time time, String threadNamePrefix, Option<ClientQuotaCallback> quotaCallback) {
        this.config = config;
        this.metrics = metrics;
        this.time = time;
        this.threadNamePrefix = threadNamePrefix;
        this.quotaCallback = quotaCallback;
        super(config, metrics, QuotaType$Request$.MODULE$, time, threadNamePrefix, quotaCallback);
        this.maxThrottleTimeMs = TimeUnit.SECONDS.toMillis(config.quotaWindowSizeSeconds());
        this.exemptMetricName = metrics.metricName("exempt-request-time", QuotaType$Request$.MODULE$.toString(), "Tracking exempt-request-time utilization percentage");
        this.exemptSensor = this.getOrCreateSensor(ClientRequestQuotaManager$.MODULE$.kafka$server$ClientRequestQuotaManager$$ExemptSensorName(), ClientRequestQuotaManager$.MODULE$.DefaultInactiveExemptSensorExpirationTimeSeconds(), (Function1<Sensor, BoxedUnit>)(Function1 & Serializable & scala.Serializable)sensor -> {
            sensor.add(this.exemptMetricName(), (MeasurableStat)new Rate());
            return BoxedUnit.UNIT;
        });
    }
}

