/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.BrokerDynamicThreadPool;
import kafka.server.BrokerReconfigurable;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.ControllerDynamicThreadPool;
import kafka.server.ControllerServer;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicClientQuotaCallback;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicListenerConfig;
import kafka.server.DynamicLogConfig;
import kafka.server.DynamicMetricsReporters;
import kafka.server.DynamicProducerStateManagerConfig;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer$BrokerRole$;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.utils.PasswordEncoder;
import kafka.utils.PasswordEncoder$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ListenerReconfigurable;
import org.apache.kafka.common.utils.ConfigUtils;
import org.apache.kafka.server.authorizer.Authorizer;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSetLike;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0011\u001dr!B+W\u0011\u0003Yf!B/W\u0011\u0003q\u0006\"B3\u0002\t\u00031\u0007\u0002C4\u0002\u0005\u0004%\tA\u00165\t\re\f\u0001\u0015!\u0003j\u0011\u001dQ\u0018A1A\u0005\u0002!Daa_\u0001!\u0002\u0013I\u0007b\u0002?\u0002\u0005\u0004%I! \u0005\b\u0003\u0007\t\u0001\u0015!\u0003\u007f\u0011!\t)!\u0001b\u0001\n\u0013A\u0007bBA\u0004\u0003\u0001\u0006I!\u001b\u0005\t\u0003\u0013\t!\u0019!C\u0005{\"9\u00111B\u0001!\u0002\u0013q\b\u0002CA\u0007\u0003\t\u0007I\u0011B?\t\u000f\u0005=\u0011\u0001)A\u0005}\"I\u0011\u0011C\u0001C\u0002\u0013\u0005\u00111\u0003\u0005\t\u0003K\t\u0001\u0015!\u0003\u0002\u0016!A\u0011qE\u0001C\u0002\u0013%\u0001\u000eC\u0004\u0002*\u0005\u0001\u000b\u0011B5\t\u000f\u0005-\u0012\u0001\"\u0001\u0002.!9\u0011QJ\u0001\u0005\u0002\u0005=\u0003bBA5\u0003\u0011\u0005\u00111\u000e\u0005\b\u0003\u000b\u000bA\u0011BAD\u0011\u001d\ti)\u0001C\u0005\u0003\u001fCq!a%\u0002\t\u0013\t)\nC\u0004\u0002\u001a\u0006!I!a'\t\u0011\u0005}\u0015\u0001\"\u0001W\u0003CC\u0001\"!1\u0002\t\u00031\u00161\u0019\u0005\t\u0003\u0017\fA\u0011\u0001,\u0002N\u001a)QL\u0016\u0001\u0002T\"Q\u0011\u0011]\u000f\u0003\u0006\u0004%I!a9\t\u0015\u0005-XD!A!\u0002\u0013\t)\u000f\u0003\u0004f;\u0011\u0005\u0011Q\u001e\u0005\u000b\u0003gl\"\u0019!C\u0001-\u0006U\b\u0002CA~;\u0001\u0006I!a>\t\u0015\u0005uXD1A\u0005\u0002Y\u000b)\u0010\u0003\u0005\u0002\u0000v\u0001\u000b\u0011BA|\u0011%\u0011\t!\bb\u0001\n\u0013\u0011\u0019\u0001\u0003\u0005\u0003\bu\u0001\u000b\u0011\u0002B\u0003\u0011%\u0011I!\bb\u0001\n\u0013\u0011\u0019\u0001\u0003\u0005\u0003\fu\u0001\u000b\u0011\u0002B\u0003\u0011)\u0011i!\bb\u0001\n\u00031&q\u0002\u0005\t\u0005Ki\u0002\u0015!\u0003\u0003\u0012!I!qE\u000fC\u0002\u0013%!\u0011\u0006\u0005\t\u0005gi\u0002\u0015!\u0003\u0003,!I!QG\u000fC\u0002\u0013%!q\u0007\u0005\t\u0005\u000bj\u0002\u0015!\u0003\u0003:!Y!qI\u000fA\u0002\u0003\u0007I\u0011BAr\u0011-\u0011I%\ba\u0001\u0002\u0004%IAa\u0013\t\u0017\tES\u00041A\u0001B\u0003&\u0011Q\u001d\u0005\n\u0005'j\"\u0019!C\u0005\u0005+B\u0001Ba\u0019\u001eA\u0003%!q\u000b\u0005\t\u0005KjB\u0011\u0001,\u0003h!A!1P\u000f\u0005\u0002Y\u0013i\bC\u0004\u0003\u0000u!\tA!!\t\u000f\t}T\u0004\"\u0001\u0003\u000e\"9!\u0011T\u000f\u0005\u0002\tm\u0005b\u0002BQ;\u0011\u0005!1\u0015\u0005\b\u0005OkB\u0011\u0001BU\u0011\u001d\u0011i+\bC\u0005\u0005_C\u0001B!.\u001e\t\u00031\u00161\u001d\u0005\t\u0005okB\u0011\u0001,\u0003:\"A!qX\u000f\u0005\u0002Y\u0013I\f\u0003\u0005\u0003Bv!\tA\u0016Bb\u0011)\u00119.HI\u0001\n\u00031&\u0011\u001c\u0005\t\u0005_lB\u0011\u0001,\u0003r\"Q!q_\u000f\u0012\u0002\u0013\u0005aK!7\t\u0011\teX\u0004\"\u0001W\u0005wDqa!\u0001\u001e\t\u0013\u0019\u0019\u0001C\u0004\u0004\u0018u!Ia!\u0007\t\u0011\rmQ\u0004\"\u0001W\u0007;A\u0001b!\n\u001e\t\u000316q\u0005\u0005\b\u0007[iB\u0011BB\u0018\u0011\u001d\u0019i$\bC\u0005\u0007\u007fA\u0001ba\u0012\u001e\t\u000316\u0011\n\u0005\b\u0007\u001fjB\u0011BB)\u0011!\u00199&\bC\u0001-\u000ee\u0003bBB@;\u0011%1\u0011\u0011\u0005\b\u0007[kB\u0011BBX\u0011\u001d\u0019),\bC\u0005\u0007oCqaa/\u001e\t\u0013\u0019i\fC\u0005\u0004Lv\t\n\u0011\"\u0003\u0003Z\"91QZ\u000f\u0005\n\r=\u0007bBBq;\u0011%11\u001d\u0005\b\t\u0013iB\u0011\u0002C\u0006\u0003M!\u0015P\\1nS\u000e\u0014%o\\6fe\u000e{gNZ5h\u0015\t9\u0006,\u0001\u0004tKJ4XM\u001d\u0006\u00023\u0006)1.\u00194lC\u000e\u0001\u0001C\u0001/\u0002\u001b\u00051&a\u0005#z]\u0006l\u0017n\u0019\"s_.,'oQ8oM&<7CA\u0001`!\t\u00017-D\u0001b\u0015\u0005\u0011\u0017!B:dC2\f\u0017B\u00013b\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012aW\u0001\u0017\tft\u0017-\\5d'\u0016\u001cWO]5us\u000e{gNZ5hgV\t\u0011\u000eE\u0002k_Fl\u0011a\u001b\u0006\u0003Y6\fq!\\;uC\ndWM\u0003\u0002oC\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005A\\'aA*fiB\u0011!o^\u0007\u0002g*\u0011A/^\u0001\u0005Y\u0006twMC\u0001w\u0003\u0011Q\u0017M^1\n\u0005a\u001c(AB*ue&tw-A\fEs:\fW.[2TK\u000e,(/\u001b;z\u0007>tg-[4tA\u0005\t\u0012\t\u001c7Es:\fW.[2D_:4\u0017nZ:\u0002%\u0005cG\u000eR=oC6L7mQ8oM&<7\u000fI\u0001\u001c\u00072,8\u000f^3s\u0019\u00164X\r\u001c'jgR,g.\u001a:D_:4\u0017nZ:\u0016\u0003y\u0004Ba`A\u0001c6\tQ.\u0003\u0002q[\u0006a2\t\\;ti\u0016\u0014H*\u001a<fY2K7\u000f^3oKJ\u001cuN\u001c4jON\u0004\u0013\u0001\u0005)fe\n\u0013xn[3s\u0007>tg-[4t\u0003E\u0001VM\u001d\"s_.,'oQ8oM&<7\u000fI\u0001\u0019\u0019&\u001cH/\u001a8fe6+7\r[1oSNl7i\u001c8gS\u001e\u001c\u0018!\u0007'jgR,g.\u001a:NK\u000eD\u0017M\\5t[\u000e{gNZ5hg\u0002\nQCU3m_\u0006$\u0017M\u00197f\r&dWmQ8oM&<7/\u0001\fSK2|\u0017\rZ1cY\u00164\u0015\u000e\\3D_:4\u0017nZ:!\u0003Ma\u0015n\u001d;f]\u0016\u00148i\u001c8gS\u001e\u0014VmZ3y+\t\t)\u0002\u0005\u0003\u0002\u0018\u0005\u0005RBAA\r\u0015\u0011\tY\"!\b\u0002\u00115\fGo\u00195j]\u001eT1!a\bb\u0003\u0011)H/\u001b7\n\t\u0005\r\u0012\u0011\u0004\u0002\u0006%\u0016<W\r_\u0001\u0015\u0019&\u001cH/\u001a8fe\u000e{gNZ5h%\u0016<W\r\u001f\u0011\u0002-\u0011Kh.Y7jGB\u000b7o]<pe\u0012\u001cuN\u001c4jON\fq\u0003R=oC6L7\rU1tg^|'\u000fZ\"p]\u001aLwm\u001d\u0011\u0002!%\u001c\b+Y:to>\u0014HmQ8oM&<G\u0003BA\u0018\u0003k\u00012\u0001YA\u0019\u0013\r\t\u0019$\u0019\u0002\b\u0005>|G.Z1o\u0011\u001d\t9d\u0005a\u0001\u0003s\tAA\\1nKB!\u00111HA%\u001d\u0011\ti$!\u0012\u0011\u0007\u0005}\u0012-\u0004\u0002\u0002B)\u0019\u00111\t.\u0002\rq\u0012xn\u001c;?\u0013\r\t9%Y\u0001\u0007!J,G-\u001a4\n\u0007a\fYEC\u0002\u0002H\u0005\fAC\u0019:pW\u0016\u00148i\u001c8gS\u001e\u001c\u0016P\\8os6\u001cHCBA)\u0003G\n)\u0007\u0005\u0004\u0002T\u0005u\u0013\u0011\b\b\u0005\u0003+\nIF\u0004\u0003\u0002@\u0005]\u0013\"\u00012\n\u0007\u0005m\u0013-A\u0004qC\u000e\\\u0017mZ3\n\t\u0005}\u0013\u0011\r\u0002\u0005\u0019&\u001cHOC\u0002\u0002\\\u0005Dq!a\u000e\u0015\u0001\u0004\tI\u0004C\u0004\u0002hQ\u0001\r!a\f\u0002+5\fGo\u00195MSN$XM\\3s\u001fZ,'O]5eK\u0006ya/\u00197jI\u0006$XmQ8oM&<7\u000f\u0006\u0004\u0002n\u0005M\u0014\u0011\u0011\t\u0004A\u0006=\u0014bAA9C\n!QK\\5u\u0011\u001d\t)(\u0006a\u0001\u0003o\nQ\u0001\u001d:paN\u0004B!!\u001f\u0002~5\u0011\u00111\u0010\u0006\u0004\u0003?)\u0018\u0002BA@\u0003w\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d\t\u0019)\u0006a\u0001\u0003_\tq\u0002]3s\u0005J|7.\u001a:D_:4\u0017nZ\u0001\u0011a\u0016\u0014(I]8lKJ\u001cuN\u001c4jON$B!!#\u0002\fB)q0!\u0001\u0002:!9\u0011Q\u000f\fA\u0002\u0005]\u0014!\u00058p]\u0012Kh.Y7jG\u000e{gNZ5hgR!\u0011\u0011RAI\u0011\u001d\t)h\u0006a\u0001\u0003o\nAe]3dkJLG/_\"p]\u001aLwm],ji\"|W\u000f\u001e'jgR,g.\u001a:Qe\u00164\u0017\u000e\u001f\u000b\u0005\u0003\u0013\u000b9\nC\u0004\u0002va\u0001\r!a\u001e\u0002'Y\fG.\u001b3bi\u0016\u001cuN\u001c4jORK\b/Z:\u0015\t\u00055\u0014Q\u0014\u0005\b\u0003kJ\u0002\u0019AA<\u0003E\tG\r\u001a#z]\u0006l\u0017nY\"p]\u001aLwm\u001d\u000b\u0005\u0003[\n\u0019\u000bC\u0004\u0002&j\u0001\r!a*\u0002\u0013\r|gNZ5h\t\u00164\u0007\u0003BAU\u0003{k!!a+\u000b\t\u00055\u0016qV\u0001\u0007G>tg-[4\u000b\t\u0005E\u00161W\u0001\u0007G>lWn\u001c8\u000b\u0007e\u000b)L\u0003\u0003\u00028\u0006e\u0016AB1qC\u000eDWM\u0003\u0002\u0002<\u0006\u0019qN]4\n\t\u0005}\u00161\u0016\u0002\n\u0007>tg-[4EK\u001a\f\u0001\u0004Z=oC6L7mQ8oM&<W\u000b\u001d3bi\u0016lu\u000eZ3t+\t\t)\r\u0005\u0005\u0002z\u0005\u001d\u0017\u0011HA\u001d\u0013\u0011\tI-a\u001f\u0003\u00075\u000b\u0007/\u0001\fsKN|GN^3WCJL\u0017M\u00197f\u0007>tg-[4t)\u0011\t9(a4\t\u000f\u0005EG\u00041\u0001\u0002x\u0005i\u0001O]8qg>\u0013\u0018nZ5oC2\u001cB!H0\u0002VB!\u0011q[Ao\u001b\t\tINC\u0002\u0002\\b\u000bQ!\u001e;jYNLA!a8\u0002Z\n9Aj\\4hS:<\u0017aC6bM.\f7i\u001c8gS\u001e,\"!!:\u0011\u0007q\u000b9/C\u0002\u0002jZ\u00131bS1gW\u0006\u001cuN\u001c4jO\u0006a1.\u00194lC\u000e{gNZ5hAQ!\u0011q^Ay!\taV\u0004C\u0004\u0002b\u0002\u0002\r!!:\u0002'M$\u0018\r^5d\u0005J|7.\u001a:D_:4\u0017nZ:\u0016\u0005\u0005]\b#\u00026\u0002zF\f\u0018bAAeW\u0006!2\u000f^1uS\u000e\u0014%o\\6fe\u000e{gNZ5hg\u0002\nAc\u001d;bi&\u001cG)\u001a4bk2$8i\u001c8gS\u001e\u001c\u0018!F:uCRL7\rR3gCVdGoQ8oM&<7\u000fI\u0001\u0015Ift\u0017-\\5d\u0005J|7.\u001a:D_:4\u0017nZ:\u0016\u0005\t\u0015\u0001c\u00026\u0002z\u0006e\u0012\u0011H\u0001\u0016Ift\u0017-\\5d\u0005J|7.\u001a:D_:4\u0017nZ:!\u0003U!\u0017P\\1nS\u000e$UMZ1vYR\u001cuN\u001c4jON\fa\u0003Z=oC6L7\rR3gCVdGoQ8oM&<7\u000fI\u0001\u0010e\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197fgV\u0011!\u0011\u0003\t\u0007\u0005'\u0011IB!\b\u000e\u0005\tU!\u0002\u0002B\f\u0003w\n!bY8oGV\u0014(/\u001a8u\u0013\u0011\u0011YB!\u0006\u0003)\r{\u0007/_(o/JLG/Z!se\u0006LH*[:u!\u0011\u0011yB!\t\u000e\u0005\u0005=\u0016\u0002\u0002B\u0012\u0003_\u0013aBU3d_:4\u0017nZ;sC\ndW-\u0001\tsK\u000e|gNZ5hkJ\f'\r\\3tA\u0005)\"M]8lKJ\u0014VmY8oM&<WO]1cY\u0016\u001cXC\u0001B\u0016!\u0019\u0011\u0019B!\u0007\u0003.A\u0019ALa\f\n\u0007\tEbK\u0001\u000bCe>\\WM\u001d*fG>tg-[4ve\u0006\u0014G.Z\u0001\u0017EJ|7.\u001a:SK\u000e|gNZ5hkJ\f'\r\\3tA\u0005!An\\2l+\t\u0011I\u0004\u0005\u0003\u0003<\t\u0005SB\u0001B\u001f\u0015\u0011\u0011yD!\u0006\u0002\u000b1|7m[:\n\t\t\r#Q\b\u0002\u0017%\u0016,g\u000e\u001e:b]R\u0014V-\u00193Xe&$X\rT8dW\u0006)An\\2lA\u0005i1-\u001e:sK:$8i\u001c8gS\u001e\f\u0011cY;se\u0016tGoQ8oM&<w\fJ3r)\u0011\tiG!\u0014\t\u0013\t=\u0003'!AA\u0002\u0005\u0015\u0018a\u0001=%c\u0005q1-\u001e:sK:$8i\u001c8gS\u001e\u0004\u0013\u0001\b3z]\u0006l\u0017nY\"p]\u001aLw\rU1tg^|'\u000fZ#oG>$WM]\u000b\u0003\u0005/\u0002R\u0001\u0019B-\u0005;J1Aa\u0017b\u0005\u0019y\u0005\u000f^5p]B!\u0011q\u001bB0\u0013\u0011\u0011\t'!7\u0003\u001fA\u000b7o]<pe\u0012,enY8eKJ\fQ\u0004Z=oC6L7mQ8oM&<\u0007+Y:to>\u0014H-\u00128d_\u0012,'\u000fI\u0001\u000bS:LG/[1mSj,G\u0003BA7\u0005SBqAa\u001b5\u0001\u0004\u0011i'A\u0006{W\u000ec\u0017.\u001a8u\u001fB$\b#\u00021\u0003Z\t=\u0004\u0003\u0002B9\u0005oj!Aa\u001d\u000b\u0007\tU\u0004,\u0001\u0002{W&!!\u0011\u0010B:\u00055Y\u0015MZ6b5.\u001cE.[3oi\u0006)1\r\\3beR\u0011\u0011QN\u0001\u0013C\u0012$'+Z2p]\u001aLw-\u001e:bE2,7\u000f\u0006\u0003\u0002n\t\r\u0005b\u0002BCm\u0001\u0007!qQ\u0001\fW\u000647.Y*feZ,'\u000fE\u0002]\u0005\u0013K1Aa#W\u0005-Y\u0015MZ6b\u0005J|7.\u001a:\u0015\t\u00055$q\u0012\u0005\b\u0005#;\u0004\u0019\u0001BJ\u0003)\u0019wN\u001c;s_2dWM\u001d\t\u00049\nU\u0015b\u0001BL-\n\u00012i\u001c8ue>dG.\u001a:TKJ4XM]\u0001\u0012C\u0012$'+Z2p]\u001aLw-\u001e:bE2,G\u0003BA7\u0005;CqAa(9\u0001\u0004\u0011i\"\u0001\bsK\u000e|gNZ5hkJ\f'\r\\3\u0002/\u0005$GM\u0011:pW\u0016\u0014(+Z2p]\u001aLw-\u001e:bE2,G\u0003BA7\u0005KCqAa(:\u0001\u0004\u0011i#\u0001\u000bsK6|g/\u001a*fG>tg-[4ve\u0006\u0014G.\u001a\u000b\u0005\u0003[\u0012Y\u000bC\u0004\u0003 j\u0002\rA!\b\u00027Y,'/\u001b4z%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4t)\u0011\tiG!-\t\u000f\tM6\b1\u0001\u0002\n\u0006Y1m\u001c8gS\u001et\u0015-\\3t\u0003I\u0019WO\u001d:f]R\\\u0015MZ6b\u0007>tg-[4\u00027\r,(O]3oi\u0012Kh.Y7jG\n\u0013xn[3s\u0007>tg-[4t+\t\u0011Y\fE\u0004\u0000\u0005{\u000bI$!\u000f\n\u0007\u0005%W.\u0001\u000fdkJ\u0014XM\u001c;Es:\fW.[2EK\u001a\fW\u000f\u001c;D_:4\u0017nZ:\u0002%U\u0004H-\u0019;f\u0005J|7.\u001a:D_:4\u0017n\u001a\u000b\t\u0003[\u0012)Ma4\u0003T\"9!qY A\u0002\t%\u0017\u0001\u00032s_.,'/\u00133\u0011\u0007\u0001\u0014Y-C\u0002\u0003N\u0006\u00141!\u00138u\u0011\u001d\u0011\tn\u0010a\u0001\u0003o\nq\u0002]3sg&\u001cH/\u001a8u!J|\u0007o\u001d\u0005\n\u0005+|\u0004\u0013!a\u0001\u0003_\tQ\u0001Z8M_\u001e\fA$\u001e9eCR,'I]8lKJ\u001cuN\u001c4jO\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\\*\"\u0011q\u0006BoW\t\u0011y\u000e\u0005\u0003\u0003b\n-XB\u0001Br\u0015\u0011\u0011)Oa:\u0002\u0013Ut7\r[3dW\u0016$'b\u0001BuC\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t5(1\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aE;qI\u0006$X\rR3gCVdGoQ8oM&<GCBA7\u0005g\u0014)\u0010C\u0004\u0003R\u0006\u0003\r!a\u001e\t\u0013\tU\u0017\t%AA\u0002\u0005=\u0012!H;qI\u0006$X\rR3gCVdGoQ8oM&<G\u0005Z3gCVdG\u000f\n\u001a\u0002KI,Gn\\1e+B$\u0017\r^3e\r&dWm],ji\"|W\u000f^\"p]\u001aLwm\u00115b]\u001e,G\u0003BA7\u0005{DqAa@D\u0001\u0004\t9(\u0001\u0005oK^\u0004&o\u001c9t\u0003ii\u0017-\u001f2f\u0007J,\u0017\r^3QCN\u001cxo\u001c:e\u000b:\u001cw\u000eZ3s)\u0011\u00119f!\u0002\t\u000f\r\u001dA\t1\u0001\u0004\n\u000511/Z2sKR\u0004R\u0001\u0019B-\u0007\u0017\u0001Ba!\u0004\u0004\u00145\u00111q\u0002\u0006\u0005\u0007#\tY+A\u0003usB,7/\u0003\u0003\u0004\u0016\r=!\u0001\u0003)bgN<xN\u001d3\u0002\u001fA\f7o]<pe\u0012,enY8eKJ,\"A!\u0018\u0002#Q|\u0007+\u001a:tSN$XM\u001c;Qe>\u00048\u000f\u0006\u0004\u0002x\r}11\u0005\u0005\b\u0007C1\u0005\u0019AA<\u0003-\u0019wN\u001c4jOB\u0013x\u000e]:\t\u000f\u0005\re\t1\u0001\u00020\u0005\u0019bM]8n!\u0016\u00148/[:uK:$\bK]8qgR1\u0011qOB\u0015\u0007WAqA!5H\u0001\u0004\t9\bC\u0004\u0002\u0004\u001e\u0003\r!a\f\u0002-5\f\u0017PY3SK\u0016s7m\u001c3f!\u0006\u001c8o^8sIN$b!a\u001e\u00042\rM\u0002b\u0002Bi\u0011\u0002\u0007\u0011q\u000f\u0005\b\u0007kA\u0005\u0019AB\u001c\u00035\tG-\\5o5.\u001cE.[3oiB!!\u0011OB\u001d\u0013\u0011\u0019YDa\u001d\u0003\u001b\u0005#W.\u001b8[W\u000ec\u0017.\u001a8u\u0003M1\u0018\r\\5eCR,GmS1gW\u0006\u0004&o\u001c9t)\u0019\u0011Yl!\u0011\u0004F!911I%A\u0002\u0005]\u0014!\u00049s_B\u001cxJ^3se&$W\rC\u0004\u0002\u0004&\u0003\r!a\f\u0002\u0011Y\fG.\u001b3bi\u0016$b!!\u001c\u0004L\r5\u0003bBA;\u0015\u0002\u0007\u0011q\u000f\u0005\b\u0003\u0007S\u0005\u0019AA\u0018\u0003Q\u0011X-\\8wK&sg/\u00197jI\u000e{gNZ5hgR1\u0011QNB*\u0007+Bq!!\u001eL\u0001\u0004\t9\bC\u0004\u0002\u0004.\u0003\r!a\f\u0002!5\f\u0017PY3SK\u000e|gNZ5hkJ,G\u0003CA7\u00077\u001aif!\u0019\t\u000f\t}E\n1\u0001\u0003\u001e!91q\f'A\u0002\u0005\u0015\u0018!C8mI\u000e{gNZ5h\u0011\u001d\u0019\u0019\u0007\u0014a\u0001\u0007K\n\u0011B\\3x\u0007>tg-[41\t\r\u001d4Q\u000e\t\t\u0003s\n9-!\u000f\u0004jA!11NB7\u0019\u0001!Aba\u001c\u0004b\u0005\u0005\t\u0011!B\u0001\u0007c\u00121a\u0018\u00132#\u0011\u0019\u0019h!\u001f\u0011\u0007\u0001\u001c)(C\u0002\u0004x\u0005\u0014qAT8uQ&tw\rE\u0002a\u0007wJ1a! b\u0005\r\te._\u0001\u000fkB$\u0017\r^3e\u0007>tg-[4t)\u0019\u0019\u0019ia%\u0004 B9\u0001m!\"\u0004\n\u0006%\u0015bABDC\n1A+\u001e9mKJ\u0002Daa#\u0004\u0010B9!.!?\u0002:\r5\u0005\u0003BB6\u0007\u001f#1b!%N\u0003\u0003\u0005\tQ!\u0001\u0004r\t\u0019q\f\n\u001b\t\u000f\t}X\n1\u0001\u0004\u0016B\"1qSBN!!\tI(a2\u0002:\re\u0005\u0003BB6\u00077#Ab!(\u0004\u0014\u0006\u0005\t\u0011!B\u0001\u0007c\u00121a\u0018\u00133\u0011\u001d\u0019\t+\u0014a\u0001\u0007G\u000bAbY;se\u0016tG\u000f\u0015:paN\u0004Da!*\u0004*BA\u0011\u0011PAd\u0003s\u00199\u000b\u0005\u0003\u0004l\r%F\u0001DBV\u0007?\u000b\t\u0011!A\u0003\u0002\rE$aA0%g\u0005iqN^3se&$W\r\u0015:paN$b!!\u001c\u00042\u000eM\u0006bBA;\u001d\u0002\u0007!Q\u0001\u0005\b\u0007\u0007r\u0005\u0019\u0001B\u0003\u0003M)\b\u000fZ1uK\u000e+(O]3oi\u000e{gNZ5h)\u0011\tig!/\t\u000f\tUw\n1\u0001\u00020\u00051\u0002O]8dKN\u001c(+Z2p]\u001aLw-\u001e:bi&|g\u000e\u0006\u0005\u0004@\u000e\r7QYBe!\u001d\u00017QQAs\u0007\u0003\u0004b!a\u0015\u0002^\t5\u0002b\u0002B\u0000!\u0002\u0007!1\u0018\u0005\b\u0007\u000f\u0004\u0006\u0019AA\u0018\u000311\u0018\r\\5eCR,wJ\u001c7z\u0011%\u0011)\u000e\u0015I\u0001\u0002\u0004\ty#\u0001\u0011qe>\u001cWm]:SK\u000e|gNZ5hkJ\fG/[8oI\u0011,g-Y;mi\u0012\u001a\u0014\u0001\u00068fK\u0012\u001c(+Z2p]\u001aLw-\u001e:bi&|g\u000e\u0006\u0005\u00020\rE7\u0011\\Bo\u0011\u001d\u0019\u0019N\u0015a\u0001\u0007+\fQC]3d_:4\u0017nZ;sC\ndWmQ8oM&<7\u000f\u0005\u0004\u0002z\r]\u0017\u0011H\u0005\u0004a\u0006m\u0004bBBn%\u0002\u0007\u0011\u0011R\u0001\fkB$\u0017\r^3e\u0017\u0016L8\u000fC\u0004\u0004`J\u0003\r!!#\u0002\u0017\u0011,G.\u001a;fI.+\u0017p]\u0001\u001eaJ|7-Z:t\u0019&\u001cH/\u001a8feJ+7m\u001c8gS\u001e,(/\u00192mKRa\u0011QNBs\u0007k\u001c9\u0010b\u0001\u0005\u0006!91q]*A\u0002\r%\u0018A\u00067jgR,g.\u001a:SK\u000e|gNZ5hkJ\f'\r\\3\u0011\t\r-8\u0011_\u0007\u0003\u0007[TAaa<\u00020\u00069a.\u001a;x_J\\\u0017\u0002BBz\u0007[\u0014a\u0003T5ti\u0016tWM\u001d*fG>tg-[4ve\u0006\u0014G.\u001a\u0005\b\u0007G\u001a\u0006\u0019AAs\u0011\u001d\u0019Ip\u0015a\u0001\u0007w\fQbY;ti>l7i\u001c8gS\u001e\u001c\b\u0003CA=\u0003\u000f\fId!@\u0011\u0007I\u001cy0C\u0002\u0005\u0002M\u0014aa\u00142kK\u000e$\bbBBd'\u0002\u0007\u0011q\u0006\u0005\b\t\u000f\u0019\u0006\u0019AA\u0018\u0003)\u0011X\r\\8bI>sG._\u0001\u0016aJ|7-Z:t%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f)1\ti\u0007\"\u0004\u0005\u0010\u0011MA\u0011\u0005C\u0013\u0011\u001d\u0011y\n\u0016a\u0001\u0005;Aq\u0001\"\u0005U\u0001\u0004\tI)\u0001\nva\u0012\fG/\u001a3D_:4\u0017n\u001a(b[\u0016\u001c\bb\u0002C\u000b)\u0002\u0007AqC\u0001\u000eC2dg*Z<D_:4\u0017nZ:1\t\u0011eAQ\u0004\t\t\u0003s\n9-!\u000f\u0005\u001cA!11\u000eC\u000f\t1!y\u0002b\u0005\u0002\u0002\u0003\u0005)\u0011AB9\u0005\ryF%\u000e\u0005\b\tG!\u0006\u0019AB~\u0003AqWm^\"vgR|WnQ8oM&<7\u000fC\u0004\u0004HR\u0003\r!a\f")
public class DynamicBrokerConfig
implements Logging {
    private final KafkaConfig kafkaConfig;
    private final scala.collection.mutable.Map<String, String> staticBrokerConfigs;
    private final scala.collection.mutable.Map<String, String> staticDefaultConfigs;
    private final scala.collection.mutable.Map<String, String> dynamicBrokerConfigs;
    private final scala.collection.mutable.Map<String, String> dynamicDefaultConfigs;
    private final CopyOnWriteArrayList<Reconfigurable> reconfigurables;
    private final CopyOnWriteArrayList<BrokerReconfigurable> brokerReconfigurables;
    private final ReentrantReadWriteLock lock;
    private KafkaConfig currentConfig;
    private final Option<PasswordEncoder> dynamicConfigPasswordEncoder;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void validateConfigs(Properties properties, boolean bl) {
        DynamicBrokerConfig$.MODULE$.validateConfigs(properties, bl);
    }

    public static List<String> brokerConfigSynonyms(String string, boolean bl) {
        return DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(string, bl);
    }

    public static boolean isPasswordConfig(String string) {
        return DynamicBrokerConfig$.MODULE$.isPasswordConfig(string);
    }

    public static Regex ListenerConfigRegex() {
        return DynamicBrokerConfig$.MODULE$.ListenerConfigRegex();
    }

    public static scala.collection.mutable.Set<String> AllDynamicConfigs() {
        return DynamicBrokerConfig$.MODULE$.AllDynamicConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaConfig kafkaConfig() {
        return this.kafkaConfig;
    }

    public scala.collection.mutable.Map<String, String> staticBrokerConfigs() {
        return this.staticBrokerConfigs;
    }

    public scala.collection.mutable.Map<String, String> staticDefaultConfigs() {
        return this.staticDefaultConfigs;
    }

    private scala.collection.mutable.Map<String, String> dynamicBrokerConfigs() {
        return this.dynamicBrokerConfigs;
    }

    private scala.collection.mutable.Map<String, String> dynamicDefaultConfigs() {
        return this.dynamicDefaultConfigs;
    }

    public CopyOnWriteArrayList<Reconfigurable> reconfigurables() {
        return this.reconfigurables;
    }

    private CopyOnWriteArrayList<BrokerReconfigurable> brokerReconfigurables() {
        return this.brokerReconfigurables;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private KafkaConfig currentConfig() {
        return this.currentConfig;
    }

    private void currentConfig_$eq(KafkaConfig x$1) {
        this.currentConfig = x$1;
    }

    private Option<PasswordEncoder> dynamicConfigPasswordEncoder() {
        return this.dynamicConfigPasswordEncoder;
    }

    public void initialize(Option<KafkaZkClient> zkClientOpt) {
        this.currentConfig_$eq(new KafkaConfig(this.kafkaConfig().props(), false, (Option<DynamicBrokerConfig>)None$.MODULE$));
        zkClientOpt.foreach((Function1 & Serializable & scala.Serializable)zkClient -> {
            DynamicBrokerConfig.$anonfun$initialize$1(this, zkClient);
            return BoxedUnit.UNIT;
        });
    }

    public void clear() {
        this.dynamicBrokerConfigs().clear();
        this.dynamicDefaultConfigs().clear();
        this.reconfigurables().clear();
        this.brokerReconfigurables().clear();
    }

    public void addReconfigurables(KafkaBroker kafkaServer) {
        Authorizer authz;
        Option<Authorizer> option = kafkaServer.authorizer();
        if (option instanceof Some && (authz = (Authorizer)((Some)option).value()) instanceof Reconfigurable) {
            this.addReconfigurable((Reconfigurable)authz);
        }
        this.addReconfigurable((Reconfigurable)kafkaServer.kafkaYammerMetrics());
        this.addReconfigurable(new DynamicMetricsReporters(this.kafkaConfig().brokerId(), kafkaServer.config(), kafkaServer.metrics(), kafkaServer.clusterId()));
        this.addReconfigurable(new DynamicClientQuotaCallback(kafkaServer.quotaManagers(), kafkaServer.config()));
        this.addBrokerReconfigurable(new BrokerDynamicThreadPool(kafkaServer));
        this.addBrokerReconfigurable(new DynamicLogConfig(kafkaServer.logManager(), kafkaServer));
        this.addBrokerReconfigurable(new DynamicListenerConfig(kafkaServer));
        this.addBrokerReconfigurable(kafkaServer.socketServer());
        this.addBrokerReconfigurable(new DynamicProducerStateManagerConfig(kafkaServer.logManager().producerStateManagerConfig()));
    }

    public void addReconfigurables(ControllerServer controller) {
        Authorizer authz;
        Option<Authorizer> option = controller.authorizer();
        if (option instanceof Some && (authz = (Authorizer)((Some)option).value()) instanceof Reconfigurable) {
            this.addReconfigurable((Reconfigurable)authz);
        }
        if (!this.kafkaConfig().processRoles().contains((Object)KafkaRaftServer$BrokerRole$.MODULE$)) {
            this.addReconfigurable((Reconfigurable)controller.kafkaYammerMetrics());
            this.addReconfigurable(new DynamicMetricsReporters(this.kafkaConfig().nodeId(), controller.config(), controller.metrics(), controller.clusterId()));
        }
        this.addReconfigurable(new DynamicClientQuotaCallback(controller.quotaManagers(), controller.config()));
        this.addBrokerReconfigurable(new ControllerDynamicThreadPool(controller));
        this.addBrokerReconfigurable(controller.socketServer());
    }

    /*
     * WARNING - void declaration
     */
    public void addReconfigurable(Reconfigurable reconfigurable) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$addReconfigurable$1(this, reconfigurable);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addBrokerReconfigurable(BrokerReconfigurable reconfigurable) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$addBrokerReconfigurable$1(this, reconfigurable);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeReconfigurable(Reconfigurable reconfigurable) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$removeReconfigurable$1(this, reconfigurable);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void verifyReconfigurableConfigs(Set<String> configNames) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$verifyReconfigurableConfigs$1(configNames);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public KafkaConfig currentKafkaConfig() {
        KafkaConfig kafkaConfig;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            kafkaConfig = this.currentConfig();
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return kafkaConfig;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String> currentDynamicBrokerConfigs() {
        scala.collection.mutable.Map map;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            map = DynamicBrokerConfig.$anonfun$currentDynamicBrokerConfigs$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String> currentDynamicDefaultConfigs() {
        scala.collection.mutable.Map map;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            map = DynamicBrokerConfig.$anonfun$currentDynamicDefaultConfigs$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public void updateBrokerConfig(int brokerId, Properties persistentProps, boolean doLog) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$updateBrokerConfig$1(this, persistentProps, doLog, brokerId);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public boolean updateBrokerConfig$default$3() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void updateDefaultConfig(Properties persistentProps, boolean doLog) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$updateDefaultConfig$1(this, persistentProps, doLog);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public boolean updateDefaultConfig$default$2() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void reloadUpdatedFilesWithoutConfigChange(Properties newProps) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$1(this, newProps);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    private Option<PasswordEncoder> maybeCreatePasswordEncoder(Option<Password> secret2) {
        return secret2.map((Function1 & Serializable & scala.Serializable)secret -> PasswordEncoder$.MODULE$.encrypting((Password)secret, this.kafkaConfig().passwordEncoderKeyFactoryAlgorithm(), this.kafkaConfig().passwordEncoderCipherAlgorithm(), Predef$.MODULE$.Integer2int(this.kafkaConfig().passwordEncoderKeyLength()), Predef$.MODULE$.Integer2int(this.kafkaConfig().passwordEncoderIterations())));
    }

    private PasswordEncoder passwordEncoder() {
        return (PasswordEncoder)this.dynamicConfigPasswordEncoder().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new ConfigException("Password encoder secret not configured");
        });
    }

    /*
     * WARNING - void declaration
     */
    public Properties toPersistentProps(Properties configProps, boolean perBrokerConfig) {
        void var3_3;
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Properties props = (Properties)configProps.clone();
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, value) -> {
            DynamicBrokerConfig.$anonfun$toPersistentProps$1(this, perBrokerConfig, props, name, value);
            return BoxedUnit.UNIT;
        };
        Map map = Implicits$.MODULE$.MapExtensionMethods((Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(configProps).asScala());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Properties fromPersistentProps(Properties persistentProps, boolean perBrokerConfig) {
        void var3_3;
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Properties props = (Properties)persistentProps.clone();
        this.removeInvalidConfigs(props, perBrokerConfig);
        this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$nonDynamicConfigs(props), "Non-dynamic configs configured in ZooKeeper will be ignored", props);
        this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$securityConfigsWithoutListenerPrefix(props), "Security configs can be dynamically updated only using listener prefix, base configs will be ignored", props);
        if (!perBrokerConfig) {
            this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$perBrokerConfigs(props), "Per-broker configs defined at default cluster level will be ignored", props);
        }
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, value) -> {
            DynamicBrokerConfig.$anonfun$fromPersistentProps$5(this, props, name, value);
            return BoxedUnit.UNIT;
        };
        Map map = Implicits$.MODULE$.MapExtensionMethods((Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Properties maybeReEncodePasswords(Properties persistentProps, AdminZkClient adminZkClient) {
        void var3_3;
        Properties props = (Properties)persistentProps.clone();
        if (((MapLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).keySet().exists((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)))) {
            this.maybeCreatePasswordEncoder(this.kafkaConfig().passwordEncoderOldSecret()).foreach((Function1 & Serializable & scala.Serializable)passwordDecoder -> {
                DynamicBrokerConfig.$anonfun$maybeReEncodePasswords$2(this, persistentProps, props, adminZkClient, passwordDecoder);
                return BoxedUnit.UNIT;
            });
        }
        return var3_3;
    }

    private Map<String, String> validatedKafkaProps(Properties propsOverride, boolean perBrokerConfig) {
        Properties propsResolved = DynamicBrokerConfig$.MODULE$.resolveVariableConfigs(propsOverride);
        DynamicBrokerConfig$.MODULE$.validateConfigs(propsResolved, perBrokerConfig);
        scala.collection.mutable.Map newProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        newProps.$plus$plus$eq(this.staticBrokerConfigs());
        if (perBrokerConfig) {
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicDefaultConfigs());
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, (scala.collection.mutable.Map<String, String>)((scala.collection.mutable.Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(propsResolved).asScala()));
        } else {
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, (scala.collection.mutable.Map<String, String>)((scala.collection.mutable.Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(propsResolved).asScala()));
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicBrokerConfigs());
        }
        return newProps;
    }

    /*
     * WARNING - void declaration
     */
    public void validate(Properties props, boolean perBrokerConfig) {
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$validate$1(this, props, perBrokerConfig);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private void removeInvalidConfigs(Properties props, boolean perBrokerConfig) {
        try {
            DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props);
            CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala();
            return;
        }
        catch (Exception e) {
            scala.collection.mutable.Map invalidProps = (scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$removeInvalidConfigs$1(x0$1)));
            invalidProps.keys().foreach((Function1 & Serializable & scala.Serializable)x$1 -> props.remove(x$1));
            String configSource = perBrokerConfig ? "broker" : "default cluster";
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Dynamic ").append(configSource).append(" config contains invalid values in: ").append(invalidProps.keys()).append(", these configs will be ignored").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            return;
        }
    }

    public void maybeReconfigure(Reconfigurable reconfigurable, KafkaConfig oldConfig, java.util.Map<String, ?> newConfig) {
        if (((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter(reconfigurable.reconfigurableConfigs()).asScala()).exists((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$maybeReconfigure$1(oldConfig, newConfig, key)))) {
            reconfigurable.reconfigure(newConfig);
        }
    }

    private Tuple2<scala.collection.mutable.Map<String, ?>, Set<String>> updatedConfigs(java.util.Map<String, ?> newProps, java.util.Map<String, ?> currentProps) {
        scala.collection.mutable.Map changeMap = (scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(newProps).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$updatedConfigs$1(currentProps, x0$1)));
        Set deletedKeySet = ((MapLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(currentProps).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$updatedConfigs$2(newProps, x0$2)))).keySet();
        return new Tuple2((Object)changeMap, (Object)deletedKeySet);
    }

    /*
     * WARNING - void declaration
     */
    private void overrideProps(scala.collection.mutable.Map<String, String> props, scala.collection.mutable.Map<String, String> propsOverride) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(k, v) -> {
            DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms((String)k, false).foreach((Function1 & Serializable & scala.Serializable)key -> props.remove(key));
            return props.put(k, v);
        };
        Map<String, String> map = Implicits$.MODULE$.MapExtensionMethods(propsOverride);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    private void updateCurrentConfig(boolean doLog) {
        void var6_6;
        void var5_5;
        scala.collection.mutable.Map newProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        newProps.$plus$plus$eq(this.staticBrokerConfigs());
        this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicDefaultConfigs());
        this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicBrokerConfigs());
        KafkaConfig oldConfig = this.currentConfig();
        Tuple2<KafkaConfig, List<BrokerReconfigurable>> tuple2 = this.processReconfiguration((Map<String, String>)newProps, false, doLog);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        KafkaConfig newConfig = (KafkaConfig)tuple2._1();
        List brokerReconfigurablesToUpdate = (List)tuple2._2();
        void newConfig2 = var5_5;
        void brokerReconfigurablesToUpdate2 = var6_6;
        if (newConfig2 != this.currentConfig()) {
            this.currentConfig_$eq((KafkaConfig)newConfig2);
            this.kafkaConfig().updateCurrentConfig((KafkaConfig)newConfig2);
            brokerReconfigurablesToUpdate2.foreach(arg_0 -> DynamicBrokerConfig.$anonfun$updateCurrentConfig$1$adapted(oldConfig, (KafkaConfig)newConfig2, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<KafkaConfig, List<BrokerReconfigurable>> processReconfiguration(Map<String, String> newProps, boolean validateOnly, boolean doLog) {
        void var7_7;
        void var6_6;
        KafkaConfig newConfig = new KafkaConfig((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(newProps).asJava(), doLog, (Option<DynamicBrokerConfig>)None$.MODULE$);
        Tuple2<scala.collection.mutable.Map<String, ?>, Set<String>> tuple2 = this.updatedConfigs(newConfig.originalsFromThisConfig(), this.currentConfig().originals());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.mutable.Map changeMap = (scala.collection.mutable.Map)tuple2._1();
        Set deletedKeySet = (Set)tuple2._2();
        void changeMap2 = var6_6;
        void deletedKeySet2 = var7_7;
        if (changeMap2.nonEmpty() || deletedKeySet2.nonEmpty()) {
            try {
                HashMap<String, Object> customConfigs = new HashMap<String, Object>(newConfig.originalsFromThisConfig());
                newConfig.valuesFromThisConfig().keySet().forEach(k -> customConfigs.remove(k));
                this.reconfigurables().forEach(arg_0 -> DynamicBrokerConfig.$anonfun$processReconfiguration$2(this, newConfig, customConfigs, validateOnly, (scala.collection.mutable.Map)changeMap2, (Set)deletedKeySet2, arg_0));
                Buffer brokerReconfigurablesToUpdate = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                this.brokerReconfigurables().forEach(arg_0 -> DynamicBrokerConfig.$anonfun$processReconfiguration$3(this, (scala.collection.mutable.Map)changeMap2, (Set)deletedKeySet2, newConfig, validateOnly, brokerReconfigurablesToUpdate, arg_0));
                return new Tuple2((Object)newConfig, (Object)brokerReconfigurablesToUpdate.toList());
            }
            catch (Exception e) {
                if (!validateOnly) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Failed to update broker configuration with configs : ").append(ConfigUtils.configMapToRedactedString(newConfig.originalsFromThisConfig(), (ConfigDef)KafkaConfig$.MODULE$.configDef())).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
                throw new ConfigException("Invalid dynamic configuration", (Object)e);
            }
        }
        return new Tuple2((Object)this.currentConfig(), (Object)List$.MODULE$.empty());
    }

    private boolean processReconfiguration$default$3() {
        return false;
    }

    private boolean needsReconfiguration(java.util.Set<String> reconfigurableConfigs, Set<String> updatedKeys, Set<String> deletedKeys) {
        return ((TraversableOnce)((GenSetLike)CollectionConverters$.MODULE$.asScalaSetConverter(reconfigurableConfigs).asScala()).intersect(updatedKeys)).nonEmpty() || ((TraversableOnce)((GenSetLike)CollectionConverters$.MODULE$.asScalaSetConverter(reconfigurableConfigs).asScala()).intersect(deletedKeys)).nonEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private void processListenerReconfigurable(ListenerReconfigurable listenerReconfigurable, KafkaConfig newConfig, java.util.Map<String, Object> customConfigs, boolean validateOnly, boolean reloadOnly) {
        void var11_11;
        void var10_10;
        ListenerName listenerName = listenerReconfigurable.listenerName();
        java.util.Map<String, Object> oldValues = this.currentConfig().valuesWithPrefixOverride(listenerName.configPrefix());
        java.util.Map<String, Object> newValues = newConfig.valuesFromThisConfigWithPrefixOverride(listenerName.configPrefix());
        Tuple2<scala.collection.mutable.Map<String, ?>, Set<String>> tuple2 = this.updatedConfigs(newValues, oldValues);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.mutable.Map changeMap = (scala.collection.mutable.Map)tuple2._1();
        Set deletedKeys = (Set)tuple2._2();
        void changeMap2 = var10_10;
        void deletedKeys2 = var11_11;
        Set updatedKeys = changeMap2.keySet();
        boolean configsChanged = this.needsReconfiguration(listenerReconfigurable.reconfigurableConfigs(), (Set<String>)updatedKeys, (Set<String>)deletedKeys2);
        if (reloadOnly != configsChanged) {
            this.processReconfigurable((Reconfigurable)listenerReconfigurable, (Set<String>)updatedKeys, newValues, customConfigs, validateOnly);
        }
    }

    private void processReconfigurable(Reconfigurable reconfigurable, Set<String> updatedConfigNames, java.util.Map<String, ?> allNewConfigs, java.util.Map<String, Object> newCustomConfigs, boolean validateOnly) {
        HashMap<String, Object> newConfigs = new HashMap<String, Object>();
        allNewConfigs.forEach((k, v) -> newConfigs.put((String)k, v));
        newConfigs.putAll(newCustomConfigs);
        try {
            reconfigurable.validateReconfiguration(newConfigs);
        }
        catch (ConfigException configException) {
            throw configException;
        }
        catch (Exception exception) {
            throw new ConfigException(new StringBuilder(58).append("Validation of dynamic config update of ").append(updatedConfigNames).append(" failed with class ").append(reconfigurable.getClass()).toString());
        }
        if (!validateOnly) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Reconfiguring ").append(reconfigurable).append(", updated configs: ").append(updatedConfigNames).append(" ").append("custom configs: ").append(ConfigUtils.configMapToRedactedString((java.util.Map)newCustomConfigs, (ConfigDef)KafkaConfig$.MODULE$.configDef())).toString());
            reconfigurable.reconfigure(newConfigs);
        }
    }

    public static final /* synthetic */ void $anonfun$initialize$1(DynamicBrokerConfig $this, KafkaZkClient zkClient) {
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        $this.updateDefaultConfig(adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), ConfigEntityName$.MODULE$.Default()), false);
        Properties props = adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), Integer.toString($this.kafkaConfig().brokerId()));
        Properties brokerConfig = $this.maybeReEncodePasswords(props, adminZkClient);
        $this.updateBrokerConfig($this.kafkaConfig().brokerId(), brokerConfig, $this.updateBrokerConfig$default$3());
    }

    public static final /* synthetic */ boolean $anonfun$addReconfigurable$1(DynamicBrokerConfig $this, Reconfigurable reconfigurable$1) {
        $this.verifyReconfigurableConfigs((Set<String>)((Set)CollectionConverters$.MODULE$.asScalaSetConverter(reconfigurable$1.reconfigurableConfigs()).asScala()));
        return $this.reconfigurables().add(reconfigurable$1);
    }

    public static final /* synthetic */ boolean $anonfun$addBrokerReconfigurable$1(DynamicBrokerConfig $this, BrokerReconfigurable reconfigurable$2) {
        $this.verifyReconfigurableConfigs(reconfigurable$2.reconfigurableConfigs());
        return $this.brokerReconfigurables().add(reconfigurable$2);
    }

    public static final /* synthetic */ boolean $anonfun$removeReconfigurable$1(DynamicBrokerConfig $this, Reconfigurable reconfigurable$3) {
        return $this.reconfigurables().remove(reconfigurable$3);
    }

    public static final /* synthetic */ boolean $anonfun$verifyReconfigurableConfigs$2(String elem) {
        return DynamicConfig$Broker$.MODULE$.nonDynamicProps().contains((Object)elem);
    }

    public static final /* synthetic */ void $anonfun$verifyReconfigurableConfigs$1(Set configNames$1) {
        Set nonDynamic = (Set)configNames$1.filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$verifyReconfigurableConfigs$2(elem)));
        Predef$.MODULE$.require(nonDynamic.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Reconfigurable contains non-dynamic configs ").append(nonDynamic).toString());
    }

    public static final /* synthetic */ scala.collection.mutable.Map $anonfun$currentDynamicBrokerConfigs$1(DynamicBrokerConfig $this) {
        return $this.dynamicBrokerConfigs().clone();
    }

    public static final /* synthetic */ scala.collection.mutable.Map $anonfun$currentDynamicDefaultConfigs$1(DynamicBrokerConfig $this) {
        return $this.dynamicDefaultConfigs().clone();
    }

    public static final /* synthetic */ void $anonfun$updateBrokerConfig$1(DynamicBrokerConfig $this, Properties persistentProps$1, boolean doLog$1, int brokerId$1) {
        try {
            Properties props = $this.fromPersistentProps(persistentProps$1, true);
            $this.dynamicBrokerConfigs().clear();
            $this.dynamicBrokerConfigs().$plus$plus$eq((TraversableOnce)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala());
            $this.updateCurrentConfig(doLog$1);
            return;
        }
        catch (Exception e) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Per-broker configs of ").append(brokerId$1).append(" could not be applied: ").append(persistentProps$1.keys()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$updateDefaultConfig$1(DynamicBrokerConfig $this, Properties persistentProps$2, boolean doLog$2) {
        try {
            Properties props = $this.fromPersistentProps(persistentProps$2, false);
            $this.dynamicDefaultConfigs().clear();
            $this.dynamicDefaultConfigs().$plus$plus$eq((TraversableOnce)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala());
            $this.updateCurrentConfig(doLog$2);
            return;
        }
        catch (Exception e) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Cluster default configs could not be applied: ").append(persistentProps$2.keys()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$reloadUpdatedFilesWithoutConfigChange$2(Reconfigurable reconfigurable) {
        return DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs().exists(arg_0 -> DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$3$adapted(reconfigurable.reconfigurableConfigs(), arg_0));
    }

    public static final /* synthetic */ void $anonfun$reloadUpdatedFilesWithoutConfigChange$4(DynamicBrokerConfig $this, Properties newProps$1, Reconfigurable x0$1) {
        if (x0$1 instanceof ListenerReconfigurable) {
            ListenerReconfigurable listenerReconfigurable = (ListenerReconfigurable)x0$1;
            Map<String, String> kafkaProps = $this.validatedKafkaProps(newProps$1, true);
            KafkaConfig newConfig = new KafkaConfig((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(kafkaProps).asJava(), false, (Option<DynamicBrokerConfig>)None$.MODULE$);
            $this.processListenerReconfigurable(listenerReconfigurable, newConfig, Collections.emptyMap(), false, true);
            return;
        }
        $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Files will not be reloaded without config change for ").append(x0$1).toString());
    }

    public static final /* synthetic */ void $anonfun$reloadUpdatedFilesWithoutConfigChange$1(DynamicBrokerConfig $this, Properties newProps$1) {
        ((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter($this.reconfigurables()).asScala()).filter((Function1 & Serializable & scala.Serializable)reconfigurable -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$2(reconfigurable)))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$4($this, newProps$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private final void encodePassword$1(String configName, String value, boolean perBrokerConfig$1, Properties props$3) {
        if (value != null) {
            if (!perBrokerConfig$1) {
                throw new ConfigException("Password config can be defined only at broker level");
            }
            props$3.setProperty(configName, this.passwordEncoder().encode(new Password(value)));
        }
    }

    public static final /* synthetic */ void $anonfun$toPersistentProps$1(DynamicBrokerConfig $this, boolean perBrokerConfig$1, Properties props$3, String name, String value) {
        if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)) {
            $this.encodePassword$1(name, value, perBrokerConfig$1, props$3);
        }
    }

    private final void removeInvalidProps$1(Set invalidPropNames, String errorMessage, Properties props$4) {
        if (invalidPropNames.nonEmpty()) {
            invalidPropNames.foreach((Function1 & Serializable & scala.Serializable)x$1 -> props$4.remove(x$1));
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(2).append(errorMessage).append(": ").append(invalidPropNames).toString());
        }
    }

    private final void decodePassword$1(String configName, String value, Properties props$4) {
        if (value != null) {
            try {
                props$4.setProperty(configName, this.passwordEncoder().decode(value).value());
                return;
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Dynamic password config ").append(configName).append(" could not be decoded, ignoring.").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                props$4.remove(configName);
                return;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$fromPersistentProps$5(DynamicBrokerConfig $this, Properties props$4, String name, String value) {
        if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)) {
            $this.decodePassword$1(name, value, props$4);
        }
    }

    public static final /* synthetic */ void $anonfun$maybeReEncodePasswords$3(DynamicBrokerConfig $this, PasswordEncoder passwordDecoder$1, Properties props$5, String configName, String value2) {
        if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(configName) && value2 != null) {
            Some some;
            try {
                some = new Some((Object)passwordDecoder$1.decode(value2).value());
            }
            catch (Exception exception) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(88).append("Dynamic password config ").append(configName).append(" could not be decoded using old secret, new secret will be used.").toString());
                some = None$.MODULE$;
            }
            some.foreach((Function1 & Serializable & scala.Serializable)value -> props$5.put(configName, $this.passwordEncoder().encode(new Password(value))));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$maybeReEncodePasswords$2(DynamicBrokerConfig $this, Properties persistentProps$3, Properties props$5, AdminZkClient adminZkClient$1, PasswordEncoder passwordDecoder) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(configName, value) -> {
            DynamicBrokerConfig.$anonfun$maybeReEncodePasswords$3($this, passwordDecoder, props$5, configName, value);
            return BoxedUnit.UNIT;
        };
        Map map = Implicits$.MODULE$.MapExtensionMethods((Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(persistentProps$3).asScala());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        adminZkClient$1.changeBrokerConfig((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)$this.kafkaConfig().brokerId())), props$5);
    }

    public static final /* synthetic */ Tuple2 $anonfun$validate$1(DynamicBrokerConfig $this, Properties props$6, boolean perBrokerConfig$2) {
        Map<String, String> newProps = $this.validatedKafkaProps(props$6, perBrokerConfig$2);
        return $this.processReconfiguration(newProps, true, $this.processReconfiguration$default$3());
    }

    public static final /* synthetic */ boolean $anonfun$removeInvalidConfigs$1(Tuple2 x0$1) {
        boolean bl;
        if (x0$1 != null) {
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Properties props1 = new Properties();
            props1.put(k, v);
            try {
                DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props1);
                bl = false;
            }
            catch (Exception exception) {
                bl = true;
            }
        } else {
            throw new MatchError(null);
        }
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ boolean $anonfun$maybeReconfigure$1(KafkaConfig oldConfig$1, java.util.Map newConfig$1, String key) {
        return !BoxesRunTime.equals((Object)oldConfig$1.originals().get(key), newConfig$1.get(key));
    }

    public static final /* synthetic */ boolean $anonfun$updatedConfigs$1(java.util.Map currentProps$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String k = (String)x0$1._1();
        boolean bl = !BoxesRunTime.equals((Object)x0$1._2(), currentProps$1.get(k));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$updatedConfigs$2(java.util.Map newProps$2, Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        String k = (String)x0$2._1();
        boolean bl = !newProps$2.containsKey(k);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$processReconfiguration$2(DynamicBrokerConfig $this, KafkaConfig newConfig$3, HashMap customConfigs$1, boolean validateOnly$1, scala.collection.mutable.Map changeMap$1, Set deletedKeySet$1, Reconfigurable x0$1) {
        if (x0$1 instanceof ListenerReconfigurable) {
            ListenerReconfigurable listenerReconfigurable = (ListenerReconfigurable)x0$1;
            $this.processListenerReconfigurable(listenerReconfigurable, newConfig$3, customConfigs$1, validateOnly$1, false);
            return;
        }
        if ($this.needsReconfiguration(x0$1.reconfigurableConfigs(), (Set<String>)changeMap$1.keySet(), (Set<String>)deletedKeySet$1)) {
            $this.processReconfigurable(x0$1, (Set<String>)changeMap$1.keySet(), newConfig$3.valuesFromThisConfig(), customConfigs$1, validateOnly$1);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$processReconfiguration$3(DynamicBrokerConfig $this, scala.collection.mutable.Map changeMap$1, Set deletedKeySet$1, KafkaConfig newConfig$3, boolean validateOnly$1, Buffer brokerReconfigurablesToUpdate$1, BrokerReconfigurable reconfigurable) {
        if ($this.needsReconfiguration((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(reconfigurable.reconfigurableConfigs()).asJava(), (Set<String>)changeMap$1.keySet(), (Set<String>)deletedKeySet$1)) {
            reconfigurable.validateReconfiguration(newConfig$3);
            if (!validateOnly$1) {
                brokerReconfigurablesToUpdate$1.$plus$eq((Object)reconfigurable);
                return;
            }
        }
    }

    public DynamicBrokerConfig(KafkaConfig kafkaConfig) {
        Option<PasswordEncoder> option;
        this.kafkaConfig = kafkaConfig;
        Logging.$init$(this);
        this.staticBrokerConfigs = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(ConfigDef.convertToStringMapWithPasswordValues(kafkaConfig.originalsFromThisConfig())).asScala();
        this.staticDefaultConfigs = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(ConfigDef.convertToStringMapWithPasswordValues((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(KafkaConfig$.MODULE$.defaultValues()).asJava()))).asScala();
        this.dynamicBrokerConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.dynamicDefaultConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.reconfigurables = new CopyOnWriteArrayList();
        this.brokerReconfigurables = new CopyOnWriteArrayList();
        this.lock = new ReentrantReadWriteLock();
        if (kafkaConfig.processRoles().isEmpty()) {
            option = this.maybeCreatePasswordEncoder(kafkaConfig.passwordEncoderSecret());
        } else {
            Option<PasswordEncoder> option2;
            option = option2;
            super((Object)PasswordEncoder$.MODULE$.noop());
        }
        this.dynamicConfigPasswordEncoder = option;
    }

    public static final /* synthetic */ Object $anonfun$updateCurrentConfig$1$adapted(KafkaConfig oldConfig$2, KafkaConfig newConfig$2, BrokerReconfigurable x$3) {
        x$3.reconfigure(oldConfig$2, newConfig$2);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$reloadUpdatedFilesWithoutConfigChange$3$adapted(java.util.Set eta$0$1$1, Object x$1) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$1.contains(x$1));
    }
}

