/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.ControllerInformation;
import kafka.server.ControllerNodeProvider;
import kafka.server.KRaftCachedControllerId;
import kafka.server.KafkaConfig;
import kafka.server.ZkCachedControllerId;
import kafka.server.metadata.ZkMetadataCache;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001e4A!\u0006\f\u00017!Aa\u0005\u0001BC\u0002\u0013\u0005q\u0005\u0003\u0005/\u0001\t\u0005\t\u0015!\u0003)\u0011!y\u0003A!b\u0001\n\u0003\u0001\u0004\u0002\u0003\u001b\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\t\u000bU\u0002A\u0011\u0001\u001c\t\u000fi\u0002!\u0019!C\u0005w!1\u0011\n\u0001Q\u0001\nqBqA\u0013\u0001C\u0002\u0013%1\n\u0003\u0004U\u0001\u0001\u0006I\u0001\u0014\u0005\b+\u0002\u0011\r\u0011\"\u0003W\u0011\u0019y\u0006\u0001)A\u0005/\"9\u0001\r\u0001b\u0001\n\u0013Y\u0004BB1\u0001A\u0003%A\bC\u0004c\u0001\t\u0007I\u0011B&\t\r\r\u0004\u0001\u0015!\u0003M\u0011\u001d!\u0007A1A\u0005\n\u0015Da\u0001\u001d\u0001!\u0002\u00131\u0007bB9\u0001\u0005\u0004%IA\u001d\u0005\u0007m\u0002\u0001\u000b\u0011B:\t\u000b]\u0004A\u0011\t=\u0003G5+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0007>tGO]8mY\u0016\u0014hj\u001c3f!J|g/\u001b3fe*\u0011q\u0003G\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003e\tQa[1gW\u0006\u001c\u0001aE\u0002\u00019\t\u0002\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011a!\u00118z%\u00164\u0007CA\u0012%\u001b\u00051\u0012BA\u0013\u0017\u0005Y\u0019uN\u001c;s_2dWM\u001d(pI\u0016\u0004&o\u001c<jI\u0016\u0014\u0018!D7fi\u0006$\u0017\r^1DC\u000eDW-F\u0001)!\tIC&D\u0001+\u0015\tYc#\u0001\u0005nKR\fG-\u0019;b\u0013\ti#FA\b[W6+G/\u00193bi\u0006\u001c\u0015m\u00195f\u00039iW\r^1eCR\f7)Y2iK\u0002\naaY8oM&<W#A\u0019\u0011\u0005\r\u0012\u0014BA\u001a\u0017\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u000f\r|gNZ5hA\u00051A(\u001b8jiz\"2a\u000e\u001d:!\t\u0019\u0003\u0001C\u0003'\u000b\u0001\u0007\u0001\u0006C\u00030\u000b\u0001\u0007\u0011'\u0001\r{W\u000e{g\u000e\u001e:pY2,'\u000fT5ti\u0016tWM\u001d(b[\u0016,\u0012\u0001\u0010\t\u0003{\u001dk\u0011A\u0010\u0006\u0003\u007f\u0001\u000bqA\\3uo>\u00148N\u0003\u0002B\u0005\u000611m\\7n_:T!!G\"\u000b\u0005\u0011+\u0015AB1qC\u000eDWMC\u0001G\u0003\ry'oZ\u0005\u0003\u0011z\u0012A\u0002T5ti\u0016tWM\u001d(b[\u0016\f\u0011D_6D_:$(o\u001c7mKJd\u0015n\u001d;f]\u0016\u0014h*Y7fA\u0005a\"p[\"p]R\u0014x\u000e\u001c7feN+7-\u001e:jif\u0004&o\u001c;pG>dW#\u0001'\u0011\u00055\u0013V\"\u0001(\u000b\u0005=\u0003\u0016\u0001B1vi\"T!!\u0015!\u0002\u0011M,7-\u001e:jifL!a\u0015(\u0003!M+7-\u001e:jif\u0004&o\u001c;pG>d\u0017!\b>l\u0007>tGO]8mY\u0016\u00148+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\u001c\u0011\u00023i\\7i\u001c8ue>dG.\u001a:TCNdW*Z2iC:L7/\\\u000b\u0002/B\u0011\u0001,X\u0007\u00023*\u0011!lW\u0001\u0005Y\u0006twMC\u0001]\u0003\u0011Q\u0017M^1\n\u0005yK&AB*ue&tw-\u0001\u000e{W\u000e{g\u000e\u001e:pY2,'oU1tY6+7\r[1oSNl\u0007%A\u000ele\u00064GoQ8oiJ|G\u000e\\3s\u0019&\u001cH/\u001a8fe:\u000bW.Z\u0001\u001dWJ\fg\r^\"p]R\u0014x\u000e\u001c7fe2K7\u000f^3oKJt\u0015-\\3!\u0003}Y'/\u00194u\u0007>tGO]8mY\u0016\u00148+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\\\u0001!WJ\fg\r^\"p]R\u0014x\u000e\u001c7feN+7-\u001e:jif\u0004&o\u001c;pG>d\u0007%\u0001\u000fle\u00064GoQ8oiJ|G\u000e\\3s'\u0006\u001cH.T3dQ\u0006t\u0017n]7\u0016\u0003\u0019\u0004\"a\u001a8\u000f\u0005!d\u0007CA5\u001f\u001b\u0005Q'BA6\u001b\u0003\u0019a$o\\8u}%\u0011QNH\u0001\u0007!J,G-\u001a4\n\u0005y{'BA7\u001f\u0003uY'/\u00194u\u0007>tGO]8mY\u0016\u00148+Y:m\u001b\u0016\u001c\u0007.\u00198jg6\u0004\u0013!F3naRL(l[\"p]R\u0014x\u000e\u001c7fe&sgm\\\u000b\u0002gB\u00111\u0005^\u0005\u0003kZ\u0011QcQ8oiJ|G\u000e\\3s\u0013:4wN]7bi&|g.\u0001\ff[B$\u0018PW6D_:$(o\u001c7mKJLeNZ8!\u0003E9W\r^\"p]R\u0014x\u000e\u001c7fe&sgm\u001c\u000b\u0002g\u0002")
public class MetadataCacheControllerNodeProvider
implements ControllerNodeProvider {
    private final ZkMetadataCache metadataCache;
    private final KafkaConfig config;
    private final ListenerName zkControllerListenerName;
    private final SecurityProtocol zkControllerSecurityProtocol;
    private final String zkControllerSaslMechanism;
    private final ListenerName kraftControllerListenerName;
    private final SecurityProtocol kraftControllerSecurityProtocol;
    private final String kraftControllerSaslMechanism;
    private final ControllerInformation emptyZkControllerInfo;

    public ZkMetadataCache metadataCache() {
        return this.metadataCache;
    }

    public KafkaConfig config() {
        return this.config;
    }

    private ListenerName zkControllerListenerName() {
        return this.zkControllerListenerName;
    }

    private SecurityProtocol zkControllerSecurityProtocol() {
        return this.zkControllerSecurityProtocol;
    }

    private String zkControllerSaslMechanism() {
        return this.zkControllerSaslMechanism;
    }

    private ListenerName kraftControllerListenerName() {
        return this.kraftControllerListenerName;
    }

    private SecurityProtocol kraftControllerSecurityProtocol() {
        return this.kraftControllerSecurityProtocol;
    }

    private String kraftControllerSaslMechanism() {
        return this.kraftControllerSaslMechanism;
    }

    private ControllerInformation emptyZkControllerInfo() {
        return this.emptyZkControllerInfo;
    }

    @Override
    public ControllerInformation getControllerInfo() {
        return (ControllerInformation)this.metadataCache().getControllerId().map((Function1 & java.io.Serializable & Serializable)x0$1 -> {
            ControllerInformation controllerInformation;
            if (x0$1 instanceof ZkCachedControllerId) {
                int id = ((ZkCachedControllerId)x0$1).id();
                controllerInformation = new ControllerInformation(this.metadataCache().getAliveBrokerNode(id, this.zkControllerListenerName()), this.zkControllerListenerName(), this.zkControllerSecurityProtocol(), this.zkControllerSaslMechanism(), true);
            } else if (x0$1 instanceof KRaftCachedControllerId) {
                int id = ((KRaftCachedControllerId)x0$1).id();
                controllerInformation = new ControllerInformation(this.metadataCache().getAliveBrokerNode(id, this.kraftControllerListenerName()), this.kraftControllerListenerName(), this.kraftControllerSecurityProtocol(), this.kraftControllerSaslMechanism(), false);
            } else {
                throw new MatchError(x0$1);
            }
            return controllerInformation;
        }).getOrElse((Function0 & java.io.Serializable & Serializable)() -> this.emptyZkControllerInfo());
    }

    public MetadataCacheControllerNodeProvider(ZkMetadataCache metadataCache, KafkaConfig config) {
        this.metadataCache = metadataCache;
        this.config = config;
        this.zkControllerListenerName = (ListenerName)config.controlPlaneListenerName().getOrElse((Function0 & java.io.Serializable & Serializable)() -> this.config().interBrokerListenerName());
        this.zkControllerSecurityProtocol = (SecurityProtocol)config.controlPlaneSecurityProtocol().getOrElse((Function0 & java.io.Serializable & Serializable)() -> this.config().interBrokerSecurityProtocol());
        this.zkControllerSaslMechanism = config.saslMechanismInterBrokerProtocol();
        this.kraftControllerListenerName = config.controllerListenerNames().nonEmpty() ? new ListenerName((String)config.controllerListenerNames().head()) : null;
        this.kraftControllerSecurityProtocol = (SecurityProtocol)Option$.MODULE$.apply((Object)this.kraftControllerListenerName()).map((Function1 & java.io.Serializable & Serializable)listener -> (SecurityProtocol)this.config().effectiveListenerSecurityProtocolMap().getOrElse(listener, (Function0 & java.io.Serializable & Serializable)() -> SecurityProtocol.forName((String)this.kraftControllerListenerName().value()))).orNull(Predef$.MODULE$.$conforms());
        this.kraftControllerSaslMechanism = config.saslMechanismControllerProtocol();
        this.emptyZkControllerInfo = new ControllerInformation((Option<Node>)None$.MODULE$, this.zkControllerListenerName(), this.zkControllerSecurityProtocol(), this.zkControllerSaslMechanism(), true);
    }
}

