/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kafka.raft.KafkaRaftManager;
import kafka.server.DynamicBrokerConfig;
import kafka.server.FaultHandlerFactory;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer$;
import kafka.server.KafkaRaftServer$BrokerRole$;
import kafka.server.KafkaRaftServer$ControllerRole$;
import kafka.server.MetaProperties;
import kafka.server.Server$;
import kafka.server.metadata.BrokerServerMetrics;
import kafka.server.metadata.BrokerServerMetrics$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.metrics.ControllerMetadataMetrics;
import org.apache.kafka.image.loader.MetadataLoader;
import org.apache.kafka.image.loader.MetadataLoaderMetrics;
import org.apache.kafka.image.publisher.SnapshotEmitter;
import org.apache.kafka.image.publisher.SnapshotGenerator;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t=f\u0001\u0002\"D\u0001!C\u0001\"\u0016\u0001\u0003\u0006\u0004%IA\u0016\u0005\t7\u0002\u0011\t\u0011)A\u0005/\"AA\f\u0001BC\u0002\u0013\u0005Q\f\u0003\u0005b\u0001\t\u0005\t\u0015!\u0003_\u0011!\u0011\u0007A!b\u0001\n\u0003\u0019\u0007\u0002\u00039\u0001\u0005\u0003\u0005\u000b\u0011\u00023\t\u0011E\u0004!Q1A\u0005\nID\u0001\"\u001f\u0001\u0003\u0002\u0003\u0006Ia\u001d\u0005\tu\u0002\u0011)\u0019!C\u0001w\"I\u0011\u0011\n\u0001\u0003\u0002\u0003\u0006I\u0001 \u0005\u000b\u0003\u0017\u0002!Q1A\u0005\u0002\u00055\u0003BCA+\u0001\t\u0005\t\u0015!\u0003\u0002P!9\u0011q\u000b\u0001\u0005\u0002\u0005e\u0003\"CA5\u0001\t\u0007I\u0011BA6\u0011!\t\u0019\b\u0001Q\u0001\n\u00055\u0004\"CA;\u0001\u0001\u0007I\u0011BA<\u0011%\ty\b\u0001a\u0001\n\u0013\t\t\t\u0003\u0005\u0002\u000e\u0002\u0001\u000b\u0015BA=\u0011%\ty\t\u0001a\u0001\n\u0013\t9\bC\u0005\u0002\u0012\u0002\u0001\r\u0011\"\u0003\u0002\u0014\"A\u0011q\u0013\u0001!B\u0013\tI\bC\u0005\u0002\u001a\u0002\u0001\r\u0011\"\u0003\u0002x!I\u00111\u0014\u0001A\u0002\u0013%\u0011Q\u0014\u0005\t\u0003C\u0003\u0001\u0015)\u0003\u0002z!A\u00111\u0015\u0001C\u0002\u0013\u0005a\u000bC\u0004\u0002&\u0002\u0001\u000b\u0011B,\t\u0011\u0005\u001d\u0006A1A\u0005\u0002YCq!!+\u0001A\u0003%q\u000bC\u0004w\u0001\u0001\u0007I\u0011\u0001:\t\u0013\u0005-\u0006\u00011A\u0005\u0002\u00055\u0006bBAY\u0001\u0001\u0006Ka\u001d\u0005\f\u0003w\u0003\u0001\u0019!a\u0001\n\u0003\ti\fC\u0006\u0002V\u0002\u0001\r\u00111A\u0005\u0002\u0005]\u0007bCAn\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u007fC1\"a8\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002b\"Y\u0011q\u001e\u0001A\u0002\u0003\u0007I\u0011AAy\u0011-\t)\u0010\u0001a\u0001\u0002\u0003\u0006K!a9\t\u0017\u0005e\b\u00011AA\u0002\u0013\u0005\u00111 \u0005\f\u0005\u0017\u0001\u0001\u0019!a\u0001\n\u0003\u0011i\u0001C\u0006\u0003\u0012\u0001\u0001\r\u0011!Q!\n\u0005u\bb\u0003B\u000b\u0001\u0001\u0007\t\u0019!C\u0001\u0005/A1Ba\n\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003*!Y!Q\u0006\u0001A\u0002\u0003\u0005\u000b\u0015\u0002B\r\u0011%\u0011\t\u0004\u0001b\u0001\n\u0003\u0011\u0019\u0004\u0003\u0005\u0003R\u0001\u0001\u000b\u0011\u0002B\u001b\u0011-\u0011\u0019\u0006\u0001a\u0001\u0002\u0004%\tA!\u0016\t\u0017\t\r\u0004\u00011AA\u0002\u0013\u0005!Q\r\u0005\f\u0005S\u0002\u0001\u0019!A!B\u0013\u00119\u0006C\u0006\u0003n\u0001\u0001\r\u00111A\u0005\u0002\t=\u0004b\u0003B<\u0001\u0001\u0007\t\u0019!C\u0001\u0005sB1B! \u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003r!9!\u0011\u0011\u0001\u0005\u0002\t\r\u0005b\u0002BC\u0001\u0011\u0005!q\u0011\u0005\b\u0005\u0013\u0003A\u0011\u0001BD\u0011\u001d\u0011Y\t\u0001C\u0001\u0005\u000fCqA!$\u0001\t\u0003\u00119\tC\u0004\u0003\u0010\u0002!\tA!%\t\u000f\t}\u0005\u0001\"\u0001\u0003\u0012\"9!\u0011\u0015\u0001\u0005\u0002\tE\u0005b\u0002BR\u0001\u0011\u0005!\u0011\u0013\u0005\b\u0005K\u0003A\u0011\u0001BI\u0011\u001d\u00119\u000b\u0001C\u0001\u0005#CqA!+\u0001\t\u0013\u00119\tC\u0004\u0003,\u0002!\tAa\"\t\u000f\t5\u0006\u0001\"\u0003\u0003\b\na1\u000b[1sK\u0012\u001cVM\u001d<fe*\u0011A)R\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0019\u000bQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u0013>\u0003\"AS'\u000e\u0003-S\u0011\u0001T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001d.\u0013a!\u00118z%\u00164\u0007C\u0001)T\u001b\u0005\t&B\u0001*F\u0003\u0015)H/\u001b7t\u0013\t!\u0016KA\u0004M_\u001e<\u0017N\\4\u0002%MD\u0017M]3e'\u0016\u0014h/\u001a:D_:4\u0017nZ\u000b\u0002/B\u0011\u0001,W\u0007\u0002\u0007&\u0011!l\u0011\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\ntQ\u0006\u0014X\rZ*feZ,'oQ8oM&<\u0007%A\u0005nKR\f\u0007K]8qgV\ta\f\u0005\u0002Y?&\u0011\u0001m\u0011\u0002\u000f\u001b\u0016$\u0018\r\u0015:pa\u0016\u0014H/[3t\u0003)iW\r^1Qe>\u00048\u000fI\u0001\u0005i&lW-F\u0001e!\t)g.D\u0001g\u0015\t\u0011vM\u0003\u0002iS\u000611m\\7n_:T!A\u00126\u000b\u0005-d\u0017AB1qC\u000eDWMC\u0001n\u0003\ry'oZ\u0005\u0003_\u001a\u0014A\u0001V5nK\u0006)A/[7fA\u0005Aq,\\3ue&\u001c7/F\u0001t!\t!x/D\u0001v\u0015\t1x-A\u0004nKR\u0014\u0018nY:\n\u0005a,(aB'fiJL7m]\u0001\n?6,GO]5dg\u0002\nAdY8oiJ|G\u000e\\3s#V|'/^7W_R,'o\u001d$viV\u0014X-F\u0001}!\u0015i\u0018\u0011BA\u0007\u001b\u0005q(bA@\u0002\u0002\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005\r\u0011QA\u0001\u0005kRLGN\u0003\u0002\u0002\b\u0005!!.\u0019<b\u0013\r\tYA \u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007\u0003CA\b\u0003#\t)\"!\t\u000e\u0005\u0005\u0005\u0011\u0002BA\n\u0003\u0003\u00111!T1q!\u0011\t9\"!\b\u000e\u0005\u0005e!\u0002BA\u000e\u0003\u000b\tA\u0001\\1oO&!\u0011qDA\r\u0005\u001dIe\u000e^3hKJ\u0004B!a\t\u0002D9!\u0011QEA\u001f\u001d\u0011\t9#!\u000f\u000f\t\u0005%\u0012q\u0007\b\u0005\u0003W\t)D\u0004\u0003\u0002.\u0005MRBAA\u0018\u0015\r\t\tdR\u0001\u0007yI|w\u000e\u001e \n\u00035L!a\u001b7\n\u0005\u0019S\u0017bAA\u001eS\u0006!!/\u00194u\u0013\u0011\ty$!\u0011\u0002\u0015I\u000bg\r^\"p]\u001aLwMC\u0002\u0002<%LA!!\u0012\u0002H\tY\u0011\t\u001a3sKN\u001c8\u000b]3d\u0015\u0011\ty$!\u0011\u0002;\r|g\u000e\u001e:pY2,'/U;peVlgk\u001c;feN4U\u000f^;sK\u0002\n1CZ1vYRD\u0015M\u001c3mKJ4\u0015m\u0019;pef,\"!a\u0014\u0011\u0007a\u000b\t&C\u0002\u0002T\r\u00131CR1vYRD\u0015M\u001c3mKJ4\u0015m\u0019;pef\fACZ1vYRD\u0015M\u001c3mKJ4\u0015m\u0019;pef\u0004\u0013A\u0002\u001fj]&$h\b\u0006\b\u0002\\\u0005u\u0013qLA1\u0003G\n)'a\u001a\u0011\u0005a\u0003\u0001\"B+\u000e\u0001\u00049\u0006\"\u0002/\u000e\u0001\u0004q\u0006\"\u00022\u000e\u0001\u0004!\u0007\"B9\u000e\u0001\u0004\u0019\b\"\u0002>\u000e\u0001\u0004a\bbBA&\u001b\u0001\u0007\u0011qJ\u0001\u000bY><7i\u001c8uKb$XCAA7!\r)\u0017qN\u0005\u0004\u0003c2'A\u0003'pO\u000e{g\u000e^3yi\u0006YAn\\4D_:$X\r\u001f;!\u0003\u001d\u0019H/\u0019:uK\u0012,\"!!\u001f\u0011\u0007)\u000bY(C\u0002\u0002~-\u0013qAQ8pY\u0016\fg.A\u0006ti\u0006\u0014H/\u001a3`I\u0015\fH\u0003BAB\u0003\u0013\u00032ASAC\u0013\r\t9i\u0013\u0002\u0005+:LG\u000fC\u0005\u0002\fF\t\t\u00111\u0001\u0002z\u0005\u0019\u0001\u0010J\u0019\u0002\u0011M$\u0018M\u001d;fI\u0002\nA\"^:fI\nK(I]8lKJ\f\u0001#^:fI\nK(I]8lKJ|F%Z9\u0015\t\u0005\r\u0015Q\u0013\u0005\n\u0003\u0017#\u0012\u0011!a\u0001\u0003s\nQ\"^:fI\nK(I]8lKJ\u0004\u0013\u0001E;tK\u0012\u0014\u0015pQ8oiJ|G\u000e\\3s\u0003Q)8/\u001a3Cs\u000e{g\u000e\u001e:pY2,'o\u0018\u0013fcR!\u00111QAP\u0011%\tYiFA\u0001\u0002\u0004\tI(A\tvg\u0016$')_\"p]R\u0014x\u000e\u001c7fe\u0002\nAB\u0019:pW\u0016\u00148i\u001c8gS\u001e\fQB\u0019:pW\u0016\u00148i\u001c8gS\u001e\u0004\u0013\u0001E2p]R\u0014x\u000e\u001c7fe\u000e{gNZ5h\u0003E\u0019wN\u001c;s_2dWM]\"p]\u001aLw\rI\u0001\f[\u0016$(/[2t?\u0012*\u0017\u000f\u0006\u0003\u0002\u0004\u0006=\u0006\u0002CAF=\u0005\u0005\t\u0019A:\u0002\u00115,GO]5dg\u0002B3aHA[!\rQ\u0015qW\u0005\u0004\u0003s[%\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u0017I\fg\r^'b]\u0006<WM]\u000b\u0003\u0003\u007f\u0003b!!1\u0002F\u0006%WBAAb\u0015\r\tY$R\u0005\u0005\u0003\u000f\f\u0019M\u0001\tLC\u001a\\\u0017MU1gi6\u000bg.Y4feB!\u00111ZAi\u001b\t\tiMC\u0002i\u0003\u001fT!\u0001R5\n\t\u0005M\u0017Q\u001a\u0002\u0015\u0003BLW*Z:tC\u001e,\u0017I\u001c3WKJ\u001c\u0018n\u001c8\u0002\u001fI\fg\r^'b]\u0006<WM]0%KF$B!a!\u0002Z\"I\u00111R\u0011\u0002\u0002\u0003\u0007\u0011qX\u0001\re\u00064G/T1oC\u001e,'\u000f\t\u0015\u0004E\u0005U\u0016!\u00042s_.,'/T3ue&\u001c7/\u0006\u0002\u0002dB!\u0011Q]Av\u001b\t\t9OC\u0002\u0002j\u000e\u000b\u0001\"\\3uC\u0012\fG/Y\u0005\u0005\u0003[\f9OA\nCe>\\WM]*feZ,'/T3ue&\u001c7/A\tce>\\WM]'fiJL7m]0%KF$B!a!\u0002t\"I\u00111\u0012\u0013\u0002\u0002\u0003\u0007\u00111]\u0001\u000fEJ|7.\u001a:NKR\u0014\u0018nY:!Q\r)\u0013QW\u0001\u0018G>tGO]8mY\u0016\u00148+\u001a:wKJlU\r\u001e:jGN,\"!!@\u0011\t\u0005}(qA\u0007\u0003\u0005\u0003Q1A\u001eB\u0002\u0015\r\u0011)![\u0001\u000bG>tGO]8mY\u0016\u0014\u0018\u0002\u0002B\u0005\u0005\u0003\u0011\u0011dQ8oiJ|G\u000e\\3s\u001b\u0016$\u0018\rZ1uC6+GO]5dg\u0006Y2m\u001c8ue>dG.\u001a:TKJ4XM]'fiJL7m]0%KF$B!a!\u0003\u0010!I\u00111R\u0014\u0002\u0002\u0003\u0007\u0011Q`\u0001\u0019G>tGO]8mY\u0016\u00148+\u001a:wKJlU\r\u001e:jGN\u0004\u0003f\u0001\u0015\u00026\u00061An\\1eKJ,\"A!\u0007\u0011\t\tm!1E\u0007\u0003\u0005;QAA!\u0006\u0003 )\u0019!\u0011E5\u0002\u000b%l\u0017mZ3\n\t\t\u0015\"Q\u0004\u0002\u000f\u001b\u0016$\u0018\rZ1uC2{\u0017\rZ3s\u0003)aw.\u00193fe~#S-\u001d\u000b\u0005\u0003\u0007\u0013Y\u0003C\u0005\u0002\f*\n\t\u00111\u0001\u0003\u001a\u00059An\\1eKJ\u0004\u0003fA\u0016\u00026\u000612O\\1qg\"|Go\u001d#jC\ndW\r\u001a*fCN|g.\u0006\u0002\u00036A1!q\u0007B\u001f\u0005\u0003j!A!\u000f\u000b\u0007\tmb0\u0001\u0004bi>l\u0017nY\u0005\u0005\u0005\u007f\u0011IDA\bBi>l\u0017n\u0019*fM\u0016\u0014XM\\2f!\u0011\u0011\u0019Ea\u0013\u000f\t\t\u0015#q\t\t\u0004\u0003[Y\u0015b\u0001B%\u0017\u00061\u0001K]3eK\u001aLAA!\u0014\u0003P\t11\u000b\u001e:j]\u001eT1A!\u0013L\u0003]\u0019h.\u00199tQ>$8\u000fR5bE2,GMU3bg>t\u0007%A\bt]\u0006\u00048\u000f[8u\u000b6LG\u000f^3s+\t\u00119\u0006\u0005\u0003\u0003Z\t}SB\u0001B.\u0015\u0011\u0011iFa\b\u0002\u0013A,(\r\\5tQ\u0016\u0014\u0018\u0002\u0002B1\u00057\u0012qb\u00158baNDw\u000e^#nSR$XM]\u0001\u0014g:\f\u0007o\u001d5pi\u0016k\u0017\u000e\u001e;fe~#S-\u001d\u000b\u0005\u0003\u0007\u00139\u0007C\u0005\u0002\f>\n\t\u00111\u0001\u0003X\u0005\u00012O\\1qg\"|G/R7jiR,'\u000f\t\u0015\u0004a\u0005U\u0016!E:oCB\u001c\bn\u001c;HK:,'/\u0019;peV\u0011!\u0011\u000f\t\u0005\u00053\u0012\u0019(\u0003\u0003\u0003v\tm#!E*oCB\u001c\bn\u001c;HK:,'/\u0019;pe\u0006)2O\\1qg\"|GoR3oKJ\fGo\u001c:`I\u0015\fH\u0003BAB\u0005wB\u0011\"a#3\u0003\u0003\u0005\rA!\u001d\u0002%Mt\u0017\r]:i_R<UM\\3sCR|'\u000f\t\u0015\u0004g\u0005U\u0016AB5t+N,G\r\u0006\u0002\u0002z\u0005q1\u000f^1si\u001a{'O\u0011:pW\u0016\u0014HCAAB\u0003I\u0019H/\u0019:u\r>\u00148i\u001c8ue>dG.\u001a:\u0002\u001bM$x\u000e\u001d$pe\n\u0013xn[3s\u0003E\u0019Ho\u001c9G_J\u001cuN\u001c;s_2dWM]\u0001\u0018e\u00064G/T1oC\u001e,'OR1vYRD\u0015M\u001c3mKJ,\"Aa%\u0011\t\tU%1T\u0007\u0003\u0005/SAA!'\u0002P\u0006)a-Y;mi&!!Q\u0014BL\u000511\u0015-\u001e7u\u0011\u0006tG\r\\3s\u0003iiW\r^1eCR\fGj\\1eKJ4\u0015-\u001e7u\u0011\u0006tG\r\\3s\u0003u\u0019wN\u001c;s_2dWM]*uCJ$X\u000f\u001d$bk2$\b*\u00198eY\u0016\u0014\u0018!J5oSRL\u0017\r\u001c\"s_.,'/T3uC\u0012\fG/\u0019'pC\u00124\u0015-\u001e7u\u0011\u0006tG\r\\3s\u0003q\tXo\u001c:v[\u000e{g\u000e\u001e:pY2,'OR1vYRD\u0015M\u001c3mKJ\fa$\\3uC\u0012\fG/\u0019)vE2L7\u000f[5oO\u001a\u000bW\u000f\u001c;IC:$G.\u001a:\u0002\u000bM$\u0018M\u001d;\u0002'\u0015t7/\u001e:f\u001d>$(+\u00194u\u0019\u0016\fG-\u001a:\u0002\tM$x\u000e\u001d")
public class SharedServer
implements Logging {
    private final KafkaConfig sharedServerConfig;
    private final MetaProperties metaProps;
    private final Time time;
    private final Metrics _metrics;
    private final CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final FaultHandlerFactory faultHandlerFactory;
    private final LogContext logContext;
    private boolean started;
    private boolean usedByBroker;
    private boolean usedByController;
    private final KafkaConfig brokerConfig;
    private final KafkaConfig controllerConfig;
    private volatile Metrics metrics;
    private volatile KafkaRaftManager<ApiMessageAndVersion> raftManager;
    private volatile BrokerServerMetrics brokerMetrics;
    private volatile ControllerMetadataMetrics controllerServerMetrics;
    private volatile MetadataLoader loader;
    private final AtomicReference<String> snapshotsDiabledReason;
    private volatile SnapshotEmitter snapshotEmitter;
    private volatile SnapshotGenerator snapshotGenerator;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaConfig sharedServerConfig() {
        return this.sharedServerConfig;
    }

    public MetaProperties metaProps() {
        return this.metaProps;
    }

    public Time time() {
        return this.time;
    }

    private Metrics _metrics() {
        return this._metrics;
    }

    public CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    public FaultHandlerFactory faultHandlerFactory() {
        return this.faultHandlerFactory;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private boolean started() {
        return this.started;
    }

    private void started_$eq(boolean x$1) {
        this.started = x$1;
    }

    private boolean usedByBroker() {
        return this.usedByBroker;
    }

    private void usedByBroker_$eq(boolean x$1) {
        this.usedByBroker = x$1;
    }

    private boolean usedByController() {
        return this.usedByController;
    }

    private void usedByController_$eq(boolean x$1) {
        this.usedByController = x$1;
    }

    public KafkaConfig brokerConfig() {
        return this.brokerConfig;
    }

    public KafkaConfig controllerConfig() {
        return this.controllerConfig;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public KafkaRaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    public void raftManager_$eq(KafkaRaftManager<ApiMessageAndVersion> x$1) {
        this.raftManager = x$1;
    }

    public BrokerServerMetrics brokerMetrics() {
        return this.brokerMetrics;
    }

    public void brokerMetrics_$eq(BrokerServerMetrics x$1) {
        this.brokerMetrics = x$1;
    }

    public ControllerMetadataMetrics controllerServerMetrics() {
        return this.controllerServerMetrics;
    }

    public void controllerServerMetrics_$eq(ControllerMetadataMetrics x$1) {
        this.controllerServerMetrics = x$1;
    }

    public MetadataLoader loader() {
        return this.loader;
    }

    public void loader_$eq(MetadataLoader x$1) {
        this.loader = x$1;
    }

    public AtomicReference<String> snapshotsDiabledReason() {
        return this.snapshotsDiabledReason;
    }

    public SnapshotEmitter snapshotEmitter() {
        return this.snapshotEmitter;
    }

    public void snapshotEmitter_$eq(SnapshotEmitter x$1) {
        this.snapshotEmitter = x$1;
    }

    public SnapshotGenerator snapshotGenerator() {
        return this.snapshotGenerator;
    }

    public void snapshotGenerator_$eq(SnapshotGenerator x$1) {
        this.snapshotGenerator = x$1;
    }

    public synchronized boolean isUsed() {
        return this.usedByController() || this.usedByBroker();
    }

    public synchronized void startForBroker() {
        if (!this.isUsed()) {
            this.start();
        }
        this.usedByBroker_$eq(true);
    }

    public synchronized void startForController() {
        if (!this.isUsed()) {
            this.start();
        }
        this.usedByController_$eq(true);
    }

    public synchronized void stopForBroker() {
        if (this.usedByBroker()) {
            this.usedByBroker_$eq(false);
            if (!this.isUsed()) {
                this.stop();
                return;
            }
        }
    }

    public synchronized void stopForController() {
        if (this.usedByController()) {
            this.usedByController_$eq(false);
            if (!this.isUsed()) {
                this.stop();
                return;
            }
        }
    }

    public FaultHandler raftManagerFaultHandler() {
        return this.faultHandlerFactory().build("raft manager", true, () -> {});
    }

    public FaultHandler metadataLoaderFaultHandler() {
        return this.faultHandlerFactory().build("metadata loading", this.sharedServerConfig().processRoles().contains((Object)KafkaRaftServer$ControllerRole$.MODULE$), () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.brokerMetrics()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)SharedServer.$anonfun$metadataLoaderFaultHandler$2(x$1)));
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                    x$2.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDiabledReason().compareAndSet(null, "metadata loading fault");
                return;
            }
        });
    }

    public FaultHandler controllerStartupFaultHandler() {
        return this.faultHandlerFactory().build("controller startup", true, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                    x$3.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDiabledReason().compareAndSet(null, "controller startup fault");
                return;
            }
        });
    }

    public FaultHandler initialBrokerMetadataLoadFaultHandler() {
        return this.faultHandlerFactory().build("initial broker metadata loading", true, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.brokerMetrics()).foreach((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)SharedServer.$anonfun$initialBrokerMetadataLoadFaultHandler$2(x$4)));
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                    x$5.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDiabledReason().compareAndSet(null, "initial broker metadata loading fault");
                return;
            }
        });
    }

    public FaultHandler quorumControllerFaultHandler() {
        return this.faultHandlerFactory().build("quorum controller", true, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                    x$6.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDiabledReason().compareAndSet(null, "quorum controller fault");
                return;
            }
        });
    }

    public FaultHandler metadataPublishingFaultHandler() {
        return this.faultHandlerFactory().build("metadata publishing", false, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.brokerMetrics()).foreach((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)SharedServer.$anonfun$metadataPublishingFaultHandler$2(x$7)));
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                    x$8.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                return;
            }
        });
    }

    private synchronized void start() {
        if (this.started()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "SharedServer has already been started.");
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting SharedServer");
        try {
            if (this.metrics() == null) {
                this.metrics_$eq(new Metrics());
            }
            this.sharedServerConfig().dynamicConfig().initialize((Option<KafkaZkClient>)None$.MODULE$);
            if (this.sharedServerConfig().processRoles().contains((Object)KafkaRaftServer$BrokerRole$.MODULE$)) {
                this.brokerMetrics_$eq(BrokerServerMetrics$.MODULE$.apply(this.metrics()));
            }
            if (this.sharedServerConfig().processRoles().contains((Object)KafkaRaftServer$ControllerRole$.MODULE$)) {
                this.controllerServerMetrics_$eq(new ControllerMetadataMetrics(Optional.of(KafkaYammerMetrics.defaultRegistry())));
            }
            KafkaRaftManager<ApiMessageAndVersion> _raftManager = new KafkaRaftManager<ApiMessageAndVersion>(this.metaProps(), this.sharedServerConfig(), (RecordSerde<ApiMessageAndVersion>)new MetadataRecordSerde(), KafkaRaftServer$.MODULE$.MetadataPartition(), KafkaRaftServer$.MODULE$.MetadataTopicId(), this.time(), this.metrics(), (Option<String>)new Some((Object)new StringBuilder(11).append("kafka-").append(this.sharedServerConfig().nodeId()).append("-raft").toString()), this.controllerQuorumVotersFuture(), this.raftManagerFaultHandler());
            this.raftManager_$eq(_raftManager);
            _raftManager.startup();
            MetadataLoader.Builder loaderBuilder = new MetadataLoader.Builder().setNodeId(this.metaProps().nodeId()).setTime(this.time()).setThreadNamePrefix(new StringBuilder(7).append("kafka-").append(this.sharedServerConfig().nodeId()).append("-").toString()).setFaultHandler(this.metadataLoaderFaultHandler()).setHighWaterMarkAccessor(() -> _raftManager.client().highWatermark());
            if (this.brokerMetrics() != null) {
                loaderBuilder.setMetadataLoaderMetrics((MetadataLoaderMetrics)this.brokerMetrics());
            }
            this.loader_$eq(loaderBuilder.build());
            this.snapshotEmitter_$eq(new SnapshotEmitter.Builder().setNodeId(this.metaProps().nodeId()).setRaftClient(_raftManager.client()).build());
            this.snapshotGenerator_$eq(new SnapshotGenerator.Builder((SnapshotGenerator.Emitter)this.snapshotEmitter()).setNodeId(this.metaProps().nodeId()).setTime(this.time()).setFaultHandler(this.metadataPublishingFaultHandler()).setMaxBytesSinceLastSnapshot(Predef$.MODULE$.Long2long(this.sharedServerConfig().metadataSnapshotMaxNewRecordBytes())).setMaxTimeSinceLastSnapshotNs(TimeUnit.MILLISECONDS.toNanos(Predef$.MODULE$.Long2long(this.sharedServerConfig().metadataSnapshotMaxIntervalMs()))).setDisabledReason(this.snapshotsDiabledReason()).setThreadNamePrefix(new StringBuilder(7).append("kafka-").append(this.sharedServerConfig().nodeId()).append("-").toString()).build());
            _raftManager.register((RaftClient.Listener<ApiMessageAndVersion>)this.loader());
            try {
                this.loader().installPublishers(Collections.singletonList(this.snapshotGenerator()));
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unable to install metadata publishers", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                throw new RuntimeException("Unable to install metadata publishers.", t);
            }
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Completed SharedServer startup.");
            this.started_$eq(true);
            return;
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Got exception while starting SharedServer", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            this.stop();
            return;
        }
    }

    public synchronized void ensureNotRaftLeader() {
        Option$.MODULE$.apply(this.raftManager()).foreach((Function1 & Serializable & scala.Serializable)_raftManager -> {
            SharedServer.$anonfun$ensureNotRaftLeader$1(this, _raftManager);
            return BoxedUnit.UNIT;
        });
    }

    private synchronized void stop() {
        if (!this.started()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "SharedServer is not running.");
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopping SharedServer");
        if (this.loader() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.loader().beginShutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
        }
        if (this.snapshotGenerator() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.snapshotGenerator().beginShutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
        }
        if (this.loader() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.loader().close(), this, CoreUtils$.MODULE$.swallow$default$3());
            this.loader_$eq(null);
        }
        if (this.snapshotGenerator() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.snapshotGenerator().close(), this, CoreUtils$.MODULE$.swallow$default$3());
            this.snapshotGenerator_$eq(null);
        }
        if (this.raftManager() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.raftManager().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
            this.raftManager_$eq(null);
        }
        if (this.controllerServerMetrics() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.controllerServerMetrics().close(), this, CoreUtils$.MODULE$.swallow$default$3());
            this.controllerServerMetrics_$eq(null);
        }
        if (this.brokerMetrics() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.brokerMetrics().close(), this, CoreUtils$.MODULE$.swallow$default$3());
            this.brokerMetrics_$eq(null);
        }
        if (this.metrics() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.metrics().close(), this, CoreUtils$.MODULE$.swallow$default$3());
            this.metrics_$eq(null);
        }
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AppInfoParser.unregisterAppInfo((String)Server$.MODULE$.MetricsPrefix(), (String)Integer.toString(this.sharedServerConfig().nodeId()), (Metrics)this.metrics()), this, CoreUtils$.MODULE$.swallow$default$3());
        this.started_$eq(false);
    }

    public static final /* synthetic */ long $anonfun$metadataLoaderFaultHandler$2(BrokerServerMetrics x$1) {
        return x$1.metadataLoadErrorCount().getAndIncrement();
    }

    public static final /* synthetic */ long $anonfun$initialBrokerMetadataLoadFaultHandler$2(BrokerServerMetrics x$4) {
        return x$4.metadataApplyErrorCount().getAndIncrement();
    }

    public static final /* synthetic */ long $anonfun$metadataPublishingFaultHandler$2(BrokerServerMetrics x$7) {
        return x$7.metadataApplyErrorCount().getAndIncrement();
    }

    public static final /* synthetic */ void $anonfun$ensureNotRaftLeader$1(SharedServer $this, KafkaRaftManager _raftManager) {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> _raftManager.shutdown(), $this, CoreUtils$.MODULE$.swallow$default$3());
        $this.raftManager_$eq(null);
    }

    public SharedServer(KafkaConfig sharedServerConfig, MetaProperties metaProps, Time time, Metrics _metrics, CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture, FaultHandlerFactory faultHandlerFactory) {
        this.sharedServerConfig = sharedServerConfig;
        this.metaProps = metaProps;
        this.time = time;
        this._metrics = _metrics;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        this.faultHandlerFactory = faultHandlerFactory;
        Logging.$init$(this);
        this.logContext = new LogContext(new StringBuilder(19).append("[SharedServer id=").append(sharedServerConfig.nodeId()).append("] ").toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.started = false;
        this.usedByBroker = false;
        this.usedByController = false;
        this.brokerConfig = new KafkaConfig(sharedServerConfig.props(), false, (Option<DynamicBrokerConfig>)None$.MODULE$);
        this.controllerConfig = new KafkaConfig(sharedServerConfig.props(), false, (Option<DynamicBrokerConfig>)None$.MODULE$);
        this.metrics = _metrics;
        this.snapshotsDiabledReason = new AtomicReference<Object>(null);
    }
}

