/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.zk.ControllerEpochZNode$;
import kafka.zk.KafkaZkClient;
import kafka.zookeeper.AsyncRequest;
import kafka.zookeeper.AsyncResponse;
import kafka.zookeeper.CheckOp;
import kafka.zookeeper.CreateOp;
import kafka.zookeeper.CreateRequest;
import kafka.zookeeper.CreateResponse;
import kafka.zookeeper.DeleteOp;
import kafka.zookeeper.DeleteRequest;
import kafka.zookeeper.DeleteResponse;
import kafka.zookeeper.MultiRequest;
import kafka.zookeeper.MultiResponse;
import kafka.zookeeper.ResponseMetadata;
import kafka.zookeeper.SetDataOp;
import kafka.zookeeper.SetDataRequest;
import kafka.zookeeper.SetDataResponse;
import kafka.zookeeper.ZkOp;
import kafka.zookeeper.ZkOpResult;
import kafka.zookeeper.ZooKeeperClient;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.client.ZKClientConfig;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;

public final class KafkaZkClient$ {
    public static KafkaZkClient$ MODULE$;

    static {
        new KafkaZkClient$();
    }

    public KafkaZkClient apply(String connectString, boolean isSecure, int sessionTimeoutMs, int connectionTimeoutMs, int maxInFlightRequests, Time time, String name, ZKClientConfig zkClientConfig, String metricGroup, String metricType, boolean createChrootIfNecessary) {
        int chrootIndex;
        if (zkClientConfig.getProperty("jute.maxbuffer") == null) {
            zkClientConfig.setProperty("jute.maxbuffer", Integer.toString(0x400000));
        }
        if (createChrootIfNecessary && (chrootIndex = connectString.indexOf("/")) > 0) {
            String zkConnWithoutChrootForChrootCreation = connectString.substring(0, chrootIndex);
            try (KafkaZkClient zkClientForChrootCreation = this.apply(zkConnWithoutChrootForChrootCreation, isSecure, sessionTimeoutMs, connectionTimeoutMs, maxInFlightRequests, time, name, zkClientConfig, metricGroup, metricType, this.apply$default$11());){
                String chroot = connectString.substring(chrootIndex);
                if (!zkClientForChrootCreation.pathExists(chroot)) {
                    zkClientForChrootCreation.makeSurePersistentPathExists(chroot);
                }
            }
        }
        ZooKeeperClient zooKeeperClient = new ZooKeeperClient(connectString, sessionTimeoutMs, connectionTimeoutMs, maxInFlightRequests, time, metricGroup, metricType, zkClientConfig, name);
        return new KafkaZkClient(zooKeeperClient, isSecure, time);
    }

    public String apply$default$9() {
        return "kafka.server";
    }

    public String apply$default$10() {
        return "SessionExpireListener";
    }

    public boolean apply$default$11() {
        return false;
    }

    public MultiRequest kafka$zk$KafkaZkClient$$wrapRequestWithControllerEpochCheck(AsyncRequest request, int expectedControllerZkVersion) {
        MultiRequest multiRequest;
        CheckOp checkOp = new CheckOp(ControllerEpochZNode$.MODULE$.path(), expectedControllerZkVersion);
        if (request instanceof CreateRequest) {
            CreateRequest createRequest = (CreateRequest)request;
            String path = createRequest.path();
            byte[] data = createRequest.data();
            Seq<ACL> acl = createRequest.acl();
            CreateMode createMode = createRequest.createMode();
            Option<Object> ctx = createRequest.ctx();
            multiRequest = new MultiRequest((Seq<ZkOp>)new .colon.colon((Object)checkOp, (List)new .colon.colon((Object)new CreateOp(path, data, acl, createMode), (List)Nil$.MODULE$)), ctx);
        } else if (request instanceof DeleteRequest) {
            DeleteRequest deleteRequest = (DeleteRequest)request;
            String path = deleteRequest.path();
            int version = deleteRequest.version();
            Option<Object> ctx = deleteRequest.ctx();
            multiRequest = new MultiRequest((Seq<ZkOp>)new .colon.colon((Object)checkOp, (List)new .colon.colon((Object)new DeleteOp(path, version), (List)Nil$.MODULE$)), ctx);
        } else if (request instanceof SetDataRequest) {
            SetDataRequest setDataRequest = (SetDataRequest)request;
            String path = setDataRequest.path();
            byte[] data = setDataRequest.data();
            int version = setDataRequest.version();
            Option<Object> ctx = setDataRequest.ctx();
            multiRequest = new MultiRequest((Seq<ZkOp>)new .colon.colon((Object)checkOp, (List)new .colon.colon((Object)new SetDataOp(path, data, version), (List)Nil$.MODULE$)), ctx);
        } else {
            throw new IllegalStateException(new StringBuilder(37).append(request).append(" does not need controller epoch check").toString());
        }
        return multiRequest;
    }

    public void kafka$zk$KafkaZkClient$$handleUnwrappedCheckOp(CheckOp checkOp, OpResult checkOpResult) {
        if (checkOpResult instanceof OpResult.ErrorResult) {
            OpResult.ErrorResult errorResult = (OpResult.ErrorResult)checkOpResult;
            if (checkOp.path().equals(ControllerEpochZNode$.MODULE$.path())) {
                KeeperException.Code errorCode;
                KeeperException.Code code = errorCode = KeeperException.Code.get((int)errorResult.getErr());
                KeeperException.Code code2 = KeeperException.Code.BADVERSION;
                if (!(code != null ? !code.equals(code2) : code2 != null)) {
                    throw new ControllerMovedException(new StringBuilder(61).append("Controller epoch zkVersion check fails. Expected zkVersion = ").append(checkOp.version()).toString());
                }
                KeeperException.Code code3 = errorCode;
                KeeperException.Code code4 = KeeperException.Code.OK;
                if (code3 == null ? code4 != null : !code3.equals(code4)) {
                    throw KeeperException.create((KeeperException.Code)errorCode, (String)checkOp.path());
                }
            }
        }
    }

    public AsyncResponse kafka$zk$KafkaZkClient$$handleUnwrappedZkOp(ZkOpResult zkOpResult, KeeperException.Code resultCode, Option<Object> ctx, ResponseMetadata responseMetadata) {
        AsyncResponse asyncResponse;
        OpResult rawOpResult = zkOpResult.rawOpResult();
        ZkOp zkOp = zkOpResult.zkOp();
        if (zkOp instanceof CreateOp) {
            CreateOp createOp = (CreateOp)zkOp;
            String string = rawOpResult instanceof OpResult.CreateResult ? ((OpResult.CreateResult)rawOpResult).getPath() : null;
            asyncResponse = new CreateResponse(resultCode, createOp.path(), ctx, string, responseMetadata);
        } else if (zkOp instanceof DeleteOp) {
            DeleteOp deleteOp = (DeleteOp)zkOp;
            asyncResponse = new DeleteResponse(resultCode, deleteOp.path(), ctx, responseMetadata);
        } else if (zkOp instanceof SetDataOp) {
            SetDataOp setDataOp = (SetDataOp)zkOp;
            Stat stat = rawOpResult instanceof OpResult.SetDataResult ? ((OpResult.SetDataResult)rawOpResult).getStat() : null;
            asyncResponse = new SetDataResponse(resultCode, setDataOp.path(), ctx, stat, responseMetadata);
        } else {
            throw new IllegalStateException(new StringBuilder(17).append("Unexpected zkOp: ").append(zkOp).toString());
        }
        return asyncResponse;
    }

    public AsyncResponse kafka$zk$KafkaZkClient$$unwrapResponseWithControllerEpochCheck(AsyncResponse response) {
        OpResult checkOpResult;
        ZkOp checkOp;
        ZkOpResult zkOpResult;
        ResponseMetadata responseMetadata;
        Option<Object> ctx;
        KeeperException.Code resultCode;
        block5: {
            block3: {
                Seq<ZkOpResult> zkOpResults;
                block4: {
                    if (!(response instanceof MultiResponse)) break block3;
                    MultiResponse multiResponse = (MultiResponse)response;
                    resultCode = multiResponse.resultCode();
                    ctx = multiResponse.ctx();
                    zkOpResults = multiResponse.zkOpResults();
                    responseMetadata = multiResponse.metadata();
                    Some some = Seq$.MODULE$.unapplySeq(zkOpResults);
                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block4;
                    ZkOpResult zkOpResult2 = (ZkOpResult)((SeqLike)some.get()).apply(0);
                    zkOpResult = (ZkOpResult)((SeqLike)some.get()).apply(1);
                    if (zkOpResult2 == null) break block4;
                    checkOp = zkOpResult2.zkOp();
                    checkOpResult = zkOpResult2.rawOpResult();
                    if (checkOp instanceof CheckOp) break block5;
                }
                if (zkOpResults == null) {
                    throw KeeperException.create((KeeperException.Code)resultCode);
                }
                throw new IllegalStateException(new StringBuilder(86).append("Cannot unwrap ").append(response).append(" because the first zookeeper op is not check op in original MultiRequest").toString());
            }
            throw new IllegalStateException(new StringBuilder(48).append("Cannot unwrap ").append(response).append(" because it is not a MultiResponse").toString());
        }
        CheckOp checkOp2 = (CheckOp)checkOp;
        this.kafka$zk$KafkaZkClient$$handleUnwrappedCheckOp(checkOp2, checkOpResult);
        AsyncResponse asyncResponse = this.kafka$zk$KafkaZkClient$$handleUnwrappedZkOp(zkOpResult, resultCode, ctx, responseMetadata);
        return asyncResponse;
    }

    public KafkaZkClient createZkClient(String name, Time time, KafkaConfig config, ZKClientConfig zkClientConfig) {
        boolean isZkSecurityEnabled;
        boolean secureAclsEnabled = config.zkEnableSecureAcls();
        boolean bl = isZkSecurityEnabled = JaasUtils.isZkSaslEnabled() || KafkaConfig$.MODULE$.zkTlsClientAuthEnabled(zkClientConfig);
        if (secureAclsEnabled && !isZkSecurityEnabled) {
            throw new SecurityException(new StringBuilder(146).append(KafkaConfig$.MODULE$.ZkEnableSecureAclsProp()).append(" is true, but ZooKeeper client TLS configuration identifying at least ").append(KafkaConfig$.MODULE$.ZkSslClientEnableProp()).append(", ").append(KafkaConfig$.MODULE$.ZkClientCnxnSocketProp()).append(", and ").append(KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp()).append(" was not present and the verification of the JAAS login file failed ").append(JaasUtils.zkSecuritySysConfigString()).toString());
        }
        String x$1 = config.zkConnect();
        int x$3 = config.zkSessionTimeoutMs();
        int x$4 = config.zkConnectionTimeoutMs();
        int x$5 = config.zkMaxInFlightRequests();
        boolean x$9 = true;
        String x$10 = this.apply$default$9();
        String x$11 = this.apply$default$10();
        return this.apply(x$1, secureAclsEnabled, x$3, x$4, x$5, time, name, zkClientConfig, x$10, x$11, x$9);
    }

    private KafkaZkClient$() {
        MODULE$ = this;
    }
}

