/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk.migration;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.function.BiConsumer;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclAuthorizer$;
import kafka.security.authorizer.AclEntry;
import kafka.utils.Logging;
import kafka.zk.AclChangeNode;
import kafka.zk.KafkaZkClient;
import kafka.zk.ResourceZNode$;
import kafka.zk.ZkAclStore$;
import kafka.zk.ZkMigrationClient$;
import kafka.zk.ZkVersion$;
import kafka.zookeeper.AsyncResponse;
import kafka.zookeeper.CreateRequest;
import kafka.zookeeper.CreateRequest$;
import kafka.zookeeper.DeleteRequest;
import kafka.zookeeper.DeleteRequest$;
import kafka.zookeeper.DeleteResponse;
import kafka.zookeeper.SetDataRequest;
import kafka.zookeeper.SetDataRequest$;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.metadata.migration.AclMigrationClient;
import org.apache.kafka.metadata.migration.MigrationClientAuthException;
import org.apache.kafka.metadata.migration.MigrationClientException;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.immutable.TreeMap;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001\u0002\u0005\n\u0001AA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\u0006a\u0001!\t!\r\u0005\u0006k\u0001!IA\u000e\u0005\u0006\u000f\u0002!I\u0001\u0013\u0005\u0006_\u0002!\t\u0005\u001d\u0005\b\u0003\u0007\u0001A\u0011IA\u0003\u0011\u001d\tY\u0001\u0001C!\u0003\u001b\u0011ACW6BG2l\u0015n\u001a:bi&|gn\u00117jK:$(B\u0001\u0006\f\u0003%i\u0017n\u001a:bi&|gN\u0003\u0002\r\u001b\u0005\u0011!p\u001b\u0006\u0002\u001d\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\u00123\u0015\u0002\"AE\f\u000e\u0003MQ!\u0001F\u000b\u0002\t1\fgn\u001a\u0006\u0002-\u0005!!.\u0019<b\u0013\tA2C\u0001\u0004PE*,7\r\u001e\t\u00035\rj\u0011a\u0007\u0006\u0003\u0015qQ!!\b\u0010\u0002\u00115,G/\u00193bi\u0006T!AD\u0010\u000b\u0005\u0001\n\u0013AB1qC\u000eDWMC\u0001#\u0003\ry'oZ\u0005\u0003Im\u0011!#Q2m\u001b&<'/\u0019;j_:\u001cE.[3oiB\u0011a%K\u0007\u0002O)\u0011\u0001&D\u0001\u0006kRLGn]\u0005\u0003U\u001d\u0012q\u0001T8hO&tw-\u0001\u0005{W\u000ec\u0017.\u001a8u!\tic&D\u0001\f\u0013\ty3BA\u0007LC\u001a\\\u0017MW6DY&,g\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005I\"\u0004CA\u001a\u0001\u001b\u0005I\u0001\"B\u0016\u0003\u0001\u0004a\u0013\u0001H1dY\u000eC\u0017M\\4f\u001d>$\u0018NZ5dCRLwN\u001c*fcV,7\u000f\u001e\u000b\u0003ou\u0002\"\u0001O\u001e\u000e\u0003eR!AO\u0007\u0002\u0013i|wn[3fa\u0016\u0014\u0018B\u0001\u001f:\u00055\u0019%/Z1uKJ+\u0017/^3ti\")ah\u0001a\u0001\u007f\u0005y!/Z:pkJ\u001cW\rU1ui\u0016\u0014h\u000e\u0005\u0002A\u000b6\t\u0011I\u0003\u0002C\u0007\u0006A!/Z:pkJ\u001cWM\u0003\u0002E=\u000511m\\7n_:L!AR!\u0003\u001fI+7o\\;sG\u0016\u0004\u0016\r\u001e;fe:\fA\u0002\u001e:z/JLG/Z!dYN$R!\u0013*TQ6\u00042AS'P\u001b\u0005Y%\"\u0001'\u0002\u000bM\u001c\u0017\r\\1\n\u00059[%AB(qi&|g\u000e\u0005\u0002\u001b!&\u0011\u0011k\u0007\u0002\u001b5.l\u0015n\u001a:bi&|g\u000eT3bI\u0016\u00148\u000f[5q'R\fG/\u001a\u0005\u0006}\u0011\u0001\ra\u0010\u0005\u0006)\u0012\u0001\r!V\u0001\u000bC\u000edWI\u001c;sS\u0016\u001c\bc\u0001,^A:\u0011qk\u0017\t\u00031.k\u0011!\u0017\u0006\u00035>\ta\u0001\u0010:p_Rt\u0014B\u0001/L\u0003\u0019\u0001&/\u001a3fM&\u0011al\u0018\u0002\u0004'\u0016$(B\u0001/L!\t\tg-D\u0001c\u0015\t\u0019G-\u0001\u0006bkRDwN]5{KJT!!Z\u0007\u0002\u0011M,7-\u001e:jifL!a\u001a2\u0003\u0011\u0005\u001bG.\u00128uefDQ!\u001b\u0003A\u0002)\faa\u0019:fCR,\u0007C\u0001&l\u0013\ta7JA\u0004C_>dW-\u00198\t\u000b9$\u0001\u0019A(\u0002\u000bM$\u0018\r^3\u0002#]\u0014\u0018\u000e^3SKN|WO]2f\u0003\u000ed7\u000fF\u0003PcJ\f\t\u0001C\u0003?\u000b\u0001\u0007q\bC\u0003t\u000b\u0001\u0007A/A\u0006bG2\u001cHk\\,sSR,\u0007cA;yu6\taO\u0003\u0002x+\u0005!Q\u000f^5m\u0013\tIhO\u0001\u0006D_2dWm\u0019;j_:\u0004\"a\u001f@\u000e\u0003qT!!`\"\u0002\u0007\u0005\u001cG.\u0003\u0002\u0000y\n\u0011\u0012iY2fgN\u001cuN\u001c;s_2,e\u000e\u001e:z\u0011\u0015qW\u00011\u0001P\u00039!W\r\\3uKJ+7o\\;sG\u0016$RaTA\u0004\u0003\u0013AQA\u0010\u0004A\u0002}BQA\u001c\u0004A\u0002=\u000b1\"\u001b;fe\u0006$X-Q2mgR!\u0011qBA\u000b!\rQ\u0015\u0011C\u0005\u0004\u0003'Y%\u0001B+oSRDq!a\u0006\b\u0001\u0004\tI\"A\u0006bG2\u001cuN\\:v[\u0016\u0014\bcBA\u000e\u0003Cy\u0014QE\u0007\u0003\u0003;Q1!a\bw\u0003!1WO\\2uS>t\u0017\u0002BA\u0012\u0003;\u0011!BQ5D_:\u001cX/\\3s!\u0011)\u0018q\u0005>\n\u0005y3\b")
public class ZkAclMigrationClient
implements AclMigrationClient,
Logging {
    private final KafkaZkClient zkClient;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private CreateRequest aclChangeNotificationRequest(ResourcePattern resourcePattern) {
        AclChangeNode aclChange = ZkAclStore$.MODULE$.apply(resourcePattern.patternType()).changeStore().createChangeNode(resourcePattern);
        return new CreateRequest(aclChange.path(), aclChange.bytes(), this.zkClient.defaultAcls(aclChange.path()), CreateMode.PERSISTENT_SEQUENTIAL, CreateRequest$.MODULE$.apply$default$5());
    }

    private Option<ZkMigrationLeadershipState> tryWriteAcls(ResourcePattern resourcePattern, scala.collection.immutable.Set<AclEntry> aclEntries, boolean create, ZkMigrationLeadershipState state) {
        if (ZkMigrationClient$.MODULE$ == null) {
            throw null;
        }
        try {
            return ZkAclMigrationClient.$anonfun$tryWriteAcls$1(this, aclEntries, create, resourcePattern, state);
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException;
            if (bl) {
                throw throwable;
            }
            boolean bl2 = throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException);
            if (bl2) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ZkMigrationLeadershipState writeResourceAcls(ResourcePattern resourcePattern, Collection<AccessControlEntry> aclsToWrite, ZkMigrationLeadershipState state) {
        ZkMigrationLeadershipState zkMigrationLeadershipState;
        scala.collection.immutable.Set acls = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(aclsToWrite).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> new AclEntry((AccessControlEntry)x$2), Iterable$.MODULE$.canBuildFrom())).toSet();
        Option<ZkMigrationLeadershipState> option = this.tryWriteAcls(resourcePattern, (scala.collection.immutable.Set<AclEntry>)acls, false, state);
        if (option instanceof Some) {
            zkMigrationLeadershipState = (ZkMigrationLeadershipState)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            void var8_8;
            Option<ZkMigrationLeadershipState> option2 = this.tryWriteAcls(resourcePattern, (scala.collection.immutable.Set<AclEntry>)acls, true, state);
            if (!(option2 instanceof Some)) {
                if (None$.MODULE$.equals(option2)) {
                    throw new MigrationClientException(new StringBuilder(42).append("Could not write ACLs for resource pattern ").append(resourcePattern).toString());
                }
                throw new MatchError(option2);
            }
            ZkMigrationLeadershipState newState = (ZkMigrationLeadershipState)((Some)option2).value();
            zkMigrationLeadershipState = var8_8;
        } else {
            throw new MatchError(option);
        }
        return zkMigrationLeadershipState;
    }

    /*
     * WARNING - void declaration
     */
    public ZkMigrationLeadershipState deleteResource(ResourcePattern resourcePattern, ZkMigrationLeadershipState state) {
        void var6_6;
        DeleteRequest request = new DeleteRequest(ResourceZNode$.MODULE$.path(resourcePattern), ZkVersion$.MODULE$.MatchAnyVersion(), DeleteRequest$.MODULE$.apply$default$3());
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = this.zkClient.retryMigrationRequestsUntilConnected(new .colon.colon((Object)request, (List)Nil$.MODULE$), state);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        if (((DeleteResponse)var6_6.head()).resultCode().equals((Object)KeeperException.Code.OK) || ((DeleteResponse)var6_6.head()).resultCode().equals((Object)KeeperException.Code.NONODE)) {
            void var5_5;
            this.zkClient.retryRequestUntilConnected(this.aclChangeNotificationRequest(resourcePattern), this.zkClient.retryRequestUntilConnected$default$2());
            return state.withMigrationZkVersion((int)var5_5);
        }
        throw new MigrationClientException(new StringBuilder(42).append("Could not delete ACL for resource pattern ").append(resourcePattern).toString());
    }

    /*
     * WARNING - void declaration
     */
    public void iterateAcls(BiConsumer<ResourcePattern, java.util.Set<AccessControlEntry>> aclConsumer) {
        void loadAllAcls_aclConsumer;
        void loadAllAcls_zkClient;
        ObjectRef allAcls = ObjectRef.create((Object)new TreeMap((Ordering)new AclAuthorizer.ResourceOrdering()));
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(resourcePattern, versionedAcls) -> {
            ZkAclMigrationClient.updateAcls$1(resourcePattern, versionedAcls, allAcls);
            return BoxedUnit.UNIT;
        };
        KafkaZkClient kafkaZkClient = this.zkClient;
        if (AclAuthorizer$.MODULE$ == null) {
            throw null;
        }
        ZkAclStore$.MODULE$.stores().foreach(arg_0 -> AclAuthorizer$.$anonfun$loadAllAcls$1$adapted((KafkaZkClient)loadAllAcls_zkClient, (Function2)loadAllAcls_aclConsumer, this, arg_0));
        ((TreeMap)allAcls.elem).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                ResourcePattern $anonfun$iterateAcls$2_resourcePattern = (ResourcePattern)x0$1._1();
                AclAuthorizer.VersionedAcls $anonfun$iterateAcls$2_versionedAcls = (AclAuthorizer.VersionedAcls)x0$1._2();
                String string = new StringBuilder(37).append("Error in ACL consumer. Resource was ").append($anonfun$iterateAcls$2_resourcePattern).append(".").toString();
                if (ZkMigrationClient$.MODULE$ == null) {
                    throw null;
                }
                try {
                    aclConsumer.accept($anonfun$iterateAcls$2_resourcePattern, CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)$anonfun$iterateAcls$2_versionedAcls.acls().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.ace(), Set$.MODULE$.canBuildFrom())).asJava());
                }
                catch (Throwable $anonfun$iterateAcls$2_logAndRethrow_e) {
                    void $anonfun$iterateAcls$2_logAndRethrow_msg;
                    this.error((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1((String)$anonfun$iterateAcls$2_logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2($anonfun$iterateAcls$2_logAndRethrow_e)));
                    throw $anonfun$iterateAcls$2_logAndRethrow_e;
                }
            } else {
                throw new MatchError(null);
            }
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Option $anonfun$tryWriteAcls$1(ZkAclMigrationClient $this, scala.collection.immutable.Set aclEntries$1, boolean create$1, ResourcePattern resourcePattern$1, ZkMigrationLeadershipState state$1) {
        void var9_9;
        void var10_10;
        Product product;
        byte[] aclData = ResourceZNode$.MODULE$.encode((scala.collection.immutable.Set<AclEntry>)aclEntries$1);
        if (create$1) {
            String path = ResourceZNode$.MODULE$.path(resourcePattern$1);
            product = new CreateRequest(path, aclData, $this.zkClient.defaultAcls(path), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5());
        } else {
            product = new SetDataRequest(ResourceZNode$.MODULE$.path(resourcePattern$1), aclData, ZkVersion$.MODULE$.MatchAnyVersion(), SetDataRequest$.MODULE$.apply$default$4());
        }
        Product request = product;
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(new .colon.colon((Object)request, (List)Nil$.MODULE$), state$1);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        if (((AsyncResponse)var10_10.head()).resultCode().equals((Object)KeeperException.Code.NONODE)) {
            return None$.MODULE$;
        }
        $this.zkClient.retryRequestUntilConnected($this.aclChangeNotificationRequest(resourcePattern$1), $this.zkClient.retryRequestUntilConnected$default$2());
        return new Some((Object)state$1.withMigrationZkVersion((int)var9_9));
    }

    private static final void updateAcls$1(ResourcePattern resourcePattern, AclAuthorizer.VersionedAcls versionedAcls, ObjectRef allAcls$1) {
        allAcls$1.elem = ((TreeMap)allAcls$1.elem).updated((Object)resourcePattern, (Object)versionedAcls);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$iterateAcls$2(ZkAclMigrationClient $this, BiConsumer aclConsumer$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            ResourcePattern resourcePattern = (ResourcePattern)x0$1._1();
            AclAuthorizer.VersionedAcls versionedAcls = (AclAuthorizer.VersionedAcls)x0$1._2();
            String string = new StringBuilder(37).append("Error in ACL consumer. Resource was ").append(resourcePattern).append(".").toString();
            if (ZkMigrationClient$.MODULE$ == null) {
                throw null;
            }
            try {
                aclConsumer$1.accept(resourcePattern, CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)versionedAcls.acls().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.ace(), Set$.MODULE$.canBuildFrom())).asJava());
                return;
            }
            catch (Throwable logAndRethrow_e) {
                void logAndRethrow_msg;
                $this.error((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1((String)logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
                throw logAndRethrow_e;
            }
        }
        throw new MatchError(null);
    }

    public ZkAclMigrationClient(KafkaZkClient zkClient) {
        this.zkClient = zkClient;
        Logging.$init$(this);
    }
}

