/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Optional;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.KafkaMetadataLog$FullTruncation$;
import kafka.raft.KafkaMetadataLog$UnknownReason$;
import kafka.raft.MetadataLogConfig;
import kafka.raft.SegmentPosition;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.utils.Logging;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.Isolation;
import org.apache.kafka.raft.LogFetchInfo;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.OffsetMetadata;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.raft.ValidOffsetAndEpoch;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.snapshot.FileRawSnapshotReader;
import org.apache.kafka.snapshot.FileRawSnapshotWriter;
import org.apache.kafka.snapshot.NotifyingRawSnapshotWriter;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.Snapshots;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.kafka.storage.internals.log.VerificationGuard;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MapLike;
import scala.collection.mutable.TreeMap;
import scala.collection.mutable.TreeMap$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0011ue\u0001\u0002;v\u0005iD!\"a\n\u0001\u0005\u000b\u0007I\u0011AA\u0015\u0011)\t)\u0004\u0001B\u0001B\u0003%\u00111\u0006\u0005\u000b\u0003o\u0001!\u0011!Q\u0001\n\u0005e\u0002BCA$\u0001\t\u0005\t\u0015!\u0003\u0002J!Q\u0011\u0011\f\u0001\u0003\u0002\u0003\u0006I!a\u0017\t\u0015\u0005%\u0005A!A!\u0002\u0013\tY\t\u0003\u0006\u0002\u0014\u0002\u0011\t\u0011)A\u0005\u0003+Cq!!(\u0001\t\u0013\ty\nC\u0004\u00020\u0002!\t%!-\t\u000f\u00055\u0007\u0001\"\u0011\u0002P\"9\u0011\u0011\u001f\u0001\u0005B\u0005M\bbBA|\u0001\u0011%\u0011\u0011 \u0005\b\u0005\u001f\u0001A\u0011\tB\t\u0011\u001d\u0011\u0019\u0002\u0001C!\u0005+AqA!\u0007\u0001\t\u0003\u0012Y\u0002C\u0004\u0002<\u0002!\tEa\t\t\u000f\t\u0015\u0002\u0001\"\u0011\u0003(!9!1\u0007\u0001\u0005B\tU\u0002b\u0002B\u001f\u0001\u0011\u0005#q\b\u0005\b\u0005\u0007\u0002A\u0011\tB#\u0011\u001d\u0011Y\u0005\u0001C!\u00057AqA!\u0014\u0001\t\u0003\u0012y\u0005C\u0004\u0002\n\u0002!\tE!\u0016\t\u000f\t]\u0003\u0001\"\u0011\u0003Z!9!\u0011\r\u0001\u0005B\t\r\u0004b\u0002B=\u0001\u0011\u0005#1\u0010\u0005\b\u0005\u007f\u0002A\u0011\tBA\u0011\u001d\u0011i\t\u0001C!\u0005\u001fCqA!%\u0001\t\u0003\u0012\u0019\nC\u0004\u0003\u0018\u0002!\tEa%\t\u000f\te\u0005\u0001\"\u0011\u0003\u001c\"9!q\u0014\u0001\u0005B\t\u0005\u0006b\u0002BP\u0001\u0011%!Q\u0015\u0005\b\t\u001b\u0002A\u0011\u0002C(\u0011\u001d!I\u0007\u0001C\u0005\tWBq\u0001\"\u001d\u0001\t\u0003\u0012)\u0004C\u0004\u0005t\u0001!I\u0001\"\u001e\t\u000f\u0011\r\u0005\u0001\"\u0003\u00036!9AQ\u0011\u0001\u0005\n\tU\u0002b\u0002CD\u0001\u0011%A\u0011\u0012\u0005\b\t\u001f\u0003A\u0011\u0002CI\u0011\u001d!9\n\u0001C!\t3C\u0001\u0002b'\u0001\t\u0003)(\u0011C\u0004\b\u0005\u007f+\b\u0012\u0001Ba\r\u0019!X\u000f#\u0001\u0003D\"9\u0011QT\u0017\u0005\u0002\t-\u0007b\u0002Bg[\u0011\u0005!q\u001a\u0005\b\u0005WlC\u0011\u0002Bw\u0011\u001d\u0011\t0\fC\u0005\u0005g4\u0011b!\u0005.!\u0003\rJca\u0005\t\u000f\t-&G\"\u0001\u0004\u0016\u0019111H\u0017G\u0007{A!ba\u00135\u0005+\u0007I\u0011AB'\u0011)\u0019y\u0005\u000eB\tB\u0003%\u0011Q\u0018\u0005\u000b\u0007#\"$Q3A\u0005\u0002\r5\u0003BCB*i\tE\t\u0015!\u0003\u0002>\"Q1Q\u000b\u001b\u0003\u0016\u0004%\ta!\u0014\t\u0015\r]CG!E!\u0002\u0013\ti\fC\u0004\u0002\u001eR\"\ta!\u0017\t\u000f\t-F\u0007\"\u0011\u0004d!I1q\r\u001b\u0002\u0002\u0013\u00051\u0011\u000e\u0005\n\u0007c\"\u0014\u0013!C\u0001\u0007gB\u0011b!#5#\u0003%\taa\u001d\t\u0013\r-E'%A\u0005\u0002\rM\u0004\"CBGi\u0005\u0005I\u0011IBH\u0011%\u0019)\nNA\u0001\n\u0003\u00199\nC\u0005\u0004\u001aR\n\t\u0011\"\u0001\u0004\u001c\"I1q\u0015\u001b\u0002\u0002\u0013\u00053\u0011\u0016\u0005\n\u0007g#\u0014\u0011!C\u0001\u0007kC\u0011b!/5\u0003\u0003%\tE!\u0005\t\u0013\rmF'!A\u0005B\ru\u0006\"CB`i\u0005\u0005I\u0011IBa\u000f%!\u0019!LA\u0001\u0012\u0013!)AB\u0005\u0004<5\n\t\u0011#\u0003\u0005\b!9\u0011Q\u0014&\u0005\u0002\u0011U\u0001\"CB^\u0015\u0006\u0005IQIB_\u0011%\u0011iMSA\u0001\n\u0003#9\u0002C\u0005\u0005 )\u000b\t\u0011\"!\u0005\"!IAq\u0006&\u0002\u0002\u0013%A\u0011\u0007\u0004\u0007\u0007\u000blcia2\t\u0015\r%\u0007K!f\u0001\n\u0003\u0019i\u0005\u0003\u0006\u0004LB\u0013\t\u0012)A\u0005\u0003{C!b!4Q\u0005+\u0007I\u0011AB'\u0011)\u0019y\r\u0015B\tB\u0003%\u0011Q\u0018\u0005\u000b\u0007#\u0004&Q3A\u0005\u0002\r5\u0003BCBj!\nE\t\u0015!\u0003\u0002>\"9\u0011Q\u0014)\u0005\u0002\rU\u0007b\u0002BV!\u0012\u00053q\u001c\u0005\n\u0007O\u0002\u0016\u0011!C\u0001\u0007GD\u0011b!\u001dQ#\u0003%\taa\u001d\t\u0013\r%\u0005+%A\u0005\u0002\rM\u0004\"CBF!F\u0005I\u0011AB:\u0011%\u0019i\tUA\u0001\n\u0003\u001ay\tC\u0005\u0004\u0016B\u000b\t\u0011\"\u0001\u0004\u0018\"I1\u0011\u0014)\u0002\u0002\u0013\u000511\u001e\u0005\n\u0007O\u0003\u0016\u0011!C!\u0007SC\u0011ba-Q\u0003\u0003%\taa<\t\u0013\re\u0006+!A\u0005B\tE\u0001\"CB^!\u0006\u0005I\u0011IB_\u0011%\u0019y\fUA\u0001\n\u0003\u001a\u0019pB\u0005\u000545\n\t\u0011#\u0003\u00056\u0019I1QY\u0017\u0002\u0002#%Aq\u0007\u0005\b\u0003;3G\u0011\u0001C\u001e\u0011%\u0019YLZA\u0001\n\u000b\u001ai\fC\u0005\u0003N\u001a\f\t\u0011\"!\u0005>!IAq\u00044\u0002\u0002\u0013\u0005EQ\t\u0005\n\t_1\u0017\u0011!C\u0005\tc9q\u0001\"\u0013.\u0011\u001b\u0019)DB\u0004\u0004,5Bia!\f\t\u000f\u0005uU\u000e\"\u0001\u00044!9!1V7\u0005B\r]ra\u0002C&[!51Q \u0004\b\u0007ol\u0003RBB}\u0011\u001d\ti*\u001dC\u0001\u0007wDqAa+r\t\u0003\u001ayP\u0001\tLC\u001a\\\u0017-T3uC\u0012\fG/\u0019'pO*\u0011ao^\u0001\u0005e\u00064GOC\u0001y\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019b\u0001A>\u0002\b\u0005m\u0001c\u0001?\u0002\u00045\tQP\u0003\u0002\u007f\u007f\u0006!A.\u00198h\u0015\t\t\t!\u0001\u0003kCZ\f\u0017bAA\u0003{\n1qJ\u00196fGR\u0004B!!\u0003\u0002\u00185\u0011\u00111\u0002\u0006\u0004m\u00065!b\u0001=\u0002\u0010)!\u0011\u0011CA\n\u0003\u0019\t\u0007/Y2iK*\u0011\u0011QC\u0001\u0004_J<\u0017\u0002BA\r\u0003\u0017\u0011QBU3qY&\u001c\u0017\r^3e\u0019><\u0007\u0003BA\u000f\u0003Gi!!a\b\u000b\u0007\u0005\u0005r/A\u0003vi&d7/\u0003\u0003\u0002&\u0005}!a\u0002'pO\u001eLgnZ\u0001\u0004Y><WCAA\u0016!\u0011\ti#!\r\u000e\u0005\u0005=\"bAA\u0014o&!\u00111GA\u0018\u0005))f.\u001b4jK\u0012dunZ\u0001\u0005Y><\u0007%\u0001\u0003uS6,\u0007\u0003BA\u001e\u0003\u0007j!!!\u0010\u000b\t\u0005\u0005\u0012q\b\u0006\u0005\u0003\u0003\ni!\u0001\u0004d_6lwN\\\u0005\u0005\u0003\u000b\niD\u0001\u0003US6,\u0017!C:dQ\u0016$W\u000f\\3s!\u0011\tY%!\u0016\u000e\u0005\u00055#\u0002BA(\u0003#\nA!\u001e;jY*!\u00111KA\u0007\u0003\u0019\u0019XM\u001d<fe&!\u0011qKA'\u0005%\u00196\r[3ek2,'/A\u0005t]\u0006\u00048\u000f[8ugBA\u0011QLA6\u0003_\n)(\u0004\u0002\u0002`)!\u0011\u0011MA2\u0003\u001diW\u000f^1cY\u0016TA!!\u001a\u0002h\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0005\u0005%\u0014!B:dC2\f\u0017\u0002BA7\u0003?\u0012q\u0001\u0016:fK6\u000b\u0007\u000f\u0005\u0003\u0002\n\u0005E\u0014\u0002BA:\u0003\u0017\u0011ab\u00144gg\u0016$\u0018I\u001c3Fa>\u001c\u0007\u000e\u0005\u0004\u0002x\u0005e\u0014QP\u0007\u0003\u0003OJA!a\u001f\u0002h\t1q\n\u001d;j_:\u0004B!a \u0002\u00066\u0011\u0011\u0011\u0011\u0006\u0005\u0003\u0007\u000bi!\u0001\u0005t]\u0006\u00048\u000f[8u\u0013\u0011\t9)!!\u0003+\u0019KG.\u001a*boNs\u0017\r]:i_R\u0014V-\u00193fe\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0003BAG\u0003\u001fk!!a\u0010\n\t\u0005E\u0015q\b\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003\u0019\u0019wN\u001c4jOB!\u0011qSAM\u001b\u0005)\u0018bAANk\n\tR*\u001a;bI\u0006$\u0018\rT8h\u0007>tg-[4\u0002\rqJg.\u001b;?)9\t\t+a)\u0002&\u0006\u001d\u0016\u0011VAV\u0003[\u00032!a&\u0001\u0011\u001d\t9\u0003\u0003a\u0001\u0003WAq!a\u000e\t\u0001\u0004\tI\u0004C\u0004\u0002H!\u0001\r!!\u0013\t\u000f\u0005e\u0003\u00021\u0001\u0002\\!9\u0011\u0011\u0012\u0005A\u0002\u0005-\u0005bBAJ\u0011\u0001\u0007\u0011QS\u0001\u0005e\u0016\fG\r\u0006\u0004\u00024\u0006e\u00161\u0019\t\u0005\u0003\u0013\t),\u0003\u0003\u00028\u0006-!\u0001\u0004'pO\u001a+Go\u00195J]\u001a|\u0007bBA^\u0013\u0001\u0007\u0011QX\u0001\fgR\f'\u000f^(gMN,G\u000f\u0005\u0003\u0002x\u0005}\u0016\u0002BAa\u0003O\u0012A\u0001T8oO\"9\u0011QY\u0005A\u0002\u0005\u001d\u0017!\u0004:fC\u0012L5o\u001c7bi&|g\u000e\u0005\u0003\u0002\n\u0005%\u0017\u0002BAf\u0003\u0017\u0011\u0011\"S:pY\u0006$\u0018n\u001c8\u0002\u001d\u0005\u0004\b/\u001a8e\u0003NdU-\u00193feR1\u0011\u0011[Al\u0003O\u0004B!!\u0003\u0002T&!\u0011Q[A\u0006\u00055aunZ!qa\u0016tG-\u00138g_\"9\u0011\u0011\u001c\u0006A\u0002\u0005m\u0017a\u0002:fG>\u0014Hm\u001d\t\u0005\u0003;\f\u0019/\u0004\u0002\u0002`*!\u0011\u0011]A \u0003\u0019\u0011XmY8sI&!\u0011Q]Ap\u0005\u001d\u0011VmY8sINDq!!;\u000b\u0001\u0004\tY/A\u0003fa>\u001c\u0007\u000e\u0005\u0003\u0002x\u00055\u0018\u0002BAx\u0003O\u00121!\u00138u\u0003A\t\u0007\u000f]3oI\u0006\u001bhi\u001c7m_^,'\u000f\u0006\u0003\u0002R\u0006U\bbBAm\u0017\u0001\u0007\u00111\\\u0001\u001eQ\u0006tG\r\\3B]\u0012\u001cuN\u001c<feRdunZ!qa\u0016tG-\u00138g_R!\u0011\u0011[A~\u0011\u001d\ti\u0010\u0004a\u0001\u0003\u007f\f!\"\u00199qK:$\u0017J\u001c4p!\u0011\u0011\tA!\u0004\u000e\u0005\t\r!\u0002BA\u0014\u0005\u000bQAAa\u0002\u0003\n\u0005I\u0011N\u001c;fe:\fGn\u001d\u0006\u0005\u0005\u0017\ti!A\u0004ti>\u0014\u0018mZ3\n\t\u0005U'1A\u0001\u0011Y\u0006\u001cHOR3uG\",G-\u00129pG\"$\"!a;\u0002#\u0015tGm\u00144gg\u0016$hi\u001c:Fa>\u001c\u0007\u000e\u0006\u0003\u0002p\t]\u0001bBAu\u001d\u0001\u0007\u00111^\u0001\nK:$wJ\u001a4tKR$\"A!\b\u0011\t\u0005%!qD\u0005\u0005\u0005C\tYAA\tM_\u001e|eMZ:fi6+G/\u00193bi\u0006$\"!!0\u0002\u0015Q\u0014XO\\2bi\u0016$v\u000e\u0006\u0003\u0003*\t=\u0002\u0003BA<\u0005WIAA!\f\u0002h\t!QK\\5u\u0011\u001d\u0011\t$\u0005a\u0001\u0003{\u000baa\u001c4gg\u0016$\u0018\u0001\u0007;sk:\u001c\u0017\r^3U_2\u000bG/Z:u':\f\u0007o\u001d5piR\u0011!q\u0007\t\u0005\u0003o\u0012I$\u0003\u0003\u0003<\u0005\u001d$a\u0002\"p_2,\u0017M\\\u0001\u0016S:LG/[1mSj,G*Z1eKJ,\u0005o\\2i)\u0011\u0011IC!\u0011\t\u000f\u0005%8\u00031\u0001\u0002l\u0006\u0019R\u000f\u001d3bi\u0016D\u0015n\u001a5XCR,'/\\1sWR!!\u0011\u0006B$\u0011\u001d\u0011I\u0005\u0006a\u0001\u0005;\tab\u001c4gg\u0016$X*\u001a;bI\u0006$\u0018-A\u0007iS\u001eDw+\u0019;fe6\f'o[\u0001\u0006M2,8\u000f\u001b\u000b\u0005\u0005S\u0011\t\u0006C\u0004\u0003TY\u0001\rAa\u000e\u0002/\u0019|'oY3GYV\u001c\b.Q2uSZ,7+Z4nK:$HCAAF\u0003\u001d!x\u000e]5d\u0013\u0012$\"Aa\u0017\u0011\t\u00055%QL\u0005\u0005\u0005?\nyD\u0001\u0003Vk&$\u0017!E2sK\u0006$XMT3x':\f\u0007o\u001d5piR!!Q\rB;!\u0019\u00119Ga\u001b\u0003p5\u0011!\u0011\u000e\u0006\u0004\u0003\u001fz\u0018\u0002\u0002B7\u0005S\u0012\u0001b\u00149uS>t\u0017\r\u001c\t\u0005\u0003\u007f\u0012\t(\u0003\u0003\u0003t\u0005\u0005%!\u0005*boNs\u0017\r]:i_R<&/\u001b;fe\"9!qO\rA\u0002\u0005=\u0014AC:oCB\u001c\bn\u001c;JI\u0006Q2M]3bi\u0016tUm^*oCB\u001c\bn\u001c;V]\u000eDWmY6fIR!!Q\rB?\u0011\u001d\u00119H\u0007a\u0001\u0003_\nAB]3bINs\u0017\r]:i_R$BAa!\u0003\fB1!q\rB6\u0005\u000b\u0003B!a \u0003\b&!!\u0011RAA\u0005E\u0011\u0016m^*oCB\u001c\bn\u001c;SK\u0006$WM\u001d\u0005\b\u0005oZ\u0002\u0019AA8\u00039a\u0017\r^3tiNs\u0017\r]:i_R$\"Aa!\u0002!1\fG/Z:u':\f\u0007o\u001d5pi&#GC\u0001BK!\u0019\u00119Ga\u001b\u0002p\u0005\u0011R-\u0019:mS\u0016\u001cHo\u00158baNDw\u000e^%e\u0003Aygn\u00158baNDw\u000e\u001e$s_j,g\u000e\u0006\u0003\u0003*\tu\u0005b\u0002B<?\u0001\u0007\u0011qN\u0001\u0015I\u0016dW\r^3CK\u001a|'/Z*oCB\u001c\bn\u001c;\u0015\t\t]\"1\u0015\u0005\b\u0005o\u0002\u0003\u0019AA8)\u0019\u00119Da*\u0003*\"9!qO\u0011A\u0002\u0005=\u0004b\u0002BVC\u0001\u0007!QV\u0001\u0007e\u0016\f7o\u001c8\u0011\u0007\t=&GD\u0002\u000322rAAa-\u0003>:!!Q\u0017B^\u001b\t\u00119LC\u0002\u0003:f\fa\u0001\u0010:p_Rt\u0014\"\u0001=\n\u0005Y<\u0018\u0001E&bM.\fW*\u001a;bI\u0006$\u0018\rT8h!\r\t9*L\n\u0006[\t\u0015\u00171\u0004\t\u0005\u0003o\u00129-\u0003\u0003\u0003J\u0006\u001d$AB!osJ+g\r\u0006\u0002\u0003B\u0006)\u0011\r\u001d9msRq\u0011\u0011\u0015Bi\u0005'\u0014)N!:\u0003h\n%\bbBAE_\u0001\u0007\u00111\u0012\u0005\b\u0005/z\u0003\u0019\u0001B.\u0011\u001d\u00119n\fa\u0001\u00053\fq\u0001Z1uC\u0012K'\u000f\u0005\u0003\u0003\\\n\u0005XB\u0001Bo\u0015\r\u0011yn`\u0001\u0003S>LAAa9\u0003^\n!a)\u001b7f\u0011\u001d\t9d\fa\u0001\u0003sAq!a\u00120\u0001\u0004\tI\u0005C\u0004\u0002\u0014>\u0002\r!!&\u0002!I,7m\u001c<feNs\u0017\r]:i_R\u001cH\u0003BA.\u0005_Dq!a\n1\u0001\u0004\tY#A\neK2,G/Z*oCB\u001c\bn\u001c;GS2,7\u000f\u0006\u0005\u0003*\tU8\u0011BB\u0007\u0011\u001d\u001190\ra\u0001\u0005s\fa\u0001\\8h\t&\u0014\b\u0003\u0002B~\u0007\u000bi!A!@\u000b\t\t}8\u0011A\u0001\u0005M&dWMC\u0002\u0004\u0004}\f1A\\5p\u0013\u0011\u00199A!@\u0003\tA\u000bG\u000f\u001b\u0005\b\u0007\u0017\t\u0004\u0019AA.\u0003A)\u0007\u0010]5sK\u0012\u001cf.\u00199tQ>$8\u000fC\u0004\u0004\u0010E\u0002\r!a\u0007\u0002\u000f1|wmZ5oO\n12K\\1qg\"|G\u000fR3mKRLwN\u001c*fCN|gnE\u00023\u0005\u000b$Baa\u0006\u0004(A!1\u0011DB\u0011\u001d\u0011\u0019Yb!\b\u0011\t\tU\u0016qM\u0005\u0005\u0007?\t9'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0007G\u0019)C\u0001\u0004TiJLgn\u001a\u0006\u0005\u0007?\t9\u0007C\u0004\u0003xM\u0002\r!a\u001c*\u000bIjG\u0007U9\u0003\u001d\u0019+H\u000e\u001c+sk:\u001c\u0017\r^5p]N)QN!2\u00040A\u00191\u0011\u0007\u001a\u000e\u00035\"\"a!\u000e\u0011\u0007\rER\u000e\u0006\u0003\u0004\u0018\re\u0002b\u0002B<_\u0002\u0007\u0011q\u000e\u0002\u0012%\u0016$XM\u001c;j_:l5O\u0011:fC\u000eD7#\u0003\u001b\u0003F\u000e=2qHB#!\u0011\t9h!\u0011\n\t\r\r\u0013q\r\u0002\b!J|G-^2u!\u0011\t9ha\u0012\n\t\r%\u0013q\r\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0004]><XCAA_\u0003\u0011qwn\u001e\u0011\u0002\u0013QLW.Z:uC6\u0004\u0018A\u0003;j[\u0016\u001cH/Y7qA\u0005y!/\u001a;f]RLwN\\'jY2L7/\u0001\tsKR,g\u000e^5p]6KG\u000e\\5tAQA11LB/\u0007?\u001a\t\u0007E\u0002\u00042QBqaa\u0013<\u0001\u0004\ti\fC\u0004\u0004Rm\u0002\r!!0\t\u000f\rU3\b1\u0001\u0002>R!1qCB3\u0011\u001d\u00119\b\u0010a\u0001\u0003_\nAaY8qsRA11LB6\u0007[\u001ay\u0007C\u0005\u0004Lu\u0002\n\u00111\u0001\u0002>\"I1\u0011K\u001f\u0011\u0002\u0003\u0007\u0011Q\u0018\u0005\n\u0007+j\u0004\u0013!a\u0001\u0003{\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004v)\"\u0011QXB<W\t\u0019I\b\u0005\u0003\u0004|\r\u0015UBAB?\u0015\u0011\u0019yh!!\u0002\u0013Ut7\r[3dW\u0016$'\u0002BBB\u0003O\n!\"\u00198o_R\fG/[8o\u0013\u0011\u00199i! \u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"a!%\u0011\u0007q\u001c\u0019*C\u0002\u0004$u\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!1QTBR!\u0011\t9ha(\n\t\r\u0005\u0016q\r\u0002\u0004\u0003:L\b\"CBS\u0007\u0006\u0005\t\u0019AAv\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u001111\u0016\t\u0007\u0007[\u001byk!(\u000e\u0005\u0005\r\u0014\u0002BBY\u0003G\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!qGB\\\u0011%\u0019)+RA\u0001\u0002\u0004\u0019i*\u0001\u0005iCND7i\u001c3f\u0003!!xn\u0015;sS:<GCABI\u0003\u0019)\u0017/^1mgR!!qGBb\u0011%\u0019)\u000bSA\u0001\u0002\u0004\u0019iJA\nSKR,g\u000e^5p]NK'0\u001a\"sK\u0006\u001c\u0007nE\u0005Q\u0005\u000b\u001cyca\u0010\u0004F\u00059An\\4TSj,\u0017\u0001\u00037pONK'0\u001a\u0011\u0002\u001bMt\u0017\r]:i_R\u001c8+\u001b>f\u00039\u0019h.\u00199tQ>$8oU5{K\u0002\n\u0011C]3uK:$\u0018n\u001c8NCb\u0014\u0015\u0010^3t\u0003I\u0011X\r^3oi&|g.T1y\u0005f$Xm\u001d\u0011\u0015\u0011\r]7\u0011\\Bn\u0007;\u00042a!\rQ\u0011\u001d\u0019Im\u0016a\u0001\u0003{Cqa!4X\u0001\u0004\ti\fC\u0004\u0004R^\u0003\r!!0\u0015\t\r]1\u0011\u001d\u0005\b\u0005oB\u0006\u0019AA8)!\u00199n!:\u0004h\u000e%\b\"CBe3B\u0005\t\u0019AA_\u0011%\u0019i-\u0017I\u0001\u0002\u0004\ti\fC\u0005\u0004Rf\u0003\n\u00111\u0001\u0002>R!1QTBw\u0011%\u0019)kXA\u0001\u0002\u0004\tY\u000f\u0006\u0003\u00038\rE\b\"CBSC\u0006\u0005\t\u0019ABO)\u0011\u00119d!>\t\u0013\r\u0015F-!AA\u0002\ru%!D+oW:|wO\u001c*fCN|gnE\u0003r\u0005\u000b\u001cy\u0003\u0006\u0002\u0004~B\u00191\u0011G9\u0015\t\r]A\u0011\u0001\u0005\b\u0005o\u001a\b\u0019AA8\u0003E\u0011V\r^3oi&|g.T:Ce\u0016\f7\r\u001b\t\u0004\u0007cQ5#\u0002&\u0005\n\r\u0015\u0003\u0003\u0004C\u0006\t#\ti,!0\u0002>\u000emSB\u0001C\u0007\u0015\u0011!y!a\u001a\u0002\u000fI,h\u000e^5nK&!A1\u0003C\u0007\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\t\u000b!\u0002ba\u0017\u0005\u001a\u0011mAQ\u0004\u0005\b\u0007\u0017j\u0005\u0019AA_\u0011\u001d\u0019\t&\u0014a\u0001\u0003{Cqa!\u0016N\u0001\u0004\ti,A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0011\rB1\u0006\t\u0007\u0003o\nI\b\"\n\u0011\u0015\u0005]DqEA_\u0003{\u000bi,\u0003\u0003\u0005*\u0005\u001d$A\u0002+va2,7\u0007C\u0005\u0005.9\u000b\t\u00111\u0001\u0004\\\u0005\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0002w\u0006\u0019\"+\u001a;f]RLwN\\*ju\u0016\u0014%/Z1dQB\u00191\u0011\u00074\u0014\u000b\u0019$Id!\u0012\u0011\u0019\u0011-A\u0011CA_\u0003{\u000bila6\u0015\u0005\u0011UB\u0003CBl\t\u007f!\t\u0005b\u0011\t\u000f\r%\u0017\u000e1\u0001\u0002>\"91QZ5A\u0002\u0005u\u0006bBBiS\u0002\u0007\u0011Q\u0018\u000b\u0005\tG!9\u0005C\u0005\u0005.)\f\t\u00111\u0001\u0004X\u0006qa)\u001e7m)J,hnY1uS>t\u0017!D+oW:|wO\u001c*fCN|g.A\tm_\u0006$7K\\1qg\"|GoU5{KN$\"\u0001\"\u0015\u0011\r\u0011MCQ\fC2\u001d\u0011!)\u0006\"\u0017\u000f\t\tUFqK\u0005\u0003\u0003SJA\u0001b\u0017\u0002h\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002C0\tC\u00121aU3r\u0015\u0011!Y&a\u001a\u0011\u0011\u0005]DQMA8\u0003{KA\u0001b\u001a\u0002h\t1A+\u001e9mKJ\nQC]3bINs\u0017\r]:i_R$\u0016.\\3ti\u0006l\u0007\u000f\u0006\u0003\u0005n\u0011=\u0004CBA<\u0003s\ni\fC\u0004\u0003x\r\u0002\r!a\u001c\u0002\u00155\f\u0017PY3DY\u0016\fg.\u0001\bdY\u0016\fgn\u00158baNDw\u000e^:\u0015\t\t]Bq\u000f\u0005\b\ts*\u0003\u0019\u0001C>\u0003%\u0001(/\u001a3jG\u0006$X\r\u0005\u0005\u0002x\u0011u\u0014q\u000eCA\u0013\u0011!y(a\u001a\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CBA<\u0003s\u0012i+A\rdY\u0016\fgn\u00158baNDw\u000e^:SKR,g\u000e^5p]6\u001b\u0018aG2mK\u0006t7K\\1qg\"|Go\u001d*fi\u0016tG/[8o'&TX-A\u000bg_J<W\r^*oCB\u001c\bn\u001c;t\u0005\u00164wN]3\u0015\t\u0005mC1\u0012\u0005\b\t\u001bC\u0003\u0019AA8\u0003IawnZ*uCJ$8K\\1qg\"|G/\u00133\u0002\u001fI,Wn\u001c<f':\f\u0007o\u001d5piN$bA!\u000b\u0005\u0014\u0012U\u0005bBB\u0006S\u0001\u0007\u00111\f\u0005\b\u0005WK\u0003\u0019\u0001BW\u0003\u0015\u0019Gn\\:f)\t\u0011I#A\u0007t]\u0006\u00048\u000f[8u\u0007>,h\u000e\u001e")
public final class KafkaMetadataLog
implements ReplicatedLog,
Logging {
    private final UnifiedLog log;
    private final Time time;
    private final Scheduler scheduler;
    private final TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> snapshots;
    private final TopicPartition topicPartition;
    private final MetadataLogConfig config;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static KafkaMetadataLog apply(TopicPartition topicPartition, Uuid uuid, File file, Time time, Scheduler scheduler, MetadataLogConfig metadataLogConfig) {
        return KafkaMetadataLog$.MODULE$.apply(topicPartition, uuid, file, time, scheduler, metadataLogConfig);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public ValidOffsetAndEpoch validateOffsetAndEpoch(long x$1, int x$2) {
        return super.validateOffsetAndEpoch(x$1, x$2);
    }

    public long truncateToEndOffset(OffsetAndEpoch x$1) {
        return super.truncateToEndOffset(x$1);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public UnifiedLog log() {
        return this.log;
    }

    public LogFetchInfo read(long startOffset, Isolation readIsolation) {
        FetchIsolation fetchIsolation;
        if (Isolation.COMMITTED.equals(readIsolation)) {
            fetchIsolation = FetchIsolation.HIGH_WATERMARK;
        } else if (Isolation.UNCOMMITTED.equals(readIsolation)) {
            fetchIsolation = FetchIsolation.LOG_END;
        } else {
            throw new IllegalArgumentException(new StringBuilder(25).append("Unhandled read isolation ").append(readIsolation).toString());
        }
        FetchIsolation isolation = fetchIsolation;
        FetchDataInfo fetchInfo = this.log().read(startOffset, this.config.maxFetchSizeInBytes(), isolation, true);
        return new LogFetchInfo(fetchInfo.records, new LogOffsetMetadata(fetchInfo.fetchOffsetMetadata.messageOffset, Optional.of(new SegmentPosition(fetchInfo.fetchOffsetMetadata.segmentBaseOffset, fetchInfo.fetchOffsetMetadata.relativePositionInSegment))));
    }

    public org.apache.kafka.raft.LogAppendInfo appendAsLeader(Records records, int epoch) {
        if (records.sizeInBytes() == 0) {
            throw new IllegalArgumentException("Attempt to append an empty record set");
        }
        MemoryRecords x$1 = (MemoryRecords)records;
        AppendOrigin x$3 = AppendOrigin.RAFT_LEADER;
        RequestLocal x$4 = RequestLocal$.MODULE$.NoCaching();
        MetadataVersion x$5 = this.log().appendAsLeader$default$4();
        VerificationGuard x$6 = this.log().appendAsLeader$default$6();
        return this.handleAndConvertLogAppendInfo(this.log().appendAsLeader(x$1, epoch, x$3, x$5, x$4, x$6));
    }

    public org.apache.kafka.raft.LogAppendInfo appendAsFollower(Records records) {
        if (records.sizeInBytes() == 0) {
            throw new IllegalArgumentException("Attempt to append an empty record set");
        }
        return this.handleAndConvertLogAppendInfo(this.log().appendAsFollower((MemoryRecords)records));
    }

    private org.apache.kafka.raft.LogAppendInfo handleAndConvertLogAppendInfo(LogAppendInfo appendInfo) {
        if (appendInfo.firstOffset() != UnifiedLog$.MODULE$.UnknownOffset()) {
            return new org.apache.kafka.raft.LogAppendInfo(appendInfo.firstOffset(), appendInfo.lastOffset());
        }
        throw new KafkaException("Append failed unexpectedly");
    }

    public int lastFetchedEpoch() {
        return BoxesRunTime.unboxToInt((Object)this.log().latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)this.latestSnapshotId().map(snapshotId -> BoxesRunTime.boxToInteger((int)KafkaMetadataLog.$anonfun$lastFetchedEpoch$2(this, snapshotId))).orElse(BoxesRunTime.boxToInteger((int)0)))));
    }

    public OffsetAndEpoch endOffsetForEpoch(int epoch) {
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.earliestSnapshotId()));
        Option<org.apache.kafka.server.common.OffsetAndEpoch> option2 = this.log().endOffsetForEpoch(epoch);
        Tuple2 tuple2 = new Tuple2(option2, (Object)option);
        if (option2 instanceof Some) {
            org.apache.kafka.server.common.OffsetAndEpoch offsetAndEpoch = (org.apache.kafka.server.common.OffsetAndEpoch)((Some)option2).value();
            if (option instanceof Some) {
                OffsetAndEpoch snapshotId = (OffsetAndEpoch)((Some)option).value();
                if (offsetAndEpoch.offset() == snapshotId.offset() && offsetAndEpoch.leaderEpoch() == epoch) {
                    return new OffsetAndEpoch(snapshotId.offset(), snapshotId.epoch());
                }
            }
        }
        if (option2 instanceof Some) {
            org.apache.kafka.server.common.OffsetAndEpoch offsetAndEpoch = (org.apache.kafka.server.common.OffsetAndEpoch)((Some)option2).value();
            return new OffsetAndEpoch(offsetAndEpoch.offset(), offsetAndEpoch.leaderEpoch());
        }
        if (None$.MODULE$.equals(option2)) {
            return new OffsetAndEpoch(this.endOffset().offset(), this.lastFetchedEpoch());
        }
        throw new MatchError((Object)tuple2);
    }

    public LogOffsetMetadata endOffset() {
        org.apache.kafka.storage.internals.log.LogOffsetMetadata endOffsetMetadata = this.log().logEndOffsetMetadata();
        return new LogOffsetMetadata(endOffsetMetadata.messageOffset, Optional.of(new SegmentPosition(endOffsetMetadata.segmentBaseOffset, endOffsetMetadata.relativePositionInSegment)));
    }

    public long startOffset() {
        return this.log().logStartOffset();
    }

    public void truncateTo(long offset) {
        if (offset < this.highWatermark().offset()) {
            throw new IllegalArgumentException(new StringBuilder(74).append("Attempt to truncate to offset ").append(offset).append(", which is below ").append("the current high watermark ").append(this.highWatermark().offset()).toString());
        }
        this.log().truncateTo(offset);
    }

    /*
     * WARNING - void declaration
     */
    public boolean truncateToLatestSnapshot() {
        void var5_8;
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap;
        boolean bl;
        OffsetAndEpoch snapshotId;
        int latestEpoch = BoxesRunTime.unboxToInt((Object)this.log().latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.latestSnapshotId()));
        if (option instanceof Some && ((snapshotId = (OffsetAndEpoch)((Some)option).value()).epoch() > latestEpoch || snapshotId.epoch() == latestEpoch && snapshotId.offset() > this.endOffset().offset())) {
            this.log().truncateFullyAndStartAt(snapshotId.offset(), this.log().truncateFullyAndStartAt$default$2());
            TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap2 = this.snapshots;
            synchronized (treeMap2) {
                TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap3 = this.forgetSnapshotsBefore(snapshotId);
                boolean bl2 = true;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl10 : MonitorExitStatement: MONITOREXIT : var4_4
                bl = bl2;
                treeMap = treeMap3;
            }
        } else {
            bl = false;
            treeMap = TreeMap$.MODULE$.empty(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        }
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap4 = treeMap;
        boolean truncated = bl;
        this.removeSnapshots(treeMap4, KafkaMetadataLog$FullTruncation$.MODULE$);
        return (boolean)var5_8;
    }

    public void initializeLeaderEpoch(int epoch) {
        this.log().maybeAssignEpochStartOffset(epoch, this.log().logEndOffset());
    }

    public void updateHighWatermark(LogOffsetMetadata offsetMetadata) {
        long logHighWatermark;
        long l;
        OffsetMetadata segmentPosition;
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(offsetMetadata.metadata()));
        if (option instanceof Some && (segmentPosition = (OffsetMetadata)((Some)option).value()) instanceof SegmentPosition) {
            SegmentPosition segmentPosition2 = (SegmentPosition)segmentPosition;
            l = this.log().updateHighWatermark(new org.apache.kafka.storage.internals.log.LogOffsetMetadata(offsetMetadata.offset(), segmentPosition2.baseOffset(), segmentPosition2.relativePosition()));
        } else {
            l = logHighWatermark = this.log().updateHighWatermark(offsetMetadata.offset());
        }
        if (logHighWatermark != offsetMetadata.offset()) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(this.msgWithLogIdent(KafkaMetadataLog.$anonfun$updateHighWatermark$1(logHighWatermark, offsetMetadata)));
                return;
            }
            return;
        }
    }

    public LogOffsetMetadata highWatermark() {
        org.apache.kafka.storage.internals.log.LogOffsetMetadata hwm = this.log().fetchOffsetSnapshot().highWatermark;
        Optional segmentPosition = !hwm.messageOffsetOnly() ? Optional.of(new SegmentPosition(hwm.segmentBaseOffset, hwm.relativePositionInSegment)) : Optional.empty();
        return new LogOffsetMetadata(hwm.messageOffset, segmentPosition);
    }

    public void flush(boolean forceFlushActiveSegment) {
        this.log().flush(forceFlushActiveSegment);
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Uuid topicId() {
        return (Uuid)this.log().topicId().get();
    }

    public Optional<RawSnapshotWriter> createNewSnapshot(OffsetAndEpoch snapshotId) {
        if (snapshotId.offset() < this.startOffset()) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(this.msgWithLogIdent(KafkaMetadataLog.$anonfun$createNewSnapshot$1(this, snapshotId)));
            }
            return Optional.empty();
        }
        long highWatermarkOffset = this.highWatermark().offset();
        if (snapshotId.offset() > highWatermarkOffset) {
            throw new IllegalArgumentException(new StringBuilder(73).append("Cannot create a snapshot with an id (").append(snapshotId).append(") greater than the high-watermark (").append(highWatermarkOffset).append(")").toString());
        }
        ValidOffsetAndEpoch validOffsetAndEpoch = this.validateOffsetAndEpoch(snapshotId.offset(), snapshotId.epoch());
        ValidOffsetAndEpoch.Kind kind = validOffsetAndEpoch.kind();
        ValidOffsetAndEpoch.Kind kind2 = ValidOffsetAndEpoch.Kind.VALID;
        if (kind == null ? kind2 != null : !kind.equals(kind2)) {
            throw new IllegalArgumentException(new StringBuilder(50).append("Snapshot id (").append(snapshotId).append(") is not valid according to the log: ").append(validOffsetAndEpoch).toString());
        }
        return this.createNewSnapshotUnchecked(snapshotId);
    }

    public Optional<RawSnapshotWriter> createNewSnapshotUnchecked(OffsetAndEpoch snapshotId2) {
        boolean bl;
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            bl = this.snapshots.contains((Object)snapshotId2);
        }
        if (bl) {
            return Optional.empty();
        }
        return Optional.of(new NotifyingRawSnapshotWriter((RawSnapshotWriter)FileRawSnapshotWriter.create((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId2), snapshotId -> this.onSnapshotFrozen((OffsetAndEpoch)snapshotId)));
    }

    /*
     * Unable to fully structure code
     */
    public Optional<RawSnapshotReader> readSnapshot(OffsetAndEpoch snapshotId) {
        var2_2 = this.snapshots;
        synchronized (var2_2) {
            block8: {
                block7: {
                    var5_3 = false;
                    var6_4 = null;
                    var7_5 = this.snapshots.get((Object)snapshotId);
                    if (!None$.MODULE$.equals(var7_5)) break block7;
                    v0 = None$.MODULE$;
                    break block8;
                }
                if (!(var7_5 instanceof Some)) ** GOTO lbl-1000
                var5_3 = true;
                var6_4 = (Some)var7_5;
                var8_6 = (Option)var6_4.value();
                if (None$.MODULE$.equals(var8_6)) {
                    v0 = this.liftedTree1$1(snapshotId);
                } else if (var5_3) {
                    v0 = (Option)var6_4.value();
                } else {
                    throw new MatchError((Object)var7_5);
                }
            }
            reader = v0;
            var3_8 = OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8((Option)reader));
            return var3_8;
        }
    }

    public Optional<RawSnapshotReader> latestSnapshot() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            Optional<RawSnapshotReader> optional = this.latestSnapshotId().flatMap(snapshotId -> this.readSnapshot((OffsetAndEpoch)snapshotId));
            return optional;
        }
    }

    public Optional<OffsetAndEpoch> latestSnapshotId() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            Optional optional = OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.snapshots.lastOption().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 != null) {
                    return (OffsetAndEpoch)x0$1._1();
                }
                throw new MatchError(null);
            })));
            return optional;
        }
    }

    public Optional<OffsetAndEpoch> earliestSnapshotId() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            Optional optional = OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.snapshots.headOption().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 != null) {
                    return (OffsetAndEpoch)x0$1._1();
                }
                throw new MatchError(null);
            })));
            return optional;
        }
    }

    public void onSnapshotFrozen(OffsetAndEpoch snapshotId) {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            this.snapshots.put((Object)snapshotId, (Object)None$.MODULE$);
            return;
        }
    }

    public boolean deleteBeforeSnapshot(OffsetAndEpoch snapshotId) {
        return this.deleteBeforeSnapshot(snapshotId, KafkaMetadataLog$UnknownReason$.MODULE$);
    }

    /*
     * Unable to fully structure code
     */
    private boolean deleteBeforeSnapshot(OffsetAndEpoch snapshotId, SnapshotDeletionReason reason) {
        var3_3 = this.snapshots;
        synchronized (var3_3) {
            var4_4 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.latestSnapshotId()));
            if (!(var4_4 instanceof Some)) ** GOTO lbl-1000
            latestSnapshotId = (OffsetAndEpoch)((Some)var4_4).value();
            if (this.snapshots.contains((Object)snapshotId) && this.startOffset() < snapshotId.offset() && snapshotId.offset() <= latestSnapshotId.offset() && this.log().maybeIncrementLogStartOffset(snapshotId.offset(), LogStartOffsetIncrementReason.SnapshotGenerated)) {
                deletedSegments = this.log().deleteOldSegments();
                forgottenSnapshots = this.forgetSnapshotsBefore(snapshotId);
                v0 = deletedSegments != 0 || forgottenSnapshots.nonEmpty() != false;
                v1 = forgottenSnapshots;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
                v1 = TreeMap$.MODULE$.empty(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
            }
            var9_8 = v1;
            var8_9 = v0;
        }
        this.removeSnapshots(var9_8, reason);
        return var8_9;
    }

    private Seq<Tuple2<OffsetAndEpoch, Object>> loadSnapshotSizes() {
        return (Seq)this.snapshots.keys().toSeq().flatMap((Function1 & Serializable & scala.Serializable)snapshotId -> Option$.MODULE$.option2Iterable(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.readSnapshot((OffsetAndEpoch)snapshotId))).map((Function1 & Serializable & scala.Serializable)reader -> new Tuple2(snapshotId, (Object)BoxesRunTime.boxToLong((long)reader.sizeInBytes())))), Seq$.MODULE$.canBuildFrom());
    }

    private Option<Object> readSnapshotTimestamp(OffsetAndEpoch snapshotId) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.readSnapshot(snapshotId))).map((Function1 & Serializable & scala.Serializable)reader -> BoxesRunTime.boxToLong((long)KafkaMetadataLog.$anonfun$readSnapshotTimestamp$1(reader)));
    }

    public boolean maybeClean() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            boolean didClean = false;
            boolean bl = (didClean |= this.cleanSnapshotsRetentionSize()) | this.cleanSnapshotsRetentionMs();
            return bl;
        }
    }

    private boolean cleanSnapshots(Function1<OffsetAndEpoch, Option<SnapshotDeletionReason>> predicate) {
        Object object = new Object();
        try {
            if (this.snapshots.size() < 2) {
                return false;
            }
            BooleanRef didClean = BooleanRef.create((boolean)false);
            this.snapshots.keys().toSeq().sliding(2).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Some some = Seq$.MODULE$.unapplySeq(x0$1);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    OffsetAndEpoch snapshot = (OffsetAndEpoch)((SeqLike)some.get()).apply(0);
                    OffsetAndEpoch nextSnapshot = (OffsetAndEpoch)((SeqLike)some.get()).apply(1);
                    if (snapshot != null && nextSnapshot != null) {
                        Option option = (Option)predicate.apply((Object)snapshot);
                        if (option instanceof Some) {
                            SnapshotDeletionReason reason = (SnapshotDeletionReason)((Some)option).value();
                            if (!this.deleteBeforeSnapshot(nextSnapshot, reason)) {
                                throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                            }
                        } else {
                            if (None$.MODULE$.equals(option)) {
                                throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                            }
                            throw new MatchError((Object)option);
                        }
                        didClean$1.elem = true;
                        return BoxedUnit.UNIT;
                    }
                }
                return BoxesRunTime.boxToBoolean((boolean)false);
            });
            return didClean.elem;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    private boolean cleanSnapshotsRetentionMs() {
        boolean bl;
        if (this.config.retentionMillis() < 0L) {
            return false;
        }
        Function1 & Serializable & scala.Serializable cleanSnapshots_predicate = (Function1 & Serializable & scala.Serializable)snapshotId -> this.shouldClean$1((OffsetAndEpoch)snapshotId);
        Object object = new Object();
        try {
            if (this.snapshots.size() >= 2) {
                BooleanRef cleanSnapshots_didClean = BooleanRef.create((boolean)false);
                this.snapshots.keys().toSeq().sliding(2).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Some some = Seq$.MODULE$.unapplySeq(x0$1);
                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                        OffsetAndEpoch snapshot = (OffsetAndEpoch)((SeqLike)some.get()).apply(0);
                        OffsetAndEpoch nextSnapshot = (OffsetAndEpoch)((SeqLike)some.get()).apply(1);
                        if (snapshot != null && nextSnapshot != null) {
                            Option option = (Option)predicate.apply((Object)snapshot);
                            if (option instanceof Some) {
                                SnapshotDeletionReason reason = (SnapshotDeletionReason)((Some)option).value();
                                if (!this.deleteBeforeSnapshot(nextSnapshot, reason)) {
                                    throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                                }
                            } else {
                                if (None$.MODULE$.equals(option)) {
                                    throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                                }
                                throw new MatchError((Object)option);
                            }
                            didClean$1.elem = true;
                            return BoxedUnit.UNIT;
                        }
                    }
                    return BoxesRunTime.boxToBoolean((boolean)false);
                });
                return cleanSnapshots_didClean.elem;
            }
            bl = false;
        }
        catch (NonLocalReturnControl cleanSnapshots_ex) {
            if (cleanSnapshots_ex.key() == object) {
                return cleanSnapshots_ex.value$mcZ$sp();
            }
            throw cleanSnapshots_ex;
        }
        return bl;
    }

    private boolean cleanSnapshotsRetentionSize() {
        boolean bl;
        if (this.config.retentionMaxBytes() < 0L) {
            return false;
        }
        Map snapshotSizes = this.loadSnapshotSizes().toMap(Predef$.MODULE$.$conforms());
        LongRef snapshotTotalSize = LongRef.create((long)BoxesRunTime.unboxToLong((Object)snapshotSizes.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        Function1 & Serializable & scala.Serializable cleanSnapshots_predicate = (Function1 & Serializable & scala.Serializable)snapshotId -> this.shouldClean$2((OffsetAndEpoch)snapshotId, snapshotSizes, snapshotTotalSize);
        Object object = new Object();
        try {
            if (this.snapshots.size() >= 2) {
                BooleanRef cleanSnapshots_didClean = BooleanRef.create((boolean)false);
                this.snapshots.keys().toSeq().sliding(2).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Some some = Seq$.MODULE$.unapplySeq(x0$1);
                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                        OffsetAndEpoch snapshot = (OffsetAndEpoch)((SeqLike)some.get()).apply(0);
                        OffsetAndEpoch nextSnapshot = (OffsetAndEpoch)((SeqLike)some.get()).apply(1);
                        if (snapshot != null && nextSnapshot != null) {
                            Option option = (Option)predicate.apply((Object)snapshot);
                            if (option instanceof Some) {
                                SnapshotDeletionReason reason = (SnapshotDeletionReason)((Some)option).value();
                                if (!this.deleteBeforeSnapshot(nextSnapshot, reason)) {
                                    throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                                }
                            } else {
                                if (None$.MODULE$.equals(option)) {
                                    throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                                }
                                throw new MatchError((Object)option);
                            }
                            didClean$1.elem = true;
                            return BoxedUnit.UNIT;
                        }
                    }
                    return BoxesRunTime.boxToBoolean((boolean)false);
                });
                return cleanSnapshots_didClean.elem;
            }
            bl = false;
        }
        catch (NonLocalReturnControl cleanSnapshots_ex) {
            if (cleanSnapshots_ex.key() == object) {
                return cleanSnapshots_ex.value$mcZ$sp();
            }
            throw cleanSnapshots_ex;
        }
        return bl;
    }

    private TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> forgetSnapshotsBefore(OffsetAndEpoch logStartSnapshotId) {
        TreeMap expiredSnapshots = (TreeMap)((MapLike)this.snapshots.until((Object)logStartSnapshotId)).clone();
        this.snapshots.$minus$minus$eq((TraversableOnce)expiredSnapshots.keys());
        return expiredSnapshots;
    }

    private void removeSnapshots(TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> expiredSnapshots, SnapshotDeletionReason reason) {
        expiredSnapshots.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                OffsetAndEpoch snapshotId = (OffsetAndEpoch)x0$1._1();
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(this.msgWithLogIdent(reason.reason(snapshotId)));
                }
                return Snapshots.markForDelete((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId);
            }
            throw new MatchError(null);
        });
        if (expiredSnapshots.nonEmpty()) {
            this.scheduler.scheduleOnce("delete-snapshot-files", () -> KafkaMetadataLog$.MODULE$.kafka$raft$KafkaMetadataLog$$deleteSnapshotFiles(this.log().dir().toPath(), expiredSnapshots, this), this.config.fileDeleteDelayMs());
            return;
        }
    }

    public void close() {
        this.log().close();
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            ((IterableLike)this.snapshots.values().flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                x$3.close();
                return BoxedUnit.UNIT;
            });
            this.snapshots.clear();
            return;
        }
    }

    public int snapshotCount() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            int n = this.snapshots.size();
            return n;
        }
    }

    public static final /* synthetic */ int $anonfun$lastFetchedEpoch$2(KafkaMetadataLog $this, OffsetAndEpoch snapshotId) {
        long logEndOffset = $this.endOffset().offset();
        if (snapshotId.offset() == $this.startOffset() && snapshotId.offset() == logEndOffset) {
            return snapshotId.epoch();
        }
        throw new KafkaException(new StringBuilder(159).append("Log doesn't have a last fetch epoch and there is a snapshot (").append(snapshotId).append("). ").append("Expected the snapshot's end offset to match the log's end offset (").append(logEndOffset).append(") ").append("and the log start offset (").append($this.startOffset()).append(")").toString());
    }

    public static final /* synthetic */ String $anonfun$updateHighWatermark$1(long logHighWatermark$1, LogOffsetMetadata offsetMetadata$1) {
        return new StringBuilder(79).append("Log's high watermark (").append(logHighWatermark$1).append(") is different from the local replica's high watermark (").append(offsetMetadata$1).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$createNewSnapshot$1(KafkaMetadataLog $this, OffsetAndEpoch snapshotId$1) {
        return new StringBuilder(72).append("Cannot create a snapshot with an id (").append(snapshotId$1).append(") less than the log start offset (").append($this.startOffset()).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$readSnapshot$1(OffsetAndEpoch snapshotId$2, Path path$1) {
        return new StringBuilder(47).append("Couldn't read ").append(snapshotId$2).append("; expected to find snapshot file ").append(path$1).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final /* synthetic */ Option liftedTree1$1(OffsetAndEpoch snapshotId$2) {
        try {
            void var2_2;
            Some snapshotReader = new Some((Object)FileRawSnapshotReader.open((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId$2));
            this.snapshots.put((Object)snapshotId$2, (Object)snapshotReader);
            return var2_2;
        }
        catch (NoSuchFileException noSuchFileException) {
            Path path = Snapshots.snapshotPath((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId$2);
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(this.msgWithLogIdent(KafkaMetadataLog.$anonfun$readSnapshot$1(snapshotId$2, path)));
            }
            this.snapshots.remove((Object)snapshotId$2);
            return None$.MODULE$;
        }
    }

    public static final /* synthetic */ long $anonfun$readSnapshotTimestamp$1(RawSnapshotReader reader) {
        return Snapshots.lastContainedLogTimestamp((RawSnapshotReader)reader);
    }

    public static final /* synthetic */ Option $anonfun$cleanSnapshotsRetentionMs$1(KafkaMetadataLog $this, long timestamp) {
        long now = $this.time.milliseconds();
        if (now - timestamp > $this.config.retentionMillis()) {
            return new Some((Object)new RetentionMsBreach(now, timestamp, $this.config.retentionMillis()));
        }
        return None$.MODULE$;
    }

    private final Option shouldClean$1(OffsetAndEpoch snapshotId) {
        return this.readSnapshotTimestamp(snapshotId).flatMap((Function1 & Serializable & scala.Serializable)timestamp -> KafkaMetadataLog.$anonfun$cleanSnapshotsRetentionMs$1(this, BoxesRunTime.unboxToLong((Object)timestamp)));
    }

    public static final /* synthetic */ Option $anonfun$cleanSnapshotsRetentionSize$1(KafkaMetadataLog $this, LongRef snapshotTotalSize$1, long snapshotSize) {
        if ($this.log().size() + snapshotTotalSize$1.elem > $this.config.retentionMaxBytes()) {
            long oldSnapshotTotalSize = snapshotTotalSize$1.elem;
            snapshotTotalSize$1.elem -= snapshotSize;
            return new Some((Object)new RetentionSizeBreach($this.log().size(), oldSnapshotTotalSize, $this.config.retentionMaxBytes()));
        }
        return None$.MODULE$;
    }

    private final Option shouldClean$2(OffsetAndEpoch snapshotId, Map snapshotSizes$1, LongRef snapshotTotalSize$1) {
        return snapshotSizes$1.get((Object)snapshotId).flatMap((Function1 & Serializable & scala.Serializable)snapshotSize -> KafkaMetadataLog.$anonfun$cleanSnapshotsRetentionSize$1(this, snapshotTotalSize$1, BoxesRunTime.unboxToLong((Object)snapshotSize)));
    }

    public KafkaMetadataLog(UnifiedLog log, Time time, Scheduler scheduler, TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> snapshots, TopicPartition topicPartition, MetadataLogConfig config) {
        this.log = log;
        this.time = time;
        this.scheduler = scheduler;
        this.snapshots = snapshots;
        this.topicPartition = topicPartition;
        this.config = config;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(34).append("[MetadataLog partition=").append(topicPartition).append(", nodeId=").append(config.nodeId()).append("] ").toString());
    }

    private static final class RetentionMsBreach
    implements SnapshotDeletionReason,
    Product,
    scala.Serializable {
        private final long now;
        private final long timestamp;
        private final long retentionMillis;

        public long now() {
            return this.now;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public long retentionMillis() {
            return this.retentionMillis;
        }

        @Override
        public String reason(OffsetAndEpoch snapshotId) {
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(104).append("Marking snapshot ").append(snapshotId).append(" for deletion because its timestamp (").append(this.timestamp()).append(") is now (").append(this.now()).append(") older than the\n          |retention (").append(this.retentionMillis()).append(")").toString())).stripMargin();
        }

        public RetentionMsBreach copy(long now, long timestamp, long retentionMillis) {
            return new RetentionMsBreach(now, timestamp, retentionMillis);
        }

        public long copy$default$1() {
            return this.now();
        }

        public long copy$default$2() {
            return this.timestamp();
        }

        public long copy$default$3() {
            return this.retentionMillis();
        }

        public String productPrefix() {
            return "RetentionMsBreach";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.now());
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.timestamp());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this.retentionMillis());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof RetentionMsBreach;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.longHash((long)this.now())), (int)Statics.longHash((long)this.timestamp())), (int)Statics.longHash((long)this.retentionMillis())), (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof RetentionMsBreach)) break block3;
                    RetentionMsBreach retentionMsBreach = (RetentionMsBreach)x$1;
                    if (this.now() != retentionMsBreach.now() || this.timestamp() != retentionMsBreach.timestamp() || this.retentionMillis() != retentionMsBreach.retentionMillis()) break block3;
                }
                return true;
            }
            return false;
        }

        public RetentionMsBreach(long now, long timestamp, long retentionMillis) {
            this.now = now;
            this.timestamp = timestamp;
            this.retentionMillis = retentionMillis;
            Product.$init$((Product)this);
        }
    }

    private static final class RetentionSizeBreach
    implements SnapshotDeletionReason,
    Product,
    scala.Serializable {
        private final long logSize;
        private final long snapshotsSize;
        private final long retentionMaxBytes;

        public long logSize() {
            return this.logSize;
        }

        public long snapshotsSize() {
            return this.snapshotsSize;
        }

        public long retentionMaxBytes() {
            return this.retentionMaxBytes;
        }

        @Override
        public String reason(OffsetAndEpoch snapshotId) {
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(104).append("Marking snapshot ").append(snapshotId).append(" for deletion because the log size (").append(this.logSize()).append(") and snapshots size (").append(this.snapshotsSize()).append(")\n          |is greater than ").append(this.retentionMaxBytes()).toString())).stripMargin();
        }

        public RetentionSizeBreach copy(long logSize, long snapshotsSize, long retentionMaxBytes) {
            return new RetentionSizeBreach(logSize, snapshotsSize, retentionMaxBytes);
        }

        public long copy$default$1() {
            return this.logSize();
        }

        public long copy$default$2() {
            return this.snapshotsSize();
        }

        public long copy$default$3() {
            return this.retentionMaxBytes();
        }

        public String productPrefix() {
            return "RetentionSizeBreach";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.logSize());
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.snapshotsSize());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this.retentionMaxBytes());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof RetentionSizeBreach;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.longHash((long)this.logSize())), (int)Statics.longHash((long)this.snapshotsSize())), (int)Statics.longHash((long)this.retentionMaxBytes())), (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof RetentionSizeBreach)) break block3;
                    RetentionSizeBreach retentionSizeBreach = (RetentionSizeBreach)x$1;
                    if (this.logSize() != retentionSizeBreach.logSize() || this.snapshotsSize() != retentionSizeBreach.snapshotsSize() || this.retentionMaxBytes() != retentionSizeBreach.retentionMaxBytes()) break block3;
                }
                return true;
            }
            return false;
        }

        public RetentionSizeBreach(long logSize, long snapshotsSize, long retentionMaxBytes) {
            this.logSize = logSize;
            this.snapshotsSize = snapshotsSize;
            this.retentionMaxBytes = retentionMaxBytes;
            Product.$init$((Product)this);
        }
    }

    private static interface SnapshotDeletionReason {
        public String reason(OffsetAndEpoch var1);
    }
}

