/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import kafka.api.KAFKA_0_10_0_IV1$;
import kafka.api.KAFKA_0_10_2_IV0$;
import kafka.api.KAFKA_0_9_0$;
import kafka.api.KAFKA_1_0_IV0$;
import kafka.api.KAFKA_2_2_IV0$;
import kafka.api.KAFKA_2_4_IV0$;
import kafka.api.KAFKA_2_4_IV1$;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.controller.ControllerContext;
import kafka.controller.ControllerEvent;
import kafka.controller.LeaderAndIsrResponseReceived;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaAssignment;
import kafka.controller.StateChangeLogger;
import kafka.controller.StopReplicaRequestInfo;
import kafka.controller.TopicDeletionStopReplicaResponseReceived;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.StopReplicaResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t-a!B\u000e\u001d\u0003\u0003\t\u0003\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0018\t\u0011U\u0002!\u0011!Q\u0001\nYB\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\u0006}\u0001!\ta\u0010\u0005\b\t\u0002\u0011\r\u0011\"\u0001F\u0011\u0019I\u0005\u0001)A\u0005\r\"9!\n\u0001b\u0001\n\u0003Y\u0005B\u0002<\u0001A\u0003%A\nC\u0004x\u0001\t\u0007I\u0011\u0001=\t\u000f\u0005\u0005\u0001\u0001)A\u0005s\"I\u00111\u0001\u0001C\u0002\u0013\u0005\u0011Q\u0001\u0005\t\u0003\u001b\u0001\u0001\u0015!\u0003\u0002\b!I\u0011q\u0002\u0001C\u0002\u0013\u0005\u0011\u0011\u0003\u0005\t\u0003G\u0001\u0001\u0015!\u0003\u0002\u0014!9\u0011Q\u0005\u0001\u0007\u0002\u0005\u001d\u0002bBA\u001d\u0001\u0019\u0005\u00111\b\u0005\n\u0003\u0003\u0003\u0011\u0013!C\u0001\u0003\u0007Cq!!'\u0001\t\u0003\tY\nC\u0004\u0002\u001e\u0002!\t!a'\t\u000f\u0005}\u0005\u0001\"\u0001\u0002\"\"9\u0011\u0011\u001b\u0001\u0005\u0002\u0005M\u0007bBAo\u0001\u0011\u0005\u0011q\u001c\u0005\b\u0003W\u0004A\u0011BAw\u0011\u001d\t9\u0010\u0001C\u0005\u0003sDq!a@\u0001\t\u0013\u0011\t\u0001C\u0004\u0003\u0006\u0001!\tAa\u0002\u0003I\u0005\u00137\u000f\u001e:bGR\u001cuN\u001c;s_2dWM\u001d\"s_.,'OU3rk\u0016\u001cHOQ1uG\"T!!\b\u0010\u0002\u0015\r|g\u000e\u001e:pY2,'OC\u0001 \u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0012)!\t\u0019c%D\u0001%\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0005\u0019\te.\u001f*fMB\u0011\u0011\u0006L\u0007\u0002U)\u00111FH\u0001\u0006kRLGn]\u0005\u0003[)\u0012q\u0001T8hO&tw-\u0001\u0004d_:4\u0017n\u001a\t\u0003aMj\u0011!\r\u0006\u0003ey\taa]3sm\u0016\u0014\u0018B\u0001\u001b2\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002#\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH\u000f\u0005\u00028q5\tA$\u0003\u0002:9\t\t2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0002#M$\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'\u000f\u0005\u00028y%\u0011Q\b\b\u0002\u0012'R\fG/Z\"iC:<W\rT8hO\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0003A\u0003\n\u001b\u0005CA\u001c\u0001\u0011\u0015qC\u00011\u00010\u0011\u0015)D\u00011\u00017\u0011\u0015QD\u00011\u0001<\u00031\u0019wN\u001c;s_2dWM]%e+\u00051\u0005CA\u0012H\u0013\tAEEA\u0002J]R\fQbY8oiJ|G\u000e\\3s\u0013\u0012\u0004\u0013A\u00067fC\u0012,'/\u00118e\u0013N\u0014(+Z9vKN$X*\u00199\u0016\u00031\u0003B!\u0014*G)6\taJ\u0003\u0002P!\u00069Q.\u001e;bE2,'BA)%\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003':\u00131!T1q!\u0011i%+\u00161\u0011\u0005YsV\"A,\u000b\u0005aK\u0016AB2p[6|gN\u0003\u0002 5*\u00111\fX\u0001\u0007CB\f7\r[3\u000b\u0003u\u000b1a\u001c:h\u0013\tyvK\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\u0005\u0005\u001chB\u00012q\u001d\t\u0019gN\u0004\u0002e[:\u0011Q\r\u001c\b\u0003M.t!a\u001a6\u000e\u0003!T!!\u001b\u0011\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0016BA.]\u0013\ty\",\u0003\u0002Y3&\u0011qnV\u0001\b[\u0016\u001c8/Y4f\u0013\t\t(/A\fMK\u0006$WM]!oI&\u001b(OU3rk\u0016\u001cH\u000fR1uC*\u0011qnV\u0005\u0003iV\u0014!\u0004T3bI\u0016\u0014\u0018I\u001c3JgJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016T!!\u001d:\u0002/1,\u0017\rZ3s\u0003:$\u0017j\u001d:SKF,Xm\u001d;NCB\u0004\u0013!F:u_B\u0014V\r\u001d7jG\u0006\u0014V-];fgRl\u0015\r]\u000b\u0002sB!QJ\u0015${!\ri50`\u0005\u0003y:\u0013!\u0002T5ti\n+hMZ3s!\t9d0\u0003\u0002\u00009\t12\u000b^8q%\u0016\u0004H.[2b%\u0016\fX/Z:u\u0013:4w.\u0001\fti>\u0004(+\u001a9mS\u000e\f'+Z9vKN$X*\u00199!\u0003y)\b\u000fZ1uK6+G/\u00193bi\u0006\u0014V-];fgR\u0014%o\\6feN+G/\u0006\u0002\u0002\bA!Q*!\u0003G\u0013\r\tYA\u0014\u0002\u0004'\u0016$\u0018aH;qI\u0006$X-T3uC\u0012\fG/\u0019*fcV,7\u000f\u001e\"s_.,'oU3uA\u0005)S\u000f\u001d3bi\u0016lU\r^1eCR\f'+Z9vKN$\b+\u0019:uSRLwN\\%oM>l\u0015\r]\u000b\u0003\u0003'\u0001R!\u0014*V\u0003+\u0001B!a\u0006\u0002\u001e9\u0019!-!\u0007\n\u0007\u0005m!/A\rVa\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;ECR\f\u0017\u0002BA\u0010\u0003C\u0011A$\u00169eCR,W*\u001a;bI\u0006$\u0018\rU1si&$\u0018n\u001c8Ti\u0006$XMC\u0002\u0002\u001cI\fa%\u001e9eCR,W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000fU1si&$\u0018n\u001c8J]\u001a|W*\u00199!\u0003%\u0019XM\u001c3Fm\u0016tG\u000f\u0006\u0003\u0002*\u0005=\u0002cA\u0012\u0002,%\u0019\u0011Q\u0006\u0013\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003cy\u0001\u0019AA\u001a\u0003\u0015)g/\u001a8u!\r9\u0014QG\u0005\u0004\u0003oa\"aD\"p]R\u0014x\u000e\u001c7fe\u00163XM\u001c;\u0002\u0017M,g\u000e\u001a*fcV,7\u000f\u001e\u000b\t\u0003S\ti$!\u0011\u0002r!1\u0011q\b\tA\u0002\u0019\u000b\u0001B\u0019:pW\u0016\u0014\u0018\n\u001a\u0005\b\u0003\u0007\u0002\u0002\u0019AA#\u0003\u001d\u0011X-];fgR\u0004D!a\u0012\u0002`A1\u0011\u0011JA+\u00037rA!a\u0013\u0002R5\u0011\u0011Q\n\u0006\u0004\u0003\u001f:\u0016\u0001\u0003:fcV,7\u000f^:\n\t\u0005M\u0013QJ\u0001\u0017\u0003\n\u001cHO]1di\u000e{g\u000e\u001e:pYJ+\u0017/^3ti&!\u0011qKA-\u0005\u001d\u0011U/\u001b7eKJTA!a\u0015\u0002NA!\u0011QLA0\u0019\u0001!A\"!\u0019\u0002B\u0005\u0005\t\u0011!B\u0001\u0003G\u00121a\u0018\u00135#\u0011\t)'a\u001b\u0011\u0007\r\n9'C\u0002\u0002j\u0011\u0012qAT8uQ&tw\r\u0005\u0003\u0002L\u00055\u0014\u0002BA8\u0003\u001b\u0012a#\u00112tiJ\f7\r^\"p]R\u0014x\u000e\u001c*fcV,7\u000f\u001e\u0005\n\u0003g\u0002\u0002\u0013!a\u0001\u0003k\n\u0001bY1mY\n\f7m\u001b\t\bG\u0005]\u00141PA\u0015\u0013\r\tI\b\n\u0002\n\rVt7\r^5p]F\u0002B!a\u0013\u0002~%!\u0011qPA'\u0005A\t%m\u001d;sC\u000e$(+Z:q_:\u001cX-A\u000btK:$'+Z9vKN$H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005\u0015%\u0006BA;\u0003\u000f[#!!#\u0011\t\u0005-\u0015QS\u0007\u0003\u0003\u001bSA!a$\u0002\u0012\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003'#\u0013AC1o]>$\u0018\r^5p]&!\u0011qSAG\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\t]\u0016<()\u0019;dQR\u0011\u0011\u0011F\u0001\u0006G2,\u0017M]\u0001!C\u0012$G*Z1eKJ\fe\u000eZ%teJ+\u0017/^3ti\u001a{'O\u0011:pW\u0016\u00148\u000f\u0006\u0007\u0002*\u0005\r\u0016qVAZ\u0003{\u000b9\rC\u0004\u0002&R\u0001\r!a*\u0002\u0013\t\u0014xn[3s\u0013\u0012\u001c\b#BAU\u0003W3U\"\u0001)\n\u0007\u00055\u0006KA\u0002TKFDa!!-\u0015\u0001\u0004)\u0016A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003k#\u0002\u0019AA\\\u0003maW-\u00193fe&\u001b(/\u00118e\u0007>tGO]8mY\u0016\u0014X\t]8dQB\u0019q'!/\n\u0007\u0005mFDA\u000eMK\u0006$WM]%te\u0006sGmQ8oiJ|G\u000e\\3s\u000bB|7\r\u001b\u0005\b\u0003\u007f#\u0002\u0019AAa\u0003E\u0011X\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e\t\u0004o\u0005\r\u0017bAAc9\t\t\"+\u001a9mS\u000e\f\u0017i]:jO:lWM\u001c;\t\u000f\u0005%G\u00031\u0001\u0002L\u0006)\u0011n\u001d(foB\u00191%!4\n\u0007\u0005=GEA\u0004C_>dW-\u00198\u0002?\u0005$Gm\u0015;paJ+\u0007\u000f\\5dCJ+\u0017/^3ti\u001a{'O\u0011:pW\u0016\u00148\u000f\u0006\u0005\u0002*\u0005U\u0017q[Am\u0011\u001d\t)+\u0006a\u0001\u0003OCa!!-\u0016\u0001\u0004)\u0006bBAn+\u0001\u0007\u00111Z\u0001\u0010I\u0016dW\r^3QCJ$\u0018\u000e^5p]\u0006\u0011\u0013\r\u001a3Va\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;G_J\u0014%o\\6feN$b!!\u000b\u0002b\u0006\r\bbBAS-\u0001\u0007\u0011q\u0015\u0005\b\u0003K4\u0002\u0019AAt\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0006\u0003S\u000bI/V\u0005\u0004\u0003\u0017\u0001\u0016aF:f]\u0012dU-\u00193fe\u0006sG-S:s%\u0016\fX/Z:u)\u0019\tI#a<\u0002t\"1\u0011\u0011_\fA\u0002\u0019\u000bqbY8oiJ|G\u000e\\3s\u000bB|7\r\u001b\u0005\u0007\u0003k<\u0002\u0019A\u001e\u0002\u001dM$\u0018\r^3DQ\u0006tw-\u001a'pO\u0006Q2/\u001a8e+B$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:ugR1\u0011\u0011FA~\u0003{Da!!=\u0019\u0001\u00041\u0005BBA{1\u0001\u00071(A\ftK:$7\u000b^8q%\u0016\u0004H.[2b%\u0016\fX/Z:ugR!\u0011\u0011\u0006B\u0002\u0011\u0019\t\t0\u0007a\u0001\r\u0006)2/\u001a8e%\u0016\fX/Z:ugR{'I]8lKJ\u001cH\u0003BA\u0015\u0005\u0013Aa!!=\u001b\u0001\u00041\u0005")
public abstract class AbstractControllerBrokerRequestBatch
implements Logging {
    private final KafkaConfig config;
    private final ControllerContext controllerContext;
    private final StateChangeLogger stateChangeLogger;
    private final int controllerId;
    private final scala.collection.mutable.Map<Object, scala.collection.mutable.Map<TopicPartition, LeaderAndIsrRequestData.LeaderAndIsrPartitionState>> leaderAndIsrRequestMap;
    private final scala.collection.mutable.Map<Object, ListBuffer<StopReplicaRequestInfo>> stopReplicaRequestMap;
    private final scala.collection.mutable.Set<Object> updateMetadataRequestBrokerSet;
    private final scala.collection.mutable.Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> updateMetadataRequestPartitionInfoMap;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        AbstractControllerBrokerRequestBatch abstractControllerBrokerRequestBatch = this;
        synchronized (abstractControllerBrokerRequestBatch) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int controllerId() {
        return this.controllerId;
    }

    public scala.collection.mutable.Map<Object, scala.collection.mutable.Map<TopicPartition, LeaderAndIsrRequestData.LeaderAndIsrPartitionState>> leaderAndIsrRequestMap() {
        return this.leaderAndIsrRequestMap;
    }

    public scala.collection.mutable.Map<Object, ListBuffer<StopReplicaRequestInfo>> stopReplicaRequestMap() {
        return this.stopReplicaRequestMap;
    }

    public scala.collection.mutable.Set<Object> updateMetadataRequestBrokerSet() {
        return this.updateMetadataRequestBrokerSet;
    }

    public scala.collection.mutable.Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> updateMetadataRequestPartitionInfoMap() {
        return this.updateMetadataRequestPartitionInfoMap;
    }

    public abstract void sendEvent(ControllerEvent var1);

    public abstract void sendRequest(int var1, AbstractControlRequest.Builder<? extends AbstractControlRequest> var2, Function1<AbstractResponse, BoxedUnit> var3);

    public Function1<AbstractResponse, BoxedUnit> sendRequest$default$3() {
        return null;
    }

    public void newBatch() {
        if (this.leaderAndIsrRequestMap().nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(77).append("Controller to broker state change requests batch is not empty while creating ").append(new StringBuilder(58).append("a new one. Some LeaderAndIsr state changes ").append(this.leaderAndIsrRequestMap()).append(" might be lost ").toString()).toString());
        }
        if (this.stopReplicaRequestMap().nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(79).append("Controller to broker state change requests batch is not empty while creating a ").append(new StringBuilder(55).append("new one. Some StopReplica state changes ").append(this.stopReplicaRequestMap()).append(" might be lost ").toString()).toString());
        }
        if (this.updateMetadataRequestBrokerSet().nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(79).append("Controller to broker state change requests batch is not empty while creating a ").append(new StringBuilder(75).append("new one. Some UpdateMetadata state changes to brokers ").append(this.updateMetadataRequestBrokerSet()).append(" with partition info ").toString()).append(new StringBuilder(15).append(this.updateMetadataRequestPartitionInfoMap()).append(" might be lost ").toString()).toString());
        }
    }

    public void clear() {
        this.leaderAndIsrRequestMap().clear();
        this.stopReplicaRequestMap().clear();
        this.updateMetadataRequestBrokerSet().clear();
        this.updateMetadataRequestPartitionInfoMap().clear();
    }

    public void addLeaderAndIsrRequestForBrokers(Seq<Object> brokerIds, TopicPartition topicPartition, LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch, ReplicaAssignment replicaAssignment, boolean isNew) {
        ((IterableOnceOps)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable)x$4 -> x$4 >= 0)).foreach((Function1 & Serializable)brokerId -> AbstractControllerBrokerRequestBatch.$anonfun$addLeaderAndIsrRequestForBrokers$2(this, topicPartition, leaderIsrAndControllerEpoch, replicaAssignment, isNew, BoxesRunTime.unboxToInt((Object)brokerId)));
        this.addUpdateMetadataRequestForBrokers((Seq<Object>)this.controllerContext.liveOrShuttingDownBrokerIds().toSeq(), (Set<TopicPartition>)((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
    }

    public void addStopReplicaRequestForBrokers(Seq<Object> brokerIds, TopicPartition topicPartition, boolean deletePartition) {
        ((IterableOnceOps)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable)x$6 -> x$6 >= 0)).foreach((Function1 & Serializable)brokerId -> AbstractControllerBrokerRequestBatch.$anonfun$addStopReplicaRequestForBrokers$2(this, topicPartition, deletePartition, BoxesRunTime.unboxToInt((Object)brokerId)));
    }

    public void addUpdateMetadataRequestForBrokers(Seq<Object> brokerIds, Set<TopicPartition> partitions) {
        this.updateMetadataRequestBrokerSet().$plus$plus$eq((IterableOnce)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable)x$8 -> x$8 >= 0));
        partitions.foreach((Function1 & Serializable)partition -> {
            this.updateMetadataRequestPartitionInfo$1(partition, this.controllerContext.topicsToBeDeleted().contains((Object)partition.topic()));
            return BoxedUnit.UNIT;
        });
    }

    private void sendLeaderAndIsrRequest(int controllerEpoch, StateChangeLogger stateChangeLog) {
        short leaderAndIsrRequestVersion = this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_2_4_IV1$.MODULE$) ? (short)4 : (this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_2_4_IV0$.MODULE$) ? (short)3 : (this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_2_2_IV0$.MODULE$) ? (short)2 : (this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_1_0_IV0$.MODULE$) ? (short)1 : 0)));
        Set<Object> set = this.controllerContext.liveOrShuttingDownBrokerIds();
        this.leaderAndIsrRequestMap().filterKeys((Function1)(JFunction1.mcZI.sp & Serializable)elem -> set.contains((Object)BoxesRunTime.boxToInteger((int)elem))).foreach((Function1 & Serializable)x0$1 -> {
            AbstractControllerBrokerRequestBatch.$anonfun$sendLeaderAndIsrRequest$2(this, stateChangeLog, leaderAndIsrRequestVersion, controllerEpoch, x0$1);
            return BoxedUnit.UNIT;
        });
        this.leaderAndIsrRequestMap().clear();
    }

    private void sendUpdateMetadataRequests(int controllerEpoch, StateChangeLogger stateChangeLog) {
        this.updateMetadataRequestPartitionInfoMap().foreach((Function1 & Serializable)x0$1 -> {
            AbstractControllerBrokerRequestBatch.$anonfun$sendUpdateMetadataRequests$1(this, stateChangeLog, x0$1);
            return BoxedUnit.UNIT;
        });
        Buffer partitionStates = this.updateMetadataRequestPartitionInfoMap().values().toBuffer();
        int updateMetadataRequestVersion = this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_2_4_IV1$.MODULE$) ? 6 : (this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_2_2_IV0$.MODULE$) ? 5 : (this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_1_0_IV0$.MODULE$) ? 4 : (this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_2_IV0$.MODULE$) ? 3 : (this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_0_IV1$.MODULE$) ? 2 : (this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_0_9_0$.MODULE$) ? 1 : 0)))));
        Buffer liveBrokers = this.controllerContext.liveOrShuttingDownBrokers().iterator().map(arg_0 -> AbstractControllerBrokerRequestBatch.$anonfun$sendUpdateMetadataRequests$3((short)updateMetadataRequestVersion, arg_0)).toBuffer();
        this.updateMetadataRequestBrokerSet().intersect(this.controllerContext.liveOrShuttingDownBrokerIds()).foreach((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> AbstractControllerBrokerRequestBatch.$anonfun$sendUpdateMetadataRequests$5(this, (short)updateMetadataRequestVersion, controllerEpoch, partitionStates, liveBrokers, arg_0)));
        this.updateMetadataRequestBrokerSet().clear();
        this.updateMetadataRequestPartitionInfoMap().clear();
    }

    private void sendStopReplicaRequests(int controllerEpoch) {
        short stopReplicaRequestVersion = this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_2_4_IV1$.MODULE$) ? (short)2 : (this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_2_2_IV0$.MODULE$) ? (short)1 : 0);
        Set<Object> set = this.controllerContext.liveOrShuttingDownBrokerIds();
        this.stopReplicaRequestMap().filterKeys((Function1)(JFunction1.mcZI.sp & Serializable)elem -> set.contains((Object)BoxesRunTime.boxToInteger((int)elem))).foreach((Function1 & Serializable)x0$1 -> {
            AbstractControllerBrokerRequestBatch.$anonfun$sendStopReplicaRequests$5(this, stopReplicaRequestVersion, controllerEpoch, x0$1);
            return BoxedUnit.UNIT;
        });
        this.stopReplicaRequestMap().clear();
    }

    public void sendRequestsToBrokers(int controllerEpoch) {
        try {
            StateChangeLogger stateChangeLog = this.stateChangeLogger.withControllerEpoch(controllerEpoch);
            this.sendLeaderAndIsrRequest(controllerEpoch, stateChangeLog);
            this.sendUpdateMetadataRequests(controllerEpoch, stateChangeLog);
            this.sendStopReplicaRequests(controllerEpoch);
        }
        catch (Throwable e) {
            if (this.leaderAndIsrRequestMap().nonEmpty()) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(68).append("Haven't been able to send leader and isr requests, current state of ").append(new StringBuilder(32).append("the map is ").append(this.leaderAndIsrRequestMap()).append(". Exception message: ").append(e).toString()).toString());
            }
            if (this.updateMetadataRequestBrokerSet().nonEmpty()) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(64).append("Haven't been able to send metadata update requests to brokers ").append(this.updateMetadataRequestBrokerSet()).append(", ").toString()).append(new StringBuilder(60).append("current state of the partition info is ").append(this.updateMetadataRequestPartitionInfoMap()).append(". Exception message: ").append(e).toString()).toString());
            }
            if (this.stopReplicaRequestMap().nonEmpty()) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(66).append("Haven't been able to send stop replica requests, current state of ").append(new StringBuilder(32).append("the map is ").append(this.stopReplicaRequestMap()).append(". Exception message: ").append(e).toString()).toString());
            }
            throw new IllegalStateException(e);
        }
    }

    public static final /* synthetic */ Option $anonfun$addLeaderAndIsrRequestForBrokers$2(AbstractControllerBrokerRequestBatch $this, TopicPartition topicPartition$1, LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$1, ReplicaAssignment replicaAssignment$1, boolean isNew$1, int brokerId) {
        scala.collection.mutable.Map result = (scala.collection.mutable.Map)$this.leaderAndIsrRequestMap().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)brokerId), (Function0 & Serializable)() -> (scala.collection.mutable.Map)Map$.MODULE$.empty());
        boolean alreadyNew = result.get((Object)topicPartition$1).exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isNew()));
        LeaderAndIsr leaderAndIsr = leaderIsrAndControllerEpoch$1.leaderAndIsr();
        return result.put((Object)topicPartition$1, (Object)new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(topicPartition$1.topic()).setPartitionIndex(topicPartition$1.partition()).setControllerEpoch(leaderIsrAndControllerEpoch$1.controllerEpoch()).setLeader(leaderAndIsr.leader()).setLeaderEpoch(leaderAndIsr.leaderEpoch()).setIsr((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)leaderAndIsr.isr().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setZkVersion(leaderAndIsr.zkVersion()).setReplicas((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)replicaAssignment$1.replicas().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setAddingReplicas((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)replicaAssignment$1.addingReplicas().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setRemovingReplicas((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)replicaAssignment$1.removingReplicas().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setIsNew(isNew$1 || alreadyNew));
    }

    public static final /* synthetic */ ListBuffer $anonfun$addStopReplicaRequestForBrokers$2(AbstractControllerBrokerRequestBatch $this, TopicPartition topicPartition$2, boolean deletePartition$1, int brokerId) {
        ListBuffer stopReplicaInfos = (ListBuffer)$this.stopReplicaRequestMap().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)brokerId), (Function0 & Serializable)() -> ListBuffer$.MODULE$.empty());
        return (ListBuffer)stopReplicaInfos.append((Object)new StopReplicaRequestInfo(new PartitionAndReplica(topicPartition$2, brokerId), deletePartition$1));
    }

    private final void updateMetadataRequestPartitionInfo$1(TopicPartition partition, boolean beingDeleted) {
        Some some;
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch;
        Option option = this.controllerContext.partitionLeadershipInfo().get((Object)partition);
        if (option instanceof Some && (leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)(some = (Some)option).value()) != null) {
            LeaderAndIsr leaderAndIsr = leaderIsrAndControllerEpoch.leaderAndIsr();
            int controllerEpoch = leaderIsrAndControllerEpoch.controllerEpoch();
            Seq<Object> replicas = this.controllerContext.partitionReplicaAssignment(partition);
            Seq offlineReplicas = (Seq)replicas.filter((Function1)(JFunction1.mcZI.sp & Serializable)x$7 -> !$this.controllerContext.isReplicaOnline(x$7, partition, $this.controllerContext.isReplicaOnline$default$3()));
            LeaderAndIsr updatedLeaderAndIsr = beingDeleted ? LeaderAndIsr$.MODULE$.duringDelete(leaderAndIsr.isr()) : leaderAndIsr;
            UpdateMetadataRequestData.UpdateMetadataPartitionState partitionStateInfo = new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(partition.topic()).setPartitionIndex(partition.partition()).setControllerEpoch(controllerEpoch).setLeader(updatedLeaderAndIsr.leader()).setLeaderEpoch(updatedLeaderAndIsr.leaderEpoch()).setIsr((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)updatedLeaderAndIsr.isr().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setZkVersion(updatedLeaderAndIsr.zkVersion()).setReplicas((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setOfflineReplicas((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)offlineReplicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava());
            this.updateMetadataRequestPartitionInfoMap().put((Object)partition, (Object)partitionStateInfo);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append("Leader not yet assigned for partition ").append(partition).append(". Skip sending UpdateMetadataRequest.").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ void $anonfun$sendLeaderAndIsrRequest$3(int broker$2, StateChangeLogger stateChangeLog$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState state = (LeaderAndIsrRequestData.LeaderAndIsrPartitionState)tuple2._2();
        String typeOfRequest = broker$2 == state.leader() ? "become-leader" : "become-follower";
        stateChangeLog$1.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Sending ").append(typeOfRequest).append(" LeaderAndIsr request ").append(state).append(" to broker ").append(broker$2).append(" for partition ").append(topicPartition).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ int $anonfun$sendLeaderAndIsrRequest$5(Tuple2 x$9) {
        return ((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)x$9._2()).leader();
    }

    public static final /* synthetic */ void $anonfun$sendLeaderAndIsrRequest$2(AbstractControllerBrokerRequestBatch $this, StateChangeLogger stateChangeLog$1, short leaderAndIsrRequestVersion$1, int controllerEpoch$1, Tuple2 x0$1) {
        scala.collection.mutable.Map leaderAndIsrPartitionStates;
        int broker;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            broker = tuple2._1$mcI$sp();
            leaderAndIsrPartitionStates = (scala.collection.mutable.Map)tuple2._2();
            if (stateChangeLog$1.isTraceEnabled()) {
                leaderAndIsrPartitionStates.foreach((Function1 & Serializable)x0$2 -> {
                    AbstractControllerBrokerRequestBatch.$anonfun$sendLeaderAndIsrRequest$3(broker, stateChangeLog$1, x0$2);
                    return BoxedUnit.UNIT;
                });
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Set leaderIds = ((IterableOnceOps)leaderAndIsrPartitionStates.map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)AbstractControllerBrokerRequestBatch.$anonfun$sendLeaderAndIsrRequest$5(x$9)))).toSet();
        Set leaders = (Set)((IterableOps)$this.controllerContext.liveOrShuttingDownBrokers().filter((Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)leaderIds.contains((Object)BoxesRunTime.boxToInteger((int)b.id()))))).map((Function1 & Serializable)x$10 -> x$10.node($this.config.interBrokerListenerName()));
        long brokerEpoch = BoxesRunTime.unboxToLong((Object)$this.controllerContext.liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)broker)));
        LeaderAndIsrRequest.Builder leaderAndIsrRequestBuilder = new LeaderAndIsrRequest.Builder(leaderAndIsrRequestVersion$1, $this.controllerId(), controllerEpoch$1, brokerEpoch, (List)JavaConverters$.MODULE$.bufferAsJavaListConverter(leaderAndIsrPartitionStates.values().toBuffer()).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter(leaders).asJava());
        $this.sendRequest(broker, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)leaderAndIsrRequestBuilder, (Function1<AbstractResponse, BoxedUnit>)(Function1 & Serializable)r -> {
            $this.sendEvent(new LeaderAndIsrResponseReceived(r, broker));
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$sendUpdateMetadataRequests$1(AbstractControllerBrokerRequestBatch $this, StateChangeLogger stateChangeLog$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)tuple2._2();
        stateChangeLog$2.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(44).append("Sending UpdateMetadata request ").append(partitionState).append(" to brokers ").append($this.updateMetadataRequestBrokerSet()).append(" ").toString()).append(new StringBuilder(14).append("for partition ").append(tp).toString()).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ UpdateMetadataRequestData.UpdateMetadataBroker $anonfun$sendUpdateMetadataRequests$3(short updateMetadataRequestVersion$1, Broker broker) {
        Seq seq;
        if (updateMetadataRequestVersion$1 == 0) {
            SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
            ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
            Node node = broker.node(listenerName);
            seq = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataEndpoint[]{new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(node.host()).setPort(node.port()).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value())}));
        } else {
            seq = (Seq)broker.endPoints().map((Function1 & Serializable)endpoint -> new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(endpoint.host()).setPort(endpoint.port()).setSecurityProtocol(endpoint.securityProtocol().id).setListener(endpoint.listenerName().value()));
        }
        Seq endpoints = seq;
        return new UpdateMetadataRequestData.UpdateMetadataBroker().setId(broker.id()).setEndpoints((List)JavaConverters$.MODULE$.seqAsJavaListConverter(endpoints).asJava()).setRack((String)broker.rack().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public static final /* synthetic */ void $anonfun$sendUpdateMetadataRequests$5(AbstractControllerBrokerRequestBatch $this, short updateMetadataRequestVersion$1, int controllerEpoch$2, Buffer partitionStates$1, Buffer liveBrokers$1, int broker) {
        long brokerEpoch = BoxesRunTime.unboxToLong((Object)$this.controllerContext.liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)broker)));
        UpdateMetadataRequest.Builder updateMetadataRequest = new UpdateMetadataRequest.Builder(updateMetadataRequestVersion$1, $this.controllerId(), controllerEpoch$2, brokerEpoch, (List)JavaConverters$.MODULE$.bufferAsJavaListConverter(partitionStates$1).asJava(), (List)JavaConverters$.MODULE$.bufferAsJavaListConverter(liveBrokers$1).asJava());
        $this.sendRequest(broker, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)updateMetadataRequest, $this.sendRequest$default$3());
    }

    private final void stopReplicaPartitionDeleteResponseCallback$1(int brokerId, AbstractResponse response) {
        block0: {
            StopReplicaResponse stopReplicaResponse = (StopReplicaResponse)response;
            scala.collection.immutable.Map partitionErrorsForDeletingTopics = ((IterableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(stopReplicaResponse.partitionErrors()).asScala()).iterator().filter((Function1 & Serializable)pe -> BoxesRunTime.boxToBoolean((boolean)this.controllerContext.isTopicDeletionInProgress(pe.topicName()))).map((Function1 & Serializable)pe -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(pe.topicName(), pe.partitionIndex())), (Object)Errors.forCode((short)pe.errorCode()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            if (!partitionErrorsForDeletingTopics.nonEmpty()) break block0;
            this.sendEvent(new TopicDeletionStopReplicaResponseReceived(brokerId, stopReplicaResponse.error(), (Map<TopicPartition, Errors>)partitionErrorsForDeletingTopics));
        }
    }

    private final StopReplicaRequest.Builder createStopReplicaRequest$1(long brokerEpoch, Seq requests, boolean deletePartitions, short stopReplicaRequestVersion$1, int controllerEpoch$3) {
        List partitions = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)requests.map((Function1 & Serializable)x$11 -> x$11.replica().topicPartition())).asJava();
        return new StopReplicaRequest.Builder(stopReplicaRequestVersion$1, this.controllerId(), controllerEpoch$3, brokerEpoch, deletePartitions, (Collection)partitions);
    }

    public static final /* synthetic */ void $anonfun$sendStopReplicaRequests$5(AbstractControllerBrokerRequestBatch $this, short stopReplicaRequestVersion$1, int controllerEpoch$3, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int brokerId = tuple2._1$mcI$sp();
            ListBuffer replicaInfoList = (ListBuffer)tuple2._2();
            Tuple2 tuple22 = replicaInfoList.partition((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)r.deletePartition()));
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            ListBuffer stopReplicaWithDelete = (ListBuffer)tuple22._1();
            ListBuffer stopReplicaWithoutDelete = (ListBuffer)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)stopReplicaWithDelete, (Object)stopReplicaWithoutDelete);
            Tuple2 tuple24 = tuple23;
            ListBuffer stopReplicaWithDelete2 = (ListBuffer)tuple24._1();
            ListBuffer stopReplicaWithoutDelete2 = (ListBuffer)tuple24._2();
            long brokerEpoch = BoxesRunTime.unboxToLong((Object)$this.controllerContext.liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)brokerId)));
            if (stopReplicaWithDelete2.nonEmpty()) {
                $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(60).append("The stop replica request (delete = true) sent to broker ").append(brokerId).append(" is ").append(stopReplicaWithDelete2.mkString(",")).toString());
                StopReplicaRequest.Builder stopReplicaRequest = $this.createStopReplicaRequest$1(brokerEpoch, (Seq)stopReplicaWithDelete2, true, stopReplicaRequestVersion$1, controllerEpoch$3);
                Function1 & Serializable callback = (Function1 & Serializable)response -> {
                    $this.stopReplicaPartitionDeleteResponseCallback$1(brokerId, response);
                    return BoxedUnit.UNIT;
                };
                $this.sendRequest(brokerId, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)stopReplicaRequest, (Function1<AbstractResponse, BoxedUnit>)callback);
            }
            if (stopReplicaWithoutDelete2.nonEmpty()) {
                $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(61).append("The stop replica request (delete = false) sent to broker ").append(brokerId).append(" is ").append(stopReplicaWithoutDelete2.mkString(",")).toString());
                StopReplicaRequest.Builder stopReplicaRequest = $this.createStopReplicaRequest$1(brokerEpoch, (Seq)stopReplicaWithoutDelete2, false, stopReplicaRequestVersion$1, controllerEpoch$3);
                $this.sendRequest(brokerId, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)stopReplicaRequest, $this.sendRequest$default$3());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public AbstractControllerBrokerRequestBatch(KafkaConfig config, ControllerContext controllerContext, StateChangeLogger stateChangeLogger) {
        this.config = config;
        this.controllerContext = controllerContext;
        this.stateChangeLogger = stateChangeLogger;
        Logging.$init$(this);
        this.controllerId = config.brokerId();
        this.leaderAndIsrRequestMap = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.stopReplicaRequestMap = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.updateMetadataRequestBrokerSet = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.empty();
        this.updateMetadataRequestPartitionInfoMap = (scala.collection.mutable.Map)Map$.MODULE$.empty();
    }
}

