/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.coordinator.transaction.ProducerIdBlock;
import kafka.utils.Json$;
import kafka.utils.Logging;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import org.apache.kafka.common.KafkaException;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ProducerIdManager$
implements Logging {
    public static final ProducerIdManager$ MODULE$ = new ProducerIdManager$();
    private static final long CurrentVersion;
    private static final long PidBlockSize;
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
        CurrentVersion = 1L;
        PidBlockSize = 1000L;
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ProducerIdManager$ producerIdManager$ = this;
        synchronized (producerIdManager$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        return !bitmap$0 ? this.logger$lzycompute() : logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public long CurrentVersion() {
        return CurrentVersion;
    }

    public long PidBlockSize() {
        return PidBlockSize;
    }

    public byte[] generateProducerIdBlockJson(ProducerIdBlock producerIdBlock) {
        return Json$.MODULE$.encodeAsBytes(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToLong((long)this.CurrentVersion())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker"), (Object)BoxesRunTime.boxToInteger((int)producerIdBlock.brokerId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"block_start"), (Object)((Object)BoxesRunTime.boxToLong((long)producerIdBlock.blockStartId())).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"block_end"), (Object)((Object)BoxesRunTime.boxToLong((long)producerIdBlock.blockEndId())).toString())}))).asJava());
    }

    public ProducerIdBlock parseProducerIdBlockData(byte[] jsonData) {
        ProducerIdBlock producerIdBlock;
        try {
            producerIdBlock = (ProducerIdBlock)Json$.MODULE$.parseBytes(jsonData).map((Function1 & Serializable)x$1 -> x$1.asJsonObject()).flatMap((Function1 & Serializable)js -> {
                int brokerId = BoxesRunTime.unboxToInt((Object)js.apply("broker").to(DecodeJson$DecodeInt$.MODULE$));
                long blockStart = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(js.apply("block_start").to(DecodeJson$DecodeString$.MODULE$)));
                long blockEnd = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(js.apply("block_end").to(DecodeJson$DecodeString$.MODULE$)));
                return new Some((Object)new ProducerIdBlock(brokerId, blockStart, blockEnd));
            }).getOrElse((Function0 & Serializable)() -> {
                throw new KafkaException(new StringBuilder(42).append("Failed to parse the producerId block json ").append(jsonData).toString());
            });
        }
        catch (NumberFormatException e) {
            this.fatal((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(72).append("Read jason data ").append(jsonData).append(" contains producerIds that have exceeded long type limit").toString());
            throw e;
        }
        return producerIdBlock;
    }

    private ProducerIdManager$() {
    }
}

