/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.TransactionLog$KeySchema$;
import kafka.coordinator.transaction.TransactionLog$ValueSchema$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TxnKey;
import kafka.coordinator.transaction.TxnTransitMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.record.CompressionType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Set;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Map;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TransactionLog$ {
    public static final TransactionLog$ MODULE$ = new TransactionLog$();
    private static final int DefaultNumPartitions = 50;
    private static final int DefaultSegmentBytes = 0x6400000;
    private static final short DefaultReplicationFactor = (short)3;
    private static final int DefaultMinInSyncReplicas = 2;
    private static final int DefaultLoadBufferSize = 0x500000;
    private static final CompressionType EnforcedCompressionType = CompressionType.NONE;
    private static final short EnforcedRequiredAcks = (short)-1;

    public int DefaultNumPartitions() {
        return DefaultNumPartitions;
    }

    public int DefaultSegmentBytes() {
        return DefaultSegmentBytes;
    }

    public short DefaultReplicationFactor() {
        return DefaultReplicationFactor;
    }

    public int DefaultMinInSyncReplicas() {
        return DefaultMinInSyncReplicas;
    }

    public int DefaultLoadBufferSize() {
        return DefaultLoadBufferSize;
    }

    public CompressionType EnforcedCompressionType() {
        return EnforcedCompressionType;
    }

    public short EnforcedRequiredAcks() {
        return EnforcedRequiredAcks;
    }

    public Schema kafka$coordinator$transaction$TransactionLog$$schemaForKey(int version) {
        return (Schema)TransactionLog$KeySchema$.MODULE$.ofVersion(version).getOrElse((Function0 & Serializable)() -> {
            throw new KafkaException(new StringBuilder(51).append("Unknown transaction log message key schema version ").append(version).toString());
        });
    }

    public Schema kafka$coordinator$transaction$TransactionLog$$schemaForValue(int version) {
        return (Schema)TransactionLog$ValueSchema$.MODULE$.ofVersion(version).getOrElse((Function0 & Serializable)() -> {
            throw new KafkaException(new StringBuilder(53).append("Unknown transaction log message value schema version ").append(version).toString());
        });
    }

    public byte[] keyToBytes(String transactionalId) {
        Struct key = new Struct(TransactionLog$KeySchema$.MODULE$.CURRENT());
        key.set(TransactionLog$KeySchema$.MODULE$.TXN_ID_FIELD(), (Object)transactionalId);
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + key.sizeOf());
        byteBuffer.putShort(TransactionLog$KeySchema$.MODULE$.CURRENT_VERSION());
        key.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public byte[] valueToBytes(TxnTransitMetadata txnMetadata) {
        Struct struct;
        Struct value = new Struct(TransactionLog$ValueSchema$.MODULE$.Current());
        value.set(TransactionLog$ValueSchema$.MODULE$.ProducerIdField(), (Object)BoxesRunTime.boxToLong((long)txnMetadata.producerId()));
        value.set(TransactionLog$ValueSchema$.MODULE$.ProducerEpochField(), (Object)BoxesRunTime.boxToShort((short)txnMetadata.producerEpoch()));
        value.set(TransactionLog$ValueSchema$.MODULE$.TxnTimeoutField(), (Object)BoxesRunTime.boxToInteger((int)txnMetadata.txnTimeoutMs()));
        value.set(TransactionLog$ValueSchema$.MODULE$.TxnStatusField(), (Object)BoxesRunTime.boxToByte((byte)txnMetadata.txnState().byte()));
        value.set(TransactionLog$ValueSchema$.MODULE$.TxnEntryTimestampField(), (Object)BoxesRunTime.boxToLong((long)txnMetadata.txnLastUpdateTimestamp()));
        value.set(TransactionLog$ValueSchema$.MODULE$.TxnStartTimestampField(), (Object)BoxesRunTime.boxToLong((long)txnMetadata.txnStartTimestamp()));
        TransactionState transactionState = txnMetadata.txnState();
        Empty$ empty$ = Empty$.MODULE$;
        if (!(transactionState != null ? !transactionState.equals(empty$) : empty$ != null)) {
            if (txnMetadata.topicPartitions().nonEmpty()) {
                throw new IllegalStateException(new StringBuilder(72).append("Transaction is not expected to have any partitions since its state is ").append(txnMetadata.txnState()).append(": ").append(txnMetadata).toString());
            }
            struct = value.set(TransactionLog$ValueSchema$.MODULE$.TxnPartitionsField(), null);
        } else {
            Map topicAndPartitions = txnMetadata.topicPartitions().groupBy((Function1 & Serializable)x$1 -> x$1.topic());
            Iterable partitionArray = (Iterable)topicAndPartitions.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String topic = (String)tuple2._1();
                scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)tuple2._2();
                Struct topicPartitionsStruct = value.instance(TransactionLog$ValueSchema$.MODULE$.TxnPartitionsField());
                Integer[] partitionIds = (Integer[])((IterableOnceOps)partitions.map((Function1 & Serializable)topicPartition -> topicPartition.partition())).toArray(ClassTag$.MODULE$.apply(Integer.class));
                topicPartitionsStruct.set(TransactionLog$ValueSchema$.MODULE$.PartitionsTopicField(), (Object)topic);
                topicPartitionsStruct.set(TransactionLog$ValueSchema$.MODULE$.PartitionIdsField(), (Object)partitionIds);
                Struct struct = topicPartitionsStruct;
                return struct;
            });
            struct = value.set(TransactionLog$ValueSchema$.MODULE$.TxnPartitionsField(), partitionArray.toArray(ClassTag$.MODULE$.apply(Struct.class)));
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + value.sizeOf());
        byteBuffer.putShort(TransactionLog$ValueSchema$.MODULE$.CurrentVersion());
        value.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public TxnKey readTxnRecordKey(ByteBuffer buffer) {
        short version = buffer.getShort();
        Schema keySchema = this.kafka$coordinator$transaction$TransactionLog$$schemaForKey(version);
        Struct key = keySchema.read(buffer);
        if (version != TransactionLog$KeySchema$.MODULE$.CURRENT_VERSION()) {
            throw new IllegalStateException(new StringBuilder(49).append("Unknown version ").append(version).append(" from the transaction log message").toString());
        }
        String transactionalId = key.getString(TransactionLog$KeySchema$.MODULE$.TXN_ID_FIELD());
        return new TxnKey(version, transactionalId);
    }

    public TransactionMetadata readTxnRecordValue(String transactionalId, ByteBuffer buffer) {
        TransactionMetadata transactionMetadata;
        if (buffer == null) {
            transactionMetadata = null;
        } else {
            short version = buffer.getShort();
            Schema valueSchema = this.kafka$coordinator$transaction$TransactionLog$$schemaForValue(version);
            Struct value = valueSchema.read(buffer);
            if (version == TransactionLog$ValueSchema$.MODULE$.CurrentVersion()) {
                Long producerId = value.getLong(TransactionLog$ValueSchema$.MODULE$.ProducerIdField());
                Short epoch = value.getShort(TransactionLog$ValueSchema$.MODULE$.ProducerEpochField());
                Integer timeout = value.getInt(TransactionLog$ValueSchema$.MODULE$.TxnTimeoutField());
                Byte stateByte = value.getByte(TransactionLog$ValueSchema$.MODULE$.TxnStatusField());
                TransactionState state = TransactionMetadata$.MODULE$.byteToState(Predef$.MODULE$.Byte2byte(stateByte));
                Long entryTimestamp = value.getLong(TransactionLog$ValueSchema$.MODULE$.TxnEntryTimestampField());
                Long startTimestamp = value.getLong(TransactionLog$ValueSchema$.MODULE$.TxnStartTimestampField());
                TransactionMetadata transactionMetadata2 = new TransactionMetadata(transactionalId, Predef$.MODULE$.Long2long(producerId), Predef$.MODULE$.Short2short(epoch), Predef$.MODULE$.Integer2int(timeout), state, (scala.collection.mutable.Set<TopicPartition>)((scala.collection.mutable.Set)Set$.MODULE$.empty()), Predef$.MODULE$.Long2long(startTimestamp), Predef$.MODULE$.Long2long(entryTimestamp));
                if (!state.equals(Empty$.MODULE$)) {
                    Object[] topicPartitionArray = value.getArray(TransactionLog$ValueSchema$.MODULE$.TxnPartitionsField());
                    ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(topicPartitionArray), (Function1 & Serializable)memberMetadataObj -> {
                        TransactionLog$.$anonfun$readTxnRecordValue$1(transactionMetadata2, memberMetadataObj);
                        return BoxedUnit.UNIT;
                    });
                }
                transactionMetadata = transactionMetadata2;
            } else {
                throw new IllegalStateException(new StringBuilder(55).append("Unknown version ").append(version).append(" from the transaction log message value").toString());
            }
        }
        return transactionMetadata;
    }

    public static final /* synthetic */ void $anonfun$readTxnRecordValue$1(TransactionMetadata transactionMetadata$1, Object memberMetadataObj) {
        Struct memberMetadata = (Struct)memberMetadataObj;
        String topic = memberMetadata.getString(TransactionLog$ValueSchema$.MODULE$.PartitionsTopicField());
        Object[] partitionIdArray = memberMetadata.getArray(TransactionLog$ValueSchema$.MODULE$.PartitionIdsField());
        TopicPartition[] topicPartitions = (TopicPartition[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(partitionIdArray), (Function1 & Serializable)partitionIdObj -> {
            Integer partitionId = (Integer)partitionIdObj;
            return new TopicPartition(topic, Predef$.MODULE$.Integer2int(partitionId));
        }, ClassTag$.MODULE$.apply(TopicPartition.class));
        transactionMetadata$1.addPartitions((Set<TopicPartition>)Predef$.MODULE$.wrapRefArray((Object[])topicPartitions).toSet());
    }

    private TransactionLog$() {
    }
}

