/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import joptsimple.OptionSpec;
import kafka.common.MessageFormatter;
import kafka.tools.ConsoleConsumer;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Implicits$;
import kafka.utils.Logging;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;

public final class ConsoleConsumer$
implements Logging {
    public static final ConsoleConsumer$ MODULE$ = new ConsoleConsumer$();
    private static int messageCount;
    private static final CountDownLatch kafka$tools$ConsoleConsumer$$shutdownLatch;
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
        messageCount = 0;
        kafka$tools$ConsoleConsumer$$shutdownLatch = new CountDownLatch(1);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ConsoleConsumer$ consoleConsumer$ = this;
        synchronized (consoleConsumer$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        return !bitmap$0 ? this.logger$lzycompute() : logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public int messageCount() {
        return messageCount;
    }

    public void messageCount_$eq(int x$1) {
        messageCount = x$1;
    }

    public CountDownLatch kafka$tools$ConsoleConsumer$$shutdownLatch() {
        return kafka$tools$ConsoleConsumer$$shutdownLatch;
    }

    public void main(String[] args) {
        ConsoleConsumer.ConsumerConfig conf = new ConsoleConsumer.ConsumerConfig(args);
        try {
            this.run(conf);
        }
        catch (AuthenticationException e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Authentication failed: terminating consumer process", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Unknown error when running consumer: ", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
    }

    public void run(ConsoleConsumer.ConsumerConfig conf) {
        long timeoutMs = conf.timeoutMs() >= 0 ? (long)conf.timeoutMs() : Long.MAX_VALUE;
        KafkaConsumer consumer = new KafkaConsumer(this.consumerProps(conf), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        ConsoleConsumer.ConsumerWrapper consumerWrapper = conf.partitionArg().isDefined() ? new ConsoleConsumer.ConsumerWrapper((Option<String>)Option$.MODULE$.apply((Object)conf.topicArg()), conf.partitionArg(), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)conf.offsetArg())), (Option<String>)None$.MODULE$, (Consumer<byte[], byte[]>)consumer, timeoutMs) : new ConsoleConsumer.ConsumerWrapper((Option<String>)Option$.MODULE$.apply((Object)conf.topicArg()), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<String>)Option$.MODULE$.apply((Object)conf.whitelistArg()), (Consumer<byte[], byte[]>)consumer, timeoutMs);
        this.addShutdownHook(consumerWrapper, conf);
        try {
            this.process(Predef$.MODULE$.int2Integer(conf.maxMessages()), conf.formatter(), consumerWrapper, System.out, conf.skipMessageOnError());
        }
        finally {
            consumerWrapper.cleanup();
            conf.formatter().close();
            this.reportRecordCount();
            this.kafka$tools$ConsoleConsumer$$shutdownLatch().countDown();
        }
    }

    public void addShutdownHook(ConsoleConsumer.ConsumerWrapper consumer, ConsoleConsumer.ConsumerConfig conf) {
        Runtime.getRuntime().addShutdownHook(new Thread(consumer, conf){
            private final ConsoleConsumer.ConsumerWrapper consumer$1;
            private final ConsoleConsumer.ConsumerConfig conf$1;

            public void run() {
                block0: {
                    this.consumer$1.wakeup();
                    ConsoleConsumer$.MODULE$.kafka$tools$ConsoleConsumer$$shutdownLatch().await();
                    if (!this.conf$1.enableSystestEventsLogging()) break block0;
                    System.out.println("shutdown_complete");
                }
            }
            {
                this.consumer$1 = consumer$1;
                this.conf$1 = conf$1;
            }
        });
    }

    public void process(Integer maxMessages, MessageFormatter formatter, ConsoleConsumer.ConsumerWrapper consumer, PrintStream output, boolean skipMessageOnError) {
        while (this.messageCount() < Predef$.MODULE$.Integer2int(maxMessages) || BoxesRunTime.equalsNumObject((Number)maxMessages, (Object)BoxesRunTime.boxToInteger((int)-1))) {
            ConsumerRecord<byte[], byte[]> consumerRecord;
            try {
                consumerRecord = consumer.receive();
            }
            catch (WakeupException wakeupException) {
                this.trace((Function0<String>)(Function0 & Serializable)() -> "Caught WakeupException because consumer is shutdown, ignore and terminate.");
                return;
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable)() -> "Error processing message, terminating consumer process: ", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return;
            }
            ConsumerRecord<byte[], byte[]> msg = consumerRecord;
            this.messageCount_$eq(this.messageCount() + 1);
            try {
                formatter.writeTo((ConsumerRecord<byte[], byte[]>)new ConsumerRecord(msg.topic(), msg.partition(), msg.offset(), msg.timestamp(), msg.timestampType(), Predef$.MODULE$.long2Long(0L), 0, 0, msg.key(), msg.value(), msg.headers()), output);
            }
            catch (Throwable e) {
                if (skipMessageOnError) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Error processing message, skipping this message: ", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
                throw e;
            }
            if (!this.checkErr(output, formatter)) continue;
            return;
        }
    }

    public void reportRecordCount() {
        System.err.println(new StringBuilder(30).append("Processed a total of ").append(this.messageCount()).append(" messages").toString());
    }

    /*
     * WARNING - void declaration
     */
    public boolean checkErr(PrintStream output, MessageFormatter formatter) {
        void var3_3;
        block0: {
            boolean gotError = output.checkError();
            if (!gotError) break block0;
            System.err.println("Unable to write to standard out, closing consumer.");
        }
        return (boolean)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Properties consumerProps(ConsoleConsumer.ConsumerConfig config) {
        void var2_2;
        Properties props = new Properties();
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(config.consumerProps());
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(config.extraConsumerProps());
        this.setAutoOffsetResetValue(config, props);
        props.put("bootstrap.servers", config.bootstrapServer());
        CommandLineUtils$.MODULE$.maybeMergeOptions(props, "isolation.level", config.options(), config.isolationLevelOpt());
        return var2_2;
    }

    public void setAutoOffsetResetValue(ConsoleConsumer.ConsumerConfig config, Properties props) {
        Tuple2 tuple2 = new Tuple2((Object)"earliest", (Object)"latest");
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String earliestConfigValue = (String)tuple2._1();
        String latestConfigValue = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)earliestConfigValue, (Object)latestConfigValue);
        Tuple2 tuple23 = tuple22;
        String earliestConfigValue2 = (String)tuple23._1();
        String latestConfigValue2 = (String)tuple23._2();
        if (props.containsKey("auto.offset.reset")) {
            String autoResetOption = props.getProperty("auto.offset.reset");
            if (config.options().has((OptionSpec)config.resetBeginningOpt())) {
                String string = earliestConfigValue2;
                String string2 = autoResetOption;
                if (string == null ? string2 != null : !string.equals(string2)) {
                    System.err.println(new StringBuilder(24).append(new StringBuilder(72).append("Can't simultaneously specify --from-beginning and 'auto.offset.reset=").append(autoResetOption).append("', ").toString()).append("please remove one option").toString());
                    throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
                }
            }
        } else {
            String autoResetOption = config.options().has((OptionSpec)config.resetBeginningOpt()) ? earliestConfigValue2 : latestConfigValue2;
            props.put("auto.offset.reset", autoResetOption);
        }
    }

    private ConsoleConsumer$() {
    }
}

