/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSpec;
import kafka.admin.AclCommand;
import kafka.security.auth.Acl$;
import kafka.security.auth.All$;
import kafka.security.auth.Authorizer;
import kafka.security.auth.Operation$;
import kafka.security.auth.ResourceType$;
import kafka.security.auth.SimpleAclAuthorizer;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Utils;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.MapOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.SetOps;
import scala.collection.mutable.HashSet;
import scala.io.StdIn$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Properties$;

public final class AclCommand$
implements Logging {
    public static final AclCommand$ MODULE$ = new AclCommand$();
    private static final ResourcePatternFilter ClusterResourceFilter;
    private static final String kafka$admin$AclCommand$$Newline;
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
        ClusterResourceFilter = new ResourcePatternFilter(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL);
        kafka$admin$AclCommand$$Newline = Properties$.MODULE$.lineSeparator();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        AclCommand$ aclCommand$ = this;
        synchronized (aclCommand$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        return !bitmap$0 ? this.logger$lzycompute() : logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public ResourcePatternFilter ClusterResourceFilter() {
        return ClusterResourceFilter;
    }

    public String kafka$admin$AclCommand$$Newline() {
        return kafka$admin$AclCommand$$Newline;
    }

    public void main(String[] args) {
        AclCommand.AclCommandService aclCommandService;
        AclCommand.AclCommandOptions opts = new AclCommand.AclCommandOptions(args);
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, "This tool helps to manage acls on kafka.");
        opts.checkArgs();
        if (opts.options().has(opts.bootstrapServerOpt())) {
            aclCommandService = new AclCommand.AdminClientService(opts);
        } else {
            Class<SimpleAclAuthorizer> authorizerClass;
            Class clazz;
            if (opts.options().has(opts.authorizerOpt())) {
                String className = (String)opts.options().valueOf(opts.authorizerOpt());
                clazz = Class.forName(className, true, Utils.getContextOrKafkaClassLoader());
            } else {
                clazz = authorizerClass = SimpleAclAuthorizer.class;
            }
            if (org.apache.kafka.server.authorizer.Authorizer.class.isAssignableFrom(authorizerClass)) {
                aclCommandService = new AclCommand.JAuthorizerService(authorizerClass.asSubclass(org.apache.kafka.server.authorizer.Authorizer.class), opts);
            } else if (Authorizer.class.isAssignableFrom(authorizerClass)) {
                aclCommandService = new AclCommand.AuthorizerService(authorizerClass.asSubclass(Authorizer.class), opts);
            } else {
                throw new IllegalArgumentException(new StringBuilder(36).append("Authorizer ").append(authorizerClass).append(" does not implement ").append(Authorizer.class).append(" or ").append(org.apache.kafka.server.authorizer.Authorizer.class).append(".").toString());
            }
        }
        AclCommand.AdminClientService aclCommandService2 = aclCommandService;
        try {
            if (opts.options().has((OptionSpec)opts.addOpt())) {
                ((AclCommand.AclCommandService)aclCommandService2).addAcls();
            } else if (opts.options().has((OptionSpec)opts.removeOpt())) {
                ((AclCommand.AclCommandService)aclCommandService2).removeAcls();
            } else if (opts.options().has((OptionSpec)opts.listOpt())) {
                ((AclCommand.AclCommandService)aclCommandService2).listAcls();
            }
        }
        catch (Throwable e) {
            Predef$.MODULE$.println((Object)new StringBuilder(35).append("Error while executing ACL command: ").append(e.getMessage()).toString());
            Predef$.MODULE$.println((Object)Utils.stackTrace((Throwable)e));
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
    }

    /*
     * WARNING - void declaration
     */
    public Map<ResourcePattern, Set<AccessControlEntry>> kafka$admin$AclCommand$$getResourceToAcls(AclCommand.AclCommandOptions opts) {
        void var3_3;
        PatternType patternType = (PatternType)opts.options().valueOf(opts.resourcePatternType());
        if (!patternType.isSpecific()) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), new StringBuilder(70).append("A '--resource-pattern-type' value of '").append(patternType).append("' is not valid when adding acls.").toString());
        }
        Map resourceToAcl = (Map)this.kafka$admin$AclCommand$$getResourceFilterToAcls(opts).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ResourcePatternFilter filter = (ResourcePatternFilter)tuple2._1();
            Set acls = (Set)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(filter.resourceType(), filter.name(), filter.patternType())), (Object)acls);
            return tuple22;
        });
        if (resourceToAcl.values().exists((Function1 & Serializable)x$31 -> BoxesRunTime.boxToBoolean((boolean)x$31.isEmpty()))) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "You must specify one of: --allow-principal, --deny-principal when trying to add ACLs.");
        }
        return var3_3;
    }

    public Map<ResourcePatternFilter, Set<AccessControlEntry>> kafka$admin$AclCommand$$getResourceFilterToAcls(AclCommand.AclCommandOptions opts) {
        ObjectRef resourceToAcls = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        if (!opts.options().has((OptionSpec)opts.producerOpt()) && !opts.options().has((OptionSpec)opts.consumerOpt())) {
            resourceToAcls.elem = (Map)((Map)resourceToAcls.elem).$plus$plus(this.getCliResourceFilterToAcls(opts));
        }
        if (opts.options().has((OptionSpec)opts.producerOpt())) {
            resourceToAcls.elem = (Map)((Map)resourceToAcls.elem).$plus$plus(this.getProducerResourceFilterToAcls(opts));
        }
        if (opts.options().has((OptionSpec)opts.consumerOpt())) {
            resourceToAcls.elem = (Map)((Map)resourceToAcls.elem).$plus$plus((IterableOnce)this.getConsumerResourceFilterToAcls(opts).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ResourcePatternFilter k = (ResourcePatternFilter)tuple2._1();
                Set v = (Set)tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.$plus$plus((IterableOnce)((Map)resourceToAcls$5.elem).getOrElse((Object)k, (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty())));
                return tuple22;
            }));
        }
        this.validateOperation(opts, (Map<ResourcePatternFilter, Set<AccessControlEntry>>)((Map)resourceToAcls.elem));
        return (Map)resourceToAcls.elem;
    }

    private Map<ResourcePatternFilter, Set<AccessControlEntry>> getProducerResourceFilterToAcls(AclCommand.AclCommandOptions opts) {
        Set<ResourcePatternFilter> filters = this.kafka$admin$AclCommand$$getResourceFilter(opts, this.getResourceFilter$default$2());
        Set topics = (Set)filters.filter((Function1 & Serializable)x$32 -> BoxesRunTime.boxToBoolean((boolean)AclCommand$.$anonfun$getProducerResourceFilterToAcls$1(x$32)));
        Set transactionalIds = (Set)filters.filter((Function1 & Serializable)x$33 -> BoxesRunTime.boxToBoolean((boolean)AclCommand$.$anonfun$getProducerResourceFilterToAcls$2(x$33)));
        boolean enableIdempotence = opts.options().has((OptionSpec)opts.idempotentOpt());
        Set<AccessControlEntry> topicAcls = this.getAcl(opts, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.WRITE, AclOperation.DESCRIBE, AclOperation.CREATE}))));
        Set<AccessControlEntry> transactionalIdAcls = this.getAcl(opts, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.WRITE, AclOperation.DESCRIBE}))));
        return (Map)((MapOps)((IterableOnceOps)topics.map((Function1 & Serializable)x$34 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$34), (Object)topicAcls))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus$plus((IterableOnce)((IterableOnceOps)transactionalIds.map((Function1 & Serializable)x$35 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$35), (Object)transactionalIdAcls))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))).$plus$plus((IterableOnce)(enableIdempotence ? (IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ClusterResourceFilter()), this.getAcl(opts, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.IDEMPOTENT_WRITE})))))})) : Predef$.MODULE$.Map().empty()));
    }

    private Map<ResourcePatternFilter, Set<AccessControlEntry>> getConsumerResourceFilterToAcls(AclCommand.AclCommandOptions opts) {
        Set<ResourcePatternFilter> filters = this.kafka$admin$AclCommand$$getResourceFilter(opts, this.getResourceFilter$default$2());
        Set topics = (Set)filters.filter((Function1 & Serializable)x$36 -> BoxesRunTime.boxToBoolean((boolean)AclCommand$.$anonfun$getConsumerResourceFilterToAcls$1(x$36)));
        Set groups = (Set)filters.filter((Function1 & Serializable)x$37 -> BoxesRunTime.boxToBoolean((boolean)AclCommand$.$anonfun$getConsumerResourceFilterToAcls$2(x$37)));
        Set<AccessControlEntry> acls = this.getAcl(opts, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.DESCRIBE}))));
        return (Map)((IterableOnceOps)topics.map((Function1 & Serializable)x$38 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$38), (Object)acls))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus$plus((IterableOnce)((IterableOnceOps)groups.map((Function1 & Serializable)x$39 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$39), MODULE$.getAcl(opts, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ}))))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private Map<ResourcePatternFilter, Set<AccessControlEntry>> getCliResourceFilterToAcls(AclCommand.AclCommandOptions opts) {
        Set<AccessControlEntry> acls = this.getAcl(opts);
        Set<ResourcePatternFilter> filters = this.kafka$admin$AclCommand$$getResourceFilter(opts, this.getResourceFilter$default$2());
        return ((IterableOnceOps)filters.map((Function1 & Serializable)x$40 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$40), (Object)acls))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Set<AccessControlEntry> getAcl(AclCommand.AclCommandOptions opts, Set<AclOperation> operations) {
        Set<KafkaPrincipal> allowedPrincipals = this.kafka$admin$AclCommand$$getPrincipals(opts, opts.allowPrincipalsOpt());
        Set<KafkaPrincipal> deniedPrincipals = this.kafka$admin$AclCommand$$getPrincipals(opts, opts.denyPrincipalsOpt());
        Set<String> allowedHosts = this.getHosts(opts, opts.allowHostsOpt(), opts.allowPrincipalsOpt());
        Set<String> deniedHosts = this.getHosts(opts, opts.denyHostsOpt(), opts.denyPrincipalsOpt());
        HashSet acls = new HashSet();
        Object object = allowedHosts.nonEmpty() && allowedPrincipals.nonEmpty() ? acls.$plus$plus$eq(this.getAcls(allowedPrincipals, AclPermissionType.ALLOW, operations, allowedHosts)) : BoxedUnit.UNIT;
        Object object2 = deniedHosts.nonEmpty() && deniedPrincipals.nonEmpty() ? acls.$plus$plus$eq(this.getAcls(deniedPrincipals, AclPermissionType.DENY, operations, deniedHosts)) : BoxedUnit.UNIT;
        return acls.toSet();
    }

    private Set<AccessControlEntry> getAcl(AclCommand.AclCommandOptions opts) {
        Set operations = ((IterableOnceOps)((IterableOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.operationsOpt())).asScala()).map((Function1 & Serializable)operation -> Operation$.MODULE$.fromString(operation.trim()))).map((Function1 & Serializable)x$41 -> x$41.toJava())).toSet();
        return this.getAcl(opts, (Set<AclOperation>)operations);
    }

    public Set<AccessControlEntry> getAcls(Set<KafkaPrincipal> principals, AclPermissionType permissionType, Set<AclOperation> operations, Set<String> hosts) {
        return (Set)principals.flatMap((Function1 & Serializable)principal -> (Set)operations.flatMap((Function1 & Serializable)operation -> (Set)hosts.map((Function1 & Serializable)host -> new AccessControlEntry(principal.toString(), host, operation, permissionType))));
    }

    private Set<String> getHosts(AclCommand.AclCommandOptions opts, ArgumentAcceptingOptionSpec<String> hostOptionSpec, ArgumentAcceptingOptionSpec<String> principalOptionSpec) {
        return opts.options().has(hostOptionSpec) ? ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(hostOptionSpec)).asScala()).map((Function1 & Serializable)x$42 -> x$42.trim())).toSet() : (opts.options().has(principalOptionSpec) ? (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Acl$.MODULE$.WildCardHost()})) : Predef$.MODULE$.Set().empty());
    }

    public Set<KafkaPrincipal> kafka$admin$AclCommand$$getPrincipals(AclCommand.AclCommandOptions opts, ArgumentAcceptingOptionSpec<String> principalOptionSpec) {
        return opts.options().has(principalOptionSpec) ? ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(principalOptionSpec)).asScala()).map((Function1 & Serializable)s -> SecurityUtils.parseKafkaPrincipal((String)s.trim()))).toSet() : Predef$.MODULE$.Set().empty();
    }

    public Set<ResourcePatternFilter> kafka$admin$AclCommand$$getResourceFilter(AclCommand.AclCommandOptions opts, boolean dieIfNoResourceFound) {
        PatternType patternType = (PatternType)opts.options().valueOf(opts.resourcePatternType());
        ObjectRef resourceFilters = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        if (opts.options().has(opts.topicOpt())) {
            ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.topicOpt())).asScala()).foreach((Function1 & Serializable)topic -> {
                resourceFilters.elem = (Set)((Set)resourceFilters.elem).$plus((Object)new ResourcePatternFilter(ResourceType.TOPIC, topic.trim(), patternType));
                return BoxedUnit.UNIT;
            });
        }
        PatternType patternType2 = patternType;
        PatternType patternType3 = PatternType.LITERAL;
        if (!(patternType2 != null ? !patternType2.equals(patternType3) : patternType3 != null)) {
            if (opts.options().has((OptionSpec)opts.clusterOpt()) || opts.options().has((OptionSpec)opts.idempotentOpt())) {
                resourceFilters.elem = (Set)((Set)resourceFilters.elem).$plus((Object)this.ClusterResourceFilter());
            }
        }
        if (opts.options().has(opts.groupOpt())) {
            ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.groupOpt())).asScala()).foreach((Function1 & Serializable)group -> {
                resourceFilters.elem = (Set)((Set)resourceFilters.elem).$plus((Object)new ResourcePatternFilter(ResourceType.GROUP, group.trim(), patternType));
                return BoxedUnit.UNIT;
            });
        }
        if (opts.options().has(opts.transactionalIdOpt())) {
            ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.transactionalIdOpt())).asScala()).foreach((Function1 & Serializable)transactionalId -> {
                resourceFilters.elem = (Set)((Set)resourceFilters.elem).$plus((Object)new ResourcePatternFilter(ResourceType.TRANSACTIONAL_ID, transactionalId, patternType));
                return BoxedUnit.UNIT;
            });
        }
        if (opts.options().has(opts.delegationTokenOpt())) {
            ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.delegationTokenOpt())).asScala()).foreach((Function1 & Serializable)token -> {
                resourceFilters.elem = (Set)((Set)resourceFilters.elem).$plus((Object)new ResourcePatternFilter(ResourceType.DELEGATION_TOKEN, token.trim(), patternType));
                return BoxedUnit.UNIT;
            });
        }
        if (((Set)resourceFilters.elem).isEmpty() && dieIfNoResourceFound) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "You must provide at least one resource: --topic <topic> or --cluster or --group <group> or --delegation-token <Delegation Token ID>");
        }
        return (Set)resourceFilters.elem;
    }

    private boolean getResourceFilter$default$2() {
        return true;
    }

    public boolean kafka$admin$AclCommand$$confirmAction(AclCommand.AclCommandOptions opts, String msg) {
        if (opts.options().has((OptionSpec)opts.forceOpt())) {
            return true;
        }
        Predef$.MODULE$.println((Object)msg);
        return StdIn$.MODULE$.readLine().equalsIgnoreCase("y");
    }

    private void validateOperation(AclCommand.AclCommandOptions opts, Map<ResourcePatternFilter, Set<AccessControlEntry>> resourceToAcls) {
        resourceToAcls.withFilter((Function1 & Serializable)check$ifrefutable$13 -> BoxesRunTime.boxToBoolean((boolean)AclCommand$.$anonfun$validateOperation$1(check$ifrefutable$13))).foreach((Function1 & Serializable)x$45 -> {
            AclCommand$.$anonfun$validateOperation$2(opts, x$45);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getProducerResourceFilterToAcls$1(ResourcePatternFilter x$32) {
        ResourceType resourceType = x$32.resourceType();
        ResourceType resourceType2 = ResourceType.TOPIC;
        return !(resourceType != null ? !resourceType.equals(resourceType2) : resourceType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getProducerResourceFilterToAcls$2(ResourcePatternFilter x$33) {
        ResourceType resourceType = x$33.resourceType();
        ResourceType resourceType2 = ResourceType.TRANSACTIONAL_ID;
        return !(resourceType != null ? !resourceType.equals(resourceType2) : resourceType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConsumerResourceFilterToAcls$1(ResourcePatternFilter x$36) {
        ResourceType resourceType = x$36.resourceType();
        ResourceType resourceType2 = ResourceType.TOPIC;
        return !(resourceType != null ? !resourceType.equals(resourceType2) : resourceType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConsumerResourceFilterToAcls$2(ResourcePatternFilter x$37) {
        ResourceType resourceType = x$37.resourceType();
        ResourceType resourceType2 = ResourceType.GROUP;
        return !(resourceType != null ? !resourceType.equals(resourceType2) : resourceType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateOperation$1(Tuple2 check$ifrefutable$13) {
        Tuple2 tuple2 = check$ifrefutable$13;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$validateOperation$2(AclCommand.AclCommandOptions opts$2, Tuple2 x$45) {
        Tuple2 tuple2 = x$45;
        if (tuple2 != null) {
            ResourcePatternFilter resource = (ResourcePatternFilter)tuple2._1();
            Set acls = (Set)tuple2._2();
            Set validOps = (Set)ResourceType$.MODULE$.fromJava(resource.resourceType()).supportedOperations().$plus((Object)All$.MODULE$);
            if (((SetOps)acls.map((Function1 & Serializable)x$43 -> x$43.operation())).$minus$minus((IterableOnce)validOps.map((Function1 & Serializable)x$44 -> x$44.toJava())).nonEmpty()) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(opts$2.parser(), new StringBuilder(39).append("ResourceType ").append(resource.resourceType()).append(" only supports operations ").append(validOps.mkString(",")).toString());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private AclCommand$() {
    }
}

