/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Random;
import kafka.admin.AdminOperationException;
import kafka.admin.BrokerMetadata;
import kafka.utils.Logging;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeq;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class AdminUtils$
implements Logging {
    public static final AdminUtils$ MODULE$ = new AdminUtils$();
    private static final Random rand;
    private static final String AdminClientId;
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
        rand = new Random();
        AdminClientId = "__admin_client";
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        AdminUtils$ adminUtils$ = this;
        synchronized (adminUtils$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        return !bitmap$0 ? this.logger$lzycompute() : logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public Random rand() {
        return rand;
    }

    public String AdminClientId() {
        return AdminClientId;
    }

    public Map<Object, Seq<Object>> assignReplicasToBrokers(Seq<BrokerMetadata> brokerMetadatas, int nPartitions, int replicationFactor, int fixedStartIndex, int startPartitionId) {
        Map<Object, Seq<Object>> map;
        if (nPartitions <= 0) {
            throw new InvalidPartitionsException("Number of partitions must be larger than 0.");
        }
        if (replicationFactor <= 0) {
            throw new InvalidReplicationFactorException("Replication factor must be larger than 0.");
        }
        if (replicationFactor > brokerMetadatas.size()) {
            throw new InvalidReplicationFactorException(new StringBuilder(53).append("Replication factor: ").append(replicationFactor).append(" larger than available brokers: ").append(brokerMetadatas.size()).append(".").toString());
        }
        if (brokerMetadatas.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AdminUtils$.$anonfun$assignReplicasToBrokers$1(x$1)))) {
            map = this.assignReplicasToBrokersRackUnaware(nPartitions, replicationFactor, (Seq<Object>)((Seq)brokerMetadatas.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()))), fixedStartIndex, startPartitionId);
        } else {
            if (brokerMetadatas.exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AdminUtils$.$anonfun$assignReplicasToBrokers$3(x$3)))) {
                throw new AdminOperationException("Not all brokers have rack information for replica rack aware assignment.");
            }
            map = this.assignReplicasToBrokersRackAware(nPartitions, replicationFactor, brokerMetadatas, fixedStartIndex, startPartitionId);
        }
        return map;
    }

    public int assignReplicasToBrokers$default$4() {
        return -1;
    }

    public int assignReplicasToBrokers$default$5() {
        return -1;
    }

    private Map<Object, Seq<Object>> assignReplicasToBrokersRackUnaware(int nPartitions, int replicationFactor, Seq<Object> brokerList, int fixedStartIndex, int startPartitionId) {
        scala.collection.mutable.Map ret = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        int[] brokerArray = (int[])brokerList.toArray((ClassTag)ClassTag$.MODULE$.Int());
        int startIndex = fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(brokerArray.length);
        IntRef currentPartitionId = IntRef.create((int)package$.MODULE$.max(0, startPartitionId));
        IntRef nextReplicaShift = IntRef.create((int)(fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(brokerArray.length)));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), nPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> {
            int n = x$4;
            if (currentPartitionId$1.elem > 0 && currentPartitionId$1.elem % brokerArray.length == 0) {
                ++nextReplicaShift$1.elem;
            }
            int firstReplicaIndex = (currentPartitionId$1.elem + startIndex) % brokerArray.length;
            ArrayBuffer replicaBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerArray[firstReplicaIndex]}));
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), replicationFactor - 1).foreach((Function1 & Serializable)j -> AdminUtils$.$anonfun$assignReplicasToBrokersRackUnaware$2(replicaBuffer, brokerArray, firstReplicaIndex, nextReplicaShift, BoxesRunTime.unboxToInt((Object)j)));
            ret.put((Object)BoxesRunTime.boxToInteger((int)currentPartitionId$1.elem), (Object)replicaBuffer);
            ++currentPartitionId$1.elem;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
        return ret;
    }

    private Map<Object, Seq<Object>> assignReplicasToBrokersRackAware(int nPartitions, int replicationFactor, Seq<BrokerMetadata> brokerMetadatas, int fixedStartIndex, int startPartitionId) {
        scala.collection.immutable.Map brokerRackMap = ((IterableOnceOps)brokerMetadatas.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends BrokerMetadata, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    int id = A1.id();
                    Option<String> option = A1.rack();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        String rack = (String)some.value();
                        object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)id)), (Object)rack);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(BrokerMetadata x1) {
                Option<String> option;
                BrokerMetadata brokerMetadata = x1;
                boolean bl = brokerMetadata != null && (option = brokerMetadata.rack()) instanceof Some;
                return bl;
            }
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        int numRacks = brokerRackMap.values().toSet().size();
        IndexedSeq<Object> arrangedBrokerList = this.getRackAlternatedBrokerList((Map<Object, String>)brokerRackMap);
        int numBrokers = arrangedBrokerList.size();
        scala.collection.mutable.Map ret = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        int startIndex = fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(arrangedBrokerList.size());
        IntRef currentPartitionId = IntRef.create((int)package$.MODULE$.max(0, startPartitionId));
        IntRef nextReplicaShift = IntRef.create((int)(fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(arrangedBrokerList.size())));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), nPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$6 -> {
            int n = x$6;
            if (currentPartitionId$2.elem > 0 && currentPartitionId$2.elem % arrangedBrokerList.size() == 0) {
                ++nextReplicaShift$2.elem;
            }
            int firstReplicaIndex = (currentPartitionId$2.elem + startIndex) % arrangedBrokerList.size();
            int leader = BoxesRunTime.unboxToInt((Object)arrangedBrokerList.apply(firstReplicaIndex));
            ArrayBuffer replicaBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leader}));
            Set racksWithReplicas = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)brokerRackMap.apply((Object)BoxesRunTime.boxToInteger((int)leader))}));
            Set brokersWithReplicas = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leader}));
            IntRef k = IntRef.create((int)0);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), replicationFactor - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> {
                int n = x$5;
                boolean done = false;
                while (!done) {
                    int broker = BoxesRunTime.unboxToInt((Object)arrangedBrokerList.apply(MODULE$.replicaIndex(firstReplicaIndex, nextReplicaShift$2.elem * numRacks, k$1.elem, arrangedBrokerList.size())));
                    String rack = (String)brokerRackMap.apply((Object)BoxesRunTime.boxToInteger((int)broker));
                    if (!(racksWithReplicas.contains((Object)rack) && racksWithReplicas.size() != numRacks || brokersWithReplicas.contains((Object)BoxesRunTime.boxToInteger((int)broker)) && brokersWithReplicas.size() != numBrokers)) {
                        replicaBuffer.$plus$eq((Object)BoxesRunTime.boxToInteger((int)broker));
                        racksWithReplicas.$plus$eq((Object)rack);
                        brokersWithReplicas.$plus$eq((Object)BoxesRunTime.boxToInteger((int)broker));
                        done = true;
                    }
                    ++k$1.elem;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
            ret.put((Object)BoxesRunTime.boxToInteger((int)currentPartitionId$2.elem), (Object)replicaBuffer);
            ++currentPartitionId$2.elem;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
        return ret;
    }

    public IndexedSeq<Object> getRackAlternatedBrokerList(Map<Object, String> brokerRackMap) {
        Map brokersIteratorByRack = (Map)this.getInverseMap(brokerRackMap).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String rack = (String)tuple2._1();
            Seq brokers = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)rack, (Object)brokers.toIterator());
            return tuple22;
        });
        String[] racks = (String[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.refArrayOps((Object[])brokersIteratorByRack.keys().toArray(ClassTag$.MODULE$.apply(String.class))), (Ordering)Ordering.String$.MODULE$);
        ArrayBuffer result = new ArrayBuffer();
        int rackIndex = 0;
        while (result.size() < brokerRackMap.size()) {
            Iterator rackIterator = (Iterator)brokersIteratorByRack.apply((Object)racks[rackIndex]);
            Object object = rackIterator.hasNext() ? result.$plus$eq(rackIterator.next()) : BoxedUnit.UNIT;
            rackIndex = (rackIndex + 1) % racks.length;
        }
        return result;
    }

    public Map<String, Seq<Object>> getInverseMap(Map<Object, String> brokerRackMap) {
        return (Map)((IterableOps)brokerRackMap.toSeq().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int id = tuple2._1$mcI$sp();
            String rack = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)rack, (Object)BoxesRunTime.boxToInteger((int)id));
            return tuple22;
        })).groupBy((Function1 & Serializable)x0$2 -> {
            String rack;
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String string = rack = (String)tuple2._1();
            return string;
        }).map((Function1 & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String rack = (String)tuple2._1();
            scala.collection.immutable.Seq rackAndIdList = (scala.collection.immutable.Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)rack, ((SeqOps)rackAndIdList.map((Function1 & Serializable)x0$4 -> BoxesRunTime.boxToInteger((int)AdminUtils$.$anonfun$getInverseMap$4(x0$4)))).sorted((Ordering)Ordering.Int$.MODULE$));
            return tuple22;
        });
    }

    private int replicaIndex(int firstReplicaIndex, int secondReplicaShift, int replicaIndex, int nBrokers) {
        int shift = 1 + (secondReplicaShift + replicaIndex) % (nBrokers - 1);
        return (firstReplicaIndex + shift) % nBrokers;
    }

    public static final /* synthetic */ boolean $anonfun$assignReplicasToBrokers$1(BrokerMetadata x$1) {
        return x$1.rack().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$assignReplicasToBrokers$3(BrokerMetadata x$3) {
        return x$3.rack().isEmpty();
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$assignReplicasToBrokersRackUnaware$2(ArrayBuffer replicaBuffer$1, int[] brokerArray$1, int firstReplicaIndex$1, IntRef nextReplicaShift$1, int j) {
        return (ArrayBuffer)replicaBuffer$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)brokerArray$1[MODULE$.replicaIndex(firstReplicaIndex$1, nextReplicaShift$1.elem, j, brokerArray$1.length)]));
    }

    public static final /* synthetic */ int $anonfun$getInverseMap$4(Tuple2 x0$4) {
        int id;
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int n = id = tuple2._2$mcI$sp();
        return n;
    }

    private AdminUtils$() {
    }
}

