/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Optional;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_0_10_1_IV0$;
import kafka.api.KAFKA_2_1_IV0$;
import kafka.api.KAFKA_2_1_IV1$;
import kafka.api.KAFKA_2_3_IV0$;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.coordinator.group.BaseKey;
import kafka.coordinator.group.Empty$;
import kafka.coordinator.group.GroupMetadata;
import kafka.coordinator.group.GroupMetadata$;
import kafka.coordinator.group.GroupMetadataKey;
import kafka.coordinator.group.GroupState;
import kafka.coordinator.group.GroupTopicPartition;
import kafka.coordinator.group.MemberMetadata;
import kafka.coordinator.group.OffsetKey;
import kafka.coordinator.group.Stable$;
import kafka.utils.Json$;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.BoundField;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class GroupMetadataManager$ {
    public static final GroupMetadataManager$ MODULE$ = new GroupMetadataManager$();
    private static final short CURRENT_OFFSET_KEY_SCHEMA_VERSION = (short)1;
    private static final short CURRENT_GROUP_KEY_SCHEMA_VERSION = (short)2;
    private static final Schema OFFSET_COMMIT_KEY_SCHEMA = new Schema(new Field[]{new Field("group", (Type)Type.STRING), new Field("topic", (Type)Type.STRING), new Field("partition", (Type)Type.INT32)});
    private static final BoundField OFFSET_KEY_GROUP_FIELD = MODULE$.OFFSET_COMMIT_KEY_SCHEMA().get("group");
    private static final BoundField OFFSET_KEY_TOPIC_FIELD = MODULE$.OFFSET_COMMIT_KEY_SCHEMA().get("topic");
    private static final BoundField OFFSET_KEY_PARTITION_FIELD = MODULE$.OFFSET_COMMIT_KEY_SCHEMA().get("partition");
    private static final Schema OFFSET_COMMIT_VALUE_SCHEMA_V0 = new Schema(new Field[]{new Field("offset", (Type)Type.INT64), new Field("metadata", (Type)Type.STRING, "Associated metadata.", (Object)""), new Field("timestamp", (Type)Type.INT64)});
    private static final BoundField OFFSET_VALUE_OFFSET_FIELD_V0 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V0().get("offset");
    private static final BoundField OFFSET_VALUE_METADATA_FIELD_V0 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V0().get("metadata");
    private static final BoundField OFFSET_VALUE_TIMESTAMP_FIELD_V0 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V0().get("timestamp");
    private static final Schema OFFSET_COMMIT_VALUE_SCHEMA_V1 = new Schema(new Field[]{new Field("offset", (Type)Type.INT64), new Field("metadata", (Type)Type.STRING, "Associated metadata.", (Object)""), new Field("commit_timestamp", (Type)Type.INT64), new Field("expire_timestamp", (Type)Type.INT64)});
    private static final BoundField OFFSET_VALUE_OFFSET_FIELD_V1 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V1().get("offset");
    private static final BoundField OFFSET_VALUE_METADATA_FIELD_V1 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V1().get("metadata");
    private static final BoundField OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V1().get("commit_timestamp");
    private static final BoundField OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V1().get("expire_timestamp");
    private static final Schema OFFSET_COMMIT_VALUE_SCHEMA_V2 = new Schema(new Field[]{new Field("offset", (Type)Type.INT64), new Field("metadata", (Type)Type.STRING, "Associated metadata.", (Object)""), new Field("commit_timestamp", (Type)Type.INT64)});
    private static final BoundField OFFSET_VALUE_OFFSET_FIELD_V2 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V2().get("offset");
    private static final BoundField OFFSET_VALUE_METADATA_FIELD_V2 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V2().get("metadata");
    private static final BoundField OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V2 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V2().get("commit_timestamp");
    private static final Schema OFFSET_COMMIT_VALUE_SCHEMA_V3 = new Schema(new Field[]{new Field("offset", (Type)Type.INT64), new Field("leader_epoch", (Type)Type.INT32), new Field("metadata", (Type)Type.STRING, "Associated metadata.", (Object)""), new Field("commit_timestamp", (Type)Type.INT64)});
    private static final BoundField OFFSET_VALUE_OFFSET_FIELD_V3 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V3().get("offset");
    private static final BoundField OFFSET_VALUE_LEADER_EPOCH_FIELD_V3 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V3().get("leader_epoch");
    private static final BoundField OFFSET_VALUE_METADATA_FIELD_V3 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V3().get("metadata");
    private static final BoundField OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V3 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V3().get("commit_timestamp");
    private static final Schema GROUP_METADATA_KEY_SCHEMA = new Schema(new Field[]{new Field("group", (Type)Type.STRING)});
    private static final BoundField GROUP_KEY_GROUP_FIELD = MODULE$.GROUP_METADATA_KEY_SCHEMA().get("group");
    private static final String MEMBER_ID_KEY = "member_id";
    private static final String GROUP_INSTANCE_ID_KEY = "group_instance_id";
    private static final String CLIENT_ID_KEY = "client_id";
    private static final String CLIENT_HOST_KEY = "client_host";
    private static final String REBALANCE_TIMEOUT_KEY = "rebalance_timeout";
    private static final String SESSION_TIMEOUT_KEY = "session_timeout";
    private static final String SUBSCRIPTION_KEY = "subscription";
    private static final String ASSIGNMENT_KEY = "assignment";
    private static final Schema MEMBER_METADATA_V0 = new Schema(new Field[]{new Field(MODULE$.MEMBER_ID_KEY(), (Type)Type.STRING), new Field(MODULE$.CLIENT_ID_KEY(), (Type)Type.STRING), new Field(MODULE$.CLIENT_HOST_KEY(), (Type)Type.STRING), new Field(MODULE$.SESSION_TIMEOUT_KEY(), (Type)Type.INT32), new Field(MODULE$.SUBSCRIPTION_KEY(), (Type)Type.BYTES), new Field(MODULE$.ASSIGNMENT_KEY(), (Type)Type.BYTES)});
    private static final Schema MEMBER_METADATA_V1 = new Schema(new Field[]{new Field(MODULE$.MEMBER_ID_KEY(), (Type)Type.STRING), new Field(MODULE$.CLIENT_ID_KEY(), (Type)Type.STRING), new Field(MODULE$.CLIENT_HOST_KEY(), (Type)Type.STRING), new Field(MODULE$.REBALANCE_TIMEOUT_KEY(), (Type)Type.INT32), new Field(MODULE$.SESSION_TIMEOUT_KEY(), (Type)Type.INT32), new Field(MODULE$.SUBSCRIPTION_KEY(), (Type)Type.BYTES), new Field(MODULE$.ASSIGNMENT_KEY(), (Type)Type.BYTES)});
    private static final Schema MEMBER_METADATA_V2 = MODULE$.MEMBER_METADATA_V1();
    private static final Schema MEMBER_METADATA_V3 = new Schema(new Field[]{new Field(MODULE$.MEMBER_ID_KEY(), (Type)Type.STRING), new Field(MODULE$.GROUP_INSTANCE_ID_KEY(), (Type)Type.NULLABLE_STRING), new Field(MODULE$.CLIENT_ID_KEY(), (Type)Type.STRING), new Field(MODULE$.CLIENT_HOST_KEY(), (Type)Type.STRING), new Field(MODULE$.REBALANCE_TIMEOUT_KEY(), (Type)Type.INT32), new Field(MODULE$.SESSION_TIMEOUT_KEY(), (Type)Type.INT32), new Field(MODULE$.SUBSCRIPTION_KEY(), (Type)Type.BYTES), new Field(MODULE$.ASSIGNMENT_KEY(), (Type)Type.BYTES)});
    private static final String PROTOCOL_TYPE_KEY = "protocol_type";
    private static final String GENERATION_KEY = "generation";
    private static final String PROTOCOL_KEY = "protocol";
    private static final String LEADER_KEY = "leader";
    private static final String CURRENT_STATE_TIMESTAMP_KEY = "current_state_timestamp";
    private static final String MEMBERS_KEY = "members";
    private static final Schema GROUP_METADATA_VALUE_SCHEMA_V0 = new Schema(new Field[]{new Field(MODULE$.PROTOCOL_TYPE_KEY(), (Type)Type.STRING), new Field(MODULE$.GENERATION_KEY(), (Type)Type.INT32), new Field(MODULE$.PROTOCOL_KEY(), (Type)Type.NULLABLE_STRING), new Field(MODULE$.LEADER_KEY(), (Type)Type.NULLABLE_STRING), new Field(MODULE$.MEMBERS_KEY(), (Type)new ArrayOf((Type)MODULE$.MEMBER_METADATA_V0()))});
    private static final Schema GROUP_METADATA_VALUE_SCHEMA_V1 = new Schema(new Field[]{new Field(MODULE$.PROTOCOL_TYPE_KEY(), (Type)Type.STRING), new Field(MODULE$.GENERATION_KEY(), (Type)Type.INT32), new Field(MODULE$.PROTOCOL_KEY(), (Type)Type.NULLABLE_STRING), new Field(MODULE$.LEADER_KEY(), (Type)Type.NULLABLE_STRING), new Field(MODULE$.MEMBERS_KEY(), (Type)new ArrayOf((Type)MODULE$.MEMBER_METADATA_V1()))});
    private static final Schema GROUP_METADATA_VALUE_SCHEMA_V2 = new Schema(new Field[]{new Field(MODULE$.PROTOCOL_TYPE_KEY(), (Type)Type.STRING), new Field(MODULE$.GENERATION_KEY(), (Type)Type.INT32), new Field(MODULE$.PROTOCOL_KEY(), (Type)Type.NULLABLE_STRING), new Field(MODULE$.LEADER_KEY(), (Type)Type.NULLABLE_STRING), new Field(MODULE$.CURRENT_STATE_TIMESTAMP_KEY(), (Type)Type.INT64), new Field(MODULE$.MEMBERS_KEY(), (Type)new ArrayOf((Type)MODULE$.MEMBER_METADATA_V2()))});
    private static final Schema GROUP_METADATA_VALUE_SCHEMA_V3 = new Schema(new Field[]{new Field(MODULE$.PROTOCOL_TYPE_KEY(), (Type)Type.STRING), new Field(MODULE$.GENERATION_KEY(), (Type)Type.INT32), new Field(MODULE$.PROTOCOL_KEY(), (Type)Type.NULLABLE_STRING), new Field(MODULE$.LEADER_KEY(), (Type)Type.NULLABLE_STRING), new Field(MODULE$.CURRENT_STATE_TIMESTAMP_KEY(), (Type)Type.INT64), new Field(MODULE$.MEMBERS_KEY(), (Type)new ArrayOf((Type)MODULE$.MEMBER_METADATA_V3()))});
    private static final Map<Object, Schema> MESSAGE_TYPE_SCHEMAS = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)MODULE$.OFFSET_COMMIT_KEY_SCHEMA()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)MODULE$.OFFSET_COMMIT_KEY_SCHEMA()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)MODULE$.GROUP_METADATA_KEY_SCHEMA())}));
    private static final Map<Object, Schema> OFFSET_VALUE_SCHEMAS = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V0()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V1()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V2()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V3())}));
    private static final Map<Object, Schema> GROUP_VALUE_SCHEMAS = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)MODULE$.GROUP_METADATA_VALUE_SCHEMA_V0()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)MODULE$.GROUP_METADATA_VALUE_SCHEMA_V1()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)MODULE$.GROUP_METADATA_VALUE_SCHEMA_V2()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)MODULE$.GROUP_METADATA_VALUE_SCHEMA_V3())}));
    private static final Schema CURRENT_OFFSET_KEY_SCHEMA = MODULE$.schemaForKey(MODULE$.CURRENT_OFFSET_KEY_SCHEMA_VERSION());
    private static final Schema CURRENT_GROUP_KEY_SCHEMA = MODULE$.schemaForKey(MODULE$.CURRENT_GROUP_KEY_SCHEMA_VERSION());

    private short CURRENT_OFFSET_KEY_SCHEMA_VERSION() {
        return CURRENT_OFFSET_KEY_SCHEMA_VERSION;
    }

    private short CURRENT_GROUP_KEY_SCHEMA_VERSION() {
        return CURRENT_GROUP_KEY_SCHEMA_VERSION;
    }

    private Schema OFFSET_COMMIT_KEY_SCHEMA() {
        return OFFSET_COMMIT_KEY_SCHEMA;
    }

    private BoundField OFFSET_KEY_GROUP_FIELD() {
        return OFFSET_KEY_GROUP_FIELD;
    }

    private BoundField OFFSET_KEY_TOPIC_FIELD() {
        return OFFSET_KEY_TOPIC_FIELD;
    }

    private BoundField OFFSET_KEY_PARTITION_FIELD() {
        return OFFSET_KEY_PARTITION_FIELD;
    }

    private Schema OFFSET_COMMIT_VALUE_SCHEMA_V0() {
        return OFFSET_COMMIT_VALUE_SCHEMA_V0;
    }

    private BoundField OFFSET_VALUE_OFFSET_FIELD_V0() {
        return OFFSET_VALUE_OFFSET_FIELD_V0;
    }

    private BoundField OFFSET_VALUE_METADATA_FIELD_V0() {
        return OFFSET_VALUE_METADATA_FIELD_V0;
    }

    private BoundField OFFSET_VALUE_TIMESTAMP_FIELD_V0() {
        return OFFSET_VALUE_TIMESTAMP_FIELD_V0;
    }

    private Schema OFFSET_COMMIT_VALUE_SCHEMA_V1() {
        return OFFSET_COMMIT_VALUE_SCHEMA_V1;
    }

    private BoundField OFFSET_VALUE_OFFSET_FIELD_V1() {
        return OFFSET_VALUE_OFFSET_FIELD_V1;
    }

    private BoundField OFFSET_VALUE_METADATA_FIELD_V1() {
        return OFFSET_VALUE_METADATA_FIELD_V1;
    }

    private BoundField OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1() {
        return OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1;
    }

    private BoundField OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1() {
        return OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1;
    }

    private Schema OFFSET_COMMIT_VALUE_SCHEMA_V2() {
        return OFFSET_COMMIT_VALUE_SCHEMA_V2;
    }

    private BoundField OFFSET_VALUE_OFFSET_FIELD_V2() {
        return OFFSET_VALUE_OFFSET_FIELD_V2;
    }

    private BoundField OFFSET_VALUE_METADATA_FIELD_V2() {
        return OFFSET_VALUE_METADATA_FIELD_V2;
    }

    private BoundField OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V2() {
        return OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V2;
    }

    private Schema OFFSET_COMMIT_VALUE_SCHEMA_V3() {
        return OFFSET_COMMIT_VALUE_SCHEMA_V3;
    }

    private BoundField OFFSET_VALUE_OFFSET_FIELD_V3() {
        return OFFSET_VALUE_OFFSET_FIELD_V3;
    }

    private BoundField OFFSET_VALUE_LEADER_EPOCH_FIELD_V3() {
        return OFFSET_VALUE_LEADER_EPOCH_FIELD_V3;
    }

    private BoundField OFFSET_VALUE_METADATA_FIELD_V3() {
        return OFFSET_VALUE_METADATA_FIELD_V3;
    }

    private BoundField OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V3() {
        return OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V3;
    }

    private Schema GROUP_METADATA_KEY_SCHEMA() {
        return GROUP_METADATA_KEY_SCHEMA;
    }

    private BoundField GROUP_KEY_GROUP_FIELD() {
        return GROUP_KEY_GROUP_FIELD;
    }

    private String MEMBER_ID_KEY() {
        return MEMBER_ID_KEY;
    }

    private String GROUP_INSTANCE_ID_KEY() {
        return GROUP_INSTANCE_ID_KEY;
    }

    private String CLIENT_ID_KEY() {
        return CLIENT_ID_KEY;
    }

    private String CLIENT_HOST_KEY() {
        return CLIENT_HOST_KEY;
    }

    private String REBALANCE_TIMEOUT_KEY() {
        return REBALANCE_TIMEOUT_KEY;
    }

    private String SESSION_TIMEOUT_KEY() {
        return SESSION_TIMEOUT_KEY;
    }

    private String SUBSCRIPTION_KEY() {
        return SUBSCRIPTION_KEY;
    }

    private String ASSIGNMENT_KEY() {
        return ASSIGNMENT_KEY;
    }

    private Schema MEMBER_METADATA_V0() {
        return MEMBER_METADATA_V0;
    }

    private Schema MEMBER_METADATA_V1() {
        return MEMBER_METADATA_V1;
    }

    private Schema MEMBER_METADATA_V2() {
        return MEMBER_METADATA_V2;
    }

    private Schema MEMBER_METADATA_V3() {
        return MEMBER_METADATA_V3;
    }

    private String PROTOCOL_TYPE_KEY() {
        return PROTOCOL_TYPE_KEY;
    }

    private String GENERATION_KEY() {
        return GENERATION_KEY;
    }

    private String PROTOCOL_KEY() {
        return PROTOCOL_KEY;
    }

    private String LEADER_KEY() {
        return LEADER_KEY;
    }

    private String CURRENT_STATE_TIMESTAMP_KEY() {
        return CURRENT_STATE_TIMESTAMP_KEY;
    }

    private String MEMBERS_KEY() {
        return MEMBERS_KEY;
    }

    private Schema GROUP_METADATA_VALUE_SCHEMA_V0() {
        return GROUP_METADATA_VALUE_SCHEMA_V0;
    }

    private Schema GROUP_METADATA_VALUE_SCHEMA_V1() {
        return GROUP_METADATA_VALUE_SCHEMA_V1;
    }

    private Schema GROUP_METADATA_VALUE_SCHEMA_V2() {
        return GROUP_METADATA_VALUE_SCHEMA_V2;
    }

    private Schema GROUP_METADATA_VALUE_SCHEMA_V3() {
        return GROUP_METADATA_VALUE_SCHEMA_V3;
    }

    private Map<Object, Schema> MESSAGE_TYPE_SCHEMAS() {
        return MESSAGE_TYPE_SCHEMAS;
    }

    private Map<Object, Schema> OFFSET_VALUE_SCHEMAS() {
        return OFFSET_VALUE_SCHEMAS;
    }

    private Map<Object, Schema> GROUP_VALUE_SCHEMAS() {
        return GROUP_VALUE_SCHEMAS;
    }

    private Schema CURRENT_OFFSET_KEY_SCHEMA() {
        return CURRENT_OFFSET_KEY_SCHEMA;
    }

    private Schema CURRENT_GROUP_KEY_SCHEMA() {
        return CURRENT_GROUP_KEY_SCHEMA;
    }

    private Schema schemaForKey(int version) {
        Schema schema;
        Option schemaOpt = this.MESSAGE_TYPE_SCHEMAS().get((Object)BoxesRunTime.boxToInteger((int)version));
        Option option = schemaOpt;
        if (!(option instanceof Some)) {
            throw new KafkaException(new StringBuilder(35).append("Unknown message key schema version ").append(version).toString());
        }
        Some some = (Some)option;
        Schema schema2 = schema = (Schema)some.value();
        return schema2;
    }

    private Schema schemaForOffsetValue(int version) {
        Schema schema;
        Option schemaOpt = this.OFFSET_VALUE_SCHEMAS().get((Object)BoxesRunTime.boxToInteger((int)version));
        Option option = schemaOpt;
        if (!(option instanceof Some)) {
            throw new KafkaException(new StringBuilder(30).append("Unknown offset schema version ").append(version).toString());
        }
        Some some = (Some)option;
        Schema schema2 = schema = (Schema)some.value();
        return schema2;
    }

    private Schema schemaForGroupValue(int version) {
        Schema schema;
        Option schemaOpt = this.GROUP_VALUE_SCHEMAS().get((Object)BoxesRunTime.boxToInteger((int)version));
        Option option = schemaOpt;
        if (!(option instanceof Some)) {
            throw new KafkaException(new StringBuilder(31).append("Unknown group metadata version ").append(version).toString());
        }
        Some some = (Some)option;
        Schema schema2 = schema = (Schema)some.value();
        return schema2;
    }

    public byte[] offsetCommitKey(String group, TopicPartition topicPartition) {
        Struct key = new Struct(this.CURRENT_OFFSET_KEY_SCHEMA());
        key.set(this.OFFSET_KEY_GROUP_FIELD(), (Object)group);
        key.set(this.OFFSET_KEY_TOPIC_FIELD(), (Object)topicPartition.topic());
        key.set(this.OFFSET_KEY_PARTITION_FIELD(), (Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()));
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + key.sizeOf());
        byteBuffer.putShort(this.CURRENT_OFFSET_KEY_SCHEMA_VERSION());
        key.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public byte[] groupMetadataKey(String group) {
        Struct key = new Struct(this.CURRENT_GROUP_KEY_SCHEMA());
        key.set(this.GROUP_KEY_GROUP_FIELD(), (Object)group);
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + key.sizeOf());
        byteBuffer.putShort(this.CURRENT_GROUP_KEY_SCHEMA_VERSION());
        key.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public byte[] offsetCommitValue(OffsetAndMetadata offsetAndMetadata, ApiVersion apiVersion) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        if (apiVersion.$less(KAFKA_2_1_IV0$.MODULE$) || offsetAndMetadata.expireTimestamp().nonEmpty()) {
            Struct value = new Struct(this.OFFSET_COMMIT_VALUE_SCHEMA_V1());
            value.set(this.OFFSET_VALUE_OFFSET_FIELD_V1(), (Object)BoxesRunTime.boxToLong((long)offsetAndMetadata.offset()));
            value.set(this.OFFSET_VALUE_METADATA_FIELD_V1(), (Object)offsetAndMetadata.metadata());
            value.set(this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1(), (Object)BoxesRunTime.boxToLong((long)offsetAndMetadata.commitTimestamp()));
            value.set(this.OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1(), offsetAndMetadata.expireTimestamp().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
            tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)value);
        } else if (apiVersion.$less(KAFKA_2_1_IV1$.MODULE$)) {
            Struct value = new Struct(this.OFFSET_COMMIT_VALUE_SCHEMA_V2());
            value.set(this.OFFSET_VALUE_OFFSET_FIELD_V2(), (Object)BoxesRunTime.boxToLong((long)offsetAndMetadata.offset()));
            value.set(this.OFFSET_VALUE_METADATA_FIELD_V2(), (Object)offsetAndMetadata.metadata());
            value.set(this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V2(), (Object)BoxesRunTime.boxToLong((long)offsetAndMetadata.commitTimestamp()));
            tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)value);
        } else {
            Struct value = new Struct(this.OFFSET_COMMIT_VALUE_SCHEMA_V3());
            value.set(this.OFFSET_VALUE_OFFSET_FIELD_V3(), (Object)BoxesRunTime.boxToLong((long)offsetAndMetadata.offset()));
            value.set(this.OFFSET_VALUE_LEADER_EPOCH_FIELD_V3(), (Object)offsetAndMetadata.leaderEpoch().orElse(Predef$.MODULE$.int2Integer(-1)));
            value.set(this.OFFSET_VALUE_METADATA_FIELD_V3(), (Object)offsetAndMetadata.metadata());
            value.set(this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V3(), (Object)BoxesRunTime.boxToLong((long)offsetAndMetadata.commitTimestamp()));
            tuple22 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)3), (Object)value);
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int version = tuple2._1$mcI$sp();
        Struct value = (Struct)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)version), (Object)value);
        Tuple2 tuple24 = tuple23;
        int version2 = tuple24._1$mcI$sp();
        Struct value2 = (Struct)tuple24._2();
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + value2.sizeOf());
        byteBuffer.putShort((short)version2);
        value2.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public byte[] groupMetadataValue(GroupMetadata groupMetadata, Map<String, byte[]> assignment, ApiVersion apiVersion) {
        Tuple2 tuple2;
        Tuple2 tuple22 = apiVersion.$less(KAFKA_0_10_1_IV0$.MODULE$) ? new Tuple2((Object)BoxesRunTime.boxToShort((short)((short)0)), (Object)new Struct(this.GROUP_METADATA_VALUE_SCHEMA_V0())) : (apiVersion.$less(KAFKA_2_1_IV0$.MODULE$) ? new Tuple2((Object)BoxesRunTime.boxToShort((short)((short)1)), (Object)new Struct(this.GROUP_METADATA_VALUE_SCHEMA_V1())) : (tuple2 = apiVersion.$less(KAFKA_2_3_IV0$.MODULE$) ? new Tuple2((Object)BoxesRunTime.boxToShort((short)((short)2)), (Object)new Struct(this.GROUP_METADATA_VALUE_SCHEMA_V2())) : new Tuple2((Object)BoxesRunTime.boxToShort((short)((short)3)), (Object)new Struct(this.GROUP_METADATA_VALUE_SCHEMA_V3()))));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        short version = BoxesRunTime.unboxToShort((Object)tuple2._1());
        Struct value = (Struct)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToShort((short)version), (Object)value);
        Tuple2 tuple24 = tuple23;
        short version2 = BoxesRunTime.unboxToShort((Object)tuple24._1());
        Struct value2 = (Struct)tuple24._2();
        value2.set(this.PROTOCOL_TYPE_KEY(), groupMetadata.protocolType().getOrElse((Function0 & Serializable)() -> ""));
        value2.set(this.GENERATION_KEY(), (Object)BoxesRunTime.boxToInteger((int)groupMetadata.generationId()));
        value2.set(this.PROTOCOL_KEY(), (Object)groupMetadata.protocolOrNull());
        value2.set(this.LEADER_KEY(), (Object)groupMetadata.leaderOrNull());
        Object object = version2 >= 2 ? value2.set(this.CURRENT_STATE_TIMESTAMP_KEY(), (Object)BoxesRunTime.boxToLong((long)groupMetadata.currentStateTimestampOrDefault())) : BoxedUnit.UNIT;
        List memberArray = groupMetadata.allMemberMetadata().map((Function1 & Serializable)memberMetadata -> {
            Struct memberStruct = value2.instance(MODULE$.MEMBERS_KEY());
            memberStruct.set(MODULE$.MEMBER_ID_KEY(), (Object)memberMetadata.memberId());
            memberStruct.set(MODULE$.CLIENT_ID_KEY(), (Object)memberMetadata.clientId());
            memberStruct.set(MODULE$.CLIENT_HOST_KEY(), (Object)memberMetadata.clientHost());
            memberStruct.set(MODULE$.SESSION_TIMEOUT_KEY(), (Object)BoxesRunTime.boxToInteger((int)memberMetadata.sessionTimeoutMs()));
            Object object = version2 > 0 ? memberStruct.set(MODULE$.REBALANCE_TIMEOUT_KEY(), (Object)BoxesRunTime.boxToInteger((int)memberMetadata.rebalanceTimeoutMs())) : BoxedUnit.UNIT;
            Object object2 = version2 >= 3 ? memberStruct.set(MODULE$.GROUP_INSTANCE_ID_KEY(), memberMetadata.groupInstanceId().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())) : BoxedUnit.UNIT;
            String protocol = groupMetadata.protocolOrNull();
            if (protocol == null) {
                throw new IllegalStateException("Attempted to write non-empty group metadata with no defined protocol");
            }
            byte[] metadata = memberMetadata.metadata(protocol);
            memberStruct.set(MODULE$.SUBSCRIPTION_KEY(), (Object)ByteBuffer.wrap(metadata));
            byte[] memberAssignment = (byte[])assignment.apply((Object)memberMetadata.memberId());
            Predef$.MODULE$.assert(memberAssignment != null);
            memberStruct.set(MODULE$.ASSIGNMENT_KEY(), (Object)ByteBuffer.wrap(memberAssignment));
            return memberStruct;
        });
        value2.set(this.MEMBERS_KEY(), memberArray.toArray(ClassTag$.MODULE$.apply(Struct.class)));
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + value2.sizeOf());
        byteBuffer.putShort(version2);
        value2.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public BaseKey readMessageKey(ByteBuffer buffer) {
        Product product;
        short version = buffer.getShort();
        Schema keySchema = this.schemaForKey(version);
        Struct key = keySchema.read(buffer);
        if (version <= this.CURRENT_OFFSET_KEY_SCHEMA_VERSION()) {
            String group = (String)key.get(this.OFFSET_KEY_GROUP_FIELD());
            String topic = (String)key.get(this.OFFSET_KEY_TOPIC_FIELD());
            int partition = BoxesRunTime.unboxToInt((Object)key.get(this.OFFSET_KEY_PARTITION_FIELD()));
            product = new OffsetKey(version, new GroupTopicPartition(group, new TopicPartition(topic, partition)));
        } else if (version == this.CURRENT_GROUP_KEY_SCHEMA_VERSION()) {
            String group = (String)key.get(this.GROUP_KEY_GROUP_FIELD());
            product = new GroupMetadataKey(version, group);
        } else {
            throw new IllegalStateException(new StringBuilder(40).append("Unknown group metadata message version: ").append(version).toString());
        }
        return product;
    }

    public OffsetAndMetadata readOffsetMessageValue(ByteBuffer buffer) {
        OffsetAndMetadata offsetAndMetadata;
        if (buffer == null) {
            offsetAndMetadata = null;
        } else {
            short version = buffer.getShort();
            Schema valueSchema = this.schemaForOffsetValue(version);
            Struct value = valueSchema.read(buffer);
            if (version == 0) {
                long offset = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_OFFSET_FIELD_V0()));
                String metadata = (String)value.get(this.OFFSET_VALUE_METADATA_FIELD_V0());
                long timestamp = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_TIMESTAMP_FIELD_V0()));
                offsetAndMetadata = OffsetAndMetadata$.MODULE$.apply(offset, metadata, timestamp);
            } else if (version == 1) {
                long offset = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_OFFSET_FIELD_V1()));
                String metadata = (String)value.get(this.OFFSET_VALUE_METADATA_FIELD_V1());
                long commitTimestamp = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1()));
                long expireTimestamp = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1()));
                offsetAndMetadata = expireTimestamp == -1L ? OffsetAndMetadata$.MODULE$.apply(offset, metadata, commitTimestamp) : OffsetAndMetadata$.MODULE$.apply(offset, metadata, commitTimestamp, expireTimestamp);
            } else if (version == 2) {
                long offset = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_OFFSET_FIELD_V2()));
                String metadata = (String)value.get(this.OFFSET_VALUE_METADATA_FIELD_V2());
                long commitTimestamp = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V2()));
                offsetAndMetadata = OffsetAndMetadata$.MODULE$.apply(offset, metadata, commitTimestamp);
            } else if (version == 3) {
                long offset = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_OFFSET_FIELD_V3()));
                int leaderEpoch = BoxesRunTime.unboxToInt((Object)value.get(this.OFFSET_VALUE_LEADER_EPOCH_FIELD_V3()));
                String metadata = (String)value.get(this.OFFSET_VALUE_METADATA_FIELD_V3());
                long commitTimestamp = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V3()));
                Optional<Integer> leaderEpochOpt = leaderEpoch < 0 ? Optional.empty() : Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch));
                offsetAndMetadata = OffsetAndMetadata$.MODULE$.apply(offset, leaderEpochOpt, metadata, commitTimestamp);
            } else {
                throw new IllegalStateException(new StringBuilder(32).append("Unknown offset message version: ").append(version).toString());
            }
        }
        return offsetAndMetadata;
    }

    public GroupMetadata readGroupMessageValue(String groupId, ByteBuffer buffer, Time time) {
        GroupMetadata groupMetadata;
        if (buffer == null) {
            groupMetadata = null;
        } else {
            short version = buffer.getShort();
            Schema valueSchema = this.schemaForGroupValue(version);
            Struct value = valueSchema.read(buffer);
            if (version >= 0 && version <= 3) {
                Long timestamp;
                int generationId = BoxesRunTime.unboxToInt((Object)value.get(this.GENERATION_KEY()));
                String protocolType = (String)value.get(this.PROTOCOL_TYPE_KEY());
                String protocol = (String)value.get(this.PROTOCOL_KEY());
                String leaderId = (String)value.get(this.LEADER_KEY());
                Object[] memberMetadataArray = value.getArray(this.MEMBERS_KEY());
                Product initialState = ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps(memberMetadataArray)) ? Empty$.MODULE$ : Stable$.MODULE$;
                short s = version;
                switch (s) {
                    default: 
                }
                None$ currentStateTimestamp = s == 2 ? (value.hasField(this.CURRENT_STATE_TIMESTAMP_KEY()) ? (BoxesRunTime.equalsNumObject((Number)(timestamp = value.getLong(this.CURRENT_STATE_TIMESTAMP_KEY())), (Object)BoxesRunTime.boxToInteger((int)-1)) ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(timestamp)))) : None$.MODULE$) : None$.MODULE$;
                MemberMetadata[] members = (MemberMetadata[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(memberMetadataArray), (Function1 & Serializable)memberMetadataObj -> {
                    Struct memberMetadata = (Struct)memberMetadataObj;
                    String memberId = (String)memberMetadata.get(MODULE$.MEMBER_ID_KEY());
                    None$ groupInstanceId = version >= 3 ? new Some((Object)((String)memberMetadata.get(MODULE$.GROUP_INSTANCE_ID_KEY()))) : None$.MODULE$;
                    String clientId = (String)memberMetadata.get(MODULE$.CLIENT_ID_KEY());
                    String clientHost = (String)memberMetadata.get(MODULE$.CLIENT_HOST_KEY());
                    int sessionTimeout = BoxesRunTime.unboxToInt((Object)memberMetadata.get(MODULE$.SESSION_TIMEOUT_KEY()));
                    int rebalanceTimeout = version == 0 ? sessionTimeout : BoxesRunTime.unboxToInt((Object)memberMetadata.get(MODULE$.REBALANCE_TIMEOUT_KEY()));
                    byte[] subscription = Utils.toArray((ByteBuffer)((ByteBuffer)memberMetadata.get(MODULE$.SUBSCRIPTION_KEY())));
                    MemberMetadata member = new MemberMetadata(memberId, groupId, (Option<String>)groupInstanceId, clientId, clientHost, rebalanceTimeout, sessionTimeout, protocolType, (List<Tuple2<String, byte[]>>)((List)new .colon.colon((Object)new Tuple2((Object)protocol, (Object)subscription), (List)Nil$.MODULE$)));
                    member.assignment_$eq(Utils.toArray((ByteBuffer)((ByteBuffer)memberMetadata.get(MODULE$.ASSIGNMENT_KEY()))));
                    return member;
                }, ClassTag$.MODULE$.apply(MemberMetadata.class));
                groupMetadata = GroupMetadata$.MODULE$.loadGroup(groupId, (GroupState)initialState, generationId, protocolType, protocol, leaderId, (Option<Object>)currentStateTimestamp, (Iterable<MemberMetadata>)Predef$.MODULE$.wrapRefArray((Object[])members), time);
            } else {
                throw new IllegalStateException(new StringBuilder(40).append("Unknown group metadata message version: ").append(version).toString());
            }
        }
        return groupMetadata;
    }

    public Tuple2<Option<String>, Option<String>> formatRecordKeyAndValue(Record record) {
        Tuple2<Option<String>, Option<String>> tuple2;
        if (!record.hasKey()) {
            throw new KafkaException("Failed to decode message using offset topic decoder (message had a missing key)");
        }
        BaseKey baseKey = this.readMessageKey(record.key());
        if (baseKey instanceof OffsetKey) {
            OffsetKey offsetKey = (OffsetKey)baseKey;
            tuple2 = this.parseOffsets(offsetKey, record.value());
        } else if (baseKey instanceof GroupMetadataKey) {
            GroupMetadataKey groupMetadataKey = (GroupMetadataKey)baseKey;
            tuple2 = this.parseGroupMetadata(groupMetadataKey, record.value());
        } else {
            throw new KafkaException("Failed to decode message using offset topic decoder (message had an invalid key)");
        }
        return tuple2;
    }

    private Tuple2<Option<String>, Option<String>> parseOffsets(OffsetKey offsetKey, ByteBuffer payload) {
        String groupId = offsetKey.key().group();
        TopicPartition topicPartition = offsetKey.key().topicPartition();
        String keyString = new StringBuilder(32).append("offset_commit::group=").append(groupId).append(",partition=").append(topicPartition).toString();
        OffsetAndMetadata offset = this.readOffsetMessageValue(payload);
        String valueString = offset == null ? "<DELETE>" : (offset.metadata().isEmpty() ? new StringBuilder(7).append("offset=").append(offset.offset()).toString() : new StringBuilder(17).append("offset=").append(offset.offset()).append(",metadata=").append(offset.metadata()).toString());
        return new Tuple2((Object)new Some((Object)keyString), (Object)new Some((Object)valueString));
    }

    private Tuple2<Option<String>, Option<String>> parseGroupMetadata(GroupMetadataKey groupMetadataKey, ByteBuffer payload) {
        String string;
        String groupId = groupMetadataKey.key();
        String keyString = new StringBuilder(22).append("group_metadata::group=").append(groupId).toString();
        GroupMetadata group = this.readGroupMessageValue(groupId, payload, Time.SYSTEM);
        if (group == null) {
            string = "<DELETE>";
        } else {
            String protocolType = (String)group.protocolType().getOrElse((Function0 & Serializable)() -> "");
            String assignment = group.allMemberMetadata().map((Function1 & Serializable)member -> {
                ConsumerPartitionAssignor.Assignment partitionAssignment;
                String userData;
                String string = protocolType;
                String string2 = "consumer";
                return !(string != null ? !string.equals(string2) : string2 != null) ? ((userData = (String)Option$.MODULE$.apply((Object)(partitionAssignment = ConsumerProtocol.deserializeAssignment((ByteBuffer)ByteBuffer.wrap(member.assignment()))).userData()).map((Function1 & Serializable)x$1 -> Utils.toArray((ByteBuffer)x$1)).map((Function1 & Serializable)bytes -> MODULE$.hex((byte[])bytes)).getOrElse((Function0 & Serializable)() -> "")).isEmpty() ? new StringBuilder(1).append(member.memberId()).append("=").append(partitionAssignment.partitions()).toString() : new StringBuilder(2).append(member.memberId()).append("=").append(partitionAssignment.partitions()).append(":").append(userData).toString()) : new StringBuilder(1).append(member.memberId()).append("=").append(MODULE$.hex(member.assignment())).toString();
            }).mkString("{", ",", "}");
            string = Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"protocolType"), (Object)protocolType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"protocol"), (Object)group.protocolOrNull()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"generationId"), (Object)BoxesRunTime.boxToInteger((int)group.generationId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"assignment"), (Object)assignment)}))).asJava());
        }
        String valueString = string;
        return new Tuple2((Object)new Some((Object)keyString), (Object)new Some((Object)valueString));
    }

    private String hex(byte[] bytes) {
        return ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.byteArrayOps(bytes)) ? "" : StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%X"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.BigInt().apply(1, bytes)}));
    }

    private GroupMetadataManager$() {
    }
}

