/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionPartitionAndLeaderEpoch;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager$;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndMetadata;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndTransitMetadata;
import kafka.coordinator.transaction.TxnKey;
import kafka.coordinator.transaction.TxnMetadataCacheEntry;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.log.AppendOrigin$Coordinator$;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.message.UncompressedCodec$;
import kafka.server.FetchDataInfo;
import kafka.server.FetchLogEnd$;
import kafka.server.ReplicaManager;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Function5;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\tuw!B\u001b7\u0011\u0003id!B 7\u0011\u0003\u0001\u0005\"B$\u0002\t\u0003A\u0005bB%\u0002\u0005\u0004%\tA\u0013\u0005\u0007\u001d\u0006\u0001\u000b\u0011B&\t\u000f=\u000b!\u0019!C\u0001\u0015\"1\u0001+\u0001Q\u0001\n-Cq!U\u0001C\u0002\u0013\u0005!\n\u0003\u0004S\u0003\u0001\u0006Ia\u0013\u0005\b'\u0006\u0011\r\u0011\"\u0001K\u0011\u0019!\u0016\u0001)A\u0005\u0017\u001a!qH\u000e\u0001V\u0011!a6B!A!\u0002\u0013Y\u0005\u0002C/\f\u0005\u0003\u0005\u000b\u0011\u00020\t\u0011\u0011\\!\u0011!Q\u0001\n\u0015D\u0001\u0002[\u0006\u0003\u0002\u0003\u0006I!\u001b\u0005\t_.\u0011\t\u0011)A\u0005a\"A1o\u0003B\u0001B\u0003%A\u000f\u0003\u0006\u0002\u0002-\u0011\t\u0011)A\u0005\u0003\u0007AaaR\u0006\u0005\u0002\u00055QABA\u0010\u0017\u0001\t\t\u0003C\u0005\u0002\\-\u0011\r\u0011\"\u0003\u0002^!A\u0011qO\u0006!\u0002\u0013\ty\u0006C\u0005\u0002z-\u0011\r\u0011\"\u0003\u0002|!A\u0011\u0011R\u0006!\u0002\u0013\ti\b\u0003\u0006\u0002\f.\u0011\r\u0011\"\u00017\u0003\u001bC\u0001\"!*\fA\u0003%\u0011q\u0012\u0005\u000b\u0003O[!\u0019!C\u0001m\u0005%\u0006\u0002CA\\\u0017\u0001\u0006I!a+\t\u0011\u0005e6B1A\u0005\n)Cq!a/\fA\u0003%1\nC\u0005\u0002>.\u0011\r\u0011\"\u0003\u0002@\"A\u0011qY\u0006!\u0002\u0013\t\t\r\u0003\u0005\u0002J.!\tANAf\u0011!\t)n\u0003C\u0001m\u0005]\u0007bBAs\u0017\u0011\u0005\u0011q\u001d\u0005\b\u0005\u0003YA\u0011\u0001B\u0002\u0011\u001d\u0011)a\u0003C\u0001\u0005\u000fAqAa\u000b\f\t\u0003\u0011i\u0003C\u0004\u00036-!IAa\u000e\t\u000f\t\u00053\u0002\"\u0001\u0003D!9!qJ\u0006\u0005\u0002\tE\u0003b\u0002B.\u0017\u0011\u0005!Q\f\u0005\u0007\u0005CZA\u0011\u0002&\t\u000f\t\r4\u0002\"\u0003\u0003f!A!1P\u0006\u0005\u0002Y\u0012i\bC\u0004\u0003\n.!\tAa#\t\u000f\te5\u0002\"\u0001\u0003\u001c\"9!\u0011T\u0006\u0005\u0002\t}\u0005b\u0002BS\u0017\u0011%!1\u0001\u0005\b\u0005O[A\u0011\u0001BU\u0011%\u0011\u0019mCI\u0001\n\u0003\u0011)\rC\u0004\u0003\\.!\tAa\u0001\u0002/Q\u0013\u0018M\\:bGRLwN\\*uCR,W*\u00198bO\u0016\u0014(BA\u001c9\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0005eR\u0014aC2p_J$\u0017N\\1u_JT\u0011aO\u0001\u0006W\u000647.Y\u0002\u0001!\tq\u0014!D\u00017\u0005]!&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X-T1oC\u001e,'o\u0005\u0002\u0002\u0003B\u0011!)R\u0007\u0002\u0007*\tA)A\u0003tG\u0006d\u0017-\u0003\u0002G\u0007\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u001f\u0002?\u0011+g-Y;miR\u0013\u0018M\\:bGRLwN\\:NCb$\u0016.\\3pkRl5/F\u0001L!\t\u0011E*\u0003\u0002N\u0007\n\u0019\u0011J\u001c;\u0002A\u0011+g-Y;miR\u0013\u0018M\\:bGRLwN\\:NCb$\u0016.\\3pkRl5\u000fI\u0001#\t\u00164\u0017-\u001e7u)J\fgn]1di&|g.\u00197JI\u0016C\b/\u001b:bi&|g.T:\u0002G\u0011+g-Y;miR\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012,\u0005\u0010]5sCRLwN\\'tA\u0005QC)\u001a4bk2$\u0018IY8siRKW.\u001a3PkR$&/\u00198tC\u000e$\u0018n\u001c8t\u0013:$XM\u001d<bY6\u001b\u0018a\u000b#fM\u0006,H\u000e^!c_J$H+[7fI>+H\u000f\u0016:b]N\f7\r^5p]NLe\u000e^3sm\u0006dWj\u001d\u0011\u0002]\u0011+g-Y;miJ+Wn\u001c<f\u000bb\u0004\u0018N]3e)J\fgn]1di&|g.\u00197JINLe\u000e^3sm\u0006dWj]\u00010\t\u00164\u0017-\u001e7u%\u0016lwN^3FqBL'/\u001a3Ue\u0006t7/Y2uS>t\u0017\r\\%eg&sG/\u001a:wC2l5\u000fI\n\u0004\u0017\u00053\u0006CA,[\u001b\u0005A&BA-;\u0003\u0015)H/\u001b7t\u0013\tY\u0006LA\u0004M_\u001e<\u0017N\\4\u0002\u0011\t\u0014xn[3s\u0013\u0012\f\u0001B_6DY&,g\u000e\u001e\t\u0003?\nl\u0011\u0001\u0019\u0006\u0003Cj\n!A_6\n\u0005\r\u0004'!D&bM.\f'l[\"mS\u0016tG/A\u0005tG\",G-\u001e7feB\u0011qKZ\u0005\u0003Ob\u0013\u0011bU2iK\u0012,H.\u001a:\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feB\u0011!.\\\u0007\u0002W*\u0011ANO\u0001\u0007g\u0016\u0014h/\u001a:\n\u00059\\'A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0007G>tg-[4\u0011\u0005y\n\u0018B\u0001:7\u0005E!&/\u00198tC\u000e$\u0018n\u001c8D_:4\u0017nZ\u0001\u0005i&lW\r\u0005\u0002v}6\taO\u0003\u0002Zo*\u0011\u00010_\u0001\u0007G>lWn\u001c8\u000b\u0005mR(BA>}\u0003\u0019\t\u0007/Y2iK*\tQ0A\u0002pe\u001eL!a <\u0003\tQKW.Z\u0001\b[\u0016$(/[2t!\u0011\t)!!\u0003\u000e\u0005\u0005\u001d!bAA\u0001o&!\u00111BA\u0004\u0005\u001diU\r\u001e:jGN$\u0002#a\u0004\u0002\u0012\u0005M\u0011QCA\f\u00033\tY\"!\b\u0011\u0005yZ\u0001\"\u0002/\u0014\u0001\u0004Y\u0005\"B/\u0014\u0001\u0004q\u0006\"\u00023\u0014\u0001\u0004)\u0007\"\u00025\u0014\u0001\u0004I\u0007\"B8\u0014\u0001\u0004\u0001\b\"B:\u0014\u0001\u0004!\bbBA\u0001'\u0001\u0007\u00111\u0001\u0002\u0017'\u0016tG\r\u0016=o\u001b\u0006\u00148.\u001a:t\u0007\u0006dGNY1dWBq!)a\t\u0002(-\u000bi$!\u0013\u0002P\u0005U\u0013bAA\u0013\u0007\nIa)\u001e8di&|g.\u000e\t\u0005\u0003S\t9D\u0004\u0003\u0002,\u0005M\u0002cAA\u0017\u00076\u0011\u0011q\u0006\u0006\u0004\u0003ca\u0014A\u0002\u001fs_>$h(C\u0002\u00026\r\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u001d\u0003w\u0011aa\u0015;sS:<'bAA\u001b\u0007B!\u0011qHA#\u001b\t\t\tEC\u0002\u0002D]\f\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003\u000f\n\tEA\tUe\u0006t7/Y2uS>t'+Z:vYR\u00042APA&\u0013\r\tiE\u000e\u0002\u0014)J\fgn]1di&|g.T3uC\u0012\fG/\u0019\t\u0004}\u0005E\u0013bAA*m\t\u0011B\u000b\u001f8Ue\u0006t7/\u001b;NKR\fG-\u0019;b!\r\u0011\u0015qK\u0005\u0004\u00033\u001a%\u0001B+oSR\fAb\u001d5viRLgn\u001a#po:,\"!a\u0018\u0011\t\u0005\u0005\u00141O\u0007\u0003\u0003GRA!!\u001a\u0002h\u00051\u0011\r^8nS\u000eTA!!\u001b\u0002l\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u00055\u0014qN\u0001\u0005kRLGN\u0003\u0002\u0002r\u0005!!.\u0019<b\u0013\u0011\t)(a\u0019\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u00035\u0019\b.\u001e;uS:<Gi\\<oA\u0005I1\u000f^1uK2{7m[\u000b\u0003\u0003{\u0002B!a \u0002\u00066\u0011\u0011\u0011\u0011\u0006\u0005\u0003\u0007\u000b9'A\u0003m_\u000e\\7/\u0003\u0003\u0002\b\u0006\u0005%A\u0006*fK:$(/\u00198u%\u0016\fGm\u0016:ji\u0016dunY6\u0002\u0015M$\u0018\r^3M_\u000e\\\u0007%A\tm_\u0006$\u0017N\\4QCJ$\u0018\u000e^5p]N,\"!a$\u0011\r\u0005E\u00151TAP\u001b\t\t\u0019J\u0003\u0003\u0002\u0016\u0006]\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0004\u00033\u001b\u0015AC2pY2,7\r^5p]&!\u0011QTAJ\u0005\r\u0019V\r\u001e\t\u0004}\u0005\u0005\u0016bAARm\t\u0011CK]1og\u0006\u001cG/[8o!\u0006\u0014H/\u001b;j_:\fe\u000e\u001a'fC\u0012,'/\u00129pG\"\f!\u0003\\8bI&tw\rU1si&$\u0018n\u001c8tA\u0005ABO]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0016\u0005\u0005-\u0006cBAI\u0003[[\u0015\u0011W\u0005\u0005\u0003_\u000b\u0019JA\u0002NCB\u00042APAZ\u0013\r\t)L\u000e\u0002\u0016)btW*\u001a;bI\u0006$\u0018mQ1dQ\u0016,e\u000e\u001e:z\u0003e!(/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\u0011\u0002=Q\u0014\u0018M\\:bGRLwN\u001c+pa&\u001c\u0007+\u0019:uSRLwN\\\"pk:$\u0018a\b;sC:\u001c\u0018m\u0019;j_:$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8uA\u0005\u0019\u0002/\u0019:uSRLwN\u001c'pC\u0012\u001cVM\\:peV\u0011\u0011\u0011\u0019\t\u0005\u0003\u000b\t\u0019-\u0003\u0003\u0002F\u0006\u001d!AB*f]N|'/\u0001\u000bqCJ$\u0018\u000e^5p]2{\u0017\rZ*f]N|'\u000fI\u0001\u0014C\u0012$Gj\\1eS:<\u0007+\u0019:uSRLwN\u001c\u000b\u0007\u0003+\ni-!5\t\r\u0005=\u0017\u00051\u0001L\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\t\r\u0005M\u0017\u00051\u0001L\u0003A\u0019wn\u001c:eS:\fGo\u001c:Fa>\u001c\u0007.A\u0007ti\u0006$XMU3bI2{7m[\u000b\u0003\u00033\u0004B!a7\u0002b6\u0011\u0011Q\u001c\u0006\u0005\u0003?\f\t)\u0001\fSK\u0016tGO]1oiJ+\u0017\rZ,sSR,Gj\\2l\u0013\u0011\t\u0019/!8\u0003\u0011I+\u0017\r\u001a'pG.\fA\u0003^5nK\u0012|U\u000f\u001e+sC:\u001c\u0018m\u0019;j_:\u001cHCAAu!\u0019\tY/!>\u0002|:!\u0011Q^Ay\u001d\u0011\ti#a<\n\u0003\u0011K1!a=D\u0003\u001d\u0001\u0018mY6bO\u0016LA!a>\u0002z\nA\u0011\n^3sC\ndWMC\u0002\u0002t\u000e\u00032APA\u007f\u0013\r\tyP\u000e\u0002\")J\fgn]1di&|g.\u00197JI\u0006sG\r\u0015:pIV\u001cWM]%e\u000bB|7\r[\u0001 K:\f'\r\\3Ue\u0006t7/Y2uS>t\u0017\r\\%e\u000bb\u0004\u0018N]1uS>tGCAA+\u0003M9W\r\u001e+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f)\u0011\u0011IAa\n\u0011\u0011\u0005-(1\u0002B\b\u00057IAA!\u0004\u0002z\n1Q)\u001b;iKJ\u0004BA!\u0005\u0003\u00185\u0011!1\u0003\u0006\u0004\u0005+9\u0018\u0001\u00039s_R|7m\u001c7\n\t\te!1\u0003\u0002\u0007\u000bJ\u0014xN]:\u0011\u000b\t\u0013iB!\t\n\u0007\t}1I\u0001\u0004PaRLwN\u001c\t\u0004}\t\r\u0012b\u0001B\u0013m\tq2i\\8sI&t\u0017\r^8s\u000bB|7\r[!oIRCh.T3uC\u0012\fG/\u0019\u0005\b\u0005S)\u0003\u0019AA\u0014\u0003=!(/\u00198tC\u000e$\u0018n\u001c8bY&#\u0017A\b9viR\u0013\u0018M\\:bGRLwN\\*uCR,\u0017J\u001a(pi\u0016C\u0018n\u001d;t)\u0011\u0011yC!\r\u0011\u0011\u0005-(1\u0002B\b\u0005CAqAa\r'\u0001\u0004\tI%A\u0006uq:lU\r^1eCR\f\u0017AH4fi\u0006sG-T1zE\u0016\fE\r\u001a+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f)\u0019\u0011IA!\u000f\u0003<!9!\u0011F\u0014A\u0002\u0005\u001d\u0002b\u0002B\u001fO\u0001\u0007!qH\u0001\u0016GJ,\u0017\r^3e)btW*\u001a;bI\u0006$\u0018m\u00149u!\u0015\u0011%QDA%\u0003q1\u0018\r\\5eCR,GK]1og\u0006\u001cG/[8o)&lWm\\;u\u001bN$BA!\u0012\u0003LA\u0019!Ia\u0012\n\u0007\t%3IA\u0004C_>dW-\u00198\t\r\t5\u0003\u00061\u0001L\u00031!\bP\u001c+j[\u0016|W\u000f^'t\u0003]!(/\u00198tC\u000e$\u0018n\u001c8U_BL7mQ8oM&<7/\u0006\u0002\u0003TA!!Q\u000bB,\u001b\t\tY'\u0003\u0003\u0003Z\u0005-$A\u0003)s_B,'\u000f^5fg\u0006a\u0001/\u0019:uSRLwN\u001c$peR\u00191Ja\u0018\t\u000f\t%\"\u00061\u0001\u0002(\u0005\ts-\u001a;Ue\u0006t7/Y2uS>tGk\u001c9jGB\u000b'\u000f^5uS>t7i\\;oi\u00069Bn\\1e)J\fgn]1di&|g.T3uC\u0012\fG/\u0019\u000b\u0007\u0005O\u0012iG!\u001f\u0011\u000f]\u0013I'a\n\u0002J%\u0019!1\u000e-\u0003\tA{w\u000e\u001c\u0005\b\u0005_b\u0003\u0019\u0001B9\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004BAa\u001d\u0003v5\tq/C\u0002\u0003x]\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004\u0002T2\u0002\raS\u0001\u001dC\u0012$Gj\\1eK\u0012$&/\u00198tC\u000e$\u0018n\u001c8t)>\u001c\u0015m\u00195f)!\t)Fa \u0003\u0004\n\u0015\u0005B\u0002BA[\u0001\u00071*A\tuq:$v\u000e]5d!\u0006\u0014H/\u001b;j_:Da!a5.\u0001\u0004Y\u0005b\u0002BD[\u0001\u0007!qM\u0001\u0013Y>\fG-\u001a3Ue\u0006t7/Y2uS>t7/\u0001\u0013m_\u0006$GK]1og\u0006\u001cG/[8og\u001a{'\u000f\u0016=o)>\u0004\u0018n\u0019)beRLG/[8o)!\t)F!$\u0003\u0010\nE\u0005BBAh]\u0001\u00071\n\u0003\u0004\u0002T:\u0002\ra\u0013\u0005\b\u0005's\u0003\u0019\u0001BK\u00039\u0019XM\u001c3Uq:l\u0015M]6feN\u00042Aa&\u0015\u001b\u0005Y\u0011A\n:f[>4X\r\u0016:b]N\f7\r^5p]N4uN\u001d+y]R{\u0007/[2QCJ$\u0018\u000e^5p]R!\u0011Q\u000bBO\u0011\u0019\tym\fa\u0001\u0017R1\u0011Q\u000bBQ\u0005GCa!a41\u0001\u0004Y\u0005BBAja\u0001\u00071*\u0001\u0018wC2LG-\u0019;f)J\fgn]1di&|g\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|gnQ8v]RL5o\u0015;bE2,\u0017AF1qa\u0016tG\r\u0016:b]N\f7\r^5p]R{Gj\\4\u0015\u0019\u0005U#1\u0016BW\u0005_\u0013\u0019L!0\t\u000f\t%\"\u00071\u0001\u0002(!1\u00111\u001b\u001aA\u0002-CqA!-3\u0001\u0004\ty%A\u0006oK^lU\r^1eCR\f\u0007b\u0002B[e\u0001\u0007!qW\u0001\u0011e\u0016\u001c\bo\u001c8tK\u000e\u000bG\u000e\u001c2bG.\u0004rA\u0011B]\u0005\u001f\t)&C\u0002\u0003<\u000e\u0013\u0011BR;oGRLwN\\\u0019\t\u0013\t}&\u0007%AA\u0002\t\u0005\u0017\u0001\u0004:fiJLxJ\\#se>\u0014\bc\u0002\"\u0003:\n=!QI\u0001!CB\u0004XM\u001c3Ue\u0006t7/Y2uS>tGk\u001c'pO\u0012\"WMZ1vYR$S'\u0006\u0002\u0003H*\"!\u0011\u0019BeW\t\u0011Y\r\u0005\u0003\u0003N\n]WB\u0001Bh\u0015\u0011\u0011\tNa5\u0002\u0013Ut7\r[3dW\u0016$'b\u0001Bk\u0007\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\te'q\u001a\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001C:ikR$wn\u001e8")
public class TransactionStateManager
implements Logging {
    private final KafkaZkClient zkClient;
    private final Scheduler scheduler;
    private final ReplicaManager replicaManager;
    private final TransactionConfig config;
    private final Time time;
    private final AtomicBoolean shuttingDown;
    private final ReentrantReadWriteLock stateLock;
    private final Set<TransactionPartitionAndLeaderEpoch> loadingPartitions;
    private final scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache;
    private final int transactionTopicPartitionCount;
    private final Sensor partitionLoadSensor;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static int DefaultRemoveExpiredTransactionalIdsIntervalMs() {
        return TransactionStateManager$.MODULE$.DefaultRemoveExpiredTransactionalIdsIntervalMs();
    }

    public static int DefaultAbortTimedOutTransactionsIntervalMs() {
        return TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs();
    }

    public static int DefaultTransactionalIdExpirationMs() {
        return TransactionStateManager$.MODULE$.DefaultTransactionalIdExpirationMs();
    }

    public static int DefaultTransactionsMaxTimeoutMs() {
        return TransactionStateManager$.MODULE$.DefaultTransactionsMaxTimeoutMs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TransactionStateManager transactionStateManager = this;
        synchronized (transactionStateManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean shuttingDown() {
        return this.shuttingDown;
    }

    private ReentrantReadWriteLock stateLock() {
        return this.stateLock;
    }

    public Set<TransactionPartitionAndLeaderEpoch> loadingPartitions() {
        return this.loadingPartitions;
    }

    public scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache() {
        return this.transactionMetadataCache;
    }

    private int transactionTopicPartitionCount() {
        return this.transactionTopicPartitionCount;
    }

    private Sensor partitionLoadSensor() {
        return this.partitionLoadSensor;
    }

    public void addLoadingPartition(int partitionId, int coordinatorEpoch) {
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        CoreUtils$.MODULE$.inWriteLock(this.stateLock(), (JFunction0.mcZ.sp & Serializable)() -> this.loadingPartitions().add((Object)partitionAndLeaderEpoch));
    }

    public ReentrantReadWriteLock.ReadLock stateReadLock() {
        return this.stateLock().readLock();
    }

    public Iterable<TransactionalIdAndProducerIdEpoch> timedOutTransactions() {
        long now = this.time.milliseconds();
        return (Iterable)CoreUtils$.MODULE$.inReadLock(this.stateLock(), (Function0 & Serializable)() -> (scala.collection.mutable.Iterable)this.transactionMetadataCache().flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TxnMetadataCacheEntry entry = (TxnMetadataCacheEntry)tuple2._2();
            IterableOnce iterableOnce = (IterableOnce)((IterableOps)entry.metadataPerTransactionalId().filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$timedOutTransactions$3(now, x0$2)))).map((Function1 & Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String txnId = (String)tuple2._1();
                TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._2();
                TransactionalIdAndProducerIdEpoch transactionalIdAndProducerIdEpoch = new TransactionalIdAndProducerIdEpoch(txnId, txnMetadata.producerId(), txnMetadata.producerEpoch());
                return transactionalIdAndProducerIdEpoch;
            });
            return iterableOnce;
        }));
    }

    public void enableTransactionalIdExpiration() {
        this.scheduler.schedule("transactionalId-expiration", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            long now = $this.time.milliseconds();
            CoreUtils$.MODULE$.inReadLock(this.stateLock(), (JFunction0.mcV.sp & Serializable)() -> {
                scala.collection.immutable.Map transactionalIdByPartition = ((IterableOps)this.transactionMetadataCache().flatMap((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    TxnMetadataCacheEntry entry = (TxnMetadataCacheEntry)tuple2._2();
                    Iterable iterable = (Iterable)((IterableOps)((IterableOps)entry.metadataPerTransactionalId().filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$enableTransactionalIdExpiration$4(x0$2)))).filter((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$enableTransactionalIdExpiration$5(this, now, x0$3)))).map((Function1 & Serializable)x0$4 -> {
                        Tuple2 tuple2 = x0$4;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        String transactionalId = (String)tuple2._1();
                        TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._2();
                        TxnTransitMetadata txnMetadataTransition = (TxnTransitMetadata)txnMetadata.inLock((Function0 & Serializable)() -> txnMetadata.prepareDead());
                        TransactionalIdCoordinatorEpochAndMetadata transactionalIdCoordinatorEpochAndMetadata = new TransactionalIdCoordinatorEpochAndMetadata(transactionalId, entry.coordinatorEpoch(), txnMetadataTransition);
                        return transactionalIdCoordinatorEpochAndMetadata;
                    });
                    return iterable;
                })).groupBy((Function1 & Serializable)transactionalIdCoordinatorEpochAndMetadata -> BoxesRunTime.boxToInteger((int)this.partitionFor(transactionalIdCoordinatorEpochAndMetadata.transactionalId())));
                scala.collection.immutable.Map recordsPerPartition = (scala.collection.immutable.Map)transactionalIdByPartition.map((Function1 & Serializable)x0$5 -> {
                    Tuple2 tuple2 = x0$5;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    int partition = tuple2._1$mcI$sp();
                    scala.collection.mutable.Iterable transactionalIdCoordinatorEpochAndMetadatas = (scala.collection.mutable.Iterable)tuple2._2();
                    SimpleRecord[] deletes = (SimpleRecord[])((IterableOnceOps)transactionalIdCoordinatorEpochAndMetadatas.map((Function1 & Serializable)entry -> new SimpleRecord(now, TransactionLog$.MODULE$.keyToBytes(entry.transactionalId()), null))).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
                    MemoryRecords records = MemoryRecords.withRecords((CompressionType)TransactionLog$.MODULE$.EnforcedCompressionType(), (SimpleRecord[])deletes);
                    TopicPartition topicPartition = new TopicPartition("__transaction_state", partition);
                    Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)records);
                    return tuple22;
                });
                $this.replicaManager.appendRecords($this.config.requestTimeoutMs(), TransactionLog$.MODULE$.EnforcedRequiredAcks(), true, AppendOrigin$Coordinator$.MODULE$, (Map<TopicPartition, MemoryRecords>)recordsPerPartition, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)(Function1 & Serializable)responses -> {
                    this.removeFromCacheCallback$1(responses, transactionalIdByPartition);
                    return BoxedUnit.UNIT;
                }, (Option<Lock>)new Some((Object)this.stateLock().readLock()), $this.replicaManager.appendRecords$default$8());
            });
        }, this.config.removeExpiredTransactionalIdsIntervalMs(), this.config.removeExpiredTransactionalIdsIntervalMs(), this.scheduler.schedule$default$5());
    }

    public Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getTransactionState(String transactionalId) {
        return this.getAndMaybeAddTransactionState(transactionalId, (Option<TransactionMetadata>)None$.MODULE$);
    }

    public Either<Errors, CoordinatorEpochAndTxnMetadata> putTransactionStateIfNotExists(TransactionMetadata txnMetadata) {
        return this.getAndMaybeAddTransactionState(txnMetadata.transactionalId(), (Option<TransactionMetadata>)new Some((Object)txnMetadata)).right().map((Function1 & Serializable)x$1 -> (CoordinatorEpochAndTxnMetadata)x$1.getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(61).append("Unexpected empty transaction metadata returned while putting ").append(txnMetadata).toString());
        }));
    }

    private Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getAndMaybeAddTransactionState(String transactionalId, Option<TransactionMetadata> createdTxnMetadataOpt) {
        return (Either)CoreUtils$.MODULE$.inReadLock(this.stateLock(), (Function0 & Serializable)() -> {
            Left left;
            int partitionId = this.partitionFor(transactionalId);
            if (this.loadingPartitions().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$2(partitionId, x$2)))) {
                left = package$.MODULE$.Left().apply((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS);
            } else {
                Left left2;
                Option option = this.transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)partitionId));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    TxnMetadataCacheEntry cacheEntry = (TxnMetadataCacheEntry)some.value();
                    Option txnMetadata = Option$.MODULE$.apply((Object)cacheEntry.metadataPerTransactionalId().get(transactionalId)).orElse((Function0 & Serializable)() -> createdTxnMetadataOpt.map((Function1 & Serializable)createdTxnMetadata -> (TransactionMetadata)Option$.MODULE$.apply((Object)cacheEntry.metadataPerTransactionalId().putIfNotExists(transactionalId, (TransactionMetadata)createdTxnMetadata)).getOrElse((Function0 & Serializable)() -> createdTxnMetadata)));
                    left2 = package$.MODULE$.Right().apply((Object)txnMetadata.map((Function1 & Serializable)x$3 -> new CoordinatorEpochAndTxnMetadata(cacheEntry.coordinatorEpoch(), (TransactionMetadata)x$3)));
                } else if (None$.MODULE$.equals(option)) {
                    left2 = package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
                } else {
                    throw new MatchError((Object)option);
                }
                left = left2;
            }
            return left;
        });
    }

    public boolean validateTransactionTimeoutMs(int txnTimeoutMs) {
        return txnTimeoutMs <= this.config.transactionMaxTimeoutMs() && txnTimeoutMs > 0;
    }

    /*
     * WARNING - void declaration
     */
    public Properties transactionTopicConfigs() {
        void var1_1;
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "false");
        props.put(LogConfig$.MODULE$.CompressionTypeProp(), UncompressedCodec$.MODULE$.name());
        props.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        props.put(LogConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)this.config.transactionLogMinInsyncReplicas())).toString());
        props.put(LogConfig$.MODULE$.SegmentBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)this.config.transactionLogSegmentBytes())).toString());
        return var1_1;
    }

    public int partitionFor(String transactionalId) {
        return Utils.abs((int)transactionalId.hashCode()) % this.transactionTopicPartitionCount();
    }

    private int getTransactionTopicPartitionCount() {
        return BoxesRunTime.unboxToInt((Object)this.zkClient.getTopicPartitionCount("__transaction_state").getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> $this.config.transactionLogNumPartitions()));
    }

    private Pool<String, TransactionMetadata> loadTransactionMetadata(TopicPartition topicPartition, int coordinatorEpoch) {
        long startMs = this.time.milliseconds();
        Pool<String, TransactionMetadata> loadedTransactions = new Pool<String, TransactionMetadata>((Option<Function1<String, TransactionMetadata>>)Pool$.MODULE$.$lessinit$greater$default$1());
        Option<Log> option = this.replicaManager.getLog(topicPartition);
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Attempted to load transaction metadata from ").append(topicPartition).append(", but found no log").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            Log log = (Log)some.value();
            ByteBuffer buffer = ByteBuffer.allocate(0);
            LongRef currOffset = LongRef.create((long)log.logStartOffset());
            boolean readAtLeastOneRecord = true;
            try {
                while (currOffset.elem < this.logEndOffset$1(topicPartition) && readAtLeastOneRecord && !this.shuttingDown().get() && BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inReadLock(this.stateLock(), (JFunction0.mcZ.sp & Serializable)() -> this.loadingPartitions().exists((Function1 & Serializable)idAndEpoch -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$loadTransactionMetadata$4(topicPartition, coordinatorEpoch, idAndEpoch)))))) {
                    MemoryRecords memoryRecords;
                    FetchDataInfo fetchDataInfo = log.read(currOffset.elem, this.config.transactionLogLoadBufferSize(), FetchLogEnd$.MODULE$, true);
                    readAtLeastOneRecord = fetchDataInfo.records().sizeInBytes() > 0;
                    Records records = fetchDataInfo.records();
                    if (records instanceof MemoryRecords) {
                        MemoryRecords memoryRecords2;
                        memoryRecords = memoryRecords2 = (MemoryRecords)records;
                    } else if (records instanceof FileRecords) {
                        Buffer buffer2;
                        FileRecords fileRecords = (FileRecords)records;
                        int sizeInBytes = fileRecords.sizeInBytes();
                        int bytesNeeded = Math.max(this.config.transactionLogLoadBufferSize(), sizeInBytes);
                        if (buffer.capacity() < bytesNeeded) {
                            if (this.config.transactionLogLoadBufferSize() < bytesNeeded) {
                                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(67).append("Loaded transaction metadata from ").append(topicPartition).append(" with buffer larger (").append(bytesNeeded).append(" bytes) than ").toString()).append(new StringBuilder(58).append("configured transaction.state.log.load.buffer.size (").append($this.config.transactionLogLoadBufferSize()).append(" bytes)").toString()).toString());
                            }
                            buffer = ByteBuffer.allocate(bytesNeeded);
                            buffer2 = BoxedUnit.UNIT;
                        } else {
                            buffer2 = buffer.clear();
                        }
                        buffer.clear();
                        fileRecords.readInto(buffer, 0);
                        memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
                    } else {
                        throw new MatchError((Object)records);
                    }
                    MemoryRecords memRecords = memoryRecords;
                    ((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(memRecords.batches()).asScala()).foreach((Function1 & Serializable)batch -> {
                        TransactionStateManager.$anonfun$loadTransactionMetadata$6(loadedTransactions, currOffset, batch);
                        return BoxedUnit.UNIT;
                    });
                    long endMs = this.time.milliseconds();
                    long timeLapse = endMs - startMs;
                    this.partitionLoadSensor().record((double)timeLapse, endMs, false);
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(61).append("Finished loading ").append(loadedTransactions.size()).append(" transaction metadata from ").append(topicPartition).append(" in ").append(timeLapse).append(" milliseconds").toString());
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Error loading transactions from transaction log ").append(topicPartition).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            throw new MatchError(option);
        }
        return loadedTransactions;
    }

    public void addLoadedTransactionsToCache(int txnTopicPartition, int coordinatorEpoch, Pool<String, TransactionMetadata> loadedTransactions) {
        TxnMetadataCacheEntry txnMetadataCacheEntry = new TxnMetadataCacheEntry(coordinatorEpoch, loadedTransactions);
        Option previousTxnMetadataCacheEntryOpt = this.transactionMetadataCache().put((Object)BoxesRunTime.boxToInteger((int)txnTopicPartition), (Object)txnMetadataCacheEntry);
        previousTxnMetadataCacheEntryOpt.foreach((Function1 & Serializable)previousTxnMetadataCacheEntry -> {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(48).append("Unloaded transaction metadata ").append(previousTxnMetadataCacheEntry).append(" from ").append(txnTopicPartition$1).append(" as part of ").toString()).append(new StringBuilder(26).append("loading metadata at epoch ").append(coordinatorEpoch$2).toString()).toString());
            return BoxedUnit.UNIT;
        });
    }

    public void loadTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch, Function5<String, Object, TransactionResult, TransactionMetadata, TxnTransitMetadata, BoxedUnit> sendTxnMarkers) {
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        CoreUtils$.MODULE$.inWriteLock(this.stateLock(), (JFunction0.mcZ.sp & Serializable)() -> this.loadingPartitions().add((Object)partitionAndLeaderEpoch));
        this.scheduler.schedule(new StringBuilder(24).append("load-txns-for-partition-").append(topicPartition).toString(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.loadTransactions$1(topicPartition, coordinatorEpoch, partitionAndLeaderEpoch, sendTxnMarkers), this.scheduler.schedule$default$3(), this.scheduler.schedule$default$4(), this.scheduler.schedule$default$5());
    }

    public void removeTransactionsForTxnTopicPartition(int partitionId) {
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        CoreUtils$.MODULE$.inWriteLock(this.stateLock(), (JFunction0.mcV.sp & Serializable)() -> {
            this.loadingPartitions().retain((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$2(partitionId, x$4)));
            this.transactionMetadataCache().remove((Object)BoxesRunTime.boxToInteger((int)partitionId)).foreach((Function1 & Serializable)txnMetadataCacheEntry -> {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(46).append("Unloaded transaction metadata ").append(txnMetadataCacheEntry).append(" for ").append(topicPartition$4).append(" following ").toString()).append("local partition deletion").toString());
                return BoxedUnit.UNIT;
            });
        });
    }

    public void removeTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch) {
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        CoreUtils$.MODULE$.inWriteLock(this.stateLock(), (JFunction0.mcV.sp & Serializable)() -> {
            this.loadingPartitions().remove((Object)partitionAndLeaderEpoch);
            Option option = this.transactionMetadataCache().remove((Object)BoxesRunTime.boxToInteger((int)partitionId));
            if (option instanceof Some) {
                Some some = (Some)option;
                TxnMetadataCacheEntry txnMetadataCacheEntry = (TxnMetadataCacheEntry)some.value();
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(65).append("Unloaded transaction metadata ").append(txnMetadataCacheEntry).append(" for ").append(topicPartition).append(" on become-follower transition").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append("No cached transaction metadata found for ").append(topicPartition).append(" during become-follower transition").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
        });
    }

    private void validateTransactionTopicPartitionCountIsStable() {
        int curTransactionTopicPartitionCount = this.getTransactionTopicPartitionCount();
        if (this.transactionTopicPartitionCount() != curTransactionTopicPartitionCount) {
            throw new KafkaException(new StringBuilder(60).append("Transaction topic number of partitions has changed from ").append(this.transactionTopicPartitionCount()).append(" to ").append(curTransactionTopicPartitionCount).toString());
        }
    }

    public void appendTransactionToLog(String transactionalId, int coordinatorEpoch, TxnTransitMetadata newMetadata, Function1<Errors, BoxedUnit> responseCallback, Function1<Errors, Object> retryOnError) {
        byte[] keyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
        byte[] valueBytes = TransactionLog$.MODULE$.valueToBytes(newMetadata);
        long timestamp = this.time.milliseconds();
        MemoryRecords records = MemoryRecords.withRecords((CompressionType)TransactionLog$.MODULE$.EnforcedCompressionType(), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(timestamp, keyBytes, valueBytes)});
        TopicPartition topicPartition = new TopicPartition("__transaction_state", this.partitionFor(transactionalId));
        scala.collection.immutable.Map recordsPerPartition = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)records)}));
        CoreUtils$.MODULE$.inReadLock(this.stateLock(), (JFunction0.mcV.sp & Serializable)() -> {
            BoxedUnit boxedUnit;
            boolean bl = false;
            Right right = null;
            Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = this.getTransactionState(transactionalId);
            if (either instanceof Left) {
                Left left = (Left)either;
                Errors err = (Errors)left.value();
                BoxedUnit boxedUnit2 = (BoxedUnit)responseCallback.apply((Object)err);
                return;
            }
            if (either instanceof Right) {
                bl = true;
                right = (Right)either;
                Option option = (Option)right.value();
                if (None$.MODULE$.equals(option)) {
                    BoxedUnit boxedUnit3 = (BoxedUnit)responseCallback.apply((Object)Errors.NOT_COORDINATOR);
                    return;
                }
            }
            if (!bl) throw new MatchError(either);
            Option option = (Option)right.value();
            if (!(option instanceof Some)) throw new MatchError(either);
            Some some = (Some)option;
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
            TransactionMetadata metadata = epochAndMetadata.transactionMetadata();
            boolean append = BoxesRunTime.unboxToBoolean(metadata.inLock((JFunction0.mcZ.sp & Serializable)() -> {
                boolean bl;
                if (epochAndMetadata.coordinatorEpoch() != coordinatorEpoch) {
                    responseCallback.apply((Object)Errors.NOT_COORDINATOR);
                    bl = false;
                } else {
                    bl = true;
                }
                return bl;
            }));
            if (append) {
                $this.replicaManager.appendRecords(newMetadata.txnTimeoutMs(), TransactionLog$.MODULE$.EnforcedRequiredAcks(), true, AppendOrigin$Coordinator$.MODULE$, (Map<TopicPartition, MemoryRecords>)recordsPerPartition, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)(Function1 & Serializable)responseStatus -> {
                    this.updateCacheCallback$1(responseStatus, topicPartition, transactionalId, newMetadata, coordinatorEpoch, retryOnError, responseCallback);
                    return BoxedUnit.UNIT;
                }, (Option<Lock>)new Some((Object)this.stateLock().readLock()), $this.replicaManager.appendRecords$default$8());
                this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(96).append("Appending new metadata ").append(newMetadata).append(" for transaction id ").append(transactionalId).append(" with coordinator epoch ").append(coordinatorEpoch).append(" to the local transaction log").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit;
        });
    }

    public Function1<Errors, Object> appendTransactionToLog$default$5() {
        return (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$appendTransactionToLog$default$5$1(x$5));
    }

    public void shutdown() {
        this.shuttingDown().set(true);
        this.loadingPartitions().clear();
        this.transactionMetadataCache().clear();
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutdown complete");
    }

    public static final /* synthetic */ boolean $anonfun$timedOutTransactions$3(long now$1, Tuple2 x0$2) {
        boolean bl;
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._2();
            if (txnMetadata.pendingTransitionInProgress()) {
                bl = false;
            } else {
                TransactionState transactionState = txnMetadata.state();
                boolean bl2 = Ongoing$.MODULE$.equals(transactionState) ? txnMetadata.txnStartTimestamp() + (long)txnMetadata.txnTimeoutMs() < now$1 : false;
                bl = bl2;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        boolean bl3 = bl;
        return bl3;
    }

    public static final /* synthetic */ boolean $anonfun$enableTransactionalIdExpiration$4(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._2();
        TransactionState transactionState = txnMetadata.state();
        boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState));
        boolean bl2 = bl;
        boolean bl3 = bl2;
        return bl3;
    }

    public static final /* synthetic */ boolean $anonfun$enableTransactionalIdExpiration$5(TransactionStateManager $this, long now$2, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._2();
        boolean bl = txnMetadata.txnLastUpdateTimestamp() <= now$2 - (long)$this.config.transactionalIdExpirationMs();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$enableTransactionalIdExpiration$11(TransactionStateManager $this, scala.collection.immutable.Map transactionalIdByPartition$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        ProduceResponse.PartitionResponse response = (ProduceResponse.PartitionResponse)tuple2._2();
        BoxedUnit boxedUnit = (BoxedUnit)CoreUtils$.MODULE$.inReadLock($this.stateLock(), (JFunction0.mcV.sp & Serializable)() -> {
            scala.collection.mutable.Iterable toRemove = (scala.collection.mutable.Iterable)transactionalIdByPartition$1.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()));
            $this.transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())).foreach((Function1 & Serializable)txnMetadataCacheEntry -> {
                toRemove.foreach((Function1 & Serializable)idCoordinatorEpochAndMetadata -> {
                    String transactionalId = idCoordinatorEpochAndMetadata.transactionalId();
                    TransactionMetadata txnMetadata = txnMetadataCacheEntry.metadataPerTransactionalId().get(transactionalId);
                    return txnMetadata.inLock((Function0 & Serializable)() -> {
                        Object object;
                        if (txnMetadataCacheEntry.coordinatorEpoch() == idCoordinatorEpochAndMetadata.coordinatorEpoch() && txnMetadata.pendingState().contains((Object)Dead$.MODULE$) && txnMetadata.producerEpoch() == idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()) {
                            Errors errors = response$1.error;
                            Errors errors2 = Errors.NONE;
                            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                                object = txnMetadataCacheEntry.metadataPerTransactionalId().remove(transactionalId);
                                return object;
                            }
                        }
                        $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(42).append("Failed to remove expired transactionalId: ").append(transactionalId).toString()).append(new StringBuilder(43).append(" from cache. Tombstone append error code: ").append(response$1.error).append(",").toString()).append(new StringBuilder(33).append(" pendingState: ").append(txnMetadata.pendingState()).append(", producerEpoch: ").append(txnMetadata.producerEpoch()).append(",").toString()).append(new StringBuilder(26).append(" expected producerEpoch: ").append(idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()).append(",").toString()).append(new StringBuilder(48).append(" coordinatorEpoch: ").append(txnMetadataCacheEntry.coordinatorEpoch()).append(", expected coordinatorEpoch: ").toString()).append(String.valueOf(BoxesRunTime.boxToInteger((int)idCoordinatorEpochAndMetadata.coordinatorEpoch()))).toString());
                        txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                        object = BoxedUnit.UNIT;
                        return object;
                    });
                });
                return BoxedUnit.UNIT;
            });
        });
    }

    private final void removeFromCacheCallback$1(Map responses, scala.collection.immutable.Map transactionalIdByPartition$1) {
        responses.foreach((Function1 & Serializable)x0$1 -> {
            TransactionStateManager.$anonfun$enableTransactionalIdExpiration$11(this, transactionalIdByPartition$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getAndMaybeAddTransactionState$2(int partitionId$1, TransactionPartitionAndLeaderEpoch x$2) {
        return x$2.txnPartitionId() == partitionId$1;
    }

    private final long logEndOffset$1(TopicPartition topicPartition$2) {
        return BoxesRunTime.unboxToLong((Object)this.replicaManager.getLogEndOffset(topicPartition$2).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionMetadata$4(TopicPartition topicPartition$2, int coordinatorEpoch$1, TransactionPartitionAndLeaderEpoch idAndEpoch) {
        return idAndEpoch.txnPartitionId() == topicPartition$2.partition() && idAndEpoch.coordinatorEpoch() == coordinatorEpoch$1;
    }

    public static final /* synthetic */ void $anonfun$loadTransactionMetadata$7(Pool loadedTransactions$1, LongRef currOffset$1, MutableRecordBatch batch$1, Record record) {
        TransactionMetadata transactionMetadata;
        Predef$.MODULE$.require(record.hasKey(), (Function0 & Serializable)() -> "Transaction state log's key should not be null");
        TxnKey txnKey = TransactionLog$.MODULE$.readTxnRecordKey(record.key());
        String transactionalId = txnKey.transactionalId();
        Option<TransactionMetadata> option = TransactionLog$.MODULE$.readTxnRecordValue(transactionalId, record.value());
        if (None$.MODULE$.equals(option)) {
            transactionMetadata = (TransactionMetadata)loadedTransactions$1.remove(transactionalId);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            TransactionMetadata txnMetadata = (TransactionMetadata)some.value();
            transactionMetadata = loadedTransactions$1.put(transactionalId, txnMetadata);
        } else {
            throw new MatchError(option);
        }
        currOffset$1.elem = batch$1.nextOffset();
    }

    public static final /* synthetic */ void $anonfun$loadTransactionMetadata$6(Pool loadedTransactions$1, LongRef currOffset$1, MutableRecordBatch batch) {
        ((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1 & Serializable)record -> {
            TransactionStateManager.$anonfun$loadTransactionMetadata$7(loadedTransactions$1, currOffset$1, batch, record);
            return BoxedUnit.UNIT;
        });
    }

    private final void loadTransactions$1(TopicPartition topicPartition$3, int coordinatorEpoch$3, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2, Function5 sendTxnMarkers$1) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Loading transaction metadata from ").append(topicPartition$3).append(" at epoch ").append(coordinatorEpoch$3).toString());
        this.validateTransactionTopicPartitionCountIsStable();
        Pool<String, TransactionMetadata> loadedTransactions = this.loadTransactionMetadata(topicPartition$3, coordinatorEpoch$3);
        CoreUtils$.MODULE$.inWriteLock(this.stateLock(), (JFunction0.mcV.sp & Serializable)() -> {
            block0: {
                if (!this.loadingPartitions().contains((Object)partitionAndLeaderEpoch$2)) break block0;
                this.addLoadedTransactionsToCache(topicPartition$3.partition(), coordinatorEpoch$3, loadedTransactions);
                ListBuffer transactionsPendingForCompletion = new ListBuffer();
                loadedTransactions.foreach((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String transactionalId = (String)tuple2._1();
                    TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._2();
                    Object t = txnMetadata.inLock((Function0 & Serializable)() -> {
                        TransactionState transactionState = txnMetadata.state();
                        Object object = PrepareAbort$.MODULE$.equals(transactionState) ? transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.ABORT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()))) : (PrepareCommit$.MODULE$.equals(transactionState) ? transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.COMMIT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()))) : BoxedUnit.UNIT);
                        return object;
                    });
                    return t;
                });
                this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$2);
                transactionsPendingForCompletion.foreach((Function1 & Serializable)txnTransitMetadata -> {
                    sendTxnMarkers$1.apply((Object)txnTransitMetadata.transactionalId(), (Object)BoxesRunTime.boxToInteger((int)txnTransitMetadata.coordinatorEpoch()), (Object)txnTransitMetadata.result(), (Object)txnTransitMetadata.txnMetadata(), (Object)txnTransitMetadata.transitMetadata());
                    return BoxedUnit.UNIT;
                });
            }
        });
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(67).append("Completed loading transaction metadata from ").append(topicPartition$3).append(" for coordinator epoch ").append(coordinatorEpoch$3).toString());
    }

    public static final /* synthetic */ boolean $anonfun$removeTransactionsForTxnTopicPartition$2(int partitionId$2, TransactionPartitionAndLeaderEpoch x$4) {
        return x$4.txnPartitionId() != partitionId$2;
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$1(String transactionalId$4, TxnTransitMetadata newMetadata$1, ProduceResponse.PartitionResponse status$1) {
        return new StringBuilder(41).append("Appending ").append(transactionalId$4).append("'s new metadata ").append(newMetadata$1).append(" failed due to ").append(status$1.error.exceptionName()).toString();
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$2(String transactionalId$4, Errors err$1) {
        return new StringBuilder(0).append(new StringBuilder(63).append("Accessing the cached transaction metadata for ").append(transactionalId$4).append(" returns ").append(err$1).append(" error; ").toString()).append("aborting transition to the new metadata and setting the error in the callback").toString();
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$3(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndMetadata$1, int coordinatorEpoch$4, String transactionalId$4, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, TransactionMetadata metadata$1) {
        if (epochAndMetadata$1.coordinatorEpoch() != coordinatorEpoch$4) {
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(83).append("The cached coordinator epoch for ").append(transactionalId$4).append(" has changed to ").append(epochAndMetadata$1.coordinatorEpoch()).append(" after appended its new metadata ").append(newMetadata$1).append(" ").toString()).append(new StringBuilder(78).append("to the transaction log (txn topic partition ").append($this.partitionFor(transactionalId$4)).append(") while it was ").append(coordinatorEpoch$4).append(" before appending; ").toString()).append(new StringBuilder(70).append("aborting transition to the new metadata and returning ").append(Errors.NOT_COORDINATOR).append(" in the callback").toString()).toString());
            responseError$1.elem = Errors.NOT_COORDINATOR;
        } else {
            metadata$1.completeTransitionTo(newMetadata$1);
            $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(72).append("Updating ").append(transactionalId$4).append("'s transaction state to ").append(newMetadata$1).append(" with coordinator epoch ").append(coordinatorEpoch$4).append(" for ").append(transactionalId$4).append(" succeeded").toString());
        }
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$6(TransactionStateManager $this, String transactionalId$4, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$4) {
        return new StringBuilder(0).append(new StringBuilder(106).append("The cached coordinator metadata does not exist in the cache anymore for ").append(transactionalId$4).append(" after appended its new metadata ").append(newMetadata$1).append(" ").toString()).append(new StringBuilder(78).append("to the transaction log (txn topic partition ").append($this.partitionFor(transactionalId$4)).append(") while it was ").append(coordinatorEpoch$4).append(" before appending; ").toString()).append(new StringBuilder(70).append("aborting transition to the new metadata and returning ").append(Errors.NOT_COORDINATOR).append(" in the callback").toString()).toString();
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$7(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndTxnMetadata$1, int coordinatorEpoch$4, Function1 retryOnError$1, ObjectRef responseError$1, TransactionMetadata metadata$2, TxnTransitMetadata newMetadata$1) {
        if (epochAndTxnMetadata$1.coordinatorEpoch() == coordinatorEpoch$4) {
            if (BoxesRunTime.unboxToBoolean((Object)retryOnError$1.apply((Object)((Errors)responseError$1.elem)))) {
                $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(72).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").toString()).append(new StringBuilder(97).append("not resetting pending state ").append(metadata$2.pendingState()).append(" but just returning the error in the callback to let the caller retry").toString()).toString());
            } else {
                $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(72).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").toString()).append(new StringBuilder(87).append("resetting pending state from ").append(metadata$2.pendingState()).append(", aborting state transition and returning ").append((Errors)responseError$1.elem).append(" in the callback").toString()).toString());
                metadata$2.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
            }
        } else {
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(72).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").toString()).append(new StringBuilder(115).append("aborting state transition and returning the error in the callback since the coordinator epoch has changed from ").append(epochAndTxnMetadata$1.coordinatorEpoch()).append(" to ").append(coordinatorEpoch$4).toString()).toString());
        }
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$11(String transactionalId$4, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1) {
        return new StringBuilder(0).append(new StringBuilder(72).append("TransactionalId ").append(transactionalId$4).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").toString()).append("aborting state transition and returning the error in the callback since metadata is not available in the cache anymore").toString();
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$12(String transactionalId$4, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, Errors error$1) {
        return new StringBuilder(0).append(new StringBuilder(72).append("TransactionalId ").append(transactionalId$4).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").toString()).append(new StringBuilder(101).append("aborting state transition and returning the error in the callback since retrieving metadata returned ").append(error$1).toString()).toString();
    }

    /*
     * Unable to fully structure code
     */
    private final void updateCacheCallback$1(Map responseStatus, TopicPartition topicPartition$6, String transactionalId$4, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$4, Function1 retryOnError$1, Function1 responseCallback$1) {
        block15: {
            block13: {
                block17: {
                    block16: {
                        block14: {
                            if (responseStatus.size() != 1 || !responseStatus.contains((Object)topicPartition$6)) {
                                throw new IllegalStateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Append status %s should only have one partition %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{responseStatus, topicPartition$6})));
                            }
                            status = (ProduceResponse.PartitionResponse)responseStatus.apply((Object)topicPartition$6);
                            v0 = status.error;
                            var16_9 = Errors.NONE;
                            if (!(v0 != null ? v0.equals(var16_9) == false : var16_9 != null)) {
                                v1 = Errors.NONE;
                            } else {
                                this.debug((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$1(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata org.apache.kafka.common.requests.ProduceResponse$PartitionResponse ), ()Ljava/lang/String;)((String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (ProduceResponse.PartitionResponse)status));
                                var17_10 = status.error;
                                var13_11 = Errors.UNKNOWN_TOPIC_OR_PARTITION.equals(var17_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS.equals(var17_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND.equals(var17_10) != false ? true : Errors.REQUEST_TIMED_OUT.equals(var17_10) != false));
                                if (var13_11) {
                                    var10_12 = Errors.COORDINATOR_NOT_AVAILABLE;
                                } else {
                                    var12_13 = Errors.NOT_LEADER_FOR_PARTITION.equals(var17_10) != false ? true : Errors.KAFKA_STORAGE_ERROR.equals(var17_10) != false;
                                    if (var12_13) {
                                        var10_12 = Errors.NOT_COORDINATOR;
                                    } else {
                                        var11_14 = Errors.MESSAGE_TOO_LARGE.equals(var17_10) != false ? true : Errors.RECORD_LIST_TOO_LARGE.equals(var17_10) != false;
                                        var10_12 = var11_14 != false ? Errors.UNKNOWN_SERVER_ERROR : var17_10;
                                    }
                                }
                                v1 = var10_12;
                            }
                            responseError = ObjectRef.create((Object)v1);
                            v2 = (Errors)responseError.elem;
                            var18_16 = Errors.NONE;
                            if (v2 != null ? v2.equals(var18_16) == false : var18_16 != null) break block13;
                            var19_17 = false;
                            var20_18 = null;
                            var21_19 = this.getTransactionState(transactionalId$4);
                            if (!(var21_19 instanceof Left)) break block14;
                            var22_20 = (Left)var21_19;
                            err = (Errors)var22_20.value();
                            this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$2(java.lang.String org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$4, (Errors)err));
                            responseError.elem = err;
                            var9_22 = BoxedUnit.UNIT;
                            break block15;
                        }
                        if (!(var21_19 instanceof Right)) break block16;
                        var19_17 = true;
                        var20_18 = (Right)var21_19;
                        var24_25 = (Option)var20_18.value();
                        if (!(var24_25 instanceof Some)) break block16;
                        var25_26 = (Some)var24_25;
                        epochAndMetadata = (CoordinatorEpochAndTxnMetadata)var25_26.value();
                        metadata = epochAndMetadata.transactionMetadata();
                        var9_23 = (BoxedUnit)metadata.inLock((JFunction0.mcV.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$3(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata ), ()V)((TransactionStateManager)this, (CoordinatorEpochAndTxnMetadata)epochAndMetadata, (int)coordinatorEpoch$4, (String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (TransactionMetadata)metadata));
                        break block15;
                    }
                    if (!var19_17 || !None$.MODULE$.equals(var28_29 = (Option)var20_18.value())) break block17;
                    this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$6(kafka.coordinator.transaction.TransactionStateManager java.lang.String kafka.coordinator.transaction.TxnTransitMetadata int ), ()Ljava/lang/String;)((TransactionStateManager)this, (String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (int)coordinatorEpoch$4));
                    responseError.elem = Errors.NOT_COORDINATOR;
                    var9_24 = BoxedUnit.UNIT;
                    break block15;
                }
                throw new MatchError(var21_19);
            }
            var29_30 = false;
            var30_31 = null;
            var31_32 = this.getTransactionState(transactionalId$4);
            if (!(var31_32 instanceof Right)) ** GOTO lbl-1000
            var29_30 = true;
            var30_31 = (Right)var31_32;
            var32_33 = (Option)var30_31.value();
            if (var32_33 instanceof Some) {
                var33_34 = (Some)var32_33;
                epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)var33_34.value();
                metadata = epochAndTxnMetadata.transactionMetadata();
                var8_37 = (BoxedUnit)metadata.inLock((JFunction0.mcV.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$7(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int scala.Function1 scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata kafka.coordinator.transaction.TxnTransitMetadata ), ()V)((TransactionStateManager)this, (CoordinatorEpochAndTxnMetadata)epochAndTxnMetadata, (int)coordinatorEpoch$4, (Function1)retryOnError$1, (ObjectRef)responseError, (TransactionMetadata)metadata, (TxnTransitMetadata)newMetadata$1));
            } else if (var29_30 && None$.MODULE$.equals(var36_40 = (Option)var30_31.value())) {
                this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$11(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef ), ()Ljava/lang/String;)((String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError));
                var8_38 = BoxedUnit.UNIT;
            } else if (var31_32 instanceof Left) {
                var37_41 = (Left)var31_32;
                error = (Errors)var37_41.value();
                this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$12(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (Errors)error));
                var8_39 = BoxedUnit.UNIT;
            } else {
                throw new MatchError(var31_32);
            }
        }
        responseCallback$1.apply((Object)((Errors)responseError.elem));
    }

    public static final /* synthetic */ boolean $anonfun$appendTransactionToLog$default$5$1(Errors x$5) {
        return false;
    }

    public TransactionStateManager(int brokerId, KafkaZkClient zkClient, Scheduler scheduler, ReplicaManager replicaManager, TransactionConfig config, Time time, Metrics metrics) {
        this.zkClient = zkClient;
        this.scheduler = scheduler;
        this.replicaManager = replicaManager;
        this.config = config;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(30).append("[Transaction State Manager ").append(brokerId).append("]: ").toString());
        this.shuttingDown = new AtomicBoolean(false);
        this.stateLock = new ReentrantReadWriteLock();
        this.loadingPartitions = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.transactionMetadataCache = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.transactionTopicPartitionCount = this.getTransactionTopicPartitionCount();
        this.partitionLoadSensor = metrics.sensor("PartitionLoadTime");
        this.partitionLoadSensor().add(metrics.metricName("partition-load-time-max", "transaction-coordinator-metrics", "The max time it took to load the partitions in the last 30sec"), (MeasurableStat)new Max());
        this.partitionLoadSensor().add(metrics.metricName("partition-load-time-avg", "transaction-coordinator-metrics", "The avg time it took to load the partitions in the last 30sec"), (MeasurableStat)new Avg());
    }
}

