/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.common.ClientIdAndBroker;
import kafka.server.ClientIdTopicPartition;
import kafka.server.FetcherLagMetrics;
import kafka.utils.Pool;
import org.apache.kafka.common.TopicPartition;
import scala.Function1;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005Q3Aa\u0003\u0007\u0001#!A\u0001\u0004\u0001B\u0001B\u0003%\u0011\u0004C\u0003 \u0001\u0011\u0005\u0001\u0005C\u0004%\u0001\t\u0007I\u0011B\u0013\t\r=\u0002\u0001\u0015!\u0003'\u0011\u001d\u0001\u0004A1A\u0005\u0002EBa\u0001\u000f\u0001!\u0002\u0013\u0011\u0004\"B\u001d\u0001\t\u0003Q\u0004\"B$\u0001\t\u0003A\u0005\"B'\u0001\t\u0003q\u0005\"B'\u0001\t\u0003\u0019&a\u0004$fi\u000eDWM\u001d'bON#\u0018\r^:\u000b\u00055q\u0011AB:feZ,'OC\u0001\u0010\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g\u0003!iW\r\u001e:jG&#\u0007C\u0001\u000e\u001e\u001b\u0005Y\"B\u0001\u000f\u000f\u0003\u0019\u0019w.\\7p]&\u0011ad\u0007\u0002\u0012\u00072LWM\u001c;JI\u0006sGM\u0011:pW\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0002\"GA\u0011!\u0005A\u0007\u0002\u0019!)\u0001D\u0001a\u00013\u0005aa/\u00197vK\u001a\u000b7\r^8ssV\ta\u0005\u0005\u0003\u0014O%b\u0013B\u0001\u0015\u0015\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002#U%\u00111\u0006\u0004\u0002\u0017\u00072LWM\u001c;JIR{\u0007/[2QCJ$\u0018\u000e^5p]B\u0011!%L\u0005\u0003]1\u0011\u0011CR3uG\",'\u000fT1h\u001b\u0016$(/[2t\u000351\u0018\r\\;f\r\u0006\u001cGo\u001c:zA\u0005)1\u000f^1ugV\t!\u0007\u0005\u00034m%bS\"\u0001\u001b\u000b\u0005Ur\u0011!B;uS2\u001c\u0018BA\u001c5\u0005\u0011\u0001vn\u001c7\u0002\rM$\u0018\r^:!\u000399W\r^!oI6\u000b\u0017PY3QkR$\"\u0001L\u001e\t\u000bq:\u0001\u0019A\u001f\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B\u0011a(R\u0007\u0002\u007f)\u0011A\u0004\u0011\u0006\u0003\u001f\u0005S!AQ\"\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0015aA8sO&\u0011ai\u0010\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=I7OU3qY&\u001c\u0017-\u00138Ts:\u001cGCA%M!\t\u0019\"*\u0003\u0002L)\t9!i\\8mK\u0006t\u0007\"\u0002\u001f\t\u0001\u0004i\u0014AC;oe\u0016<\u0017n\u001d;feR\u0011qJ\u0015\t\u0003'AK!!\u0015\u000b\u0003\tUs\u0017\u000e\u001e\u0005\u0006y%\u0001\r!\u0010\u000b\u0002\u001f\u0002")
public class FetcherLagStats {
    private final ClientIdAndBroker metricId;
    private final Function1<ClientIdTopicPartition, FetcherLagMetrics> valueFactory;
    private final Pool<ClientIdTopicPartition, FetcherLagMetrics> stats;

    private Function1<ClientIdTopicPartition, FetcherLagMetrics> valueFactory() {
        return this.valueFactory;
    }

    public Pool<ClientIdTopicPartition, FetcherLagMetrics> stats() {
        return this.stats;
    }

    public FetcherLagMetrics getAndMaybePut(TopicPartition topicPartition) {
        return this.stats().getAndMaybePut(new ClientIdTopicPartition(this.metricId.clientId(), topicPartition));
    }

    public boolean isReplicaInSync(TopicPartition topicPartition) {
        FetcherLagMetrics fetcherLagMetrics = this.stats().get(new ClientIdTopicPartition(this.metricId.clientId(), topicPartition));
        return fetcherLagMetrics != null ? fetcherLagMetrics.lag() <= 0L : false;
    }

    public void unregister(TopicPartition topicPartition) {
        block0: {
            FetcherLagMetrics lagMetrics = this.stats().remove(new ClientIdTopicPartition(this.metricId.clientId(), topicPartition));
            if (lagMetrics == null) break block0;
            lagMetrics.unregister();
        }
    }

    public void unregister() {
        this.stats().keys().toBuffer().foreach((Function1 & Serializable)key -> {
            this.unregister(key.topicPartition());
            return BoxedUnit.UNIT;
        });
    }

    public FetcherLagStats(ClientIdAndBroker metricId) {
        this.metricId = metricId;
        this.valueFactory = (Function1 & Serializable)k -> new FetcherLagMetrics((ClientIdTopicPartition)k);
        this.stats = new Pool(new Some(this.valueFactory()));
    }
}

