/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.api.LeaderAndIsr;
import kafka.cluster.DelayedOperations;
import kafka.cluster.Partition;
import kafka.cluster.PartitionStateStore;
import kafka.log.AppendOrigin;
import kafka.log.CleanerConfig;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Builder;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.DurationConversions;
import scala.concurrent.duration.package;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tee\u0001B\u00193\u0001]BQ\u0001\u0012\u0001\u0005\u0002\u0015Cq\u0001\u0013\u0001C\u0002\u0013\u0005\u0011\n\u0003\u0004N\u0001\u0001\u0006IA\u0013\u0005\b\u001d\u0002\u0011\r\u0011\"\u0001J\u0011\u0019y\u0005\u0001)A\u0005\u0015\"9\u0001\u000b\u0001b\u0001\n\u0003I\u0005BB)\u0001A\u0003%!\nC\u0004S\u0001\t\u0007I\u0011A*\t\r]\u0003\u0001\u0015!\u0003U\u0011\u001dA\u0006A1A\u0005\u0002eCaA\u0019\u0001!\u0002\u0013Q\u0006bB2\u0001\u0005\u0004%\t!\u0017\u0005\u0007I\u0002\u0001\u000b\u0011\u0002.\t\u000f\u0015\u0004!\u0019!C\u0001M\"1q\u000e\u0001Q\u0001\n\u001dDq\u0001\u001d\u0001C\u0002\u0013\u0005\u0011\u000f\u0003\u0004v\u0001\u0001\u0006IA\u001d\u0005\bm\u0002\u0011\r\u0011\"\u0001r\u0011\u00199\b\u0001)A\u0005e\"9\u0001\u0010\u0001b\u0001\n\u0003I\bbBA\u0013\u0001\u0001\u0006IA\u001f\u0005\f\u0003O\u0001\u0001\u0019!a\u0001\n\u0003\tI\u0003C\u0006\u00028\u0001\u0001\r\u00111A\u0005\u0002\u0005e\u0002bCA#\u0001\u0001\u0007\t\u0011)Q\u0005\u0003WA1\"a\u0012\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002J!Y\u0011\u0011\u000b\u0001A\u0002\u0003\u0007I\u0011AA*\u0011-\t9\u0006\u0001a\u0001\u0002\u0003\u0006K!a\u0013\t\u000f\u0005e\u0003\u0001\"\u0001\u0002\\!9\u00111\u000e\u0001\u0005\u0002\u0005m\u0003bBA;\u0001\u0011\u0005\u00111\f\u0005\b\u0003\u007f\u0002A\u0011AA.\u0011\u001d\t\u0019\t\u0001C\u0001\u00037Bq!a\"\u0001\t\u0003\tY\u0006C\u0004\u0002\f\u0002!I!a\u0017\t\u000f\u00055\u0005\u0001\"\u0003\u0002\\!9\u0011q\u0012\u0001\u0005\n\u0005E\u0005bBAe\u0001\u0011%\u00111\u001a\u0005\b\u0003;\u0004A\u0011BAp\u0011\u001d\u0011)\u0001\u0001C\u0005\u0005\u000fAqA!\u0006\u0001\t\u0013\u00119\u0002C\u0004\u0003<\u0001!IA!\u0010\t\u000f\t\u001d\u0003\u0001\"\u0003\u0003J\u00191!q\u000b\u0001\u0005\u00053B!\"!\r,\u0005\u0003\u0005\u000b\u0011\u0002B.\u0011!\u00116F!A!\u0002\u0013!\u0006\u0002\u00039,\u0005\u0003\u0005\u000b\u0011\u0002:\t\r\u0011[C\u0011\u0001B1\u0011\u001d\u0011ig\u000bC!\u0005_\u0012\u0011\u0003U1si&$\u0018n\u001c8M_\u000e\\G+Z:u\u0015\t\u0019D'A\u0004dYV\u001cH/\u001a:\u000b\u0003U\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001qy\u0002\"!\u000f\u001f\u000e\u0003iR\u0011aO\u0001\u0006g\u000e\fG.Y\u0005\u0003{i\u0012a!\u00118z%\u00164\u0007CA C\u001b\u0005\u0001%BA!5\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0005IA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u00051\u0005CA$\u0001\u001b\u0005\u0011\u0014A\u00058v[J+\u0007\u000f\\5dC\u001a+Go\u00195feN,\u0012A\u0013\t\u0003s-K!\u0001\u0014\u001e\u0003\u0007%sG/A\nok6\u0014V\r\u001d7jG\u00064U\r^2iKJ\u001c\b%\u0001\u0007ok6\u0004&o\u001c3vG\u0016\u00148/A\u0007ok6\u0004&o\u001c3vG\u0016\u00148\u000fI\u0001\u0016]Vl'+Z2pe\u0012\u001c\b+\u001a:Qe>$WoY3s\u0003YqW/\u001c*fG>\u0014Hm\u001d)feB\u0013x\u000eZ;dKJ\u0004\u0013\u0001C7pG.$\u0016.\\3\u0016\u0003Q\u0003\"aP+\n\u0005Y\u0003%\u0001C'pG.$\u0016.\\3\u0002\u00135|7m\u001b+j[\u0016\u0004\u0013A\u0002;na\u0012K'/F\u0001[!\tY\u0006-D\u0001]\u0015\tif,\u0001\u0002j_*\tq,\u0001\u0003kCZ\f\u0017BA1]\u0005\u00111\u0015\u000e\\3\u0002\u000fQl\u0007\u000fR5sA\u00051An\\4ESJ\fq\u0001\\8h\t&\u0014\b%A\bfq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f+\u00059\u0007C\u00015n\u001b\u0005I'B\u00016l\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003Yz\u000bA!\u001e;jY&\u0011a.\u001b\u0002\u0010\u000bb,7-\u001e;peN+'O^5dK\u0006\u0001R\r_3dkR|'oU3sm&\u001cW\rI\u0001\u0010CB\u0004XM\u001c3TK6\f\u0007\u000f[8sKV\t!\u000f\u0005\u0002ig&\u0011A/\u001b\u0002\n'\u0016l\u0017\r\u001d5pe\u0016\f\u0001#\u00199qK:$7+Z7ba\"|'/\u001a\u0011\u0002%MD'/\u001b8l\u0013N\u00148+Z7ba\"|'/Z\u0001\u0014g\"\u0014\u0018N\\6JgJ\u001cV-\\1qQ>\u0014X\rI\u0001\u000fM>dGn\\<feF+X-^3t+\u0005Q\b#B>\u0002\u0002\u0005\u0015Q\"\u0001?\u000b\u0005ut\u0018!C5n[V$\u0018M\u00197f\u0015\ty((\u0001\u0006d_2dWm\u0019;j_:L1!a\u0001}\u0005)Ie\u000eZ3yK\u0012\u001cV-\u001d\t\u0006Q\u0006\u001d\u00111B\u0005\u0004\u0003\u0013I'AE!se\u0006L(\t\\8dW&tw-U;fk\u0016\u0004B!!\u0004\u0002\"5\u0011\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"\u0001\u0004sK\u000e|'\u000f\u001a\u0006\u0005\u0003+\t9\"\u0001\u0004d_6lwN\u001c\u0006\u0004k\u0005e!\u0002BA\u000e\u0003;\ta!\u00199bG\",'BAA\u0010\u0003\ry'oZ\u0005\u0005\u0003G\tyAA\u0007NK6|'/\u001f*fG>\u0014Hm]\u0001\u0010M>dGn\\<feF+X-^3tA\u0005QAn\\4NC:\fw-\u001a:\u0016\u0005\u0005-\u0002\u0003BA\u0017\u0003gi!!a\f\u000b\u0007\u0005EB'A\u0002m_\u001eLA!!\u000e\u00020\tQAj\\4NC:\fw-\u001a:\u0002\u001d1|w-T1oC\u001e,'o\u0018\u0013fcR!\u00111HA!!\rI\u0014QH\u0005\u0004\u0003\u007fQ$\u0001B+oSRD\u0011\"a\u0011\u0018\u0003\u0003\u0005\r!a\u000b\u0002\u0007a$\u0013'A\u0006m_\u001el\u0015M\\1hKJ\u0004\u0013!\u00039beRLG/[8o+\t\tY\u0005E\u0002H\u0003\u001bJ1!a\u00143\u0005%\u0001\u0016M\u001d;ji&|g.A\u0007qCJ$\u0018\u000e^5p]~#S-\u001d\u000b\u0005\u0003w\t)\u0006C\u0005\u0002Di\t\t\u00111\u0001\u0002L\u0005Q\u0001/\u0019:uSRLwN\u001c\u0011\u0002\u000bM,G/\u00169\u0015\u0005\u0005m\u0002f\u0001\u000f\u0002`A!\u0011\u0011MA4\u001b\t\t\u0019G\u0003\u0003\u0002f\u0005u\u0011!\u00026v]&$\u0018\u0002BA5\u0003G\u0012aAQ3g_J,\u0017\u0001\u0003;fCJ$un\u001e8)\u0007u\ty\u0007\u0005\u0003\u0002b\u0005E\u0014\u0002BA:\u0003G\u0012Q!\u00114uKJ\fA\u0005^3ti:{Gj\\2l\u0007>tG/\u001a8uS>tw+\u001b;i_V$\u0018j\u001d:Va\u0012\fG/\u001a\u0015\u0004=\u0005e\u0004\u0003BA1\u0003wJA!! \u0002d\t!A+Z:u\u0003Q\"Xm\u001d;BaB,g\u000e\u001a*fa2L7-\u0019$fi\u000eDw+\u001b;i'\u000eDW\rZ;mKJ\u001c\u0005.Z2l\r>\u00148\u000b\u001b:j].L5O\u001d\u0015\u0004?\u0005e\u0014a\t;fgR\f\u0005\u000f]3oIJ+\u0007\u000f\\5dC\u001a+Go\u00195XSRDW\u000b\u001d3bi\u0016L5O\u001d\u0015\u0004A\u0005e\u0014\u0001\u000b;fgR<U\r\u001e*fa2L7-Y,ji\",\u0006\u000fZ1uK\u0006\u001b8/[4o[\u0016tG/\u00118e\u0013N\u0014\bfA\u0011\u0002z\u000513m\u001c8dkJ\u0014XM\u001c;Qe>$WoY3GKR\u001c\u0007nV5uQJ+\u0017\r\u001a'pG.|e\u000e\\=\u0002G\r|gnY;se\u0016tG\u000f\u0015:pIV\u001cWMR3uG\"<\u0016\u000e\u001e5Xe&$X\rT8dW\u0006y1o\u00195fIVdW-\u00119qK:$7\u000f\u0006\u0002\u0002\u0014B1\u0011QSAS\u0003WsA!a&\u0002\":!\u0011\u0011TAP\u001b\t\tYJC\u0002\u0002\u001eZ\na\u0001\u0010:p_Rt\u0014\"A\u001e\n\u0007\u0005\r&(A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u001d\u0016\u0011\u0016\u0002\u0004'\u0016\f(bAARuA\"\u0011QVA\\!\u0015A\u0017qVAZ\u0013\r\t\t,\u001b\u0002\u0007\rV$XO]3\u0011\t\u0005U\u0016q\u0017\u0007\u0001\t-\tI\fJA\u0001\u0002\u0003\u0015\t!a/\u0003\u0007}#\u0013'\u0005\u0003\u0002>\u0006\r\u0007cA\u001d\u0002@&\u0019\u0011\u0011\u0019\u001e\u0003\u000f9{G\u000f[5oOB\u0019\u0011(!2\n\u0007\u0005\u001d'HA\u0002B]f\fqc]2iK\u0012,H.Z+qI\u0006$XMR8mY><XM]:\u0015\t\u00055\u0017\u0011\u001c\t\u0007\u0003+\u000b)+a41\t\u0005E\u0017Q\u001b\t\u0006Q\u0006=\u00161\u001b\t\u0005\u0003k\u000b)\u000eB\u0006\u0002X\u0016\n\t\u0011!A\u0003\u0002\u0005m&aA0%e!1\u00111\\\u0013A\u0002)\u000b!B\\;n%\u0016\u001cwN\u001d3t\u0003E\u00198\r[3ek2,7\u000b\u001b:j].L5O\u001d\u000b\u0007\u0003C\fY/a?1\t\u0005\r\u0018q\u001d\t\u0006Q\u0006=\u0016Q\u001d\t\u0005\u0003k\u000b9\u000fB\u0006\u0002j\u001a\n\t\u0011!A\u0003\u0002\u0005m&aA0%g!9\u0011Q\u001e\u0014A\u0002\u0005=\u0018AC1di&4XM\u00127bOB!\u0011\u0011_A|\u001b\t\t\u0019PC\u0002\u0002v&\fa!\u0019;p[&\u001c\u0017\u0002BA}\u0003g\u0014Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0007bBA\u007fM\u0001\u0007\u0011q`\u0001\u0010[>\u001c7\u000eV5nKNcW-\u001a9NgB\u0019\u0011H!\u0001\n\u0007\t\r!H\u0001\u0003M_:<\u0017aF:fiV\u0004\b+\u0019:uSRLwN\\,ji\"lunY6t)\u0019\tYE!\u0003\u0003\f!9\u0011qE\u0014A\u0002\u0005-\u0002b\u0002B\u0007O\u0001\u0007!qB\u0001\nY><7i\u001c8gS\u001e\u0004B!!\f\u0003\u0012%!!1CA\u0018\u0005%aunZ\"p]\u001aLw-A\nde\u0016\fG/\u001a'pOB\u0013x\u000e]3si&,7\u000f\u0006\u0003\u0003\u001a\t\u0005\u0002\u0003\u0002B\u000e\u0005;i\u0011a[\u0005\u0004\u0005?Y'A\u0003)s_B,'\u000f^5fg\"9!1\u0005\u0015A\u0002\t\u0015\u0012!C8wKJ\u0014\u0018\u000eZ3t!!\u00119Ca\f\u00036\tUb\u0002\u0002B\u0015\u0005W\u00012!!';\u0013\r\u0011iCO\u0001\u0007!J,G-\u001a4\n\t\tE\"1\u0007\u0002\u0004\u001b\u0006\u0004(b\u0001B\u0017uA!!q\u0005B\u001c\u0013\u0011\u0011IDa\r\u0003\rM#(/\u001b8h\u0003\u0019\t\u0007\u000f]3oIRA\u00111\bB \u0005\u0003\u0012\u0019\u0005C\u0004\u0002H%\u0002\r!a\u0013\t\r\u0005m\u0017\u00061\u0001K\u0011\u0019A\u0018\u00061\u0001\u0003FA1\u0011QSAS\u0003\u000b\t\u0001$\u001e9eCR,gi\u001c7m_^,'OR3uG\"\u001cF/\u0019;f))\tYDa\u0013\u0003N\tE#1\u000b\u0005\b\u0003\u000fR\u0003\u0019AA&\u0011\u0019\u0011yE\u000ba\u0001\u0015\u0006Qam\u001c7m_^,'/\u00133\t\r\u0005m'\u00061\u0001K\u0011\u001d\u0011)F\u000ba\u0001\u0003\u000b\tQBZ8mY><XM])vKV,'aB*m_^dunZ\n\u0004W\tm\u0003\u0003BA\u0017\u0005;JAAa\u0018\u00020\t\u0019Aj\\4\u0015\u0011\t\r$q\rB5\u0005W\u00022A!\u001a,\u001b\u0005\u0001\u0001bBA\u0019_\u0001\u0007!1\f\u0005\u0006%>\u0002\r\u0001\u0016\u0005\u0006a>\u0002\rA]\u0001\u000fCB\u0004XM\u001c3Bg2+\u0017\rZ3s))\u0011\tHa\u001e\u0003|\t}$\u0011\u0012\t\u0005\u0003[\u0011\u0019(\u0003\u0003\u0003v\u0005=\"!\u0004'pO\u0006\u0003\b/\u001a8e\u0013:4w\u000eC\u0004\u0003zA\u0002\r!a\u0003\u0002\u000fI,7m\u001c:eg\"1!Q\u0010\u0019A\u0002)\u000b1\u0002\\3bI\u0016\u0014X\t]8dQ\"I!\u0011\u0011\u0019\u0011\u0002\u0003\u0007!1Q\u0001\u0007_JLw-\u001b8\u0011\t\u00055\"QQ\u0005\u0005\u0005\u000f\u000byC\u0001\u0007BaB,g\u000eZ(sS\u001eLg\u000eC\u0005\u0003\fB\u0002\n\u00111\u0001\u0003\u000e\u0006Q\u0012N\u001c;fe\n\u0013xn[3s!J|Go\\2pYZ+'o]5p]B!!q\u0012BK\u001b\t\u0011\tJC\u0002\u0003\u0014R\n1!\u00199j\u0013\u0011\u00119J!%\u0003\u0015\u0005\u0003\u0018NV3sg&|g\u000e")
public class PartitionLockTest
implements Logging {
    private final int numReplicaFetchers;
    private final int numProducers;
    private final int numRecordsPerProducer;
    private final MockTime mockTime = new MockTime();
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final ExecutorService executorService = Executors.newFixedThreadPool(this.numReplicaFetchers() + this.numProducers() + 1);
    private final Semaphore appendSemaphore = new Semaphore(0);
    private final Semaphore shrinkIsrSemaphore = new Semaphore(0);
    private final IndexedSeq<ArrayBlockingQueue<MemoryRecords>> followerQueues;
    private LogManager logManager;
    private Partition partition;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int numReplicaFetchers() {
        return this.numReplicaFetchers;
    }

    public int numProducers() {
        return this.numProducers;
    }

    public int numRecordsPerProducer() {
        return this.numRecordsPerProducer;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public ExecutorService executorService() {
        return this.executorService;
    }

    public Semaphore appendSemaphore() {
        return this.appendSemaphore;
    }

    public Semaphore shrinkIsrSemaphore() {
        return this.shrinkIsrSemaphore;
    }

    public IndexedSeq<ArrayBlockingQueue<MemoryRecords>> followerQueues() {
        return this.followerQueues;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    @Before
    public void setUp() {
        String string;
        LogConfig logConfig = new LogConfig((Map)new Properties(), LogConfig$.MODULE$.$lessinit$greater$default$2());
        int n = 1;
        long l = 0x400000L;
        double d = 0.9;
        int n2 = 0x100000;
        int n3 = 0x2000000;
        double d2 = Double.MAX_VALUE;
        long l2 = 15000L;
        String string2 = string = "MD5";
        string = null;
        String x$9 = string2;
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}))), logConfig, new CleanerConfig(n, l, d, n2, n3, d2, l2, false, x$9), this.mockTime()));
        this.partition_$eq(this.setupPartitionWithMocks(this.logManager(), logConfig));
    }

    @After
    public void tearDown() {
        this.executorService().shutdownNow();
        this.logManager().liveLogDirs().foreach((Function1 & Serializable)x$1 -> {
            PartitionLockTest.$anonfun$tearDown$1(x$1);
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testNoLockContentionWithoutIsrUpdate() {
        this.concurrentProduceFetchWithReadLockOnly();
    }

    @Test
    public void testAppendReplicaFetchWithSchedulerCheckForShrinkIsr() {
        AtomicBoolean active = new AtomicBoolean(true);
        Future<?> future = this.scheduleShrinkIsr(active, 0L);
        this.concurrentProduceFetchWithReadLockOnly();
        active.set(false);
        future.get(15L, TimeUnit.SECONDS);
    }

    @Test
    public void testAppendReplicaFetchWithUpdateIsr() {
        AtomicBoolean active = new AtomicBoolean(true);
        Future<?> future = this.scheduleShrinkIsr(active, 10000L);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PartitionLockTest.$anonfun$testAppendReplicaFetchWithUpdateIsr$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("shrinkIsr not invoked", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(l, l2));
        }
        this.concurrentProduceFetchWithWriteLock();
        active.set(false);
        future.get(15L, TimeUnit.SECONDS);
    }

    @Test
    public void testGetReplicaWithUpdateAssignmentAndIsr() {
        AtomicBoolean active = new AtomicBoolean(true);
        int replicaToCheck = 3;
        java.util.List firstReplicaSet = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{3, 4, 5})))).asJava();
        java.util.List secondReplicaSet = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{1, 2, 3})))).asJava();
        OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
        this.partition().makeLeader(PartitionLockTest.partitionState$1(secondReplicaSet), offsetCheckpoints);
        Assert.assertTrue((String)new StringBuilder(31).append("Expected replica ").append(replicaToCheck).append(" to be defined").toString(), (boolean)this.partition().getReplica(replicaToCheck).isDefined());
        Future<?> future = this.executorService().submit(() -> {
            int i = 0;
            while (active.get()) {
                java.util.List replicas = i % 2 == 0 ? firstReplicaSet : secondReplicaSet;
                this.partition().makeLeader(PartitionLockTest.partitionState$1(replicas), offsetCheckpoints);
                ++i;
                Thread.sleep(1L);
            }
        });
        Deadline deadline = DurationConversions.seconds$((DurationConversions)new package.DurationInt(1)).fromNow();
        while (deadline.hasTimeLeft()) {
            Assert.assertTrue((String)new StringBuilder(31).append("Expected replica ").append(replicaToCheck).append(" to be defined").toString(), (boolean)this.partition().getReplica(replicaToCheck).isDefined());
        }
        active.set(false);
        future.get(5L, TimeUnit.SECONDS);
        Assert.assertTrue((String)new StringBuilder(31).append("Expected replica ").append(replicaToCheck).append(" to be defined").toString(), (boolean)this.partition().getReplica(replicaToCheck).isDefined());
    }

    private void concurrentProduceFetchWithReadLockOnly() {
        scala.collection.immutable.Seq<Future<?>> appendFutures = this.scheduleAppends();
        scala.collection.immutable.Seq<Future<?>> stateUpdateFutures = this.scheduleUpdateFollowers(this.numProducers() * this.numRecordsPerProducer() - 1);
        this.appendSemaphore().release(this.numProducers() * this.numRecordsPerProducer() - 1);
        stateUpdateFutures.foreach((Function1 & Serializable)x$4 -> x$4.get(15L, TimeUnit.SECONDS));
        this.appendSemaphore().release(1);
        this.scheduleUpdateFollowers(1).foreach((Function1 & Serializable)x$5 -> x$5.get(15L, TimeUnit.SECONDS));
        appendFutures.foreach((Function1 & Serializable)x$6 -> x$6.get(15L, TimeUnit.SECONDS));
    }

    private void concurrentProduceFetchWithWriteLock() {
        scala.collection.immutable.Seq<Future<?>> appendFutures = this.scheduleAppends();
        scala.collection.immutable.Seq<Future<?>> stateUpdateFutures = this.scheduleUpdateFollowers(this.numProducers() * this.numRecordsPerProducer());
        Assert.assertFalse((boolean)stateUpdateFutures.exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isDone())));
        this.appendSemaphore().release(this.numProducers() * this.numRecordsPerProducer());
        Assert.assertFalse((boolean)appendFutures.exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.isDone())));
        this.shrinkIsrSemaphore().release();
        stateUpdateFutures.foreach((Function1 & Serializable)x$9 -> x$9.get(15L, TimeUnit.SECONDS));
        appendFutures.foreach((Function1 & Serializable)x$10 -> x$10.get(15L, TimeUnit.SECONDS));
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Seq<Future<?>> scheduleAppends() {
        int n = 0;
        int until$extension_end = this.numProducers();
        Range.Exclusive map_this = new Range.Exclusive(n, until$extension_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        for (Object object : map_this) {
            void map_strictOptimizedMap_$plus$eq_elem;
            Future future;
            Future future2 = future = PartitionLockTest.$anonfun$scheduleAppends$1(this, BoxesRunTime.unboxToInt((Object)object));
            future = null;
            Future future3 = future2;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            future3 = null;
        }
        return (IndexedSeq)map_strictOptimizedMap_b.result();
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Seq<Future<?>> scheduleUpdateFollowers(int numRecords) {
        int n = 1;
        int to$extension_end = this.numReplicaFetchers();
        Range.Inclusive map_this = new Range.Inclusive(n, to$extension_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        for (Object object : map_this) {
            void map_strictOptimizedMap_$plus$eq_elem;
            Future future;
            Future future2 = future = PartitionLockTest.$anonfun$scheduleUpdateFollowers$1(this, numRecords, BoxesRunTime.unboxToInt((Object)object));
            future = null;
            Future future3 = future2;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            future3 = null;
        }
        return (IndexedSeq)map_strictOptimizedMap_b.result();
    }

    private Future<?> scheduleShrinkIsr(AtomicBoolean activeFlag, long mockTimeSleepMs) {
        return this.executorService().submit(() -> {
            while (activeFlag.get()) {
                if (mockTimeSleepMs > 0L) {
                    this.mockTime().sleep(mockTimeSleepMs);
                }
                this.partition().maybeShrinkIsr();
                Thread.sleep(1L);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private Partition setupPartitionWithMocks(LogManager logManager, LogConfig logConfig) {
        Integer n;
        int leaderEpoch = 1;
        int brokerId = 0;
        TopicPartition topicPartition = new TopicPartition("test-topic", 0);
        PartitionStateStore stateStore = (PartitionStateStore)Mockito.mock(PartitionStateStore.class);
        DelayedOperations delayedOperations = (DelayedOperations)Mockito.mock(DelayedOperations.class);
        MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
        logManager.startup();
        Partition partition = new Partition(this, topicPartition, brokerId, stateStore, delayedOperations, metadataCache, logManager){
            private final /* synthetic */ PartitionLockTest $outer;

            public void shrinkIsr(Set<Object> newIsr) {
                this.$outer.shrinkIsrSemaphore().acquire();
                try {
                    super.shrinkIsr(newIsr);
                }
                finally {
                    this.$outer.shrinkIsrSemaphore().release();
                }
            }

            public Log createLog(boolean isNew, boolean isFutureReplica, OffsetCheckpoints offsetCheckpoints) {
                Log log = super.createLog(isNew, isFutureReplica, offsetCheckpoints);
                return new SlowLog(this.$outer, log, this.$outer.mockTime(), this.$outer.appendSemaphore());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(topicPartition$1, Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), brokerId$1, (Time)$outer.mockTime(), stateStore$1, delayedOperations$1, metadataCache$1, logManager$1);
            }
        };
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        Mockito.when((Object)stateStore.fetchTopicConfig()).thenReturn((Object)this.createLogProperties((scala.collection.immutable.Map<String, String>)Map.EmptyMap$.MODULE$));
        Mockito.when((Object)offsetCheckpoints.fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)topicPartition))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)stateStore.shrinkIsr(ArgumentMatchers.anyInt(), (LeaderAndIsr)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)2));
        Mockito.when((Object)stateStore.expandIsr(ArgumentMatchers.anyInt(), (LeaderAndIsr)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)2));
        partition.createLogIfNotExists(false, false, offsetCheckpoints);
        int controllerEpoch = 0;
        int n2 = 0;
        int to$extension_end = this.numReplicaFetchers();
        Range.Inclusive map_this = new Range.Inclusive(n2, to$extension_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator map_strictOptimizedMap_it = map_this.iterator();
        while (map_strictOptimizedMap_it.hasNext()) {
            void map_strictOptimizedMap_$plus$eq_elem;
            Integer n3;
            Integer n4;
            int $anonfun$setupPartitionWithMocks$1_i = BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it.next());
            Integer n5 = n4 = Integer.valueOf(brokerId + $anonfun$setupPartitionWithMocks$1_i);
            n4 = null;
            Integer n6 = n3 = n5;
            n3 = null;
            n = n6;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            n = null;
        }
        Object var14_14 = null;
        Object var15_15 = null;
        Object var16_16 = null;
        n = null;
        java.util.List replicas = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)((IndexedSeq)map_strictOptimizedMap_b.result()).toList()).asJava();
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)partition.makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(brokerId).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true), offsetCheckpoints));
        return partition;
    }

    /*
     * WARNING - void declaration
     */
    private Properties createLogProperties(scala.collection.immutable.Map<String, String> overrides) {
        void var2_2;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)512);
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), (Object)1000);
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), (Object)999);
        overrides.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Object object = logProps.put(k, v);
            return object;
        });
        return var2_2;
    }

    private void append(Partition partition, int numRecords, scala.collection.immutable.Seq<ArrayBlockingQueue<MemoryRecords>> followerQueues) {
        int n = 0;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, numRecords, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                PartitionLockTest.$anonfun$append$1(partition, followerQueues, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    private void updateFollowerFetchState(Partition partition, int followerId, int numRecords, ArrayBlockingQueue<MemoryRecords> followerQueue) {
        int n = 1;
        Range.Inclusive foreach_this = new Range.Inclusive(n, numRecords, 1);
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                PartitionLockTest.$anonfun$updateFollowerFetchState$1(this, followerQueue, partition, followerId, foreach_i);
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                foreach_i += foreach_this.step();
            }
        }
    }

    public static final /* synthetic */ ArrayBlockingQueue $anonfun$followerQueues$1(int x$1) {
        return new ArrayBlockingQueue(2);
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$testAppendReplicaFetchWithUpdateIsr$1(PartitionLockTest $this) {
        return $this.shrinkIsrSemaphore().hasQueuedThreads();
    }

    public static final /* synthetic */ String $anonfun$testAppendReplicaFetchWithUpdateIsr$2() {
        return "shrinkIsr not invoked";
    }

    private static final LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState$1(java.util.List replicas) {
        return new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(1).setLeader(BoxesRunTime.unboxToInt((Object)((Integer)replicas.get(0)))).setLeaderEpoch(1).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true);
    }

    public static final /* synthetic */ Future $anonfun$scheduleAppends$1(PartitionLockTest $this, int x$11) {
        return $this.executorService().submit(() -> {
            try {
                $this.append($this.partition(), $this.numRecordsPerProducer(), (scala.collection.immutable.Seq<ArrayBlockingQueue<MemoryRecords>>)$this.followerQueues());
                return;
            }
            catch (Throwable e) {
                $this.error((Function0<String>)(Function0 & Serializable)() -> "Exception during append", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                throw e;
            }
        });
    }

    public static final /* synthetic */ Future $anonfun$scheduleUpdateFollowers$1(PartitionLockTest $this, int numRecords$1, int index) {
        return $this.executorService().submit(() -> {
            try {
                $this.updateFollowerFetchState($this.partition(), index, numRecords$1, (ArrayBlockingQueue)$this.followerQueues().apply(index - 1));
                return;
            }
            catch (Throwable e) {
                $this.error((Function0<String>)(Function0 & Serializable)() -> "Exception during updateFollowerFetchState", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                throw e;
            }
        });
    }

    public static final /* synthetic */ Integer $anonfun$setupPartitionWithMocks$1(int brokerId$1, int i) {
        return brokerId$1 + i;
    }

    public static final /* synthetic */ void $anonfun$append$1(Partition partition$1, scala.collection.immutable.Seq followerQueues$1, int x$12) {
        MemoryRecords batch = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1);
        partition$1.appendRecordsToLeader(batch, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0);
        followerQueues$1.foreach((Function1 & Serializable)x$13 -> {
            x$13.put(batch);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$updateFollowerFetchState$1(PartitionLockTest $this, ArrayBlockingQueue followerQueue$1, Partition partition$2, int followerId$1, int i) {
        MemoryRecords batch = (MemoryRecords)followerQueue$1.poll(15L, TimeUnit.SECONDS);
        if (batch == null) {
            throw new RuntimeException(new StringBuilder(33).append("Timed out waiting for next batch ").append(i).toString());
        }
        List batches = AsScalaExtensions.IteratorHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, batch.batches().iterator()).asScala().toList();
        if (batches == null) {
            throw null;
        }
        Assert.assertEquals((long)1L, (long)SeqOps.size$((SeqOps)batches));
        MutableRecordBatch recordBatch = (MutableRecordBatch)batches.head();
        return partition$2.updateFollowerFetchState(followerId$1, new LogOffsetMetadata(recordBatch.lastOffset() + 1L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, $this.mockTime().milliseconds(), partition$2.localLogOrException().logEndOffset());
    }

    /*
     * WARNING - void declaration
     */
    public PartitionLockTest() {
        this.numReplicaFetchers = 2;
        this.numProducers = 3;
        this.numRecordsPerProducer = 5;
        int n = 0;
        int until$extension_end = this.numReplicaFetchers();
        Range.Exclusive map_this = new Range.Exclusive(n, until$extension_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator map_strictOptimizedMap_it = map_this.iterator();
        while (map_strictOptimizedMap_it.hasNext()) {
            void map_strictOptimizedMap_$plus$eq_elem;
            ArrayBlockingQueue arrayBlockingQueue;
            ArrayBlockingQueue arrayBlockingQueue2;
            Integer cfr_ignored_0 = (Integer)map_strictOptimizedMap_it.next();
            ArrayBlockingQueue arrayBlockingQueue3 = arrayBlockingQueue2 = new ArrayBlockingQueue(2);
            arrayBlockingQueue2 = null;
            ArrayBlockingQueue arrayBlockingQueue4 = arrayBlockingQueue = arrayBlockingQueue3;
            arrayBlockingQueue = null;
            ArrayBlockingQueue arrayBlockingQueue5 = arrayBlockingQueue4;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            arrayBlockingQueue5 = null;
        }
        this.followerQueues = (IndexedSeq)map_strictOptimizedMap_b.result();
    }

    public static final /* synthetic */ Future $anonfun$scheduleAppends$1$adapted(PartitionLockTest $this, Object x$11) {
        return PartitionLockTest.$anonfun$scheduleAppends$1($this, BoxesRunTime.unboxToInt((Object)x$11));
    }

    public static final /* synthetic */ Future $anonfun$scheduleUpdateFollowers$1$adapted(PartitionLockTest $this, int numRecords$1, Object index) {
        return PartitionLockTest.$anonfun$scheduleUpdateFollowers$1($this, numRecords$1, BoxesRunTime.unboxToInt((Object)index));
    }

    public static final /* synthetic */ Integer $anonfun$setupPartitionWithMocks$1$adapted(int brokerId$1, Object i) {
        return PartitionLockTest.$anonfun$setupPartitionWithMocks$1(brokerId$1, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ ArrayBlockingQueue $anonfun$followerQueues$1$adapted(Object x$1) {
        return PartitionLockTest.$anonfun$followerQueues$1(BoxesRunTime.unboxToInt((Object)x$1));
    }

    public class SlowLog
    extends Log {
        private final Semaphore appendSemaphore;
        public final /* synthetic */ PartitionLockTest $outer;

        public LogAppendInfo appendAsLeader(MemoryRecords records, int leaderEpoch, AppendOrigin origin, ApiVersion interBrokerProtocolVersion) {
            LogAppendInfo appendInfo = super.appendAsLeader(records, leaderEpoch, origin, interBrokerProtocolVersion);
            this.appendSemaphore.acquire();
            return appendInfo;
        }

        public /* synthetic */ PartitionLockTest kafka$cluster$PartitionLockTest$SlowLog$$$outer() {
            return this.$outer;
        }

        public SlowLog(PartitionLockTest $outer, Log log, MockTime mockTime, Semaphore appendSemaphore) {
            this.appendSemaphore = appendSemaphore;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(log.dir(), log.config(), log.logStartOffset(), log.recoveryPoint(), (Scheduler)mockTime.scheduler(), new BrokerTopicStats(), log.time(), log.maxProducerIdExpirationMs(), log.producerIdExpirationCheckIntervalMs(), log.topicPartition(), log.producerStateManager(), new LogDirFailureChannel(1));
        }
    }
}

