/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableOnceOps;
import scala.collection.MapFactory;
import scala.collection.Set;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005Y3A\u0001D\u0007\u0001)!)1\u0004\u0001C\u00019!9q\u0004\u0001b\u0001\n\u0003\u0001\u0003B\u0002\u0013\u0001A\u0003%\u0011\u0005C\u0004&\u0001\t\u0007I\u0011\u0001\u0014\t\r)\u0002\u0001\u0015!\u0003(\u0011\u001dY\u0003A1A\u0005\u00021Baa\u0011\u0001!\u0002\u0013i\u0003\"\u0002#\u0001\t\u0003)\u0005\"\u0002)\u0001\t\u0003)\u0005\"\u0002*\u0001\t\u0003)\u0005\"\u0002+\u0001\t\u0003)%A\u0005+sC:\u001c\u0018m\u0019;j_:dun\u001a+fgRT!AD\b\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003!E\t1bY8pe\u0012Lg.\u0019;pe*\t!#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001)\u0002C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u001b\u0005i\u0001O]8ek\u000e,'/\u00129pG\",\u0012!\t\t\u0003-\tJ!aI\f\u0003\u000bMCwN\u001d;\u0002\u001dA\u0014x\u000eZ;dKJ,\u0005o\\2iA\u0005!BO]1og\u0006\u001cG/[8o)&lWm\\;u\u001bN,\u0012a\n\t\u0003-!J!!K\f\u0003\u0007%sG/A\u000bue\u0006t7/Y2uS>tG+[7f_V$Xj\u001d\u0011\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N,\u0012!\f\t\u0004]UBdBA\u00184!\t\u0001t#D\u00012\u0015\t\u00114#\u0001\u0004=e>|GOP\u0005\u0003i]\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001c8\u0005\r\u0019V\r\u001e\u0006\u0003i]\u0001\"!O!\u000e\u0003iR!a\u000f\u001f\u0002\r\r|W.\\8o\u0015\t\u0011RH\u0003\u0002?\u007f\u00051\u0011\r]1dQ\u0016T\u0011\u0001Q\u0001\u0004_J<\u0017B\u0001\";\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f\u0001\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002GMDw.\u001e7e)\"\u0014xn^#yG\u0016\u0004H/[8o/JLG/Z%om\u0006d\u0017\u000e\u001a+y]R\ta\t\u0005\u0002\u0017\u000f&\u0011\u0001j\u0006\u0002\u0005+:LG\u000f\u000b\u0002\t\u0015B\u00111JT\u0007\u0002\u0019*\u0011QjP\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u001f2\u0013A\u0001V3ti\u000692\u000f[8vY\u0012\u0014V-\u00193Xe&$X-T3tg\u0006<Wm\u001d\u0015\u0003\u0013)\u000ba\u0004^3tiR\u0013\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1QCJ\u001c\u0018N\\4)\u0005)Q\u0015a\n;fgR$&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b)>l'm\u001d;p]\u0016\u0004\u0016M]:j]\u001eD#a\u0003&")
public class TransactionLogTest {
    private final short producerEpoch;
    private final int transactionTimeoutMs;
    private final scala.collection.immutable.Set<TopicPartition> topicPartitions;

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public int transactionTimeoutMs() {
        return this.transactionTimeoutMs;
    }

    public scala.collection.immutable.Set<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    @Test
    public void shouldThrowExceptionWriteInvalidTxn() {
        String transactionalId = "transactionalId";
        long producerId = 23423L;
        TransactionMetadata txnMetadata = TransactionMetadata$.MODULE$.apply(transactionalId, producerId, this.producerEpoch(), this.transactionTimeoutMs(), 0L);
        txnMetadata.addPartitions(this.topicPartitions());
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> TransactionLog$.MODULE$.valueToBytes(txnMetadata.prepareNoTransit()), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("TransactionLogTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldReadWriteMessages() {
        IntRef intRef;
        MemoryRecords memoryRecords;
        void withRecords_records;
        void withRecords_compressionType;
        MemoryRecords memoryRecords2;
        void apply_elems;
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_y6;
        void apply_elems2;
        void $minus$greater$extension_y7;
        Long l;
        void $minus$greater$extension_y8;
        Long l2;
        void $minus$greater$extension_y9;
        Long l3;
        void $minus$greater$extension_y10;
        Long l4;
        void $minus$greater$extension_y11;
        Long l5;
        void $minus$greater$extension_y12;
        Long l6;
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[6];
        Long l7 = l6 = Long.valueOf(0L);
        l6 = null;
        Long l8 = l7;
        String $minus$greater$extension_$this = "zero";
        Object var6_3 = null;
        l8 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y12);
        Long l9 = l5 = Long.valueOf(1L);
        l5 = null;
        Long l10 = l9;
        String $minus$greater$extension_$this2 = "one";
        Object var8_6 = null;
        l10 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y11);
        Long l11 = l4 = Long.valueOf(2L);
        l4 = null;
        Long l12 = l11;
        String $minus$greater$extension_$this3 = "two";
        Object var10_9 = null;
        l12 = null;
        objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y10);
        Long l13 = l3 = Long.valueOf(3L);
        l3 = null;
        Long l14 = l13;
        String $minus$greater$extension_$this4 = "three";
        Object var12_12 = null;
        l14 = null;
        objectArray[3] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y9);
        Long l15 = l2 = Long.valueOf(4L);
        l2 = null;
        Long l16 = l15;
        String $minus$greater$extension_$this5 = "four";
        Object var14_15 = null;
        l16 = null;
        objectArray[4] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y8);
        Long l17 = l = Long.valueOf(5L);
        l = null;
        Long l18 = l17;
        String $minus$greater$extension_$this6 = "five";
        Object var16_18 = null;
        l18 = null;
        objectArray[5] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y7);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        Map pidMappings = (Map)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems2);
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[6];
        Empty$ empty$ = Empty$.MODULE$;
        Long $minus$greater$extension_$this7 = 0L;
        Object var18_22 = null;
        empty$ = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y6);
        Ongoing$ ongoing$ = Ongoing$.MODULE$;
        Long $minus$greater$extension_$this8 = 1L;
        Object var20_24 = null;
        ongoing$ = null;
        objectArray2[1] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)$minus$greater$extension_y5);
        PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
        Long $minus$greater$extension_$this9 = 2L;
        Object var22_26 = null;
        prepareCommit$ = null;
        objectArray2[2] = new Tuple2((Object)$minus$greater$extension_$this9, (Object)$minus$greater$extension_y4);
        CompleteCommit$ completeCommit$ = CompleteCommit$.MODULE$;
        Long $minus$greater$extension_$this10 = 3L;
        Object var24_28 = null;
        completeCommit$ = null;
        objectArray2[3] = new Tuple2((Object)$minus$greater$extension_$this10, (Object)$minus$greater$extension_y3);
        PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
        Long $minus$greater$extension_$this11 = 4L;
        Object var26_30 = null;
        prepareAbort$ = null;
        objectArray2[4] = new Tuple2((Object)$minus$greater$extension_$this11, (Object)$minus$greater$extension_y2);
        CompleteAbort$ completeAbort$ = CompleteAbort$.MODULE$;
        Long $minus$greater$extension_$this12 = 5L;
        Object var28_32 = null;
        completeAbort$ = null;
        objectArray2[5] = new Tuple2((Object)$minus$greater$extension_$this12, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Map transactionStates = (Map)MapFactory.apply$((MapFactory)map$2, (Seq)apply_elems);
        Seq txnRecords = ((IterableOnceOps)pidMappings.map((Function1 & Serializable)x0$1 -> {
            TransactionMetadata txnMetadata;
            String transactionalId;
            if (x0$1 != null) {
                long producerId;
                transactionalId = (String)x0$1._1();
                txnMetadata = TransactionMetadata$.MODULE$.apply(transactionalId, producerId = x0$1._2$mcJ$sp(), this.producerEpoch(), this.transactionTimeoutMs(), (TransactionState)transactionStates.apply((Object)producerId), 0L);
                if (!txnMetadata.state().equals(Empty$.MODULE$)) {
                    txnMetadata.addPartitions(this.topicPartitions());
                }
            } else {
                throw new MatchError(null);
            }
            byte[] keyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
            byte[] valueBytes = TransactionLog$.MODULE$.valueToBytes(txnMetadata.prepareNoTransit());
            SimpleRecord simpleRecord = new SimpleRecord(keyBytes, valueBytes);
            return simpleRecord;
        })).toSeq();
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])txnRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType compressionType = CompressionType.NONE;
        long withRecords_initialOffset = 0L;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        MemoryRecords memoryRecords3 = memoryRecords2 = MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        Object var45_39 = null;
        memoryRecords2 = null;
        MemoryRecords memoryRecords4 = memoryRecords = memoryRecords3;
        compressionType = null;
        simpleRecordArray = null;
        memoryRecords = null;
        MemoryRecords records = memoryRecords4;
        int create_e = 0;
        IntRef intRef2 = intRef = new IntRef(create_e);
        intRef = null;
        IntRef count = intRef2;
        AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.lang.Iterable)records.records()).asScala().foreach((Function1 & Serializable)record -> {
            TransactionLogTest.$anonfun$shouldReadWriteMessages$2(this, pidMappings, transactionStates, count, record);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)pidMappings.size(), (long)count.elem);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTransactionMetadataParsing() {
        void var11_11;
        void var10_10;
        void apply_elems;
        String transactionalId = "id";
        long producerId = 1334L;
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        TransactionMetadata txnMetadata = TransactionMetadata$.MODULE$.apply(transactionalId, producerId, this.producerEpoch(), this.transactionTimeoutMs(), (TransactionState)Ongoing$.MODULE$, 0L);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        txnMetadata.addPartitions((Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems));
        byte[] keyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
        byte[] valueBytes = TransactionLog$.MODULE$.valueToBytes(txnMetadata.prepareNoTransit());
        Record transactionMetadataRecord = (Record)AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.lang.Iterable)TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord(keyBytes, valueBytes)}))), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1).records()).asScala().head();
        Tuple2 tuple2 = TransactionLog$.MODULE$.formatRecordKeyAndValue(transactionMetadataRecord);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option keyStringOpt = (Option)tuple2._1();
        Option valueStringOpt = (Option)tuple2._2();
        Assert.assertEquals((Object)new Some((Object)new StringBuilder(38).append("transaction_metadata::transactionalId=").append(transactionalId).toString()), (Object)var10_10);
        Assert.assertEquals((Object)new Some((Object)new StringBuilder(0).append(new StringBuilder(41).append("producerId:").append(producerId).append(",producerEpoch:").append(this.producerEpoch()).append(",state=Ongoing,").toString()).append(new StringBuilder(52).append("partitions=[").append(topicPartition).append("],txnLastUpdateTimestamp=0,txnTimeoutMs=").append(this.transactionTimeoutMs()).toString()).toString()), (Object)var11_11);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTransactionMetadataTombstoneParsing() {
        void var5_5;
        void var4_4;
        String transactionalId = "id";
        Record transactionMetadataRecord = (Record)AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.lang.Iterable)TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord(TransactionLog$.MODULE$.keyToBytes(transactionalId), null)}))), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1).records()).asScala().head();
        Tuple2 tuple2 = TransactionLog$.MODULE$.formatRecordKeyAndValue(transactionMetadataRecord);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option keyStringOpt = (Option)tuple2._1();
        Option valueStringOpt = (Option)tuple2._2();
        Assert.assertEquals((Object)new Some((Object)new StringBuilder(38).append("transaction_metadata::transactionalId=").append(transactionalId).toString()), (Object)var4_4);
        Assert.assertEquals((Object)new Some((Object)"<DELETE>"), (Object)var5_5);
    }

    public static final /* synthetic */ void $anonfun$shouldReadWriteMessages$2(TransactionLogTest $this, Map pidMappings$1, Map transactionStates$1, IntRef count$1, Record record) {
        String transactionalId = TransactionLog$.MODULE$.readTxnRecordKey(record.key()).transactionalId();
        TransactionMetadata txnMetadata = (TransactionMetadata)TransactionLog$.MODULE$.readTxnRecordValue(transactionalId, record.value()).get();
        Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)pidMappings$1.apply((Object)transactionalId)), (long)txnMetadata.producerId());
        Assert.assertEquals((long)$this.producerEpoch(), (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)$this.transactionTimeoutMs(), (long)txnMetadata.txnTimeoutMs());
        Assert.assertEquals((Object)transactionStates$1.apply((Object)txnMetadata.producerId()), (Object)txnMetadata.state());
        if (txnMetadata.state().equals(Empty$.MODULE$)) {
            if (Predef$.MODULE$.Set() == null) {
                throw null;
            }
            Assert.assertEquals((Object)Set.EmptySet$.MODULE$, (Object)txnMetadata.topicPartitions());
        } else {
            Assert.assertEquals($this.topicPartitions(), (Object)txnMetadata.topicPartitions());
        }
        ++count$1.elem;
    }

    /*
     * WARNING - void declaration
     */
    public TransactionLogTest() {
        void apply_elems;
        this.producerEpoch = 0;
        this.transactionTimeoutMs = 1000;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1), new TopicPartition("topic2", 0), new TopicPartition("topic2", 1), new TopicPartition("topic2", 2)});
        if (set$ == null) {
            throw null;
        }
        this.topicPartitions = (scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems);
    }
}

