/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import scala.;
import scala.$less$colon$less$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.SetOps;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class JmxTool$
implements Logging {
    public static final JmxTool$ MODULE$ = new JmxTool$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public void main(String[] args) {
        scala.collection.immutable.Map numExpectedAttributes;
        ObjectRef objectRef;
        None$ none$;
        OptionParser parser = new OptionParser(false);
        ArgumentAcceptingOptionSpec objectNameOpt = parser.accepts("object-name", "A JMX object name to use as a query. This can contain wild cards, and this option can be given multiple times to specify more than one query. If no objects are specified all objects will be queried.").withRequiredArg().describedAs("name").ofType(String.class);
        ArgumentAcceptingOptionSpec attributesOpt = parser.accepts("attributes", "The whitelist of attributes to query. This is a comma-separated list. If no attributes are specified all objects will be queried.").withRequiredArg().describedAs("name").ofType(String.class);
        ArgumentAcceptingOptionSpec reportingIntervalOpt = parser.accepts("reporting-interval", "Interval in MS with which to poll jmx stats; default value is 2 seconds. Value of -1 equivalent to setting one-time to true").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)2000, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec oneTimeOpt = parser.accepts("one-time", "Flag to indicate run once only.").withRequiredArg().describedAs("one-time").ofType(Boolean.class).defaultsTo((Object)false, (Object[])new Boolean[0]);
        ArgumentAcceptingOptionSpec dateFormatOpt = parser.accepts("date-format", "The date format to use for formatting the time field. See java.text.SimpleDateFormat for options.").withRequiredArg().describedAs("format").ofType(String.class);
        ArgumentAcceptingOptionSpec jmxServiceUrlOpt = parser.accepts("jmx-url", "The url to connect to poll JMX data. See Oracle javadoc for JMXServiceURL for details.").withRequiredArg().describedAs("service-url").ofType(String.class).defaultsTo((Object)"service:jmx:rmi:///jndi/rmi://:9999/jmxrmi", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec reportFormatOpt = parser.accepts("report-format", "output format name: either 'original', 'properties', 'csv', 'tsv' ").withRequiredArg().describedAs("report-format").ofType(String.class).defaultsTo((Object)"original", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec jmxAuthPropOpt = parser.accepts("jmx-auth-prop", "A mechanism to pass property in the form 'username=password' when enabling remote JMX with password authentication.").withRequiredArg().describedAs("jmx-auth-prop").ofType(String.class);
        ArgumentAcceptingOptionSpec jmxSslEnableOpt = parser.accepts("jmx-ssl-enable", "Flag to enable remote JMX with SSL.").withRequiredArg().describedAs("ssl-enable").ofType(Boolean.class).defaultsTo((Object)false, (Object[])new Boolean[0]);
        OptionSpecBuilder waitOpt = parser.accepts("wait", "Wait for requested JMX objects to become available before starting output. Only supported when the list of objects is non-empty and contains no object name patterns.");
        OptionSpecBuilder helpOpt = parser.accepts("help", "Print usage information.");
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "Dump JMX values to standard output.");
        }
        OptionSet options = parser.parse(args);
        if (options.has((OptionSpec)helpOpt)) {
            parser.printHelpOn((OutputStream)System.out);
            throw Exit$.MODULE$.exit(0, Exit$.MODULE$.exit$default$2());
        }
        JMXServiceURL url = new JMXServiceURL((String)options.valueOf((OptionSpec)jmxServiceUrlOpt));
        int interval = (Integer)options.valueOf((OptionSpec)reportingIntervalOpt);
        boolean oneTime = interval < 0 || options.has((OptionSpec)oneTimeOpt);
        boolean attributesWhitelistExists = options.has((OptionSpec)attributesOpt);
        if (attributesWhitelistExists) {
            Object object;
            String[] stringArray;
            String[] stringArray2 = stringArray = ((String)options.valueOf((OptionSpec)attributesOpt)).split(",");
            stringArray = null;
            String[] filterNot$extension_$this = stringArray2;
            ClassTag filterNot$extension_filter$extension_make_evidence$1 = ClassTag$.MODULE$.apply(filterNot$extension_$this.getClass().getComponentType());
            Class clazz = filterNot$extension_filter$extension_make_evidence$1.runtimeClass();
            Class<Byte> clazz2 = Byte.TYPE;
            if (!(clazz2 != null ? !clazz2.equals(clazz) : clazz != null)) {
                object = new ArrayBuilder.ofByte();
            } else {
                Class<Short> clazz3 = Short.TYPE;
                if (!(clazz3 != null ? !clazz3.equals(clazz) : clazz != null)) {
                    object = new ArrayBuilder.ofShort();
                } else {
                    Class<Character> clazz4 = Character.TYPE;
                    if (!(clazz4 != null ? !clazz4.equals(clazz) : clazz != null)) {
                        object = new ArrayBuilder.ofChar();
                    } else {
                        Class<Integer> clazz5 = Integer.TYPE;
                        if (!(clazz5 != null ? !clazz5.equals(clazz) : clazz != null)) {
                            object = new ArrayBuilder.ofInt();
                        } else {
                            Class<Long> clazz6 = Long.TYPE;
                            if (!(clazz6 != null ? !clazz6.equals(clazz) : clazz != null)) {
                                object = new ArrayBuilder.ofLong();
                            } else {
                                Class<Float> clazz7 = Float.TYPE;
                                if (!(clazz7 != null ? !clazz7.equals(clazz) : clazz != null)) {
                                    object = new ArrayBuilder.ofFloat();
                                } else {
                                    Class<Double> clazz8 = Double.TYPE;
                                    if (!(clazz8 != null ? !clazz8.equals(clazz) : clazz != null)) {
                                        object = new ArrayBuilder.ofDouble();
                                    } else {
                                        Class<Boolean> clazz9 = Boolean.TYPE;
                                        if (!(clazz9 != null ? !clazz9.equals(clazz) : clazz != null)) {
                                            object = new ArrayBuilder.ofBoolean();
                                        } else {
                                            Class<Void> clazz10 = Void.TYPE;
                                            object = !(clazz10 != null ? !clazz10.equals(clazz) : clazz != null) ? new ArrayBuilder.ofUnit() : new ArrayBuilder.ofRef(filterNot$extension_filter$extension_make_evidence$1);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            ArrayBuilder.ofByte ofByte2 = object;
            Object var63_21 = null;
            object = null;
            clazz = null;
            ArrayBuilder.ofByte filterNot$extension_filter$extension_res = ofByte2;
            for (int filterNot$extension_filter$extension_i = 0; filterNot$extension_filter$extension_i < filterNot$extension_$this.length; ++filterNot$extension_filter$extension_i) {
                String filterNot$extension_filter$extension_x = filterNot$extension_$this[filterNot$extension_filter$extension_i];
                if (!(!filterNot$extension_filter$extension_x.equals(""))) continue;
                filterNot$extension_filter$extension_res.addOne((Object)filterNot$extension_filter$extension_x);
            }
            Object var59_20 = null;
            Object var60_24 = null;
            Object var62_26 = null;
            Some some = new Some(filterNot$extension_filter$extension_res.result());
            none$ = some;
        } else {
            none$ = None$.MODULE$;
        }
        None$ attributesWhitelist = none$;
        None$ dateFormat = options.has((OptionSpec)dateFormatOpt) ? new Some((Object)new SimpleDateFormat((String)options.valueOf((OptionSpec)dateFormatOpt))) : None$.MODULE$;
        boolean wait = options.has((OptionSpec)waitOpt);
        String reportFormat = this.parseFormat(((String)options.valueOf((OptionSpec)reportFormatOpt)).toLowerCase());
        boolean reportFormatOriginal = reportFormat.equals("original");
        boolean enablePasswordAuth = options.has((OptionSpec)jmxAuthPropOpt);
        boolean enableSsl = options.has((OptionSpec)jmxSslEnableOpt);
        ObjectRef objectRef2 = objectRef = new ObjectRef(null);
        objectRef = null;
        ObjectRef mbsc = objectRef2;
        boolean connected = false;
        int connectTimeoutMs = 10000;
        long connectTestStarted = System.currentTimeMillis();
        do {
            try {
                System.err.println(new StringBuilder(31).append("Trying to connect to JMX url: ").append(url).append(".").toString());
                HashMap<String, Object> env = new HashMap<String, Object>();
                if (enableSsl) {
                    SslRMIClientSocketFactory csf = new SslRMIClientSocketFactory();
                    env.put("com.sun.jndi.rmi.factory.socket", csf);
                }
                if (enablePasswordAuth) {
                    String[] credentials = ((String)options.valueOf((OptionSpec)jmxAuthPropOpt)).split("=", 2);
                    env.put("jmx.remote.credentials", credentials);
                }
                JMXConnector jmxc = JMXConnectorFactory.connect(url, env);
                mbsc.elem = jmxc.getMBeanServerConnection();
                connected = true;
            }
            catch (Exception e) {
                System.err.println(new StringBuilder(43).append("Could not connect to JMX url: ").append(url).append(". Exception ").append(e.getMessage()).append(".").toString());
                e.printStackTrace();
                Thread.sleep(100L);
            }
        } while (System.currentTimeMillis() - connectTestStarted < (long)connectTimeoutMs && !connected);
        if (!connected) {
            System.err.println(new StringBuilder(40).append("Could not connect to JMX url ").append(url).append(" after ").append(connectTimeoutMs).append(" ms.").toString());
            System.err.println("Exiting.");
            throw scala.sys.package$.MODULE$.exit(1);
        }
        Iterable queries = options.has((OptionSpec)objectNameOpt) ? (Iterable)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)options.valuesOf((OptionSpec)objectNameOpt)).asScala().map((Function1 & Serializable)x$2 -> new ObjectName((String)x$2)) : (Iterable)IterableFactory.apply$((IterableFactory)List$.MODULE$, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null}));
        boolean hasPatternQueries = ((IterableOnceOps)queries.filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JmxTool$.$anonfun$main$3(x$1)))).exists((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)name.isPattern()));
        Iterable iterable = null;
        int waitTimeoutMs = 10000;
        if (!hasPatternQueries) {
            boolean bl;
            long start = System.currentTimeMillis();
            do {
                Set set;
                if ((Iterable)iterable != null) {
                    System.err.println("Could not find all object names, retrying");
                    Thread.sleep(100L);
                }
                iterable = (Iterable)queries.flatMap((Function1 & Serializable)name -> AsScalaExtensions.SetHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, ((MBeanServerConnection)mbsc$1.elem).queryNames((ObjectName)name, null)).asScala());
                if (!wait || System.currentTimeMillis() - start >= (long)waitTimeoutMs) break;
                Set set2 = queries.toSet();
                Set set3 = set = (Set)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)iterable)).toSet().flatten((Function1)$less$colon$less$.MODULE$.refl());
                set = null;
                Set set4 = set3;
                bl = !(set2 != null ? !set2.equals(set4) : set4 != null);
                set4 = null;
            } while (!bl);
        }
        if (wait) {
            Set set;
            Set set5 = queries.toSet();
            Set set6 = set = (Set)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)iterable)).toSet().flatten((Function1)$less$colon$less$.MODULE$.refl());
            set = null;
            Set set7 = set6;
            boolean bl = !(set5 != null ? !set5.equals(set7) : set7 != null);
            set7 = null;
            if (!bl) {
                void mkString_sep;
                String string;
                void $minus_elem;
                Set set8;
                Set set9 = queries.toSet();
                Set set10 = set8 = (Set)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)iterable)).toSet().flatten((Function1)$less$colon$less$.MODULE$.refl());
                set8 = null;
                Set set11 = set10;
                if (set9 == null) {
                    throw null;
                }
                SetOps setOps = set9.excl((Object)$minus_elem);
                set11 = null;
                String string2 = ", ";
                if (setOps == null) {
                    throw null;
                }
                SetOps mkString_this = setOps;
                String string3 = string = mkString_this.mkString("", (String)mkString_sep, "");
                Object var51_56 = null;
                string2 = null;
                string = null;
                String missing = string3;
                System.err.println(new StringBuilder(61).append("Could not find all requested object names after ").append(waitTimeoutMs).append(" ms. Missing ").append(missing).toString());
                System.err.println("Exiting.");
                throw scala.sys.package$.MODULE$.exit(1);
            }
        }
        scala.collection.immutable.Map map = !attributesWhitelistExists ? ((IterableOnceOps)((Iterable)iterable).map((Function1 & Serializable)name -> {
            Object var4_5;
            MBeanInfo mbean = ((MBeanServerConnection)mbsc$1.elem).getMBeanInfo((ObjectName)name);
            MBeanServerConnection mBeanServerConnection = (MBeanServerConnection)mbsc$1.elem;
            MBeanAttributeInfo[] map$extension_$this = mbean.getAttributes();
            int n = map$extension_$this.length;
            String[] map$extension_ys = new String[n];
            if (n > 0) {
                for (int map$extension_i = 0; map$extension_i < n; ++map$extension_i) {
                    String array_update_value;
                    String string;
                    String string2 = string = map$extension_$this[map$extension_i].getName();
                    string = null;
                    map$extension_ys[map$extension_i] = array_update_value = string2;
                    Object var8_8 = null;
                }
            }
            void v2 = var4_5;
            Object var3_3 = null;
            var4_5 = null;
            return new Tuple2(name, (Object)mBeanServerConnection.getAttributes((ObjectName)name, (String[])v2).size());
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()) : (numExpectedAttributes = !hasPatternQueries ? (scala.collection.immutable.Map)((IterableOnceOps)((Iterable)iterable).map(arg_0 -> JmxTool$.$anonfun$main$8(mbsc, (Option)attributesWhitelist, arg_0))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)JmxTool$.$anonfun$main$11(x$5))) : ((IterableOnceOps)queries.map(arg_0 -> JmxTool$.$anonfun$main$12((Option)attributesWhitelist, arg_0))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        if (numExpectedAttributes.isEmpty()) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, new StringBuilder(47).append("No matched attributes for the queried objects ").append(queries).append(".").toString());
        }
        List keys = (List)new .colon.colon((Object)"time", (List)Nil$.MODULE$).concat((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.sorted$extension((Object)((Object[])this.queryAttributes((MBeanServerConnection)mbsc.elem, (Iterable<ObjectName>)iterable, (Option<String[]>)attributesWhitelist).keys().toArray(ClassTag$.MODULE$.apply(String.class))), (Ordering)Ordering.String$.MODULE$)));
        if (reportFormatOriginal) {
            if (keys == null) {
                throw null;
            }
            if (SeqOps.size$((SeqOps)keys) == BoxesRunTime.unboxToInt((Object)numExpectedAttributes.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1) {
                Nil$ nil$;
                if (keys == Nil$.MODULE$) {
                    nil$ = Nil$.MODULE$;
                } else {
                    .colon.colon map_h;
                    .colon.colon map_t = map_h = new .colon.colon((Object)JmxTool$.$anonfun$main$13((String)keys.head()), (List)Nil$.MODULE$);
                    for (List map_rest = (List)keys.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                        .colon.colon map_nx = new .colon.colon((Object)JmxTool$.$anonfun$main$13((String)map_rest.head()), (List)Nil$.MODULE$);
                        map_t.next_$eq((List)map_nx);
                        map_t = map_nx;
                    }
                    Statics.releaseFence();
                    nil$ = map_h;
                }
                Nil$ nil$2 = nil$;
                Object var66_62 = null;
                Object var67_63 = null;
                Object var68_64 = null;
                Object var69_65 = null;
                nil$ = null;
                String mkString_sep = ",";
                Object var54_66 = null;
                Predef$.MODULE$.println((Object)nil$2.mkString("", mkString_sep, ""));
            }
        }
        boolean keepGoing = true;
        while (keepGoing) {
            String string;
            long start = System.currentTimeMillis();
            Map<String, Object> attributes = this.queryAttributes((MBeanServerConnection)mbsc.elem, (Iterable<ObjectName>)iterable, (Option<String[]>)attributesWhitelist);
            if (dateFormat instanceof Some) {
                string = ((SimpleDateFormat)((Some)dateFormat).value()).format(new Date());
            } else if (None$.MODULE$.equals(dateFormat)) {
                string = ((Object)System.currentTimeMillis()).toString();
            } else {
                throw new MatchError((Object)dateFormat);
            }
            attributes.update((Object)"time", (Object)string);
            if (attributes.keySet().size() == BoxesRunTime.unboxToInt((Object)numExpectedAttributes.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1) {
                if (reportFormatOriginal) {
                    Nil$ nil$;
                    if (keys == null) {
                        throw null;
                    }
                    if (keys == Nil$.MODULE$) {
                        nil$ = Nil$.MODULE$;
                    } else {
                        .colon.colon map_h;
                        String string4 = (String)keys.head();
                        .colon.colon map_t = map_h = new .colon.colon(attributes.apply((Object)string4), (List)Nil$.MODULE$);
                        for (List map_rest = (List)keys.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                            string4 = (String)map_rest.head();
                            .colon.colon map_nx = new .colon.colon(attributes.apply((Object)string4), (List)Nil$.MODULE$);
                            map_t.next_$eq((List)map_nx);
                            map_t = map_nx;
                        }
                        Statics.releaseFence();
                        nil$ = map_h;
                    }
                    Nil$ nil$3 = nil$;
                    Object var71_75 = null;
                    Object var72_76 = null;
                    Object var73_77 = null;
                    Object var74_78 = null;
                    nil$ = null;
                    String mkString_sep = ",";
                    Object var55_71 = null;
                    Predef$.MODULE$.println((Object)nil$3.mkString("", mkString_sep, ""));
                } else if (reportFormat.equals("properties")) {
                    if (keys == null) {
                        throw null;
                    }
                    List foreach_these = keys;
                    while (!foreach_these.isEmpty()) {
                        String string5 = (String)foreach_these.head();
                        JmxTool$.$anonfun$main$15(attributes, string5);
                        foreach_these = (List)foreach_these.tail();
                    }
                    Object var56_72 = null;
                } else if (reportFormat.equals("csv")) {
                    if (keys == null) {
                        throw null;
                    }
                    List foreach_these = keys;
                    while (!foreach_these.isEmpty()) {
                        String string6 = (String)foreach_these.head();
                        JmxTool$.$anonfun$main$16(attributes, string6);
                        foreach_these = (List)foreach_these.tail();
                    }
                    Object var57_73 = null;
                } else {
                    if (keys == null) {
                        throw null;
                    }
                    List foreach_these = keys;
                    while (!foreach_these.isEmpty()) {
                        String string7 = (String)foreach_these.head();
                        JmxTool$.$anonfun$main$17(attributes, string7);
                        foreach_these = (List)foreach_these.tail();
                    }
                    Object var58_74 = null;
                }
            }
            if (oneTime) {
                keepGoing = false;
                continue;
            }
            Thread.sleep(package$.MODULE$.max(0L, (long)interval - (System.currentTimeMillis() - start)));
        }
    }

    public Map<String, Object> queryAttributes(MBeanServerConnection mbsc, Iterable<ObjectName> names, Option<String[]> attributesWhitelist) {
        scala.collection.mutable.HashMap attributes = new scala.collection.mutable.HashMap();
        names.foreach((Function1 & Serializable)name -> {
            JmxTool$.$anonfun$queryAttributes$1(mbsc, attributesWhitelist, attributes, name);
            return BoxedUnit.UNIT;
        });
        return attributes;
    }

    public String parseFormat(String reportFormatOpt) {
        String string;
        block9: {
            block6: {
                block8: {
                    block7: {
                        switch (reportFormatOpt == null ? 0 : reportFormatOpt.hashCode()) {
                            case -926053069: {
                                if ("properties".equals(reportFormatOpt)) {
                                    break;
                                }
                                break block6;
                            }
                            case 98822: {
                                if (!"csv".equals(reportFormatOpt)) break block6;
                                break block7;
                            }
                            case 115159: {
                                if (!"tsv".equals(reportFormatOpt)) break block6;
                                break block8;
                            }
                            default: {
                                break block6;
                            }
                        }
                        string = "properties";
                        break block9;
                    }
                    string = "csv";
                    break block9;
                }
                string = "tsv";
                break block9;
            }
            string = "original";
        }
        return string;
    }

    public static final /* synthetic */ boolean $anonfun$main$3(Object x$1) {
        return Objects.isNull(x$1);
    }

    private static final Set namesSet$1(ObjectRef names$1) {
        return (Set)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)((Iterable)names$1.elem))).toSet().flatten((Function1)$less$colon$less$.MODULE$.refl());
    }

    private static final boolean foundAllObjects$1(Iterable queries$1, ObjectRef names$1) {
        Set set;
        Set set2 = queries$1.toSet();
        Set set3 = set = (Set)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)((Iterable)names$1.elem))).toSet().flatten((Function1)$less$colon$less$.MODULE$.refl());
        set = null;
        Set set4 = set3;
        return !(set2 != null ? !set2.equals(set4) : set4 != null);
    }

    public static final /* synthetic */ String $anonfun$main$7(MBeanAttributeInfo x$3) {
        return x$3.getName();
    }

    public static final /* synthetic */ String $anonfun$main$9(MBeanAttributeInfo x$4) {
        return x$4.getName();
    }

    public static final /* synthetic */ Tuple2 $anonfun$main$8(ObjectRef mbsc$1, Option attributesWhitelist$1, ObjectName name) {
        Object var7_6;
        MBeanInfo mbean = ((MBeanServerConnection)mbsc$1.elem).getMBeanInfo(name);
        MBeanServerConnection mBeanServerConnection = (MBeanServerConnection)mbsc$1.elem;
        MBeanAttributeInfo[] map$extension_$this = mbean.getAttributes();
        int n = map$extension_$this.length;
        String[] map$extension_ys = new String[n];
        if (n > 0) {
            for (int map$extension_i = 0; map$extension_i < n; ++map$extension_i) {
                String array_update_value;
                String string;
                String string2 = string = map$extension_$this[map$extension_i].getName();
                string = null;
                map$extension_ys[map$extension_i] = array_update_value = string2;
                Object var11_9 = null;
            }
        }
        void v2 = var7_6;
        Object var6_4 = null;
        var7_6 = null;
        AttributeList attributes = mBeanServerConnection.getAttributes(name, (String[])v2);
        Buffer expectedAttributes = (Buffer)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)attributes).asScala().filter((Function1 & Serializable)attr -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.contains$extension((Object)((Object[])attributesWhitelist$1.get()), (Object)attr.getName())));
        if (expectedAttributes == null) {
            throw null;
        }
        return new Tuple2((Object)name, (Object)expectedAttributes.length());
    }

    public static final /* synthetic */ boolean $anonfun$main$11(Tuple2 x$5) {
        return x$5._2$mcI$sp() > 0;
    }

    public static final /* synthetic */ Tuple2 $anonfun$main$12(Option attributesWhitelist$1, ObjectName x$6) {
        return new Tuple2((Object)x$6, (Object)((String[])attributesWhitelist$1.get()).length);
    }

    public static final /* synthetic */ String $anonfun$main$13(String x$7) {
        return new StringBuilder(2).append("\"").append(x$7).append("\"").toString();
    }

    public static final /* synthetic */ Object $anonfun$main$14(Map attributes$1, String x$8) {
        return attributes$1.apply((Object)x$8);
    }

    public static final /* synthetic */ void $anonfun$main$15(Map attributes$1, String k) {
        String println_x = new StringBuilder(1).append(k).append("=").append(attributes$1.apply((Object)k)).toString();
        Console$.MODULE$.println((Object)println_x);
    }

    public static final /* synthetic */ void $anonfun$main$16(Map attributes$1, String k) {
        String println_x = new StringBuilder(3).append(k).append(",\"").append(attributes$1.apply((Object)k)).append("\"").toString();
        Console$.MODULE$.println((Object)println_x);
    }

    public static final /* synthetic */ void $anonfun$main$17(Map attributes$1, String k) {
        String println_x = new StringBuilder(1).append(k).append("\t").append(attributes$1.apply((Object)k)).toString();
        Console$.MODULE$.println((Object)println_x);
    }

    public static final /* synthetic */ String $anonfun$queryAttributes$2(MBeanAttributeInfo x$9) {
        return x$9.getName();
    }

    public static final /* synthetic */ void $anonfun$queryAttributes$3(Option attributesWhitelist$2, scala.collection.mutable.HashMap attributes$2, ObjectName name$1, Object attrObj) {
        Attribute attr = (Attribute)attrObj;
        if (attributesWhitelist$2 instanceof Some) {
            String[] allowedAttributes = (String[])((Some)attributesWhitelist$2).value();
            if (ArrayOps$.MODULE$.contains$extension((Object)allowedAttributes, (Object)attr.getName())) {
                attributes$2.update((Object)new StringBuilder(1).append(name$1.toString()).append(":").append(attr.getName()).toString(), attr.getValue());
                return;
            }
        } else {
            if (None$.MODULE$.equals(attributesWhitelist$2)) {
                attributes$2.update((Object)new StringBuilder(1).append(name$1.toString()).append(":").append(attr.getName()).toString(), attr.getValue());
                return;
            }
            throw new MatchError((Object)attributesWhitelist$2);
        }
    }

    public static final /* synthetic */ void $anonfun$queryAttributes$1(MBeanServerConnection mbsc$2, Option attributesWhitelist$2, scala.collection.mutable.HashMap attributes$2, ObjectName name) {
        Object var6_7;
        MBeanInfo mbean = mbsc$2.getMBeanInfo(name);
        MBeanAttributeInfo[] map$extension_$this = mbean.getAttributes();
        int n = map$extension_$this.length;
        String[] map$extension_ys = new String[n];
        if (n > 0) {
            for (int map$extension_i = 0; map$extension_i < n; ++map$extension_i) {
                String array_update_value;
                String string;
                String string2 = string = map$extension_$this[map$extension_i].getName();
                string = null;
                map$extension_ys[map$extension_i] = array_update_value = string2;
                Object var10_10 = null;
            }
        }
        void v1 = var6_7;
        Object var5_5 = null;
        var6_7 = null;
        AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)mbsc$2.getAttributes(name, (String[])v1)).asScala().foreach((Function1 & Serializable)attrObj -> {
            JmxTool$.$anonfun$queryAttributes$3(attributesWhitelist$2, attributes$2, name, attrObj);
            return BoxedUnit.UNIT;
        });
    }

    private JmxTool$() {
    }

    public static final /* synthetic */ Object $anonfun$main$1$adapted(String x$1) {
        return BoxesRunTime.boxToBoolean((boolean)x$1.equals(""));
    }

    public static final /* synthetic */ Object $anonfun$main$15$adapted(Map attributes$1, String k) {
        JmxTool$.$anonfun$main$15(attributes$1, k);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$main$16$adapted(Map attributes$1, String k) {
        JmxTool$.$anonfun$main$16(attributes$1, k);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$main$17$adapted(Map attributes$1, String k) {
        JmxTool$.$anonfun$main$17(attributes$1, k);
        return BoxedUnit.UNIT;
    }
}

