/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.api.LeaderAndIsr;
import kafka.controller.ControllerContext;
import kafka.controller.ElectionResult;
import kafka.controller.PartitionLeaderElectionAlgorithms$;
import org.apache.kafka.common.TopicPartition;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableFactory;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

public final class Election$ {
    public static final Election$ MODULE$ = new Election$();

    private ElectionResult leaderForOffline(TopicPartition partition, Option<LeaderAndIsr> leaderAndIsrOpt, boolean uncleanLeaderElectionEnabled, ControllerContext controllerContext) {
        ElectionResult electionResult;
        Seq<Object> assignment = controllerContext.partitionReplicaAssignment(partition);
        Seq liveReplicas = (Seq)assignment.filter((Function1)(JFunction1.mcZI.sp & Serializable)replica -> controllerContext.isReplicaOnline(replica, partition, controllerContext.isReplicaOnline$default$3()));
        if (leaderAndIsrOpt instanceof Some) {
            None$ none$;
            LeaderAndIsr leaderAndIsr = (LeaderAndIsr)((Some)leaderAndIsrOpt).value();
            List<Object> isr = leaderAndIsr.isr();
            Option<Object> leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.offlinePartitionLeaderElection(assignment, (Seq<Object>)isr, (Set<Object>)liveReplicas.toSet(), uncleanLeaderElectionEnabled, controllerContext);
            if (leaderOpt == null) {
                throw null;
            }
            if (leaderOpt.isEmpty()) {
                none$ = None$.MODULE$;
            } else {
                Object object = leaderOpt.get();
                none$ = new Some((Object)Election$.$anonfun$leaderForOffline$2(isr, controllerContext, partition, leaderAndIsr, BoxesRunTime.unboxToInt((Object)object)));
            }
            None$ none$2 = none$;
            none$ = null;
            None$ newLeaderAndIsrOpt = none$2;
            electionResult = new ElectionResult(partition, (Option<LeaderAndIsr>)newLeaderAndIsrOpt, (Seq<Object>)liveReplicas);
        } else if (None$.MODULE$.equals(leaderAndIsrOpt)) {
            electionResult = new ElectionResult(partition, (Option<LeaderAndIsr>)None$.MODULE$, (Seq<Object>)liveReplicas);
        } else {
            throw new MatchError(leaderAndIsrOpt);
        }
        return electionResult;
    }

    public Seq<ElectionResult> leaderForOffline(ControllerContext controllerContext, Seq<Tuple3<TopicPartition, Option<LeaderAndIsr>, Object>> partitionsWithUncleanLeaderElectionState) {
        return (Seq)partitionsWithUncleanLeaderElectionState.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition partition = (TopicPartition)x0$1._1();
            Option leaderAndIsrOpt = (Option)x0$1._2();
            boolean uncleanLeaderElectionEnabled = BoxesRunTime.unboxToBoolean((Object)x0$1._3());
            ElectionResult electionResult = MODULE$.leaderForOffline(partition, (Option<LeaderAndIsr>)leaderAndIsrOpt, uncleanLeaderElectionEnabled, controllerContext);
            return electionResult;
        });
    }

    private ElectionResult leaderForReassign(TopicPartition partition, LeaderAndIsr leaderAndIsr, ControllerContext controllerContext) {
        None$ none$;
        Seq<Object> targetReplicas = controllerContext.partitionFullReplicaAssignment(partition).targetReplicas();
        Seq liveReplicas = (Seq)targetReplicas.filter((Function1)(JFunction1.mcZI.sp & Serializable)replica -> controllerContext.isReplicaOnline(replica, partition, controllerContext.isReplicaOnline$default$3()));
        List<Object> isr = leaderAndIsr.isr();
        Option<Object> leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.reassignPartitionLeaderElection(targetReplicas, (Seq<Object>)isr, (Set<Object>)liveReplicas.toSet());
        if (leaderOpt == null) {
            throw null;
        }
        if (leaderOpt.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            int $anonfun$leaderForReassign$2_leader = BoxesRunTime.unboxToInt((Object)leaderOpt.get());
            none$ = new Some((Object)leaderAndIsr.newLeader($anonfun$leaderForReassign$2_leader));
        }
        None$ none$2 = none$;
        none$ = null;
        None$ newLeaderAndIsrOpt = none$2;
        return new ElectionResult(partition, (Option<LeaderAndIsr>)newLeaderAndIsrOpt, targetReplicas);
    }

    public Seq<ElectionResult> leaderForReassign(ControllerContext controllerContext, Seq<Tuple2<TopicPartition, LeaderAndIsr>> leaderAndIsrs) {
        return (Seq)leaderAndIsrs.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition partition = (TopicPartition)x0$1._1();
            LeaderAndIsr leaderAndIsr = (LeaderAndIsr)x0$1._2();
            ElectionResult electionResult = MODULE$.leaderForReassign(partition, leaderAndIsr, controllerContext);
            return electionResult;
        });
    }

    private ElectionResult leaderForPreferredReplica(TopicPartition partition, LeaderAndIsr leaderAndIsr, ControllerContext controllerContext) {
        None$ none$;
        Seq<Object> assignment = controllerContext.partitionReplicaAssignment(partition);
        Seq liveReplicas = (Seq)assignment.filter((Function1)(JFunction1.mcZI.sp & Serializable)replica -> controllerContext.isReplicaOnline(replica, partition, controllerContext.isReplicaOnline$default$3()));
        List<Object> isr = leaderAndIsr.isr();
        Option<Object> leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.preferredReplicaPartitionLeaderElection(assignment, (Seq<Object>)isr, (Set<Object>)liveReplicas.toSet());
        if (leaderOpt == null) {
            throw null;
        }
        if (leaderOpt.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            int $anonfun$leaderForPreferredReplica$2_leader = BoxesRunTime.unboxToInt((Object)leaderOpt.get());
            none$ = new Some((Object)leaderAndIsr.newLeader($anonfun$leaderForPreferredReplica$2_leader));
        }
        None$ none$2 = none$;
        none$ = null;
        None$ newLeaderAndIsrOpt = none$2;
        return new ElectionResult(partition, (Option<LeaderAndIsr>)newLeaderAndIsrOpt, assignment);
    }

    public Seq<ElectionResult> leaderForPreferredReplica(ControllerContext controllerContext, Seq<Tuple2<TopicPartition, LeaderAndIsr>> leaderAndIsrs) {
        return (Seq)leaderAndIsrs.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition partition = (TopicPartition)x0$1._1();
            LeaderAndIsr leaderAndIsr = (LeaderAndIsr)x0$1._2();
            ElectionResult electionResult = MODULE$.leaderForPreferredReplica(partition, leaderAndIsr, controllerContext);
            return electionResult;
        });
    }

    private ElectionResult leaderForControlledShutdown(TopicPartition partition, LeaderAndIsr leaderAndIsr, Set<Object> shuttingDownBrokerIds, ControllerContext controllerContext) {
        None$ none$;
        Nil$ nil$;
        Object var18_15;
        Object var17_14;
        List list;
        Object var26_23;
        Object var25_22;
        Object var24_21;
        Object var23_20;
        Object var22_19;
        Object var21_18;
        Object var20_17;
        Object var19_16;
        Nil$ nil$2;
        Seq<Object> assignment = controllerContext.partitionReplicaAssignment(partition);
        Seq liveOrShuttingDownReplicas = (Seq)assignment.filter((Function1)(JFunction1.mcZI.sp & Serializable)replica -> controllerContext.isReplicaOnline(replica, partition, true));
        List isr = leaderAndIsr.isr();
        Option<Object> leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.controlledShutdownPartitionLeaderElection(assignment, (Seq<Object>)isr, (Set<Object>)liveOrShuttingDownReplicas.toSet(), shuttingDownBrokerIds);
        if (isr == null) {
            throw null;
        }
        boolean filter_filterCommon_isFlipped = false;
        List filter_filterCommon_noneIn$1_l = isr;
        while (true) {
            if (filter_filterCommon_noneIn$1_l.isEmpty()) {
                nil$2 = Nil$.MODULE$;
                break;
            }
            Object filter_filterCommon_noneIn$1_h = filter_filterCommon_noneIn$1_l.head();
            List filter_filterCommon_noneIn$1_t = (List)filter_filterCommon_noneIn$1_l.tail();
            int n = BoxesRunTime.unboxToInt((Object)filter_filterCommon_noneIn$1_h);
            if (Election$.$anonfun$leaderForControlledShutdown$2(shuttingDownBrokerIds, n) != filter_filterCommon_isFlipped) {
                List list2;
                block14: {
                    List filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next;
                    List filter_filterCommon_noneIn$1_allIn$1_remaining = filter_filterCommon_noneIn$1_t;
                    while (true) {
                        if (filter_filterCommon_noneIn$1_allIn$1_remaining.isEmpty()) {
                            list2 = filter_filterCommon_noneIn$1_l;
                            break block14;
                        }
                        Object filter_filterCommon_noneIn$1_allIn$1_x = filter_filterCommon_noneIn$1_allIn$1_remaining.head();
                        n = BoxesRunTime.unboxToInt((Object)filter_filterCommon_noneIn$1_allIn$1_x);
                        if (Election$.$anonfun$leaderForControlledShutdown$2(shuttingDownBrokerIds, n) == filter_filterCommon_isFlipped) break;
                        filter_filterCommon_noneIn$1_allIn$1_remaining = (List)filter_filterCommon_noneIn$1_allIn$1_remaining.tail();
                    }
                    .colon.colon filter_filterCommon_noneIn$1_allIn$1_partialFill$1_newHead = new .colon.colon(filter_filterCommon_noneIn$1_l.head(), (List)Nil$.MODULE$);
                    .colon.colon filter_filterCommon_noneIn$1_allIn$1_partialFill$1_currentLast = filter_filterCommon_noneIn$1_allIn$1_partialFill$1_newHead;
                    for (List filter_filterCommon_noneIn$1_allIn$1_partialFill$1_toProcess = (List)filter_filterCommon_noneIn$1_l.tail(); filter_filterCommon_noneIn$1_allIn$1_partialFill$1_toProcess != filter_filterCommon_noneIn$1_allIn$1_remaining; filter_filterCommon_noneIn$1_allIn$1_partialFill$1_toProcess = (List)filter_filterCommon_noneIn$1_allIn$1_partialFill$1_toProcess.tail()) {
                        .colon.colon filter_filterCommon_noneIn$1_allIn$1_partialFill$1_newElem = new .colon.colon(filter_filterCommon_noneIn$1_allIn$1_partialFill$1_toProcess.head(), (List)Nil$.MODULE$);
                        filter_filterCommon_noneIn$1_allIn$1_partialFill$1_currentLast.next_$eq((List)filter_filterCommon_noneIn$1_allIn$1_partialFill$1_newElem);
                        filter_filterCommon_noneIn$1_allIn$1_partialFill$1_currentLast = filter_filterCommon_noneIn$1_allIn$1_partialFill$1_newElem;
                    }
                    List filter_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy = filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next = (List)filter_filterCommon_noneIn$1_allIn$1_remaining.tail();
                    while (!filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next.isEmpty()) {
                        Object filter_filterCommon_noneIn$1_allIn$1_partialFill$1_head = filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next.head();
                        n = BoxesRunTime.unboxToInt((Object)filter_filterCommon_noneIn$1_allIn$1_partialFill$1_head);
                        if (Election$.$anonfun$leaderForControlledShutdown$2(shuttingDownBrokerIds, n) != filter_filterCommon_isFlipped) {
                            filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next = (List)filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next.tail();
                            continue;
                        }
                        while (filter_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy != filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next) {
                            .colon.colon filter_filterCommon_noneIn$1_allIn$1_partialFill$1_newElem = new .colon.colon(filter_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy.head(), (List)Nil$.MODULE$);
                            filter_filterCommon_noneIn$1_allIn$1_partialFill$1_currentLast.next_$eq((List)filter_filterCommon_noneIn$1_allIn$1_partialFill$1_newElem);
                            filter_filterCommon_noneIn$1_allIn$1_partialFill$1_currentLast = filter_filterCommon_noneIn$1_allIn$1_partialFill$1_newElem;
                            filter_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy = (List)filter_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy.tail();
                        }
                        filter_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy = (List)filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next.tail();
                        filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next = (List)filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next.tail();
                    }
                    if (!filter_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy.isEmpty()) {
                        filter_filterCommon_noneIn$1_allIn$1_partialFill$1_currentLast.next_$eq(filter_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy);
                    }
                    list2 = var19_16;
                    var19_16 = null;
                    var20_17 = null;
                    var21_18 = null;
                    var22_19 = null;
                    var23_20 = null;
                    var24_21 = null;
                    var25_22 = null;
                    var26_23 = null;
                }
                list = list2;
                nil$2 = list;
                var17_14 = null;
                var18_15 = null;
                var19_16 = null;
                var20_17 = null;
                var21_18 = null;
                var22_19 = null;
                var23_20 = null;
                var24_21 = null;
                var25_22 = null;
                var26_23 = null;
                list = null;
                break;
            }
            filter_filterCommon_noneIn$1_l = filter_filterCommon_noneIn$1_t;
        }
        Nil$ nil$3 = nil$ = nil$2;
        Object var14_10 = null;
        Object var15_11 = null;
        Object var16_12 = null;
        var17_14 = null;
        var18_15 = null;
        var19_16 = null;
        var20_17 = null;
        var21_18 = null;
        var22_19 = null;
        var23_20 = null;
        var24_21 = null;
        var25_22 = null;
        var26_23 = null;
        list = null;
        nil$ = null;
        Nil$ nil$4 = nil$3;
        Statics.releaseFence();
        Nil$ nil$5 = nil$4;
        nil$4 = null;
        Nil$ newIsr = nil$5;
        if (leaderOpt == null) {
            throw null;
        }
        if (leaderOpt.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            int $anonfun$leaderForControlledShutdown$3_leader = BoxesRunTime.unboxToInt((Object)leaderOpt.get());
            none$ = new Some((Object)leaderAndIsr.newLeaderAndIsr($anonfun$leaderForControlledShutdown$3_leader, (List<Object>)newIsr));
        }
        None$ none$2 = none$;
        none$ = null;
        None$ newLeaderAndIsrOpt = none$2;
        return new ElectionResult(partition, (Option<LeaderAndIsr>)newLeaderAndIsrOpt, (Seq<Object>)liveOrShuttingDownReplicas);
    }

    public Seq<ElectionResult> leaderForControlledShutdown(ControllerContext controllerContext, Seq<Tuple2<TopicPartition, LeaderAndIsr>> leaderAndIsrs) {
        Set shuttingDownBrokerIds = controllerContext.shuttingDownBrokerIds().toSet();
        return (Seq)leaderAndIsrs.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition partition = (TopicPartition)x0$1._1();
            LeaderAndIsr leaderAndIsr = (LeaderAndIsr)x0$1._2();
            ElectionResult electionResult = MODULE$.leaderForControlledShutdown(partition, leaderAndIsr, (Set<Object>)shuttingDownBrokerIds, controllerContext);
            return electionResult;
        });
    }

    public static final /* synthetic */ LeaderAndIsr $anonfun$leaderForOffline$2(List isr$1, ControllerContext controllerContext$1, TopicPartition partition$1, LeaderAndIsr leaderAndIsr$1, int leader) {
        List list;
        if (isr$1.contains((Object)leader)) {
            Nil$ nil$;
            Object var12_11;
            Object var11_10;
            List list2;
            Object var20_19;
            Object var19_18;
            Object var18_17;
            Object var17_16;
            Object var16_15;
            Object var15_14;
            Object var14_13;
            Object var13_12;
            Nil$ nil$2;
            boolean filter_filterCommon_isFlipped = false;
            List filter_filterCommon_noneIn$1_l = isr$1;
            while (true) {
                if (filter_filterCommon_noneIn$1_l.isEmpty()) {
                    nil$2 = Nil$.MODULE$;
                    break;
                }
                Object filter_filterCommon_noneIn$1_h = filter_filterCommon_noneIn$1_l.head();
                List filter_filterCommon_noneIn$1_t = (List)filter_filterCommon_noneIn$1_l.tail();
                int n = BoxesRunTime.unboxToInt((Object)filter_filterCommon_noneIn$1_h);
                if (controllerContext$1.isReplicaOnline(n, partition$1, controllerContext$1.isReplicaOnline$default$3()) != filter_filterCommon_isFlipped) {
                    List list3;
                    block12: {
                        List filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next;
                        List filter_filterCommon_noneIn$1_allIn$1_remaining = filter_filterCommon_noneIn$1_t;
                        while (true) {
                            if (filter_filterCommon_noneIn$1_allIn$1_remaining.isEmpty()) {
                                list3 = filter_filterCommon_noneIn$1_l;
                                break block12;
                            }
                            Object filter_filterCommon_noneIn$1_allIn$1_x = filter_filterCommon_noneIn$1_allIn$1_remaining.head();
                            n = BoxesRunTime.unboxToInt((Object)filter_filterCommon_noneIn$1_allIn$1_x);
                            if (controllerContext$1.isReplicaOnline(n, partition$1, controllerContext$1.isReplicaOnline$default$3()) == filter_filterCommon_isFlipped) break;
                            filter_filterCommon_noneIn$1_allIn$1_remaining = (List)filter_filterCommon_noneIn$1_allIn$1_remaining.tail();
                        }
                        .colon.colon filter_filterCommon_noneIn$1_allIn$1_partialFill$1_newHead = new .colon.colon(filter_filterCommon_noneIn$1_l.head(), (List)Nil$.MODULE$);
                        .colon.colon filter_filterCommon_noneIn$1_allIn$1_partialFill$1_currentLast = filter_filterCommon_noneIn$1_allIn$1_partialFill$1_newHead;
                        for (List filter_filterCommon_noneIn$1_allIn$1_partialFill$1_toProcess = (List)filter_filterCommon_noneIn$1_l.tail(); filter_filterCommon_noneIn$1_allIn$1_partialFill$1_toProcess != filter_filterCommon_noneIn$1_allIn$1_remaining; filter_filterCommon_noneIn$1_allIn$1_partialFill$1_toProcess = (List)filter_filterCommon_noneIn$1_allIn$1_partialFill$1_toProcess.tail()) {
                            .colon.colon filter_filterCommon_noneIn$1_allIn$1_partialFill$1_newElem = new .colon.colon(filter_filterCommon_noneIn$1_allIn$1_partialFill$1_toProcess.head(), (List)Nil$.MODULE$);
                            filter_filterCommon_noneIn$1_allIn$1_partialFill$1_currentLast.next_$eq((List)filter_filterCommon_noneIn$1_allIn$1_partialFill$1_newElem);
                            filter_filterCommon_noneIn$1_allIn$1_partialFill$1_currentLast = filter_filterCommon_noneIn$1_allIn$1_partialFill$1_newElem;
                        }
                        List filter_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy = filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next = (List)filter_filterCommon_noneIn$1_allIn$1_remaining.tail();
                        while (!filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next.isEmpty()) {
                            Object filter_filterCommon_noneIn$1_allIn$1_partialFill$1_head = filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next.head();
                            n = BoxesRunTime.unboxToInt((Object)filter_filterCommon_noneIn$1_allIn$1_partialFill$1_head);
                            if (controllerContext$1.isReplicaOnline(n, partition$1, controllerContext$1.isReplicaOnline$default$3()) != filter_filterCommon_isFlipped) {
                                filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next = (List)filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next.tail();
                                continue;
                            }
                            while (filter_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy != filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next) {
                                .colon.colon filter_filterCommon_noneIn$1_allIn$1_partialFill$1_newElem = new .colon.colon(filter_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy.head(), (List)Nil$.MODULE$);
                                filter_filterCommon_noneIn$1_allIn$1_partialFill$1_currentLast.next_$eq((List)filter_filterCommon_noneIn$1_allIn$1_partialFill$1_newElem);
                                filter_filterCommon_noneIn$1_allIn$1_partialFill$1_currentLast = filter_filterCommon_noneIn$1_allIn$1_partialFill$1_newElem;
                                filter_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy = (List)filter_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy.tail();
                            }
                            filter_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy = (List)filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next.tail();
                            filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next = (List)filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next.tail();
                        }
                        if (!filter_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy.isEmpty()) {
                            filter_filterCommon_noneIn$1_allIn$1_partialFill$1_currentLast.next_$eq(filter_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy);
                        }
                        list3 = var13_12;
                        var13_12 = null;
                        var14_13 = null;
                        var15_14 = null;
                        var16_15 = null;
                        var17_16 = null;
                        var18_17 = null;
                        var19_18 = null;
                        var20_19 = null;
                    }
                    list2 = list3;
                    nil$2 = list2;
                    var11_10 = null;
                    var12_11 = null;
                    var13_12 = null;
                    var14_13 = null;
                    var15_14 = null;
                    var16_15 = null;
                    var17_16 = null;
                    var18_17 = null;
                    var19_18 = null;
                    var20_19 = null;
                    list2 = null;
                    break;
                }
                filter_filterCommon_noneIn$1_l = filter_filterCommon_noneIn$1_t;
            }
            Nil$ nil$3 = nil$ = nil$2;
            Object var8_6 = null;
            Object var9_8 = null;
            Object var10_9 = null;
            var11_10 = null;
            var12_11 = null;
            var13_12 = null;
            var14_13 = null;
            var15_14 = null;
            var16_15 = null;
            var17_16 = null;
            var18_17 = null;
            var19_18 = null;
            var20_19 = null;
            list2 = null;
            nil$ = null;
            Nil$ nil$4 = nil$3;
            Statics.releaseFence();
            list = nil$4;
            nil$4 = null;
        } else {
            list = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leader}));
        }
        List newIsr = list;
        return leaderAndIsr$1.newLeaderAndIsr(leader, (List<Object>)newIsr);
    }

    public static final /* synthetic */ boolean $anonfun$leaderForControlledShutdown$2(Set shuttingDownBrokerIds$1, int replica) {
        return !shuttingDownBrokerIds$1.contains((Object)replica);
    }

    private Election$() {
    }

    public static final /* synthetic */ LeaderAndIsr $anonfun$leaderForOffline$2$adapted(List isr$1, ControllerContext controllerContext$1, TopicPartition partition$1, LeaderAndIsr leaderAndIsr$1, Object leader) {
        return Election$.$anonfun$leaderForOffline$2(isr$1, controllerContext$1, partition$1, leaderAndIsr$1, BoxesRunTime.unboxToInt((Object)leader));
    }

    public static final /* synthetic */ LeaderAndIsr $anonfun$leaderForReassign$2$adapted(LeaderAndIsr leaderAndIsr$2, Object leader) {
        return leaderAndIsr$2.newLeader(BoxesRunTime.unboxToInt((Object)leader));
    }

    public static final /* synthetic */ LeaderAndIsr $anonfun$leaderForPreferredReplica$2$adapted(LeaderAndIsr leaderAndIsr$3, Object leader) {
        return leaderAndIsr$3.newLeader(BoxesRunTime.unboxToInt((Object)leader));
    }

    public static final /* synthetic */ LeaderAndIsr $anonfun$leaderForControlledShutdown$3$adapted(LeaderAndIsr leaderAndIsr$4, List newIsr$1, Object leader) {
        return leaderAndIsr$4.newLeaderAndIsr(BoxesRunTime.unboxToInt((Object)leader), (List<Object>)newIsr$1);
    }
}

