/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import kafka.api.FixedPortTestUtils$;
import kafka.api.IntegrationTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.internals.ErrorLoggingCallback;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005]e\u0001B\u000e\u001d\u0001\u0005BQA\n\u0001\u0005\u0002\u001dBq!\u000b\u0001C\u0002\u0013%!\u0006\u0003\u00042\u0001\u0001\u0006Ia\u000b\u0005\be\u0001\u0011\r\u0011\"\u0003+\u0011\u0019\u0019\u0004\u0001)A\u0005W!9A\u0007\u0001b\u0001\n\u0013Q\u0003BB\u001b\u0001A\u0003%1\u0006C\u00047\u0001\t\u0007I\u0011B\u001c\t\r\u0001\u0003\u0001\u0015!\u00039\u0011\u001d\t\u0005A1A\u0005\n]BaA\u0011\u0001!\u0002\u0013A\u0004bB\"\u0001\u0005\u0004%\t\u0001\u0012\u0005\u0007\u0017\u0002\u0001\u000b\u0011B#\t\u000b1\u0003A\u0011I'\t\u000bq\u0003A\u0011\u000b\u0016\t\u000bu\u0003A\u0011\u00010\t\u000b-\u0004A\u0011\u00010\t\u000b5\u0004A\u0011\u00028\t\u000f\u0005-\u0002\u0001\"\u0003\u0002.!9\u00111\u0007\u0001\u0005\n\u0005U\u0002\"CA.\u0001E\u0005I\u0011BA/\u0011\u001d\t\u0019\b\u0001C\u0005\u0003k2a!! \u0001\t\u0005}\u0004B\u0002\u0014\u0018\t\u0003\ti\t\u0003\u0004\u0002\u0014^!\tE\u0018\u0005\u0007\u0003+;B\u0011\t0\u0003-Q\u0013\u0018M\\:bGRLwN\\:C_Vt7-\u001a+fgRT!!\b\u0010\u0002\u0007\u0005\u0004\u0018NC\u0001 \u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0012\u0011\u0005\r\"S\"\u0001\u000f\n\u0005\u0015b\"AF%oi\u0016<'/\u0019;j_:$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005A\u0003CA\u0012\u0001\u0003I\u0001(o\u001c3vG\u0016\u0014()\u001e4gKJ\u001c\u0016N_3\u0016\u0003-\u0002\"\u0001L\u0018\u000e\u00035R\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\u00121!\u00138u\u0003M\u0001(o\u001c3vG\u0016\u0014()\u001e4gKJ\u001c\u0016N_3!\u0003U\u0019XM\u001d<fe6+7o]1hK6\u000b\u0007PQ=uKN\fac]3sm\u0016\u0014X*Z:tC\u001e,W*\u0019=CsR,7\u000fI\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\u0002\u001d9,X\u000eU1si&$\u0018n\u001c8tA\u0005Yq.\u001e;qkR$v\u000e]5d+\u0005A\u0004CA\u001d?\u001b\u0005Q$BA\u001e=\u0003\u0011a\u0017M\\4\u000b\u0003u\nAA[1wC&\u0011qH\u000f\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019=,H\u000f];u)>\u0004\u0018n\u0019\u0011\u0002\u0015%t\u0007/\u001e;U_BL7-A\u0006j]B,H\u000fV8qS\u000e\u0004\u0013aD8wKJ\u0014\u0018\u000eZ5oOB\u0013x\u000e]:\u0016\u0003\u0015\u0003\"AR%\u000e\u0003\u001dS!\u0001\u0013\u001f\u0002\tU$\u0018\u000e\\\u0005\u0003\u0015\u001e\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0003Ayg/\u001a:sS\u0012Lgn\u001a)s_B\u001c\b%A\bhK:,'/\u0019;f\u0007>tg-[4t+\u0005q\u0005cA(U-6\t\u0001K\u0003\u0002R%\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003'6\n!bY8mY\u0016\u001cG/[8o\u0013\t)\u0006KA\u0002TKF\u0004\"a\u0016.\u000e\u0003aS!!\u0017\u0010\u0002\rM,'O^3s\u0013\tY\u0006LA\u0006LC\u001a\\\u0017mQ8oM&<\u0017a\u00032s_.,'oQ8v]R\fq\u0002^3ti^KG\u000f[$s_V\u0004\u0018\n\u001a\u000b\u0002?B\u0011A\u0006Y\u0005\u0003C6\u0012A!\u00168ji\"\u0012\u0001c\u0019\t\u0003I&l\u0011!\u001a\u0006\u0003M\u001e\fQA[;oSRT\u0011\u0001[\u0001\u0004_J<\u0017B\u00016f\u0005\u0011!Vm\u001d;\u0002+Q,7\u000f^,ji\"<%o\\;q\u001b\u0016$\u0018\rZ1uC\"\u0012\u0011cY\u0001\u0012i\u0016\u001cHO\u0011:pW\u0016\u0014h)Y5mkJ,GCA0p\u0011\u0015\u0001(\u00031\u0001r\u0003\u0019\u0019w.\\7jiBAAF\u001d;\u0002\f\u0005}q,\u0003\u0002t[\tIa)\u001e8di&|gn\r\t\u0005kv|x0D\u0001w\u0015\t9\b0\u0001\u0005qe>$WoY3s\u0015\tI(0A\u0004dY&,g\u000e^:\u000b\u0005}Y(B\u0001?h\u0003\u0019\t\u0007/Y2iK&\u0011aP\u001e\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\u0011\u000b1\n\t!!\u0002\n\u0007\u0005\rQFA\u0003BeJ\f\u0017\u0010E\u0002-\u0003\u000fI1!!\u0003.\u0005\u0011\u0011\u0015\u0010^3\u0011\t\u00055\u00111\u0004\b\u0005\u0003\u001f\t9\u0002E\u0002\u0002\u00125j!!a\u0005\u000b\u0007\u0005U\u0001%\u0001\u0004=e>|GOP\u0005\u0004\u00033i\u0013A\u0002)sK\u0012,g-C\u0002@\u0003;Q1!!\u0007.!\u0019\t\t#a\n\u0000\u007f6\u0011\u00111\u0005\u0006\u0004\u0003KA\u0018\u0001C2p]N,X.\u001a:\n\t\u0005%\u00121\u0005\u0002\u000e\u0017\u000647.Y\"p]N,X.\u001a:\u00027\r\u0014X-\u0019;f)J\fgn]1di&|g.\u00197Qe>$WoY3s)\r!\u0018q\u0006\u0005\b\u0003c\u0019\u0002\u0019AA\u0006\u0003=!(/\u00198tC\u000e$\u0018n\u001c8bY&#\u0017AG2sK\u0006$XmQ8ogVlWM]!oIN+(m]2sS\n,G\u0003CA\u0010\u0003o\tY$!\u0015\t\u000f\u0005eB\u00031\u0001\u0002\f\u00059qM]8va&#\u0007bBA\u001f)\u0001\u0007\u0011qH\u0001\u0007i>\u0004\u0018nY:\u0011\r\u0005\u0005\u00131JA\u0006\u001d\u0011\t\u0019%a\u0012\u000f\t\u0005E\u0011QI\u0005\u0002]%\u0019\u0011\u0011J\u0017\u0002\u000fA\f7m[1hK&!\u0011QJA(\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005%S\u0006C\u0005\u0002TQ\u0001\n\u00111\u0001\u0002V\u0005i!/Z1e\u0007>lW.\u001b;uK\u0012\u00042\u0001LA,\u0013\r\tI&\f\u0002\b\u0005>|G.Z1o\u0003\u0011\u001a'/Z1uK\u000e{gn];nKJ\fe\u000eZ*vEN\u001c'/\u001b2fI\u0011,g-Y;mi\u0012\u001aTCAA0U\u0011\t)&!\u0019,\u0005\u0005\r\u0004\u0003BA3\u0003_j!!a\u001a\u000b\t\u0005%\u00141N\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u001c.\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003c\n9GA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fAb\u0019:fCR,Gk\u001c9jGN$\"!a\u001e\u0011\u000b=\u000bIhK\u0016\n\u0007\u0005m\u0004KA\u0002NCB\u0014qBQ8v]\u000e,7k\u00195fIVdWM]\n\u0004/\u0005\u0005\u0005\u0003BAB\u0003\u0013k!!!\"\u000b\u0007\u0005\u001de$A\u0003vi&d7/\u0003\u0003\u0002\f\u0006\u0015%AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012$\"!a$\u0011\u0007\u0005Eu#D\u0001\u0001\u0003\u0019!wnV8sW\u0006A1\u000f[;uI><h\u000e")
public class TransactionsBounceTest
extends IntegrationTestHarness {
    private final int producerBufferSize;
    private final int serverMessageMaxBytes = this.producerBufferSize() / 2;
    private final int kafka$api$TransactionsBounceTest$$numPartitions;
    private final String kafka$api$TransactionsBounceTest$$outputTopic;
    private final String inputTopic;
    private final Properties overridingProps = new Properties();

    private int producerBufferSize() {
        return this.producerBufferSize;
    }

    private int serverMessageMaxBytes() {
        return this.serverMessageMaxBytes;
    }

    public int kafka$api$TransactionsBounceTest$$numPartitions() {
        return this.kafka$api$TransactionsBounceTest$$numPartitions;
    }

    public String kafka$api$TransactionsBounceTest$$outputTopic() {
        return this.kafka$api$TransactionsBounceTest$$outputTopic;
    }

    private String inputTopic() {
        return this.inputTopic;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public scala.collection.immutable.Seq<KafkaConfig> generateConfigs() {
        return (scala.collection.immutable.Seq)FixedPortTestUtils$.MODULE$.createBrokerConfigs(this.brokerCount(), this.zkConnect(), true, false).map((Function1 & Serializable)x$1 -> {
            Properties fromProps_overrides = this.overridingProps();
            return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
        });
    }

    @Override
    public int brokerCount() {
        return 4;
    }

    @Test
    public void testWithGroupId() {
        String testBrokerFailure_consumerGroup = "myGroup";
        int testBrokerFailure_numInputRecords = 10000;
        this.createTopics();
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.inputTopic(), testBrokerFailure_numInputRecords, (Seq<KafkaServer>)this.servers());
        KafkaConsumer<byte[], byte[]> testBrokerFailure_consumer = this.createConsumerAndSubscribe(testBrokerFailure_consumerGroup, (List<String>)new .colon.colon((Object)this.inputTopic(), (List)Nil$.MODULE$), false);
        KafkaProducer<byte[], byte[]> testBrokerFailure_producer = this.createTransactionalProducer("test-txn");
        testBrokerFailure_producer.initTransactions();
        BounceScheduler testBrokerFailure_scheduler = new BounceScheduler();
        testBrokerFailure_scheduler.start();
        try {
            IntRef intRef;
            IntRef intRef2;
            int testBrokerFailure_create_e = 0;
            IntRef intRef3 = intRef2 = new IntRef(testBrokerFailure_create_e);
            intRef2 = null;
            IntRef testBrokerFailure_numMessagesProcessed = intRef3;
            int testBrokerFailure_create_e2 = 0;
            IntRef intRef4 = intRef = new IntRef(testBrokerFailure_create_e2);
            intRef = null;
            IntRef testBrokerFailure_iteration = intRef4;
            while (testBrokerFailure_numMessagesProcessed.elem < testBrokerFailure_numInputRecords) {
                int testBrokerFailure_toRead = Math.min(200, testBrokerFailure_numInputRecords - testBrokerFailure_numMessagesProcessed.elem);
                this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append(iteration$1.elem).append(": About to read ").append(testBrokerFailure_toRead).append(" messages, processed ").append(numMessagesProcessed$1.elem).append(" so far..").toString());
                Seq<ConsumerRecord<byte[], byte[]>> testBrokerFailure_records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(testBrokerFailure_consumer, testBrokerFailure_toRead, 15000L);
                this.trace((Function0<String>)(Function0 & Serializable)() -> {
                    if (testBrokerFailure_records == null) {
                        throw null;
                    }
                    return new StringBuilder(52).append("Received ").append(testBrokerFailure_records.length()).append(" messages, sending them transactionally to ").append(this.kafka$api$TransactionsBounceTest$$outputTopic()).toString();
                });
                testBrokerFailure_producer.beginTransaction();
                boolean testBrokerFailure_shouldAbort = testBrokerFailure_iteration.elem % 3 == 0;
                testBrokerFailure_records.foreach((Function1 & Serializable)record -> testBrokerFailure_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.kafka$api$TransactionsBounceTest$$outputTopic(), null, (byte[])record.key(), (byte[])record.value(), !testBrokerFailure_shouldAbort), (Callback)new ErrorLoggingCallback(this.kafka$api$TransactionsBounceTest$$outputTopic(), (byte[])record.key(), (byte[])record.value(), true)));
                this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(35).append("Sent ").append(testBrokerFailure_records.length()).append(" messages. Committing offsets.").toString());
                testBrokerFailure_producer.sendOffsetsToTransaction(AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, TestUtils$.MODULE$.consumerPositions((KafkaConsumer<byte[], byte[]>)testBrokerFailure_consumer)).asJava(), testBrokerFailure_consumerGroup);
                if (testBrokerFailure_shouldAbort) {
                    this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append("Committed offsets. Aborting transaction of ").append(testBrokerFailure_records.length()).append(" messages.").toString());
                    testBrokerFailure_producer.abortTransaction();
                    TestUtils$.MODULE$.resetToCommittedPositions(testBrokerFailure_consumer);
                } else {
                    this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Committed offsets. committing transaction of ").append(testBrokerFailure_records.length()).append(" messages.").toString());
                    testBrokerFailure_producer.commitTransaction();
                    testBrokerFailure_numMessagesProcessed.elem += testBrokerFailure_records.length();
                }
                ++testBrokerFailure_iteration.elem;
            }
        }
        finally {
            testBrokerFailure_scheduler.shutdown();
        }
        KafkaConsumer<byte[], byte[]> testBrokerFailure_verifyingConsumer = this.createConsumerAndSubscribe("randomGroup", (List<String>)new .colon.colon((Object)this.kafka$api$TransactionsBounceTest$$outputTopic(), (List)Nil$.MODULE$), true);
        HashMap testBrokerFailure_recordsByPartition = new HashMap();
        TestUtils$.MODULE$.pollUntilAtLeastNumRecords(testBrokerFailure_verifyingConsumer, testBrokerFailure_numInputRecords, 15000L).foreach((Function1 & Serializable)record -> {
            void append_elem;
            Integer n;
            int n2 = Integer.parseInt(TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
            TopicPartition topicPartition = new TopicPartition(record.topic(), record.partition());
            Buffer buffer = (Buffer)testBrokerFailure_recordsByPartition.getOrElseUpdate((Object)topicPartition, (Function0 & Serializable)() -> new ListBuffer());
            Integer n3 = n = Integer.valueOf(n2);
            n = null;
            Integer n4 = n3;
            if (buffer == null) {
                throw null;
            }
            return (ListBuffer)((Buffer)buffer.addOne((Object)append_elem));
        });
        ListBuffer testBrokerFailure_outputRecords = new ListBuffer();
        testBrokerFailure_recordsByPartition.values().foreach((Function1 & Serializable)partitionValues -> {
            Assert.assertEquals((String)"Out of order messages detected", (Object)partitionValues, (Object)partitionValues.sorted((Ordering)Ordering.Int$.MODULE$));
            return testBrokerFailure_outputRecords.addAll((IterableOnce)partitionValues);
        });
        Set testBrokerFailure_recordSet = testBrokerFailure_outputRecords.toSet();
        Assert.assertEquals((long)testBrokerFailure_numInputRecords, (long)testBrokerFailure_recordSet.size());
        int n = 0;
        Set testBrokerFailure_expectedValues = new Range.Exclusive(n, testBrokerFailure_numInputRecords, 1).toSet();
        if (testBrokerFailure_expectedValues == null) {
            throw null;
        }
        Assert.assertEquals((String)new StringBuilder(18).append("Missing messages: ").append(testBrokerFailure_expectedValues.removedAll((IterableOnce)testBrokerFailure_recordSet)).toString(), (Object)testBrokerFailure_expectedValues, (Object)testBrokerFailure_recordSet);
    }

    @Test
    public void testWithGroupMetadata() {
        String testBrokerFailure_consumerGroup = "myGroup";
        int testBrokerFailure_numInputRecords = 10000;
        this.createTopics();
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.inputTopic(), testBrokerFailure_numInputRecords, (Seq<KafkaServer>)this.servers());
        KafkaConsumer<byte[], byte[]> testBrokerFailure_consumer = this.createConsumerAndSubscribe(testBrokerFailure_consumerGroup, (List<String>)new .colon.colon((Object)this.inputTopic(), (List)Nil$.MODULE$), false);
        KafkaProducer<byte[], byte[]> testBrokerFailure_producer = this.createTransactionalProducer("test-txn");
        testBrokerFailure_producer.initTransactions();
        BounceScheduler testBrokerFailure_scheduler = new BounceScheduler();
        testBrokerFailure_scheduler.start();
        try {
            IntRef intRef;
            IntRef intRef2;
            int testBrokerFailure_create_e = 0;
            IntRef intRef3 = intRef2 = new IntRef(testBrokerFailure_create_e);
            intRef2 = null;
            IntRef testBrokerFailure_numMessagesProcessed = intRef3;
            int testBrokerFailure_create_e2 = 0;
            IntRef intRef4 = intRef = new IntRef(testBrokerFailure_create_e2);
            intRef = null;
            IntRef testBrokerFailure_iteration = intRef4;
            while (testBrokerFailure_numMessagesProcessed.elem < testBrokerFailure_numInputRecords) {
                int testBrokerFailure_toRead = Math.min(200, testBrokerFailure_numInputRecords - testBrokerFailure_numMessagesProcessed.elem);
                this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append(iteration$1.elem).append(": About to read ").append(testBrokerFailure_toRead).append(" messages, processed ").append(numMessagesProcessed$1.elem).append(" so far..").toString());
                Seq<ConsumerRecord<byte[], byte[]>> testBrokerFailure_records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(testBrokerFailure_consumer, testBrokerFailure_toRead, 15000L);
                this.trace((Function0<String>)(Function0 & Serializable)() -> {
                    if (testBrokerFailure_records == null) {
                        throw null;
                    }
                    return new StringBuilder(52).append("Received ").append(testBrokerFailure_records.length()).append(" messages, sending them transactionally to ").append(this.kafka$api$TransactionsBounceTest$$outputTopic()).toString();
                });
                testBrokerFailure_producer.beginTransaction();
                boolean testBrokerFailure_shouldAbort = testBrokerFailure_iteration.elem % 3 == 0;
                testBrokerFailure_records.foreach((Function1 & Serializable)record -> testBrokerFailure_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.kafka$api$TransactionsBounceTest$$outputTopic(), null, (byte[])record.key(), (byte[])record.value(), !testBrokerFailure_shouldAbort), (Callback)new ErrorLoggingCallback(this.kafka$api$TransactionsBounceTest$$outputTopic(), (byte[])record.key(), (byte[])record.value(), true)));
                this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(35).append("Sent ").append(testBrokerFailure_records.length()).append(" messages. Committing offsets.").toString());
                testBrokerFailure_producer.sendOffsetsToTransaction(AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, TestUtils$.MODULE$.consumerPositions((KafkaConsumer<byte[], byte[]>)testBrokerFailure_consumer)).asJava(), testBrokerFailure_consumer.groupMetadata());
                if (testBrokerFailure_shouldAbort) {
                    this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append("Committed offsets. Aborting transaction of ").append(testBrokerFailure_records.length()).append(" messages.").toString());
                    testBrokerFailure_producer.abortTransaction();
                    TestUtils$.MODULE$.resetToCommittedPositions(testBrokerFailure_consumer);
                } else {
                    this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Committed offsets. committing transaction of ").append(testBrokerFailure_records.length()).append(" messages.").toString());
                    testBrokerFailure_producer.commitTransaction();
                    testBrokerFailure_numMessagesProcessed.elem += testBrokerFailure_records.length();
                }
                ++testBrokerFailure_iteration.elem;
            }
        }
        finally {
            testBrokerFailure_scheduler.shutdown();
        }
        KafkaConsumer<byte[], byte[]> testBrokerFailure_verifyingConsumer = this.createConsumerAndSubscribe("randomGroup", (List<String>)new .colon.colon((Object)this.kafka$api$TransactionsBounceTest$$outputTopic(), (List)Nil$.MODULE$), true);
        HashMap testBrokerFailure_recordsByPartition = new HashMap();
        TestUtils$.MODULE$.pollUntilAtLeastNumRecords(testBrokerFailure_verifyingConsumer, testBrokerFailure_numInputRecords, 15000L).foreach((Function1 & Serializable)record -> {
            void append_elem;
            Integer n;
            int n2 = Integer.parseInt(TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
            TopicPartition topicPartition = new TopicPartition(record.topic(), record.partition());
            Buffer buffer = (Buffer)testBrokerFailure_recordsByPartition.getOrElseUpdate((Object)topicPartition, (Function0 & Serializable)() -> new ListBuffer());
            Integer n3 = n = Integer.valueOf(n2);
            n = null;
            Integer n4 = n3;
            if (buffer == null) {
                throw null;
            }
            return (ListBuffer)((Buffer)buffer.addOne((Object)append_elem));
        });
        ListBuffer testBrokerFailure_outputRecords = new ListBuffer();
        testBrokerFailure_recordsByPartition.values().foreach((Function1 & Serializable)partitionValues -> {
            Assert.assertEquals((String)"Out of order messages detected", (Object)partitionValues, (Object)partitionValues.sorted((Ordering)Ordering.Int$.MODULE$));
            return testBrokerFailure_outputRecords.addAll((IterableOnce)partitionValues);
        });
        Set testBrokerFailure_recordSet = testBrokerFailure_outputRecords.toSet();
        Assert.assertEquals((long)testBrokerFailure_numInputRecords, (long)testBrokerFailure_recordSet.size());
        int n = 0;
        Set testBrokerFailure_expectedValues = new Range.Exclusive(n, testBrokerFailure_numInputRecords, 1).toSet();
        if (testBrokerFailure_expectedValues == null) {
            throw null;
        }
        Assert.assertEquals((String)new StringBuilder(18).append("Missing messages: ").append(testBrokerFailure_expectedValues.removedAll((IterableOnce)testBrokerFailure_recordSet)).toString(), (Object)testBrokerFailure_expectedValues, (Object)testBrokerFailure_recordSet);
    }

    private void testBrokerFailure(Function3<KafkaProducer<byte[], byte[]>, String, KafkaConsumer<byte[], byte[]>, BoxedUnit> commit) {
        String consumerGroup = "myGroup";
        int numInputRecords = 10000;
        this.createTopics();
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.inputTopic(), numInputRecords, (Seq<KafkaServer>)this.servers());
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerAndSubscribe(consumerGroup, (List<String>)new .colon.colon((Object)this.inputTopic(), (List)Nil$.MODULE$), false);
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("test-txn");
        producer.initTransactions();
        BounceScheduler scheduler = new BounceScheduler();
        scheduler.start();
        try {
            IntRef intRef;
            IntRef intRef2;
            int create_e = 0;
            IntRef intRef3 = intRef2 = new IntRef(create_e);
            intRef2 = null;
            IntRef numMessagesProcessed = intRef3;
            int create_e2 = 0;
            IntRef intRef4 = intRef = new IntRef(create_e2);
            intRef = null;
            IntRef iteration = intRef4;
            while (numMessagesProcessed.elem < numInputRecords) {
                int toRead = Math.min(200, numInputRecords - numMessagesProcessed.elem);
                this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append(iteration$1.elem).append(": About to read ").append(testBrokerFailure_toRead).append(" messages, processed ").append(numMessagesProcessed$1.elem).append(" so far..").toString());
                Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, toRead, 15000L);
                this.trace((Function0<String>)(Function0 & Serializable)() -> {
                    if (testBrokerFailure_records == null) {
                        throw null;
                    }
                    return new StringBuilder(52).append("Received ").append(testBrokerFailure_records.length()).append(" messages, sending them transactionally to ").append(this.kafka$api$TransactionsBounceTest$$outputTopic()).toString();
                });
                producer.beginTransaction();
                boolean shouldAbort = iteration.elem % 3 == 0;
                records.foreach((Function1 & Serializable)record -> testBrokerFailure_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.kafka$api$TransactionsBounceTest$$outputTopic(), null, (byte[])record.key(), (byte[])record.value(), !testBrokerFailure_shouldAbort), (Callback)new ErrorLoggingCallback(this.kafka$api$TransactionsBounceTest$$outputTopic(), (byte[])record.key(), (byte[])record.value(), true)));
                this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(35).append("Sent ").append(testBrokerFailure_records.length()).append(" messages. Committing offsets.").toString());
                commit.apply(producer, (Object)consumerGroup, consumer);
                if (shouldAbort) {
                    this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append("Committed offsets. Aborting transaction of ").append(testBrokerFailure_records.length()).append(" messages.").toString());
                    producer.abortTransaction();
                    TestUtils$.MODULE$.resetToCommittedPositions(consumer);
                } else {
                    this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Committed offsets. committing transaction of ").append(testBrokerFailure_records.length()).append(" messages.").toString());
                    producer.commitTransaction();
                    numMessagesProcessed.elem += records.length();
                }
                ++iteration.elem;
            }
        }
        finally {
            scheduler.shutdown();
        }
        KafkaConsumer<byte[], byte[]> verifyingConsumer = this.createConsumerAndSubscribe("randomGroup", (List<String>)new .colon.colon((Object)this.kafka$api$TransactionsBounceTest$$outputTopic(), (List)Nil$.MODULE$), true);
        HashMap recordsByPartition = new HashMap();
        TestUtils$.MODULE$.pollUntilAtLeastNumRecords(verifyingConsumer, numInputRecords, 15000L).foreach((Function1 & Serializable)record -> {
            void append_elem;
            Integer n;
            int n2 = Integer.parseInt(TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
            TopicPartition topicPartition = new TopicPartition(record.topic(), record.partition());
            Buffer buffer = (Buffer)testBrokerFailure_recordsByPartition.getOrElseUpdate((Object)topicPartition, (Function0 & Serializable)() -> new ListBuffer());
            Integer n3 = n = Integer.valueOf(n2);
            n = null;
            Integer n4 = n3;
            if (buffer == null) {
                throw null;
            }
            return (ListBuffer)((Buffer)buffer.addOne((Object)append_elem));
        });
        ListBuffer outputRecords = new ListBuffer();
        recordsByPartition.values().foreach((Function1 & Serializable)partitionValues -> {
            Assert.assertEquals((String)"Out of order messages detected", (Object)partitionValues, (Object)partitionValues.sorted((Ordering)Ordering.Int$.MODULE$));
            return testBrokerFailure_outputRecords.addAll((IterableOnce)partitionValues);
        });
        Set recordSet = outputRecords.toSet();
        Assert.assertEquals((long)numInputRecords, (long)recordSet.size());
        int n = 0;
        Set expectedValues = new Range.Exclusive(n, numInputRecords, 1).toSet();
        if (expectedValues == null) {
            throw null;
        }
        Assert.assertEquals((String)new StringBuilder(18).append("Missing messages: ").append(expectedValues.removedAll((IterableOnce)recordSet)).toString(), (Object)expectedValues, (Object)recordSet);
    }

    private KafkaProducer<byte[], byte[]> createTransactionalProducer(String transactionalId) {
        Properties props = new Properties();
        props.put("acks", "all");
        props.put("batch.size", "512");
        props.put("transactional.id", transactionalId);
        props.put("enable.idempotence", "true");
        ByteArraySerializer x$2 = this.createProducer$default$1();
        ByteArraySerializer x$3 = this.createProducer$default$2();
        return this.createProducer(x$2, x$3, props);
    }

    private KafkaConsumer<byte[], byte[]> createConsumerAndSubscribe(String groupId, List<String> topics, boolean readCommitted) {
        Properties consumerProps = new Properties();
        consumerProps.put("group.id", groupId);
        consumerProps.put("enable.auto.commit", "false");
        consumerProps.put("isolation.level", readCommitted ? "read_committed" : "read_uncommitted");
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        KafkaConsumer consumer = this.createConsumer(x$2, x$3, consumerProps, x$4);
        consumer.subscribe((Collection)AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, topics).asJava());
        return consumer;
    }

    private boolean createConsumerAndSubscribe$default$3() {
        return false;
    }

    private Map<Object, Object> createTopics() {
        Properties topicConfig = new Properties();
        topicConfig.put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)2).toString());
        this.createTopic(this.inputTopic(), this.kafka$api$TransactionsBounceTest$$numPartitions(), 3, topicConfig);
        return this.createTopic(this.kafka$api$TransactionsBounceTest$$outputTopic(), this.kafka$api$TransactionsBounceTest$$numPartitions(), 3, topicConfig);
    }

    public TransactionsBounceTest() {
        this.producerBufferSize = 65536;
        this.kafka$api$TransactionsBounceTest$$numPartitions = 3;
        this.kafka$api$TransactionsBounceTest$$outputTopic = "output-topic";
        this.inputTopic = "input-topic";
        this.overridingProps().put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), ((Object)false).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), ((Object)this.serverMessageMaxBytes()).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), ((Object)true).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), ((Object)false).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), ((Object)false).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), ((Object)1).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), ((Object)3).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)2).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), ((Object)1).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), ((Object)3).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "10");
        this.overridingProps().put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
    }

    public static final /* synthetic */ Object $anonfun$testWithGroupId$1$adapted(KafkaProducer producer, String groupId, KafkaConsumer consumer) {
        producer.sendOffsetsToTransaction(AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, TestUtils$.MODULE$.consumerPositions((KafkaConsumer<byte[], byte[]>)consumer)).asJava(), groupId);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testWithGroupMetadata$1$adapted(KafkaProducer producer, String x$2, KafkaConsumer consumer) {
        producer.sendOffsetsToTransaction(AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, TestUtils$.MODULE$.consumerPositions((KafkaConsumer<byte[], byte[]>)consumer)).asJava(), consumer.groupMetadata());
        return BoxedUnit.UNIT;
    }

    public class BounceScheduler
    extends ShutdownableThread {
        public void doWork() {
            this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().servers().foreach((Function1 & Serializable)server -> {
                BounceScheduler.$anonfun$doWork$1(this, server);
                return BoxedUnit.UNIT;
            });
            int n = 0;
            int until$extension_end = this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().kafka$api$TransactionsBounceTest$$numPartitions();
            Range.Exclusive foreach_this = new Range.Exclusive(n, until$extension_end, 1);
            if (!foreach_this.isEmpty()) {
                int foreach_i = foreach_this.start();
                while (true) {
                    TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().zkClient(), this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().kafka$api$TransactionsBounceTest$$outputTopic(), foreach_i, 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
                    if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                    foreach_i += foreach_this.step();
                }
            }
        }

        public void shutdown() {
            super.shutdown();
        }

        public /* synthetic */ TransactionsBounceTest kafka$api$TransactionsBounceTest$BounceScheduler$$$outer() {
            return TransactionsBounceTest.this;
        }

        public static final /* synthetic */ void $anonfun$doWork$1(BounceScheduler $this, KafkaServer server) {
            $this.trace((Function0 & Serializable)() -> StringOps$.MODULE$.format$extension("Shutting down server : %s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{server.config().brokerId()})));
            server.shutdown();
            server.awaitShutdown();
            Thread.sleep(500L);
            $this.trace((Function0 & Serializable)() -> StringOps$.MODULE$.format$extension("Server %s shut down. Starting it up again.", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{server.config().brokerId()})));
            server.startup();
            $this.trace((Function0 & Serializable)() -> StringOps$.MODULE$.format$extension("Restarted server: %s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{server.config().brokerId()})));
            Thread.sleep(500L);
        }

        public BounceScheduler() {
            if (TransactionsBounceTest.this == null) {
                throw null;
            }
            super("daemon-broker-bouncer", false);
        }
    }
}

