/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import kafka.server.BrokerReconfigurable;
import kafka.server.DynamicBrokerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicBrokerConfigTest;
import kafka.server.DynamicListenerConfig;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.TestDynamicThreadPool;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.MapFactory;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005y4A!\u0005\n\u0001/!)a\u0004\u0001C\u0001?!)!\u0005\u0001C\u0001G!)\u0001\u0007\u0001C\u0001G!)!\u0007\u0001C\u0001G!)A\u0007\u0001C\u0001G!)a\u0007\u0001C\u0001G!)\u0001\b\u0001C\u0001G!)!\b\u0001C\u0001G!)A\b\u0001C\u0005{!)A\f\u0001C\u0005;\")!\u000f\u0001C\u0001G!)A\u000f\u0001C\u0001G!)a\u000f\u0001C\u0001G!)\u0001\u0010\u0001C\u0001G!)!\u0010\u0001C\u0001G!)A\u0010\u0001C\u0001G\t9B)\u001f8b[&\u001c'I]8lKJ\u001cuN\u001c4jOR+7\u000f\u001e\u0006\u0003'Q\taa]3sm\u0016\u0014(\"A\u000b\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0007\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\u0001\u0003CA\u0011\u0001\u001b\u0005\u0011\u0012\u0001\u0005;fgR\u001cuN\u001c4jOV\u0003H-\u0019;f)\u0005!\u0003CA\r&\u0013\t1#D\u0001\u0003V]&$\bF\u0001\u0002)!\tIc&D\u0001+\u0015\tYC&A\u0003kk:LGOC\u0001.\u0003\ry'oZ\u0005\u0003_)\u0012A\u0001V3ti\u00061C/Z:u\u0007>tg-[4Va\u0012\fG/Z,ji\"\u001cv.\\3J]Z\fG.\u001b3D_:4\u0017nZ:)\u0005\rA\u0013a\r;fgR\u001cuN\u001c4jOV\u0003H-\u0019;f/&$\bNU3d_:4\u0017nZ;sC\ndWMV1mS\u0012\fG/[8o\r\u0006LG.\u001e:fQ\t!\u0001&\u0001\u000fuKN$(+Z2p]\u001aLw-\u001e:bE2,g+\u00197jI\u0006$\u0018n\u001c8)\u0005\u0015A\u0013a\u0005;fgR\u001cVmY;sSRL8i\u001c8gS\u001e\u001c\bF\u0001\u0004)\u0003M!Xm\u001d;D_:tWm\u0019;j_:\fVo\u001c;bQ\t9\u0001&A\fuKN$8i\u001c8oK\u000e$\u0018n\u001c8SCR,\u0017+^8uC\"\u0012\u0001\u0002K\u0001\u0013m\u0016\u0014\u0018NZ=D_:4\u0017nZ+qI\u0006$X\rF\u0003%}-+&\fC\u0003@\u0013\u0001\u0007\u0001)\u0001\u0003oC6,\u0007CA!I\u001d\t\u0011e\t\u0005\u0002D55\tAI\u0003\u0002F-\u00051AH]8pizJ!a\u0012\u000e\u0002\rA\u0013X\rZ3g\u0013\tI%J\u0001\u0004TiJLgn\u001a\u0006\u0003\u000fjAQ\u0001T\u0005A\u00025\u000bQA^1mk\u0016\u0004\"AT*\u000e\u0003=S!\u0001U)\u0002\t1\fgn\u001a\u0006\u0002%\u0006!!.\u0019<b\u0013\t!vJ\u0001\u0004PE*,7\r\u001e\u0005\u0006-&\u0001\raV\u0001\u0010a\u0016\u0014(I]8lKJ\u001cuN\u001c4jOB\u0011\u0011\u0004W\u0005\u00033j\u0011qAQ8pY\u0016\fg\u000eC\u0003\\\u0013\u0001\u0007q+A\u0007fqB,7\r\u001e$bS2,(/Z\u0001$m\u0016\u0014\u0018NZ=D_:4\u0017nZ+qI\u0006$XmV5uQ&sg/\u00197jI\u000e{gNZ5h)\u0015!clY6q\u0011\u0015y&\u00021\u0001a\u0003\u0019\u0019wN\u001c4jOB\u0011\u0011%Y\u0005\u0003EJ\u00111bS1gW\u0006\u001cuN\u001c4jO\")AM\u0003a\u0001K\u0006IqN]5h!J|\u0007o\u001d\t\u0003M&l\u0011a\u001a\u0006\u0003QF\u000bA!\u001e;jY&\u0011!n\u001a\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\b\"\u00027\u000b\u0001\u0004i\u0017A\u0003<bY&$\u0007K]8qgB!\u0011I\u001c!A\u0013\ty'JA\u0002NCBDQ!\u001d\u0006A\u00025\fA\"\u001b8wC2LG\r\u0015:paN\fA\u0004^3tiB\u000b7o]<pe\u0012\u001cuN\u001c4jO\u0016s7M]=qi&|g\u000e\u000b\u0002\fQ\u0005)C/Z:u!\u0006\u001c8o^8sI\u000e{gNZ5h\u000b:\u001cw\u000eZ3s'\u0016\u001c'/\u001a;DQ\u0006tw-\u001a\u0015\u0003\u0019!\n\u0011\u0004^3ti\u0012Kh.Y7jG2K7\u000f^3oKJ\u001cuN\u001c4jO\"\u0012Q\u0002K\u0001\u0015i\u0016\u001cH/Q;uQ>\u0014\u0018N_3s\u0007>tg-[4)\u00059A\u0013\u0001\u0004;fgR\u001c\u0016P\\8os6\u001c\bFA\b)\u0003E\"Xm\u001d;Es:\fW.[2D_:4\u0017nZ%oSRL\u0017\r\\5{CRLwN\\,ji\"|W\u000f^\"p]\u001aLwm]%o5.C#\u0001\u0005\u0015")
public class DynamicBrokerConfigTest {
    @Test
    public void testConfigUpdate() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        String oldKeystore = "oldKs.jks";
        props.put("ssl.keystore.location", oldKeystore);
        KafkaConfig config = new KafkaConfig((java.util.Map)props, true);
        DynamicBrokerConfig dynamicConfig = config.dynamicConfig();
        Assert.assertSame((Object)config, (Object)dynamicConfig.currentKafkaConfig());
        Assert.assertEquals((Object)oldKeystore, config.values().get("ssl.keystore.location"));
        Assert.assertEquals((Object)oldKeystore, config.valuesFromThisConfigWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
        Assert.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
        int n6 = 1;
        int to$extension_end = 2;
        Range.Inclusive foreach$mVc$sp_this = new Range.Inclusive(n6, to$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                DynamicBrokerConfigTest.$anonfun$testConfigUpdate$1(dynamicConfig, config, oldKeystore, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConfigUpdateWithSomeInvalidConfigs() {
        void apply_elems;
        void $minus$greater$extension_y;
        void apply_elems2;
        void $minus$greater$extension_y2;
        void apply_elems3;
        void $minus$greater$extension_y3;
        void apply_elems4;
        void $minus$greater$extension_y4;
        KafkaConfig kafkaConfig;
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        origProps.put("ssl.keystore.type", "JKS");
        KafkaConfig kafkaConfig2 = kafkaConfig = new KafkaConfig((java.util.Map)origProps, true);
        kafkaConfig = null;
        KafkaConfig config = kafkaConfig2;
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        String string = "ks.p12";
        String $minus$greater$extension_$this = new StringBuilder(44).append("listener.name.external.").append("ssl.keystore.location").toString();
        Object var12_27 = null;
        string = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y4);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Map validProps = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems4);
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        String string2 = "PKCS12";
        String $minus$greater$extension_$this2 = "ssl.keystore.type";
        Object var14_31 = null;
        string2 = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y3);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        scala.collection.immutable.Map securityPropsWithoutListenerPrefix = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$2, (Seq)apply_elems3);
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)securityPropsWithoutListenerPrefix);
        Map$ map$3 = Predef$.MODULE$.Map();
        Object[] objectArray3 = new Tuple2[1];
        String string3 = "somehost:2181";
        String $minus$greater$extension_$this3 = KafkaConfig$.MODULE$.ZkConnectProp();
        Object var16_35 = null;
        string3 = null;
        objectArray3[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y2);
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray3);
        if (map$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        scala.collection.immutable.Map nonDynamicProps = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$3, (Seq)apply_elems2);
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)nonDynamicProps);
        Map$ map$4 = Predef$.MODULE$.Map();
        Object[] objectArray4 = new Tuple2[1];
        String string4 = "invalid";
        String $minus$greater$extension_$this4 = KafkaConfig$.MODULE$.LogCleanerThreadsProp();
        Object var18_39 = null;
        string4 = null;
        objectArray4[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray4);
        if (map$4 == null) {
            throw null;
        }
        arraySeq4 = null;
        scala.collection.immutable.Map invalidProps = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$4, (Seq)apply_elems);
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)invalidProps);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConfigUpdateWithReconfigurableValidationFailure() {
        void apply_elems;
        void $minus$greater$extension_y;
        Map.EmptyMap$ emptyMap$;
        KafkaConfig kafkaConfig;
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        origProps.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), "100000000");
        KafkaConfig kafkaConfig2 = kafkaConfig = new KafkaConfig((java.util.Map)origProps, true);
        kafkaConfig = null;
        KafkaConfig config = kafkaConfig2;
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        Map.EmptyMap$ emptyMap$2 = emptyMap$ = Map.EmptyMap$.MODULE$;
        emptyMap$ = null;
        Map.EmptyMap$ validProps = emptyMap$2;
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        String string = "20";
        String $minus$greater$extension_$this = KafkaConfig$.MODULE$.LogCleanerThreadsProp();
        Object var12_29 = null;
        string = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Map invalidProps = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems);
        Reconfigurable reconfigurable = new Reconfigurable(this){
            private final /* synthetic */ DynamicBrokerConfigTest $outer;

            public void configure(java.util.Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return AsJavaExtensions.SetHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Set)((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp()})))).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
                DynamicBrokerConfigTest.kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(configs);
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        config.dynamicConfig().addReconfigurable(reconfigurable);
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)invalidProps);
        config.dynamicConfig().removeReconfigurable(reconfigurable);
        BrokerReconfigurable brokerReconfigurable = new BrokerReconfigurable(this){
            private final /* synthetic */ DynamicBrokerConfigTest $outer;

            public Set<String> reconfigurableConfigs() {
                return (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp()}));
            }

            public void validateReconfiguration(KafkaConfig newConfig) {
                DynamicBrokerConfigTest.kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(newConfig.originals());
            }

            public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        config.dynamicConfig().addBrokerReconfigurable(brokerReconfigurable);
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)invalidProps);
    }

    @Test
    public void testReconfigurableValidation() {
        KafkaConfig kafkaConfig;
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        KafkaConfig kafkaConfig2 = kafkaConfig = new KafkaConfig((java.util.Map)origProps, true);
        kafkaConfig = null;
        KafkaConfig config = kafkaConfig2;
        Set invalidReconfigurableProps = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp(), KafkaConfig$.MODULE$.BrokerIdProp(), "some.prop"}));
        Set validReconfigurableProps = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp(), KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), "some.prop"}));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> config.dynamicConfig().addReconfigurable(new Reconfigurable(null, invalidReconfigurableProps){
            private final Set configs$1;

            public void configure(java.util.Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return AsJavaExtensions.SetHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Set)this.configs$1).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
            }
            {
                this.configs$1 = configs$1;
            }
        }), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DynamicBrokerConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
        config.dynamicConfig().addReconfigurable(new /* invalid duplicate definition of identical inner class */);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> config.dynamicConfig().addBrokerReconfigurable(new BrokerReconfigurable(null, invalidReconfigurableProps){
            private final Set configs$2;

            public Set<String> reconfigurableConfigs() {
                return this.configs$2;
            }

            public void validateReconfiguration(KafkaConfig newConfig) {
            }

            public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
            }
            {
                this.configs$2 = configs$2;
            }
        }), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DynamicBrokerConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
        config.dynamicConfig().addBrokerReconfigurable(new /* invalid duplicate definition of identical inner class */);
    }

    @Test
    public void testSecurityConfigs() {
        this.verifyUpdate$1("ssl.keystore.location", "ks.jks");
        this.verifyUpdate$1("ssl.keystore.type", "JKS");
        this.verifyUpdate$1("ssl.keystore.password", "password");
        this.verifyUpdate$1("ssl.key.password", "password");
    }

    @Test
    public void testConnectionQuota() {
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "100", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "100", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "0", false, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "hostName1:100,hostName2:0", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "hostName1:100,hostName2:0", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "hostName#:100", true, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsProp(), "100", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsProp(), "100", false, false);
        String listenerMaxConnectionsProp = new StringBuilder(23).append("listener.name.external.").append(KafkaConfig$.MODULE$.MaxConnectionsProp()).toString();
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "10", true, false);
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "10", false, false);
    }

    @Test
    public void testConnectionRateQuota() {
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), "110", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), "120", false, false);
        String listenerMaxConnectionsProp = new StringBuilder(23).append("listener.name.external.").append(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()).toString();
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "20", true, false);
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "30", false, false);
    }

    private void verifyConfigUpdate(String name, Object value, boolean perBrokerConfig, boolean expectFailure) {
        KafkaConfig kafkaConfig;
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        Properties configProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        configProps.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "broker.secret");
        KafkaConfig kafkaConfig2 = kafkaConfig = new KafkaConfig((java.util.Map)configProps, true);
        kafkaConfig = null;
        KafkaConfig config = kafkaConfig2;
        Properties props = new Properties();
        props.put(name, value);
        Object oldValue = config.originals().get(name);
        if (!expectFailure) {
            config.dynamicConfig().validate(props, perBrokerConfig);
            DynamicBrokerConfigTest.updateConfig$1(perBrokerConfig, config, props);
            Assert.assertEquals((Object)value, config.originals().get(name));
            return;
        }
        try {
            config.dynamicConfig().validate(props, perBrokerConfig);
            Assert.fail((String)"Invalid config did not fail validation");
        }
        catch (Exception exception) {}
        DynamicBrokerConfigTest.updateConfig$1(perBrokerConfig, config, props);
        Assert.assertEquals(oldValue, config.originals().get(name));
    }

    private void verifyConfigUpdateWithInvalidConfig(KafkaConfig config, Properties origProps, scala.collection.immutable.Map<String, String> validProps, scala.collection.immutable.Map<String, String> invalidProps) {
        Properties props = new Properties();
        validProps.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Object object = props.put(k, v);
            return object;
        });
        invalidProps.foreach((Function1 & Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$2._1();
            String v = (String)x0$2._2();
            Object object = props.put(k, v);
            return object;
        });
        try {
            config.dynamicConfig().validate(props, true);
            Assert.fail((String)"Invalid config did not fail validation");
        }
        catch (ConfigException configException) {}
        config.dynamicConfig().updateBrokerConfig(0, props);
        validProps.foreach((Function1 & Serializable)x0$3 -> {
            DynamicBrokerConfigTest.$anonfun$verifyConfigUpdateWithInvalidConfig$3(config, x0$3);
            return BoxedUnit.UNIT;
        });
        invalidProps.keySet().foreach((Function1 & Serializable)name -> {
            DynamicBrokerConfigTest.$anonfun$verifyConfigUpdateWithInvalidConfig$4(origProps, config, name);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPasswordConfigEncryption() {
        KafkaConfig kafkaConfig;
        KafkaConfig kafkaConfig2;
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        KafkaConfig kafkaConfig3 = kafkaConfig2 = new KafkaConfig((java.util.Map)props, true);
        kafkaConfig2 = null;
        KafkaConfig configWithoutSecret = kafkaConfig3;
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "config-encoder-secret");
        KafkaConfig kafkaConfig4 = kafkaConfig = new KafkaConfig((java.util.Map)props, true);
        kafkaConfig = null;
        KafkaConfig configWithSecret = kafkaConfig4;
        Properties dynamicProps = new Properties();
        dynamicProps.put(KafkaConfig$.MODULE$.SaslJaasConfigProp(), "myLoginModule required;");
        try {
            configWithoutSecret.dynamicConfig().toPersistentProps(dynamicProps, true);
        }
        catch (ConfigException configException) {}
        Properties persistedProps = configWithSecret.dynamicConfig().toPersistentProps(dynamicProps, true);
        Assert.assertFalse((String)"Password not encoded", (boolean)persistedProps.getProperty(KafkaConfig$.MODULE$.SaslJaasConfigProp()).contains("myLoginModule"));
        Properties decodedProps = configWithSecret.dynamicConfig().fromPersistentProps(persistedProps, true);
        Assert.assertEquals((Object)"myLoginModule required;", (Object)decodedProps.getProperty(KafkaConfig$.MODULE$.SaslJaasConfigProp()));
    }

    @Test
    public void testPasswordConfigEncoderSecretChange() {
        KafkaConfig kafkaConfig;
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        props.put(KafkaConfig$.MODULE$.SaslJaasConfigProp(), "staticLoginModule required;");
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "config-encoder-secret");
        KafkaConfig kafkaConfig2 = kafkaConfig = new KafkaConfig((java.util.Map)props, true);
        kafkaConfig = null;
        KafkaConfig config = kafkaConfig2;
        Properties dynamicProps = new Properties();
        dynamicProps.put(KafkaConfig$.MODULE$.SaslJaasConfigProp(), "dynamicLoginModule required;");
        Properties persistedProps = config.dynamicConfig().toPersistentProps(dynamicProps, true);
        Assert.assertFalse((String)"Password not encoded", (boolean)persistedProps.getProperty(KafkaConfig$.MODULE$.SaslJaasConfigProp()).contains("LoginModule"));
        config.dynamicConfig().updateBrokerConfig(0, persistedProps);
        Assert.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)config.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
        KafkaConfig newConfigWithSameSecret = new KafkaConfig((java.util.Map)props, true);
        newConfigWithSameSecret.dynamicConfig().updateBrokerConfig(0, persistedProps);
        Assert.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)newConfigWithSameSecret.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "new-encoder-secret");
        props.put(KafkaConfig$.MODULE$.PasswordEncoderOldSecretProp(), "config-encoder-secret");
        new KafkaConfig((java.util.Map)props, true).dynamicConfig().updateBrokerConfig(0, persistedProps);
        Assert.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)newConfigWithSameSecret.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "another-new-encoder-secret");
        KafkaConfig newConfigWithNewSecret = new KafkaConfig((java.util.Map)props, true);
        newConfigWithNewSecret.dynamicConfig().updateBrokerConfig(0, persistedProps);
        Assert.assertEquals((Object)"staticLoginModule required;", (Object)((Password)newConfigWithNewSecret.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
    }

    @Test
    public void testDynamicListenerConfig() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 9092, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        KafkaServer kafkaServer = (KafkaServer)EasyMock.createMock(KafkaServer.class);
        EasyMock.expect((Object)kafkaServer.config()).andReturn((Object)oldConfig).anyTimes();
        EasyMock.replay((Object[])new Object[]{kafkaServer});
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://hostname:9092,SASL_PLAINTEXT://hostname:9093");
        new DynamicListenerConfig(kafkaServer).validateReconfiguration(new KafkaConfig((java.util.Map)props, true));
        props.put("listener.name.plaintext.you.should.not.pass", "failure");
        DynamicListenerConfig dynamicListenerConfig = new DynamicListenerConfig(kafkaServer);
        Assert.assertThrows(ConfigException.class, () -> dynamicListenerConfig.validateReconfiguration(new KafkaConfig((java.util.Map)props, true)));
    }

    @Test
    public void testAuthorizerConfig() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 9092, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        KafkaServer kafkaServer = (KafkaServer)EasyMock.createMock(KafkaServer.class);
        public class Kafka_server_DynamicBrokerConfigTest$TestAuthorizer$1
        implements Authorizer,
        Reconfigurable {
            private volatile String superUsers;

            public String superUsers() {
                return this.superUsers;
            }

            public void superUsers_$eq(String x$1) {
                this.superUsers = x$1;
            }

            public java.util.Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo serverInfo) {
                if (Predef$.MODULE$.Map() == null) {
                    throw null;
                }
                return AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)Map.EmptyMap$.MODULE$).asJava();
            }

            public java.util.List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, java.util.List<Action> actions) {
                return null;
            }

            public java.util.List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, java.util.List<AclBinding> aclBindings) {
                return null;
            }

            public java.util.List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, java.util.List<AclBindingFilter> aclBindingFilters) {
                return null;
            }

            public Iterable<AclBinding> acls(AclBindingFilter filter) {
                return null;
            }

            public void close() {
            }

            public void configure(java.util.Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return AsJavaExtensions.SetHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Set)((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"super.users"})))).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
                this.superUsers_$eq(configs.get("super.users").toString());
            }

            public Kafka_server_DynamicBrokerConfigTest$TestAuthorizer$1(DynamicBrokerConfigTest $outer) {
                this.superUsers = "";
            }
        }
        Kafka_server_DynamicBrokerConfigTest$TestAuthorizer$1 authorizer = new Kafka_server_DynamicBrokerConfigTest$TestAuthorizer$1(null);
        EasyMock.expect((Object)kafkaServer.config()).andReturn((Object)oldConfig).anyTimes();
        EasyMock.expect((Object)kafkaServer.authorizer()).andReturn((Object)new Some((Object)authorizer)).anyTimes();
        EasyMock.replay((Object[])new Object[]{kafkaServer});
        try {
            kafkaServer.config().dynamicConfig().addReconfigurables(kafkaServer);
        }
        catch (Throwable throwable) {}
        props.put("super.users", "User:admin");
        kafkaServer.config().dynamicConfig().updateBrokerConfig(0, props);
        Assert.assertEquals((Object)"User:admin", (Object)authorizer.superUsers());
    }

    @Test
    public void testSynonyms() {
        Assert.assertEquals((Object)new .colon.colon((Object)"listener.name.secure.ssl.keystore.type", (List)new .colon.colon((Object)"ssl.keystore.type", (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("listener.name.secure.ssl.keystore.type", true));
        Assert.assertEquals((Object)new .colon.colon((Object)"listener.name.sasl_ssl.plain.sasl.jaas.config", (List)new .colon.colon((Object)"sasl.jaas.config", (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("listener.name.sasl_ssl.plain.sasl.jaas.config", true));
        Assert.assertEquals((Object)new .colon.colon((Object)"some.config", (List)Nil$.MODULE$), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("some.config", true));
        Assert.assertEquals((Object)new .colon.colon((Object)KafkaConfig$.MODULE$.LogRollTimeMillisProp(), (List)new .colon.colon((Object)KafkaConfig$.MODULE$.LogRollTimeHoursProp(), (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(KafkaConfig$.MODULE$.LogRollTimeMillisProp(), true));
    }

    @Test
    public void testDynamicConfigInitializationWithoutConfigsInZK() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createMock(KafkaZkClient.class);
        EasyMock.expect((Object)zkClient.getEntityConfigs(EasyMock.anyString(), EasyMock.anyString())).andReturn((Object)new Properties()).anyTimes();
        EasyMock.replay((Object[])new Object[]{zkClient});
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 9092, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s));
        DynamicBrokerConfig dynamicBrokerConfig = new DynamicBrokerConfig(oldConfig);
        dynamicBrokerConfig.initialize(zkClient);
        dynamicBrokerConfig.addBrokerReconfigurable((BrokerReconfigurable)new TestDynamicThreadPool());
        Properties newprops = new Properties();
        newprops.put(KafkaConfig$.MODULE$.NumIoThreadsProp(), "10");
        newprops.put(KafkaConfig$.MODULE$.BackgroundThreadsProp(), "100");
        dynamicBrokerConfig.updateBrokerConfig(0, newprops);
    }

    public static final /* synthetic */ void $anonfun$testConfigUpdate$1(DynamicBrokerConfig dynamicConfig$1, KafkaConfig config$1, String oldKeystore$1, int i) {
        Properties props1 = new Properties();
        String newKeystore = new StringBuilder(6).append("ks").append(i).append(".jks").toString();
        props1.put(new StringBuilder(44).append("listener.name.external.").append("ssl.keystore.location").toString(), newKeystore);
        dynamicConfig$1.updateBrokerConfig(0, props1);
        Assert.assertNotSame((Object)config$1, (Object)dynamicConfig$1.currentKafkaConfig());
        Assert.assertEquals((Object)newKeystore, config$1.valuesWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
        Assert.assertEquals((Object)newKeystore, config$1.originalsWithPrefix("listener.name.external.").get("ssl.keystore.location"));
        Assert.assertEquals((Object)newKeystore, config$1.valuesWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
        Assert.assertEquals((Object)newKeystore, config$1.originalsWithPrefix("listener.name.external.").get("ssl.keystore.location"));
        Assert.assertEquals((Object)oldKeystore$1, (Object)config$1.getString(KafkaConfig$.MODULE$.SslKeystoreLocationProp()));
        Assert.assertEquals((Object)oldKeystore$1, config$1.originals().get("ssl.keystore.location"));
        Assert.assertEquals((Object)oldKeystore$1, config$1.values().get("ssl.keystore.location"));
        Assert.assertEquals((Object)oldKeystore$1, config$1.originalsStrings().get("ssl.keystore.location"));
        Assert.assertEquals((Object)oldKeystore$1, config$1.valuesFromThisConfigWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
        Assert.assertEquals((Object)oldKeystore$1, config$1.originalsFromThisConfig().get("ssl.keystore.location"));
        Assert.assertEquals((Object)oldKeystore$1, config$1.valuesFromThisConfig().get("ssl.keystore.location"));
        Assert.assertEquals((Object)oldKeystore$1, config$1.originalsFromThisConfig().get("ssl.keystore.location"));
        Assert.assertEquals((Object)oldKeystore$1, config$1.valuesFromThisConfig().get("ssl.keystore.location"));
    }

    public static final void kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(java.util.Map configs) {
        int n = Integer.parseInt(configs.get(KafkaConfig$.MODULE$.LogCleanerThreadsProp()).toString());
        if (n <= 0 || n >= 5) {
            throw new ConfigException(new StringBuilder(24).append("Invalid cleaner threads ").append(n).toString());
        }
    }

    private static final Reconfigurable createReconfigurable$1(Set configs) {
        return new /* invalid duplicate definition of identical inner class */;
    }

    private static final BrokerReconfigurable createBrokerReconfigurable$1(Set configs) {
        return new /* invalid duplicate definition of identical inner class */;
    }

    private final void verifyUpdate$1(String name, Object value) {
        this.verifyConfigUpdate(name, value, true, true);
        this.verifyConfigUpdate(new StringBuilder(23).append("listener.name.external.").append(name).toString(), value, true, false);
        this.verifyConfigUpdate(name, value, false, true);
        this.verifyConfigUpdate(new StringBuilder(23).append("listener.name.external.").append(name).toString(), value, false, true);
    }

    private static final void updateConfig$1(boolean perBrokerConfig$1, KafkaConfig config$3, Properties props$1) {
        if (perBrokerConfig$1) {
            config$3.dynamicConfig().updateBrokerConfig(0, config$3.dynamicConfig().toPersistentProps(props$1, perBrokerConfig$1));
            return;
        }
        config$3.dynamicConfig().updateDefaultConfig(props$1);
    }

    public static final /* synthetic */ void $anonfun$verifyConfigUpdateWithInvalidConfig$3(KafkaConfig config$4, Tuple2 x0$3) {
        if (x0$3 != null) {
            String name = (String)x0$3._1();
            Assert.assertEquals((Object)((String)x0$3._2()), config$4.originals().get(name));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyConfigUpdateWithInvalidConfig$4(Properties origProps$1, KafkaConfig config$4, String name) {
        Assert.assertEquals((Object)origProps$1.get(name), config$4.originals().get(name));
    }
}

