/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.network.SocketServer;
import kafka.server.ConfigEntityName$;
import kafka.server.IntegrationTestUtils$;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.ScramCredentialInfo;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.clients.admin.UserScramCredentialUpsertion;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.quota.ClientQuotaFilter;
import org.apache.kafka.common.quota.ClientQuotaFilterComponent;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterClientQuotasRequest;
import org.apache.kafka.common.requests.AlterClientQuotasResponse;
import org.apache.kafka.common.requests.DescribeClientQuotasRequest;
import org.apache.kafka.common.requests.DescribeClientQuotasResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ClusterTestDefaults(clusterType=Type.BOTH)
@ExtendWith(value={ClusterTestExtensions.class})
@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\t\u001dd\u0001\u0002\u0014(\u00011B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\u0006u\u0001!\ta\u000f\u0005\b\u007f\u0001\u0011\r\u0011\"\u0003A\u0011\u0019I\u0005\u0001)A\u0005\u0003\"9!\n\u0001b\u0001\n\u0013\u0001\u0005BB&\u0001A\u0003%\u0011\tC\u0004M\u0001\t\u0007I\u0011\u0002!\t\r5\u0003\u0001\u0015!\u0003B\u0011\u001dq\u0005A1A\u0005\n\u0001Caa\u0014\u0001!\u0002\u0013\t\u0005\"\u0002)\u0001\t\u0003\t\u0006\"\u0002/\u0001\t\u0003\t\u0006\"\u00020\u0001\t\u0003\t\u0006\"\u00024\u0001\t\u0003\t\u0006\"\u00025\u0001\t\u0003\t\u0006\"\u00026\u0001\t\u0013Y\u0007\"B?\u0001\t\u0003\t\u0006\"B@\u0001\t\u0003\t\u0006BBA\u0002\u0001\u0011\u0005\u0011\u000bC\u0005\u0002\b\u0001\u0011\r\u0011\"\u0003\u0002\n!A\u0011\u0011\t\u0001!\u0002\u0013\tY\u0001C\u0005\u0002D\u0001\u0011\r\u0011\"\u0003\u0002\n!A\u0011Q\t\u0001!\u0002\u0013\tY\u0001\u0003\u0004\u0002H\u0001!I!\u0015\u0005\u0007\u0003\u0013\u0002A\u0011A)\t\r\u00055\u0003\u0001\"\u0001R\u0011\u0019\t\t\u0006\u0001C\u0001#\"1\u0011Q\u000b\u0001\u0005\u0002ECa!!\u0017\u0001\t\u0003\t\u0006bBA/\u0001\u0011%\u0011q\f\u0005\b\u0003_\u0002A\u0011BA9\u0011\u001d\t\t\t\u0001C\u0005\u0003\u0007Cq!!#\u0001\t\u0013\tY\tC\u0004\u0002(\u0002!I!!+\t\u000f\u0005e\u0006\u0001\"\u0003\u0002<\"9\u0011q\u001b\u0001\u0005\n\u0005e\u0007bBA}\u0001\u0011%\u00111 \u0002\u0018\u00072LWM\u001c;Rk>$\u0018m\u001d*fcV,7\u000f\u001e+fgRT!\u0001K\u0015\u0002\rM,'O^3s\u0015\u0005Q\u0013!B6bM.\f7\u0001A\n\u0003\u00015\u0002\"AL\u0019\u000e\u0003=R\u0011\u0001M\u0001\u0006g\u000e\fG.Y\u0005\u0003e=\u0012a!\u00118z%\u00164\u0017aB2mkN$XM\u001d\t\u0003kaj\u0011A\u000e\u0006\u0003o%\nA\u0001^3ti&\u0011\u0011H\u000e\u0002\u0010\u00072,8\u000f^3s\u0013:\u001cH/\u00198dK\u00061A(\u001b8jiz\"\"\u0001\u0010 \u0011\u0005u\u0002Q\"A\u0014\t\u000bM\u0012\u0001\u0019\u0001\u001b\u0002)\r{gn];nKJ\u0014\u0015\u0010^3SCR,\u0007K]8q+\u0005\t\u0005C\u0001\"H\u001b\u0005\u0019%B\u0001#F\u0003\u0011a\u0017M\\4\u000b\u0003\u0019\u000bAA[1wC&\u0011\u0001j\u0011\u0002\u0007'R\u0014\u0018N\\4\u0002+\r{gn];nKJ\u0014\u0015\u0010^3SCR,\u0007K]8qA\u0005!\u0002K]8ek\u000e,'OQ=uKJ\u000bG/\u001a)s_B\fQ\u0003\u0015:pIV\u001cWM\u001d\"zi\u0016\u0014\u0016\r^3Qe>\u0004\b%A\u000bSKF,Xm\u001d;QKJ\u001cWM\u001c;bO\u0016\u0004&o\u001c9\u0002-I+\u0017/^3tiB+'oY3oi\u0006<W\r\u0015:pa\u0002\nA#\u00139D_:tWm\u0019;j_:\u0014\u0016\r^3Qe>\u0004\u0018!F%q\u0007>tg.Z2uS>t'+\u0019;f!J|\u0007\u000fI\u0001\u001di\u0016\u001cH/\u00117uKJ\u001cE.[3oiF+x\u000e^1t%\u0016\fX/Z:u)\u0005\u0011\u0006C\u0001\u0018T\u0013\t!vF\u0001\u0003V]&$\bFA\u0006W!\t9&,D\u0001Y\u0015\tIf'\u0001\u0006b]:|G/\u0019;j_:L!a\u0017-\u0003\u0017\rcWo\u001d;feR+7\u000f^\u0001)i\u0016\u001cH/\u00117uKJ\u001cE.[3oiF+x\u000e^1t%\u0016\fX/Z:u-\u0006d\u0017\u000eZ1uK>sG.\u001f\u0015\u0003\u0019Y\u000bQ\u0004^3ti\u000ec\u0017.\u001a8u#V|G/Y:G_J\u001c6M]1n+N,'o\u001d\u0015\u0005\u001bY\u0003\u0017-A\u0006dYV\u001cH/\u001a:UsB,G%\u00012\n\u0005\r$\u0017A\u0001.L\u0015\t)\u0007,\u0001\u0003UsB,\u0017\u0001\u0007;fgR\fE\u000e^3s\u0013B\fVo\u001c;bgJ+\u0017/^3ti\"\u0012aBV\u0001%i\u0016\u001cH/\u00117uKJ\u001cE.[3oiF+x\u000e^1t\u0013:4\u0018\r\\5e%\u0016\fX/Z:ug\"\u0012qBV\u0001 Kb\u0004Xm\u0019;J]Z\fG.\u001b3SKF,Xm\u001d;XSRDW*Z:tC\u001e,Gc\u0001*mc\"1Q\u000e\u0005CA\u00029\f\u0001B];o]\u0006\u0014G.\u001a\t\u0004]=\u0014\u0016B\u000190\u0005!a$-\u001f8b[\u0016t\u0004\"\u0002:\u0011\u0001\u0004\u0019\u0018aD3ya\u0016\u001cG/\u001a3NKN\u001c\u0018mZ3\u0011\u0005Q\\hBA;z!\t1x&D\u0001x\u0015\tA8&\u0001\u0004=e>|GOP\u0005\u0003u>\na\u0001\u0015:fI\u00164\u0017B\u0001%}\u0015\tQx&A\u0017uKN$\u0018\t\u001c;fe\u000ec\u0017.\u001a8u#V|G/Y:J]Z\fG.\u001b3F]RLG/_\"p[\nLg.\u0019;j_:D#!\u0005,\u00025Q,7\u000f^!mi\u0016\u00148\t\\5f]R\fVo\u001c;bg\n\u000bG-\u00139)\u0005I1\u0016\u0001\r;fgR$Um]2sS\n,7\t\\5f]R\fVo\u001c;bg&sg/\u00197jI\u001aKG\u000e^3s\u0007>l'-\u001b8bi&|g\u000e\u000b\u0002\u0014-\u00069R.\u0019;dQV\u001bXM]\"mS\u0016tG/\u00128uSRLWm]\u000b\u0003\u0003\u0017\u0001b!!\u0004\u0002\u0018\u0005mQBAA\b\u0015\u0011\t\t\"a\u0005\u0002\u0013%lW.\u001e;bE2,'bAA\u000b_\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005e\u0011q\u0002\u0002\u0005\u0019&\u001cH\u000fE\u0004/\u0003;\t\t#a\u000f\n\u0007\u0005}qF\u0001\u0004UkBdWM\r\t\u0005\u0003G\t9$\u0004\u0002\u0002&)!\u0011qEA\u0015\u0003\u0015\tXo\u001c;b\u0015\u0011\tY#!\f\u0002\r\r|W.\\8o\u0015\rQ\u0013q\u0006\u0006\u0005\u0003c\t\u0019$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003k\t1a\u001c:h\u0013\u0011\tI$!\n\u0003#\rc\u0017.\u001a8u#V|G/Y#oi&$\u0018\u0010E\u0002/\u0003{I1!a\u00100\u0005\u0019!u.\u001e2mK\u0006AR.\u0019;dQV\u001bXM]\"mS\u0016tG/\u00128uSRLWm\u001d\u0011\u0002\u001f5\fGo\u00195Ja\u0016sG/\u001b;jKN\f\u0001#\\1uG\"L\u0005/\u00128uSRLWm\u001d\u0011\u0002EM,G/\u001e9EKN\u001c'/\u001b2f\u00072LWM\u001c;Rk>$\u0018m]'bi\u000eDG+Z:u\u0003\t\"Xm\u001d;EKN\u001c'/\u001b2f\u00072LWM\u001c;Rk>$\u0018m]'bi\u000eDW\t_1di\"\u0012\u0011DV\u0001%i\u0016\u001cH\u000fR3tGJL'-Z\"mS\u0016tG/U;pi\u0006\u001cX*\u0019;dQB\u000b'\u000f^5bY\"\u0012!DV\u0001'i\u0016\u001cHo\u00117jK:$\u0018+^8uCN,fn];qa>\u0014H/\u001a3F]RLG/\u001f+za\u0016\u001c\bFA\u000eW\u0003e!Xm\u001d;DY&,g\u000e^)v_R\f7oU1oSRL'0\u001a3)\u0005q1\u0016a\b;fgR\u001cE.[3oiF+x\u000e^1t/&$\b\u000eR3gCVdGOT1nK\"\u0012QDV\u0001\u001bm\u0016\u0014\u0018NZ=EKN\u001c'/\u001b2f\u000b:$\u0018\u000e^=Rk>$\u0018m\u001d\u000b\u0006%\u0006\u0005\u0014Q\r\u0005\b\u0003Gr\u0002\u0019AA\u0011\u0003\u0019)g\u000e^5us\"9\u0011q\r\u0010A\u0002\u0005%\u0014AB9v_R\f7\u000f\u0005\u0004u\u0003W\u001a\u00181H\u0005\u0004\u0003[b(aA'ba\u0006qAo\\\"mS\u0016tG/\u00128uSRLHCBA\u0011\u0003g\ni\bC\u0004\u0002v}\u0001\r!a\u001e\u0002\tU\u001cXM\u001d\t\u0005]\u0005e4/C\u0002\u0002|=\u0012aa\u00149uS>t\u0007bBA@?\u0001\u0007\u0011qO\u0001\tG2LWM\u001c;JI\u0006QAo\\%q\u000b:$\u0018\u000e^=\u0015\t\u0005\u0005\u0012Q\u0011\u0005\b\u0003\u000f\u0003\u0003\u0019AA<\u0003\tI\u0007/\u0001\u000beKN\u001c'/\u001b2f\u00072LWM\u001c;Rk>$\u0018m\u001d\u000b\u0005\u0003\u001b\u000bi\n\u0005\u0005\u0002\u0010\u0006U\u0015\u0011EAL\u001b\t\t\tJC\u0002\u0002\u0014\u0016\u000bA!\u001e;jY&!\u0011QNAI!\u001d\ty)!&t\u00033\u00032AQAN\u0013\r\tyd\u0011\u0005\b\u0003?\u000b\u0003\u0019AAQ\u0003\u00191\u0017\u000e\u001c;feB!\u00111EAR\u0013\u0011\t)+!\n\u0003#\rc\u0017.\u001a8u#V|G/\u0019$jYR,'/A\u0010tK:$G)Z:de&\u0014Wm\u00117jK:$\u0018+^8uCN\u0014V-];fgR$B!a+\u00028B!\u0011QVAZ\u001b\t\tyK\u0003\u0003\u00022\u0006%\u0012\u0001\u0003:fcV,7\u000f^:\n\t\u0005U\u0016q\u0016\u0002\u001d\t\u0016\u001c8M]5cK\u000ec\u0017.\u001a8u#V|G/Y:SKN\u0004xN\\:f\u0011\u001d\tyJ\ta\u0001\u0003C\u000b\u0011#\u00197uKJ,e\u000e^5usF+x\u000e^1t)!\ti,a1\u0002F\u00065\u0007c\u0001\"\u0002@&\u0019\u0011\u0011Y\"\u0003\tY{\u0017\u000e\u001a\u0005\b\u0003G\u001a\u0003\u0019AA\u0011\u0011\u001d\t9m\ta\u0001\u0003\u0013\fQ!\u00197uKJ\u0004b\u0001^A6g\u0006-\u0007#\u0002\u0018\u0002z\u0005m\u0002bBAhG\u0001\u0007\u0011\u0011[\u0001\rm\u0006d\u0017\u000eZ1uK>sG.\u001f\t\u0004]\u0005M\u0017bAAk_\t9!i\\8mK\u0006t\u0017!E1mi\u0016\u00148\t\\5f]R\fVo\u001c;bgR1\u00111\\Ay\u0003o\u0004\u0002\"!8\u0002d\u0006\u0005\u0012Q]\u0007\u0003\u0003?TA!!9\u0002\u0014\u00059Q.\u001e;bE2,\u0017\u0002BA7\u0003?\u0004b!a:\u0002n\u0006uVBAAu\u0015\u0011\tY/!\u000b\u0002\u0013%tG/\u001a:oC2\u001c\u0018\u0002BAx\u0003S\u0014qbS1gW\u00064U\u000f^;sK&k\u0007\u000f\u001c\u0005\b\u0003g$\u0003\u0019AA{\u0003\u001d\u0011X-];fgR\u0004r\u0001^A6\u0003C\tI\rC\u0004\u0002P\u0012\u0002\r!!5\u00029M,g\u000eZ!mi\u0016\u00148\t\\5f]R\fVo\u001c;bgJ+\u0017/^3tiR1\u0011Q B\u0002\u0005?\u0001B!!,\u0002\u0000&!!\u0011AAX\u0005e\tE\u000e^3s\u00072LWM\u001c;Rk>$\u0018m\u001d*fgB|gn]3\t\u000f\t\u0015Q\u00051\u0001\u0003\b\u00059QM\u001c;sS\u0016\u001c\bC\u0002B\u0005\u0005'\u0011IB\u0004\u0003\u0003\f\t=ab\u0001<\u0003\u000e%\t\u0001'C\u0002\u0003\u0012=\nq\u0001]1dW\u0006<W-\u0003\u0003\u0003\u0016\t]!\u0001C%uKJ\f'\r\\3\u000b\u0007\tEq\u0006\u0005\u0003\u0002$\tm\u0011\u0002\u0002B\u000f\u0003K\u0011Qc\u00117jK:$\u0018+^8uC\u0006cG/\u001a:bi&|g\u000eC\u0004\u0002P\u0016\u0002\r!!5)\u000f\u0001\u0011\u0019Ca\u000e\u0003:A!!Q\u0005B\u001a\u001b\t\u00119C\u0003\u0003\u0003*\t-\u0012aA1qS*!!Q\u0006B\u0018\u0003\u001dQW\u000f]5uKJTAA!\r\u00024\u0005)!.\u001e8ji&!!Q\u0007B\u0014\u0005\r!\u0016mZ\u0001\u0006m\u0006dW/Z\u0011\u0003\u0005w\t1\"\u001b8uK\u001e\u0014\u0018\r^5p]\":\u0001Aa\u0010\u00038\t-\u0003\u0003\u0002B!\u0005\u000fj!Aa\u0011\u000b\t\t\u0015#qE\u0001\nKb$XM\\:j_:LAA!\u0013\u0003D\tQQ\t\u001f;f]\u0012<\u0016\u000e\u001e5-\u0005\t53E\u0001B(!\u0011\u0011\tF!\u0016\u000e\u0005\tM#b\u0001B\u0019m%!!q\u000bB*\u0005U\u0019E.^:uKJ$Vm\u001d;FqR,gn]5p]NDc\u0001\u0001B.A\n\u0005\u0004cA,\u0003^%\u0019!q\f-\u0003'\rcWo\u001d;feR+7\u000f\u001e#fM\u0006,H\u000e^:%\u0005\t\r\u0014b\u0001B3I\u0006!!i\u0014+I\u0001")
public class ClientQuotasRequestTest {
    private final ClusterInstance cluster;
    private final String ConsumerByteRateProp;
    private final String ProducerByteRateProp;
    private final String RequestPercentageProp;
    private final String IpConnectionRateProp;
    private final List<Tuple2<ClientQuotaEntity, Object>> matchUserClientEntities;
    private final List<Tuple2<ClientQuotaEntity, Object>> matchIpEntities;

    private String ConsumerByteRateProp() {
        return this.ConsumerByteRateProp;
    }

    private String ProducerByteRateProp() {
        return this.ProducerByteRateProp;
    }

    private String RequestPercentageProp() {
        return this.RequestPercentageProp;
    }

    private String IpConnectionRateProp() {
        return this.IpConnectionRateProp;
    }

    @ClusterTest
    public void testAlterClientQuotasRequest() {
        ClientQuotaEntity entity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"client-id")}))).asJava());
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)Predef$.MODULE$.Map().empty());
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)10000.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ConsumerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)20000.0)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)10000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ConsumerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)15000.0)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)15000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ConsumerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)None$.MODULE$)}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ConsumerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)None$.MODULE$)}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ConsumerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)5000.0)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)5000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ConsumerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)20000.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ConsumerByteRateProp()), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)12.3)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)BoxesRunTime.boxToDouble((double)12.3))}))));
    }

    @ClusterTest
    public void testAlterClientQuotasRequestValidateOnly() {
        ClientQuotaEntity entity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user")}))).asJava());
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)20000.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)23.45)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)BoxesRunTime.boxToDouble((double)23.45))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ConsumerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)50000.0)))}))), true);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)BoxesRunTime.boxToDouble((double)23.45))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)10000.0)))}))), true);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)BoxesRunTime.boxToDouble((double)23.45))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)None$.MODULE$)}))), true);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)BoxesRunTime.boxToDouble((double)23.45))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)10000.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ConsumerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)50000.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)None$.MODULE$)}))), true);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)BoxesRunTime.boxToDouble((double)23.45))}))));
    }

    @ClusterTest(clusterType=Type.ZK)
    public void testClientQuotasForScramUsers() {
        String userName = "user";
        this.cluster.createAdminClient().alterUserScramCredentials(Arrays.asList(new UserScramCredentialUpsertion(userName, new ScramCredentialInfo(ScramMechanism.SCRAM_SHA_256, 4096), "password"))).all().get();
        ClientQuotaEntity entity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)userName)}))).asJava());
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)Predef$.MODULE$.Map().empty());
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)10000.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ConsumerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)20000.0)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)10000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ConsumerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
    }

    @ClusterTest
    public void testAlterIpQuotasRequest() {
        String knownHost = "1.2.3.4";
        String unknownHost = "2.3.4.5";
        ClientQuotaEntity entity = this.toIpEntity((Option<String>)new Some((Object)knownHost));
        ClientQuotaEntity defaultEntity = this.toIpEntity((Option<String>)new Some(null));
        ClientQuotaFilterComponent entityFilter = ClientQuotaFilterComponent.ofEntity((String)"ip", (String)knownHost);
        ClientQuotaFilterComponent defaultEntityFilter = ClientQuotaFilterComponent.ofDefaultEntity((String)"ip");
        ClientQuotaFilterComponent allIpEntityFilter = ClientQuotaFilterComponent.ofEntityType((String)"ip");
        this.verifyIpQuotas$1(allIpEntityFilter, Predef$.MODULE$.Map().empty(), unknownHost);
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.IpConnectionRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)100.0)))}))), false);
        this.verifyIpQuotas$1(entityFilter, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entity), (Object)BoxesRunTime.boxToDouble((double)100.0))})), unknownHost);
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.IpConnectionRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)150.0)))}))), false);
        this.verifyIpQuotas$1(entityFilter, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entity), (Object)BoxesRunTime.boxToDouble((double)150.0))})), unknownHost);
        this.alterEntityQuotas(defaultEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.IpConnectionRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)200.0)))}))), false);
        this.verifyIpQuotas$1(defaultEntityFilter, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultEntity), (Object)BoxesRunTime.boxToDouble((double)200.0))})), unknownHost);
        this.verifyIpQuotas$1(allIpEntityFilter, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entity), (Object)BoxesRunTime.boxToDouble((double)150.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultEntity), (Object)BoxesRunTime.boxToDouble((double)200.0))})), unknownHost);
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.IpConnectionRateProp()), (Object)None$.MODULE$)}))), false);
        this.verifyIpQuotas$1(entityFilter, Predef$.MODULE$.Map().empty(), unknownHost);
        this.alterEntityQuotas(defaultEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.IpConnectionRateProp()), (Object)None$.MODULE$)}))), false);
        this.verifyIpQuotas$1(allIpEntityFilter, Predef$.MODULE$.Map().empty(), unknownHost);
    }

    @ClusterTest
    public void testAlterClientQuotasInvalidRequests() {
        ObjectRef entity = ObjectRef.create((Object)new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"")}))).asJava()));
        Assertions.assertThrows(InvalidRequestException.class, () -> this.alterEntityQuotas((ClientQuotaEntity)entity$1.elem, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)12.34)))}))), true));
        entity.elem = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"")}))).asJava());
        Assertions.assertThrows(InvalidRequestException.class, () -> this.alterEntityQuotas((ClientQuotaEntity)entity$1.elem, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)12.34)))}))), true));
        entity.elem = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), (Object)"name")}))).asJava());
        Assertions.assertThrows(InvalidRequestException.class, () -> this.alterEntityQuotas((ClientQuotaEntity)entity$1.elem, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)12.34)))}))), true));
        entity.elem = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava());
        Assertions.assertThrows(InvalidRequestException.class, () -> this.alterEntityQuotas((ClientQuotaEntity)entity$1.elem, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)10000.5)))}))), true));
        entity.elem = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user")}))).asJava());
        Assertions.assertThrows(InvalidRequestException.class, () -> this.alterEntityQuotas((ClientQuotaEntity)entity$1.elem, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bad"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)))}))), true));
        entity.elem = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user")}))).asJava());
        Assertions.assertThrows(InvalidRequestException.class, () -> this.alterEntityQuotas((ClientQuotaEntity)entity$1.elem, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)10000.5)))}))), true));
    }

    private void expectInvalidRequestWithMessage(Function0<BoxedUnit> runnable, String expectedMessage) {
        InvalidRequestException exception = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> runnable.apply$mcV$sp());
        Assertions.assertTrue((boolean)exception.getMessage().contains(expectedMessage), (String)new StringBuilder(29).append("Expected message ").append(exception).append(" to contain ").append(expectedMessage).toString());
    }

    @ClusterTest
    public void testAlterClientQuotasInvalidEntityCombination() {
        ClientQuotaEntity userAndIpEntity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"1.2.3.4")}))).asJava());
        ClientQuotaEntity clientAndIpEntity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"client"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"1.2.3.4")}))).asJava());
        String expectedExceptionMessage = "Invalid quota entity combination";
        JFunction0.mcV.sp & Serializable expectInvalidRequestWithMessage_runnable = (JFunction0.mcV.sp & Serializable)() -> this.alterEntityQuotas(userAndIpEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)12.34)))}))), true);
        InvalidRequestException expectInvalidRequestWithMessage_exception = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> ClientQuotasRequestTest.$anonfun$expectInvalidRequestWithMessage$1((Function0)expectInvalidRequestWithMessage_runnable));
        Assertions.assertTrue((boolean)expectInvalidRequestWithMessage_exception.getMessage().contains(expectedExceptionMessage), (String)new StringBuilder(29).append("Expected message ").append(expectInvalidRequestWithMessage_exception).append(" to contain ").append(expectedExceptionMessage).toString());
        Object var4_4 = null;
        Object var5_5 = null;
        JFunction0.mcV.sp & Serializable expectInvalidRequestWithMessage_runnable2 = (JFunction0.mcV.sp & Serializable)() -> this.alterEntityQuotas(clientAndIpEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)12.34)))}))), true);
        InvalidRequestException expectInvalidRequestWithMessage_exception2 = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> ClientQuotasRequestTest.$anonfun$expectInvalidRequestWithMessage$1((Function0)expectInvalidRequestWithMessage_runnable2));
        Assertions.assertTrue((boolean)expectInvalidRequestWithMessage_exception2.getMessage().contains(expectedExceptionMessage), (String)new StringBuilder(29).append("Expected message ").append(expectInvalidRequestWithMessage_exception2).append(" to contain ").append(expectedExceptionMessage).toString());
    }

    @ClusterTest
    public void testAlterClientQuotasBadIp() {
        ClientQuotaEntity invalidHostPatternEntity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"abc-123")}))).asJava());
        ClientQuotaEntity unresolvableHostEntity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"ip")}))).asJava());
        String expectedExceptionMessage = "not a valid IP";
        JFunction0.mcV.sp & Serializable expectInvalidRequestWithMessage_runnable = (JFunction0.mcV.sp & Serializable)() -> this.alterEntityQuotas(invalidHostPatternEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.IpConnectionRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)50.0)))}))), true);
        InvalidRequestException expectInvalidRequestWithMessage_exception = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> ClientQuotasRequestTest.$anonfun$expectInvalidRequestWithMessage$1((Function0)expectInvalidRequestWithMessage_runnable));
        Assertions.assertTrue((boolean)expectInvalidRequestWithMessage_exception.getMessage().contains(expectedExceptionMessage), (String)new StringBuilder(29).append("Expected message ").append(expectInvalidRequestWithMessage_exception).append(" to contain ").append(expectedExceptionMessage).toString());
        Object var4_4 = null;
        Object var5_5 = null;
        JFunction0.mcV.sp & Serializable expectInvalidRequestWithMessage_runnable2 = (JFunction0.mcV.sp & Serializable)() -> this.alterEntityQuotas(unresolvableHostEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.IpConnectionRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)50.0)))}))), true);
        InvalidRequestException expectInvalidRequestWithMessage_exception2 = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> ClientQuotasRequestTest.$anonfun$expectInvalidRequestWithMessage$1((Function0)expectInvalidRequestWithMessage_runnable2));
        Assertions.assertTrue((boolean)expectInvalidRequestWithMessage_exception2.getMessage().contains(expectedExceptionMessage), (String)new StringBuilder(29).append("Expected message ").append(expectInvalidRequestWithMessage_exception2).append(" to contain ").append(expectedExceptionMessage).toString());
    }

    @ClusterTest
    public void testDescribeClientQuotasInvalidFilterCombination() {
        ClientQuotaFilterComponent ipFilterComponent = ClientQuotaFilterComponent.ofEntityType((String)"ip");
        ClientQuotaFilterComponent userFilterComponent = ClientQuotaFilterComponent.ofEntityType((String)"user");
        ClientQuotaFilterComponent clientIdFilterComponent = ClientQuotaFilterComponent.ofEntityType((String)"client-id");
        String expectedExceptionMessage = "Invalid entity filter component combination";
        JFunction0.mcV.sp & Serializable expectInvalidRequestWithMessage_runnable = (JFunction0.mcV.sp & Serializable)() -> this.describeClientQuotas(ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaFilterComponent[]{ipFilterComponent, userFilterComponent}))).asJava()));
        InvalidRequestException expectInvalidRequestWithMessage_exception = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> ClientQuotasRequestTest.$anonfun$expectInvalidRequestWithMessage$1((Function0)expectInvalidRequestWithMessage_runnable));
        Assertions.assertTrue((boolean)expectInvalidRequestWithMessage_exception.getMessage().contains(expectedExceptionMessage), (String)new StringBuilder(29).append("Expected message ").append(expectInvalidRequestWithMessage_exception).append(" to contain ").append(expectedExceptionMessage).toString());
        Object var5_5 = null;
        Object var6_6 = null;
        JFunction0.mcV.sp & Serializable expectInvalidRequestWithMessage_runnable2 = (JFunction0.mcV.sp & Serializable)() -> this.describeClientQuotas(ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaFilterComponent[]{ipFilterComponent, clientIdFilterComponent}))).asJava()));
        InvalidRequestException expectInvalidRequestWithMessage_exception2 = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> ClientQuotasRequestTest.$anonfun$expectInvalidRequestWithMessage$1((Function0)expectInvalidRequestWithMessage_runnable2));
        Assertions.assertTrue((boolean)expectInvalidRequestWithMessage_exception2.getMessage().contains(expectedExceptionMessage), (String)new StringBuilder(29).append("Expected message ").append(expectInvalidRequestWithMessage_exception2).append(" to contain ").append(expectedExceptionMessage).toString());
    }

    private List<Tuple2<ClientQuotaEntity, Object>> matchUserClientEntities() {
        return this.matchUserClientEntities;
    }

    private List<Tuple2<ClientQuotaEntity, Object>> matchIpEntities() {
        return this.matchIpEntities;
    }

    private void setupDescribeClientQuotasMatchTest() {
        scala.collection.immutable.Map userClientQuotas = this.matchUserClientEntities().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            ClientQuotaEntity e = (ClientQuotaEntity)x0$1._1();
            double v = x0$1._2$mcD$sp();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e), Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.RequestPercentageProp(), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)v)))})));
            return tuple2;
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map ipQuotas = this.matchIpEntities().map((Function1 & Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            ClientQuotaEntity e = (ClientQuotaEntity)x0$2._1();
            double v = x0$2._2$mcD$sp();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e), Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.IpConnectionRateProp(), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)v)))})));
            return tuple2;
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.mutable.Map<ClientQuotaEntity, KafkaFutureImpl<Void>> result = this.alterClientQuotas((scala.collection.immutable.Map<ClientQuotaEntity, scala.collection.immutable.Map<String, Option<Object>>>)((scala.collection.immutable.Map)userClientQuotas.$plus$plus((IterableOnce)ipQuotas)), false);
        ((List)this.matchUserClientEntities().$plus$plus(this.matchIpEntities())).foreach((Function1 & Serializable)e -> (Void)((KafkaFutureImpl)result.apply(e._1())).get(10L, TimeUnit.SECONDS));
    }

    @ClusterTest
    public void testDescribeClientQuotasMatchExact() {
        this.setupDescribeClientQuotasMatchTest();
        this.matchUserClientEntities().foreach((Function1 & Serializable)x0$1 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchExact$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
        ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Some((Object)"user-1"), (Object)new Some((Object)"client-id-2")), new Tuple2((Object)new Some((Object)"user-3"), (Object)new Some((Object)"client-id-1")), new Tuple2((Object)new Some((Object)"user-2"), (Object)new Some(null)), new Tuple2((Object)new Some((Object)"user-4"), (Object)None$.MODULE$), new Tuple2((Object)new Some(null), (Object)new Some((Object)"client-id-2")), new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)"client-id-1")), new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)"client-id-3"))}))).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            Option u = (Option)x0$2._1();
            Option c = (Option)x0$2._2();
            ClientQuotaEntity clientQuotaEntity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)Option$.MODULE$.option2Iterable(u.map((Function1 & Serializable)x$1 -> new Tuple2((Object)"user", x$1))).$plus$plus((IterableOnce)c.map((Function1 & Serializable)x$2 -> new Tuple2((Object)"client-id", x$2)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava());
            return clientQuotaEntity;
        }).foreach((Function1 & Serializable)e -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchExact$7(this, e);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest
    public void testDescribeClientQuotasMatchPartial() {
        Tuple2 tuple2;
        void testMatchEntities$1_expectedMatchSize;
        void testMatchEntities$1_partition;
        Object var160_143;
        Tuple2 tuple22;
        void testMatchEntities$1_expectedMatchSize2;
        void testMatchEntities$1_partition2;
        Object var146_131;
        Tuple2 tuple23;
        void testMatchEntities$1_expectedMatchSize3;
        void testMatchEntities$1_partition3;
        Object var132_119;
        Tuple2 tuple24;
        void testMatchEntities$1_expectedMatchSize4;
        void testMatchEntities$1_partition4;
        Object var118_107;
        Tuple2 tuple25;
        void testMatchEntities$1_expectedMatchSize5;
        void testMatchEntities$1_partition5;
        Object var104_95;
        Tuple2 tuple26;
        void testMatchEntities$1_expectedMatchSize6;
        void testMatchEntities$1_partition6;
        Object var90_83;
        Tuple2 tuple27;
        void testMatchEntities$1_expectedMatchSize7;
        void testMatchEntities$1_partition7;
        Object var76_71;
        Tuple2 tuple28;
        void testMatchEntities$1_expectedMatchSize8;
        void testMatchEntities$1_partition8;
        Object var62_59;
        Tuple2 tuple29;
        void testMatchEntities$1_expectedMatchSize9;
        void testMatchEntities$1_partition9;
        Object var48_47;
        Tuple2 tuple210;
        void testMatchEntities$1_expectedMatchSize10;
        void testMatchEntities$1_partition10;
        Object var34_35;
        Tuple2 tuple211;
        void testMatchEntities$1_expectedMatchSize11;
        void testMatchEntities$1_partition11;
        Object var20_23;
        Tuple2 tuple212;
        void testMatchEntities$1_expectedMatchSize12;
        void testMatchEntities$1_partition12;
        Object var6_11;
        Tuple2 tuple213;
        void testMatchEntities$1_partition13;
        this.setupDescribeClientQuotasMatchTest();
        Function1 & Serializable intersect = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$5(entity));
        int testMatchEntities$1_expectedMatchSize13 = 3;
        ClientQuotaFilter testMatchEntities$1_filter = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaFilterComponent[]{ClientQuotaFilterComponent.ofEntity((String)"user", (String)"user-1")}))).asJava());
        long l = 15000L;
        long l2 = 100L;
        JFunction0.mcV.sp & Serializable testMatchEntities$1_tryUntilNoAssertionError_assertions = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter, (Function1)testMatchEntities$1_partition13, testMatchEntities$1_expectedMatchSize13);
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            Option testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple213 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime + l) {
                tuple213 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Tuple2 tuple214 = tuple213;
        Object var9_8 = null;
        tuple213 = null;
        Tuple2 tuple215 = tuple214;
        if (tuple215 == null) {
            throw new MatchError(null);
        }
        Option testMatchEntities$1_tryUntilNoAssertionError_error = (Option)tuple215._1();
        boolean bl = tuple215._2$mcZ$sp();
        if (!bl) {
            throw (Throwable)var6_11.get();
        }
        Object var4_6 = null;
        tuple215 = null;
        var6_11 = null;
        Object var1_3 = null;
        intersect = null;
        Function1 & Serializable intersect2 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$6(entity));
        boolean bl2 = false;
        ClientQuotaFilter testMatchEntities$1_filter2 = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaFilterComponent[]{ClientQuotaFilterComponent.ofEntity((String)"user", (String)"unknown")}))).asJava());
        long l3 = 15000L;
        long l4 = 100L;
        JFunction0.mcV.sp & Serializable testMatchEntities$1_tryUntilNoAssertionError_assertions2 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter2, (Function1)testMatchEntities$1_partition12, (int)testMatchEntities$1_expectedMatchSize12);
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            Option testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions2)))) {
                tuple212 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime2 + l3) {
                tuple212 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
        Tuple2 tuple216 = tuple212;
        Object var23_20 = null;
        tuple212 = null;
        Tuple2 tuple217 = tuple216;
        if (tuple217 == null) {
            throw new MatchError(null);
        }
        Option testMatchEntities$1_tryUntilNoAssertionError_error2 = (Option)tuple217._1();
        boolean bl3 = tuple217._2$mcZ$sp();
        if (!bl3) {
            throw (Throwable)var20_23.get();
        }
        Object var18_18 = null;
        tuple217 = null;
        var20_23 = null;
        Object var15_15 = null;
        intersect2 = null;
        Function1 & Serializable intersect3 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$7(entity));
        int n = 2;
        ClientQuotaFilter testMatchEntities$1_filter3 = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaFilterComponent[]{ClientQuotaFilterComponent.ofEntity((String)"client-id", (String)"client-id-2")}))).asJava());
        long l5 = 15000L;
        long l6 = 100L;
        JFunction0.mcV.sp & Serializable testMatchEntities$1_tryUntilNoAssertionError_assertions3 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter3, (Function1)testMatchEntities$1_partition11, (int)testMatchEntities$1_expectedMatchSize11);
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime3 = System.currentTimeMillis();
        while (true) {
            Option testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions3)))) {
                tuple211 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime3 + l5) {
                tuple211 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l5), l6));
        }
        Tuple2 tuple218 = tuple211;
        Object var37_32 = null;
        tuple211 = null;
        Tuple2 tuple219 = tuple218;
        if (tuple219 == null) {
            throw new MatchError(null);
        }
        Option testMatchEntities$1_tryUntilNoAssertionError_error3 = (Option)tuple219._1();
        boolean bl4 = tuple219._2$mcZ$sp();
        if (!bl4) {
            throw (Throwable)var34_35.get();
        }
        Object var32_30 = null;
        tuple219 = null;
        var34_35 = null;
        Object var29_27 = null;
        intersect3 = null;
        Function1 & Serializable intersect4 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$8(entity));
        int n2 = 2;
        ClientQuotaFilter testMatchEntities$1_filter4 = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaFilterComponent[]{ClientQuotaFilterComponent.ofDefaultEntity((String)"user")}))).asJava());
        long l7 = 15000L;
        long l8 = 100L;
        JFunction0.mcV.sp & Serializable testMatchEntities$1_tryUntilNoAssertionError_assertions4 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter4, (Function1)testMatchEntities$1_partition10, (int)testMatchEntities$1_expectedMatchSize10);
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime4 = System.currentTimeMillis();
        while (true) {
            Option testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions4)))) {
                tuple210 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime4 + l7) {
                tuple210 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l7), l8));
        }
        Tuple2 tuple220 = tuple210;
        Object var51_44 = null;
        tuple210 = null;
        Tuple2 tuple221 = tuple220;
        if (tuple221 == null) {
            throw new MatchError(null);
        }
        Option testMatchEntities$1_tryUntilNoAssertionError_error4 = (Option)tuple221._1();
        boolean bl5 = tuple221._2$mcZ$sp();
        if (!bl5) {
            throw (Throwable)var48_47.get();
        }
        Object var46_42 = null;
        tuple221 = null;
        var48_47 = null;
        Object var43_39 = null;
        intersect4 = null;
        Function1 & Serializable intersect5 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$9(entity));
        boolean bl6 = true;
        ClientQuotaFilter testMatchEntities$1_filter5 = ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaFilterComponent[]{ClientQuotaFilterComponent.ofEntity((String)"user", (String)"user-2")}))).asJava());
        long l9 = 15000L;
        long l10 = 100L;
        JFunction0.mcV.sp & Serializable testMatchEntities$1_tryUntilNoAssertionError_assertions5 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter5, (Function1)testMatchEntities$1_partition9, (int)testMatchEntities$1_expectedMatchSize9);
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime5 = System.currentTimeMillis();
        while (true) {
            Option testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions5)))) {
                tuple29 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime5 + l9) {
                tuple29 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l9), l10));
        }
        Tuple2 tuple222 = tuple29;
        Object var65_56 = null;
        tuple29 = null;
        Tuple2 tuple223 = tuple222;
        if (tuple223 == null) {
            throw new MatchError(null);
        }
        Option testMatchEntities$1_tryUntilNoAssertionError_error5 = (Option)tuple223._1();
        boolean bl7 = tuple223._2$mcZ$sp();
        if (!bl7) {
            throw (Throwable)var62_59.get();
        }
        Object var60_54 = null;
        tuple223 = null;
        var62_59 = null;
        Object var57_51 = null;
        intersect5 = null;
        Function1 & Serializable intersect6 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$10(entity));
        boolean bl8 = false;
        ClientQuotaFilter testMatchEntities$1_filter6 = ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaFilterComponent[]{ClientQuotaFilterComponent.ofEntity((String)"client-id", (String)"client-id-1")}))).asJava());
        long l11 = 15000L;
        long l12 = 100L;
        JFunction0.mcV.sp & Serializable testMatchEntities$1_tryUntilNoAssertionError_assertions6 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter6, (Function1)testMatchEntities$1_partition8, (int)testMatchEntities$1_expectedMatchSize8);
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime6 = System.currentTimeMillis();
        while (true) {
            Option testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions6)))) {
                tuple28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime6 + l11) {
                tuple28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l11), l12));
        }
        Tuple2 tuple224 = tuple28;
        Object var79_68 = null;
        tuple28 = null;
        Tuple2 tuple225 = tuple224;
        if (tuple225 == null) {
            throw new MatchError(null);
        }
        Option testMatchEntities$1_tryUntilNoAssertionError_error6 = (Option)tuple225._1();
        boolean bl9 = tuple225._2$mcZ$sp();
        if (!bl9) {
            throw (Throwable)var76_71.get();
        }
        Object var74_66 = null;
        tuple225 = null;
        var76_71 = null;
        Object var71_63 = null;
        intersect6 = null;
        Function1 & Serializable intersect7 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$11(entity));
        int n3 = 4;
        ClientQuotaFilter testMatchEntities$1_filter7 = ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaFilterComponent[]{ClientQuotaFilterComponent.ofEntityType((String)"user")}))).asJava());
        long l13 = 15000L;
        long l14 = 100L;
        JFunction0.mcV.sp & Serializable testMatchEntities$1_tryUntilNoAssertionError_assertions7 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter7, (Function1)testMatchEntities$1_partition7, (int)testMatchEntities$1_expectedMatchSize7);
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime7 = System.currentTimeMillis();
        while (true) {
            Option testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions7)))) {
                tuple27 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime7 + l13) {
                tuple27 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l13), l14));
        }
        Tuple2 tuple226 = tuple27;
        Object var93_80 = null;
        tuple27 = null;
        Tuple2 tuple227 = tuple226;
        if (tuple227 == null) {
            throw new MatchError(null);
        }
        Option testMatchEntities$1_tryUntilNoAssertionError_error7 = (Option)tuple227._1();
        boolean bl10 = tuple227._2$mcZ$sp();
        if (!bl10) {
            throw (Throwable)var90_83.get();
        }
        Object var88_78 = null;
        tuple227 = null;
        var90_83 = null;
        Object var85_75 = null;
        intersect7 = null;
        Function1 & Serializable intersect8 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$12(entity));
        int n4 = 10;
        ClientQuotaFilter testMatchEntities$1_filter8 = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaFilterComponent[]{ClientQuotaFilterComponent.ofEntityType((String)"user")}))).asJava());
        long l15 = 15000L;
        long l16 = 100L;
        JFunction0.mcV.sp & Serializable testMatchEntities$1_tryUntilNoAssertionError_assertions8 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter8, (Function1)testMatchEntities$1_partition6, (int)testMatchEntities$1_expectedMatchSize6);
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime8 = System.currentTimeMillis();
        while (true) {
            Option testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions8)))) {
                tuple26 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime8 + l15) {
                tuple26 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l15), l16));
        }
        Tuple2 tuple228 = tuple26;
        Object var107_92 = null;
        tuple26 = null;
        Tuple2 tuple229 = tuple228;
        if (tuple229 == null) {
            throw new MatchError(null);
        }
        Option testMatchEntities$1_tryUntilNoAssertionError_error8 = (Option)tuple229._1();
        boolean bl11 = tuple229._2$mcZ$sp();
        if (!bl11) {
            throw (Throwable)var104_95.get();
        }
        Object var102_90 = null;
        tuple229 = null;
        var104_95 = null;
        Object var99_87 = null;
        intersect8 = null;
        Function1 & Serializable intersect9 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$13(entity));
        boolean bl12 = true;
        ClientQuotaFilter testMatchEntities$1_filter9 = ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaFilterComponent[]{ClientQuotaFilterComponent.ofEntityType((String)"client-id")}))).asJava());
        long l17 = 15000L;
        long l18 = 100L;
        JFunction0.mcV.sp & Serializable testMatchEntities$1_tryUntilNoAssertionError_assertions9 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter9, (Function1)testMatchEntities$1_partition5, (int)testMatchEntities$1_expectedMatchSize5);
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime9 = System.currentTimeMillis();
        while (true) {
            Option testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions9)))) {
                tuple25 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime9 + l17) {
                tuple25 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l17), l18));
        }
        Tuple2 tuple230 = tuple25;
        Object var121_104 = null;
        tuple25 = null;
        Tuple2 tuple231 = tuple230;
        if (tuple231 == null) {
            throw new MatchError(null);
        }
        Option testMatchEntities$1_tryUntilNoAssertionError_error9 = (Option)tuple231._1();
        boolean bl13 = tuple231._2$mcZ$sp();
        if (!bl13) {
            throw (Throwable)var118_107.get();
        }
        Object var116_102 = null;
        tuple231 = null;
        var118_107 = null;
        Object var113_99 = null;
        intersect9 = null;
        Function1 & Serializable intersect10 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$14(entity));
        int n5 = 7;
        ClientQuotaFilter testMatchEntities$1_filter10 = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaFilterComponent[]{ClientQuotaFilterComponent.ofEntityType((String)"client-id")}))).asJava());
        long l19 = 15000L;
        long l20 = 100L;
        JFunction0.mcV.sp & Serializable testMatchEntities$1_tryUntilNoAssertionError_assertions10 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter10, (Function1)testMatchEntities$1_partition4, (int)testMatchEntities$1_expectedMatchSize4);
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime10 = System.currentTimeMillis();
        while (true) {
            Option testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions10)))) {
                tuple24 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime10 + l19) {
                tuple24 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l19), l20));
        }
        Tuple2 tuple232 = tuple24;
        Object var135_116 = null;
        tuple24 = null;
        Tuple2 tuple233 = tuple232;
        if (tuple233 == null) {
            throw new MatchError(null);
        }
        Option testMatchEntities$1_tryUntilNoAssertionError_error10 = (Option)tuple233._1();
        boolean bl14 = tuple233._2$mcZ$sp();
        if (!bl14) {
            throw (Throwable)var132_119.get();
        }
        Object var130_114 = null;
        tuple233 = null;
        var132_119 = null;
        Object var127_111 = null;
        intersect10 = null;
        Function1 & Serializable intersect11 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$15(entity));
        int n6 = 2;
        ClientQuotaFilter testMatchEntities$1_filter11 = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaFilterComponent[]{ClientQuotaFilterComponent.ofEntityType((String)"ip")}))).asJava());
        long l21 = 15000L;
        long l22 = 100L;
        JFunction0.mcV.sp & Serializable testMatchEntities$1_tryUntilNoAssertionError_assertions11 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter11, (Function1)testMatchEntities$1_partition3, (int)testMatchEntities$1_expectedMatchSize3);
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime11 = System.currentTimeMillis();
        while (true) {
            Option testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions11)))) {
                tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime11 + l21) {
                tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l21), l22));
        }
        Tuple2 tuple234 = tuple23;
        Object var149_128 = null;
        tuple23 = null;
        Tuple2 tuple235 = tuple234;
        if (tuple235 == null) {
            throw new MatchError(null);
        }
        Option testMatchEntities$1_tryUntilNoAssertionError_error11 = (Option)tuple235._1();
        boolean bl15 = tuple235._2$mcZ$sp();
        if (!bl15) {
            throw (Throwable)var146_131.get();
        }
        Object var144_126 = null;
        tuple235 = null;
        var146_131 = null;
        Object var141_123 = null;
        intersect11 = null;
        Function1 & Serializable intersect12 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$16(entity));
        int n7 = 13;
        ClientQuotaFilter testMatchEntities$1_filter12 = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava());
        long l23 = 15000L;
        long l24 = 100L;
        JFunction0.mcV.sp & Serializable testMatchEntities$1_tryUntilNoAssertionError_assertions12 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter12, (Function1)testMatchEntities$1_partition2, (int)testMatchEntities$1_expectedMatchSize2);
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime12 = System.currentTimeMillis();
        while (true) {
            Option testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions12)))) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime12 + l23) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l23), l24));
        }
        Tuple2 tuple236 = tuple22;
        Object var163_140 = null;
        tuple22 = null;
        Tuple2 tuple237 = tuple236;
        if (tuple237 == null) {
            throw new MatchError(null);
        }
        Option testMatchEntities$1_tryUntilNoAssertionError_error12 = (Option)tuple237._1();
        boolean bl16 = tuple237._2$mcZ$sp();
        if (!bl16) {
            throw (Throwable)var160_143.get();
        }
        Object var158_138 = null;
        tuple237 = null;
        var160_143 = null;
        Object var155_135 = null;
        intersect12 = null;
        Function1 & Serializable intersect13 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$17(entity));
        boolean bl17 = false;
        ClientQuotaFilter testMatchEntities$1_filter13 = ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava());
        long l25 = 15000L;
        long l26 = 100L;
        JFunction0.mcV.sp & Serializable testMatchEntities$1_tryUntilNoAssertionError_assertions13 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter13, (Function1)testMatchEntities$1_partition, (int)testMatchEntities$1_expectedMatchSize);
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime13 = System.currentTimeMillis();
        while (true) {
            Option testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions13)))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime13 + l25) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l25), l26));
        }
        Tuple2 tuple238 = tuple2;
        Object var177_152 = null;
        tuple2 = null;
        Tuple2 tuple239 = tuple238;
        if (tuple239 == null) {
            throw new MatchError(null);
        }
        Option testMatchEntities$1_tryUntilNoAssertionError_error13 = (Option)tuple239._1();
        boolean bl18 = tuple239._2$mcZ$sp();
        if (!bl18) {
            void var174_155;
            throw (Throwable)var174_155.get();
        }
    }

    @ClusterTest
    public void testClientQuotasUnsupportedEntityTypes() {
        ClientQuotaEntity entity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other"), (Object)"name")}))).asJava());
        Assertions.assertThrows(UnsupportedVersionException.class, () -> this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)Predef$.MODULE$.Map().empty()));
    }

    @ClusterTest
    public void testClientQuotasSanitized() {
        ClientQuotaEntity entity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user with spaces")}))).asJava());
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)20000.0)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
    }

    @ClusterTest
    public void testClientQuotasWithDefaultName() {
        ClientQuotaEntity entity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)ConfigEntityName$.MODULE$.Default())}))).asJava());
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)20000.0)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
        java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> result = this.describeClientQuotas(ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaFilterComponent[]{ClientQuotaFilterComponent.ofDefaultEntity((String)"client-id")}))).asJava()));
        Predef$.MODULE$.assert(result.isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    private void verifyDescribeEntityQuotas(ClientQuotaEntity entity, scala.collection.immutable.Map<String, Object> quotas) {
        Tuple2 tuple2;
        long l = 100L;
        long tryUntilNoAssertionError_waitTime = 5000L;
        long tryUntilNoAssertionError_computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            Some some;
            try {
                ClientQuotasRequestTest.$anonfun$verifyDescribeEntityQuotas$1(this, entity, quotas);
                some = None$.MODULE$;
            }
            catch (AssertionError $anonfun$tryUntilNoAssertionError$1_ae) {
                some = new Some((Object)$anonfun$tryUntilNoAssertionError$1_ae);
            }
            Object var13_7 = null;
            Some tryUntilNoAssertionError_computeUntilTrue_result = some;
            if (((Option)tryUntilNoAssertionError_computeUntilTrue_result).isEmpty()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > tryUntilNoAssertionError_computeUntilTrue_startTime + tryUntilNoAssertionError_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(tryUntilNoAssertionError_waitTime), l));
        }
        Tuple2 tuple22 = tuple2;
        Object var9_6 = null;
        tuple2 = null;
        Tuple2 tuple23 = tuple22;
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        Option tryUntilNoAssertionError_error = (Option)tuple23._1();
        boolean bl = tuple23._2$mcZ$sp();
        if (!bl) {
            void var6_11;
            throw (Throwable)var6_11.get();
        }
    }

    private ClientQuotaEntity toClientEntity(Option<String> user, Option<String> clientId) {
        return new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)Option$.MODULE$.option2Iterable(user.map((Function1 & Serializable)x$3 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), x$3))).$plus$plus((IterableOnce)clientId.map((Function1 & Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), x$4)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava());
    }

    private ClientQuotaEntity toIpEntity(Option<String> ip) {
        return new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Option$.MODULE$.option2Iterable(ip.map((Function1 & Serializable)x$5 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), x$5))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava());
    }

    private java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> describeClientQuotas(ClientQuotaFilter filter) {
        KafkaFutureImpl result = new KafkaFutureImpl();
        this.sendDescribeClientQuotasRequest(filter).complete(result);
        try {
            return (java.util.Map)result.get();
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    private DescribeClientQuotasResponse sendDescribeClientQuotasRequest(ClientQuotaFilter filter) {
        DescribeClientQuotasRequest request = (DescribeClientQuotasRequest)new DescribeClientQuotasRequest.Builder(filter).build();
        return (DescribeClientQuotasResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, this.cluster.anyBrokerSocketServer(), this.cluster.clientListener(), ClassTag$.MODULE$.apply(DescribeClientQuotasResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private Void alterEntityQuotas(ClientQuotaEntity entity, scala.collection.immutable.Map<String, Option<Object>> alter, boolean validateOnly) {
        try {
            return (Void)((KafkaFutureImpl)this.alterClientQuotas((scala.collection.immutable.Map<ClientQuotaEntity, scala.collection.immutable.Map<String, Option<Object>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entity), alter)}))), validateOnly).get((Object)entity).get()).get(10L, TimeUnit.SECONDS);
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    private scala.collection.mutable.Map<ClientQuotaEntity, KafkaFutureImpl<Void>> alterClientQuotas(scala.collection.immutable.Map<ClientQuotaEntity, scala.collection.immutable.Map<String, Option<Object>>> request, boolean validateOnly) {
        scala.collection.immutable.Iterable entries = (scala.collection.immutable.Iterable)request.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            ClientQuotaEntity entity = (ClientQuotaEntity)x0$1._1();
            scala.collection.immutable.Map alter = (scala.collection.immutable.Map)x0$1._2();
            Collection ops = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)alter.map((Function1 & Serializable)x0$2 -> {
                if (x0$2 == null) {
                    throw new MatchError(null);
                }
                String key = (String)x0$2._1();
                Option value = (Option)x0$2._2();
                ClientQuotaAlteration.Op op = new ClientQuotaAlteration.Op(key, (Double)value.map((Function1 & Serializable)x -> ClientQuotasRequestTest.$anonfun$alterClientQuotas$3(BoxesRunTime.unboxToDouble((Object)x))).getOrElse((Function0 & Serializable)() -> null));
                return op;
            })).asJavaCollection();
            ClientQuotaAlteration clientQuotaAlteration = new ClientQuotaAlteration(entity, ops);
            return clientQuotaAlteration;
        });
        java.util.Map response = CollectionConverters$.MODULE$.MapHasAsJava((Map)request.map((Function1 & Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(e._1()), (Object)new KafkaFutureImpl()))).asJava();
        this.sendAlterClientQuotasRequest((Iterable<ClientQuotaAlteration>)entries, validateOnly).complete(response);
        scala.collection.mutable.Map result = CollectionConverters$.MODULE$.MapHasAsScala(response).asScala();
        Assertions.assertEquals((int)request.size(), (int)result.size());
        request.foreach((Function1 & Serializable)e -> {
            ClientQuotasRequestTest.$anonfun$alterClientQuotas$6(result, e);
            return BoxedUnit.UNIT;
        });
        return result;
    }

    private AlterClientQuotasResponse sendAlterClientQuotasRequest(Iterable<ClientQuotaAlteration> entries, boolean validateOnly) {
        AlterClientQuotasRequest request = (AlterClientQuotasRequest)new AlterClientQuotasRequest.Builder(CollectionConverters$.MODULE$.IterableHasAsJava(entries).asJavaCollection(), validateOnly).build();
        return (AlterClientQuotasResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, this.cluster.anyBrokerSocketServer(), this.cluster.clientListener(), ClassTag$.MODULE$.apply(AlterClientQuotasResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    public static final /* synthetic */ void $anonfun$testAlterIpQuotasRequest$2(ClientQuotasRequestTest $this, scala.collection.immutable.Map expectedMatches$1, String unknownHost$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            ClientQuotaEntity entity = (ClientQuotaEntity)x0$1._1();
            java.util.Map props = (java.util.Map)x0$1._2();
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{$this.IpConnectionRateProp()})), (Object)CollectionConverters$.MODULE$.MapHasAsScala(props).asScala().keySet());
            Assertions.assertEquals((double)BoxesRunTime.unboxToDouble((Object)expectedMatches$1.apply((Object)entity)), (Double)((Double)props.get($this.IpConnectionRateProp())));
            String entityName = (String)entity.entries().get("ip");
            InetAddress entityIp = entityName == null ? InetAddress.getByName(unknownHost$1) : InetAddress.getByName(entityName);
            int currentServerQuota = ((SocketServer)CollectionConverters$.MODULE$.CollectionHasAsScala($this.cluster.brokerSocketServers()).asScala().head()).connectionQuotas().connectionRateForIp(entityIp);
            Assertions.assertTrue((Math.abs(BoxesRunTime.unboxToDouble((Object)expectedMatches$1.apply((Object)entity)) - (double)currentServerQuota) < 0.01 ? 1 : 0) != 0, (String)new StringBuilder(33).append("Connection quota of ").append(entity).append(" is not ").append(expectedMatches$1.apply((Object)entity)).append(" but ").append(currentServerQuota).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testAlterIpQuotasRequest$1(ClientQuotasRequestTest $this, ClientQuotaFilterComponent entityFilter$1, scala.collection.immutable.Map expectedMatches$1, String unknownHost$1) {
        java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> result = $this.describeClientQuotas(ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaFilterComponent[]{entityFilter$1}))).asJava()));
        Assertions.assertEquals((Object)expectedMatches$1.keySet(), (Object)CollectionConverters$.MODULE$.MapHasAsScala(result).asScala().keySet());
        CollectionConverters$.MODULE$.MapHasAsScala(result).asScala().foreach((Function1 & Serializable)x0$1 -> {
            ClientQuotasRequestTest.$anonfun$testAlterIpQuotasRequest$2($this, expectedMatches$1, unknownHost$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyIpQuotas$1(ClientQuotaFilterComponent entityFilter, scala.collection.immutable.Map expectedMatches, String unknownHost$1) {
        Tuple2 tuple2;
        long l = 15000L;
        long l2 = 100L;
        long tryUntilNoAssertionError_computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            Some some;
            try {
                ClientQuotasRequestTest.$anonfun$testAlterIpQuotasRequest$1(this, entityFilter, expectedMatches, unknownHost$1);
                some = None$.MODULE$;
            }
            catch (AssertionError $anonfun$tryUntilNoAssertionError$1_ae) {
                some = new Some((Object)$anonfun$tryUntilNoAssertionError$1_ae);
            }
            Object var14_8 = null;
            Some tryUntilNoAssertionError_computeUntilTrue_result = some;
            if (((Option)tryUntilNoAssertionError_computeUntilTrue_result).isEmpty()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > tryUntilNoAssertionError_computeUntilTrue_startTime + l) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Tuple2 tuple22 = tuple2;
        Object var8_7 = null;
        tuple2 = null;
        Tuple2 tuple23 = tuple22;
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        Option tryUntilNoAssertionError_error = (Option)tuple23._1();
        boolean bl = tuple23._2$mcZ$sp();
        if (!bl) {
            void var5_12;
            throw (Throwable)var5_12.get();
        }
    }

    private final java.util.Map matchEntity$1(ClientQuotaEntity entity) {
        scala.collection.mutable.Iterable components = (scala.collection.mutable.Iterable)CollectionConverters$.MODULE$.MapHasAsScala(entity.entries()).asScala().map((Function1 & Serializable)x0$1 -> {
            ClientQuotaFilterComponent clientQuotaFilterComponent;
            if (x0$1 != null) {
                String entityType = (String)x0$1._1();
                String entityName = (String)x0$1._2();
                switch (entityName == null ? 0 : entityName.hashCode()) {
                    case 0: {
                        if (entityName == null) {
                            clientQuotaFilterComponent = ClientQuotaFilterComponent.ofDefaultEntity((String)entityType);
                            break;
                        }
                    }
                    default: {
                        clientQuotaFilterComponent = ClientQuotaFilterComponent.ofEntity((String)entityType, (String)entityName);
                        break;
                    }
                }
            } else {
                throw new MatchError(null);
            }
            return clientQuotaFilterComponent;
        });
        return this.describeClientQuotas(ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)components.toList()).asJava()));
    }

    public static final /* synthetic */ void $anonfun$testDescribeClientQuotasMatchExact$3(ClientQuotasRequestTest $this, ClientQuotaEntity e$1, double v$1) {
        java.util.Map result = $this.matchEntity$1(e$1);
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertTrue((result.get(e$1) != null ? 1 : 0) != 0);
        Double value = (Double)((java.util.Map)result.get(e$1)).get($this.RequestPercentageProp());
        Assertions.assertNotNull((Object)value);
        Assertions.assertEquals((double)Predef$.MODULE$.Double2double(value), (double)v$1, (double)1.0E-6);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDescribeClientQuotasMatchExact$2(ClientQuotasRequestTest $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            Tuple2 tuple2;
            ClientQuotaEntity e = (ClientQuotaEntity)x0$1._1();
            double v = x0$1._2$mcD$sp();
            long l = 15000L;
            long l2 = 100L;
            long tryUntilNoAssertionError_computeUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                Some some;
                try {
                    ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchExact$3($this, e, v);
                    some = None$.MODULE$;
                }
                catch (AssertionError $anonfun$tryUntilNoAssertionError$1_ae) {
                    some = new Some((Object)$anonfun$tryUntilNoAssertionError$1_ae);
                }
                Object var15_8 = null;
                Some tryUntilNoAssertionError_computeUntilTrue_result = some;
                if (((Option)tryUntilNoAssertionError_computeUntilTrue_result).isEmpty()) {
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    break;
                }
                if (System.currentTimeMillis() > tryUntilNoAssertionError_computeUntilTrue_startTime + l) {
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                    break;
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
            }
            Tuple2 tuple22 = tuple2;
            Object var9_7 = null;
            tuple2 = null;
            Tuple2 tuple23 = tuple22;
            if (tuple23 == null) {
                throw new MatchError(null);
            }
            Option tryUntilNoAssertionError_error = (Option)tuple23._1();
            boolean bl = tuple23._2$mcZ$sp();
            if (!bl) {
                void var6_12;
                throw (Throwable)var6_12.get();
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testDescribeClientQuotasMatchExact$7(ClientQuotasRequestTest $this, ClientQuotaEntity e) {
        java.util.Map result = $this.matchEntity$1(e);
        Assertions.assertEquals((int)0, (int)result.size());
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$2(Function1 partition$1, Tuple2 e) {
        return BoxesRunTime.unboxToBoolean((Object)partition$1.apply(e._1()));
    }

    public static final /* synthetic */ void $anonfun$testDescribeClientQuotasMatchPartial$3(ClientQuotasRequestTest $this, scala.collection.immutable.Map expectedMatchesMap$1, java.util.Map result$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            ClientQuotaEntity entity = (ClientQuotaEntity)x0$1._1();
            double expectedValue = x0$1._2$mcD$sp();
            if (expectedMatchesMap$1.contains((Object)entity)) {
                java.util.Map config = (java.util.Map)result$2.get(entity);
                Assertions.assertNotNull((Object)config);
                Double value = (Double)config.get($this.RequestPercentageProp());
                Assertions.assertNotNull((Object)value);
                Assertions.assertEquals((double)expectedValue, (double)Predef$.MODULE$.Double2double(value), (double)1.0E-6);
                return;
            }
            Assertions.assertNull(result$2.get(entity));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testDescribeClientQuotasMatchPartial$4(ClientQuotasRequestTest $this, scala.collection.immutable.Map expectedMatchesMap$1, java.util.Map result$2, Tuple2 x0$2) {
        if (x0$2 != null) {
            ClientQuotaEntity entity = (ClientQuotaEntity)x0$2._1();
            double expectedValue = x0$2._2$mcD$sp();
            if (expectedMatchesMap$1.contains((Object)entity)) {
                java.util.Map config = (java.util.Map)result$2.get(entity);
                Assertions.assertNotNull((Object)config);
                Double value = (Double)config.get($this.IpConnectionRateProp());
                Assertions.assertNotNull((Object)value);
                Assertions.assertEquals((double)expectedValue, (double)Predef$.MODULE$.Double2double(value), (double)1.0E-6);
                return;
            }
            Assertions.assertNull(result$2.get(entity));
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDescribeClientQuotasMatchPartial$1(ClientQuotasRequestTest $this, ClientQuotaFilter filter$1, Function1 partition$1, int expectedMatchSize$1) {
        void var6_6;
        java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> result = $this.describeClientQuotas(filter$1);
        Tuple2 tuple2 = ((List)$this.matchUserClientEntities().$plus$plus($this.matchIpEntities())).partition((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$2(partition$1, e)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        List expectedMatches = (List)tuple2._1();
        Assertions.assertEquals((int)expectedMatchSize$1, (int)var6_6.size());
        Assertions.assertEquals((int)expectedMatchSize$1, (int)result.size(), (String)new StringBuilder(30).append("Failed to match ").append(expectedMatchSize$1).append(" entities for ").append(filter$1).toString());
        scala.collection.immutable.Map expectedMatchesMap = var6_6.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        $this.matchUserClientEntities().foreach((Function1 & Serializable)x0$1 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$3(this, expectedMatchesMap, result, x0$1);
            return BoxedUnit.UNIT;
        });
        $this.matchIpEntities().foreach((Function1 & Serializable)x0$2 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$4(this, expectedMatchesMap, result, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void testMatchEntities$1(ClientQuotaFilter filter, int expectedMatchSize, Function1 partition) {
        Tuple2 tuple2;
        long l = 15000L;
        long l2 = 100L;
        long tryUntilNoAssertionError_computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            Some some;
            try {
                Object var17_12;
                java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> $anonfun$testDescribeClientQuotasMatchPartial$1_result = this.describeClientQuotas(filter);
                Tuple2 tuple22 = ((List)this.matchUserClientEntities().$plus$plus(this.matchIpEntities())).partition((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$2(partition$1, e)));
                if (tuple22 == null) {
                    throw new MatchError(null);
                }
                List $anonfun$testDescribeClientQuotasMatchPartial$1_expectedMatches = (List)tuple22._1();
                Assertions.assertEquals((int)expectedMatchSize, (int)var17_12.size());
                Assertions.assertEquals((int)expectedMatchSize, (int)$anonfun$testDescribeClientQuotasMatchPartial$1_result.size(), (String)new StringBuilder(30).append("Failed to match ").append(expectedMatchSize).append(" entities for ").append(filter).toString());
                scala.collection.immutable.Map $anonfun$testDescribeClientQuotasMatchPartial$1_expectedMatchesMap = var17_12.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                this.matchUserClientEntities().foreach((Function1 & Serializable)x0$1 -> {
                    ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$3(this, expectedMatchesMap, result, x0$1);
                    return BoxedUnit.UNIT;
                });
                this.matchIpEntities().foreach((Function1 & Serializable)x0$2 -> {
                    ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$4(this, expectedMatchesMap, result, x0$2);
                    return BoxedUnit.UNIT;
                });
                Object var15_10 = null;
                tuple22 = null;
                var17_12 = null;
                Object var18_13 = null;
                some = None$.MODULE$;
            }
            catch (AssertionError $anonfun$tryUntilNoAssertionError$1_ae) {
                some = new Some((Object)$anonfun$tryUntilNoAssertionError$1_ae);
            }
            Object var14_8 = null;
            Some tryUntilNoAssertionError_computeUntilTrue_result = some;
            if (((Option)tryUntilNoAssertionError_computeUntilTrue_result).isEmpty()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > tryUntilNoAssertionError_computeUntilTrue_startTime + l) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Tuple2 tuple23 = tuple2;
        Object var8_7 = null;
        tuple2 = null;
        Tuple2 tuple24 = tuple23;
        if (tuple24 == null) {
            throw new MatchError(null);
        }
        Option tryUntilNoAssertionError_error = (Option)tuple24._1();
        boolean bl = tuple24._2$mcZ$sp();
        if (!bl) {
            void var5_16;
            throw (Throwable)var5_16.get();
        }
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$5(ClientQuotaEntity entity) {
        Object v = entity.entries().get("user");
        String string = "user-1";
        return v != null && v.equals(string);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$6(ClientQuotaEntity entity) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$7(ClientQuotaEntity entity) {
        Object v = entity.entries().get("client-id");
        String string = "client-id-2";
        return v != null && v.equals(string);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$8(ClientQuotaEntity entity) {
        return entity.entries().containsKey("user") && entity.entries().get("user") == null;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$9(ClientQuotaEntity entity) {
        Object v = entity.entries().get("user");
        String string = "user-2";
        return v != null && v.equals(string) && !entity.entries().containsKey("client-id");
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$10(ClientQuotaEntity entity) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$11(ClientQuotaEntity entity) {
        return entity.entries().containsKey("user") && !entity.entries().containsKey("client-id");
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$12(ClientQuotaEntity entity) {
        return entity.entries().containsKey("user");
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$13(ClientQuotaEntity entity) {
        return entity.entries().containsKey("client-id") && !entity.entries().containsKey("user");
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$14(ClientQuotaEntity entity) {
        return entity.entries().containsKey("client-id");
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$15(ClientQuotaEntity entity) {
        return entity.entries().containsKey("ip");
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$16(ClientQuotaEntity entity) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$17(ClientQuotaEntity entity) {
        return false;
    }

    public static final /* synthetic */ void $anonfun$verifyDescribeEntityQuotas$5(java.util.Map configs$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            String k = (String)x0$2._1();
            double v = x0$2._2$mcD$sp();
            Double value = (Double)configs$1.get(k);
            Assertions.assertNotNull((Object)value);
            Assertions.assertEquals((double)v, (double)Predef$.MODULE$.Double2double(value), (double)1.0E-6);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyDescribeEntityQuotas$1(ClientQuotasRequestTest $this, ClientQuotaEntity entity$3, scala.collection.immutable.Map quotas$1) {
        scala.collection.mutable.Iterable components = (scala.collection.mutable.Iterable)CollectionConverters$.MODULE$.MapHasAsScala(entity$3.entries()).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String entityType = (String)x0$1._1();
            String entityName = (String)x0$1._2();
            ClientQuotaFilterComponent clientQuotaFilterComponent = (ClientQuotaFilterComponent)Option$.MODULE$.apply((Object)entityName).map((Function1 & Serializable)name -> ClientQuotaFilterComponent.ofEntity((String)entityType, (String)name)).getOrElse((Function0 & Serializable)() -> ClientQuotaFilterComponent.ofDefaultEntity((String)entityType));
            return clientQuotaFilterComponent;
        });
        java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> describe = $this.describeClientQuotas(ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)components.toList()).asJava()));
        if (quotas$1.isEmpty()) {
            Assertions.assertEquals((int)0, (int)describe.size());
            return;
        }
        Assertions.assertEquals((int)1, (int)describe.size());
        java.util.Map<String, Double> configs = describe.get(entity$3);
        Assertions.assertNotNull(configs);
        Assertions.assertEquals((int)quotas$1.size(), (int)configs.size());
        quotas$1.foreach((Function1 & Serializable)x0$2 -> {
            ClientQuotasRequestTest.$anonfun$verifyDescribeEntityQuotas$5(configs, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Double $anonfun$alterClientQuotas$3(double x) {
        return BoxesRunTime.boxToDouble((double)x);
    }

    public static final /* synthetic */ void $anonfun$alterClientQuotas$6(scala.collection.mutable.Map result$3, Tuple2 e) {
        Assertions.assertTrue((boolean)result$3.contains(e._1()));
    }

    public ClientQuotasRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
        this.ConsumerByteRateProp = "consumer_byte_rate";
        this.ProducerByteRateProp = "producer_byte_rate";
        this.RequestPercentageProp = "request_percentage";
        this.IpConnectionRateProp = "connection_creation_rate";
        this.matchUserClientEntities = ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)new Some((Object)"user-1"), (Object)new Some((Object)"client-id-1"), (Object)BoxesRunTime.boxToDouble((double)50.5)), new Tuple3((Object)new Some((Object)"user-2"), (Object)new Some((Object)"client-id-1"), (Object)BoxesRunTime.boxToDouble((double)51.51)), new Tuple3((Object)new Some((Object)"user-3"), (Object)new Some((Object)"client-id-2"), (Object)BoxesRunTime.boxToDouble((double)52.52)), new Tuple3((Object)new Some(null), (Object)new Some((Object)"client-id-1"), (Object)BoxesRunTime.boxToDouble((double)53.53)), new Tuple3((Object)new Some((Object)"user-1"), (Object)new Some(null), (Object)BoxesRunTime.boxToDouble((double)54.54)), new Tuple3((Object)new Some((Object)"user-3"), (Object)new Some(null), (Object)BoxesRunTime.boxToDouble((double)55.55)), new Tuple3((Object)new Some((Object)"user-1"), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)56.56)), new Tuple3((Object)new Some((Object)"user-2"), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)57.57)), new Tuple3((Object)new Some((Object)"user-3"), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)58.58)), new Tuple3((Object)new Some(null), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)59.59)), new Tuple3((Object)None$.MODULE$, (Object)new Some((Object)"client-id-2"), (Object)BoxesRunTime.boxToDouble((double)60.6))}))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            Option u = (Option)x0$1._1();
            Option c = (Option)x0$1._2();
            double v = BoxesRunTime.unboxToDouble((Object)x0$1._3());
            Tuple2 tuple2 = new Tuple2((Object)this.toClientEntity((Option<String>)u, (Option<String>)c), (Object)BoxesRunTime.boxToDouble((double)v));
            return tuple2;
        });
        this.matchIpEntities = ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Some((Object)"1.2.3.4"), (Object)BoxesRunTime.boxToDouble((double)10.0)), new Tuple2((Object)new Some((Object)"2.3.4.5"), (Object)BoxesRunTime.boxToDouble((double)20.0))}))).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            Some ip = (Some)x0$2._1();
            double quota = x0$2._2$mcD$sp();
            Tuple2 tuple2 = new Tuple2((Object)this.toIpEntity((Option<String>)ip), (Object)BoxesRunTime.boxToDouble((double)quota));
            return tuple2;
        });
    }
}

