/*
 * Decompiled with CFR 0.152.
 */
package kafka.testkit;

import kafka.testkit.TestKitNode;

public class ControllerNode
implements TestKitNode {
    private final int id;
    private final String metadataDirectory;

    ControllerNode(int id, String metadataDirectory) {
        this.id = id;
        this.metadataDirectory = metadataDirectory;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public String metadataDirectory() {
        return this.metadataDirectory;
    }

    public static class Builder {
        private int id = -1;
        private String metadataDirectory = null;

        public Builder setId(int id) {
            this.id = id;
            return this;
        }

        public Builder setMetadataDirectory() {
            this.metadataDirectory = this.metadataDirectory;
            return this;
        }

        public ControllerNode build() {
            if (this.id == -1) {
                throw new RuntimeException("You must set the node id");
            }
            if (this.metadataDirectory == null) {
                this.metadataDirectory = String.format("controller_%d", this.id);
            }
            return new ControllerNode(this.id, this.metadataDirectory);
        }
    }
}

