/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import kafka.admin.FeatureCommand$;
import kafka.admin.FeatureCommandTestEnv;
import kafka.tools.TerseFailure;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005E3AAD\b\u0001)!)1\u0004\u0001C\u00019!)q\u0004\u0001C\u0001A!)\u0011\u0007\u0001C\u0001A!)1\u0007\u0001C\u0001A!)Q\u0007\u0001C\u0001A!)q\u0007\u0001C\u0001q!)1\t\u0001C\u0001A!)Q\t\u0001C\u0001A!)q\t\u0001C\u0001A!)\u0011\n\u0001C\u0001A!)1\n\u0001C\u0001A!)Q\n\u0001C\u0001A!)q\n\u0001C\u0001A\t1b)Z1ukJ,7i\\7nC:$WK\\5u)\u0016\u001cHO\u0003\u0002\u0011#\u0005)\u0011\rZ7j]*\t!#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001)\u0002C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u001f\u0005\tB/Z:u\u0019\u00164X\r\u001c+p'R\u0014\u0018N\\4\u0015\u0003\u0005\u0002\"A\u0006\u0012\n\u0005\r:\"\u0001B+oSRD#AA\u0013\u0011\u0005\u0019zS\"A\u0014\u000b\u0005!J\u0013aA1qS*\u0011!fK\u0001\bUV\u0004\u0018\u000e^3s\u0015\taS&A\u0003kk:LGOC\u0001/\u0003\ry'oZ\u0005\u0003a\u001d\u0012A\u0001V3ti\u0006aB/Z:u\u001b\u0016$\u0018\rZ1uCZ+'o]5p]N$vn\u0015;sS:<\u0007FA\u0002&\u0003E!Xm\u001d;e_^twM]1eKRK\b/\u001a\u0015\u0003\t\u0015\nQ\u0003^3tiB\u000b'o]3OC6,\u0017I\u001c3MKZ,G\u000e\u000b\u0002\u0006K\u0005\t\"-^5mI\u0006#W.\u001b8DY&,g\u000e^\u0019\u0015\u0003e\u0002\"AO!\u000e\u0003mR!\u0001\u0005\u001f\u000b\u0005ur\u0014aB2mS\u0016tGo\u001d\u0006\u0003%}R!\u0001Q\u0017\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t\u00115HA\bN_\u000e\\\u0017\tZ7j]\u000ec\u0017.\u001a8u\u0003I!Xm\u001d;IC:$G.\u001a#fg\u000e\u0014\u0018NY3)\u0005\u001d)\u0013!\u0005;fgRD\u0015M\u001c3mKV\u0003xM]1eK\"\u0012\u0001\"J\u0001\u0018i\u0016\u001cH\u000fS1oI2,W\u000b]4sC\u0012,GI]=Sk:D#!C\u0013\u0002'Q,7\u000f\u001e%b]\u0012dW\rR8x]\u001e\u0014\u0018\rZ3)\u0005))\u0013!\u0007;fgRD\u0015M\u001c3mK\u0012{wO\\4sC\u0012,GI]=Sk:D#aC\u0013\u0002#Q,7\u000f\u001e%b]\u0012dW\rR5tC\ndW\r\u000b\u0002\rK\u00059B/Z:u\u0011\u0006tG\r\\3ESN\f'\r\\3Eef\u0014VO\u001c\u0015\u0003\u001b\u0015\u0002")
public class FeatureCommandUnitTest {
    @Test
    public void testLevelToString() {
        Assertions.assertEquals((Object)"5", (Object)FeatureCommand$.MODULE$.levelToString("foo.bar", (short)5));
        Assertions.assertEquals((Object)"3.3-IV0", (Object)FeatureCommand$.MODULE$.levelToString("metadata.version", MetadataVersion.IBP_3_3_IV0.featureLevel()));
    }

    @Test
    public void testMetadataVersionsToString() {
        Assertions.assertEquals((Object)"3.3-IV0, 3.3-IV1, 3.3-IV2, 3.3-IV3", (Object)FeatureCommand$.MODULE$.metadataVersionsToString(MetadataVersion.IBP_3_3_IV0, MetadataVersion.IBP_3_3_IV3));
    }

    @Test
    public void testdowngradeType() {
        Assertions.assertEquals((Object)FeatureUpdate.UpgradeType.SAFE_DOWNGRADE, (Object)FeatureCommand$.MODULE$.downgradeType(new Namespace(Collections.singletonMap("unsafe", false))));
        Assertions.assertEquals((Object)FeatureUpdate.UpgradeType.UNSAFE_DOWNGRADE, (Object)FeatureCommand$.MODULE$.downgradeType(new Namespace(Collections.singletonMap("unsafe", true))));
        Assertions.assertEquals((Object)FeatureUpdate.UpgradeType.SAFE_DOWNGRADE, (Object)FeatureCommand$.MODULE$.downgradeType(new Namespace(Collections.emptyMap())));
    }

    @Test
    public void testParseNameAndLevel() {
        Assertions.assertEquals((Object)new Tuple2((Object)"foo.bar", (Object)BoxesRunTime.boxToShort((short)((short)5))), (Object)FeatureCommand$.MODULE$.parseNameAndLevel("foo.bar=5"));
        Assertions.assertEquals((Object)new Tuple2((Object)"quux", (Object)BoxesRunTime.boxToShort((short)((short)0))), (Object)FeatureCommand$.MODULE$.parseNameAndLevel(" quux=0"));
        Assertions.assertEquals((Object)"Can't parse feature=level string baaz: equals sign not found.", (Object)Assertions.assertThrows(TerseFailure.class, () -> FeatureCommand$.MODULE$.parseNameAndLevel("baaz")).getMessage());
        Assertions.assertEquals((Object)"Can't parse feature=level string w=tf: unable to parse tf as a short.", (Object)Assertions.assertThrows(TerseFailure.class, () -> FeatureCommand$.MODULE$.parseNameAndLevel("w=tf")).getMessage());
    }

    public MockAdminClient buildAdminClient1() {
        return new MockAdminClient.Builder().minSupportedFeatureLevels(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.version"), (Object)MetadataVersion.IBP_3_3_IV0.featureLevel()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo.bar"), (Object)((short)0))}))).asJava()).featureLevels(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.version"), (Object)MetadataVersion.IBP_3_3_IV2.featureLevel()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo.bar"), (Object)((short)5))}))).asJava()).maxSupportedFeatureLevels(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.version"), (Object)MetadataVersion.IBP_3_3_IV3.featureLevel()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo.bar"), (Object)((short)10))}))).asJava()).build();
    }

    @Test
    public void testHandleDescribe() {
        try (FeatureCommandTestEnv resource_resource = new FeatureCommandTestEnv(this.buildAdminClient1());){
            FeatureCommandUnitTest.$anonfun$testHandleDescribe$1(resource_resource);
        }
    }

    @Test
    public void testHandleUpgrade() {
        try (FeatureCommandTestEnv resource_resource = new FeatureCommandTestEnv(this.buildAdminClient1());){
            FeatureCommandUnitTest.$anonfun$testHandleUpgrade$1(resource_resource);
        }
    }

    @Test
    public void testHandleUpgradeDryRun() {
        try (FeatureCommandTestEnv resource_resource = new FeatureCommandTestEnv(this.buildAdminClient1());){
            FeatureCommandUnitTest.$anonfun$testHandleUpgradeDryRun$1(resource_resource);
        }
    }

    @Test
    public void testHandleDowngrade() {
        try (FeatureCommandTestEnv resource_resource = new FeatureCommandTestEnv(this.buildAdminClient1());){
            FeatureCommandUnitTest.$anonfun$testHandleDowngrade$1(resource_resource);
        }
    }

    @Test
    public void testHandleDowngradeDryRun() {
        try (FeatureCommandTestEnv resource_resource = new FeatureCommandTestEnv(this.buildAdminClient1());){
            FeatureCommandUnitTest.$anonfun$testHandleDowngradeDryRun$1(resource_resource);
        }
    }

    @Test
    public void testHandleDisable() {
        try (FeatureCommandTestEnv resource_resource = new FeatureCommandTestEnv(this.buildAdminClient1());){
            FeatureCommandUnitTest.$anonfun$testHandleDisable$1(resource_resource);
        }
    }

    @Test
    public void testHandleDisableDryRun() {
        try (FeatureCommandTestEnv resource_resource = new FeatureCommandTestEnv(this.buildAdminClient1());){
            FeatureCommandUnitTest.$anonfun$testHandleDisableDryRun$1(resource_resource);
        }
    }

    public static final /* synthetic */ void $anonfun$testHandleDescribe$1(FeatureCommandTestEnv env) {
        FeatureCommand$.MODULE$.handleDescribe(env.out(), (Admin)env.admin());
        Assertions.assertEquals((Object)String.format("Feature: foo.bar\tSupportedMinVersion: 0\tSupportedMaxVersion: 10\tFinalizedVersionLevel: 5\tEpoch: 123%nFeature: metadata.version\tSupportedMinVersion: 3.3-IV0\tSupportedMaxVersion: 3.3-IV3\tFinalizedVersionLevel: 3.3-IV2\tEpoch: 123%n", new Object[0]), (Object)env.stream().toString());
    }

    public static final /* synthetic */ void $anonfun$testHandleUpgrade$1(FeatureCommandTestEnv env) {
        Assertions.assertEquals((Object)"1 out of 2 operation(s) failed.", (Object)Assertions.assertThrows(TerseFailure.class, () -> {
            void handleUpgrade_admin;
            MockAdminClient mockAdminClient = env.admin();
            Namespace handleUpgrade_namespace = new Namespace(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata"), (Object)"3.3-IV1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature"), Arrays.asList("foo.bar=6"))}))).asJava());
            PrintStream handleUpgrade_out = env.out();
            FeatureCommand$.MODULE$.handleUpgradeOrDowngrade("upgrade", handleUpgrade_out, handleUpgrade_namespace, (Admin)handleUpgrade_admin, FeatureUpdate.UpgradeType.UPGRADE);
        }).getMessage());
        Assertions.assertEquals((Object)String.format("foo.bar was upgraded to 6.%nCould not upgrade metadata.version to 5. Can't upgrade to lower version.%n", new Object[0]), (Object)env.stream().toString());
    }

    public static final /* synthetic */ void $anonfun$testHandleUpgradeDryRun$1(FeatureCommandTestEnv env) {
        Assertions.assertEquals((Object)"1 out of 2 operation(s) failed.", (Object)Assertions.assertThrows(TerseFailure.class, () -> {
            void handleUpgrade_admin;
            MockAdminClient mockAdminClient = env.admin();
            Namespace handleUpgrade_namespace = new Namespace(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata"), (Object)"3.3-IV1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature"), Arrays.asList("foo.bar=6")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dry-run"), (Object)true)}))).asJava());
            PrintStream handleUpgrade_out = env.out();
            FeatureCommand$.MODULE$.handleUpgradeOrDowngrade("upgrade", handleUpgrade_out, handleUpgrade_namespace, (Admin)handleUpgrade_admin, FeatureUpdate.UpgradeType.UPGRADE);
        }).getMessage());
        Assertions.assertEquals((Object)String.format("foo.bar can be upgraded to 6.%nCan not upgrade metadata.version to 5. Can't upgrade to lower version.%n", new Object[0]), (Object)env.stream().toString());
    }

    public static final /* synthetic */ void $anonfun$testHandleDowngrade$1(FeatureCommandTestEnv env) {
        Assertions.assertEquals((Object)"1 out of 2 operation(s) failed.", (Object)Assertions.assertThrows(TerseFailure.class, () -> FeatureCommand$.MODULE$.handleDowngrade(env.out(), new Namespace(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata"), (Object)"3.3-IV3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature"), Arrays.asList("foo.bar=1"))}))).asJava()), (Admin)env.admin())).getMessage());
        Assertions.assertEquals((Object)String.format("foo.bar was downgraded to 1.%nCould not downgrade metadata.version to 7. Can't downgrade to newer version.%n", new Object[0]), (Object)env.stream().toString());
    }

    public static final /* synthetic */ void $anonfun$testHandleDowngradeDryRun$1(FeatureCommandTestEnv env) {
        Assertions.assertEquals((Object)"1 out of 2 operation(s) failed.", (Object)Assertions.assertThrows(TerseFailure.class, () -> FeatureCommand$.MODULE$.handleDowngrade(env.out(), new Namespace(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata"), (Object)"3.3-IV3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature"), Arrays.asList("foo.bar=1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dry-run"), (Object)true)}))).asJava()), (Admin)env.admin())).getMessage());
        Assertions.assertEquals((Object)String.format("foo.bar can be downgraded to 1.%nCan not downgrade metadata.version to 7. Can't downgrade to newer version.%n", new Object[0]), (Object)env.stream().toString());
    }

    public static final /* synthetic */ void $anonfun$testHandleDisable$1(FeatureCommandTestEnv env) {
        Assertions.assertEquals((Object)"1 out of 3 operation(s) failed.", (Object)Assertions.assertThrows(TerseFailure.class, () -> FeatureCommand$.MODULE$.handleDisable(env.out(), new Namespace(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature"), Arrays.asList("foo.bar", "metadata.version", "quux"))}))).asJava()), (Admin)env.admin())).getMessage());
        Assertions.assertEquals((Object)String.format("foo.bar was disabled.%nCould not disable metadata.version. Can't downgrade below 4%nquux was disabled.%n", new Object[0]), (Object)env.stream().toString());
    }

    public static final /* synthetic */ void $anonfun$testHandleDisableDryRun$1(FeatureCommandTestEnv env) {
        Assertions.assertEquals((Object)"1 out of 3 operation(s) failed.", (Object)Assertions.assertThrows(TerseFailure.class, () -> FeatureCommand$.MODULE$.handleDisable(env.out(), new Namespace(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature"), Arrays.asList("foo.bar", "metadata.version", "quux")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dry-run"), (Object)true)}))).asJava()), (Admin)env.admin())).getMessage());
        Assertions.assertEquals((Object)String.format("foo.bar can be disabled.%nCan not disable metadata.version. Can't downgrade below 4%nquux can be disabled.%n", new Object[0]), (Object)env.stream().toString());
    }

    public static final /* synthetic */ Object $anonfun$testHandleDescribe$1$adapted(FeatureCommandTestEnv env) {
        FeatureCommandUnitTest.$anonfun$testHandleDescribe$1(env);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testHandleUpgrade$1$adapted(FeatureCommandTestEnv env) {
        FeatureCommandUnitTest.$anonfun$testHandleUpgrade$1(env);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testHandleUpgradeDryRun$1$adapted(FeatureCommandTestEnv env) {
        FeatureCommandUnitTest.$anonfun$testHandleUpgradeDryRun$1(env);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testHandleDowngrade$1$adapted(FeatureCommandTestEnv env) {
        FeatureCommandUnitTest.$anonfun$testHandleDowngrade$1(env);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testHandleDowngradeDryRun$1$adapted(FeatureCommandTestEnv env) {
        FeatureCommandUnitTest.$anonfun$testHandleDowngradeDryRun$1(env);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testHandleDisable$1$adapted(FeatureCommandTestEnv env) {
        FeatureCommandUnitTest.$anonfun$testHandleDisable$1(env);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testHandleDisableDryRun$1$adapted(FeatureCommandTestEnv env) {
        FeatureCommandUnitTest.$anonfun$testHandleDisableDryRun$1(env);
        return BoxedUnit.UNIT;
    }
}

