/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import kafka.cluster.Partition;
import kafka.log.LogOffsetSnapshot;
import kafka.log.UnifiedLog$;
import kafka.server.DelayedFetch;
import kafka.server.FetchDataInfo;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.FetchParams;
import kafka.server.FetchPartitionData;
import kafka.server.FetchPartitionStatus;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.FetchRequest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005e4AAD\b\u0001)!)1\u0004\u0001C\u00019!9q\u0004\u0001b\u0001\n\u0013\u0001\u0003B\u0002\u0013\u0001A\u0003%\u0011\u0005C\u0004&\u0001\t\u0007I\u0011\u0002\u0014\t\r)\u0002\u0001\u0015!\u0003(\u0011\u001dY\u0003A1A\u0005\n1Ba\u0001\r\u0001!\u0002\u0013i\u0003\"B\u0019\u0001\t\u0003\u0011\u0004\"B\"\u0001\t\u0003\u0011\u0004\"B#\u0001\t\u0003\u0011\u0004\"B$\u0001\t\u0013A\u0005\"\u0002)\u0001\t\u0013\t\u0006\"B:\u0001\t\u0013!(\u0001\u0005#fY\u0006LX\r\u001a$fi\u000eDG+Z:u\u0015\t\u0001\u0012#\u0001\u0004tKJ4XM\u001d\u0006\u0002%\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0016!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011aD\u0001\t[\u0006D()\u001f;fgV\t\u0011\u0005\u0005\u0002\u0017E%\u00111e\u0006\u0002\u0004\u0013:$\u0018!C7bq\nKH/Z:!\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ,\u0012a\n\t\u0003=!J!!K\b\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006y!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b%\u0001\u0007sKBd\u0017nY1Rk>$\u0018-F\u0001.!\tqb&\u0003\u00020\u001f\ta!+\u001a9mS\u000e\f\u0017+^8uC\u0006i!/\u001a9mS\u000e\f\u0017+^8uC\u0002\n\u0001\u0004^3ti\u001a+Go\u00195XSRDg)\u001a8dK\u0012,\u0005o\\2i)\u0005\u0019\u0004C\u0001\f5\u0013\t)tC\u0001\u0003V]&$\bF\u0001\u00058!\tA\u0014)D\u0001:\u0015\tQ4(A\u0002ba&T!\u0001P\u001f\u0002\u000f),\b/\u001b;fe*\u0011ahP\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u0001\u0006\u0019qN]4\n\u0005\tK$\u0001\u0002+fgR\fq\u0003^3ti:{G\u000fT3bI\u0016\u0014xJ\u001d$pY2|w/\u001a:)\u0005%9\u0014A\u0005;fgR$\u0015N^3sO&tw-\u00129pG\"D#AC\u001c\u00021\t,\u0018\u000e\u001c3G_2dwn^3s\r\u0016$8\r\u001b)be\u0006l7\u000fF\u0002J\u0019:\u0003\"A\b&\n\u0005-{!a\u0003$fi\u000eD\u0007+\u0019:b[NDQ!T\u0006A\u0002\u0005\n\u0011B]3qY&\u001c\u0017-\u00133\t\u000b=[\u0001\u0019A\u0011\u0002\u00135\f\u0007pV1ji6\u001b\u0018!F3ya\u0016\u001cGOU3bI\u001a\u0013x.\u001c*fa2L7-\u0019\u000b\u0006gI#vl\u001b\u0005\u0006'2\u0001\r!S\u0001\fM\u0016$8\r\u001b)be\u0006l7\u000fC\u0003V\u0019\u0001\u0007a+\u0001\tu_BL7-\u00133QCJ$\u0018\u000e^5p]B\u0011q+X\u0007\u00021*\u0011\u0011LW\u0001\u0007G>lWn\u001c8\u000b\u0005IY&B\u0001/@\u0003\u0019\t\u0007/Y2iK&\u0011a\f\u0017\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:DQ\u0001\u0019\u0007A\u0002\u0005\f!CZ3uG\"\u0004\u0016M\u001d;ji&|g\u000eR1uCB\u0011!\r\u001b\b\u0003G\u001al\u0011\u0001\u001a\u0006\u0003Kb\u000b\u0001B]3rk\u0016\u001cHo]\u0005\u0003O\u0012\fABR3uG\"\u0014V-];fgRL!!\u001b6\u0003\u001bA\u000b'\u000f^5uS>tG)\u0019;b\u0015\t9G\rC\u0003m\u0019\u0001\u0007Q.A\u0003feJ|'\u000f\u0005\u0002oc6\tqN\u0003\u0002q1\u0006A\u0001O]8u_\u000e|G.\u0003\u0002s_\n1QI\u001d:peN\fqBY;jY\u0012\u0014V-\u00193SKN,H\u000e\u001e\u000b\u0003kb\u0004\"A\b<\n\u0005]|!!\u0004'pOJ+\u0017\r\u001a*fgVdG\u000fC\u0003m\u001b\u0001\u0007Q\u000e")
public class DelayedFetchTest {
    private final int maxBytes;
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private final ReplicaQuota replicaQuota = (ReplicaQuota)Mockito.mock(ReplicaQuota.class);

    private int maxBytes() {
        return this.maxBytes;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private ReplicaQuota replicaQuota() {
        return this.replicaQuota;
    }

    @Test
    public void testFetchWithFencedEpoch() {
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "topic");
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        int replicaId = 1;
        FetchPartitionStatus fetchStatus = new FetchPartitionStatus(new LogOffsetMetadata(fetchOffset, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), new FetchRequest.PartitionData(Uuid.ZERO_UUID, fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch));
        FetchParams fetchParams = this.buildFollowerFetchParams(replicaId, 500);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)fetchStatus), (List)Nil$.MODULE$), this.replicaManager(), this.replicaQuota(), (Function1 & Serializable)responses -> {
            DelayedFetchTest.callback$1(responses, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)this.replicaManager().getPartitionOrException(topicIdPartition.topicPartition())).thenReturn((Object)partition);
        Mockito.when((Object)partition.fetchOffsetSnapshot(currentLeaderEpoch, true)).thenThrow(new Throwable[]{new FencedLeaderEpochException("Requested epoch has been fenced")});
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica((TopicPartition)ArgumentMatchers.any(), ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.expectReadFromReplica(fetchParams, topicIdPartition, fetchStatus.fetchInfo(), Errors.FENCED_LEADER_EPOCH);
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedFetch.isCompleted());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
        FetchPartitionData fetchResult = (FetchPartitionData)((Option)fetchResultOpt.elem).get();
        Assertions.assertEquals((Object)Errors.FENCED_LEADER_EPOCH, (Object)fetchResult.error());
    }

    @Test
    public void testNotLeaderOrFollower() {
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "topic");
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        int replicaId = 1;
        FetchPartitionStatus fetchStatus = new FetchPartitionStatus(new LogOffsetMetadata(fetchOffset, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), new FetchRequest.PartitionData(Uuid.ZERO_UUID, fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch));
        FetchParams fetchParams = this.buildFollowerFetchParams(replicaId, 500);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)fetchStatus), (List)Nil$.MODULE$), this.replicaManager(), this.replicaQuota(), (Function1 & Serializable)responses -> {
            DelayedFetchTest.callback$2(responses, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        Mockito.when((Object)this.replicaManager().getPartitionOrException(topicIdPartition.topicPartition())).thenThrow(new Throwable[]{new NotLeaderOrFollowerException(new StringBuilder(26).append("Replica for ").append(topicIdPartition).append(" not available").toString())});
        this.expectReadFromReplica(fetchParams, topicIdPartition, fetchStatus.fetchInfo(), Errors.NOT_LEADER_OR_FOLLOWER);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica((TopicPartition)ArgumentMatchers.any(), ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedFetch.isCompleted());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
    }

    @Test
    public void testDivergingEpoch() {
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "topic");
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        Optional<Integer> lastFetchedEpoch = Optional.of(Predef$.MODULE$.int2Integer(9));
        int replicaId = 1;
        FetchPartitionStatus fetchStatus = new FetchPartitionStatus(new LogOffsetMetadata(fetchOffset, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), new FetchRequest.PartitionData(topicIdPartition.topicId(), fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch, lastFetchedEpoch));
        FetchParams fetchParams = this.buildFollowerFetchParams(replicaId, 500);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)fetchStatus), (List)Nil$.MODULE$), this.replicaManager(), this.replicaQuota(), (Function1 & Serializable)responses -> {
            DelayedFetchTest.callback$3(responses, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)this.replicaManager().getPartitionOrException(topicIdPartition.topicPartition())).thenReturn((Object)partition);
        LogOffsetMetadata endOffsetMetadata = new LogOffsetMetadata(500L, 0L, 500);
        Mockito.when((Object)partition.fetchOffsetSnapshot(currentLeaderEpoch, true)).thenReturn((Object)new LogOffsetSnapshot(0L, endOffsetMetadata, endOffsetMetadata, endOffsetMetadata));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(currentLeaderEpoch, Predef$.MODULE$.Integer2int(lastFetchedEpoch.get()), false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(topicIdPartition.partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(Predef$.MODULE$.Integer2int(lastFetchedEpoch.get())).setEndOffset(fetchOffset - 1L));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica((TopicPartition)ArgumentMatchers.any(), ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.expectReadFromReplica(fetchParams, topicIdPartition, fetchStatus.fetchInfo(), Errors.NONE);
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedFetch.isCompleted());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
    }

    private FetchParams buildFollowerFetchParams(int replicaId, int maxWaitMs) {
        return new FetchParams(ApiKeys.FETCH.latestVersion(), replicaId, (long)maxWaitMs, 1, this.maxBytes(), (FetchIsolation)FetchLogEnd$.MODULE$, (Option)None$.MODULE$);
    }

    private void expectReadFromReplica(FetchParams fetchParams, TopicIdPartition topicIdPartition, FetchRequest.PartitionData fetchPartitionData, Errors error) {
        Mockito.when((Object)this.replicaManager().readFromLocalLog(fetchParams, (Seq)new .colon.colon((Object)new Tuple2((Object)topicIdPartition, (Object)fetchPartitionData), (List)Nil$.MODULE$), this.replicaQuota(), true)).thenReturn((Object)new .colon.colon((Object)new Tuple2((Object)topicIdPartition, (Object)this.buildReadResult(error)), (List)Nil$.MODULE$));
    }

    private LogReadResult buildReadResult(Errors error) {
        None$ none$;
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        None$ x$1 = (errors == null ? errors2 != null : !errors.equals(errors2)) ? new Some((Object)error.exception()) : None$.MODULE$;
        FetchDataInfo x$2 = new FetchDataInfo(LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata(), (Records)MemoryRecords.EMPTY, false, (Option)None$.MODULE$);
        None$ x$3 = None$.MODULE$;
        None$ x$9 = None$.MODULE$;
        None$ none$2 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$10 = none$2;
        return new LogReadResult(x$2, (Option)x$3, -1L, -1L, -1L, -1L, -1L, (Option)x$9, (Option)x$10, (Option)x$1);
    }

    private static final void callback$1(Seq responses, ObjectRef fetchResultOpt$1) {
        fetchResultOpt$1.elem = new Some(((Tuple2)responses.head())._2());
    }

    private static final void callback$2(Seq responses, ObjectRef fetchResultOpt$2) {
        fetchResultOpt$2.elem = new Some(((Tuple2)responses.head())._2());
    }

    private static final void callback$3(Seq responses, ObjectRef fetchResultOpt$3) {
        fetchResultOpt$3.elem = new Some(((Tuple2)responses.head())._2());
    }

    public DelayedFetchTest() {
        this.maxBytes = 1024;
    }
}

