/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.log.ClientRecordDeletion$;
import kafka.log.LogAppendInfo;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.log.UnifiedLog;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.LazyZip2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.View;
import scala.collection.WithFilter;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;

@Timeout(value=300L)
@ScalaSignature(bytes="\u0006\u0005\t%c\u0001B\u000b\u0017\u0001mAQ\u0001\t\u0001\u0005\u0002\u0005BQa\t\u0001\u0005B\u0011BQa\u000b\u0001\u0005R1BQA\u000f\u0001\u0005\u0002mBQ!\u001c\u0001\u0005\u00029DQ\u0001\u001e\u0001\u0005\u0002UDQA\u001f\u0001\u0005\u0002mDq!!\u0001\u0001\t\u0003\t\u0019\u0001C\u0004\u0002\u000e\u0001!\t!a\u0004\t\u000f\u0005e\u0001\u0001\"\u0001\u0002\u001c!9\u0011Q\u0005\u0001\u0005\u0002\u0005\u001d\u0002bBA\u001c\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0003\u000b\u0002A\u0011AA$\u0011\u001d\t\t\u0006\u0001C\u0001\u0003'Bq!!\u0018\u0001\t\u0013\ty\u0006C\u0004\u0002h\u0001!I!!\u001b\t\u000f\u0005-\u0005\u0001\"\u0003\u0002\u000e\"9\u0011Q\u0014\u0001\u0005\n\u0005}\u0005bBAy\u0001\u0011%\u00111\u001f\u0005\b\u0005?\u0001A\u0011\u0002B\u0011\u00055aunZ(gMN,G\u000fV3ti*\u0011q\u0003G\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003e\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00019A\u0011QDH\u0007\u0002-%\u0011qD\u0006\u0002\u0010\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3ti\u00061A(\u001b8jiz\"\u0012A\t\t\u0003;\u0001\t1B\u0019:pW\u0016\u00148i\\;oiV\tQ\u0005\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsEA\u0002J]R\fqC\u0019:pW\u0016\u0014\bK]8qKJ$\u0018p\u0014<feJLG-Z:\u0015\u00055\u0002\u0004C\u0001\u0014/\u0013\tysE\u0001\u0003V]&$\b\"B\u0019\u0004\u0001\u0004\u0011\u0014!\u00029s_B\u001c\bCA\u001a9\u001b\u0005!$BA\u001b7\u0003\u0011)H/\u001b7\u000b\u0003]\nAA[1wC&\u0011\u0011\b\u000e\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!\b;fgR<U\r^(gMN,Go\u001d$peVs7N\\8x]R{\u0007/[2\u0015\u00055b\u0004\"B\u001f\u0005\u0001\u0004q\u0014AB9v_J,X\u000e\u0005\u0002@\r:\u0011\u0001\t\u0012\t\u0003\u0003\u001ej\u0011A\u0011\u0006\u0003\u0007j\ta\u0001\u0010:p_Rt\u0014BA#(\u0003\u0019\u0001&/\u001a3fM&\u0011q\t\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0015;\u0003\u0006\u0002\u0003K1f\u0003\"a\u0013,\u000e\u00031S!!\u0014(\u0002\u0011A\u0014xN^5eKJT!a\u0014)\u0002\rA\f'/Y7t\u0015\t\t&+A\u0004kkBLG/\u001a:\u000b\u0005M#\u0016!\u00026v]&$(\"A+\u0002\u0007=\u0014x-\u0003\u0002X\u0019\nYa+\u00197vKN{WO]2f\u0003\u001d\u0019HO]5oONd#A\u0017/\"\u0003m\u000b!A_6\"\u0003u\u000bQa\u001b:bMRD#\u0001B0\u0011\u0005\u0001\fW\"\u0001(\n\u0005\tt%!\u0005)be\u0006lW\r^3sSj,G\rV3ti\"2A\u0001Z4iU.\u0004\"AJ3\n\u0005\u0019<#A\u00033faJ,7-\u0019;fI\u00069Q.Z:tC\u001e,\u0017%A5\u0002+1K7\u000f^(gMN,Go\u001d*fcV,7\u000f\u001e\u0011Wa\u0005)1/\u001b8dK\u0006\nA.\u0001\u0001\u0002AQ,7\u000f^$fi>3gm]3ug\u00063G/\u001a:EK2,G/\u001a*fG>\u0014Hm\u001d\u000b\u0003[=DQ!P\u0003A\u0002yBC!\u0002&Yc2\u0012!\f\u0018\u0015\u0003\u000b}Cc!\u00023hQ*\\\u0017A\u000e;fgR4U\r^2i\u001f\u001a47/\u001a;CsRKW.Z:uC6\u0004hi\u001c:NCb$\u0016.\\3ti\u0006l\u0007/\u00114uKJ$&/\u001e8dCR,GCA\u0017w\u0011\u0015id\u00011\u0001?Q\u00111!\n\u0017=-\u0005ic\u0006F\u0001\u0004`\u0003\u0001#Xm\u001d;GKR\u001c\u0007n\u00144gg\u0016$()\u001f+j[\u0016\u001cH/Y7q\r>\u0014X*\u0019=US6,7\u000f^1na^KG\u000f[+o_J$WM]3e)&lWm\u001d;b[B\u001cHCA\u0017}\u0011\u0015it\u00011\u0001?Q\u00119!\n\u0017@-\u0005ic\u0006FA\u0004`\u0003y!Xm\u001d;HKR|eMZ:fiN\u0014UMZ8sK2\u000bG/Z:u)&lW\rF\u0002.\u0003\u000bAQ!\u0010\u0005A\u0002yBS\u0001\u0003&Y\u0003\u0013a#A\u0017/)\u0005!y\u0016a\u0006;fgR,U\u000e\u001d;z\u0019><7oR3u\u001f\u001a47/\u001a;t)\ri\u0013\u0011\u0003\u0005\u0006{%\u0001\rA\u0010\u0015\u0006\u0013)C\u0016Q\u0003\u0017\u00035rC#!C0\u0002kQ,7\u000f\u001e$fi\u000eDwJ\u001a4tKR\u0014\u0015\u0010V5nKN$\u0018-\u001c9G_Jl\u0015\r\u001f+j[\u0016\u001cH/Y7q/&$\b.R7qifdun\u001a\u000b\u0004[\u0005u\u0001\"B\u001f\u000b\u0001\u0004q\u0004&\u0002\u0006K1\u0006\u0005BF\u0001.]Q\tQq,A\fuKN$x)\u001a;PM\u001a\u001cX\r^:CK\u001a|'/\u001a(poR\u0019Q&!\u000b\t\u000buZ\u0001\u0019\u0001 )\u000b-Q\u0005,!\f-\u0005ic\u0006FA\u0006`Q\u001dYAmZA\u001aU.\f#!!\u000e\u000211,w-Y2z\r\u0016$8\r[(gMN,Go\u001d\"fM>\u0014X-\u0001\u0011uKN$x)\u001a;PM\u001a\u001cX\r^:CK\u001a|'/Z#be2LWm\u001d;US6,GcA\u0017\u0002<!)Q\b\u0004a\u0001}!*AB\u0013-\u0002@1\u0012!\f\u0018\u0015\u0003\u0019}Cs\u0001\u00043h\u0003gQ7.A\u0017uKN$h)\u001a;dQ>3gm]3ug\n+gm\u001c:f/&$\bn\u00115b]\u001eLgnZ*fO6,g\u000e^*ju\u0016$2!LA%\u0011\u0015iT\u00021\u0001?Q\u0015i!\nWA'Y\tQF\f\u000b\u0002\u000e?\u0006QC/Z:u\r\u0016$8\r[(gMN,Go\u001d\"fM>\u0014XmV5uQ\u000eC\u0017M\\4j]\u001e\u001cVmZ7f]R\u001cHcA\u0017\u0002V!)QH\u0004a\u0001}!*aB\u0013-\u0002Z1\u0012!\f\u0018\u0015\u0003\u001d}\u000baA\u0019:pW\u0016\u0014XCAA1!\ri\u00121M\u0005\u0004\u0003K2\"aC&bM.\f'I]8lKJ\fac]3oI2K7\u000f^(gMN,Go\u001d*fcV,7\u000f\u001e\u000b\u0005\u0003W\n\t\t\u0005\u0003\u0002n\u0005uTBAA8\u0015\u0011\t\t(a\u001d\u0002\u0011I,\u0017/^3tiNTA!!\u001e\u0002x\u000511m\\7n_:T1!GA=\u0015\r\tY\bV\u0001\u0007CB\f7\r[3\n\t\u0005}\u0014q\u000e\u0002\u0014\u0019&\u001cHo\u00144gg\u0016$8OU3ta>t7/\u001a\u0005\b\u0003\u0007\u0003\u0002\u0019AAC\u0003\u001d\u0011X-];fgR\u0004B!!\u001c\u0002\b&!\u0011\u0011RA8\u0005Ia\u0015n\u001d;PM\u001a\u001cX\r^:SKF,Xm\u001d;\u0002!M,g\u000e\u001a$fi\u000eD'+Z9vKN$H\u0003BAH\u0003+\u0003B!!\u001c\u0002\u0012&!\u00111SA8\u000551U\r^2i%\u0016\u001c\bo\u001c8tK\"9\u00111Q\tA\u0002\u0005]\u0005\u0003BA7\u00033KA!a'\u0002p\taa)\u001a;dQJ+\u0017/^3ti\u0006\u0001\"-^5mIR\u000b'oZ3u)&lWm\u001d\u000b\t\u0003C\u000b9.a9\u0002nB1\u00111UAW\u0003gsA!!*\u0002*:\u0019\u0011)a*\n\u0003!J1!a+(\u0003\u001d\u0001\u0018mY6bO\u0016LA!a,\u00022\n!A*[:u\u0015\r\tYk\n\t\u0005\u0003k\u000b\tN\u0004\u0003\u00028\u0006-g\u0002BA]\u0003\u0013tA!a/\u0002H:!\u0011QXAc\u001d\u0011\ty,a1\u000f\u0007\u0005\u000b\t-C\u0001V\u0013\r\tY\bV\u0005\u00043\u0005e\u0014\u0002BA;\u0003oJ1aZA:\u0013\u0011\ti-a4\u0002-1K7\u000f^(gMN,Go\u001d*fcV,7\u000f\u001e#bi\u0006T1aZA:\u0013\u0011\t\u0019.!6\u0003!1K7\u000f^(gMN,Go\u001d+pa&\u001c'\u0002BAg\u0003\u001fDq!!7\u0013\u0001\u0004\tY.\u0001\u0002uaB!\u0011Q\\Ap\u001b\t\t\u0019(\u0003\u0003\u0002b\u0006M$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003K\u0014\u0002\u0019AAt\u0003%!\u0018.\\3ti\u0006l\u0007\u000fE\u0002'\u0003SL1!a;(\u0005\u0011auN\\4\t\r\u0005=(\u00031\u0001&\u00035i\u0017\r\u001f(v[>3gm]3ug\u0006ia-\u001b8e!\u0006\u0014H/\u001b;j_:$b!!>\u0003\u0004\tu\u0001\u0003BA|\u0003{tA!a.\u0002z&!\u00111`Ah\u0003]a\u0015n\u001d;PM\u001a\u001cX\r^:SKN\u0004xN\\:f\t\u0006$\u0018-\u0003\u0003\u0002\u0000\n\u0005!\u0001\b'jgR|eMZ:fiN\u0004\u0016M\u001d;ji&|gNU3ta>t7/\u001a\u0006\u0005\u0003w\fy\rC\u0004\u0003\u0006M\u0001\rAa\u0002\u0002\rQ|\u0007/[2t!\u0019\u0011IAa\u0005\u0003\u00185\u0011!1\u0002\u0006\u0005\u0005\u001b\u0011y!A\u0004nkR\f'\r\\3\u000b\u0007\tEq%\u0001\u0006d_2dWm\u0019;j_:LAA!\u0006\u0003\f\t1!)\u001e4gKJ\u0004B!a>\u0003\u001a%!!1\u0004B\u0001\u0005aa\u0015n\u001d;PM\u001a\u001cX\r^:U_BL7MU3ta>t7/\u001a\u0005\b\u00033\u001c\u0002\u0019AAn\u0003Q\u0019'/Z1uKR{\u0007/[2B]\u0012<U\r\u001e'pOR1!1\u0005B\u0018\u0005g\u0001BA!\n\u0003,5\u0011!q\u0005\u0006\u0004\u0005SA\u0012a\u00017pO&!!Q\u0006B\u0014\u0005))f.\u001b4jK\u0012dun\u001a\u0005\u0007\u0005c!\u0002\u0019\u0001 \u0002\u000bQ|\u0007/[2\t\u000f\tUB\u00031\u0001\u0002\\\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007f\u0002\u0001\u0003:\t\u0015#q\t\t\u0005\u0005w\u0011\t%\u0004\u0002\u0003>)\u0019!q\b)\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0003D\tu\"a\u0002+j[\u0016|W\u000f^\u0001\u0006m\u0006dW/\u001a\u0010\u0003\u00031\u0002")
public class LogOffsetTest
extends BaseRequestTest {
    @Override
    public int brokerCount() {
        return 1;
    }

    @Override
    public void brokerPropertyOverrides(Properties props) {
        props.put("log.flush.interval.messages", "1");
        props.put("num.partitions", "20");
        props.put("log.retention.hours", "10");
        props.put("log.retention.check.interval.ms", Integer.toString(300000));
        props.put("log.segment.bytes", "140");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testGetOffsetsForUnknownTopic(String quorum) {
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        ListOffsetsRequest request = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -1L, 10)).asJava()).build((short)0);
        ListOffsetsResponse response = this.sendListOffsetsRequest(request);
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (short)this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(response.topics()).asScala(), topicPartition).errorCode());
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testGetOffsetsAfterDeleteRecords(String quorum) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)x$1 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush(false);
        log.updateHighWatermark(log.logEndOffset());
        log.maybeIncrementLogStartOffset(3L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        log.deleteOldSegments();
        Seq offsets = log.legacyFetchOffsetsBefore(-1L, 15);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 3L})), (Object)offsets);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.broker())) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Leader should be elected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -1L, 15)).asJava()).build();
        Buffer consumerOffsets = CollectionConverters$.MODULE$.ListHasAsScala(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 3L})), (Object)consumerOffsets);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchOffsetByTimestampForMaxTimestampAfterTruncate(String quorum) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)timestamp -> LogOffsetTest.$anonfun$testFetchOffsetByTimestampForMaxTimestampAfterTruncate$1(log, BoxesRunTime.unboxToInt((Object)timestamp)));
        log.flush(false);
        log.updateHighWatermark(log.logEndOffset());
        Option firstOffset = log.fetchOffsetByTimestamp(-3L);
        Assertions.assertEquals((long)19L, (long)((FileRecords.TimestampAndOffset)firstOffset.get()).offset);
        Assertions.assertEquals((long)19L, (long)((FileRecords.TimestampAndOffset)firstOffset.get()).timestamp);
        log.truncateTo(0L);
        Option secondOffset = log.fetchOffsetByTimestamp(-3L);
        Assertions.assertEquals((long)0L, (long)((FileRecords.TimestampAndOffset)secondOffset.get()).offset);
        Assertions.assertEquals((long)-1L, (long)((FileRecords.TimestampAndOffset)secondOffset.get()).timestamp);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchOffsetByTimestampForMaxTimestampWithUnorderedTimestamps(String quorum) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L, 1L, 2L, 3L, 4L, 6L, 5L}))).foreach((Function1 & Serializable)timestamp -> LogOffsetTest.$anonfun$testFetchOffsetByTimestampForMaxTimestampWithUnorderedTimestamps$1(log, BoxesRunTime.unboxToLong((Object)timestamp)));
        log.flush(false);
        log.updateHighWatermark(log.logEndOffset());
        Option maxTimestampOffset = log.fetchOffsetByTimestamp(-3L);
        Assertions.assertEquals((long)7L, (long)log.logEndOffset());
        Assertions.assertEquals((long)5L, (long)((FileRecords.TimestampAndOffset)maxTimestampOffset.get()).offset);
        Assertions.assertEquals((long)6L, (long)((FileRecords.TimestampAndOffset)maxTimestampOffset.get()).timestamp);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testGetOffsetsBeforeLatestTime(String quorum) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds((Seq<String>)((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"kafka-"}))))).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$2 -> x$2.swap())).asJava();
        Uuid topicId = (Uuid)topicIds.get(topic);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)x$3 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush(false);
        Seq offsets = log.legacyFetchOffsetsBefore(-1L, 15);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, 0, this.broker())) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Leader should be elected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -1L, 15)).asJava()).build();
        Buffer consumerOffsets = CollectionConverters$.MODULE$.ListHasAsScala(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((short)ApiKeys.FETCH.latestVersion(), (int)0, (int)1, (java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new FetchRequest.PartitionData(topicId, Predef$.MODULE$.Long2long((Long)consumerOffsets.head()), -1L, 307200, Optional.empty()))}))).asJava()).build();
        Assertions.assertFalse((boolean)FetchResponse.recordsOrFail((FetchResponseData.PartitionData)((FetchResponseData.PartitionData)this.sendFetchRequest(fetchRequest).responseData(topicNames, ApiKeys.FETCH.latestVersion()).get(topicPartition))).batches().iterator().hasNext());
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testEmptyLogsGetOffsets(String quorum) {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(10));
        String topicPartitionPath = new java.lang.StringBuilder(2).append(TestUtils.tempDirectory(null, null).getAbsolutePath()).append("/").append(topic).append("-").append(topicPartition.partition()).toString();
        new File(topicPartitionPath).mkdir();
        this.createTopic(topic, 1, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        BooleanRef offsetChanged = BooleanRef.create((boolean)false);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 14).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> {
            TopicPartition topicPartition = new TopicPartition(topic, 0);
            ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -2L, 1)).asJava()).build();
            if (BoxesRunTime.equals((Object)CollectionConverters$.MODULE$.ListHasAsScala(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala().head(), (Object)BoxesRunTime.boxToInteger((int)1))) {
                offsetChanged$1.elem = true;
                return;
            }
        });
        Assertions.assertFalse((boolean)offsetChanged.elem);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchOffsetByTimestampForMaxTimestampWithEmptyLog(String quorum) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        log.updateHighWatermark(log.logEndOffset());
        Option maxTimestampOffset = log.fetchOffsetByTimestamp(-3L);
        Assertions.assertEquals((long)0L, (long)log.logEndOffset());
        Assertions.assertEquals((long)0L, (long)((FileRecords.TimestampAndOffset)maxTimestampOffset.get()).offset);
        Assertions.assertEquals((long)-1L, (long)((FileRecords.TimestampAndOffset)maxTimestampOffset.get()).timestamp);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testGetOffsetsBeforeNow(String quorum) {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(3));
        this.createTopic(topic, 3, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        LogManager logManager = this.broker().logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = logManager.getOrCreateLog$default$2();
        boolean x$4 = logManager.getOrCreateLog$default$3();
        UnifiedLog log = logManager.getOrCreateLog(topicPartition, x$3, x$4, (Option)x$2);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)x$5 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush(false);
        long now = Time.SYSTEM.milliseconds() + 30000L;
        Seq offsets = log.legacyFetchOffsetsBefore(now, 15);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.broker())) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Leader should be elected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, now, 15)).asJava()).build();
        Buffer consumerOffsets = CollectionConverters$.MODULE$.ListHasAsScala(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testGetOffsetsBeforeEarliestTime(String quorum) {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(3));
        this.createTopic(topic, 3, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        LogManager logManager = this.broker().logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = logManager.getOrCreateLog$default$2();
        boolean x$4 = logManager.getOrCreateLog$default$3();
        UnifiedLog log = logManager.getOrCreateLog(topicPartition, x$3, x$4, (Option)x$2);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)x$6 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush(false);
        Seq offsets = log.legacyFetchOffsetsBefore(-2L, 10);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L})), (Object)offsets);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.broker())) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Leader should be elected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -2L, 10)).asJava()).build();
        Buffer consumerOffsets = CollectionConverters$.MODULE$.ListHasAsScala(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L})), (Object)consumerOffsets);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchOffsetsBeforeWithChangingSegmentSize(String quorum) {
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        LogSegment logSegment = (LogSegment)Mockito.mock(LogSegment.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)logSegment.size())).thenAnswer((Answer)new Answer<Object>(null){
            private final AtomicInteger value;

            public int answer(InvocationOnMock invocation) {
                return this.value.getAndIncrement();
            }
            {
                this.value = new AtomicInteger(0);
            }
        });
        scala.collection.immutable.Seq logSegments = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogSegment[]{logSegment}));
        Mockito.when((Object)log.logSegments()).thenReturn((Object)logSegments);
        log.legacyFetchOffsetsBefore(System.currentTimeMillis(), 100);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchOffsetsBeforeWithChangingSegments(String quorum) {
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        LogSegment logSegment = (LogSegment)Mockito.mock(LogSegment.class);
        Mockito.when((Object)log.logSegments()).thenReturn((Object)new Iterable<LogSegment>(null, logSegment){
            private final LogSegment logSegment$1;

            public final Iterable<LogSegment> toIterable() {
                return Iterable.toIterable$((Iterable)this);
            }

            public final Iterable<LogSegment> coll() {
                return Iterable.coll$((Iterable)this);
            }

            public IterableFactory<Iterable> iterableFactory() {
                return Iterable.iterableFactory$((Iterable)this);
            }

            public Iterable<LogSegment> seq() {
                return Iterable.seq$((Iterable)this);
            }

            public String className() {
                return Iterable.className$((Iterable)this);
            }

            public final String collectionClassName() {
                return Iterable.collectionClassName$((Iterable)this);
            }

            public String stringPrefix() {
                return Iterable.stringPrefix$((Iterable)this);
            }

            public String toString() {
                return Iterable.toString$((Iterable)this);
            }

            public <B> LazyZip2<LogSegment, B, Iterable> lazyZip(Iterable<B> that) {
                return Iterable.lazyZip$((Iterable)this, that);
            }

            public IterableOps fromSpecific(IterableOnce coll) {
                return IterableFactoryDefaults.fromSpecific$((IterableFactoryDefaults)this, (IterableOnce)coll);
            }

            public Builder<LogSegment, Iterable<LogSegment>> newSpecificBuilder() {
                return IterableFactoryDefaults.newSpecificBuilder$((IterableFactoryDefaults)this);
            }

            public IterableOps empty() {
                return IterableFactoryDefaults.empty$((IterableFactoryDefaults)this);
            }

            public final Iterable<LogSegment> toTraversable() {
                return IterableOps.toTraversable$((IterableOps)this);
            }

            public boolean isTraversableAgain() {
                return IterableOps.isTraversableAgain$((IterableOps)this);
            }

            public final Object repr() {
                return IterableOps.repr$((IterableOps)this);
            }

            public IterableFactory<Iterable> companion() {
                return IterableOps.companion$((IterableOps)this);
            }

            public Object head() {
                return IterableOps.head$((IterableOps)this);
            }

            public Option<LogSegment> headOption() {
                return IterableOps.headOption$((IterableOps)this);
            }

            public Object last() {
                return IterableOps.last$((IterableOps)this);
            }

            public Option<LogSegment> lastOption() {
                return IterableOps.lastOption$((IterableOps)this);
            }

            public View<LogSegment> view() {
                return IterableOps.view$((IterableOps)this);
            }

            public int sizeCompare(int otherSize) {
                return IterableOps.sizeCompare$((IterableOps)this, (int)otherSize);
            }

            public final IterableOps sizeIs() {
                return IterableOps.sizeIs$((IterableOps)this);
            }

            public int sizeCompare(Iterable<?> that) {
                return IterableOps.sizeCompare$((IterableOps)this, that);
            }

            public View<LogSegment> view(int from, int until) {
                return IterableOps.view$((IterableOps)this, (int)from, (int)until);
            }

            public Object transpose(Function1 asIterable) {
                return IterableOps.transpose$((IterableOps)this, (Function1)asIterable);
            }

            public Object filter(Function1 pred) {
                return IterableOps.filter$((IterableOps)this, (Function1)pred);
            }

            public Object filterNot(Function1 pred) {
                return IterableOps.filterNot$((IterableOps)this, (Function1)pred);
            }

            public WithFilter<LogSegment, Iterable> withFilter(Function1<LogSegment, Object> p) {
                return IterableOps.withFilter$((IterableOps)this, p);
            }

            public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> partition(Function1<LogSegment, Object> p) {
                return IterableOps.partition$((IterableOps)this, p);
            }

            public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> splitAt(int n) {
                return IterableOps.splitAt$((IterableOps)this, (int)n);
            }

            public Object take(int n) {
                return IterableOps.take$((IterableOps)this, (int)n);
            }

            public Object takeRight(int n) {
                return IterableOps.takeRight$((IterableOps)this, (int)n);
            }

            public Object takeWhile(Function1 p) {
                return IterableOps.takeWhile$((IterableOps)this, (Function1)p);
            }

            public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> span(Function1<LogSegment, Object> p) {
                return IterableOps.span$((IterableOps)this, p);
            }

            public Object drop(int n) {
                return IterableOps.drop$((IterableOps)this, (int)n);
            }

            public Object dropRight(int n) {
                return IterableOps.dropRight$((IterableOps)this, (int)n);
            }

            public Object dropWhile(Function1 p) {
                return IterableOps.dropWhile$((IterableOps)this, (Function1)p);
            }

            public Iterator<Iterable<LogSegment>> grouped(int size) {
                return IterableOps.grouped$((IterableOps)this, (int)size);
            }

            public Iterator<Iterable<LogSegment>> sliding(int size) {
                return IterableOps.sliding$((IterableOps)this, (int)size);
            }

            public Iterator<Iterable<LogSegment>> sliding(int size, int step) {
                return IterableOps.sliding$((IterableOps)this, (int)size, (int)step);
            }

            public Object tail() {
                return IterableOps.tail$((IterableOps)this);
            }

            public Object init() {
                return IterableOps.init$((IterableOps)this);
            }

            public Object slice(int from, int until) {
                return IterableOps.slice$((IterableOps)this, (int)from, (int)until);
            }

            public <K> scala.collection.immutable.Map<K, Iterable<LogSegment>> groupBy(Function1<LogSegment, K> f) {
                return IterableOps.groupBy$((IterableOps)this, f);
            }

            public <K, B> scala.collection.immutable.Map<K, Iterable<B>> groupMap(Function1<LogSegment, K> key, Function1<LogSegment, B> f) {
                return IterableOps.groupMap$((IterableOps)this, key, f);
            }

            public <K, B> scala.collection.immutable.Map<K, B> groupMapReduce(Function1<LogSegment, K> key, Function1<LogSegment, B> f, Function2<B, B, B> reduce) {
                return IterableOps.groupMapReduce$((IterableOps)this, key, f, reduce);
            }

            public Object scan(Object z, Function2 op) {
                return IterableOps.scan$((IterableOps)this, (Object)z, (Function2)op);
            }

            public Object scanLeft(Object z, Function2 op) {
                return IterableOps.scanLeft$((IterableOps)this, (Object)z, (Function2)op);
            }

            public Object scanRight(Object z, Function2 op) {
                return IterableOps.scanRight$((IterableOps)this, (Object)z, (Function2)op);
            }

            public Object map(Function1 f) {
                return IterableOps.map$((IterableOps)this, (Function1)f);
            }

            public Object flatMap(Function1 f) {
                return IterableOps.flatMap$((IterableOps)this, (Function1)f);
            }

            public Object flatten(Function1 asIterable) {
                return IterableOps.flatten$((IterableOps)this, (Function1)asIterable);
            }

            public Object collect(PartialFunction pf) {
                return IterableOps.collect$((IterableOps)this, (PartialFunction)pf);
            }

            public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> partitionMap(Function1<LogSegment, Either<A1, A2>> f) {
                return IterableOps.partitionMap$((IterableOps)this, f);
            }

            public Object concat(IterableOnce suffix) {
                return IterableOps.concat$((IterableOps)this, (IterableOnce)suffix);
            }

            public final Object $plus$plus(IterableOnce suffix) {
                return IterableOps.$plus$plus$((IterableOps)this, (IterableOnce)suffix);
            }

            public Object zip(IterableOnce that) {
                return IterableOps.zip$((IterableOps)this, (IterableOnce)that);
            }

            public Object zipWithIndex() {
                return IterableOps.zipWithIndex$((IterableOps)this);
            }

            public Object zipAll(Iterable that, Object thisElem, Object thatElem) {
                return IterableOps.zipAll$((IterableOps)this, (Iterable)that, (Object)thisElem, (Object)thatElem);
            }

            public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Function1<LogSegment, Tuple2<A1, A2>> asPair) {
                return IterableOps.unzip$((IterableOps)this, asPair);
            }

            public <A1, A2, A3> Tuple3<Iterable<A1>, Iterable<A2>, Iterable<A3>> unzip3(Function1<LogSegment, Tuple3<A1, A2, A3>> asTriple) {
                return IterableOps.unzip3$((IterableOps)this, asTriple);
            }

            public Iterator<Iterable<LogSegment>> tails() {
                return IterableOps.tails$((IterableOps)this);
            }

            public Iterator<Iterable<LogSegment>> inits() {
                return IterableOps.inits$((IterableOps)this);
            }

            public Object tapEach(Function1 f) {
                return IterableOps.tapEach$((IterableOps)this, (Function1)f);
            }

            public Object $plus$plus$colon(IterableOnce that) {
                return IterableOps.$plus$plus$colon$((IterableOps)this, (IterableOnce)that);
            }

            public boolean hasDefiniteSize() {
                return IterableOnceOps.hasDefiniteSize$((IterableOnceOps)this);
            }

            public <U> void foreach(Function1<LogSegment, U> f) {
                IterableOnceOps.foreach$((IterableOnceOps)this, f);
            }

            public boolean forall(Function1<LogSegment, Object> p) {
                return IterableOnceOps.forall$((IterableOnceOps)this, p);
            }

            public boolean exists(Function1<LogSegment, Object> p) {
                return IterableOnceOps.exists$((IterableOnceOps)this, p);
            }

            public int count(Function1<LogSegment, Object> p) {
                return IterableOnceOps.count$((IterableOnceOps)this, p);
            }

            public Option<LogSegment> find(Function1<LogSegment, Object> p) {
                return IterableOnceOps.find$((IterableOnceOps)this, p);
            }

            public <B> B foldLeft(B z, Function2<B, LogSegment, B> op) {
                return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
            }

            public <B> B foldRight(B z, Function2<LogSegment, B, B> op) {
                return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
            }

            public final <B> B $div$colon(B z, Function2<B, LogSegment, B> op) {
                return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
            }

            public final <B> B $colon$bslash(B z, Function2<LogSegment, B, B> op) {
                return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
            }

            public <B> B reduce(Function2<B, B, B> op) {
                return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
            }

            public <B> B reduceLeft(Function2<B, LogSegment, B> op) {
                return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
            }

            public <B> B reduceRight(Function2<LogSegment, B, B> op) {
                return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, LogSegment, B> op) {
                return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<LogSegment, B, B> op) {
                return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
            }

            public boolean isEmpty() {
                return IterableOnceOps.isEmpty$((IterableOnceOps)this);
            }

            public boolean nonEmpty() {
                return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
            }

            public final <B> void copyToBuffer(Buffer<B> dest) {
                IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
            }

            public <B> int copyToArray(Object xs) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
            }

            public <B> int copyToArray(Object xs, int start) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
            }

            public <B> int copyToArray(Object xs, int start, int len) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
            }

            public Object min(Ordering ord) {
                return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<LogSegment> minOption(Ordering<B> ord) {
                return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
            }

            public Object max(Ordering ord) {
                return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<LogSegment> maxOption(Ordering<B> ord) {
                return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
            }

            public <B> Option<LogSegment> maxByOption(Function1<LogSegment, B> f, Ordering<B> cmp) {
                return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
            }

            public <B> Option<LogSegment> minByOption(Function1<LogSegment, B> f, Ordering<B> cmp) {
                return IterableOnceOps.minByOption$((IterableOnceOps)this, f, cmp);
            }

            public <B> Option<B> collectFirst(PartialFunction<LogSegment, B> pf) {
                return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, LogSegment, B> seqop, Function2<B, B, B> combop) {
                return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
            }

            public <B> boolean corresponds(IterableOnce<B> that, Function2<LogSegment, B, Object> p) {
                return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
            }

            public final String mkString(String start, String sep, String end) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
            }

            public final String mkString(String sep) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
            }

            public final String mkString() {
                return IterableOnceOps.mkString$((IterableOnceOps)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public final StringBuilder addString(StringBuilder b, String sep) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
            }

            public final StringBuilder addString(StringBuilder b) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
            }

            public <C1> C1 to(Factory<LogSegment, C1> factory) {
                return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
            }

            public final Iterator<LogSegment> toIterator() {
                return IterableOnceOps.toIterator$((IterableOnceOps)this);
            }

            public List<LogSegment> toList() {
                return IterableOnceOps.toList$((IterableOnceOps)this);
            }

            public Vector<LogSegment> toVector() {
                return IterableOnceOps.toVector$((IterableOnceOps)this);
            }

            public <K, V> scala.collection.immutable.Map<K, V> toMap(.less.colon.less<LogSegment, Tuple2<K, V>> ev) {
                return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
            }

            public <B> Set<B> toSet() {
                return IterableOnceOps.toSet$((IterableOnceOps)this);
            }

            public scala.collection.immutable.Seq<LogSegment> toSeq() {
                return IterableOnceOps.toSeq$((IterableOnceOps)this);
            }

            public IndexedSeq<LogSegment> toIndexedSeq() {
                return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
            }

            public final Stream<LogSegment> toStream() {
                return IterableOnceOps.toStream$((IterableOnceOps)this);
            }

            public final <B> Buffer<B> toBuffer() {
                return IterableOnceOps.toBuffer$((IterableOnceOps)this);
            }

            public <B> Object toArray(ClassTag<B> evidence$2) {
                return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
            }

            public Iterable<LogSegment> reversed() {
                return IterableOnceOps.reversed$((IterableOnceOps)this);
            }

            public <S extends Stepper<?>> S stepper(StepperShape<LogSegment, S> shape) {
                return (S)IterableOnce.stepper$((IterableOnce)this, shape);
            }

            public int knownSize() {
                return IterableOnce.knownSize$((IterableOnce)this);
            }

            public int size() {
                return 2;
            }

            public Iterator<LogSegment> iterator() {
                return package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogSegment[]{this.logSegment$1})).iterator();
            }
            {
                this.logSegment$1 = logSegment$1;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                IterableOps.$init$((IterableOps)this);
                IterableFactoryDefaults.$init$((IterableFactoryDefaults)this);
                Iterable.$init$((Iterable)this);
            }
        });
        log.legacyFetchOffsetsBefore(System.currentTimeMillis(), 100);
    }

    private KafkaBroker broker() {
        return (KafkaBroker)this.brokers().head();
    }

    private ListOffsetsResponse sendListOffsetsRequest(ListOffsetsRequest request) {
        return (ListOffsetsResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ListOffsetsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private FetchResponse sendFetchRequest(FetchRequest request) {
        return (FetchResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private List<ListOffsetsRequestData.ListOffsetsTopic> buildTargetTimes(TopicPartition tp, long timestamp, int maxNumOffsets) {
        return (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ListOffsetsRequestData.ListOffsetsTopic[]{new ListOffsetsRequestData.ListOffsetsTopic().setName(tp.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ListOffsetsRequestData.ListOffsetsPartition[]{new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(tp.partition()).setTimestamp(timestamp).setMaxNumOffsets(maxNumOffsets)}))).asJava())}));
    }

    private ListOffsetsResponseData.ListOffsetsPartitionResponse findPartition(Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse> topics, TopicPartition tp) {
        return (ListOffsetsResponseData.ListOffsetsPartitionResponse)CollectionConverters$.MODULE$.ListHasAsScala(((ListOffsetsResponseData.ListOffsetsTopicResponse)topics.find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)LogOffsetTest.$anonfun$findPartition$1(tp, x$7))).get()).partitions()).asScala().find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)LogOffsetTest.$anonfun$findPartition$2(tp, x$8))).get();
    }

    private UnifiedLog createTopicAndGetLog(String topic, TopicPartition topicPartition) {
        this.createTopic(topic, 1, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        LogManager logManager = this.broker().logManager();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogOffsetTest.$anonfun$createTopicAndGetLog$1(logManager, topicPartition)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Log for partition [topic,0] should be created");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        return (UnifiedLog)logManager.getLog(topicPartition, logManager.getLog$default$2()).get();
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsAfterDeleteRecords$3() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testFetchOffsetByTimestampForMaxTimestampAfterTruncate$1(UnifiedLog log$2, int timestamp) {
        CompressionType compressionType;
        byte[] x$1 = Integer.toString(42).getBytes();
        long x$2 = timestamp;
        CompressionType compressionType2 = compressionType = CompressionType.NONE;
        compressionType = null;
        CompressionType x$4 = compressionType2;
        byte by = 2;
        return log$2.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, null, x$4, x$2, by), 0, log$2.appendAsLeader$default$3(), log$2.appendAsLeader$default$4(), log$2.appendAsLeader$default$5());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testFetchOffsetByTimestampForMaxTimestampWithUnorderedTimestamps$1(UnifiedLog log$3, long timestamp) {
        CompressionType compressionType;
        byte[] x$1 = Integer.toString(42).getBytes();
        CompressionType compressionType2 = compressionType = CompressionType.NONE;
        compressionType = null;
        CompressionType x$4 = compressionType2;
        byte by = 2;
        return log$3.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, null, x$4, timestamp, by), 0, log$3.appendAsLeader$default$3(), log$3.appendAsLeader$default$4(), log$3.appendAsLeader$default$5());
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeLatestTime$4() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeNow$3() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeEarliestTime$3() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ boolean $anonfun$findPartition$1(TopicPartition tp$1, ListOffsetsResponseData.ListOffsetsTopicResponse x$7) {
        String string = x$7.name();
        String string2 = tp$1.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findPartition$2(TopicPartition tp$1, ListOffsetsResponseData.ListOffsetsPartitionResponse x$8) {
        return x$8.partitionIndex() == tp$1.partition();
    }

    public static final /* synthetic */ boolean $anonfun$createTopicAndGetLog$1(LogManager logManager$1, TopicPartition topicPartition$4) {
        return logManager$1.getLog(topicPartition$4, logManager$1.getLog$default$2()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$createTopicAndGetLog$2() {
        return "Log for partition [topic,0] should be created";
    }
}

