/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Properties;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.tools.GetOffsetShell$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\rh\u0001B\u0012%\u0001%BQA\u000e\u0001\u0005\u0002]BqA\u000f\u0001C\u0002\u0013%1\b\u0003\u0004C\u0001\u0001\u0006I\u0001\u0010\u0005\b\u0007\u0002\u0011\r\u0011\"\u0003<\u0011\u0019!\u0005\u0001)A\u0005y!)Q\t\u0001C!\r\")1\u000b\u0001C!)\")!\u000e\u0001C\u0001W\")\u0001\u000f\u0001C\u0001W\")!\u000f\u0001C\u0001W\")A\u000f\u0001C\u0001W\")a\u000f\u0001C\u0001W\")\u0001\u0010\u0001C\u0001W\")!\u0010\u0001C\u0001W\")A\u0010\u0001C\u0001{\"9\u0011q\b\u0001\u0005\u0002\u0005\u0005\u0003bBA*\u0001\u0011\u0005\u0011Q\u000b\u0005\u0007\u0003O\u0002A\u0011A6\t\r\u0005-\u0004\u0001\"\u0001l\u0011\u0019\ty\u0007\u0001C\u0001W\"1\u00111\u000f\u0001\u0005\u0002-Da!a\u001e\u0001\t\u0003Y\u0007BBA>\u0001\u0011\u00051\u000e\u0003\u0004\u0002\u0000\u0001!\ta\u001b\u0005\u0007\u0003\u0007\u0003A\u0011A6\t\r\u0005\u001d\u0005\u0001\"\u0001l\u0011\u001d\tY\t\u0001C\u0005\u0003\u001bCq!a-\u0001\t\u0013\ti\tC\u0004\u00026\u0002!I!a.\t\u000f\u0005u\u0006\u0001\"\u0003\u0002@\"9\u00111\u0019\u0001\u0005\n\u0005\u0015\u0007bBAi\u0001\u0011%\u00111\u001b\u0005\b\u0003/\u0004A\u0011BAm\u0011\u001d\ti\u000e\u0001C\u0005\u0003?\u0014!cR3u\u001f\u001a47/\u001a;TQ\u0016dG\u000eV3ti*\u0011QEJ\u0001\u0006i>|Gn\u001d\u0006\u0002O\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001+aA\u00111FL\u0007\u0002Y)\u0011QFJ\u0001\fS:$Xm\u001a:bi&|g.\u0003\u00020Y\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u00022i5\t!G\u0003\u00024M\u0005)Q\u000f^5mg&\u0011QG\r\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t\u0001\b\u0005\u0002:\u00015\tA%\u0001\u0006u_BL7mQ8v]R,\u0012\u0001\u0010\t\u0003{\u0001k\u0011A\u0010\u0006\u0002\u007f\u0005)1oY1mC&\u0011\u0011I\u0010\u0002\u0004\u0013:$\u0018a\u0003;pa&\u001c7i\\;oi\u0002\n\u0011d\u001c4gg\u0016$Hk\u001c9jGB\u000b'\u000f^5uS>t7i\\;oi\u0006QrN\u001a4tKR$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8uA\u0005yq-\u001a8fe\u0006$XmQ8oM&<7/F\u0001H!\rA5*T\u0007\u0002\u0013*\u0011!JP\u0001\u000bG>dG.Z2uS>t\u0017B\u0001'J\u0005\r\u0019V-\u001d\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!\u001a\naa]3sm\u0016\u0014\u0018B\u0001*P\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u000bM,G/\u00169\u0015\u0005UC\u0006CA\u001fW\u0013\t9fH\u0001\u0003V]&$\b\"B-\b\u0001\u0004Q\u0016\u0001\u0003;fgRLeNZ8\u0011\u0005m#W\"\u0001/\u000b\u0005us\u0016aA1qS*\u0011q\fY\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\t'-A\u0003kk:LGOC\u0001d\u0003\ry'oZ\u0005\u0003Kr\u0013\u0001\u0002V3ti&sgm\u001c\u0015\u0003\u000f\u001d\u0004\"a\u00175\n\u0005%d&A\u0003\"fM>\u0014X-R1dQ\u0006\u0019B/Z:u\u001d>4\u0015\u000e\u001c;fe>\u0003H/[8ogR\tQ\u000b\u000b\u0002\t[B\u00111L\\\u0005\u0003_r\u0013A\u0001V3ti\u0006!B/Z:u\u0013:$XM\u001d8bY\u0016C8\r\\;eK\u0012D#!C7\u0002!Q,7\u000f\u001e+pa&\u001cg*Y7f\u0003J<\u0007F\u0001\u0006n\u0003M!Xm\u001d;U_BL7\rU1ui\u0016\u0014h.\u0011:hQ\tYQ.A\tuKN$\b+\u0019:uSRLwN\\:Be\u001eD#\u0001D7\u0002IQ,7\u000f\u001e+pa&\u001c\u0007+\u0019;uKJt\u0017I]4XSRD\u0007+\u0019:uSRLwN\\:Be\u001eD#!D7\u0002-Q,7\u000f\u001e+pa&\u001c\u0007+\u0019:uSRLwN\\:Be\u001eD#AD7\u0002)Q,7\u000f^$fi2\u000bG/Z:u\u001f\u001a47/\u001a;t)\t)f\u0010\u0003\u0004\u0000\u001f\u0001\u0007\u0011\u0011A\u0001\u0005i&lW\r\u0005\u0003\u0002\u0004\u0005Ea\u0002BA\u0003\u0003\u001b\u00012!a\u0002?\u001b\t\tIAC\u0002\u0002\f!\na\u0001\u0010:p_Rt\u0014bAA\b}\u00051\u0001K]3eK\u001aLA!a\u0005\u0002\u0016\t11\u000b\u001e:j]\u001eT1!a\u0004?Q\u001dy\u0011\u0011DA\u0015\u0003W\u0001B!a\u0007\u0002&5\u0011\u0011Q\u0004\u0006\u0005\u0003?\t\t#\u0001\u0005qe>4\u0018\u000eZ3s\u0015\r\t\u0019CX\u0001\u0007a\u0006\u0014\u0018-\\:\n\t\u0005\u001d\u0012Q\u0004\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\t\u00055\u0012\u0011G\u0011\u0003\u0003_\t!!L\u0019\"\u0005\u0005M\u0012A\u00027bi\u0016\u001cH\u000fK\u0002\u0010\u0003o\u0001B!!\u000f\u0002<5\u0011\u0011\u0011E\u0005\u0005\u0003{\t\tCA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fa\u0003^3ti\u001e+G/R1sY&,7\u000f^(gMN,Go\u001d\u000b\u0004+\u0006\r\u0003BB@\u0011\u0001\u0004\t\t\u0001K\u0004\u0011\u00033\tI#a\u0012-\t\u0005%\u0013QJ\u0011\u0003\u0003\u0017\n!!\f\u001a\"\u0005\u0005=\u0013\u0001C3be2LWm\u001d;)\u0007A\t9$\u0001\u000fuKN$x)\u001a;PM\u001a\u001cX\r^:Cs6\u000b\u0007\u0010V5nKN$\u0018-\u001c9\u0015\u0007U\u000b9\u0006\u0003\u0004\u0000#\u0001\u0007\u0011\u0011\u0001\u0015\b#\u0005e\u0011\u0011FA.Y\u0011\ti&!\u0019\"\u0005\u0005}\u0013AA\u00174C\t\t\u0019'A\u0007nCblC/[7fgR\fW\u000e\u001d\u0015\u0004#\u0005]\u0012!\u0007;fgR<U\r^(gMN,Go\u001d\"z)&lWm\u001d;b[BD#AE7\u0002]Q,7\u000f\u001e(p\u001f\u001a47/\u001a;JMRKW.Z:uC6\u0004xI]3bi\u0016\u0014H\u000b[1o\u0019\u0006$Xm\u001d;SK\u000e|'\u000f\u001a\u0015\u0003'5\f!\u0006^3tiR{\u0007/[2QCJ$\u0018\u000e^5p]N\f%oZ,ji\"Le\u000e^3s]\u0006dW\t_2mk\u0012,G\r\u000b\u0002\u0015[\u0006QC/Z:u)>\u0004\u0018n\u0019)beRLG/[8og\u0006\u0013xmV5uQ&sG/\u001a:oC2Len\u00197vI\u0016$\u0007FA\u000bn\u00039\"Xm\u001d;U_BL7\rU1si&$\u0018n\u001c8t\u001d>$hi\\;oI\u001a{'OT8o\u000bbL7\u000f^3oiR{\u0007/[2)\u0005Yi\u0017a\r;fgR$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001chj\u001c;G_VtGMR8s\u000bb\u001cG.\u001e3fI&sG/\u001a:oC2$v\u000e]5dQ\t9R.\u0001 uKN$Hk\u001c9jGB\u000b'\u000f^5uS>t7OT8u\r>,h\u000e\u001a$pe:{g.T1uG\"Lgn\u001a+pa&\u001c\u0007+\u0019:uSRLwN\u001c)biR,'O\u001c\u0015\u000315\fQ\u0006^3tiR{\u0007/[2QCJ$\u0018\u000e^5p]N4E.Y4XSRDGk\u001c9jG\u001ac\u0017mZ\"bkN,W\t_5uQ\tIR.\u0001\u001auKN$Hk\u001c9jGB\u000b'\u000f^5uS>t7O\u00127bO^KG\u000f\u001b)beRLG/[8og\u001ac\u0017mZ\"bkN,W\t_5uQ\tQR.A\u000efqB,7\r^3e\u001f\u001a47/\u001a;t/&$\b.\u00138uKJt\u0017\r\u001c\u000b\u0003\u0003\u001f\u0003b!!%\u0002\u001c\u0006\u0005f\u0002BAJ\u0003/sA!a\u0002\u0002\u0016&\tq(C\u0002\u0002\u001az\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u001e\u0006}%\u0001\u0002'jgRT1!!'?!!i\u00141UA\u0001y\u0005\u001d\u0016bAAS}\t1A+\u001e9mKN\u0002R!PAU\u0003[K1!a+?\u0005\u0019y\u0005\u000f^5p]B\u0019Q(a,\n\u0007\u0005EfH\u0001\u0003M_:<\u0017\u0001G3ya\u0016\u001cG/\u001a3UKN$Hk\u001c9jG>3gm]3ug\u00069R\r\u001f9fGR,Gm\u00144gg\u0016$8OR8s)>\u0004\u0018n\u0019\u000b\u0005\u0003\u001f\u000bI\f\u0003\u0004\u0002<v\u0001\r\u0001P\u0001\u0002S\u0006IAo\u001c9jG:\u000bW.\u001a\u000b\u0005\u0003\u0003\t\t\r\u0003\u0004\u0002<z\u0001\r\u0001P\u0001\u0014CN\u001cXM\u001d;Fq&$8i\u001c3f\u0013N|e.\u001a\u000b\u0004+\u0006\u001d\u0007bBAe?\u0001\u0007\u00111Z\u0001\u0005CJ<7\u000fE\u0003>\u0003\u001b\f\t!C\u0002\u0002Pz\u0012Q!\u0011:sCf\fq\"\u001a=fGV$X-\u00118e!\u0006\u00148/\u001a\u000b\u0005\u0003\u001f\u000b)\u000eC\u0004\u0002J\u0002\u0002\r!a3\u0002)\u0015DXmY;uK\u0006sGm\u0012:bE>+H\u000f];u)\u0011\t\t!a7\t\u000f\u0005%\u0017\u00051\u0001\u0002L\u0006\u0011\u0012\r\u001a3C_>$8\u000f\u001e:baN+'O^3s)\u0011\tY-!9\t\u000f\u0005%'\u00051\u0001\u0002L\u0002")
public class GetOffsetShellTest
extends KafkaServerTestHarness {
    private final int topicCount;
    private final int offsetTopicPartitionCount;

    private int topicCount() {
        return this.topicCount;
    }

    private int offsetTopicPartitionCount() {
        return this.offsetTopicPartitionCount;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)((IterableOps)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0).map((Function1 & Serializable)p -> {
            p.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), BoxesRunTime.boxToInteger((int)this.offsetTopicPartitionCount()));
            return p;
        })).map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props));
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        package$.MODULE$.Range().apply(1, this.topicCount() + 1).foreach((Function1 & Serializable)i -> this.createTopic(this.topicName(BoxesRunTime.unboxToInt((Object)i)), BoxesRunTime.unboxToInt((Object)i), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6()));
        Properties props = new Properties();
        props.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        props.put("key.serializer", StringSerializer.class);
        props.put("value.serializer", StringSerializer.class);
        KafkaProducer producer = new KafkaProducer(props);
        package$.MODULE$.Range().apply(1, this.topicCount() + 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> package$.MODULE$.Range().apply(0, i * i).foreach((Function1 & Serializable)msgCount -> producer.send(new ProducerRecord(this.topicName(i), Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)msgCount) % i), null, (Object)new StringBuilder(3).append("val").append(BoxesRunTime.unboxToInt((Object)msgCount)).toString()))));
        producer.close();
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
    }

    @Test
    public void testNoFilterOptions() {
        List<Tuple3<String, Object, Option<Object>>> offsets = this.executeAndParse((String[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
        Assertions.assertEquals(this.expectedOffsetsWithInternal(), offsets);
    }

    @Test
    public void testInternalExcluded() {
        List<Tuple3<String, Object, Option<Object>>> offsets = this.executeAndParse(new String[]{"--exclude-internal-topics"});
        Assertions.assertEquals(this.expectedTestTopicOffsets(), offsets);
    }

    @Test
    public void testTopicNameArg() {
        package$.MODULE$.Range().apply(1, this.topicCount() + 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            List<Tuple3<String, Object, Option<Object>>> offsets = this.executeAndParse(new String[]{"--topic", this.topicName(i)});
            Assertions.assertEquals(this.expectedOffsetsForTopic(i), offsets, () -> new StringBuilder(32).append("Offset output did not match for ").append(this.topicName(i)).toString());
        });
    }

    @Test
    public void testTopicPatternArg() {
        List<Tuple3<String, Object, Option<Object>>> offsets = this.executeAndParse(new String[]{"--topic", "topic.*"});
        Assertions.assertEquals(this.expectedTestTopicOffsets(), offsets);
    }

    @Test
    public void testPartitionsArg() {
        List<Tuple3<String, Object, Option<Object>>> offsets = this.executeAndParse(new String[]{"--partitions", "0,1"});
        Assertions.assertEquals((Object)this.expectedOffsetsWithInternal().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)GetOffsetShellTest.$anonfun$testPartitionsArg$1(x0$1))), offsets);
    }

    @Test
    public void testTopicPatternArgWithPartitionsArg() {
        List<Tuple3<String, Object, Option<Object>>> offsets = this.executeAndParse(new String[]{"--topic", "topic.*", "--partitions", "0,1"});
        Assertions.assertEquals((Object)this.expectedTestTopicOffsets().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)GetOffsetShellTest.$anonfun$testTopicPatternArgWithPartitionsArg$1(x0$1))), offsets);
    }

    @Test
    public void testTopicPartitionsArg() {
        List<Tuple3<String, Object, Option<Object>>> offsets = this.executeAndParse(new String[]{"--topic-partitions", "topic1:0,topic2:1,topic(3|4):2,__.*:3"});
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"__consumer_offsets", (Object)BoxesRunTime.boxToInteger((int)3), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)0))), new Tuple3((Object)"topic1", (Object)BoxesRunTime.boxToInteger((int)0), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)1))), new Tuple3((Object)"topic2", (Object)BoxesRunTime.boxToInteger((int)1), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)2))), new Tuple3((Object)"topic3", (Object)BoxesRunTime.boxToInteger((int)2), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)3))), new Tuple3((Object)"topic4", (Object)BoxesRunTime.boxToInteger((int)2), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)4)))})), offsets);
    }

    @ParameterizedTest
    @ValueSource(strings={"-1", "latest"})
    public void testGetLatestOffsets(String time) {
        List<Tuple3<String, Object, Option<Object>>> offsets = this.executeAndParse(new String[]{"--topic-partitions", "topic.*:0", "--time", time});
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"topic1", (Object)BoxesRunTime.boxToInteger((int)0), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)1))), new Tuple3((Object)"topic2", (Object)BoxesRunTime.boxToInteger((int)0), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)2))), new Tuple3((Object)"topic3", (Object)BoxesRunTime.boxToInteger((int)0), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)3))), new Tuple3((Object)"topic4", (Object)BoxesRunTime.boxToInteger((int)0), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)4)))})), offsets);
    }

    @ParameterizedTest
    @ValueSource(strings={"-2", "earliest"})
    public void testGetEarliestOffsets(String time) {
        List<Tuple3<String, Object, Option<Object>>> offsets = this.executeAndParse(new String[]{"--topic-partitions", "topic.*:0", "--time", time});
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"topic1", (Object)BoxesRunTime.boxToInteger((int)0), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)0))), new Tuple3((Object)"topic2", (Object)BoxesRunTime.boxToInteger((int)0), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)0))), new Tuple3((Object)"topic3", (Object)BoxesRunTime.boxToInteger((int)0), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)0))), new Tuple3((Object)"topic4", (Object)BoxesRunTime.boxToInteger((int)0), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)))})), offsets);
    }

    @ParameterizedTest
    @ValueSource(strings={"-3", "max-timestamp"})
    public void testGetOffsetsByMaxTimestamp(String time) {
        this.executeAndParse(new String[]{"--topic-partitions", "topic.*", "--time", time}).foreach((Function1 & Serializable)x0$1 -> {
            GetOffsetShellTest.$anonfun$testGetOffsetsByMaxTimestamp$1(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetOffsetsByTimestamp() {
        String time = Long.toString(System.currentTimeMillis() / 2L);
        List<Tuple3<String, Object, Option<Object>>> offsets = this.executeAndParse(new String[]{"--topic-partitions", "topic.*:0", "--time", time});
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"topic1", (Object)BoxesRunTime.boxToInteger((int)0), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)0))), new Tuple3((Object)"topic2", (Object)BoxesRunTime.boxToInteger((int)0), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)0))), new Tuple3((Object)"topic3", (Object)BoxesRunTime.boxToInteger((int)0), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)0))), new Tuple3((Object)"topic4", (Object)BoxesRunTime.boxToInteger((int)0), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)))})), offsets);
    }

    @Test
    public void testNoOffsetIfTimestampGreaterThanLatestRecord() {
        String time = Long.toString(System.currentTimeMillis() * 2L);
        List<Tuple3<String, Object, Option<Object>>> offsets = this.executeAndParse(new String[]{"--topic-partitions", "topic.*", "--time", time});
        Assertions.assertEquals((Object)package$.MODULE$.List().empty(), offsets);
    }

    @Test
    public void testTopicPartitionsArgWithInternalExcluded() {
        List<Tuple3<String, Object, Option<Object>>> offsets = this.executeAndParse(new String[]{"--topic-partitions", "topic1:0,topic2:1,topic(3|4):2,__.*:3", "--exclude-internal-topics"});
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"topic1", (Object)BoxesRunTime.boxToInteger((int)0), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)1))), new Tuple3((Object)"topic2", (Object)BoxesRunTime.boxToInteger((int)1), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)2))), new Tuple3((Object)"topic3", (Object)BoxesRunTime.boxToInteger((int)2), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)3))), new Tuple3((Object)"topic4", (Object)BoxesRunTime.boxToInteger((int)2), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)4)))})), offsets);
    }

    @Test
    public void testTopicPartitionsArgWithInternalIncluded() {
        List<Tuple3<String, Object, Option<Object>>> offsets = this.executeAndParse(new String[]{"--topic-partitions", "__.*:0"});
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"__consumer_offsets", (Object)BoxesRunTime.boxToInteger((int)0), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)))})), offsets);
    }

    @Test
    public void testTopicPartitionsNotFoundForNonExistentTopic() {
        this.assertExitCodeIsOne(new String[]{"--topic", "some_nonexistent_topic"});
    }

    @Test
    public void testTopicPartitionsNotFoundForExcludedInternalTopic() {
        this.assertExitCodeIsOne(new String[]{"--topic", "some_nonexistent_topic:*"});
    }

    @Test
    public void testTopicPartitionsNotFoundForNonMatchingTopicPartitionPattern() {
        this.assertExitCodeIsOne(new String[]{"--topic-partitions", "__consumer_offsets", "--exclude-internal-topics"});
    }

    @Test
    public void testTopicPartitionsFlagWithTopicFlagCauseExit() {
        this.assertExitCodeIsOne(new String[]{"--topic-partitions", "__consumer_offsets", "--topic", "topic1"});
    }

    @Test
    public void testTopicPartitionsFlagWithPartitionsFlagCauseExit() {
        this.assertExitCodeIsOne(new String[]{"--topic-partitions", "__consumer_offsets", "--partitions", "0"});
    }

    private List<Tuple3<String, Object, Option<Object>>> expectedOffsetsWithInternal() {
        return (List)package$.MODULE$.Range().apply(0, this.offsetTopicPartitionCount()).map((Function1 & Serializable)i -> GetOffsetShellTest.$anonfun$expectedOffsetsWithInternal$1(BoxesRunTime.unboxToInt((Object)i))).toList().$plus$plus(this.expectedTestTopicOffsets());
    }

    private List<Tuple3<String, Object, Option<Object>>> expectedTestTopicOffsets() {
        return ((IterableOnceOps)package$.MODULE$.Range().apply(1, this.topicCount() + 1).flatMap((Function1 & Serializable)i -> this.expectedOffsetsForTopic(BoxesRunTime.unboxToInt((Object)i)))).toList();
    }

    private List<Tuple3<String, Object, Option<Object>>> expectedOffsetsForTopic(int i) {
        String name = this.topicName(i);
        return package$.MODULE$.Range().apply(0, i).map((Function1 & Serializable)p -> GetOffsetShellTest.$anonfun$expectedOffsetsForTopic$1(name, i, BoxesRunTime.unboxToInt((Object)p))).toList();
    }

    private String topicName(int i) {
        return new StringBuilder(5).append("topic").append(i).toString();
    }

    private void assertExitCodeIsOne(String[] args) {
        ObjectRef exitStatus = ObjectRef.create((Object)None$.MODULE$);
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(status, x$1) -> GetOffsetShellTest.$anonfun$assertExitCodeIsOne$1(exitStatus, BoxesRunTime.unboxToInt((Object)status), x$1);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var4_3 = null;
        try {
            try {
                GetOffsetShell$.MODULE$.main(this.addBootstrapServer(args));
            }
            catch (RuntimeException runtimeException) {}
        }
        finally {
            Exit.resetExitProcedure();
        }
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)((Option)exitStatus.elem));
    }

    private List<Tuple3<String, Object, Option<Object>>> executeAndParse(String[] args) {
        String output = this.executeAndGrabOutput(args);
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])output.split(System.lineSeparator())), (Function1 & Serializable)x$2 -> x$2.split(":"), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)GetOffsetShellTest.$anonfun$executeAndParse$2(x$3)))), (Function1 & Serializable)line -> {
            String topic = line[0];
            int partition = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(line[1]));
            None$ timestamp = ((String[])line).length == 2 || line[2].isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(line[2]))));
            return new Tuple3((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partition), (Object)timestamp);
        }, ClassTag$.MODULE$.apply(Tuple3.class))).toList();
    }

    private String executeAndGrabOutput(String[] args) {
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> GetOffsetShell$.MODULE$.main(this.addBootstrapServer(args));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        return grabConsoleOutput_out.toString();
    }

    private String[] addBootstrapServer(String[] args) {
        return (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])args), (Object)new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1())}, ClassTag$.MODULE$.apply(String.class));
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionsArg$1(Tuple3 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = BoxesRunTime.unboxToInt((Object)x0$1._2()) <= 1;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicPatternArgWithPartitionsArg$1(Tuple3 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = BoxesRunTime.unboxToInt((Object)x0$1._2()) <= 1;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testGetOffsetsByMaxTimestamp$1(Tuple3 x0$1) {
        if (x0$1 != null) {
            String topic = (String)x0$1._1();
            Option timestampOpt = (Option)x0$1._3();
            Assertions.assertTrue((BoxesRunTime.unboxToLong((Object)timestampOpt.get()) >= 0L && BoxesRunTime.unboxToLong((Object)timestampOpt.get()) <= (long)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(topic.replace("topic", ""))) ? 1 : 0) != 0);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ Tuple3 $anonfun$expectedOffsetsWithInternal$1(int i) {
        return new Tuple3((Object)"__consumer_offsets", (Object)BoxesRunTime.boxToInteger((int)i), (Object)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
    }

    public static final /* synthetic */ Tuple3 $anonfun$expectedOffsetsForTopic$1(String name$1, int i$3, int p) {
        return new Tuple3((Object)name$1, (Object)BoxesRunTime.boxToInteger((int)p), (Object)new Some((Object)BoxesRunTime.boxToLong((long)i$3)));
    }

    public static final /* synthetic */ Nothing$ $anonfun$assertExitCodeIsOne$1(ObjectRef exitStatus$1, int status, Option x$1) {
        exitStatus$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)status));
        throw new RuntimeException();
    }

    public static final /* synthetic */ boolean $anonfun$executeAndParse$2(String[] x$3) {
        return x$3.length >= 2;
    }

    public GetOffsetShellTest() {
        this.topicCount = 4;
        this.offsetTopicPartitionCount = 4;
    }
}

