/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Optional;
import kafka.log.AppendOrigin$RaftLeader$;
import kafka.log.LogAppendInfo;
import kafka.log.LogOffsetSnapshot;
import kafka.log.SnapshotGenerated$;
import kafka.log.UnifiedLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.MetadataLogConfig;
import kafka.raft.SegmentPosition;
import kafka.server.FetchDataInfo;
import kafka.server.FetchHighWatermark$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.LogOffsetMetadata;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.SnapshotHeaderRecord;
import org.apache.kafka.common.record.ControlRecordUtils;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.CloseableIterator;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.Isolation;
import org.apache.kafka.raft.LogFetchInfo;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.OffsetMetadata;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.raft.ValidOffsetAndEpoch;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.snapshot.FileRawSnapshotReader;
import org.apache.kafka.snapshot.FileRawSnapshotWriter;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.Snapshots;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.MapOps;
import scala.collection.mutable.TreeMap;
import scala.collection.mutable.TreeMap$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tef\u0001\u0002\u001a4\u0005aB\u0001\"\u0015\u0001\u0003\u0006\u0004%\tA\u0015\u0005\t1\u0002\u0011\t\u0011)A\u0005'\"A\u0011\f\u0001B\u0001B\u0003%!\f\u0003\u0005b\u0001\t\u0005\t\u0015!\u0003c\u0011!)\u0007A!A!\u0002\u00131\u0007\u0002C?\u0001\u0005\u0003\u0005\u000b\u0011\u0002@\t\u0015\u0005\u0015\u0001A!A!\u0002\u0013\t9\u0001C\u0004\u0002\u0010\u0001!I!!\u0005\t\u000f\u0005\u0005\u0002\u0001\"\u0011\u0002$!9\u0011q\b\u0001\u0005B\u0005\u0005\u0003bBA2\u0001\u0011\u0005\u0013Q\r\u0005\b\u0003S\u0002A\u0011BA6\u0011\u001d\t)\b\u0001C!\u0003oBq!!\u001f\u0001\t\u0003\nY\bC\u0004\u0002\u0000\u0001!\t%!!\t\u000f\u00055\u0002\u0001\"\u0011\u0002\n\"9\u00111\u0012\u0001\u0005B\u00055\u0005bBAM\u0001\u0011\u0005\u00131\u0014\u0005\b\u0003G\u0003A\u0011IAS\u0011\u001d\tI\u000b\u0001C!\u0003WCq!!-\u0001\t\u0003\n\t\tC\u0004\u00024\u0002!\t%!.\t\u000f\u0005m\u0006\u0001\"\u0011\u0002\n\"1Q\u0010\u0001C!\u0003{Cq!a0\u0001\t\u0003\n\t\rC\u0004\u0002J\u0002!\t%a3\t\u000f\u0005\r\b\u0001\"\u0011\u0002f\"9\u0011\u0011\u001e\u0001\u0005B\u0005-\bbBA|\u0001\u0011\u0005\u0013\u0011 \u0005\b\u0003w\u0004A\u0011IA\u007f\u0011\u001d\u0011\t\u0001\u0001C!\u0003{DqAa\u0001\u0001\t\u0003\u0012)\u0001C\u0004\u0003\n\u0001!\tEa\u0003\t\u000f\t=\u0001\u0001\"\u0003\u0003\u0012!9!\u0011\u0007\u0001\u0005\n\tM\u0002b\u0002B\u001d\u0001\u0011\u0005\u00131\u0014\u0005\b\u0005w\u0001A\u0011\u0002B\u001f\u0011\u001d\u0011I\u0005\u0001C\u0005\u00037CqAa\u0013\u0001\t\u0013\tY\nC\u0004\u0003N\u0001!IAa\u0014\t\u000f\tU\u0003\u0001\"\u0003\u0003X!9!Q\f\u0001\u0005B\t}\u0003\u0002\u0003B1\u0001\u0011\u00051'a\u001e\b\u000f\t\r4\u0007#\u0001\u0003f\u00191!g\rE\u0001\u0005OBq!a\u0004.\t\u0003\u0011y\u0007C\u0004\u0003r5\"\tAa\u001d\t\u000f\t=U\u0006\"\u0003\u0003\u0012\"9!QS\u0017\u0005\n\t]%\u0001E&bM.\fW*\u001a;bI\u0006$\u0018\rT8h\u0015\t!T'\u0001\u0003sC\u001a$(\"\u0001\u001c\u0002\u000b-\fgm[1\u0004\u0001M!\u0001!O!L!\tQt(D\u0001<\u0015\taT(\u0001\u0003mC:<'\"\u0001 \u0002\t)\fg/Y\u0005\u0003\u0001n\u0012aa\u00142kK\u000e$\bC\u0001\"J\u001b\u0005\u0019%B\u0001\u001bE\u0015\t1TI\u0003\u0002G\u000f\u00061\u0011\r]1dQ\u0016T\u0011\u0001S\u0001\u0004_J<\u0017B\u0001&D\u00055\u0011V\r\u001d7jG\u0006$X\r\u001a'pOB\u0011AjT\u0007\u0002\u001b*\u0011a*N\u0001\u0006kRLGn]\u0005\u0003!6\u0013q\u0001T8hO&tw-A\u0002m_\u001e,\u0012a\u0015\t\u0003)Zk\u0011!\u0016\u0006\u0003#VJ!aV+\u0003\u0015Us\u0017NZ5fI2{w-\u0001\u0003m_\u001e\u0004\u0013\u0001\u0002;j[\u0016\u0004\"aW0\u000e\u0003qS!AT/\u000b\u0005y#\u0015AB2p[6|g.\u0003\u0002a9\n!A+[7f\u0003%\u00198\r[3ek2,'\u000f\u0005\u0002MG&\u0011A-\u0014\u0002\n'\u000eDW\rZ;mKJ\f\u0011b\u001d8baNDw\u000e^:\u0011\t\u001dt\u0007o]\u0007\u0002Q*\u0011\u0011N[\u0001\b[V$\u0018M\u00197f\u0015\tYG.\u0001\u0006d_2dWm\u0019;j_:T\u0011!\\\u0001\u0006g\u000e\fG.Y\u0005\u0003_\"\u0014q\u0001\u0016:fK6\u000b\u0007\u000f\u0005\u0002Cc&\u0011!o\u0011\u0002\u000f\u001f\u001a47/\u001a;B]\u0012,\u0005o\\2i!\r!Xo^\u0007\u0002Y&\u0011a\u000f\u001c\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005a\\X\"A=\u000b\u0005i$\u0015\u0001C:oCB\u001c\bn\u001c;\n\u0005qL(!\u0006$jY\u0016\u0014\u0016m^*oCB\u001c\bn\u001c;SK\u0006$WM]\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\ry\u0018\u0011A\u0007\u0002;&\u0019\u00111A/\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u000611m\u001c8gS\u001e\u0004B!!\u0003\u0002\f5\t1'C\u0002\u0002\u000eM\u0012\u0011#T3uC\u0012\fG/\u0019'pO\u000e{gNZ5h\u0003\u0019a\u0014N\\5u}Qq\u00111CA\u000b\u0003/\tI\"a\u0007\u0002\u001e\u0005}\u0001cAA\u0005\u0001!)\u0011\u000b\u0003a\u0001'\")\u0011\f\u0003a\u00015\")\u0011\r\u0003a\u0001E\")Q\r\u0003a\u0001M\")Q\u0010\u0003a\u0001}\"9\u0011Q\u0001\u0005A\u0002\u0005\u001d\u0011\u0001\u0002:fC\u0012$b!!\n\u0002,\u0005U\u0002c\u0001\"\u0002(%\u0019\u0011\u0011F\"\u0003\u00191{wMR3uG\"LeNZ8\t\u000f\u00055\u0012\u00021\u0001\u00020\u0005Y1\u000f^1si>3gm]3u!\r!\u0018\u0011G\u0005\u0004\u0003ga'\u0001\u0002'p]\u001eDq!a\u000e\n\u0001\u0004\tI$A\u0007sK\u0006$\u0017j]8mCRLwN\u001c\t\u0004\u0005\u0006m\u0012bAA\u001f\u0007\nI\u0011j]8mCRLwN\\\u0001\u000fCB\u0004XM\u001c3Bg2+\u0017\rZ3s)\u0019\t\u0019%!\u0013\u0002ZA\u0019!)!\u0012\n\u0007\u0005\u001d3IA\u0007M_\u001e\f\u0005\u000f]3oI&sgm\u001c\u0005\b\u0003\u0017R\u0001\u0019AA'\u0003\u001d\u0011XmY8sIN\u0004B!a\u0014\u0002V5\u0011\u0011\u0011\u000b\u0006\u0004\u0003'j\u0016A\u0002:fG>\u0014H-\u0003\u0003\u0002X\u0005E#a\u0002*fG>\u0014Hm\u001d\u0005\b\u00037R\u0001\u0019AA/\u0003\u0015)\u0007o\\2i!\r!\u0018qL\u0005\u0004\u0003Cb'aA%oi\u0006\u0001\u0012\r\u001d9f]\u0012\f5OR8mY><XM\u001d\u000b\u0005\u0003\u0007\n9\u0007C\u0004\u0002L-\u0001\r!!\u0014\u0002;!\fg\u000e\u001a7f\u0003:$7i\u001c8wKJ$Hj\\4BaB,g\u000eZ%oM>$B!a\u0011\u0002n!9\u0011q\u000e\u0007A\u0002\u0005E\u0014AC1qa\u0016tG-\u00138g_B\u0019A+a\u001d\n\u0007\u0005\u001dS+\u0001\tmCN$h)\u001a;dQ\u0016$W\t]8dQR\u0011\u0011QL\u0001\u0012K:$wJ\u001a4tKR4uN]#q_\u000eDGc\u00019\u0002~!9\u00111\f\bA\u0002\u0005u\u0013!C3oI>3gm]3u)\t\t\u0019\tE\u0002C\u0003\u000bK1!a\"D\u0005EaunZ(gMN,G/T3uC\u0012\fG/\u0019\u000b\u0003\u0003_\t!\u0002\u001e:v]\u000e\fG/\u001a+p)\u0011\ty)!&\u0011\u0007Q\f\t*C\u0002\u0002\u00142\u0014A!\u00168ji\"9\u0011qS\tA\u0002\u0005=\u0012AB8gMN,G/\u0001\rueVt7-\u0019;f)>d\u0015\r^3tiNs\u0017\r]:i_R$\"!!(\u0011\u0007Q\fy*C\u0002\u0002\"2\u0014qAQ8pY\u0016\fg.A\u000bj]&$\u0018.\u00197ju\u0016dU-\u00193fe\u0016\u0003xn\u00195\u0015\t\u0005=\u0015q\u0015\u0005\b\u00037\u001a\u0002\u0019AA/\u0003M)\b\u000fZ1uK\"Kw\r[,bi\u0016\u0014X.\u0019:l)\u0011\ty)!,\t\u000f\u0005=F\u00031\u0001\u0002\u0004\u0006qqN\u001a4tKRlU\r^1eCR\f\u0017!\u00045jO\"<\u0016\r^3s[\u0006\u00148.A\u0003gYV\u001c\b\u000e\u0006\u0003\u0002\u0010\u0006]\u0006bBA]-\u0001\u0007\u0011QT\u0001\u0018M>\u00148-\u001a$mkND\u0017i\u0019;jm\u0016\u001cVmZ7f]R\f\u0011\u0003\\1ti\u001acWo\u001d5fI>3gm]3u)\u0005q\u0018a\u0002;pa&\u001c\u0017\n\u001a\u000b\u0003\u0003\u0007\u00042a`Ac\u0013\r\t9-\u0018\u0002\u0005+VLG-A\tde\u0016\fG/\u001a(foNs\u0017\r]:i_R$B!!4\u0002`B1\u0011qZAk\u00033l!!!5\u000b\u0007\u0005MW(\u0001\u0003vi&d\u0017\u0002BAl\u0003#\u0014\u0001b\u00149uS>t\u0017\r\u001c\t\u0004q\u0006m\u0017bAAos\n\t\"+Y<T]\u0006\u00048\u000f[8u/JLG/\u001a:\t\r\u0005\u0005(\u00041\u0001q\u0003)\u0019h.\u00199tQ>$\u0018\nZ\u0001\u000egR|'/Z*oCB\u001c\bn\u001c;\u0015\t\u00055\u0017q\u001d\u0005\u0007\u0003C\\\u0002\u0019\u00019\u0002\u0019I,\u0017\rZ*oCB\u001c\bn\u001c;\u0015\t\u00055\u0018Q\u001f\t\u0007\u0003\u001f\f).a<\u0011\u0007a\f\t0C\u0002\u0002tf\u0014\u0011CU1x':\f\u0007o\u001d5piJ+\u0017\rZ3s\u0011\u0019\t\t\u000f\ba\u0001a\u0006qA.\u0019;fgR\u001cf.\u00199tQ>$HCAAw\u0003Aa\u0017\r^3tiNs\u0017\r]:i_RLE\r\u0006\u0002\u0002\u0000B)\u0011qZAka\u0006\u0011R-\u0019:mS\u0016\u001cHo\u00158baNDw\u000e^%e\u0003Aygn\u00158baNDw\u000e\u001e$s_j,g\u000e\u0006\u0003\u0002\u0010\n\u001d\u0001BBAqA\u0001\u0007\u0001/\u0001\u000beK2,G/\u001a\"fM>\u0014Xm\u00158baNDw\u000e\u001e\u000b\u0005\u0003;\u0013i\u0001\u0003\u0004\u0002b\u0006\u0002\r\u0001]\u0001\u0012Y>\fGm\u00158baNDw\u000e^*ju\u0016\u001cHC\u0001B\n!\u0019\u0011)B!\n\u0003,9!!q\u0003B\u0011\u001d\u0011\u0011IBa\b\u000e\u0005\tm!b\u0001B\u000fo\u00051AH]8pizJ\u0011!\\\u0005\u0004\u0005Ga\u0017a\u00029bG.\fw-Z\u0005\u0005\u0005O\u0011ICA\u0002TKFT1Aa\tm!\u0019!(Q\u00069\u00020%\u0019!q\u00067\u0003\rQ+\b\u000f\\33\u0003U\u0011X-\u00193T]\u0006\u00048\u000f[8u)&lWm\u001d;b[B$BA!\u000e\u00038A!A/^A\u0018\u0011\u0019\t\to\ta\u0001a\u0006QQ.Y=cK\u000ecW-\u00198\u0002\u001d\rdW-\u00198T]\u0006\u00048\u000f[8ugR!\u0011Q\u0014B \u0011\u001d\u0011\t%\na\u0001\u0005\u0007\n\u0011\u0002\u001d:fI&\u001c\u0017\r^3\u0011\rQ\u0014)\u0005]AO\u0013\r\u00119\u0005\u001c\u0002\n\rVt7\r^5p]F\n\u0011d\u00197fC:\u001cf.\u00199tQ>$8OU3uK:$\u0018n\u001c8Ng\u0006Y2\r\\3b]Ns\u0017\r]:i_R\u001c(+\u001a;f]RLwN\\*ju\u0016\fQCZ8sO\u0016$8K\\1qg\"|Go\u001d\"fM>\u0014X\rF\u0002g\u0005#BaAa\u0015)\u0001\u0004\u0001\u0018A\u00057pON#\u0018M\u001d;T]\u0006\u00048\u000f[8u\u0013\u0012\fqB]3n_Z,7K\\1qg\"|Go\u001d\u000b\u0005\u0003\u001f\u0013I\u0006\u0003\u0004\u0003\\%\u0002\rAZ\u0001\u0011Kb\u0004\u0018N]3e':\f\u0007o\u001d5piN\fQa\u00197pg\u0016$\"!a$\u0002\u001bMt\u0017\r]:i_R\u001cu.\u001e8u\u0003AY\u0015MZ6b\u001b\u0016$\u0018\rZ1uC2{w\rE\u0002\u0002\n5\u001aB!\fB5\u0017B\u0019AOa\u001b\n\u0007\t5DN\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0005K\nQ!\u00199qYf$b\"a\u0005\u0003v\t]$\u0011\u0010BE\u0005\u0017\u0013i\tC\u0003~_\u0001\u0007a\u0010C\u0004\u0002@>\u0002\r!a1\t\u000f\tmt\u00061\u0001\u0003~\u00059A-\u0019;b\t&\u0014\b\u0003\u0002B@\u0005\u000bk!A!!\u000b\u0007\t\rU(\u0001\u0002j_&!!q\u0011BA\u0005\u00111\u0015\u000e\\3\t\u000be{\u0003\u0019\u0001.\t\u000b\u0005|\u0003\u0019\u00012\t\u000f\u0005\u0015q\u00061\u0001\u0002\b\u0005\u0001\"/Z2pm\u0016\u00148K\\1qg\"|Go\u001d\u000b\u0004M\nM\u0005\"B)1\u0001\u0004\u0019\u0016a\u00053fY\u0016$Xm\u00158baNDw\u000e\u001e$jY\u0016\u001cH\u0003\u0003BM\u0005?\u0013\u0019L!.\u0011\u000bQ\u0014Y*a$\n\u0007\tuENA\u0005Gk:\u001cG/[8oa!9!\u0011U\u0019A\u0002\t\r\u0016A\u00027pO\u0012K'\u000f\u0005\u0003\u0003&\n=VB\u0001BT\u0015\u0011\u0011IKa+\u0002\t\u0019LG.\u001a\u0006\u0004\u0005[k\u0014a\u00018j_&!!\u0011\u0017BT\u0005\u0011\u0001\u0016\r\u001e5\t\r\tm\u0013\u00071\u0001g\u0011\u0019\u00119,\ra\u0001\u0017\u00069An\\4hS:<\u0007")
public final class KafkaMetadataLog
implements ReplicatedLog,
Logging {
    private final UnifiedLog log;
    private final Time time;
    private final Scheduler scheduler;
    private final TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> snapshots;
    private final TopicPartition topicPartition;
    private final MetadataLogConfig config;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static KafkaMetadataLog apply(TopicPartition topicPartition, Uuid topicId, File dataDir, Time time, Scheduler scheduler, MetadataLogConfig config) {
        return KafkaMetadataLog$.MODULE$.apply(topicPartition, topicId, dataDir, time, scheduler, config);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public ValidOffsetAndEpoch validateOffsetAndEpoch(long x$1, int x$2) {
        return super.validateOffsetAndEpoch(x$1, x$2);
    }

    public long truncateToEndOffset(OffsetAndEpoch x$1) {
        return super.truncateToEndOffset(x$1);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public UnifiedLog log() {
        return this.log;
    }

    public LogFetchInfo read(long startOffset, Isolation readIsolation) {
        Product product;
        if (Isolation.COMMITTED.equals(readIsolation)) {
            product = FetchHighWatermark$.MODULE$;
        } else if (Isolation.UNCOMMITTED.equals(readIsolation)) {
            product = FetchLogEnd$.MODULE$;
        } else {
            throw new IllegalArgumentException(new StringBuilder(25).append("Unhandled read isolation ").append(readIsolation).toString());
        }
        FetchDataInfo fetchInfo = this.log().read(startOffset, this.config.maxFetchSizeInBytes(), (FetchIsolation)product, true);
        return new LogFetchInfo(fetchInfo.records(), new org.apache.kafka.raft.LogOffsetMetadata(fetchInfo.fetchOffsetMetadata().messageOffset(), Optional.of(new SegmentPosition(fetchInfo.fetchOffsetMetadata().segmentBaseOffset(), fetchInfo.fetchOffsetMetadata().relativePositionInSegment()))));
    }

    public org.apache.kafka.raft.LogAppendInfo appendAsLeader(Records records, int epoch) {
        if (records.sizeInBytes() == 0) {
            throw new IllegalArgumentException("Attempt to append an empty record set");
        }
        MemoryRecords x$1 = (MemoryRecords)records;
        AppendOrigin$RaftLeader$ x$3 = AppendOrigin$RaftLeader$.MODULE$;
        RequestLocal x$4 = RequestLocal$.MODULE$.NoCaching();
        MetadataVersion x$5 = this.log().appendAsLeader$default$4();
        return this.handleAndConvertLogAppendInfo(this.log().appendAsLeader(x$1, epoch, x$3, x$5, x$4));
    }

    public org.apache.kafka.raft.LogAppendInfo appendAsFollower(Records records) {
        if (records.sizeInBytes() == 0) {
            throw new IllegalArgumentException("Attempt to append an empty record set");
        }
        return this.handleAndConvertLogAppendInfo(this.log().appendAsFollower((MemoryRecords)records));
    }

    private org.apache.kafka.raft.LogAppendInfo handleAndConvertLogAppendInfo(LogAppendInfo appendInfo) {
        Option<LogOffsetMetadata> option = appendInfo.firstOffset();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new KafkaException(new StringBuilder(28).append("Append failed unexpectedly: ").append(appendInfo.errorMessage()).toString());
            }
            throw new MatchError(option);
        }
        LogOffsetMetadata firstOffset = (LogOffsetMetadata)((Some)option).value();
        org.apache.kafka.raft.LogAppendInfo logAppendInfo = new org.apache.kafka.raft.LogAppendInfo(firstOffset.messageOffset(), appendInfo.lastOffset());
        return logAppendInfo;
    }

    public int lastFetchedEpoch() {
        return BoxesRunTime.unboxToInt((Object)this.log().latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)this.latestSnapshotId().map(snapshotId -> BoxesRunTime.boxToInteger((int)KafkaMetadataLog.$anonfun$lastFetchedEpoch$2(this, snapshotId))).orElse(BoxesRunTime.boxToInteger((int)0)))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OffsetAndEpoch endOffsetForEpoch(int epoch) {
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.earliestSnapshotId()));
        Option<kafka.server.OffsetAndEpoch> option2 = this.log().endOffsetForEpoch(epoch);
        Tuple2 tuple2 = new Tuple2(option2, (Object)option);
        if (option2 instanceof Some) {
            kafka.server.OffsetAndEpoch offsetAndEpoch = (kafka.server.OffsetAndEpoch)((Some)option2).value();
            if (option instanceof Some) {
                OffsetAndEpoch snapshotId = (OffsetAndEpoch)((Some)option).value();
                if (offsetAndEpoch.offset() == snapshotId.offset && offsetAndEpoch.leaderEpoch() == epoch) {
                    return new OffsetAndEpoch(snapshotId.offset, snapshotId.epoch);
                }
            }
        }
        if (option2 instanceof Some) {
            kafka.server.OffsetAndEpoch offsetAndEpoch = (kafka.server.OffsetAndEpoch)((Some)option2).value();
            return new OffsetAndEpoch(offsetAndEpoch.offset(), offsetAndEpoch.leaderEpoch());
        }
        if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)tuple2);
        return new OffsetAndEpoch(this.endOffset().offset, this.lastFetchedEpoch());
    }

    public org.apache.kafka.raft.LogOffsetMetadata endOffset() {
        LogOffsetMetadata endOffsetMetadata = this.log().logEndOffsetMetadata();
        return new org.apache.kafka.raft.LogOffsetMetadata(endOffsetMetadata.messageOffset(), Optional.of(new SegmentPosition(endOffsetMetadata.segmentBaseOffset(), endOffsetMetadata.relativePositionInSegment())));
    }

    public long startOffset() {
        return this.log().logStartOffset();
    }

    public void truncateTo(long offset) {
        if (offset < this.highWatermark().offset) {
            throw new IllegalArgumentException(new StringBuilder(0).append(new StringBuilder(47).append("Attempt to truncate to offset ").append(offset).append(", which is below ").toString()).append(new StringBuilder(27).append("the current high watermark ").append(this.highWatermark().offset).toString()).toString());
        }
        this.log().truncateTo(offset);
    }

    /*
     * Unable to fully structure code
     */
    public boolean truncateToLatestSnapshot() {
        latestEpoch = BoxesRunTime.unboxToInt((Object)this.log().latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()I, $anonfun$truncateToLatestSnapshot$1(), ()I)()));
        var2_2 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.latestSnapshotId()));
        if (!(var2_2 instanceof Some)) ** GOTO lbl-1000
        snapshotId = (OffsetAndEpoch)((Some)var2_2).value();
        if (snapshotId.epoch > latestEpoch || snapshotId.epoch == latestEpoch && snapshotId.offset > this.endOffset().offset) {
            this.log().truncateFullyAndStartAt(snapshotId.offset);
            var4_4 = this.snapshots;
            synchronized (var4_4) {
                var6_5 = this.forgetSnapshotsBefore(snapshotId);
                var5_6 = true;
            }
            var8_7 = var6_5;
            var7_8 = var5_6;
        } else lbl-1000:
        // 2 sources

        {
            var8_7 = TreeMap$.MODULE$.empty(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
            var7_8 = false;
        }
        this.removeSnapshots(var8_7);
        return var7_8;
    }

    public void initializeLeaderEpoch(int epoch) {
        this.log().maybeAssignEpochStartOffset(epoch, this.log().logEndOffset());
    }

    public void updateHighWatermark(org.apache.kafka.raft.LogOffsetMetadata offsetMetadata) {
        OffsetMetadata segmentPosition;
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(offsetMetadata.metadata));
        if (option instanceof Some && (segmentPosition = (OffsetMetadata)((Some)option).value()) instanceof SegmentPosition) {
            SegmentPosition segmentPosition2 = (SegmentPosition)segmentPosition;
            this.log().updateHighWatermark(new LogOffsetMetadata(offsetMetadata.offset, segmentPosition2.baseOffset(), segmentPosition2.relativePosition()));
            return;
        }
        this.log().updateHighWatermark(offsetMetadata.offset);
    }

    /*
     * WARNING - void declaration
     */
    public org.apache.kafka.raft.LogOffsetMetadata highWatermark() {
        void var2_2;
        LogOffsetSnapshot logOffsetSnapshot = this.log().fetchOffsetSnapshot();
        if (logOffsetSnapshot == null) {
            throw new MatchError(null);
        }
        LogOffsetMetadata hwm = logOffsetSnapshot.highWatermark();
        Optional segmentPosition = var2_2.messageOffsetOnly() ? Optional.of(new SegmentPosition(var2_2.segmentBaseOffset(), var2_2.relativePositionInSegment())) : Optional.empty();
        return new org.apache.kafka.raft.LogOffsetMetadata(var2_2.messageOffset(), segmentPosition);
    }

    public void flush(boolean forceFlushActiveSegment) {
        this.log().flush(forceFlushActiveSegment);
    }

    public long lastFlushedOffset() {
        return this.log().recoveryPoint();
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Uuid topicId() {
        return (Uuid)this.log().topicId().get();
    }

    public Optional<RawSnapshotWriter> createNewSnapshot(OffsetAndEpoch snapshotId) {
        if (snapshotId.offset < this.startOffset()) {
            if (this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = KafkaMetadataLog.$anonfun$createNewSnapshot$1(this, snapshotId);
                Object var6_2 = null;
                this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            return Optional.empty();
        }
        long highWatermarkOffset = this.highWatermark().offset;
        if (snapshotId.offset > highWatermarkOffset) {
            throw new IllegalArgumentException(new StringBuilder(73).append("Cannot create a snapshot with an id (").append(snapshotId).append(") greater than the high-watermark (").append(highWatermarkOffset).append(")").toString());
        }
        ValidOffsetAndEpoch validOffsetAndEpoch = this.validateOffsetAndEpoch(snapshotId.offset, snapshotId.epoch);
        ValidOffsetAndEpoch.Kind kind = validOffsetAndEpoch.kind();
        ValidOffsetAndEpoch.Kind kind2 = ValidOffsetAndEpoch.Kind.VALID;
        if (kind == null ? kind2 != null : !kind.equals(kind2)) {
            throw new IllegalArgumentException(new StringBuilder(50).append("Snapshot id (").append(snapshotId).append(") is not valid according to the log: ").append(validOffsetAndEpoch).toString());
        }
        return this.storeSnapshot(snapshotId);
    }

    public Optional<RawSnapshotWriter> storeSnapshot(OffsetAndEpoch snapshotId) {
        boolean bl;
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            bl = this.snapshots.contains((Object)snapshotId);
        }
        if (bl) {
            return Optional.empty();
        }
        return Optional.of(FileRawSnapshotWriter.create((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId, Optional.of(this)));
    }

    /*
     * Unable to fully structure code
     */
    public Optional<RawSnapshotReader> readSnapshot(OffsetAndEpoch snapshotId) {
        var3_2 = this.snapshots;
        synchronized (var3_2) {
            block8: {
                block7: {
                    var5_3 = false;
                    var6_4 = null;
                    var7_5 = this.snapshots.get((Object)snapshotId);
                    if (!None$.MODULE$.equals(var7_5)) break block7;
                    var2_6 = None$.MODULE$;
                    break block8;
                }
                if (!(var7_5 instanceof Some)) ** GOTO lbl-1000
                var5_3 = true;
                var6_4 = (Some)var7_5;
                var8_7 = (Option)var6_4.value();
                if (None$.MODULE$.equals(var8_7)) {
                    var2_6 = this.liftedTree1$1(snapshotId);
                } else if (var5_3) {
                    var2_6 = (Option)var6_4.value();
                } else {
                    throw new MatchError((Object)var7_5);
                }
            }
            var4_8 = OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8((Option)var2_6));
            return var4_8;
        }
    }

    public Optional<RawSnapshotReader> latestSnapshot() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            Optional<RawSnapshotReader> optional = this.latestSnapshotId().flatMap(snapshotId -> this.readSnapshot((OffsetAndEpoch)snapshotId));
            return optional;
        }
    }

    public Optional<OffsetAndEpoch> latestSnapshotId() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            Optional optional = OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.snapshots.lastOption().map((Function1 & Serializable)x0$1 -> {
                void var1_1;
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                OffsetAndEpoch snapshotId = (OffsetAndEpoch)x0$1._1();
                return var1_1;
            })));
            return optional;
        }
    }

    public Optional<OffsetAndEpoch> earliestSnapshotId() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            Optional optional = OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.snapshots.headOption().map((Function1 & Serializable)x0$1 -> {
                void var1_1;
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                OffsetAndEpoch snapshotId = (OffsetAndEpoch)x0$1._1();
                return var1_1;
            })));
            return optional;
        }
    }

    public void onSnapshotFrozen(OffsetAndEpoch snapshotId) {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            this.snapshots.put((Object)snapshotId, (Object)None$.MODULE$);
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean deleteBeforeSnapshot(OffsetAndEpoch snapshotId) {
        var2_2 = this.snapshots;
        synchronized (var2_2) {
            var3_3 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.latestSnapshotId()));
            if (!(var3_3 instanceof Some)) ** GOTO lbl-1000
            latestSnapshotId = (OffsetAndEpoch)((Some)var3_3).value();
            if (this.snapshots.contains((Object)snapshotId) && this.startOffset() < snapshotId.offset && snapshotId.offset <= latestSnapshotId.offset && this.log().maybeIncrementLogStartOffset(snapshotId.offset, SnapshotGenerated$.MODULE$)) {
                this.log().deleteOldSegments();
                var6_5 = this.forgetSnapshotsBefore(snapshotId);
                var5_6 = true;
            } else lbl-1000:
            // 2 sources

            {
                var6_5 = TreeMap$.MODULE$.empty(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
                var5_6 = false;
            }
        }
        this.removeSnapshots(var6_5);
        return var5_6;
    }

    private Seq<Tuple2<OffsetAndEpoch, Object>> loadSnapshotSizes() {
        return (Seq)this.snapshots.keys().toSeq().flatMap((Function1 & Serializable)snapshotId -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.readSnapshot((OffsetAndEpoch)snapshotId))).map((Function1 & Serializable)reader -> new Tuple2(snapshotId, (Object)BoxesRunTime.boxToLong((long)reader.sizeInBytes()))));
    }

    private Option<Object> readSnapshotTimestamp(OffsetAndEpoch snapshotId) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.readSnapshot(snapshotId))).flatMap((Function1 & Serializable)reader -> {
            RecordBatch firstBatch = (RecordBatch)reader.records().batchIterator().next();
            CloseableIterator records = firstBatch.streamingIterator((BufferSupplier)new BufferSupplier.GrowableBufferSupplier());
            if (firstBatch.isControlBatch()) {
                SnapshotHeaderRecord header = ControlRecordUtils.deserializedSnapshotHeaderRecord((Record)((Record)records.next()));
                return new Some((Object)BoxesRunTime.boxToLong((long)header.lastContainedLogTimestamp()));
            }
            if (this.logger().underlying().isWarnEnabled()) {
                String string;
                String string2 = string = "Did not find control record at beginning of snapshot";
                string = null;
                String msgWithLogIdent_msg = string2;
                Object var5_6 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            return None$.MODULE$;
        });
    }

    public boolean maybeClean() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            boolean didClean = false;
            boolean bl = (didClean |= this.cleanSnapshotsRetentionSize()) | this.cleanSnapshotsRetentionMs();
            return bl;
        }
    }

    private boolean cleanSnapshots(Function1<OffsetAndEpoch, Object> predicate) {
        Object object = new Object();
        try {
            if (this.snapshots.size() < 2) {
                return false;
            }
            BooleanRef didClean = BooleanRef.create((boolean)false);
            this.snapshots.keys().toSeq().sliding(2).foreach((Function1 & Serializable)x0$1 -> {
                if (x0$1 == null) return BoxesRunTime.boxToBoolean((boolean)false);
                SeqOps seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)x0$1);
                if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return BoxesRunTime.boxToBoolean((boolean)false);
                new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps));
                if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return BoxesRunTime.boxToBoolean((boolean)false);
                OffsetAndEpoch snapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                OffsetAndEpoch nextSnapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                if (snapshot == null) return BoxesRunTime.boxToBoolean((boolean)false);
                if (nextSnapshot == null) return BoxesRunTime.boxToBoolean((boolean)false);
                if (!BoxesRunTime.unboxToBoolean((Object)predicate.apply((Object)snapshot))) throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                if (!this.deleteBeforeSnapshot(nextSnapshot)) throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                didClean$1.elem = true;
                return BoxedUnit.UNIT;
            });
            return didClean.elem;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    private boolean cleanSnapshotsRetentionMs() {
        boolean bl;
        block5: {
            boolean bl2;
            if (this.config.retentionMillis() < 0L) {
                return false;
            }
            Function1 & Serializable cleanSnapshots_predicate = (Function1 & Serializable)snapshotId -> BoxesRunTime.boxToBoolean((boolean)this.shouldClean$1(snapshotId));
            Object object = new Object();
            try {
                if (this.snapshots.size() < 2) {
                    bl = false;
                    break block5;
                }
                BooleanRef cleanSnapshots_didClean = BooleanRef.create((boolean)false);
                this.snapshots.keys().toSeq().sliding(2).foreach((Function1 & Serializable)x0$1 -> {
                    if (x0$1 == null) return BoxesRunTime.boxToBoolean((boolean)false);
                    SeqOps seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)x0$1);
                    if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return BoxesRunTime.boxToBoolean((boolean)false);
                    new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps));
                    if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return BoxesRunTime.boxToBoolean((boolean)false);
                    OffsetAndEpoch snapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                    OffsetAndEpoch nextSnapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                    if (snapshot == null) return BoxesRunTime.boxToBoolean((boolean)false);
                    if (nextSnapshot == null) return BoxesRunTime.boxToBoolean((boolean)false);
                    if (!BoxesRunTime.unboxToBoolean((Object)predicate.apply((Object)snapshot))) throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                    if (!this.deleteBeforeSnapshot(nextSnapshot)) throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                    didClean$1.elem = true;
                    return BoxedUnit.UNIT;
                });
                bl2 = cleanSnapshots_didClean.elem;
            }
            catch (NonLocalReturnControl cleanSnapshots_ex) {
                if (cleanSnapshots_ex.key() == object) {
                    bl2 = cleanSnapshots_ex.value$mcZ$sp();
                }
                throw cleanSnapshots_ex;
            }
            bl = bl2;
        }
        return bl;
    }

    private boolean cleanSnapshotsRetentionSize() {
        boolean bl;
        block5: {
            boolean bl2;
            if (this.config.retentionMaxBytes() < 0L) {
                return false;
            }
            Map snapshotSizes = this.loadSnapshotSizes().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            LongRef snapshotTotalSize = LongRef.create((long)BoxesRunTime.unboxToLong((Object)snapshotSizes.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
            Function1 & Serializable cleanSnapshots_predicate = (Function1 & Serializable)snapshotId -> BoxesRunTime.boxToBoolean((boolean)this.shouldClean$2(snapshotId, snapshotSizes, snapshotTotalSize));
            Object object = new Object();
            try {
                if (this.snapshots.size() < 2) {
                    bl = false;
                    break block5;
                }
                BooleanRef cleanSnapshots_didClean = BooleanRef.create((boolean)false);
                this.snapshots.keys().toSeq().sliding(2).foreach((Function1 & Serializable)x0$1 -> {
                    if (x0$1 == null) return BoxesRunTime.boxToBoolean((boolean)false);
                    SeqOps seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)x0$1);
                    if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return BoxesRunTime.boxToBoolean((boolean)false);
                    new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps));
                    if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return BoxesRunTime.boxToBoolean((boolean)false);
                    OffsetAndEpoch snapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                    OffsetAndEpoch nextSnapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                    if (snapshot == null) return BoxesRunTime.boxToBoolean((boolean)false);
                    if (nextSnapshot == null) return BoxesRunTime.boxToBoolean((boolean)false);
                    if (!BoxesRunTime.unboxToBoolean((Object)predicate.apply((Object)snapshot))) throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                    if (!this.deleteBeforeSnapshot(nextSnapshot)) throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                    didClean$1.elem = true;
                    return BoxedUnit.UNIT;
                });
                bl2 = cleanSnapshots_didClean.elem;
            }
            catch (NonLocalReturnControl cleanSnapshots_ex) {
                if (cleanSnapshots_ex.key() == object) {
                    bl2 = cleanSnapshots_ex.value$mcZ$sp();
                }
                throw cleanSnapshots_ex;
            }
            bl = bl2;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> forgetSnapshotsBefore(OffsetAndEpoch logStartSnapshotId) {
        void var2_2;
        TreeMap expiredSnapshots = (TreeMap)((MapOps)this.snapshots.until((Object)logStartSnapshotId)).clone();
        this.snapshots.$minus$minus$eq((IterableOnce)expiredSnapshots.keys());
        return var2_2;
    }

    private void removeSnapshots(TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> expiredSnapshots) {
        expiredSnapshots.foreach((Function1 & Serializable)x0$1 -> {
            OffsetAndEpoch snapshotId;
            if (x0$1 != null) {
                snapshotId = (OffsetAndEpoch)x0$1._1();
                if (this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = KafkaMetadataLog.$anonfun$removeSnapshots$2(snapshotId);
                    Object var4_3 = null;
                    this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                }
            } else {
                throw new MatchError(null);
            }
            Path path = Snapshots.markForDelete((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId);
            return path;
        });
        if (expiredSnapshots.nonEmpty()) {
            this.scheduler.schedule("delete-snapshot-files", KafkaMetadataLog$.MODULE$.kafka$raft$KafkaMetadataLog$$deleteSnapshotFiles(this.log().dir().toPath(), expiredSnapshots, this), this.config.fileDeleteDelayMs(), this.scheduler.schedule$default$4(), this.scheduler.schedule$default$5());
        }
    }

    public void close() {
        this.log().close();
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            ((IterableOnceOps)this.snapshots.values().flatten(Predef$.MODULE$.$conforms())).foreach((Function1 & Serializable)x$3 -> {
                x$3.close();
                return BoxedUnit.UNIT;
            });
            this.snapshots.clear();
            return;
        }
    }

    public int snapshotCount() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            int n = this.snapshots.size();
            return n;
        }
    }

    public static final /* synthetic */ int $anonfun$lastFetchedEpoch$2(KafkaMetadataLog $this, OffsetAndEpoch snapshotId) {
        long logEndOffset = $this.endOffset().offset;
        if (snapshotId.offset == $this.startOffset() && snapshotId.offset == logEndOffset) {
            return snapshotId.epoch;
        }
        throw new KafkaException(new StringBuilder(0).append(new StringBuilder(64).append("Log doesn't have a last fetch epoch and there is a snapshot (").append(snapshotId).append("). ").toString()).append(new StringBuilder(68).append("Expected the snapshot's end offset to match the log's end offset (").append(logEndOffset).append(") ").toString()).append(new StringBuilder(27).append("and the log start offset (").append($this.startOffset()).append(")").toString()).toString());
    }

    public static final /* synthetic */ int $anonfun$truncateToLatestSnapshot$1() {
        return 0;
    }

    public static final /* synthetic */ String $anonfun$createNewSnapshot$1(KafkaMetadataLog $this, OffsetAndEpoch snapshotId$1) {
        return new StringBuilder(72).append("Cannot create a snapshot with an id (").append(snapshotId$1).append(") less than the log start offset (").append($this.startOffset()).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$readSnapshot$1(OffsetAndEpoch snapshotId$2, Path path$1) {
        return new StringBuilder(47).append("Couldn't read ").append(snapshotId$2).append("; expected to find snapshot file ").append(path$1).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final /* synthetic */ Option liftedTree1$1(OffsetAndEpoch snapshotId$2) {
        try {
            void var2_2;
            Some snapshotReader = new Some((Object)FileRawSnapshotReader.open((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId$2));
            this.snapshots.put((Object)snapshotId$2, (Object)snapshotReader);
            return var2_2;
        }
        catch (NoSuchFileException noSuchFileException) {
            Path path = Snapshots.snapshotPath((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId$2);
            if (this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = KafkaMetadataLog.$anonfun$readSnapshot$1(snapshotId$2, path);
                Object var4_4 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            this.snapshots.remove((Object)snapshotId$2);
            return None$.MODULE$;
        }
    }

    public static final /* synthetic */ String $anonfun$readSnapshotTimestamp$2() {
        return "Did not find control record at beginning of snapshot";
    }

    private final boolean shouldClean$1(OffsetAndEpoch snapshotId) {
        long now = this.time.milliseconds();
        return this.readSnapshotTimestamp(snapshotId).exists((Function1)(JFunction1.mcZJ.sp & Serializable)timestamp -> now - timestamp > $this.config.retentionMillis());
    }

    private final boolean shouldClean$2(OffsetAndEpoch snapshotId, Map snapshotSizes$1, LongRef snapshotTotalSize$1) {
        return snapshotSizes$1.get((Object)snapshotId).exists((Function1)(JFunction1.mcZJ.sp & Serializable)snapshotSize -> {
            if (this.log().size() + snapshotTotalSize$1.elem > $this.config.retentionMaxBytes()) {
                snapshotTotalSize$1.elem -= snapshotSize;
                return true;
            }
            return false;
        });
    }

    public static final /* synthetic */ String $anonfun$removeSnapshots$2(OffsetAndEpoch snapshotId$4) {
        return new StringBuilder(30).append("Marking snapshot ").append(snapshotId$4).append(" for deletion").toString();
    }

    public KafkaMetadataLog(UnifiedLog log, Time time, Scheduler scheduler, TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> snapshots, TopicPartition topicPartition, MetadataLogConfig config) {
        this.log = log;
        this.time = time;
        this.scheduler = scheduler;
        this.snapshots = snapshots;
        this.topicPartition = topicPartition;
        this.config = config;
        this.logIdent_$eq(new StringBuilder(34).append("[MetadataLog partition=").append(topicPartition).append(", nodeId=").append(config.nodeId()).append("] ").toString());
    }
}

