/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.api.IntegrationTestHarness;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidProducerEpochException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.storage.internals.log.ProducerStateEntry;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r]c\u0001\u0002\u001f>\u0001\tCQa\u0012\u0001\u0005\u0002!CQA\u0013\u0001\u0005B-CqA\u0015\u0001C\u0002\u0013\u00051\n\u0003\u0004T\u0001\u0001\u0006I\u0001\u0014\u0005\b)\u0002\u0011\r\u0011\"\u0001L\u0011\u0019)\u0006\u0001)A\u0005\u0019\"9a\u000b\u0001b\u0001\n\u0003Y\u0005BB,\u0001A\u0003%A\nC\u0004Y\u0001\t\u0007I\u0011A-\t\r\t\u0004\u0001\u0015!\u0003[\u0011\u001d\u0019\u0007A1A\u0005\u0002eCa\u0001\u001a\u0001!\u0002\u0013Q\u0006bB3\u0001\u0005\u0004%\ta\u0013\u0005\u0007M\u0002\u0001\u000b\u0011\u0002'\t\u000f\u001d\u0004!\u0019!C\u0001Q\"9\u0011\u0011\u0002\u0001!\u0002\u0013I\u0007\"CA\u0006\u0001\t\u0007I\u0011AA\u0007\u0011!\ti\u0002\u0001Q\u0001\n\u0005=\u0001\"CA\u0010\u0001\t\u0007I\u0011AA\u0007\u0011!\t\t\u0003\u0001Q\u0001\n\u0005=\u0001bBA\u0012\u0001\u0011\u0005\u0011Q\u0005\u0005\b\u0003g\u0001A\u0011KA\u001b\u0011\u001d\tI\u0005\u0001C)\u0003\u0017Bq!!\u0014\u0001\t\u0003\t)\u0003C\u0004\u0002P\u0001!\t%!\u0015\t\u000f\u0005E\u0004\u0001\"\u0011\u0002t!9\u0011Q\u0010\u0001\u0005\u0002\u0005}\u0004bBAd\u0001\u0011\u0005\u0011\u0011\u001a\u0005\b\u0003'\u0004A\u0011AAk\u0011\u001d\ty\u000e\u0001C\u0001\u0003CDq!a;\u0001\t\u0003\ti\u000fC\u0004\u0002x\u0002!I!!?\t\u000f\t\u0015\u0001\u0001\"\u0001\u0003\b!9!\u0011\u0003\u0001\u0005\u0002\tM\u0001b\u0002B\u000f\u0001\u0011\u0005!q\u0004\u0005\b\u0005S\u0001A\u0011\u0001B\u0016\u0011\u001d\u0011)\u0004\u0001C\u0001\u0005oAqA!\u0011\u0001\t\u0003\u0011\u0019\u0005C\u0004\u0003N\u0001!\tAa\u0014\t\u000f\te\u0003\u0001\"\u0003\u0003\\!9!\u0011\u000f\u0001\u0005\u0002\tM\u0004b\u0002B?\u0001\u0011\u0005!q\u0010\u0005\b\u0005\u0013\u0003A\u0011\u0001BF\u0011\u001d\u0011)\n\u0001C\u0001\u0005/CqA!)\u0001\t\u0003\u0011\u0019\u000bC\u0004\u0003.\u0002!\tAa,\t\u000f\te\u0006\u0001\"\u0001\u0003<\"9!Q\u0019\u0001\u0005\n\t\u001d\u0007b\u0002Bn\u0001\u0011%!Q\u001c\u0005\n\u0005S\u0004\u0011\u0013!C\u0005\u0005WD\u0011b!\u0001\u0001#\u0003%Iaa\u0001\t\u0013\r\u001d\u0001!%A\u0005\n\r%\u0001bBB\u0007\u0001\u0011%1q\u0002\u0005\b\u0007'\u0001A\u0011BB\u000b\u0011%\u0019\t\u0004AI\u0001\n\u0013\u0019\u0019\u0004C\u0005\u00048\u0001\t\n\u0011\"\u0003\u00044!I1\u0011\b\u0001\u0012\u0002\u0013%11\u0001\u0005\n\u0007w\u0001\u0011\u0013!C\u0005\u0007\u0007Aqa!\u0010\u0001\t\u0003\u0019yD\u0001\tUe\u0006t7/Y2uS>t7\u000fV3ti*\u0011ahP\u0001\u0004CBL'\"\u0001!\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0011\t\u0003\t\u0016k\u0011!P\u0005\u0003\rv\u0012a#\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003%\u0003\"\u0001\u0012\u0001\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u000b\u0002\u0019B\u0011Q\nU\u0007\u0002\u001d*\tq*A\u0003tG\u0006d\u0017-\u0003\u0002R\u001d\n\u0019\u0011J\u001c;\u00025Q\u0014\u0018M\\:bGRLwN\\1m!J|G-^2fe\u000e{WO\u001c;\u00027Q\u0014\u0018M\\:bGRLwN\\1m!J|G-^2fe\u000e{WO\u001c;!\u0003i!(/\u00198tC\u000e$\u0018n\u001c8bY\u000e{gn];nKJ\u001cu.\u001e8u\u0003m!(/\u00198tC\u000e$\u0018n\u001c8bY\u000e{gn];nKJ\u001cu.\u001e8uA\u0005ibn\u001c8Ue\u0006t7/Y2uS>t\u0017\r\\\"p]N,X.\u001a:D_VtG/\u0001\u0010o_:$&/\u00198tC\u000e$\u0018n\u001c8bY\u000e{gn];nKJ\u001cu.\u001e8uA\u00051Ao\u001c9jGF*\u0012A\u0017\t\u00037\u0002l\u0011\u0001\u0018\u0006\u0003;z\u000bA\u0001\\1oO*\tq,\u0001\u0003kCZ\f\u0017BA1]\u0005\u0019\u0019FO]5oO\u00069Ao\u001c9jGF\u0002\u0013A\u0002;pa&\u001c''A\u0004u_BL7M\r\u0011\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t\u00039qW/\u001c)beRLG/[8og\u0002\na\u0003\u001e:b]N\f7\r^5p]\u0006d\u0007K]8ek\u000e,'o]\u000b\u0002SB\u0019!n\\9\u000e\u0003-T!\u0001\\7\u0002\u000f5,H/\u00192mK*\u0011aNT\u0001\u000bG>dG.Z2uS>t\u0017B\u00019l\u0005\u0019\u0011UO\u001a4feB!!\u000f @\u007f\u001b\u0005\u0019(B\u0001;v\u0003!\u0001(o\u001c3vG\u0016\u0014(B\u0001<x\u0003\u001d\u0019G.[3oiNT!\u0001\u0011=\u000b\u0005eT\u0018AB1qC\u000eDWMC\u0001|\u0003\ry'oZ\u0005\u0003{N\u0014QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\b\u0003B'\u0000\u0003\u0007I1!!\u0001O\u0005\u0015\t%O]1z!\ri\u0015QA\u0005\u0004\u0003\u000fq%\u0001\u0002\"zi\u0016\fq\u0003\u001e:b]N\f7\r^5p]\u0006d\u0007K]8ek\u000e,'o\u001d\u0011\u0002-Q\u0014\u0018M\\:bGRLwN\\1m\u0007>t7/^7feN,\"!a\u0004\u0011\t)|\u0017\u0011\u0003\t\u0007\u0003'\tIB @\u000e\u0005\u0005U!bAA\fk\u0006A1m\u001c8tk6,'/\u0003\u0003\u0002\u001c\u0005U!\u0001C\"p]N,X.\u001a:\u0002/Q\u0014\u0018M\\:bGRLwN\\1m\u0007>t7/^7feN\u0004\u0013!\u00078p]R\u0013\u0018M\\:bGRLwN\\1m\u0007>t7/^7feN\f!D\\8o)J\fgn]1di&|g.\u00197D_:\u001cX/\\3sg\u0002\nqb\u001c<feJLG-\u001b8h!J|\u0007o\u001d\u000b\u0003\u0003O\u0001B!!\u000b\u000205\u0011\u00111\u0006\u0006\u0004\u0003[q\u0016\u0001B;uS2LA!!\r\u0002,\tQ\u0001K]8qKJ$\u0018.Z:\u0002\u001b5|G-\u001b4z\u0007>tg-[4t)\u0011\t9$!\u0010\u0011\u00075\u000bI$C\u0002\u0002<9\u0013A!\u00168ji\"9\u0011q\b\fA\u0002\u0005\u0005\u0013!\u00029s_B\u001c\bCBA\"\u0003\u000b\n9#D\u0001n\u0013\r\t9%\u001c\u0002\u0004'\u0016\f\u0018AF6sC\u001a$8i\u001c8ue>dG.\u001a:D_:4\u0017nZ:\u0015\u0005\u0005\u0005\u0013a\u0003;pa&\u001c7i\u001c8gS\u001e\fQa]3u+B$B!a\u000e\u0002T!9\u0011QK\rA\u0002\u0005]\u0013\u0001\u0003;fgRLeNZ8\u0011\t\u0005e\u0013QM\u0007\u0003\u00037R1APA/\u0015\u0011\ty&!\u0019\u0002\u000f),\b/\u001b;fe*\u0019\u00111\r>\u0002\u000b),h.\u001b;\n\t\u0005\u001d\u00141\f\u0002\t)\u0016\u001cH/\u00138g_\"\u001a\u0011$a\u001b\u0011\t\u0005e\u0013QN\u0005\u0005\u0003_\nYF\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u000b\u0003\u0003oA3AGA<!\u0011\tI&!\u001f\n\t\u0005m\u00141\f\u0002\n\u0003\u001a$XM]#bG\"\fQ\u0003^3ti\n\u000b7/[2Ue\u0006t7/Y2uS>t7\u000f\u0006\u0003\u00028\u0005\u0005\u0005bBAB7\u0001\u0007\u0011QQ\u0001\u0007cV|'/^7\u0011\t\u0005\u001d\u0015Q\u0013\b\u0005\u0003\u0013\u000b\t\nE\u0002\u0002\f:k!!!$\u000b\u0007\u0005=\u0015)\u0001\u0004=e>|GOP\u0005\u0004\u0003's\u0015A\u0002)sK\u0012,g-C\u0002b\u0003/S1!a%OQ\u001dY\u00121TAV\u0003[\u0003B!!(\u0002(6\u0011\u0011q\u0014\u0006\u0005\u0003C\u000b\u0019+\u0001\u0005qe>4\u0018\u000eZ3s\u0015\u0011\t)+!\u0018\u0002\rA\f'/Y7t\u0013\u0011\tI+a(\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\u0011\ty+a-\"\u0005\u0005E\u0016A\u0001>lC\t\t),A\u0003le\u00064G\u000fK\u0004\u001c\u0003s\u000b\t-a1\u0011\t\u0005m\u0016QX\u0007\u0003\u0003GKA!a0\u0002$\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\t9\fW.Z\u0011\u0003\u0003\u000b\f\u0001d\u001f3jgBd\u0017-\u001f(b[\u0016lh&];peVlWh\u001f\u0019~\u0003I\"Xm\u001d;SK\u0006$7i\\7nSR$X\rZ\"p]N,X.\u001a:TQ>,H\u000e\u001a(piN+W-\u00168eK\u000eLG-\u001a3ECR\fG\u0003BA\u001c\u0003\u0017Dq!a!\u001d\u0001\u0004\t)\tK\u0004\u001d\u00037\u000bY+a4-\t\u0005=\u00161\u0017\u0015\b9\u0005e\u0016\u0011YAb\u0003)\"Xm\u001d;EK2\f\u00170\u001a3GKR\u001c\u0007.\u00138dYV$Wm]!c_J$X\r\u001a+sC:\u001c\u0018m\u0019;j_:$B!a\u000e\u0002X\"9\u00111Q\u000fA\u0002\u0005\u0015\u0005fB\u000f\u0002\u001c\u0006-\u00161\u001c\u0017\u0005\u0003_\u000b\u0019\fK\u0004\u001e\u0003s\u000b\t-a1\u00025Q,7\u000f^*f]\u0012|eMZ:fiN<\u0016\u000e\u001e5He>,\b/\u00133\u0015\t\u0005]\u00121\u001d\u0005\b\u0003\u0007s\u0002\u0019AACQ\u001dq\u00121TAV\u0003OdC!a,\u00024\":a$!/\u0002B\u0006\r\u0017\u0001\t;fgR\u001cVM\u001c3PM\u001a\u001cX\r^:XSRDwI]8va6+G/\u00193bi\u0006$B!a\u000e\u0002p\"9\u00111Q\u0010A\u0002\u0005\u0015\u0005fB\u0010\u0002\u001c\u0006-\u00161\u001f\u0017\u0005\u0003_\u000b\u0019\fK\u0004 \u0003s\u000b\t-a1\u0002\u0015M,g\u000eZ(gMN,G\u000f\u0006\u0003\u00028\u0005m\bbBA\u007fA\u0001\u0007\u0011q`\u0001\u0007G>lW.\u001b;\u0011\u00155\u0013\t!]AC\u0003#\t9$C\u0002\u0003\u00049\u0013\u0011BR;oGRLwN\\\u001a\u0002'Q,7\u000f\u001e$f]\u000eLgnZ(o\u0007>lW.\u001b;\u0015\t\u0005]\"\u0011\u0002\u0005\b\u0003\u0007\u000b\u0003\u0019AACQ\u001d\t\u00131TAV\u0005\u001baC!a,\u00024\":\u0011%!/\u0002B\u0006\r\u0017\u0001\u0007;fgR4UM\\2j]\u001e|enU3oI>3gm]3ugR!\u0011q\u0007B\u000b\u0011\u001d\t\u0019I\ta\u0001\u0003\u000bCsAIAN\u0003W\u0013I\u0002\f\u0003\u00020\u0006M\u0006f\u0002\u0012\u0002:\u0006\u0005\u00171Y\u0001-i\u0016\u001cHo\u00144gg\u0016$X*\u001a;bI\u0006$\u0018-\u00138TK:$wJ\u001a4tKR\u001cHk\u001c+sC:\u001c\u0018m\u0019;j_:$B!a\u000e\u0003\"!9\u00111Q\u0012A\u0002\u0005\u0015\u0005fB\u0012\u0002\u001c\u0006-&Q\u0005\u0017\u0005\u0003_\u000b\u0019\fK\u0004$\u0003s\u000b\t-a1\u00027Q,7\u000f^%oSR$&/\u00198tC\u000e$\u0018n\u001c8t)&lWm\\;u)\u0011\t9D!\f\t\u000f\u0005\rE\u00051\u0001\u0002\u0006\":A%a'\u0002,\nEB\u0006BAX\u0003gCs\u0001JA]\u0003\u0003\f\u0019-A\u0012uKN$8+\u001a8e\u001f\u001a47/\u001a;t)>$&/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;\u0015\t\u0005]\"\u0011\b\u0005\b\u0003\u0007+\u0003\u0019AACQ\u001d)\u00131TAV\u0005{aC!a,\u00024\":Q%!/\u0002B\u0006\r\u0017\u0001\b;fgR\u001cu.\\7jiR\u0013\u0018M\\:bGRLwN\u001c+j[\u0016|W\u000f\u001e\u000b\u0005\u0003o\u0011)\u0005C\u0004\u0002\u0004\u001a\u0002\r!!\")\u000f\u0019\nY*a+\u0003J1\"\u0011qVAZQ\u001d1\u0013\u0011XAa\u0003\u0007\f1\u0004^3ti\u0006\u0013wN\u001d;Ue\u0006t7/Y2uS>tG+[7f_V$H\u0003BA\u001c\u0005#Bq!a!(\u0001\u0004\t)\tK\u0004(\u00037\u000bYK!\u0016-\t\u0005=\u00161\u0017\u0015\bO\u0005e\u0016\u0011YAb\u0003-!Xm\u001d;US6,w.\u001e;\u0015\r\u0005]\"Q\fB4\u0011\u001d\u0011y\u0006\u000ba\u0001\u0005C\n!C\\3fI&s\u0017\u000e^!oIN+g\u000eZ'tOB\u0019QJa\u0019\n\u0007\t\u0015dJA\u0004C_>dW-\u00198\t\u000f\t%\u0004\u00061\u0001\u0003l\u0005qA/[7f_V$\bK]8dKN\u001c\bCB'\u0003nE\f9$C\u0002\u0003p9\u0013\u0011BR;oGRLwN\\\u0019\u0002#Q,7\u000f\u001e$f]\u000eLgnZ(o'\u0016tG\r\u0006\u0003\u00028\tU\u0004bBABS\u0001\u0007\u0011Q\u0011\u0015\bS\u0005m\u00151\u0016B=Y\u0011\ty+a-)\u000f%\nI,!1\u0002D\u0006QB/Z:u\r\u0016t7-\u001b8h\u001f:\fE\r\u001a)beRLG/[8ogR!\u0011q\u0007BA\u0011\u001d\t\u0019I\u000ba\u0001\u0003\u000bCsAKAN\u0003W\u0013)\t\f\u0003\u00020\u0006M\u0006f\u0002\u0016\u0002:\u0006\u0005\u00171Y\u0001#i\u0016\u001cHOR3oG&twm\u00148Ue\u0006t7/Y2uS>tW\t\u001f9je\u0006$\u0018n\u001c8\u0015\t\u0005]\"Q\u0012\u0005\b\u0003\u0007[\u0003\u0019AACQ\u001dY\u00131TAV\u0005#cC!a,\u00024\":1&!/\u0002B\u0006\r\u0017\u0001\b;fgRlU\u000f\u001c;ja2,W*\u0019:lKJ\u001cxJ\\3MK\u0006$WM\u001d\u000b\u0005\u0003o\u0011I\nC\u0004\u0002\u00042\u0002\r!!\")\u000f1\nY*a+\u0003\u001e2\"\u0011qVAZQ\u001da\u0013\u0011XAa\u0003\u0007\fA\u0005^3ti\u000e{gn]3dkRLg/\u001a7z%Vt\u0017J\\5u)J\fgn]1di&|gn\u001d\u000b\u0005\u0003o\u0011)\u000bC\u0004\u0002\u00046\u0002\r!!\")\u000f5\nY*a+\u0003*2\"\u0011qVAZQ\u001di\u0013\u0011XAa\u0003\u0007\f!\u0004^3ti\n+X\u000e\u001d+sC:\u001c\u0018m\u0019;j_:\fG.\u00129pG\"$B!a\u000e\u00032\"9\u00111\u0011\u0018A\u0002\u0005\u0015\u0005f\u0002\u0018\u0002\u001c\u0006-&Q\u0017\u0017\u0005\u0003_\u000b\u0019\fK\u0004/\u0003s\u000b\t-a1\u0002/Q,7\u000f\u001e$bS2,(/\u001a+p\r\u0016t7-Z#q_\u000eDG\u0003BA\u001c\u0005{Cq!a!0\u0001\u0004\t)\tK\u00040\u00037\u000bYK!1-\t\u0005=\u00161\u0017\u0015\b_\u0005e\u0016\u0011YAb\u0003\u001d\u001aXM\u001c3Ue\u0006t7/Y2uS>t\u0017\r\\'fgN\fw-Z:XSRDg+\u00197vKJ\u000bgnZ3\u0015\u0019\u0005]\"\u0011\u001aBf\u0005\u001f\u0014\u0019Na6\t\u000bQ\u0004\u0004\u0019A9\t\u000f\t5\u0007\u00071\u0001\u0002\u0006\u0006)Ao\u001c9jG\"1!\u0011\u001b\u0019A\u00021\u000bQa\u001d;beRDaA!61\u0001\u0004a\u0015aA3oI\"9!\u0011\u001c\u0019A\u0002\t\u0005\u0014aD<jY2\u0014UmQ8n[&$H/\u001a3\u00027\r\u0014X-\u0019;f%\u0016\fGmQ8n[&$H/\u001a3D_:\u001cX/\\3s)!\t\tBa8\u0003d\n\u001d\b\"\u0003BqcA\u0005\t\u0019AAC\u0003\u00159'o\\;q\u0011!\u0011)/\rI\u0001\u0002\u0004a\u0015AD7bqB{G\u000e\u001c*fG>\u0014Hm\u001d\u0005\n\u0003\u007f\t\u0004\u0013!a\u0001\u0003O\tQe\u0019:fCR,'+Z1e\u0007>lW.\u001b;uK\u0012\u001cuN\\:v[\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t5(\u0006BAC\u0005_\\#A!=\u0011\t\tM(Q`\u0007\u0003\u0005kTAAa>\u0003z\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005wt\u0015AC1o]>$\u0018\r^5p]&!!q B{\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001&GJ,\u0017\r^3SK\u0006$7i\\7nSR$X\rZ\"p]N,X.\u001a:%I\u00164\u0017-\u001e7uII*\"a!\u0002+\u00071\u0013y/A\u0013de\u0016\fG/\u001a*fC\u0012\u001cu.\\7jiR,GmQ8ogVlWM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u001111\u0002\u0016\u0005\u0003O\u0011y/A\u000fde\u0016\fG/\u001a*fC\u0012,fnY8n[&$H/\u001a3D_:\u001cX/\\3s)\u0011\t\tb!\u0005\t\u000f\t\u0005X\u00071\u0001\u0002\u0006\u0006Y2M]3bi\u0016$&/\u00198tC\u000e$\u0018n\u001c8bYB\u0013x\u000eZ;dKJ$2\"]B\f\u00077\u0019)c!\u000b\u0004.!91\u0011\u0004\u001cA\u0002\u0005\u0015\u0015a\u0004;sC:\u001c\u0018m\u0019;j_:\fG.\u00133\t\u0013\rua\u0007%AA\u0002\r}\u0011\u0001\u0006;sC:\u001c\u0018m\u0019;j_:$\u0016.\\3pkRl5\u000fE\u0002N\u0007CI1aa\tO\u0005\u0011auN\\4\t\u0013\r\u001db\u0007%AA\u0002\r}\u0011AC7bq\ncwnY6Ng\"A11\u0006\u001c\u0011\u0002\u0003\u0007A*A\teK2Lg/\u001a:z)&lWm\\;u\u001bND\u0001ba\f7!\u0003\u0005\r\u0001T\u0001\u0011e\u0016\fX/Z:u)&lWm\\;u\u001bN\fQe\u0019:fCR,GK]1og\u0006\u001cG/[8oC2\u0004&o\u001c3vG\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\rU\"\u0006BB\u0010\u0005_\fQe\u0019:fCR,GK]1og\u0006\u001cG/[8oC2\u0004&o\u001c3vG\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0002K\r\u0014X-\u0019;f)J\fgn]1di&|g.\u00197Qe>$WoY3sI\u0011,g-Y;mi\u0012\"\u0014!J2sK\u0006$X\r\u0016:b]N\f7\r^5p]\u0006d\u0007K]8ek\u000e,'\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0003\rj\u0017-\u001f2f/\u0006LGOR8s\u0003RdU-Y:u\u001f:,7+Z4nK:$X\u000b\u001d7pC\u0012$B!a\u000e\u0004B!911I\u001eA\u0002\r\u0015\u0013a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0011\u000b5\u001b9ea\u0013\n\u0007\r%cJ\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u0002Ba!\u0014\u0004T5\u00111q\n\u0006\u0004\u0007#:\u0018AB2p[6|g.\u0003\u0003\u0004V\r=#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c")
public class TransactionsTest
extends IntegrationTestHarness {
    private final int transactionalProducerCount;
    private final int transactionalConsumerCount;
    private final int nonTransactionalConsumerCount;
    private final String topic1;
    private final String topic2;
    private final int numPartitions;
    private final Buffer<KafkaProducer<byte[], byte[]>> transactionalProducers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final Buffer<Consumer<byte[], byte[]>> transactionalConsumers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final Buffer<Consumer<byte[], byte[]>> nonTransactionalConsumers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);

    @Override
    public int brokerCount() {
        return 3;
    }

    public int transactionalProducerCount() {
        return this.transactionalProducerCount;
    }

    public int transactionalConsumerCount() {
        return this.transactionalConsumerCount;
    }

    public int nonTransactionalConsumerCount() {
        return this.nonTransactionalConsumerCount;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public Buffer<KafkaProducer<byte[], byte[]>> transactionalProducers() {
        return this.transactionalProducers;
    }

    public Buffer<Consumer<byte[], byte[]>> transactionalConsumers() {
        return this.transactionalConsumers;
    }

    public Buffer<Consumer<byte[], byte[]>> nonTransactionalConsumers() {
        return this.nonTransactionalConsumers;
    }

    public Properties overridingProps() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), Boolean.toString(false));
        props.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), Integer.toString(1));
        props.put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), Integer.toString(3));
        props.put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), Integer.toString(2));
        props.put(KafkaConfig$.MODULE$.TransactionsTopicMinISRProp(), Integer.toString(2));
        props.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), Boolean.toString(true));
        props.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), Boolean.toString(false));
        props.put(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), Boolean.toString(false));
        props.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        props.put(KafkaConfig$.MODULE$.TransactionsAbortTimedOutTransactionCleanupIntervalMsProp(), "200");
        return props;
    }

    @Override
    public void modifyConfigs(Seq<Properties> props) {
        props.foreach((Function1 & Serializable)p -> {
            p.putAll((java.util.Map<?, ?>)this.overridingProps());
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Seq<Properties> kraftControllerConfigs() {
        return new .colon.colon((Object)this.overridingProps(), (List)Nil$.MODULE$);
    }

    public Properties topicConfig() {
        Properties topicConfig = new Properties();
        topicConfig.put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), Integer.toString(2));
        return topicConfig;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.createTopic(this.topic1(), this.numPartitions(), this.brokerCount(), this.topicConfig(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(this.topic2(), this.numPartitions(), this.brokerCount(), this.topicConfig(), this.createTopic$default$5(), this.createTopic$default$6());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.transactionalProducerCount()).foreach((Function1 & Serializable)x$1 -> this.createTransactionalProducer("transactional-producer", 60000L, 60000L, 120000, 30000));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.transactionalConsumerCount()).foreach((Function1 & Serializable)x$2 -> this.createReadCommittedConsumer("transactional-group", 500, new Properties()));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.nonTransactionalConsumerCount()).foreach((Function1 & Serializable)x$3 -> this.createReadUncommittedConsumer("non-transactional-group"));
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.transactionalProducers().foreach((Function1 & Serializable)x$4 -> {
            x$4.close();
            return BoxedUnit.UNIT;
        });
        this.transactionalConsumers().foreach((Function1 & Serializable)x$5 -> {
            x$5.close();
            return BoxedUnit.UNIT;
        });
        this.nonTransactionalConsumers().foreach((Function1 & Serializable)x$6 -> {
            x$6.close();
            return BoxedUnit.UNIT;
        });
        super.tearDown();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testBasicTransactions(String quorum) {
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        Consumer consumer = (Consumer)this.transactionalConsumers().head();
        Consumer unCommittedConsumer = (Consumer)this.nonTransactionalConsumers().head();
        TopicPartition tp11 = new TopicPartition(this.topic1(), 1);
        TopicPartition tp22 = new TopicPartition(this.topic2(), 2);
        producer.initTransactions();
        producer.beginTransaction();
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), Predef$.MODULE$.int2Integer(2), "2", "2", false));
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(1), "4", "4", false));
        producer.flush();
        producer.abortTransaction();
        producer.beginTransaction();
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(1), "1", "1", true));
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), Predef$.MODULE$.int2Integer(2), "3", "3", true));
        producer.commitTransaction();
        this.maybeWaitForAtLeastOneSegmentUpload((scala.collection.immutable.Seq<TopicPartition>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp11, tp22}));
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        unCommittedConsumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        TestUtils$.MODULE$.consumeRecords(consumer, 2, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
        Seq allRecords = TestUtils$.MODULE$.consumeRecords(unCommittedConsumer, 4, 15000L);
        scala.collection.immutable.Set expectedValues = new .colon.colon((Object)"1", (List)new .colon.colon((Object)"2", (List)new .colon.colon((Object)"3", (List)new .colon.colon((Object)"4", (List)Nil$.MODULE$)))).toSet();
        allRecords.foreach((Function1 & Serializable)record -> {
            TransactionsTest.$anonfun$testBasicTransactions$2(expectedValues, record);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testReadCommittedConsumerShouldNotSeeUndecidedData(String quorum) {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().head();
        KafkaProducer<byte[], byte[]> producer2 = this.createTransactionalProducer("other", 60000L, 60000L, 120000, 30000);
        Consumer readCommittedConsumer = (Consumer)this.transactionalConsumers().head();
        Consumer readUncommittedConsumer = (Consumer)this.nonTransactionalConsumers().head();
        producer1.initTransactions();
        producer2.initTransactions();
        producer1.beginTransaction();
        producer2.beginTransaction();
        long latestVisibleTimestamp = System.currentTimeMillis();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestVisibleTimestamp), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestVisibleTimestamp), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.flush();
        long latestWrittenTimestamp = latestVisibleTimestamp + 1L;
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"a".getBytes(), (Object)"1".getBytes()));
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"b".getBytes(), (Object)"2".getBytes()));
        producer1.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"c".getBytes(), (Object)"3".getBytes()));
        producer1.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"d".getBytes(), (Object)"4".getBytes()));
        producer1.flush();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.commitTransaction();
        TopicPartition tp1 = new TopicPartition(this.topic1(), 0);
        TopicPartition tp2 = new TopicPartition(this.topic2(), 0);
        readUncommittedConsumer.assign((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
        TestUtils$.MODULE$.consumeRecords(readUncommittedConsumer, 8, 15000L);
        java.util.Map readUncommittedOffsetsForTimes = readUncommittedConsumer.offsetsForTimes(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)Predef$.MODULE$.long2Long(latestWrittenTimestamp)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)Predef$.MODULE$.long2Long(latestWrittenTimestamp))}))).asJava());
        Assertions.assertEquals((int)2, (int)readUncommittedOffsetsForTimes.size());
        Assertions.assertEquals((long)latestWrittenTimestamp, (long)((OffsetAndTimestamp)readUncommittedOffsetsForTimes.get(tp1)).timestamp());
        Assertions.assertEquals((long)latestWrittenTimestamp, (long)((OffsetAndTimestamp)readUncommittedOffsetsForTimes.get(tp2)).timestamp());
        readUncommittedConsumer.unsubscribe();
        readCommittedConsumer.assign((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
        TestUtils$.MODULE$.consumeRecords(readCommittedConsumer, 2, 15000L).foreach((Function1 & Serializable)record -> {
            TransactionsTest.$anonfun$testReadCommittedConsumerShouldNotSeeUndecidedData$1(record);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)2, (int)readCommittedConsumer.assignment().size());
        readCommittedConsumer.seekToEnd((Collection)readCommittedConsumer.assignment());
        readCommittedConsumer.assignment().forEach(tp -> Assertions.assertEquals((long)1L, (long)readCommittedConsumer.position(tp)));
        java.util.Map readCommittedOffsetsForTimes = readCommittedConsumer.offsetsForTimes(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)Predef$.MODULE$.long2Long(latestWrittenTimestamp)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)Predef$.MODULE$.long2Long(latestWrittenTimestamp))}))).asJava());
        Assertions.assertNull(readCommittedOffsetsForTimes.get(tp1));
        Assertions.assertNull(readCommittedOffsetsForTimes.get(tp2));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDelayedFetchIncludesAbortedTransaction(String quorum) {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().head();
        KafkaProducer<byte[], byte[]> producer2 = this.createTransactionalProducer("other", 60000L, 60000L, 120000, 30000);
        TopicPartition tp10 = new TopicPartition(this.topic1(), 0);
        producer1.initTransactions();
        producer2.initTransactions();
        producer1.beginTransaction();
        producer2.beginTransaction();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.flush();
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"y".getBytes(), (Object)"1".getBytes()));
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"y".getBytes(), (Object)"2".getBytes()));
        producer1.flush();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.flush();
        producer1.abortTransaction();
        producer2.commitTransaction();
        this.maybeWaitForAtLeastOneSegmentUpload((scala.collection.immutable.Seq<TopicPartition>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp10}));
        Properties consumerProps = new Properties();
        consumerProps.put("fetch.min.bytes", "100000");
        consumerProps.put("fetch.max.wait.ms", "100");
        String x$2 = "group";
        int x$3 = 500;
        Consumer<byte[], byte[]> readCommittedConsumer = this.createReadCommittedConsumer(x$2, x$3, consumerProps);
        readCommittedConsumer.assign((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp10}))).asJava());
        Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.consumeRecords(readCommittedConsumer, 2, 15000L);
        Assertions.assertEquals((int)2, (int)records.size());
        ConsumerRecord first = (ConsumerRecord)records.head();
        Assertions.assertEquals((Object)"x", (Object)new String((byte[])first.key()));
        Assertions.assertEquals((Object)"1", (Object)new String((byte[])first.value()));
        Assertions.assertEquals((long)0L, (long)first.offset());
        ConsumerRecord second = (ConsumerRecord)records.last();
        Assertions.assertEquals((Object)"x", (Object)new String((byte[])second.key()));
        Assertions.assertEquals((Object)"2", (Object)new String((byte[])second.value()));
        Assertions.assertEquals((long)3L, (long)second.offset());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSendOffsetsWithGroupId(String quorum) {
        String sendOffset_consumerGroupId = "foobar-consumer-group";
        int sendOffset_numSeedMessages = 500;
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.topic1(), sendOffset_numSeedMessages, this.brokers());
        KafkaProducer sendOffset_producer = (KafkaProducer)this.transactionalProducers().head();
        Consumer<byte[], byte[]> sendOffset_consumer = this.createReadCommittedConsumer(sendOffset_consumerGroupId, sendOffset_numSeedMessages / 4, new Properties());
        sendOffset_consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        sendOffset_producer.initTransactions();
        BooleanRef sendOffset_shouldCommit = BooleanRef.create((boolean)false);
        IntRef sendOffset_recordsProcessed = IntRef.create((int)0);
        try {
            while (sendOffset_recordsProcessed.elem < sendOffset_numSeedMessages) {
                Seq<ConsumerRecord<byte[], byte[]>> sendOffset_records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(sendOffset_consumer, Math.min(10, sendOffset_numSeedMessages - sendOffset_recordsProcessed.elem), 15000L);
                sendOffset_producer.beginTransaction();
                sendOffset_shouldCommit.elem = !sendOffset_shouldCommit.elem;
                sendOffset_records.foreach((Function1 & Serializable)record -> {
                    String key = new String((byte[])record.key(), StandardCharsets.UTF_8);
                    String value = new String((byte[])record.value(), StandardCharsets.UTF_8);
                    return sendOffset_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, key, value, shouldCommit$1.elem));
                });
                sendOffset_producer.sendOffsetsToTransaction(CollectionConverters$.MODULE$.MapHasAsJava(TestUtils$.MODULE$.consumerPositions((Consumer<byte[], byte[]>)sendOffset_consumer)).asJava(), sendOffset_consumerGroupId);
                if (sendOffset_shouldCommit.elem) {
                    sendOffset_producer.commitTransaction();
                    sendOffset_recordsProcessed.elem += sendOffset_records.size();
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(74).append("committed transaction.. Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                    continue;
                }
                sendOffset_producer.abortTransaction();
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(70).append("aborted transaction Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                TestUtils$.MODULE$.resetToCommittedPositions(sendOffset_consumer);
            }
        }
        finally {
            sendOffset_consumer.close();
        }
        ListBuffer sendOffset_partitions = ListBuffer$.MODULE$.empty();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach((Function1 & Serializable)partition -> TransactionsTest.$anonfun$sendOffset$4(this, sendOffset_partitions, BoxesRunTime.unboxToInt((Object)partition)));
        this.maybeWaitForAtLeastOneSegmentUpload((scala.collection.immutable.Seq<TopicPartition>)sendOffset_partitions.toSeq());
        Consumer sendOffset_verifyingConsumer = (Consumer)this.transactionalConsumers().apply(0);
        sendOffset_verifyingConsumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava());
        Seq sendOffset_valueSeq = (Seq)TestUtils$.MODULE$.pollUntilAtLeastNumRecords(sendOffset_verifyingConsumer, sendOffset_numSeedMessages, 15000L).map((Function1 & Serializable)record -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record)))));
        scala.collection.immutable.Set sendOffset_valueSet = sendOffset_valueSeq.toSet();
        Assertions.assertEquals((int)sendOffset_numSeedMessages, (int)sendOffset_valueSeq.size(), (String)new StringBuilder(21).append("Expected ").append(sendOffset_numSeedMessages).append(" values in ").append(this.topic2()).append(".").toString());
        Assertions.assertEquals((int)sendOffset_valueSeq.size(), (int)sendOffset_valueSet.size(), (String)new StringBuilder(30).append("Expected ").append(sendOffset_valueSeq.size()).append(" unique messages in ").append(this.topic2()).append(".").toString());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSendOffsetsWithGroupMetadata(String quorum) {
        String sendOffset_consumerGroupId = "foobar-consumer-group";
        int sendOffset_numSeedMessages = 500;
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.topic1(), sendOffset_numSeedMessages, this.brokers());
        KafkaProducer sendOffset_producer = (KafkaProducer)this.transactionalProducers().head();
        Consumer<byte[], byte[]> sendOffset_consumer = this.createReadCommittedConsumer(sendOffset_consumerGroupId, sendOffset_numSeedMessages / 4, new Properties());
        sendOffset_consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        sendOffset_producer.initTransactions();
        BooleanRef sendOffset_shouldCommit = BooleanRef.create((boolean)false);
        IntRef sendOffset_recordsProcessed = IntRef.create((int)0);
        try {
            while (sendOffset_recordsProcessed.elem < sendOffset_numSeedMessages) {
                Seq<ConsumerRecord<byte[], byte[]>> sendOffset_records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(sendOffset_consumer, Math.min(10, sendOffset_numSeedMessages - sendOffset_recordsProcessed.elem), 15000L);
                sendOffset_producer.beginTransaction();
                sendOffset_shouldCommit.elem = !sendOffset_shouldCommit.elem;
                sendOffset_records.foreach((Function1 & Serializable)record -> {
                    String key = new String((byte[])record.key(), StandardCharsets.UTF_8);
                    String value = new String((byte[])record.value(), StandardCharsets.UTF_8);
                    return sendOffset_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, key, value, shouldCommit$1.elem));
                });
                sendOffset_producer.sendOffsetsToTransaction(CollectionConverters$.MODULE$.MapHasAsJava(TestUtils$.MODULE$.consumerPositions((Consumer<byte[], byte[]>)sendOffset_consumer)).asJava(), sendOffset_consumer.groupMetadata());
                if (sendOffset_shouldCommit.elem) {
                    sendOffset_producer.commitTransaction();
                    sendOffset_recordsProcessed.elem += sendOffset_records.size();
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(74).append("committed transaction.. Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                    continue;
                }
                sendOffset_producer.abortTransaction();
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(70).append("aborted transaction Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                TestUtils$.MODULE$.resetToCommittedPositions(sendOffset_consumer);
            }
        }
        finally {
            sendOffset_consumer.close();
        }
        ListBuffer sendOffset_partitions = ListBuffer$.MODULE$.empty();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach((Function1 & Serializable)partition -> TransactionsTest.$anonfun$sendOffset$4(this, sendOffset_partitions, BoxesRunTime.unboxToInt((Object)partition)));
        this.maybeWaitForAtLeastOneSegmentUpload((scala.collection.immutable.Seq<TopicPartition>)sendOffset_partitions.toSeq());
        Consumer sendOffset_verifyingConsumer = (Consumer)this.transactionalConsumers().apply(0);
        sendOffset_verifyingConsumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava());
        Seq sendOffset_valueSeq = (Seq)TestUtils$.MODULE$.pollUntilAtLeastNumRecords(sendOffset_verifyingConsumer, sendOffset_numSeedMessages, 15000L).map((Function1 & Serializable)record -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record)))));
        scala.collection.immutable.Set sendOffset_valueSet = sendOffset_valueSeq.toSet();
        Assertions.assertEquals((int)sendOffset_numSeedMessages, (int)sendOffset_valueSeq.size(), (String)new StringBuilder(21).append("Expected ").append(sendOffset_numSeedMessages).append(" values in ").append(this.topic2()).append(".").toString());
        Assertions.assertEquals((int)sendOffset_valueSeq.size(), (int)sendOffset_valueSet.size(), (String)new StringBuilder(30).append("Expected ").append(sendOffset_valueSeq.size()).append(" unique messages in ").append(this.topic2()).append(".").toString());
    }

    private void sendOffset(Function3<KafkaProducer<byte[], byte[]>, String, Consumer<byte[], byte[]>, BoxedUnit> commit) {
        String consumerGroupId = "foobar-consumer-group";
        int numSeedMessages = 500;
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.topic1(), numSeedMessages, this.brokers());
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        Consumer<byte[], byte[]> consumer = this.createReadCommittedConsumer(consumerGroupId, numSeedMessages / 4, new Properties());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        producer.initTransactions();
        BooleanRef shouldCommit = BooleanRef.create((boolean)false);
        IntRef recordsProcessed = IntRef.create((int)0);
        try {
            while (recordsProcessed.elem < numSeedMessages) {
                Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, Math.min(10, numSeedMessages - recordsProcessed.elem), 15000L);
                producer.beginTransaction();
                shouldCommit.elem = !shouldCommit.elem;
                records.foreach((Function1 & Serializable)record -> {
                    String key = new String((byte[])record.key(), StandardCharsets.UTF_8);
                    String value = new String((byte[])record.value(), StandardCharsets.UTF_8);
                    return sendOffset_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, key, value, shouldCommit$1.elem));
                });
                commit.apply((Object)producer, (Object)consumerGroupId, consumer);
                if (shouldCommit.elem) {
                    producer.commitTransaction();
                    recordsProcessed.elem += records.size();
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(74).append("committed transaction.. Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                    continue;
                }
                producer.abortTransaction();
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(70).append("aborted transaction Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                TestUtils$.MODULE$.resetToCommittedPositions(consumer);
            }
        }
        finally {
            consumer.close();
        }
        ListBuffer partitions = ListBuffer$.MODULE$.empty();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach((Function1 & Serializable)partition -> TransactionsTest.$anonfun$sendOffset$4(this, sendOffset_partitions, BoxesRunTime.unboxToInt((Object)partition)));
        this.maybeWaitForAtLeastOneSegmentUpload((scala.collection.immutable.Seq<TopicPartition>)partitions.toSeq());
        Consumer verifyingConsumer = (Consumer)this.transactionalConsumers().apply(0);
        verifyingConsumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava());
        Seq valueSeq = (Seq)TestUtils$.MODULE$.pollUntilAtLeastNumRecords(verifyingConsumer, numSeedMessages, 15000L).map((Function1 & Serializable)record -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record)))));
        scala.collection.immutable.Set valueSet = valueSeq.toSet();
        Assertions.assertEquals((int)numSeedMessages, (int)valueSeq.size(), (String)new StringBuilder(21).append("Expected ").append(numSeedMessages).append(" values in ").append(this.topic2()).append(".").toString());
        Assertions.assertEquals((int)valueSeq.size(), (int)valueSet.size(), (String)new StringBuilder(30).append("Expected ").append(valueSeq.size()).append(" unique messages in ").append(this.topic2()).append(".").toString());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testFencingOnCommit(String quorum) {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        Consumer consumer = (Consumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true));
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true));
        Assertions.assertThrows(ProducerFencedException.class, () -> producer1.commitTransaction());
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testFencingOnSendOffsets(String quorum) {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        Consumer consumer = (Consumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer1.flush();
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true));
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true));
        Assertions.assertThrows(ProducerFencedException.class, () -> producer1.sendOffsetsToTransaction(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foobartopic", 0)), (Object)new OffsetAndMetadata(110L))}))).asJava(), new ConsumerGroupMetadata("foobarGroup")));
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testOffsetMetadataInSendOffsetsToTransaction(String quorum) {
        TopicPartition tp = new TopicPartition(this.topic1(), 0);
        String groupId = "group";
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        Consumer<byte[], byte[]> consumer = this.createReadCommittedConsumer(groupId, 500, new Properties());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        producer.initTransactions();
        producer.beginTransaction();
        OffsetAndMetadata offsetAndMetadata = new OffsetAndMetadata(110L, Optional.of(Predef$.MODULE$.int2Integer(15)), "some metadata");
        producer.sendOffsetsToTransaction(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)offsetAndMetadata)}))).asJava(), new ConsumerGroupMetadata(groupId));
        producer.commitTransaction();
        ((KafkaProducer)this.transactionalProducers().apply(1)).initTransactions();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!offsetAndMetadata.equals(consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava()).get(tp))) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"cannot read committed offset");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testInitTransactionsTimeout(String quorum) {
        Function1 & Serializable testTimeout_timeoutProcess = (Function1 & Serializable)producer -> {
            producer.initTransactions();
            return BoxedUnit.UNIT;
        };
        boolean testTimeout_needInitAndSendMsg = false;
        long testTimeout_x$3 = 60000L;
        int testTimeout_x$4 = 120000;
        int testTimeout_x$5 = 30000;
        KafkaProducer<byte[], byte[]> testTimeout_producer = this.createTransactionalProducer("transactionProducer", testTimeout_x$3, 3000L, testTimeout_x$4, testTimeout_x$5);
        if (testTimeout_needInitAndSendMsg) {
            testTimeout_producer.initTransactions();
            testTimeout_producer.beginTransaction();
            testTimeout_producer.send(new ProducerRecord(this.topic1(), (Object)"foo".getBytes(), (Object)"bar".getBytes()));
        }
        this.brokers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.killBroker(i));
        Assertions.assertThrows(TimeoutException.class, () -> testTimeout_timeoutProcess.apply((Object)testTimeout_producer));
        testTimeout_producer.close(Duration.ZERO);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSendOffsetsToTransactionTimeout(String quorum) {
        Function1 & Serializable testTimeout_timeoutProcess = (Function1 & Serializable)producer -> {
            producer.sendOffsetsToTransaction(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic1(), 0)), (Object)new OffsetAndMetadata(0L))}))).asJava(), new ConsumerGroupMetadata("test-group"));
            return BoxedUnit.UNIT;
        };
        boolean testTimeout_needInitAndSendMsg = true;
        long testTimeout_x$3 = 60000L;
        int testTimeout_x$4 = 120000;
        int testTimeout_x$5 = 30000;
        KafkaProducer<byte[], byte[]> testTimeout_producer = this.createTransactionalProducer("transactionProducer", testTimeout_x$3, 3000L, testTimeout_x$4, testTimeout_x$5);
        if (testTimeout_needInitAndSendMsg) {
            testTimeout_producer.initTransactions();
            testTimeout_producer.beginTransaction();
            testTimeout_producer.send(new ProducerRecord(this.topic1(), (Object)"foo".getBytes(), (Object)"bar".getBytes()));
        }
        this.brokers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.killBroker(i));
        Assertions.assertThrows(TimeoutException.class, () -> testTimeout_timeoutProcess.apply((Object)testTimeout_producer));
        testTimeout_producer.close(Duration.ZERO);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCommitTransactionTimeout(String quorum) {
        Function1 & Serializable testTimeout_timeoutProcess = (Function1 & Serializable)producer -> {
            producer.commitTransaction();
            return BoxedUnit.UNIT;
        };
        boolean testTimeout_needInitAndSendMsg = true;
        long testTimeout_x$3 = 60000L;
        int testTimeout_x$4 = 120000;
        int testTimeout_x$5 = 30000;
        KafkaProducer<byte[], byte[]> testTimeout_producer = this.createTransactionalProducer("transactionProducer", testTimeout_x$3, 3000L, testTimeout_x$4, testTimeout_x$5);
        if (testTimeout_needInitAndSendMsg) {
            testTimeout_producer.initTransactions();
            testTimeout_producer.beginTransaction();
            testTimeout_producer.send(new ProducerRecord(this.topic1(), (Object)"foo".getBytes(), (Object)"bar".getBytes()));
        }
        this.brokers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.killBroker(i));
        Assertions.assertThrows(TimeoutException.class, () -> testTimeout_timeoutProcess.apply((Object)testTimeout_producer));
        testTimeout_producer.close(Duration.ZERO);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAbortTransactionTimeout(String quorum) {
        Function1 & Serializable testTimeout_timeoutProcess = (Function1 & Serializable)producer -> {
            producer.abortTransaction();
            return BoxedUnit.UNIT;
        };
        boolean testTimeout_needInitAndSendMsg = true;
        long testTimeout_x$3 = 60000L;
        int testTimeout_x$4 = 120000;
        int testTimeout_x$5 = 30000;
        KafkaProducer<byte[], byte[]> testTimeout_producer = this.createTransactionalProducer("transactionProducer", testTimeout_x$3, 3000L, testTimeout_x$4, testTimeout_x$5);
        if (testTimeout_needInitAndSendMsg) {
            testTimeout_producer.initTransactions();
            testTimeout_producer.beginTransaction();
            testTimeout_producer.send(new ProducerRecord(this.topic1(), (Object)"foo".getBytes(), (Object)"bar".getBytes()));
        }
        this.brokers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.killBroker(i));
        Assertions.assertThrows(TimeoutException.class, () -> testTimeout_timeoutProcess.apply((Object)testTimeout_producer));
        testTimeout_producer.close(Duration.ZERO);
    }

    private void testTimeout(boolean needInitAndSendMsg, Function1<KafkaProducer<byte[], byte[]>, BoxedUnit> timeoutProcess) {
        long x$3 = 60000L;
        int x$4 = 120000;
        int x$5 = 30000;
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("transactionProducer", x$3, 3000L, x$4, x$5);
        if (needInitAndSendMsg) {
            producer.initTransactions();
            producer.beginTransaction();
            producer.send(new ProducerRecord(this.topic1(), (Object)"foo".getBytes(), (Object)"bar".getBytes()));
        }
        this.brokers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.killBroker(i));
        Assertions.assertThrows(TimeoutException.class, () -> testTimeout_timeoutProcess.apply((Object)testTimeout_producer));
        producer.close(Duration.ZERO);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testFencingOnSend(String quorum) {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        Consumer consumer = (Consumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true)).get();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true)).get();
        try {
            RecordMetadata recordMetadata = (RecordMetadata)producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "5", false)).get();
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Missed a producer fenced exception when writing to ").append(recordMetadata.topic()).append("-").append(recordMetadata.partition()).append(". Grab the logs!!").toString());
            this.brokers().foreach((Function1 & Serializable)broker -> {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(10).append("log dirs: ").append(((IterableOps)broker.logManager().liveLogDirs().map((Function1 & Serializable)x$8 -> x$8.getAbsolutePath())).head()).toString());
                return BoxedUnit.UNIT;
            });
            Assertions.fail((String)"Should not be able to send messages from a fenced producer.");
        }
        catch (ProducerFencedException producerFencedException) {
            producer1.close();
        }
        catch (ExecutionException executionException) {
            Assertions.assertTrue((boolean)(executionException.getCause() instanceof InvalidProducerEpochException));
        }
        catch (Exception e) {
            throw new AssertionError("Got an unexpected exception from a fenced producer.", e);
        }
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testFencingOnAddPartitions(String quorum) {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        Consumer consumer = (Consumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer1.abortTransaction();
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true)).get(20L, TimeUnit.SECONDS);
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true)).get(20L, TimeUnit.SECONDS);
        try {
            producer1.beginTransaction();
            RecordMetadata recordMetadata = (RecordMetadata)producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "5", false)).get();
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Missed a producer fenced exception when writing to ").append(recordMetadata.topic()).append("-").append(recordMetadata.partition()).append(". Grab the logs!!").toString());
            this.brokers().foreach((Function1 & Serializable)broker -> {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(10).append("log dirs: ").append(((IterableOps)broker.logManager().liveLogDirs().map((Function1 & Serializable)x$9 -> x$9.getAbsolutePath())).head()).toString());
                return BoxedUnit.UNIT;
            });
            Assertions.fail((String)"Should not be able to send messages from a fenced producer.");
        }
        catch (ProducerFencedException producerFencedException) {
        }
        catch (ExecutionException executionException) {
            Assertions.assertTrue((boolean)(executionException.getCause() instanceof ProducerFencedException));
        }
        catch (Exception e) {
            throw new AssertionError("Got an unexpected exception from a fenced producer.", e);
        }
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testFencingOnTransactionExpiration(String quorum) {
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("expiringProducer", 100L, 60000L, 120000, 30000);
        producer.initTransactions();
        producer.beginTransaction();
        Assertions.assertTrue((boolean)((RecordMetadata)producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false)).get()).hasOffset());
        Thread.sleep(600L);
        try {
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "2", false)).get();
            Assertions.fail((String)"should have raised a ProducerFencedException since the transaction has expired");
        }
        catch (ProducerFencedException producerFencedException) {
        }
        catch (ExecutionException executionException) {
            Assertions.assertTrue((boolean)(executionException.getCause() instanceof ProducerFencedException));
        }
        Consumer nonTransactionalConsumer = (Consumer)this.nonTransactionalConsumers().head();
        nonTransactionalConsumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        Seq records = TestUtils$.MODULE$.consumeRecords(nonTransactionalConsumer, 1, 15000L);
        Assertions.assertEquals((int)1, (int)records.size());
        Assertions.assertEquals((Object)"1", (Object)TestUtils$.MODULE$.recordValueAsString((ConsumerRecord<byte[], byte[]>)((ConsumerRecord)records.head())));
        Consumer transactionalConsumer = (Consumer)this.transactionalConsumers().head();
        transactionalConsumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertTrue((boolean)TestUtils$.MODULE$.consumeRecordsFor(transactionalConsumer, 1000L).isEmpty());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testMultipleMarkersOneLeader(String quorum) {
        KafkaProducer firstProducer = (KafkaProducer)this.transactionalProducers().head();
        Consumer consumer = (Consumer)this.transactionalConsumers().head();
        Consumer unCommittedConsumer = (Consumer)this.nonTransactionalConsumers().head();
        String topicWith10Partitions = "largeTopic";
        String topicWith10PartitionsAndOneReplica = "largeTopicOneReplica";
        this.createTopic(topicWith10Partitions, 10, this.brokerCount(), this.topicConfig(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(topicWith10PartitionsAndOneReplica, 10, 1, new Properties(), this.createTopic$default$5(), this.createTopic$default$6());
        firstProducer.initTransactions();
        firstProducer.beginTransaction();
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10Partitions, 0, 5000, false);
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10PartitionsAndOneReplica, 5000, 10000, false);
        firstProducer.abortTransaction();
        firstProducer.beginTransaction();
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10Partitions, 10000, 11000, true);
        firstProducer.commitTransaction();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topicWith10PartitionsAndOneReplica, (List)new .colon.colon((Object)topicWith10Partitions, (List)Nil$.MODULE$))).asJava());
        unCommittedConsumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topicWith10PartitionsAndOneReplica, (List)new .colon.colon((Object)topicWith10Partitions, (List)Nil$.MODULE$))).asJava());
        TestUtils$.MODULE$.consumeRecords(consumer, 1000, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
        Seq allRecords = TestUtils$.MODULE$.consumeRecords(unCommittedConsumer, 11000, 15000L);
        scala.collection.immutable.Set expectedValues = package$.MODULE$.Range().apply(0, 11000).map((Function1 & Serializable)x$10 -> TransactionsTest.$anonfun$testMultipleMarkersOneLeader$2(BoxesRunTime.unboxToInt((Object)x$10))).toSet();
        allRecords.foreach((Function1 & Serializable)record -> {
            TransactionsTest.$anonfun$testMultipleMarkersOneLeader$3(expectedValues, record);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testConsecutivelyRunInitTransactions(String quorum) {
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("normalProducer", 60000L, 60000L, 120000, 30000);
        producer.initTransactions();
        Assertions.assertThrows(IllegalStateException.class, () -> producer.initTransactions());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testBumpTransactionalEpoch(String quorum) {
        long x$4 = 60000L;
        long x$5 = 60000L;
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("transactionalProducer", x$4, x$5, 5000, 5000);
        Consumer consumer = (Consumer)this.transactionalConsumers().head();
        try {
            String testTopic = "test-topic";
            this.createTopic(testTopic, this.numPartitions(), 1, new Properties(), this.createTopic$default$5(), this.createTopic$default$6());
            int partitionLeader = TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.brokers(), new TopicPartition(testTopic, 0), 15000L);
            producer.initTransactions();
            producer.beginTransaction();
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "4", "4", true));
            producer.commitTransaction();
            LogManager qual$1 = ((KafkaBroker)this.brokers().apply(partitionLeader)).logManager();
            TopicPartition x$6 = new TopicPartition(testTopic, 0);
            boolean x$7 = qual$1.getLog$default$2();
            Iterator activeProducersIter = ((UnifiedLog)qual$1.getLog(x$6, x$7).get()).producerStateManager().activeProducers().entrySet().iterator();
            Assertions.assertTrue((boolean)activeProducersIter.hasNext());
            ProducerStateEntry producerStateEntry = (ProducerStateEntry)activeProducersIter.next().getValue();
            long producerId = producerStateEntry.producerId();
            short initialProducerEpoch = producerStateEntry.producerEpoch();
            producer.beginTransaction();
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "2", false));
            this.killBroker(partitionLeader);
            Future failedFuture = producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "3", "3", false));
            Thread.sleep(6000L);
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
            TestUtils.assertFutureThrows((Future)failedFuture, TimeoutException.class);
            producer.abortTransaction();
            producer.beginTransaction();
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "2", true));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "4", "4", true));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "1", "1", true));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "3", "3", true));
            producer.commitTransaction();
            consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)new .colon.colon((Object)testTopic, (List)Nil$.MODULE$)))).asJava());
            TestUtils$.MODULE$.consumeRecords(consumer, 5, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
            LogManager qual$2 = ((KafkaBroker)this.brokers().apply(partitionLeader)).logManager();
            TopicPartition x$8 = new TopicPartition(testTopic, 0);
            boolean x$9 = qual$2.getLog$default$2();
            producerStateEntry = (ProducerStateEntry)((UnifiedLog)qual$2.getLog(x$8, x$9).get()).producerStateManager().activeProducers().get(BoxesRunTime.boxToLong((long)producerId));
            Assertions.assertNotNull((Object)producerStateEntry);
            Assertions.assertTrue((producerStateEntry.producerEpoch() > initialProducerEpoch ? 1 : 0) != 0);
        }
        finally {
            producer.close(Duration.ZERO);
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testFailureToFenceEpoch(String quorum) {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().head();
        long x$3 = 60000L;
        int x$4 = 120000;
        int x$5 = 30000;
        KafkaProducer<byte[], byte[]> producer2 = this.createTransactionalProducer("transactional-producer", x$3, 1000L, x$4, x$5);
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(0), "4", "4", true));
        producer1.commitTransaction();
        int partitionLeader = TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.brokers(), new TopicPartition(this.topic1(), 0), 15000L);
        LogManager qual$1 = ((KafkaBroker)this.brokers().apply(partitionLeader)).logManager();
        TopicPartition x$6 = new TopicPartition(this.topic1(), 0);
        boolean x$7 = qual$1.getLog$default$2();
        Iterator activeProducersIter = ((UnifiedLog)qual$1.getLog(x$6, x$7).get()).producerStateManager().activeProducers().entrySet().iterator();
        Assertions.assertTrue((boolean)activeProducersIter.hasNext());
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)activeProducersIter.next().getValue();
        long producerId = producerStateEntry.producerId();
        short initialProducerEpoch = producerStateEntry.producerEpoch();
        this.killBroker(0);
        this.killBroker(1);
        try {
            try {
                producer2.initTransactions();
            }
            catch (TimeoutException timeoutException) {
            }
            catch (Exception e) {
                throw new AssertionError("Got an unexpected exception from initTransactions", e);
            }
        }
        finally {
            producer2.close();
        }
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        try {
            try {
                producer1.beginTransaction();
            }
            catch (ProducerFencedException producerFencedException) {
            }
            catch (Exception e) {
                throw new AssertionError("Got an unexpected exception from commitTransaction", e);
            }
        }
        finally {
            producer1.close();
        }
        long x$10 = 60000L;
        int x$11 = 120000;
        int x$12 = 30000;
        KafkaProducer<byte[], byte[]> producer3 = this.createTransactionalProducer("transactional-producer", x$10, 5000L, x$11, x$12);
        producer3.initTransactions();
        producer3.beginTransaction();
        producer3.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(0), "4", "4", true));
        producer3.commitTransaction();
        LogManager qual$2 = ((KafkaBroker)this.brokers().apply(partitionLeader)).logManager();
        TopicPartition x$13 = new TopicPartition(this.topic1(), 0);
        boolean x$14 = qual$2.getLog$default$2();
        producerStateEntry = (ProducerStateEntry)((UnifiedLog)qual$2.getLog(x$13, x$14).get()).producerStateManager().activeProducers().get(BoxesRunTime.boxToLong((long)producerId));
        Assertions.assertNotNull((Object)producerStateEntry);
        Assertions.assertEquals((short)((short)(initialProducerEpoch + 1)), (short)producerStateEntry.producerEpoch());
    }

    private void sendTransactionalMessagesWithValueRange(KafkaProducer<byte[], byte[]> producer, String topic, int start, int end, boolean willBeCommitted) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(start), end).foreach((Function1 & Serializable)i -> TransactionsTest.$anonfun$sendTransactionalMessagesWithValueRange$1(producer, topic, willBeCommitted, BoxesRunTime.unboxToInt((Object)i)));
        producer.flush();
    }

    private Consumer<byte[], byte[]> createReadCommittedConsumer(String group, int maxPollRecords, Properties props) {
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        String x$6 = "earliest";
        SecurityProtocol x$7 = SecurityProtocol.PLAINTEXT;
        None$ x$8 = None$.MODULE$;
        None$ x$9 = None$.MODULE$;
        ByteArrayDeserializer x$10 = new ByteArrayDeserializer();
        ByteArrayDeserializer x$11 = new ByteArrayDeserializer();
        Consumer consumer = TestUtils$.MODULE$.createConsumer(x$1, group, x$6, false, true, maxPollRecords, x$7, (Option<File>)x$8, (Option<Properties>)x$9, x$10, x$11);
        this.transactionalConsumers().$plus$eq(consumer);
        return consumer;
    }

    private String createReadCommittedConsumer$default$1() {
        return "group";
    }

    private int createReadCommittedConsumer$default$2() {
        return 500;
    }

    private Properties createReadCommittedConsumer$default$3() {
        return new Properties();
    }

    private Consumer<byte[], byte[]> createReadUncommittedConsumer(String group) {
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        String x$4 = "earliest";
        boolean x$5 = false;
        int x$6 = 500;
        SecurityProtocol x$7 = SecurityProtocol.PLAINTEXT;
        None$ x$8 = None$.MODULE$;
        None$ x$9 = None$.MODULE$;
        ByteArrayDeserializer x$10 = new ByteArrayDeserializer();
        ByteArrayDeserializer x$11 = new ByteArrayDeserializer();
        Consumer consumer = TestUtils$.MODULE$.createConsumer(x$1, group, x$4, false, x$5, x$6, x$7, (Option<File>)x$8, (Option<Properties>)x$9, x$10, x$11);
        this.nonTransactionalConsumers().$plus$eq(consumer);
        return consumer;
    }

    private KafkaProducer<byte[], byte[]> createTransactionalProducer(String transactionalId, long transactionTimeoutMs, long maxBlockMs, int deliveryTimeoutMs, int requestTimeoutMs) {
        Buffer<KafkaBroker> x$2 = this.brokers();
        int x$7 = 16384;
        int x$8 = 5;
        KafkaProducer<byte[], byte[]> producer = TestUtils$.MODULE$.createTransactionalProducer(transactionalId, x$2, x$7, transactionTimeoutMs, maxBlockMs, deliveryTimeoutMs, requestTimeoutMs, x$8);
        this.transactionalProducers().$plus$eq(producer);
        return producer;
    }

    private long createTransactionalProducer$default$2() {
        return 60000L;
    }

    private long createTransactionalProducer$default$3() {
        return 60000L;
    }

    private int createTransactionalProducer$default$4() {
        return 120000;
    }

    private int createTransactionalProducer$default$5() {
        return 30000;
    }

    public void maybeWaitForAtLeastOneSegmentUpload(scala.collection.immutable.Seq<TopicPartition> topicPartitions) {
    }

    public static final /* synthetic */ void $anonfun$testBasicTransactions$2(scala.collection.immutable.Set expectedValues$1, ConsumerRecord record) {
        Assertions.assertTrue((boolean)expectedValues$1.contains((Object)TestUtils$.MODULE$.recordValueAsString((ConsumerRecord<byte[], byte[]>)record)));
    }

    public static final /* synthetic */ void $anonfun$testReadCommittedConsumerShouldNotSeeUndecidedData$1(ConsumerRecord record) {
        Assertions.assertEquals((Object)"x", (Object)new String((byte[])record.key()));
        Assertions.assertEquals((Object)"1", (Object)new String((byte[])record.value()));
    }

    public static final /* synthetic */ ListBuffer $anonfun$sendOffset$4(TransactionsTest $this, ListBuffer partitions$1, int partition) {
        return (ListBuffer)partitions$1.$plus$eq((Object)new TopicPartition($this.topic2(), partition));
    }

    public static final /* synthetic */ String $anonfun$testOffsetMetadataInSendOffsetsToTransaction$2() {
        return "cannot read committed offset";
    }

    public static final /* synthetic */ String $anonfun$testMultipleMarkersOneLeader$2(int x$10) {
        return Integer.toString(x$10);
    }

    public static final /* synthetic */ void $anonfun$testMultipleMarkersOneLeader$3(scala.collection.immutable.Set expectedValues$2, ConsumerRecord record) {
        Assertions.assertTrue((boolean)expectedValues$2.contains((Object)TestUtils$.MODULE$.recordValueAsString((ConsumerRecord<byte[], byte[]>)record)));
    }

    public static final /* synthetic */ Future $anonfun$sendTransactionalMessagesWithValueRange$1(KafkaProducer producer$4, String topic$1, boolean willBeCommitted$1, int i) {
        String x$3 = Integer.toString(i);
        String x$5 = Integer.toString(i);
        return producer$4.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(topic$1, null, x$5, x$3, willBeCommitted$1));
    }

    public TransactionsTest() {
        this.transactionalProducerCount = 2;
        this.transactionalConsumerCount = 1;
        this.nonTransactionalConsumerCount = 1;
        this.topic1 = "topic1";
        this.topic2 = "topic2";
        this.numPartitions = 4;
    }

    public static final /* synthetic */ Object $anonfun$testSendOffsetsWithGroupId$1$adapted(KafkaProducer producer, String groupId, Consumer consumer) {
        producer.sendOffsetsToTransaction(CollectionConverters$.MODULE$.MapHasAsJava(TestUtils$.MODULE$.consumerPositions((Consumer<byte[], byte[]>)consumer)).asJava(), groupId);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSendOffsetsWithGroupMetadata$1$adapted(KafkaProducer producer, String x$7, Consumer consumer) {
        producer.sendOffsetsToTransaction(CollectionConverters$.MODULE$.MapHasAsJava(TestUtils$.MODULE$.consumerPositions((Consumer<byte[], byte[]>)consumer)).asJava(), consumer.groupMetadata());
        return BoxedUnit.UNIT;
    }
}

