/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import kafka.cluster.Partition;
import kafka.server.DelayedRemoteFetch;
import kafka.server.FetchPartitionStatus;
import kafka.server.LogReadResult;
import kafka.server.ReplicaManager;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.FetchParams;
import org.apache.kafka.storage.internals.log.FetchPartitionData;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.RemoteStorageFetchInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\u0005]c\u0001B\u000e\u001d\u0001\u0005BQ\u0001\u000b\u0001\u0005\u0002%Bq\u0001\f\u0001C\u0002\u0013%Q\u0006\u0003\u00042\u0001\u0001\u0006IA\f\u0005\be\u0001\u0011\r\u0011\"\u00034\u0011\u00199\u0004\u0001)A\u0005i!9\u0001\b\u0001b\u0001\n\u0013I\u0004BB#\u0001A\u0003%!\bC\u0004G\u0001\t\u0007I\u0011B$\t\r-\u0003\u0001\u0015!\u0003I\u0011\u001da\u0005A1A\u0005\n\u001dCa!\u0014\u0001!\u0002\u0013A\u0005b\u0002(\u0001\u0005\u0004%Ia\u0014\u0005\u0007=\u0002\u0001\u000b\u0011\u0002)\t\u000f}\u0003!\u0019!C\u0005[!1\u0001\r\u0001Q\u0001\n9Bq!\u0019\u0001C\u0002\u0013%!\r\u0003\u0004g\u0001\u0001\u0006Ia\u0019\u0005\bO\u0002\u0011\r\u0011\"\u0003i\u0011\u0019\u0019\b\u0001)A\u0005S\")A\u000f\u0001C\u0001k\"1\u0011\u0011\u0002\u0001\u0005\u0002UDa!!\u0004\u0001\t\u0003)\bbBA\t\u0001\u0011%\u00111\u0003\u0005\b\u00037\u0001A\u0011BA\u000f\u0011%\ti\u0004AI\u0001\n\u0013\ty\u0004C\u0005\u0002V\u0001\t\n\u0011\"\u0003\u0002@\t1B)\u001a7bs\u0016$'+Z7pi\u00164U\r^2i)\u0016\u001cHO\u0003\u0002\u001e=\u000511/\u001a:wKJT\u0011aH\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0005\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003)\u0002\"a\u000b\u0001\u000e\u0003q\t\u0001\"\\1y\u0005f$Xm]\u000b\u0002]A\u00111eL\u0005\u0003a\u0011\u00121!\u00138u\u0003%i\u0017\r\u001f\"zi\u0016\u001c\b%\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0016\u0003Q\u0002\"aK\u001b\n\u0005Yb\"A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA\u0005\u0001Bo\u001c9jG&#\u0007+\u0019:uSRLwN\\\u000b\u0002uA\u00111hQ\u0007\u0002y)\u0011QHP\u0001\u0007G>lWn\u001c8\u000b\u0005}y$B\u0001!B\u0003\u0019\t\u0007/Y2iK*\t!)A\u0002pe\u001eL!\u0001\u0012\u001f\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0017!\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8oA\u0005Ya-\u001a;dQ>3gm]3u+\u0005A\u0005CA\u0012J\u0013\tQEE\u0001\u0003M_:<\u0017\u0001\u00044fi\u000eDwJ\u001a4tKR\u0004\u0013A\u00047pON#\u0018M\u001d;PM\u001a\u001cX\r^\u0001\u0010Y><7\u000b^1si>3gm]3uA\u0005\u00112-\u001e:sK:$H*Z1eKJ,\u0005o\\2i+\u0005\u0001\u0006cA)W16\t!K\u0003\u0002T)\u0006!Q\u000f^5m\u0015\u0005)\u0016\u0001\u00026bm\u0006L!a\u0016*\u0003\u0011=\u0003H/[8oC2\u0004\"!\u0017/\u000e\u0003iS!a\u0017+\u0002\t1\fgnZ\u0005\u0003;j\u0013q!\u00138uK\u001e,'/A\ndkJ\u0014XM\u001c;MK\u0006$WM]#q_\u000eD\u0007%A\u0005sKBd\u0017nY1JI\u0006Q!/\u001a9mS\u000e\f\u0017\n\u001a\u0011\u0002\u0017\u0019,Go\u00195Ti\u0006$Xo]\u000b\u0002GB\u00111\u0006Z\u0005\u0003Kr\u0011ACR3uG\"\u0004\u0016M\u001d;ji&|gn\u0015;biV\u001c\u0018\u0001\u00044fi\u000eD7\u000b^1ukN\u0004\u0013a\u00034fi\u000eD\u0007+\u0019:b[N,\u0012!\u001b\t\u0003UFl\u0011a\u001b\u0006\u0003Y6\f1\u0001\\8h\u0015\tqw.A\u0005j]R,'O\\1mg*\u0011\u0001OP\u0001\bgR|'/Y4f\u0013\t\u00118NA\u0006GKR\u001c\u0007\u000eU1sC6\u001c\u0018\u0001\u00044fi\u000eD\u0007+\u0019:b[N\u0004\u0013!\u0003;fgR4U\r^2i)\u00051\bCA\u0012x\u0013\tAHE\u0001\u0003V]&$\bF\u0001\u000b{!\rY\u0018QA\u0007\u0002y*\u0011QP`\u0001\u0004CBL'bA@\u0002\u0002\u00059!.\u001e9ji\u0016\u0014(bAA\u0002\u0003\u0006)!.\u001e8ji&\u0019\u0011q\u0001?\u0003\tQ+7\u000f^\u0001\u0018i\u0016\u001cHOT8u\u0019\u0016\fG-\u001a:Pe\u001a{G\u000e\\8xKJD#!\u0006>\u0002)Q,7\u000f^#se>\u0014Hj\\4SK\u0006$\u0017J\u001c4pQ\t1\"0\u0001\rck&dGMR8mY><XM\u001d$fi\u000eD\u0007+\u0019:b[N$R![A\u000b\u0003/AQaX\fA\u00029Ba!!\u0007\u0018\u0001\u0004q\u0013!C7bq^\u000b\u0017\u000e^'t\u0003=\u0011W/\u001b7e%\u0016\fGMU3tk2$H\u0003CA\u0010\u0003K\t)$!\u000f\u0011\u0007-\n\t#C\u0002\u0002$q\u0011Q\u0002T8h%\u0016\fGMU3tk2$\bbBA\u00141\u0001\u0007\u0011\u0011F\u0001\u0006KJ\u0014xN\u001d\t\u0005\u0003W\t\t$\u0004\u0002\u0002.)\u0019\u0011q\u0006\u001f\u0002\u0011A\u0014x\u000e^8d_2LA!a\r\u0002.\t1QI\u001d:peND\u0001\"a\u000e\u0019!\u0003\u0005\rAL\u0001\u000eQ&<\u0007nV1uKJl\u0017M]6\t\u0011\u0005m\u0002\u0004%AA\u00029\nA\u0003\\3bI\u0016\u0014Hj\\4Ti\u0006\u0014Ho\u00144gg\u0016$\u0018!\u00072vS2$'+Z1e%\u0016\u001cX\u000f\u001c;%I\u00164\u0017-\u001e7uII*\"!!\u0011+\u00079\n\u0019e\u000b\u0002\u0002FA!\u0011qIA)\u001b\t\tIE\u0003\u0003\u0002L\u00055\u0013!C;oG\",7m[3e\u0015\r\ty\u0005J\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA*\u0003\u0013\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003e\u0011W/\u001b7e%\u0016\fGMU3tk2$H\u0005Z3gCVdG\u000fJ\u001a")
public class DelayedRemoteFetchTest {
    private final int maxBytes;
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private final TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "topic");
    private final long fetchOffset;
    private final long logStartOffset;
    private final Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
    private final int replicaId;
    private final FetchPartitionStatus fetchStatus = new FetchPartitionStatus(new LogOffsetMetadata(this.fetchOffset()), new FetchRequest.PartitionData(Uuid.ZERO_UUID, this.fetchOffset(), this.logStartOffset(), this.maxBytes(), this.currentLeaderEpoch()));
    private final FetchParams fetchParams = this.buildFollowerFetchParams(this.replicaId(), 500);

    private int maxBytes() {
        return this.maxBytes;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    private long fetchOffset() {
        return this.fetchOffset;
    }

    private long logStartOffset() {
        return this.logStartOffset;
    }

    private Optional<Integer> currentLeaderEpoch() {
        return this.currentLeaderEpoch;
    }

    private int replicaId() {
        return this.replicaId;
    }

    private FetchPartitionStatus fetchStatus() {
        return this.fetchStatus;
    }

    private FetchParams fetchParams() {
        return this.fetchParams;
    }

    @Test
    public void testFetch() {
        ObjectRef actualTopicPartition = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        future.complete(null);
        RemoteStorageFetchInfo fetchInfo = new RemoteStorageFetchInfo(0, false, this.topicIdPartition().topicPartition(), null, null, false);
        int highWatermark = 100;
        int leaderLogStartOffset = 10;
        LogReadResult logReadInfo = this.buildReadResult(Errors.NONE, highWatermark, leaderLogStartOffset);
        DelayedRemoteFetch delayedRemoteFetch = new DelayedRemoteFetch(null, future, fetchInfo, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition()), (Object)this.fetchStatus()), (List)Nil$.MODULE$), this.fetchParams(), (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition()), (Object)logReadInfo), (List)Nil$.MODULE$), this.replicaManager(), (Function1 & Serializable)responses -> {
            DelayedRemoteFetchTest.callback$1(responses, actualTopicPartition, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        Mockito.when((Object)this.replicaManager().getPartitionOrException(this.topicIdPartition().topicPartition())).thenReturn(Mockito.mock(Partition.class));
        Assertions.assertTrue((boolean)delayedRemoteFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedRemoteFetch.isCompleted());
        Assertions.assertTrue((boolean)((Option)actualTopicPartition.elem).isDefined());
        Assertions.assertEquals((Object)this.topicIdPartition(), (Object)((Option)actualTopicPartition.elem).get());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
        FetchPartitionData fetchResult = (FetchPartitionData)((Option)fetchResultOpt.elem).get();
        Assertions.assertEquals((Object)Errors.NONE, (Object)fetchResult.error);
        Assertions.assertEquals((long)highWatermark, (long)fetchResult.highWatermark);
        Assertions.assertEquals((long)leaderLogStartOffset, (long)fetchResult.logStartOffset);
    }

    @Test
    public void testNotLeaderOrFollower() {
        ObjectRef actualTopicPartition = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        Mockito.when((Object)this.replicaManager().getPartitionOrException(this.topicIdPartition().topicPartition())).thenThrow(new Throwable[]{new NotLeaderOrFollowerException(new StringBuilder(26).append("Replica for ").append(this.topicIdPartition()).append(" not available").toString())});
        CompletableFuture future = new CompletableFuture();
        RemoteStorageFetchInfo fetchInfo = new RemoteStorageFetchInfo(0, false, this.topicIdPartition().topicPartition(), null, null, false);
        LogReadResult logReadInfo = this.buildReadResult(Errors.NONE, 0, 0);
        DelayedRemoteFetch delayedRemoteFetch = new DelayedRemoteFetch(null, future, fetchInfo, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition()), (Object)this.fetchStatus()), (List)Nil$.MODULE$), this.fetchParams(), (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition()), (Object)logReadInfo), (List)Nil$.MODULE$), this.replicaManager(), (Function1 & Serializable)responses -> {
            DelayedRemoteFetchTest.callback$2(responses, actualTopicPartition, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)delayedRemoteFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedRemoteFetch.isCompleted());
        Assertions.assertEquals((Object)this.topicIdPartition(), (Object)((Option)actualTopicPartition.elem).get());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
    }

    @Test
    public void testErrorLogReadInfo() {
        ObjectRef actualTopicPartition = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        Mockito.when((Object)this.replicaManager().getPartitionOrException(this.topicIdPartition().topicPartition())).thenReturn(Mockito.mock(Partition.class));
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        future.complete(null);
        RemoteStorageFetchInfo fetchInfo = new RemoteStorageFetchInfo(0, false, this.topicIdPartition().topicPartition(), null, null, false);
        LogReadResult logReadInfo = this.buildReadResult(Errors.FENCED_LEADER_EPOCH, 0, 0);
        DelayedRemoteFetch delayedRemoteFetch = new DelayedRemoteFetch(null, future, fetchInfo, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition()), (Object)this.fetchStatus()), (List)Nil$.MODULE$), this.fetchParams(), (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition()), (Object)logReadInfo), (List)Nil$.MODULE$), this.replicaManager(), (Function1 & Serializable)responses -> {
            DelayedRemoteFetchTest.callback$3(responses, actualTopicPartition, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)delayedRemoteFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedRemoteFetch.isCompleted());
        Assertions.assertEquals((Object)this.topicIdPartition(), (Object)((Option)actualTopicPartition.elem).get());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
        Assertions.assertEquals((Object)Errors.FENCED_LEADER_EPOCH, (Object)((FetchPartitionData)((Option)fetchResultOpt.elem).get()).error);
    }

    private FetchParams buildFollowerFetchParams(int replicaId, int maxWaitMs) {
        return new FetchParams(ApiKeys.FETCH.latestVersion(), replicaId, 1L, (long)maxWaitMs, 1, this.maxBytes(), FetchIsolation.LOG_END, Optional.empty());
    }

    private LogReadResult buildReadResult(Errors error, int highWatermark, int leaderLogStartOffset) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        None$ x$1 = (errors == null ? errors2 != null : !errors.equals(errors2)) ? new Some((Object)error.exception()) : None$.MODULE$;
        FetchDataInfo x$2 = new FetchDataInfo(LogOffsetMetadata.UNKNOWN_OFFSET_METADATA, (Records)MemoryRecords.EMPTY);
        None$ x$3 = None$.MODULE$;
        long x$4 = highWatermark;
        long x$5 = leaderLogStartOffset;
        None$ x$9 = None$.MODULE$;
        None$ x$10 = None$.MODULE$;
        return new LogReadResult(x$2, (Option)x$3, x$4, x$5, -1L, -1L, -1L, (Option)x$9, (Option)x$10, (Option)x$1);
    }

    private int buildReadResult$default$2() {
        return 0;
    }

    private int buildReadResult$default$3() {
        return 0;
    }

    private static final void callback$1(Seq responses, ObjectRef actualTopicPartition$1, ObjectRef fetchResultOpt$1) {
        Assertions.assertEquals((int)1, (int)responses.size());
        actualTopicPartition$1.elem = new Some(((Tuple2)responses.head())._1());
        fetchResultOpt$1.elem = new Some(((Tuple2)responses.head())._2());
    }

    private static final void callback$2(Seq responses, ObjectRef actualTopicPartition$2, ObjectRef fetchResultOpt$2) {
        Assertions.assertEquals((int)1, (int)responses.size());
        actualTopicPartition$2.elem = new Some(((Tuple2)responses.head())._1());
        fetchResultOpt$2.elem = new Some(((Tuple2)responses.head())._2());
    }

    private static final void callback$3(Seq responses, ObjectRef actualTopicPartition$3, ObjectRef fetchResultOpt$3) {
        Assertions.assertEquals((int)1, (int)responses.size());
        actualTopicPartition$3.elem = new Some(((Tuple2)responses.head())._1());
        fetchResultOpt$3.elem = new Some(((Tuple2)responses.head())._2());
    }

    public DelayedRemoteFetchTest() {
        this.maxBytes = 1024;
        this.fetchOffset = 500L;
        this.logStartOffset = 0L;
        this.replicaId = 1;
    }
}

