/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.net.Socket;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import kafka.api.KafkaSasl$;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.network.SocketServer;
import kafka.security.minikdc.MiniKdc;
import kafka.server.AbstractApiVersionsRequestTest;
import kafka.server.IntegrationTestUtils$;
import kafka.test.ClusterConfig;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.NotNothing$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.message.SaslHandshakeRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.SaslHandshakeRequest;
import org.apache.kafka.common.requests.SaslHandshakeResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.$less$colon$less$;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.Statics;

@ExtendWith(value={ClusterTestExtensions.class})
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015c\u0001\u0002\t\u0012\u0001YA\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001\b\u0005\u0006E\u0001!\ta\t\u0005\bM\u0001\u0011\r\u0011\"\u0001(\u0011\u0019\u0001\u0004\u0001)A\u0005Q!9\u0011\u0007\u0001b\u0001\n\u0003\u0011\u0004BB\u001f\u0001A\u0003%1\u0007C\u0005?\u0001\u0001\u0007\t\u0019!C\u0005\u007f!Ia\t\u0001a\u0001\u0002\u0004%Ia\u0012\u0005\n\u001d\u0002\u0001\r\u0011!Q!\n\u0001CQa\u0014\u0001\u0005\u0002ACQA\u0019\u0001\u0005\u0002\rDa!!\u0001\u0001\t\u0003\u0019\u0007BBA\u0003\u0001\u0011\u00051\r\u0003\u0004\u0002\n\u0001!\ta\u0019\u0005\b\u0003'\u0001A\u0011BA\u000b\u0005i\u0019\u0016m\u001d7Ba&4VM]:j_:\u001c(+Z9vKN$H+Z:u\u0015\t\u00112#\u0001\u0004tKJ4XM\u001d\u0006\u0002)\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0018!\tA\u0012$D\u0001\u0012\u0013\tQ\u0012C\u0001\u0010BEN$(/Y2u\u0003BLg+\u001a:tS>t7OU3rk\u0016\u001cH\u000fV3ti\u000691\r\\;ti\u0016\u0014\bCA\u000f!\u001b\u0005q\"BA\u0010\u0014\u0003\u0011!Xm\u001d;\n\u0005\u0005r\"aD\"mkN$XM]%ogR\fgnY3\u0002\rqJg.\u001b;?)\t!S\u0005\u0005\u0002\u0019\u0001!)1D\u0001a\u00019\u0005A2.\u00194lC\u000ec\u0017.\u001a8u'\u0006\u001cH.T3dQ\u0006t\u0017n]7\u0016\u0003!\u0002\"!\u000b\u0018\u000e\u0003)R!a\u000b\u0017\u0002\t1\fgn\u001a\u0006\u0002[\u0005!!.\u0019<b\u0013\ty#F\u0001\u0004TiJLgnZ\u0001\u001aW\u000647.Y\"mS\u0016tGoU1tY6+7\r[1oSNl\u0007%A\rlC\u001a\\\u0017mU3sm\u0016\u00148+Y:m\u001b\u0016\u001c\u0007.\u00198jg6\u001cX#A\u001a\u0011\u0007QZ\u0004&D\u00016\u0015\t1t'A\u0005j[6,H/\u00192mK*\u0011\u0001(O\u0001\u000bG>dG.Z2uS>t'\"\u0001\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005q*$\u0001\u0002'jgR\f!d[1gW\u0006\u001cVM\u001d<feN\u000b7\u000f\\'fG\"\fg.[:ng\u0002\nAa]1tYV\t\u0001\t\u0005\u0002B\t6\t!I\u0003\u0002D'\u0005\u0019\u0011\r]5\n\u0005\u0015\u0013%!C*bg2\u001cV\r^;q\u0003!\u0019\u0018m\u001d7`I\u0015\fHC\u0001%M!\tI%*D\u0001:\u0013\tY\u0015H\u0001\u0003V]&$\bbB'\t\u0003\u0003\u0005\r\u0001Q\u0001\u0004q\u0012\n\u0014!B:bg2\u0004\u0013!C:fiV\u00048+Y:m)\tA\u0015\u000bC\u0003S\u0015\u0001\u00071+\u0001\u0004d_:4\u0017n\u001a\t\u0003;QK!!\u0016\u0010\u0003\u001b\rcWo\u001d;fe\u000e{gNZ5hQ\tQq\u000b\u0005\u0002YA6\t\u0011L\u0003\u0002D5*\u00111\fX\u0001\bUV\u0004\u0018\u000e^3s\u0015\tif,A\u0003kk:LGOC\u0001`\u0003\ry'oZ\u0005\u0003Cf\u0013!BQ3g_J,W)Y2i\u0003A\"Xm\u001d;Ba&4VM]:j_:\u001c(+Z9vKN$()\u001a4pe\u0016\u001c\u0016m\u001d7IC:$7\u000f[1lKJ+\u0017/^3tiR\t\u0001\n\u000b\u0004\fK.d'p\u001f\t\u0003M&l\u0011a\u001a\u0006\u0003Qz\t!\"\u00198o_R\fG/[8o\u0013\tQwMA\u0006DYV\u001cH/\u001a:UKN$\u0018\u0001E:fGV\u0014\u0018\u000e^=Qe>$xnY8mI\u0005i\u0017B\u00018p\u00039\u0019\u0016i\u0015'`!2\u000b\u0015J\u0014+F1RS!\u0001]9\u0002!M+7-\u001e:jif\u0004&o\u001c;pG>d'B\u0001:t\u0003\u0011\tW\u000f\u001e5\u000b\u0005Q,\u0018\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005Y<\u0018AB2p[6|gN\u0003\u0002\u0015q*\u0011\u0011PX\u0001\u0007CB\f7\r[3\u0002\u0017\rdWo\u001d;feRK\b/\u001a\u0013\u0002y&\u0011QP`\u0001\u00035.S!a`4\u0002\tQK\b/Z\u00010i\u0016\u001cH/\u00119j-\u0016\u00148/[8ogJ+\u0017/^3ti\u00063G/\u001a:TCNd\u0007*\u00198eg\"\f7.\u001a*fcV,7\u000f\u001e\u0015\u0007\u0019\u0015\\GN_>\u0002YQ,7\u000f^!qSZ+'o]5p]N\u0014V-];fgR<\u0016\u000e\u001e5V]N,\b\u000f]8si\u0016$g+\u001a:tS>t\u0007FB\u0007fW2T80A\u0005dY>\u001cXmU1tY\"\u001aa\"!\u0004\u0011\u0007a\u000by!C\u0002\u0002\u0012e\u0013\u0011\"\u00114uKJ,\u0015m\u00195\u0002QM,g\u000eZ*bg2D\u0015M\u001c3tQ\u0006\\WMU3rk\u0016\u001cHOV1mS\u0012\fG/\u001a*fgB|gn]3\u0015\u0007!\u000b9\u0002C\u0004\u0002\u001a=\u0001\r!a\u0007\u0002\rM|7m[3u!\u0011\ti\"a\t\u000e\u0005\u0005}!bAA\u0011Y\u0005\u0019a.\u001a;\n\t\u0005\u0015\u0012q\u0004\u0002\u0007'>\u001c7.\u001a;)\u000f\u0001\tI#!\u000e\u00028A!\u00111FA\u0019\u001b\t\tiCC\u0002\u00020e\u000b\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\t\u0005M\u0012Q\u0006\u0002\u000b\u000bb$XM\u001c3XSRD\u0017!\u0002<bYV,GFAA\u001dG\t\tY\u0004\u0005\u0003\u0002>\u0005\u0005SBAA \u0015\tif$\u0003\u0003\u0002D\u0005}\"!F\"mkN$XM\u001d+fgR,\u0005\u0010^3og&|gn\u001d")
public class SaslApiVersionsRequestTest
extends AbstractApiVersionsRequestTest {
    private final ClusterInstance cluster;
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private SaslSetup sasl;

    public String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    public List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    private SaslSetup sasl() {
        return this.sasl;
    }

    private void sasl_$eq(SaslSetup x$1) {
        this.sasl = x$1;
    }

    @BeforeEach
    public void setupSasl(ClusterConfig config) {
        this.sasl_$eq(new SaslSetup(null){
            private File kafka$api$SaslSetup$$workDir;
            private Properties kafka$api$SaslSetup$$kdcConf;
            private MiniKdc kafka$api$SaslSetup$$kdc;
            private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
            private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

            public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
                SaslSetup.startSasl$(this, jaasSections);
            }

            public void initializeKerberos() {
                SaslSetup.initializeKerberos$(this);
            }

            public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
                return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
            }

            public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
                return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
            }

            public SaslSetupMode jaasSections$default$3() {
                return SaslSetup.jaasSections$default$3$(this);
            }

            public String jaasSections$default$4() {
                return SaslSetup.jaasSections$default$4$(this);
            }

            public void closeSasl() {
                SaslSetup.closeSasl$(this);
            }

            public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
                return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
            }

            public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
                return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
            }

            public boolean kafkaClientSaslProperties$default$2() {
                return SaslSetup.kafkaClientSaslProperties$default$2$(this);
            }

            public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
                return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
            }

            public Option<String> jaasClientLoginModule$default$2() {
                return SaslSetup.jaasClientLoginModule$default$2$(this);
            }

            public String jaasAdminLoginModule(String clientSaslMechanism, Option<String> serviceName) {
                return SaslSetup.jaasAdminLoginModule$(this, clientSaslMechanism, serviceName);
            }

            public Option<String> jaasAdminLoginModule$default$2() {
                return SaslSetup.jaasAdminLoginModule$default$2$(this);
            }

            public String jaasScramClientLoginModule(String clientSaslScramMechanism, String scramUser, String scramPassword) {
                return SaslSetup.jaasScramClientLoginModule$(this, clientSaslScramMechanism, scramUser, scramPassword);
            }

            public Admin createPrivilegedAdminClient() {
                return SaslSetup.createPrivilegedAdminClient$(this);
            }

            public Admin createAdminClient(String brokerList, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> clientSaslProperties, String scramMechanism, String user, String password) {
                return SaslSetup.createAdminClient$(this, brokerList, securityProtocol, trustStoreFile, clientSaslProperties, scramMechanism, user, password);
            }

            public void createScramCredentialsViaPrivilegedAdminClient(String userName, String password) {
                SaslSetup.createScramCredentialsViaPrivilegedAdminClient$(this, userName, password);
            }

            public void createScramCredentials(Admin adminClient, String userName, String password) {
                SaslSetup.createScramCredentials$((SaslSetup)this, adminClient, userName, password);
            }

            public void createScramCredentials(String zkConnect, String userName, String password) {
                SaslSetup.createScramCredentials$((SaslSetup)this, zkConnect, userName, password);
            }

            public File kafka$api$SaslSetup$$workDir() {
                return this.kafka$api$SaslSetup$$workDir;
            }

            public Properties kafka$api$SaslSetup$$kdcConf() {
                return this.kafka$api$SaslSetup$$kdcConf;
            }

            public MiniKdc kafka$api$SaslSetup$$kdc() {
                return this.kafka$api$SaslSetup$$kdc;
            }

            public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
                this.kafka$api$SaslSetup$$kdc = x$1;
            }

            public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
                return this.kafka$api$SaslSetup$$serverKeytabFile;
            }

            public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
                this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
            }

            public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
                return this.kafka$api$SaslSetup$$clientKeytabFile;
            }

            public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
                this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
            }

            public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
                this.kafka$api$SaslSetup$$workDir = x$1;
            }

            public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
                this.kafka$api$SaslSetup$$kdcConf = x$1;
            }
            {
                SaslSetup.$init$(this);
                Statics.releaseFence();
            }
        });
        this.sasl().startSasl(this.sasl().jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)new Some((Object)this.kafkaClientSaslMechanism()), KafkaSasl$.MODULE$, JaasTestUtils$.MODULE$.KafkaServerContextName()));
        config.saslServerProperties().putAll((Map<?, ?>)this.sasl().kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        SaslSetup qual$1 = this.sasl();
        String x$1 = this.kafkaClientSaslMechanism();
        boolean x$2 = qual$1.kafkaClientSaslProperties$default$2();
        config.saslClientProperties().putAll((Map<?, ?>)qual$1.kafkaClientSaslProperties(x$1, x$2));
        super.brokerPropertyOverrides(config.serverProperties());
    }

    @ClusterTest(securityProtocol=SecurityProtocol.SASL_PLAINTEXT, clusterType=Type.ZK)
    public void testApiVersionsRequestBeforeSaslHandshakeRequest() {
        try (Socket socket = IntegrationTestUtils$.MODULE$.connect((SocketServer)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokerSocketServers()).asScala().head(), this.cluster.clientListener());){
            ApiVersionsResponse apiVersionsResponse = (ApiVersionsResponse)IntegrationTestUtils$.MODULE$.sendAndReceive((AbstractRequest)new ApiVersionsRequest.Builder().build((short)0), socket, "client-id", (Option<Object>)None$.MODULE$, ClassTag$.MODULE$.apply(ApiVersionsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
            this.validateApiVersionsResponse(apiVersionsResponse, this.validateApiVersionsResponse$default$2(), this.validateApiVersionsResponse$default$3(), this.validateApiVersionsResponse$default$4());
            this.sendSaslHandshakeRequestValidateResponse(socket);
        }
    }

    @ClusterTest(securityProtocol=SecurityProtocol.SASL_PLAINTEXT, clusterType=Type.ZK)
    public void testApiVersionsRequestAfterSaslHandshakeRequest() {
        try (Socket socket = IntegrationTestUtils$.MODULE$.connect((SocketServer)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokerSocketServers()).asScala().head(), this.cluster.clientListener());){
            this.sendSaslHandshakeRequestValidateResponse(socket);
            ApiVersionsResponse response = (ApiVersionsResponse)IntegrationTestUtils$.MODULE$.sendAndReceive((AbstractRequest)new ApiVersionsRequest.Builder().build((short)0), socket, "client-id", (Option<Object>)None$.MODULE$, ClassTag$.MODULE$.apply(ApiVersionsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
            Assertions.assertEquals((short)Errors.ILLEGAL_SASL_STATE.code(), (short)response.data().errorCode());
        }
    }

    @ClusterTest(securityProtocol=SecurityProtocol.SASL_PLAINTEXT, clusterType=Type.ZK)
    public void testApiVersionsRequestWithUnsupportedVersion() {
        try (Socket socket = IntegrationTestUtils$.MODULE$.connect((SocketServer)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokerSocketServers()).asScala().head(), this.cluster.clientListener());){
            ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest.Builder().build((short)0);
            ApiVersionsResponse apiVersionsResponse = this.sendUnsupportedApiVersionRequest(apiVersionsRequest);
            Assertions.assertEquals((short)Errors.UNSUPPORTED_VERSION.code(), (short)apiVersionsResponse.data().errorCode());
            ApiVersionsResponse apiVersionsResponse2 = (ApiVersionsResponse)IntegrationTestUtils$.MODULE$.sendAndReceive((AbstractRequest)new ApiVersionsRequest.Builder().build((short)0), socket, "client-id", (Option<Object>)None$.MODULE$, ClassTag$.MODULE$.apply(ApiVersionsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
            this.validateApiVersionsResponse(apiVersionsResponse2, this.validateApiVersionsResponse$default$2(), this.validateApiVersionsResponse$default$3(), this.validateApiVersionsResponse$default$4());
            this.sendSaslHandshakeRequestValidateResponse(socket);
        }
    }

    @AfterEach
    public void closeSasl() {
        this.sasl().closeSasl();
    }

    private void sendSaslHandshakeRequestValidateResponse(Socket socket) {
        SaslHandshakeRequest request = new SaslHandshakeRequest(new SaslHandshakeRequestData().setMechanism("PLAIN"), ApiKeys.SASL_HANDSHAKE.latestVersion());
        SaslHandshakeResponse response = (SaslHandshakeResponse)IntegrationTestUtils$.MODULE$.sendAndReceive((AbstractRequest)request, socket, "client-id", (Option<Object>)None$.MODULE$, ClassTag$.MODULE$.apply(SaslHandshakeResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error());
        Assertions.assertEquals(Collections.singletonList("PLAIN"), (Object)response.enabledMechanisms());
    }

    public SaslApiVersionsRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
        super(cluster);
        this.kafkaClientSaslMechanism = "PLAIN";
        this.kafkaServerSaslMechanisms = new .colon.colon((Object)"PLAIN", (List)Nil$.MODULE$);
    }
}

