/*
 * Decompiled with CFR 0.152.
 */
package kafka.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.errors.ThrottlingQuotaExceededException;
import org.apache.kafka.common.message.AllocateProducerIdsRequestData;
import org.apache.kafka.common.message.AllocateProducerIdsResponseData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.kafka.common.message.AlterUserScramCredentialsRequestData;
import org.apache.kafka.common.message.AlterUserScramCredentialsResponseData;
import org.apache.kafka.common.message.BrokerHeartbeatRequestData;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.CreateDelegationTokenRequestData;
import org.apache.kafka.common.message.CreateDelegationTokenResponseData;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreatePartitionsResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.ElectLeadersRequestData;
import org.apache.kafka.common.message.ElectLeadersResponseData;
import org.apache.kafka.common.message.ExpireDelegationTokenRequestData;
import org.apache.kafka.common.message.ExpireDelegationTokenResponseData;
import org.apache.kafka.common.message.ListPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.ListPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.RenewDelegationTokenRequestData;
import org.apache.kafka.common.message.RenewDelegationTokenResponseData;
import org.apache.kafka.common.message.UpdateFeaturesRequestData;
import org.apache.kafka.common.message.UpdateFeaturesResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.controller.Controller;
import org.apache.kafka.controller.ControllerRequestContext;
import org.apache.kafka.controller.ResultOrError;
import org.apache.kafka.metadata.BrokerHeartbeatReply;
import org.apache.kafka.metadata.BrokerRegistrationReply;
import org.apache.kafka.metadata.FinalizedControllerFeatures;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;

public class MockController
implements Controller {
    private static final NotControllerException NOT_CONTROLLER_EXCEPTION = new NotControllerException("This is not the correct controller for this cluster.");
    private final AtomicLong nextTopicId = new AtomicLong(1L);
    private volatile boolean active = true;
    private final Map<String, Uuid> topicNameToId = new HashMap<String, Uuid>();
    private final Map<Uuid, MockTopic> topics = new HashMap<Uuid, MockTopic>();
    private final Map<ConfigResource, Map<String, String>> configs = new HashMap<ConfigResource, Map<String, String>>();

    public CompletableFuture<List<AclCreateResult>> createAcls(ControllerRequestContext context, List<AclBinding> aclBindings) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<AclDeleteResult>> deleteAcls(ControllerRequestContext context, List<AclBindingFilter> aclBindingFilters) {
        throw new UnsupportedOperationException();
    }

    private MockController(Collection<MockTopic> initialTopics) {
        for (MockTopic topic : initialTopics) {
            this.topics.put(topic.id, topic);
            this.topicNameToId.put(topic.name, topic.id);
        }
    }

    public CompletableFuture<AlterPartitionResponseData> alterPartition(ControllerRequestContext context, AlterPartitionRequestData request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<AlterUserScramCredentialsResponseData> alterUserScramCredentials(ControllerRequestContext context, AlterUserScramCredentialsRequestData request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<CreateDelegationTokenResponseData> createDelegationToken(ControllerRequestContext context, CreateDelegationTokenRequestData request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<RenewDelegationTokenResponseData> renewDelegationToken(ControllerRequestContext context, RenewDelegationTokenRequestData request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<ExpireDelegationTokenResponseData> expireDelegationToken(ControllerRequestContext context, ExpireDelegationTokenRequestData request) {
        throw new UnsupportedOperationException();
    }

    public synchronized CompletableFuture<CreateTopicsResponseData> createTopics(ControllerRequestContext context, CreateTopicsRequestData request, Set<String> describable) {
        CreateTopicsResponseData response = new CreateTopicsResponseData();
        for (CreateTopicsRequestData.CreatableTopic topic : request.topics()) {
            if (this.topicNameToId.containsKey(topic.name())) {
                response.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsResponseData.CreatableTopicResult().setName(topic.name()).setErrorCode(Errors.TOPIC_ALREADY_EXISTS.code()));
                continue;
            }
            long topicId = this.nextTopicId.getAndIncrement();
            Uuid topicUuid = new Uuid(0L, topicId);
            MockTopic mockTopic = new MockTopic(topic.name(), topicUuid);
            CreateTopicsResponseData.CreatableTopicResult creatableTopicResult = new CreateTopicsResponseData.CreatableTopicResult().setName(topic.name()).setErrorCode(Errors.NONE.code());
            try {
                context.applyPartitionChangeQuota(mockTopic.numPartitions);
                creatableTopicResult.setTopicId(topicUuid);
                this.topicNameToId.put(topic.name(), topicUuid);
                this.topics.put(topicUuid, mockTopic);
                if (describable.contains(topic.name())) {
                    if (topic.assignments() != null && !topic.assignments().isEmpty()) {
                        creatableTopicResult.setTopicConfigErrorCode(Errors.NONE.code()).setReplicationFactor((short)((CreateTopicsRequestData.CreatableReplicaAssignment)topic.assignments().iterator().next()).brokerIds().size()).setNumPartitions(topic.assignments().size());
                    } else {
                        creatableTopicResult.setTopicConfigErrorCode(Errors.NONE.code()).setReplicationFactor(topic.replicationFactor()).setNumPartitions(topic.numPartitions());
                    }
                } else {
                    creatableTopicResult.setTopicConfigErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code());
                }
            }
            catch (ThrottlingQuotaExceededException e) {
                ApiError apiError = new ApiError(Errors.THROTTLING_QUOTA_EXCEEDED);
                creatableTopicResult.setErrorCode(apiError.error().code()).setErrorMessage(apiError.message());
            }
            response.topics().add((ImplicitLinkedHashCollection.Element)creatableTopicResult);
        }
        return CompletableFuture.completedFuture(response);
    }

    public CompletableFuture<Void> unregisterBroker(ControllerRequestContext context, int brokerId) {
        throw new UnsupportedOperationException();
    }

    public synchronized CompletableFuture<Map<String, ResultOrError<Uuid>>> findTopicIds(ControllerRequestContext context, Collection<String> topicNames) {
        HashMap<String, ResultOrError> results = new HashMap<String, ResultOrError>();
        for (String topicName : topicNames) {
            if (!this.topicNameToId.containsKey(topicName)) {
                results.put(topicName, new ResultOrError(new ApiError(Errors.UNKNOWN_TOPIC_OR_PARTITION)));
                continue;
            }
            results.put(topicName, new ResultOrError((Object)this.topicNameToId.get(topicName)));
        }
        return CompletableFuture.completedFuture(results);
    }

    public synchronized CompletableFuture<Map<String, Uuid>> findAllTopicIds(ControllerRequestContext context) {
        HashMap<String, Uuid> results = new HashMap<String, Uuid>();
        for (Map.Entry<Uuid, MockTopic> entry : this.topics.entrySet()) {
            results.put(entry.getValue().name, entry.getKey());
        }
        return CompletableFuture.completedFuture(results);
    }

    public synchronized CompletableFuture<Map<Uuid, ResultOrError<String>>> findTopicNames(ControllerRequestContext context, Collection<Uuid> topicIds) {
        HashMap<Uuid, ResultOrError> results = new HashMap<Uuid, ResultOrError>();
        for (Uuid topicId : topicIds) {
            MockTopic topic = this.topics.get(topicId);
            if (topic == null) {
                results.put(topicId, new ResultOrError(new ApiError(Errors.UNKNOWN_TOPIC_ID)));
                continue;
            }
            results.put(topicId, new ResultOrError((Object)topic.name));
        }
        return CompletableFuture.completedFuture(results);
    }

    public synchronized CompletableFuture<Map<Uuid, ApiError>> deleteTopics(ControllerRequestContext context, Collection<Uuid> topicIds) {
        if (!this.active) {
            CompletableFuture<Map<Uuid, ApiError>> future = new CompletableFuture<Map<Uuid, ApiError>>();
            future.completeExceptionally((Throwable)NOT_CONTROLLER_EXCEPTION);
            return future;
        }
        HashMap<Uuid, ApiError> results = new HashMap<Uuid, ApiError>();
        for (Uuid topicId : topicIds) {
            MockTopic topic = this.topics.get(topicId);
            if (topic == null) {
                results.put(topicId, new ApiError(Errors.UNKNOWN_TOPIC_ID));
                continue;
            }
            try {
                context.applyPartitionChangeQuota(topic.numPartitions);
                this.topics.remove(topicId);
                this.topicNameToId.remove(topic.name);
                results.put(topicId, ApiError.NONE);
            }
            catch (ThrottlingQuotaExceededException e) {
                results.put(topicId, new ApiError(Errors.THROTTLING_QUOTA_EXCEEDED));
            }
        }
        return CompletableFuture.completedFuture(results);
    }

    public CompletableFuture<Map<ConfigResource, ResultOrError<Map<String, String>>>> describeConfigs(ControllerRequestContext context, Map<ConfigResource, Collection<String>> resources) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<ElectLeadersResponseData> electLeaders(ControllerRequestContext context, ElectLeadersRequestData request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<FinalizedControllerFeatures> finalizedFeatures(ControllerRequestContext context) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Map<ConfigResource, ApiError>> incrementalAlterConfigs(ControllerRequestContext context, Map<ConfigResource, Map<String, Map.Entry<AlterConfigOp.OpType, String>>> configChanges, boolean validateOnly) {
        HashMap<ConfigResource, ApiError> results = new HashMap<ConfigResource, ApiError>();
        for (Map.Entry<ConfigResource, Map<String, Map.Entry<AlterConfigOp.OpType, String>>> entry : configChanges.entrySet()) {
            ConfigResource resource = entry.getKey();
            results.put(resource, this.incrementalAlterResource(resource, entry.getValue(), validateOnly));
        }
        CompletableFuture<Map<ConfigResource, ApiError>> future = new CompletableFuture<Map<ConfigResource, ApiError>>();
        future.complete(results);
        return future;
    }

    private ApiError incrementalAlterResource(ConfigResource resource, Map<String, Map.Entry<AlterConfigOp.OpType, String>> ops, boolean validateOnly) {
        for (Map.Entry<String, Map.Entry<AlterConfigOp.OpType, String>> entry : ops.entrySet()) {
            AlterConfigOp.OpType opType = entry.getValue().getKey();
            if (opType == AlterConfigOp.OpType.SET || opType == AlterConfigOp.OpType.DELETE) continue;
            return new ApiError(Errors.INVALID_REQUEST, "This mock does not support the " + opType + " config operation.");
        }
        if (!validateOnly) {
            for (Map.Entry<String, Map.Entry<AlterConfigOp.OpType, String>> entry : ops.entrySet()) {
                String key = entry.getKey();
                AlterConfigOp.OpType op = entry.getValue().getKey();
                String value = entry.getValue().getValue();
                switch (op) {
                    case SET: {
                        this.configs.computeIfAbsent(resource, __ -> new HashMap()).put(key, value);
                        break;
                    }
                    case DELETE: {
                        this.configs.getOrDefault(resource, Collections.emptyMap()).remove(key);
                    }
                }
            }
        }
        return ApiError.NONE;
    }

    public CompletableFuture<AlterPartitionReassignmentsResponseData> alterPartitionReassignments(ControllerRequestContext context, AlterPartitionReassignmentsRequestData request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<ListPartitionReassignmentsResponseData> listPartitionReassignments(ControllerRequestContext context, ListPartitionReassignmentsRequestData request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Map<ConfigResource, ApiError>> legacyAlterConfigs(ControllerRequestContext context, Map<ConfigResource, Map<String, String>> newConfigs, boolean validateOnly) {
        HashMap results = new HashMap();
        if (!validateOnly) {
            for (Map.Entry<ConfigResource, Map<String, String>> entry : newConfigs.entrySet()) {
                ConfigResource resource = entry.getKey();
                Map map = this.configs.computeIfAbsent(resource, __ -> new HashMap());
                map.clear();
                map.putAll(entry.getValue());
            }
        }
        CompletableFuture<Map<ConfigResource, ApiError>> future = new CompletableFuture<Map<ConfigResource, ApiError>>();
        future.complete(results);
        return future;
    }

    public CompletableFuture<BrokerHeartbeatReply> processBrokerHeartbeat(ControllerRequestContext context, BrokerHeartbeatRequestData request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<BrokerRegistrationReply> registerBroker(ControllerRequestContext context, BrokerRegistrationRequestData request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Void> waitForReadyBrokers(int minBrokers) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Map<ClientQuotaEntity, ApiError>> alterClientQuotas(ControllerRequestContext context, Collection<ClientQuotaAlteration> quotaAlterations, boolean validateOnly) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<AllocateProducerIdsResponseData> allocateProducerIds(ControllerRequestContext context, AllocateProducerIdsRequestData request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<UpdateFeaturesResponseData> updateFeatures(ControllerRequestContext context, UpdateFeaturesRequestData request) {
        throw new UnsupportedOperationException();
    }

    public synchronized CompletableFuture<List<CreatePartitionsResponseData.CreatePartitionsTopicResult>> createPartitions(ControllerRequestContext context, List<CreatePartitionsRequestData.CreatePartitionsTopic> topicList, boolean validateOnly) {
        if (!this.active) {
            CompletableFuture<List<CreatePartitionsResponseData.CreatePartitionsTopicResult>> future = new CompletableFuture<List<CreatePartitionsResponseData.CreatePartitionsTopicResult>>();
            future.completeExceptionally((Throwable)NOT_CONTROLLER_EXCEPTION);
            return future;
        }
        ArrayList<CreatePartitionsResponseData.CreatePartitionsTopicResult> results = new ArrayList<CreatePartitionsResponseData.CreatePartitionsTopicResult>();
        for (CreatePartitionsRequestData.CreatePartitionsTopic topic : topicList) {
            if (this.topicNameToId.containsKey(topic.name())) {
                try {
                    context.applyPartitionChangeQuota(topic.count());
                    results.add(new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName(topic.name()).setErrorCode(Errors.NONE.code()).setErrorMessage(null));
                }
                catch (ThrottlingQuotaExceededException e) {
                    ApiError apiError = new ApiError(Errors.THROTTLING_QUOTA_EXCEEDED);
                    results.add(new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName(topic.name()).setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()));
                }
                continue;
            }
            results.add(new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName(topic.name()).setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setErrorMessage("No such topic as " + topic.name()));
        }
        return CompletableFuture.completedFuture(results);
    }

    public void beginShutdown() {
        this.active = false;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public int curClaimEpoch() {
        return this.active ? 1 : -1;
    }

    public void close() {
        this.beginShutdown();
    }

    static class MockTopic {
        private final String name;
        private final Uuid id;
        private final int numPartitions;

        MockTopic(String name, Uuid id) {
            this(name, id, 1);
        }

        MockTopic(String name, Uuid id, int numPartitions) {
            this.name = name;
            this.id = id;
            this.numPartitions = numPartitions;
        }
    }

    public static class Builder {
        private final Map<String, MockTopic> initialTopics = new HashMap<String, MockTopic>();

        public Builder newInitialTopic(String name, Uuid id) {
            this.initialTopics.put(name, new MockTopic(name, id));
            return this;
        }

        public Builder newInitialTopic(String name, Uuid id, int numPartitions) {
            this.initialTopics.put(name, new MockTopic(name, id, numPartitions));
            return this;
        }

        public MockController build() {
            return new MockController(this.initialTopics.values());
        }
    }
}

