/*
 * Decompiled with CFR 0.152.
 */
package kafka.testkit;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import kafka.server.MetaProperties;
import kafka.testkit.BrokerNode;
import kafka.testkit.ControllerNode;
import kafka.testkit.TestKitNode;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.server.common.MetadataVersion;

public class TestKitNodes {
    private final Uuid clusterId;
    private final MetadataVersion bootstrapMetadataVersion;
    private final NavigableMap<Integer, ControllerNode> controllerNodes;
    private final NavigableMap<Integer, BrokerNode> brokerNodes;

    public boolean isCombined(int node) {
        return this.controllerNodes.containsKey(node) && this.brokerNodes.containsKey(node);
    }

    private TestKitNodes(Uuid clusterId, MetadataVersion bootstrapMetadataVersion, NavigableMap<Integer, ControllerNode> controllerNodes, NavigableMap<Integer, BrokerNode> brokerNodes) {
        this.clusterId = clusterId;
        this.bootstrapMetadataVersion = bootstrapMetadataVersion;
        this.controllerNodes = controllerNodes;
        this.brokerNodes = brokerNodes;
    }

    public Uuid clusterId() {
        return this.clusterId;
    }

    public MetadataVersion bootstrapMetadataVersion() {
        return this.bootstrapMetadataVersion;
    }

    public Map<Integer, ControllerNode> controllerNodes() {
        return this.controllerNodes;
    }

    public NavigableMap<Integer, BrokerNode> brokerNodes() {
        return this.brokerNodes;
    }

    public MetaProperties controllerProperties(int id) {
        return MetaProperties.apply((String)this.clusterId.toString(), (int)id);
    }

    public MetaProperties brokerProperties(int id) {
        return MetaProperties.apply((String)this.clusterId.toString(), (int)id);
    }

    public ListenerName interBrokerListenerName() {
        return new ListenerName("EXTERNAL");
    }

    public ListenerName externalListenerName() {
        return new ListenerName("EXTERNAL");
    }

    public TestKitNodes copyWithAbsolutePaths(String baseDirectory) {
        TestKitNode node;
        TreeMap<Integer, ControllerNode> newControllerNodes = new TreeMap<Integer, ControllerNode>();
        TreeMap<Integer, BrokerNode> newBrokerNodes = new TreeMap<Integer, BrokerNode>();
        for (Map.Entry entry : this.controllerNodes.entrySet()) {
            node = (ControllerNode)entry.getValue();
            newControllerNodes.put((Integer)entry.getKey(), new ControllerNode(((ControllerNode)node).id(), TestKitNodes.absolutize(baseDirectory, ((ControllerNode)node).metadataDirectory())));
        }
        for (Map.Entry entry : this.brokerNodes.entrySet()) {
            node = (BrokerNode)entry.getValue();
            newBrokerNodes.put((Integer)entry.getKey(), new BrokerNode(((BrokerNode)node).id(), ((BrokerNode)node).incarnationId(), TestKitNodes.absolutize(baseDirectory, ((BrokerNode)node).metadataDirectory()), TestKitNodes.absolutize(baseDirectory, ((BrokerNode)node).logDataDirectories()), ((BrokerNode)node).propertyOverrides()));
        }
        return new TestKitNodes(this.clusterId, this.bootstrapMetadataVersion, newControllerNodes, newBrokerNodes);
    }

    private static List<String> absolutize(String base, Collection<String> directories) {
        ArrayList<String> newDirectories = new ArrayList<String>();
        for (String directory : directories) {
            newDirectories.add(TestKitNodes.absolutize(base, directory));
        }
        return newDirectories;
    }

    private static String absolutize(String base, String directory) {
        if (Paths.get(directory, new String[0]).isAbsolute()) {
            return directory;
        }
        return Paths.get(base, directory).toAbsolutePath().toString();
    }

    public static class Builder {
        private boolean combined = false;
        private Uuid clusterId = null;
        private MetadataVersion bootstrapMetadataVersion = null;
        private final NavigableMap<Integer, ControllerNode> controllerNodes = new TreeMap<Integer, ControllerNode>();
        private final NavigableMap<Integer, BrokerNode> brokerNodes = new TreeMap<Integer, BrokerNode>();

        public Builder setClusterId(Uuid clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public Builder setBootstrapMetadataVersion(MetadataVersion metadataVersion) {
            this.bootstrapMetadataVersion = metadataVersion;
            return this;
        }

        public Builder setCombined(boolean combined) {
            this.combined = combined;
            return this;
        }

        public Builder addNodes(TestKitNode[] nodes) {
            for (TestKitNode node : nodes) {
                this.addNode(node);
            }
            return this;
        }

        public Builder addNode(TestKitNode node) {
            if (node instanceof ControllerNode) {
                ControllerNode controllerNode = (ControllerNode)node;
                this.controllerNodes.put(node.id(), controllerNode);
            } else if (node instanceof BrokerNode) {
                BrokerNode brokerNode = (BrokerNode)node;
                this.brokerNodes.put(node.id(), brokerNode);
            } else {
                throw new RuntimeException("Can't handle TestKitNode subclass " + node.getClass().getSimpleName());
            }
            return this;
        }

        public Builder setNumControllerNodes(int numControllerNodes) {
            if (numControllerNodes < 0) {
                throw new RuntimeException("Invalid negative value for numControllerNodes");
            }
            while (this.controllerNodes.size() > numControllerNodes) {
                this.controllerNodes.pollFirstEntry();
            }
            while (this.controllerNodes.size() < numControllerNodes) {
                int nextId = this.startControllerId();
                if (!this.controllerNodes.isEmpty()) {
                    nextId = (Integer)this.controllerNodes.lastKey() + 1;
                }
                this.controllerNodes.put(nextId, new ControllerNode.Builder().setId(nextId).build());
            }
            return this;
        }

        public Builder setNumBrokerNodes(int numBrokerNodes) {
            if (numBrokerNodes < 0) {
                throw new RuntimeException("Invalid negative value for numBrokerNodes");
            }
            while (this.brokerNodes.size() > numBrokerNodes) {
                this.brokerNodes.pollFirstEntry();
            }
            while (this.brokerNodes.size() < numBrokerNodes) {
                int nextId = this.startBrokerId();
                if (!this.brokerNodes.isEmpty()) {
                    nextId = (Integer)this.brokerNodes.lastKey() + 1;
                }
                this.brokerNodes.put(nextId, new BrokerNode.Builder().setId(nextId).build());
            }
            return this;
        }

        public TestKitNodes build() {
            if (this.clusterId == null) {
                this.clusterId = Uuid.randomUuid();
            }
            if (this.bootstrapMetadataVersion == null) {
                this.bootstrapMetadataVersion = MetadataVersion.latest();
            }
            return new TestKitNodes(this.clusterId, this.bootstrapMetadataVersion, this.controllerNodes, this.brokerNodes);
        }

        private int startBrokerId() {
            return 0;
        }

        private int startControllerId() {
            if (this.combined) {
                return this.startBrokerId();
            }
            return this.startBrokerId() + 3000;
        }
    }
}

