/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.cluster.EndPoint;
import kafka.network.SocketServer;
import kafka.server.BadAuthorizer;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.DummyClientQuotaCallback;
import kafka.server.DummyClientQuotaCallback$;
import kafka.server.FakeConfigurableAuthorizer;
import kafka.server.FakeConfigurableAuthorizer$;
import kafka.server.HostedPartition;
import kafka.server.IntegrationTestUtils$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.testkit.BrokerNode;
import kafka.testkit.KafkaClusterTestKit;
import kafka.testkit.TestKitNodes;
import kafka.utils.Logging;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeMetadataQuorumOptions;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.QuorumInfo;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.UpdateFeaturesOptions;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.message.DescribeClusterRequestData;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.quota.ClientQuotaFilter;
import org.apache.kafka.common.quota.ClientQuotaFilterComponent;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DescribeClusterRequest;
import org.apache.kafka.common.requests.DescribeClusterResponse;
import org.apache.kafka.controller.QuorumController;
import org.apache.kafka.controller.QuorumControllerIntegrationTestUtils;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.BrokerState;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@Timeout(value=120L)
@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\r\u001de\u0001\u0002\u001b6\u0001iBQ!\u0011\u0001\u0005\u0002\tCq!\u0012\u0001C\u0002\u0013\u0005a\t\u0003\u0004P\u0001\u0001\u0006Ia\u0012\u0005\b!\u0002\u0011\r\u0011\"\u0001G\u0011\u0019\t\u0006\u0001)A\u0005\u000f\")!\u000b\u0001C\u0001'\")!\r\u0001C\u0001'\")A\r\u0001C\u0001'\")a\r\u0001C\u0001'\")\u0001\u000e\u0001C\u0001'\")!\u000e\u0001C\u0001'\")A\u000e\u0001C\u0001'\")a\u000e\u0001C\u0001_\"9\u0011q\u0003\u0001\u0005\u0002\u0005e\u0001BBA\u001a\u0001\u0011\u00051\u000b\u0003\u0004\u00028\u0001!\ta\u0015\u0005\u0007\u0003w\u0001A\u0011A*\t\r\u0005}\u0002\u0001\"\u0001T\u0011\u001d\t\u0019\u0005\u0001C\u0005\u0003\u000bB\u0011\"a#\u0001#\u0003%I!!$\t\u000f\u0005\r\u0006\u0001\"\u0003\u0002&\"9\u0011Q\u001c\u0001\u0005\n\u0005}\u0007b\u0002B\u0002\u0001\u0011%!Q\u0001\u0005\b\u0005'\u0001A\u0011\u0002B\u000b\u0011\u0019\u0011)\u0003\u0001C\u0001'\"9!\u0011\u0006\u0001\u0005\n\t-\u0002b\u0002B$\u0001\u0011%!\u0011\n\u0005\b\u0005S\u0002A\u0011\u0002B6\u0011\u001d\u0011I\b\u0001C\u0005\u0005wBqAa)\u0001\t\u0013\u0011)\u000bC\u0005\u0003>\u0002\t\n\u0011\"\u0003\u0003@\"1!1\u0019\u0001\u0005\u0002MCaAa2\u0001\t\u0003\u0019\u0006b\u0002Bf\u0001\u0011\u0005!Q\u001a\u0005\u0007\u0005?\u0004A\u0011A*\t\u000f\t\r\b\u0001\"\u0003\u0003f\"9!\u0011 \u0001\u0005\n\tm\bbBB\u0001\u0001\u0011%11\u0001\u0005\u0007\u0007\u0013\u0001A\u0011A*\t\u000f\r5\u0001\u0001\"\u0001\u0004\u0010!111\u0003\u0001\u0005\u0002MCaaa\u0006\u0001\t\u0003\u0019\u0006BBB\u000e\u0001\u0011\u00051\u000b\u0003\u0004\u0004 \u0001!\ta\u0015\u0005\u0007\u0007G\u0001A\u0011A*\t\r\r\u001d\u0002\u0001\"\u0001T\u0011\u001d\u0019Y\u0003\u0001C\u0001\u0007[Aqaa\u0016\u0001\t\u0003\u0019I\u0006\u0003\u0004\u0004f\u0001!\ta\u0015\u0005\u0007\u0007S\u0002A\u0011A*\t\r\r5\u0004\u0001\"\u0001T\u0005AY%+\u00194u\u00072,8\u000f^3s)\u0016\u001cHO\u0003\u00027o\u000511/\u001a:wKJT\u0011\u0001O\u0001\u0006W\u000647.Y\u0002\u0001'\t\u00011\b\u0005\u0002=\u007f5\tQHC\u0001?\u0003\u0015\u00198-\u00197b\u0013\t\u0001UH\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\r\u0003\"\u0001\u0012\u0001\u000e\u0003U\n1\u0001\\8h+\u00059\u0005C\u0001%N\u001b\u0005I%B\u0001&L\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005a\u0015aA8sO&\u0011a*\u0013\u0002\u0007\u0019><w-\u001a:\u0002\t1|w\rI\u0001\u0005Y><''A\u0003m_\u001e\u0014\u0004%A\ruKN$8I]3bi\u0016\u001cE.^:uKJ\fe\u000eZ\"m_N,G#\u0001+\u0011\u0005q*\u0016B\u0001,>\u0005\u0011)f.\u001b;)\u0005\u0019A\u0006CA-a\u001b\u0005Q&BA.]\u0003\r\t\u0007/\u001b\u0006\u0003;z\u000bqA[;qSR,'O\u0003\u0002`\u0017\u0006)!.\u001e8ji&\u0011\u0011M\u0017\u0002\u0005)\u0016\u001cH/A\u0013uKN$8I]3bi\u0016\u001cE.^:uKJ\fe\u000e\u001a*fgR\f'\u000f\u001e\"s_.,'OT8eK\"\u0012q\u0001W\u0001*i\u0016\u001cHo\u0011:fCR,7\t\\;ti\u0016\u0014\u0018I\u001c3SKN$\u0018M\u001d;D_:$(o\u001c7mKJtu\u000eZ3)\u0005!A\u0016a\f;fgR\u001c%/Z1uK\u000ecWo\u001d;fe\u0006sGmV1ji\u001a{'O\u0011:pW\u0016\u0014\u0018J\u001c*v]:LgnZ*uCR,\u0007FA\u0005Y\u0003%\"Xm\u001d;De\u0016\fG/Z\"mkN$XM]!oI\u000e\u0013X-\u0019;f\u0019&\u001cH\u000fR3mKR,Gk\u001c9jG\"\u0012!\u0002W\u0001(i\u0016\u001cHo\u0011:fCR,7\t\\;ti\u0016\u0014\u0018I\u001c3De\u0016\fG/Z!oI6\u000bg.\u001f+pa&\u001c7\u000f\u000b\u0002\f1\u0006\u0001B/Z:u\u00072LWM\u001c;Rk>$\u0018m\u001d\u0015\u0003\u0019a\u000b1c]3u\u0007>t7/^7fe\nKH/\u001a*bi\u0016$R\u0001\u00169}\u0003\u001bAQ!]\u0007A\u0002I\fQ!\u00193nS:\u0004\"a\u001d>\u000e\u0003QT!!];\u000b\u0005Y<\u0018aB2mS\u0016tGo\u001d\u0006\u0003qaT!!_&\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tYHOA\u0003BI6Lg\u000eC\u0003~\u001b\u0001\u0007a0\u0001\u0004f]RLG/\u001f\t\u0004\u007f\u0006%QBAA\u0001\u0015\u0011\t\u0019!!\u0002\u0002\u000bE,x\u000e^1\u000b\u0007\u0005\u001dq/\u0001\u0004d_6lwN\\\u0005\u0005\u0003\u0017\t\tAA\tDY&,g\u000e^)v_R\fWI\u001c;jifDq!a\u0004\u000e\u0001\u0004\t\t\"A\u0003wC2,X\rE\u0002=\u0003'I1!!\u0006>\u0005\u0011auN\\4\u0002)\u001d,GoQ8ogVlWM\u001d\"zi\u0016\u0014\u0016\r^3t)\u0011\tY\"!\r\u0011\u000f\u0005u\u00111\u0006@\u0002\u00129!\u0011qDA\u0014!\r\t\t#P\u0007\u0003\u0003GQ1!!\n:\u0003\u0019a$o\\8u}%\u0019\u0011\u0011F\u001f\u0002\rA\u0013X\rZ3g\u0013\u0011\ti#a\f\u0003\u00075\u000b\u0007OC\u0002\u0002*uBQ!\u001d\bA\u0002I\fq\u0003^3ti\u0012+g-Y;mi\u000ec\u0017.\u001a8u#V|G/Y:)\u0005=A\u0016a\n;fgR\u001c%/Z1uK\u000ecWo\u001d;fe^KG\u000f[!em\u0016\u0014H/[:fIB{'\u000f\u001e.fe>D#\u0001\u0005-\u0002\u0007R,7\u000f^\"sK\u0006$Xm\u00117vgR,'oV5uQ\u0006#g/\u001a:uSN,G\rS8ti\u0006sG\rU8si\u0012KgMZ3sK:$hI]8n'>\u001c7.\u001a;TKJ4XM\u001d\u0015\u0003#a\u000bq\u0005^3ti\u000e\u0013X-\u0019;f\u00072,8\u000f^3s\u0013:4\u0018\r\\5e\u001b\u0016$\u0018\rZ1uCZ+'o]5p]\"\u0012!\u0003W\u0001\u0018I>|en\u0015;beR,GmS1gW\u0006\u001cE.^:uKJ$\u0002\"a\u0012\u0002`\u0005%\u0014Q\u000e\u000b\u0004)\u0006%\u0003bBA&'\u0001\u0007\u0011QJ\u0001\u0007C\u000e$\u0018n\u001c8\u0011\rq\ny%a\u0015U\u0013\r\t\t&\u0010\u0002\n\rVt7\r^5p]F\u0002B!!\u0016\u0002\\5\u0011\u0011q\u000b\u0006\u0004\u00033:\u0014a\u0002;fgR\\\u0017\u000e^\u0005\u0005\u0003;\n9FA\nLC\u001a\\\u0017m\u00117vgR,'\u000fV3ti.KG\u000fC\u0005\u0002bM\u0001\n\u00111\u0001\u0002d\u0005\u0011b.^7D_:$(o\u001c7mKJtu\u000eZ3t!\ra\u0014QM\u0005\u0004\u0003Oj$aA%oi\"9\u00111N\nA\u0002\u0005\r\u0014A\u00048v[\n\u0013xn[3s\u001d>$Wm\u001d\u0005\b\u0003_\u001a\u0002\u0019AA9\u0003]\u0011'o\\6feB\u0013x\u000e]3sif|e/\u001a:sS\u0012,7\u000fE\u0005=\u0003g\n9(! \u0002\u0004&\u0019\u0011QO\u001f\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004\u0003BA+\u0003sJA!a\u001f\u0002X\taA+Z:u\u0017&$hj\u001c3fgB!\u0011QKA@\u0013\u0011\t\t)a\u0016\u0003\u0015\t\u0013xn[3s\u001d>$W\r\u0005\u0005\u0002\u001e\u0005-\u0012QQAC!\u0011\ti\"a\"\n\t\u0005%\u0015q\u0006\u0002\u0007'R\u0014\u0018N\\4\u0002C\u0011|wJ\\*uCJ$X\rZ&bM.\f7\t\\;ti\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005=%\u0006BA2\u0003#[#!a%\u0011\t\u0005U\u0015qT\u0007\u0003\u0003/SA!!'\u0002\u001c\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003;k\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011UAL\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001?g\u0016tG\rR3tGJL'-Z\"mkN$XM\u001d*fcV,7\u000f\u001e+p\u0005>,h\u000e\u001a)peR,f\u000e^5m\u00032d'I]8lKJ\u001c\bK]8qC\u001e\fG/\u001a3\u0015\r\u0005\u001d\u0016\u0011XAe)\u0011\tI+!.\u0011\t\u0005-\u0016\u0011W\u0007\u0003\u0003[SA!a,\u0002\u0006\u0005A!/Z9vKN$8/\u0003\u0003\u00024\u00065&a\u0006#fg\u000e\u0014\u0018NY3DYV\u001cH/\u001a:SKN\u0004xN\\:f\u0011\u001d\t9,\u0006a\u0002\u0003'\nqa\u00197vgR,'\u000fC\u0004\u0002<V\u0001\r!!0\u0002\u00191L7\u000f^3oKJt\u0015-\\3\u0011\t\u0005}\u0016QY\u0007\u0003\u0003\u0003TA!a1\u0002\u0006\u00059a.\u001a;x_J\\\u0017\u0002BAd\u0003\u0003\u0014A\u0002T5ti\u0016tWM\u001d(b[\u0016Dq!a3\u0016\u0001\u0004\ti-\u0001\u0005xC&$H+[7f!\u0011\ty-!7\u000e\u0005\u0005E'\u0002BAj\u0003+\f\u0001\u0002Z;sCRLwN\u001c\u0006\u0004\u0003/l\u0014AC2p]\u000e,(O]3oi&!\u00111\\Ai\u000591\u0015N\\5uK\u0012+(/\u0019;j_:\fQc^1ji\u001a{'OU;o]&twM\u0011:pW\u0016\u00148\u000f\u0006\u0004\u0002b\u0006u(\u0011\u0001\u000b\u0005\u0003G\fY\u0010\u0005\u0004\u0002f\u0006=\u0018Q\u001f\b\u0005\u0003O\fYO\u0004\u0003\u0002\"\u0005%\u0018\"\u0001 \n\u0007\u00055X(A\u0004qC\u000e\\\u0017mZ3\n\t\u0005E\u00181\u001f\u0002\u0004'\u0016\f(bAAw{A\u0019A)a>\n\u0007\u0005eXG\u0001\u0007Ce>\\WM]*feZ,'\u000fC\u0004\u00028Z\u0001\u001d!a\u0015\t\u000f\u0005}h\u00031\u0001\u0002d\u0005)1m\\;oi\"9\u00111\u001a\fA\u0002\u00055\u0017aO:f]\u0012$Um]2sS\n,7\t\\;ti\u0016\u0014(+Z9vKN$Hk\u001c\"pk:$\u0007k\u001c:u+:$\u0018\u000e\u001c\"s_.,'o\u001d)s_B\fw-\u0019;fIRQ\u0011\u0011\u0016B\u0004\u0005\u0017\u0011iA!\u0005\t\u000f\t%q\u00031\u0001\u0002v\u0006YA-Z:uS:\fG/[8o\u0011\u001d\tYl\u0006a\u0001\u0003{CqAa\u0004\u0018\u0001\u0004\t\u0019'A\nfqB,7\r^3e\u0005J|7.\u001a:D_VtG\u000fC\u0004\u0002L^\u0001\r!!4\u0002KM,g\u000e\u001a#fg\u000e\u0014\u0018NY3DYV\u001cH/\u001a:SKF,Xm\u001d;U_\n{WO\u001c3Q_J$HCBAU\u0005/\u0011\u0019\u0003C\u0004\u0003\na\u0001\rA!\u0007\u0011\t\tm!qD\u0007\u0003\u0005;Q1!a18\u0013\u0011\u0011\tC!\b\u0003\u0019M{7m[3u'\u0016\u0014h/\u001a:\t\u000f\u0005m\u0006\u00041\u0001\u0002>\u00069C/Z:u\u0007J,\u0017\r^3DYV\u001cH/\u001a:B]\u0012\u0004VM\u001d4pe6\u0014V-Y:tS\u001etW.\u001a8uQ\tI\u0002,A\ndQ\u0016\u001c7NU3qY&\u001c\u0017-T1oC\u001e,'\u000fF\u0003U\u0005[\u0011y\u0003C\u0004\u00028j\u0001\r!a\u0015\t\u000f\tE\"\u00041\u0001\u00034\u0005yQ\r\u001f9fGR,G\rS8ti&tw\r\u0005\u0004\u0002f\nU\"\u0011H\u0005\u0005\u0005o\t\u0019P\u0001\u0003MSN$\bc\u0002\u001f\u0003<\u0005\r$qH\u0005\u0004\u0005{i$A\u0002+va2,'\u0007\u0005\u0004\u0002f\nU\"\u0011\t\t\u0004y\t\r\u0013b\u0001B#{\t9!i\\8mK\u0006t\u0017a\u0007;sC:\u001cH.\u0019;f!\u0006\u0014H/\u001b;j_:LeNZ8U_N+\u0017\u000f\u0006\u0003\u0003L\t=\u0003CBAs\u0003_\u0014i\u0005\u0005\u0004\u0002f\u0006=\u00181\r\u0005\b\u0005#Z\u0002\u0019\u0001B*\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0007\u0005+\u0012yF!\u0019\u000e\u0005\t]#\u0002\u0002B-\u00057\nA!\u001e;jY*\u0011!QL\u0001\u0005U\u00064\u0018-\u0003\u0003\u00038\t]\u0003\u0003\u0002B2\u0005Kj!!!\u0002\n\t\t\u001d\u0014Q\u0001\u0002\u0013)>\u0004\u0018n\u0019)beRLG/[8o\u0013:4w.A\nxC&$hi\u001c:U_BL7\rT5ti&tw\rF\u0004U\u0005[\u0012yG!\u001e\t\u000bEd\u0002\u0019\u0001:\t\u000f\tED\u00041\u0001\u0003t\u0005yQ\r\u001f9fGR,G\r\u0015:fg\u0016tG\u000f\u0005\u0004\u0002f\u0006=\u0018Q\u0011\u0005\b\u0005ob\u0002\u0019\u0001B:\u00039)\u0007\u0010]3di\u0016$\u0017IY:f]R\f\u0001#\u001b8de\u0016lWM\u001c;bY\u0006cG/\u001a:\u0015\r\tu$Q\u0011BD!\u0019\t)/a<\u0003\u0000A!\u00111\u0016BA\u0013\u0011\u0011\u0019)!,\u0003\u0011\u0005\u0003\u0018.\u0012:s_JDQ!]\u000fA\u0002IDqA!#\u001e\u0001\u0004\u0011Y)A\u0004dQ\u0006tw-Z:\u0011\r\u0005\u0015\u0018q\u001eBG!\u001da$1\bBH\u00057\u0003BA!%\u0003\u00186\u0011!1\u0013\u0006\u0005\u0005+\u000b)!\u0001\u0004d_:4\u0017nZ\u0005\u0005\u00053\u0013\u0019J\u0001\bD_:4\u0017n\u001a*fg>,(oY3\u0011\r\u0005\u0015\u0018q\u001eBO!\r\u0019(qT\u0005\u0004\u0005C#(!D!mi\u0016\u00148i\u001c8gS\u001e|\u0005/A\bwC2LG-\u0019;f\u0007>tg-[4t)!\u00119K!,\u00030\ne\u0006\u0003CA\u000f\u0003W\u0011yI!+\u0011\u0011\tU#1VAC\u0003\u000bKA!!\f\u0003X!)\u0011O\ba\u0001e\"9!\u0011\u0017\u0010A\u0002\tM\u0016\u0001C3ya\u0016\u001cG/\u001a3\u0011\u0011\u0005u\u00111\u0006BH\u0005k\u0003b!!:\u0002p\n]\u0006c\u0002\u001f\u0003<\u0005\u0015\u0015Q\u0011\u0005\n\u0005ws\u0002\u0013!a\u0001\u0005\u0003\n!\"\u001a=iCV\u001cH/\u001b<f\u0003e1\u0018\r\\5eCR,7i\u001c8gS\u001e\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t\u0005'\u0006\u0002B!\u0003#\u000b1\u0004^3ti&s7M]3nK:$\u0018\r\\!mi\u0016\u00148i\u001c8gS\u001e\u001c\bF\u0001\u0011Y\u0003i!Xm\u001d;TKRdun\u001a\u001bk\u0007>tg-[4ve\u0006$\u0018n\u001c8tQ\t\t\u0003,A\u0006mK\u001e\f7-_!mi\u0016\u0014HC\u0002B?\u0005\u001f\u0014\t\u000eC\u0003rE\u0001\u0007!\u000fC\u0004\u0003T\n\u0002\rA!6\u0002\u0013I,7o\\;sG\u0016\u001c\b\u0003CA\u000f\u0003W\u0011yIa6\u0011\r\u0005\u0015\u0018q\u001eBm!\r\u0019(1\\\u0005\u0004\u0005;$(aC\"p]\u001aLw-\u00128uef\fa\u0003^3ti2+w-Y2z\u00032$XM]\"p]\u001aLwm\u001d\u0015\u0003Ga\u000bAb\u00197vgR,'/S7bO\u0016$bAa:\u0003t\nU\b\u0003\u0002Bu\u0005_l!Aa;\u000b\u0007\t5x/A\u0003j[\u0006<W-\u0003\u0003\u0003r\n-(\u0001D\"mkN$XM]%nC\u001e,\u0007bBA\\I\u0001\u0007\u00111\u000b\u0005\b\u0005o$\u0003\u0019AA2\u0003!\u0011'o\\6fe&#\u0017\u0001\u00052s_.,'/S:V]\u001a,gnY3e)\u0019\u0011\tE!@\u0003\u0000\"9!Q^\u0013A\u0002\t\u001d\bb\u0002B|K\u0001\u0007\u00111M\u0001\u000fEJ|7.\u001a:Jg\u0006\u00137/\u001a8u)\u0019\u0011\te!\u0002\u0004\b!9!Q\u001e\u0014A\u0002\t\u001d\bb\u0002B|M\u0001\u0007\u00111M\u0001\u0015i\u0016\u001cH/\u00168sK\u001eL7\u000f^3s\u0005J|7.\u001a:)\u0005\u001dB\u0016!E2sK\u0006$X-\u00113nS:\u001cE.[3oiR\u0019!o!\u0005\t\u000f\u0005]\u0006\u00061\u0001\u0002T\u0005\u0011C/Z:u\t\u0016\u001c8M]5cKF+xN];n%\u0016\fX/Z:u)>\u0014%o\\6feND#!\u000b-\u00023Q,7\u000f^+qI\u0006$X-T3uC\u0012\fG/\u0019,feNLwN\u001c\u0015\u0003Ua\u000b\u0011\u0005^3tiJ+Wn\u001c;f\u0019><W*\u00198bO\u0016\u0014\u0018J\\:uC:$\u0018.\u0019;j_:D#a\u000b-\u0002#Q,7\u000f^*oCB\u001c\bn\u001c;D_VtG\u000f\u000b\u0002-1\u0006iC/Z:u\u0003V$\bn\u001c:ju\u0016\u0014h)Y5mkJ,gi\\;oI&s7i\u001c8ue>dG.\u001a:Ti\u0006\u0014H/\u001e9)\u00055B\u0016a\n;fgR\u001c\u0016N\\4mK\u000e{g\u000e\u001e:pY2,'oU5oO2,'I]8lKJ\u001cE.^:uKJD#A\f-\u0002KQ,7\u000f\u001e*fG>tg-[4ve\u0016\u001cuN\u001c;s_2dWM]\"mS\u0016tG/U;pi\u0006\u001cHc\u0001+\u00040!91\u0011G\u0018A\u0002\t\u0005\u0013AE2p[\nLg.\u001a3D_:$(o\u001c7mKJDsaLB\u001b\u0007\u000b\u001a9\u0005\u0005\u0003\u00048\r\u0005SBAB\u001d\u0015\u0011\u0019Yd!\u0010\u0002\u0011A\u0014xN^5eKJT1aa\u0010]\u0003\u0019\u0001\u0018M]1ng&!11IB\u001d\u0005-1\u0016\r\\;f'>,(oY3\u0002\u0011\t|w\u000e\\3b]NdCa!\u0013\u0004Le\t\u0001!G\u0001\u0002Q\ry3q\n\t\u0005\u0007#\u001a\u0019&\u0004\u0002\u0004>%!1QKB\u001f\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001$i\u0016\u001cHOU3d_:4\u0017nZ;sK\u000e{g\u000e\u001e:pY2,'/Q;uQ>\u0014\u0018N_3s)\r!61\f\u0005\b\u0007;\u0002\u0004\u0019\u0001B!\u00031\u0019w.\u001c2j]\u0016$Wj\u001c3fQ\u001d\u00014QGB#\u0007CbCa!\u0013\u0004L!\u001a\u0001ga\u0014\u00027Q,7\u000f^(wKJd\u0017\u0010T1sO\u0016\u001c%/Z1uKR{\u0007/[2tQ\t\t\u0004,\u0001\fuKN$H+[7fI>+H\u000fS3beR\u0014W-\u0019;tQ\t\u0011\u0004,\u0001\u001duKN$8\u000b^1siV\u0004x+\u001b;i\u001d>tG)\u001a4bk2$8jQ8oiJ|G\u000e\\3s\tft\u0017-\\5d\u0007>tg-[4ve\u0006$\u0018n\u001c8)\u0005MB\u0006f\u0002\u0001\u0004t\u0005=1\u0011\u0010\t\u00043\u000eU\u0014bAB<5\n\u0019A+Y4\"\u0005\rm\u0014aC5oi\u0016<'/\u0019;j_:Ds\u0001AB@\u0003\u001f\u0019)\tE\u0002Z\u0007\u0003K1aa![\u0005\u001d!\u0016.\\3pkRt\u0012\u0001\u001f")
public class KRaftClusterTest {
    private final Logger log = LoggerFactory.getLogger(KRaftClusterTest.class);
    private final Logger log2 = LoggerFactory.getLogger((String)new StringBuilder(1).append(KRaftClusterTest.class.getCanonicalName()).append("2").toString());

    public Logger log() {
        return this.log;
    }

    public Logger log2() {
        return this.log2;
    }

    @Test
    public void testCreateClusterAndClose() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
        }
    }

    @Test
    public void testCreateClusterAndRestartBrokerNode() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            BrokerServer broker = cluster.brokers().values().iterator().next();
            broker.shutdown();
            broker.startup();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateClusterAndRestartControllerNode() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            ControllerServer controller = (ControllerServer)CollectionConverters$.MODULE$.IteratorHasAsScala(cluster.controllers().values().iterator()).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$testCreateClusterAndRestartControllerNode$1(x$1))).next();
            int port = controller.socketServer().boundPort(((EndPoint)controller.config().controllerListeners().head()).listenerName());
            controller.shutdown();
            java.util.Map config = controller.sharedServer().controllerConfig().props();
            ((HashMap)config).put(KafkaConfig$.MODULE$.ListenersProp(), new StringBuilder(23).append("CONTROLLER://localhost:").append(port).toString());
            controller.sharedServer().controllerConfig().updateCurrentConfig(new KafkaConfig(config));
            controller.sharedServer().metrics_$eq(new Metrics());
            controller.startup();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndRestartControllerNode$2(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timeout waiting for new controller election");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateClusterAndWaitForBrokerInRunningState() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndWaitForBrokerInRunningState$1(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Broker never made it to RUNNING state.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndWaitForBrokerInRunningState$3(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"RaftManager was not initialized.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                Assertions.assertEquals((Object)cluster.nodes().clusterId().toString(), (Object)admin.describeCluster().clusterId().get());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateClusterAndCreateListDeleteTopic() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(3).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndCreateListDeleteTopic$1(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Broker never made it to RUNNING state.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndCreateListDeleteTopic$3(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"RaftManager was not initialized.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                java.util.List<NewTopic> newTopic = Collections.singletonList(new NewTopic("test-topic", 1, (short)3));
                admin.createTopics(newTopic).all().get();
                this.waitForTopicListing(admin, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"test-topic", (List)Nil$.MODULE$), (scala.collection.immutable.Seq<String>)Nil$.MODULE$);
                admin.deleteTopics(Collections.singletonList("test-topic")).all().get();
                this.waitForTopicListing(admin, (scala.collection.immutable.Seq<String>)Nil$.MODULE$, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"test-topic", (List)Nil$.MODULE$));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateClusterAndCreateAndManyTopics() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(3).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndCreateAndManyTopics$1(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Broker never made it to RUNNING state.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndCreateAndManyTopics$3(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"RaftManager was not initialized.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                ArrayList<NewTopic> newTopic = new ArrayList<NewTopic>();
                newTopic.add(new NewTopic("test-topic-1", 2, (short)3));
                newTopic.add(new NewTopic("test-topic-2", 2, (short)3));
                newTopic.add(new NewTopic("test-topic-3", 2, (short)3));
                admin.createTopics(newTopic).all().get();
                this.waitForTopicListing(admin, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"test-topic-1", (List)new .colon.colon((Object)"test-topic-2", (List)new .colon.colon((Object)"test-topic-3", (List)Nil$.MODULE$))), (scala.collection.immutable.Seq<String>)Nil$.MODULE$);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClientQuotas() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testClientQuotas$1(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Broker never made it to RUNNING state.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                Object var19_19;
                Tuple2 tuple2;
                ClientQuotaEntity entity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"testkit")}))).asJava());
                ClientQuotaFilter clientQuotaFilter = ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"testkit"), (List)Nil$.MODULE$)).asJava());
                java.util.Map describeResult = KRaftClusterTest.alterThenDescribe$1(entity, (scala.collection.immutable.Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("request_percentage", Predef$.MODULE$.double2Double(0.99)), (List)Nil$.MODULE$), clientQuotaFilter, 1, admin);
                Assertions.assertEquals((double)0.99, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("request_percentage")), (double)1.0E-6);
                describeResult = KRaftClusterTest.alterThenDescribe$1(entity, (scala.collection.immutable.Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("request_percentage", Predef$.MODULE$.double2Double(0.97)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(10000.0)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(10001.0)), (List)Nil$.MODULE$))), clientQuotaFilter, 3, admin);
                Assertions.assertEquals((double)0.97, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("request_percentage")), (double)1.0E-6);
                Assertions.assertEquals((double)10000.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("producer_byte_rate")), (double)1.0E-6);
                Assertions.assertEquals((double)10001.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("consumer_byte_rate")), (double)1.0E-6);
                describeResult = KRaftClusterTest.alterThenDescribe$1(entity, (scala.collection.immutable.Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("request_percentage", Predef$.MODULE$.double2Double(0.95)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", null), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", null), (List)Nil$.MODULE$))), clientQuotaFilter, 1, admin);
                Assertions.assertEquals((double)0.95, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("request_percentage")), (double)1.0E-6);
                KRaftClusterTest.alterThenDescribe$1(entity, (scala.collection.immutable.Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("request_percentage", null), (List)Nil$.MODULE$), clientQuotaFilter, 0, admin);
                describeResult = null;
                describeResult = KRaftClusterTest.alterThenDescribe$1(entity, (scala.collection.immutable.Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(9999.0)), (List)Nil$.MODULE$), clientQuotaFilter, 1, admin);
                Assertions.assertEquals((double)9999.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("producer_byte_rate")), (double)1.0E-6);
                ClientQuotaEntity entity2 = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"testkit"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"some-client")}))).asJava());
                clientQuotaFilter = ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"testkit"), (List)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"client-id", (String)"some-client"), (List)Nil$.MODULE$))).asJava());
                describeResult = KRaftClusterTest.alterThenDescribe$1(entity2, (scala.collection.immutable.Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(9998.0)), (List)Nil$.MODULE$), clientQuotaFilter, 1, admin);
                Assertions.assertEquals((double)9998.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity2)).get("producer_byte_rate")), (double)1.0E-6);
                clientQuotaFilter = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"testkit"), (List)Nil$.MODULE$)).asJava());
                long l2 = 100L;
                long tryUntilNoAssertionError_waitTime = 15000L;
                long tryUntilNoAssertionError_computeUntilTrue_startTime = System.currentTimeMillis();
                while (true) {
                    void tryUntilNoAssertionError_pause;
                    Right right;
                    try {
                        java.util.Map $anonfun$testClientQuotas$5_results = (java.util.Map)admin.describeClientQuotas(clientQuotaFilter).entities().get();
                        Assertions.assertEquals((int)2, (int)$anonfun$testClientQuotas$5_results.size(), (String)"Broker did not see two client quotas");
                        Assertions.assertEquals((double)9999.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)$anonfun$testClientQuotas$5_results.get(entity)).get("producer_byte_rate")), (double)1.0E-6);
                        Assertions.assertEquals((double)9998.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)$anonfun$testClientQuotas$5_results.get(entity2)).get("producer_byte_rate")), (double)1.0E-6);
                        Object var25_17 = null;
                        BoxedUnit $anonfun$tryUntilNoAssertionError$1_res = BoxedUnit.UNIT;
                        right = scala.package$.MODULE$.Left().apply((Object)$anonfun$tryUntilNoAssertionError$1_res);
                    }
                    catch (AssertionError $anonfun$tryUntilNoAssertionError$1_ae) {
                        right = scala.package$.MODULE$.Right().apply((Object)$anonfun$tryUntilNoAssertionError$1_ae);
                    }
                    Object var23_14 = null;
                    Object var24_15 = null;
                    Right tryUntilNoAssertionError_computeUntilTrue_result = right;
                    if (((Either)tryUntilNoAssertionError_computeUntilTrue_result).isLeft()) {
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                        break;
                    }
                    if (System.currentTimeMillis() > tryUntilNoAssertionError_computeUntilTrue_startTime + tryUntilNoAssertionError_waitTime) {
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                        break;
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(tryUntilNoAssertionError_waitTime), (long)tryUntilNoAssertionError_pause));
                }
                Object var22_13 = null;
                Tuple2 tuple22 = tuple2;
                if (tuple22 == null) {
                    throw new MatchError(null);
                }
                Either tryUntilNoAssertionError_either = (Either)tuple22._1();
                tuple22._2$mcZ$sp();
                if (!(var19_19 instanceof Left)) {
                    if (var19_19 instanceof Right) {
                        throw (AssertionError)((Right)var19_19).value();
                    }
                    throw new MatchError((Object)var19_19);
                }
                ((Left)var19_19).value();
                tuple22 = null;
                var19_19 = null;
            }
        }
    }

    public void setConsumerByteRate(Admin admin, ClientQuotaEntity entity, long value) {
        admin.alterClientQuotas(Collections.singletonList(new ClientQuotaAlteration(entity, Collections.singletonList(new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double((double)value)))))).all().get();
    }

    public scala.collection.immutable.Map<ClientQuotaEntity, Object> getConsumerByteRates(Admin admin) {
        ClientQuotaFilter allFilter = ClientQuotaFilter.contains(Collections.emptyList());
        HashMap results = new HashMap();
        ((java.util.Map)admin.describeClientQuotas(allFilter).entities().get()).forEach((x0$1, x1$1) -> Option$.MODULE$.apply(x1$1.get("consumer_byte_rate")).foreach((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToLong((long)KRaftClusterTest.$anonfun$getConsumerByteRates$2(results, x0$1, x0$2))));
        return CollectionConverters$.MODULE$.MapHasAsScala(results).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDefaultClientQuotas() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testDefaultClientQuotas$1(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Broker never made it to RUNNING state.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                ClientQuotaEntity defaultUser = new ClientQuotaEntity(Collections.singletonMap("user", null));
                ClientQuotaEntity bobUser = new ClientQuotaEntity(Collections.singletonMap("user", "bob"));
                long l2 = 30000L;
                TestUtils$ retry_this = TestUtils$.MODULE$;
                long l3 = 1L;
                long retry_startTime = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testDefaultClientQuotas$3(this, admin);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this.logger().underlying().isInfoEnabled()) {
                            String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l3).append(", and then retrying.").toString();
                            Object var31_14 = null;
                            retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                        }
                        Thread.sleep(l3);
                        l3 += package$.MODULE$.min(l3, 1000L);
                        continue;
                    }
                    break;
                }
                Object var13_9 = null;
                Object var18_13 = null;
                this.setConsumerByteRate(admin, defaultUser, 100L);
                long l4 = 30000L;
                TestUtils$ retry_this2 = TestUtils$.MODULE$;
                long l5 = 1L;
                long retry_startTime2 = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testDefaultClientQuotas$4(this, defaultUser, admin);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this2.logger().underlying().isInfoEnabled()) {
                            String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l5).append(", and then retrying.").toString();
                            Object var32_19 = null;
                            retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                        }
                        Thread.sleep(l5);
                        l5 += package$.MODULE$.min(l5, 1000L);
                        continue;
                    }
                    break;
                }
                Object var19_16 = null;
                Object var24_21 = null;
                this.setConsumerByteRate(admin, bobUser, 1000L);
                long l6 = 30000L;
                TestUtils$ retry_this3 = TestUtils$.MODULE$;
                long l7 = 1L;
                long retry_startTime3 = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testDefaultClientQuotas$5(this, defaultUser, bobUser, admin);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime3 > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this3.logger().underlying().isInfoEnabled()) {
                            String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l7).append(", and then retrying.").toString();
                            Object var33_28 = null;
                            retry_this3.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this3, (String)msgWithLogIdent_msg));
                        }
                        Thread.sleep(l7);
                        l7 += package$.MODULE$.min(l7, 1000L);
                        continue;
                    }
                    break;
                }
                Object var25_23 = null;
                Object var30_27 = null;
            }
        }
    }

    @Test
    public void testCreateClusterWithAdvertisedPortZero() {
        Function2 & Serializable brokerPropertyOverrides = (Function2 & Serializable)(nodes, x$4) -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)KafkaConfig$.MODULE$.ListenersProp(), (Object)new StringBuilder(14).append(nodes.externalListenerName().value()).append("://localhost:0").toString()), new Tuple2((Object)KafkaConfig$.MODULE$.AdvertisedListenersProp(), (Object)new StringBuilder(14).append(nodes.externalListenerName().value()).append("://localhost:0").toString())}));
        int x$3 = 1;
        Function1 & Serializable x$42 = (Function1 & Serializable)cluster -> {
            KRaftClusterTest.$anonfun$testCreateClusterWithAdvertisedPortZero$2(this, cluster);
            return BoxedUnit.UNIT;
        };
        this.doOnStartedKafkaCluster(x$3, 3, (Function2<TestKitNodes, BrokerNode, scala.collection.immutable.Map<String, String>>)brokerPropertyOverrides, (Function1<KafkaClusterTestKit, BoxedUnit>)x$42);
    }

    @Test
    public void testCreateClusterWithAdvertisedHostAndPortDifferentFromSocketServer() {
        Function2 & Serializable brokerPropertyOverrides = (Function2 & Serializable)(nodes, broker) -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)KafkaConfig$.MODULE$.ListenersProp(), (Object)new StringBuilder(14).append(nodes.externalListenerName().value()).append("://localhost:0").toString()), new Tuple2((Object)KafkaConfig$.MODULE$.AdvertisedListenersProp(), (Object)new StringBuilder(20).append(nodes.externalListenerName().value()).append("://advertised-host-").append(broker.id()).append(":").append(broker.id() + 100).toString())}));
        int x$3 = 1;
        Function1 & Serializable x$4 = (Function1 & Serializable)cluster -> {
            KRaftClusterTest.$anonfun$testCreateClusterWithAdvertisedHostAndPortDifferentFromSocketServer$2(this, cluster);
            return BoxedUnit.UNIT;
        };
        this.doOnStartedKafkaCluster(x$3, 3, (Function2<TestKitNodes, BrokerNode, scala.collection.immutable.Map<String, String>>)brokerPropertyOverrides, (Function1<KafkaClusterTestKit, BoxedUnit>)x$4);
    }

    @Test
    public void testCreateClusterInvalidMetadataVersion() {
        Assertions.assertEquals((Object)"Bootstrap metadata versions before 3.3-IV0 are not supported. Can't load metadata from testkit", (Object)Assertions.assertThrows(RuntimeException.class, () -> new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_2_7_IV0).setNumBrokerNodes(1).setNumControllerNodes(1).build()).build()).getMessage());
    }

    private void doOnStartedKafkaCluster(int numControllerNodes, int numBrokerNodes, Function2<TestKitNodes, BrokerNode, scala.collection.immutable.Map<String, String>> brokerPropertyOverrides, Function1<KafkaClusterTestKit, BoxedUnit> action) {
        TestKitNodes nodes = new TestKitNodes.Builder().setNumControllerNodes(numControllerNodes).setNumBrokerNodes(numBrokerNodes).build();
        nodes.brokerNodes().values().forEach(broker -> broker.propertyOverrides().putAll(CollectionConverters$.MODULE$.MapHasAsJava((Map)brokerPropertyOverrides.apply((Object)nodes, broker)).asJava()));
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(nodes).build();){
            cluster.format();
            cluster.startup();
            action.apply((Object)cluster);
        }
    }

    private int doOnStartedKafkaCluster$default$1() {
        return 1;
    }

    private DescribeClusterResponse sendDescribeClusterRequestToBoundPortUntilAllBrokersPropagated(ListenerName listenerName, FiniteDuration waitTime, KafkaClusterTestKit cluster) {
        long startTime = System.currentTimeMillis();
        scala.collection.immutable.Seq<BrokerServer> runningBrokerServers = this.waitForRunningBrokers(1, waitTime, cluster);
        FiniteDuration remainingWaitTime = waitTime.$minus(scala.concurrent.duration.package$.MODULE$.pairLongToDuration(new Tuple2((Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - startTime)), (Object)TimeUnit.MILLISECONDS)));
        return this.sendDescribeClusterRequestToBoundPortUntilBrokersPropagated((BrokerServer)runningBrokerServers.head(), listenerName, cluster.nodes().brokerNodes().size(), remainingWaitTime);
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Seq<BrokerServer> waitForRunningBrokers(int count, FiniteDuration waitTime, KafkaClusterTestKit cluster) {
        void var5_9;
        Tuple2 tuple2;
        long l = 100L;
        long computeUntilTrue_waitTime = waitTime.toMillis();
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            scala.collection.immutable.Seq computeUntilTrue_result;
            if ((computeUntilTrue_result = KRaftClusterTest.getRunningBrokerServers$1(cluster)).nonEmpty()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var12_7 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Seq runningBrokerServers = (scala.collection.immutable.Seq)tuple22._1();
        Assertions.assertTrue((boolean)tuple22._2$mcZ$sp(), (String)new StringBuilder(82).append("After ").append(waitTime.toMillis()).append(" ms at least ").append(count).append(" broker(s) should be in RUNNING state, ").append("but only ").append(var5_9.size()).append(" broker(s) are.").toString());
        return var5_9;
    }

    /*
     * WARNING - void declaration
     */
    private DescribeClusterResponse sendDescribeClusterRequestToBoundPortUntilBrokersPropagated(BrokerServer destination, ListenerName listenerName, int expectedBrokerCount, FiniteDuration waitTime) {
        void var6_10;
        Tuple2 tuple2;
        long l = 100L;
        long computeUntilTrue_waitTime = waitTime.toMillis();
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            DescribeClusterResponse computeUntilTrue_result;
            if (KRaftClusterTest.$anonfun$sendDescribeClusterRequestToBoundPortUntilBrokersPropagated$2(expectedBrokerCount, computeUntilTrue_result = this.sendDescribeClusterRequestToBoundPort(destination.socketServer(), listenerName))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var13_8 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        DescribeClusterResponse describeClusterResponse = (DescribeClusterResponse)tuple22._1();
        Assertions.assertTrue((boolean)tuple22._2$mcZ$sp(), (String)new StringBuilder(62).append("After ").append(waitTime.toMillis()).append(" ms Broker is only aware of ").append(var6_10.nodes().size()).append(" brokers, ").append("but ").append(expectedBrokerCount).append(" are expected.").toString());
        return var6_10;
    }

    private DescribeClusterResponse sendDescribeClusterRequestToBoundPort(SocketServer destination, ListenerName listenerName) {
        return (DescribeClusterResponse)IntegrationTestUtils$.MODULE$.connectAndReceive(new DescribeClusterRequest.Builder(new DescribeClusterRequestData()).build(), destination, listenerName, ClassTag$.MODULE$.apply(DescribeClusterResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateClusterAndPerformReassignment() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                HashMap<Integer, java.util.List<Integer>> assignments = new HashMap<Integer, java.util.List<Integer>>();
                assignments.put(Predef$.MODULE$.int2Integer(0), Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)));
                assignments.put(Predef$.MODULE$.int2Integer(1), Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)));
                assignments.put(Predef$.MODULE$.int2Integer(2), Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(0)));
                assignments.put(Predef$.MODULE$.int2Integer(3), Arrays.asList(Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1)));
                admin.createTopics(Collections.singletonList(new NewTopic("foo", assignments))).all().get();
                this.waitForTopicListing(admin, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"foo", (List)Nil$.MODULE$), (scala.collection.immutable.Seq<String>)Nil$.MODULE$);
                Assertions.assertEquals(Collections.emptyMap(), (Object)admin.listPartitionReassignments().reassignments().get());
                HashMap<TopicPartition, Optional<NewPartitionReassignment>> reassignments = new HashMap<TopicPartition, Optional<NewPartitionReassignment>>();
                reassignments.put(new TopicPartition("foo", 0), Optional.of(new NewPartitionReassignment(Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)))));
                reassignments.put(new TopicPartition("foo", 1), Optional.of(new NewPartitionReassignment(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)))));
                reassignments.put(new TopicPartition("foo", 2), Optional.of(new NewPartitionReassignment(Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)))));
                reassignments.put(new TopicPartition("foo", 3), Optional.of(new NewPartitionReassignment(Arrays.asList(Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)))));
                admin.alterPartitionReassignments(reassignments).all().get();
                long l = 100L;
                long waitUntilTrue_waitTimeMs = 15000L;
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!KRaftClusterTest.$anonfun$testCreateClusterAndPerformReassignment$1(admin)) {
                    void waitUntilTrue_pause;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)"The reassignment never completed.");
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
                scala.collection.immutable.Seq<scala.collection.immutable.Seq<Object>> seq = Nil$.MODULE$;
                .colon.colon expectedMapping = new .colon.colon((Object)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 1, 0}))), (List)new .colon.colon((Object)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), (List)new .colon.colon((Object)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3}))), (List)new .colon.colon((Object)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 0, 1}))), (List)Nil$.MODULE$))));
                long l2 = 100L;
                long waitUntilTrue_waitTimeMs2 = 15000L;
                long waitUntilTrue_startTime2 = System.currentTimeMillis();
                while (true) {
                    void waitUntilTrue_pause;
                    boolean bl;
                    java.util.Map $anonfun$testCreateClusterAndPerformReassignment$3_topicInfoMap;
                    if (($anonfun$testCreateClusterAndPerformReassignment$3_topicInfoMap = (java.util.Map)admin.describeTopics(Collections.singleton("foo")).allTopicNames().get()).containsKey("foo")) {
                        seq = this.translatePartitionInfoToSeq(((TopicDescription)$anonfun$testCreateClusterAndPerformReassignment$3_topicInfoMap.get("foo")).partitions());
                        bl = expectedMapping.equals(seq);
                    } else {
                        bl = false;
                    }
                    Object var27_13 = null;
                    if (bl) break;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                        Assertions.fail((String)new StringBuilder(72).append("Timed out waiting for replica assignments for topic foo. ").append("Wanted: ").append(expectedMapping).append(". Got: ").append(seq).toString());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
                }
                long l3 = 60000L;
                TestUtils$ retry_this = TestUtils$.MODULE$;
                long l4 = 1L;
                long retry_startTime = System.currentTimeMillis();
                while (true) {
                    try {
                        this.checkReplicaManager(cluster, (List<Tuple2<Object, List<Object>>>)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, true, false, true}))), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, true, false, true}))), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, true, true, true}))), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)3), scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, false, true, true}))), (List)Nil$.MODULE$)))));
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this.logger().underlying().isInfoEnabled()) {
                            String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                            Object var26_20 = null;
                            retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                        }
                        Thread.sleep(l4);
                        l4 += package$.MODULE$.min(l4, 1000L);
                        continue;
                    }
                    break;
                }
                Object var20_15 = null;
                Object var25_19 = null;
            }
        }
    }

    private void checkReplicaManager(KafkaClusterTestKit cluster, List<Tuple2<Object, List<Object>>> expectedHosting) {
        expectedHosting.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$checkReplicaManager$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$9 -> {
            KRaftClusterTest.$anonfun$checkReplicaManager$2(cluster, x$9);
            return BoxedUnit.UNIT;
        });
    }

    private scala.collection.immutable.Seq<scala.collection.immutable.Seq<Object>> translatePartitionInfoToSeq(java.util.List<TopicPartitionInfo> partitions) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partitions).asScala().map((Function1 & Serializable)partition -> ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partition.replicas()).asScala().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.id()))).toSeq())).toSeq();
    }

    /*
     * WARNING - void declaration
     */
    private void waitForTopicListing(Admin admin, scala.collection.immutable.Seq<String> expectedPresent, scala.collection.immutable.Seq<String> expectedAbsent) {
        HashSet topicsNotFound = new HashSet();
        expectedPresent.foreach((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)topicsNotFound.add(x$1)));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            ((Iterable)admin.listTopics().names().get()).forEach(name -> topicsNotFound$1.remove(name));
            scala.collection.mutable.Set set = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala((java.util.Set)admin.listTopics().names().get()).asScala().filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)expectedAbsent$1.contains((Object)x$11)));
            if (topicsNotFound.isEmpty() && set.isEmpty()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)new StringBuilder(49).append("Failed to find topic(s): ").append(CollectionConverters$.MODULE$.SetHasAsScala(topicsNotFound).asScala()).append(" and NOT find topic(s): ").append(set).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private scala.collection.immutable.Seq<ApiError> incrementalAlter(Admin admin, scala.collection.immutable.Seq<Tuple2<ConfigResource, scala.collection.immutable.Seq<AlterConfigOp>>> changes) {
        HashMap configs = new HashMap();
        changes.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                ConfigResource resource = (ConfigResource)x0$1._1();
                scala.collection.immutable.Seq ops = (scala.collection.immutable.Seq)x0$1._2();
                return configs.put(resource, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ops).asJava());
            }
            throw new MatchError(null);
        });
        java.util.Map values = admin.incrementalAlterConfigs(configs).values();
        return (scala.collection.immutable.Seq)changes.map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                ConfigResource resource = (ConfigResource)x0$2._1();
                try {
                    ((KafkaFuture)values.get(resource)).get();
                    return ApiError.NONE;
                }
                catch (ExecutionException executionException) {
                    return ApiError.fromThrowable((Throwable)executionException.getCause());
                }
                catch (Throwable throwable) {
                    return ApiError.fromThrowable((Throwable)throwable);
                }
            }
            throw new MatchError(null);
        });
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Map<ConfigResource, java.util.Map<String, String>> validateConfigs(Admin admin, scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>> expected, boolean exhaustive) {
        scala.collection.mutable.HashMap results = new scala.collection.mutable.HashMap();
        long l = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                KRaftClusterTest.$anonfun$validateConfigs$1(this, admin, expected, results, exhaustive);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var11_11 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var5_6 = null;
        Object var10_10 = null;
        return results.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private boolean validateConfigs$default$3() {
        return false;
    }

    @Test
    public void testIncrementalAlterConfigs() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)Nil$.MODULE$), this.incrementalAlter(admin, (scala.collection.immutable.Seq<Tuple2<ConfigResource, scala.collection.immutable.Seq<AlterConfigOp>>>)new .colon.colon((Object)new Tuple2((Object)new ConfigResource(ConfigResource.Type.BROKER, ""), (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("log.roll.ms", "1234567"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("max.connections.per.ip", "60"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$))), (List)Nil$.MODULE$)));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.BROKER, "")), (Object)new .colon.colon((Object)new Tuple2((Object)"log.roll.ms", (Object)"1234567"), (List)new .colon.colon((Object)new Tuple2((Object)"max.connections.per.ip", (Object)"60"), (List)Nil$.MODULE$)))}))), true);
                admin.createTopics(Arrays.asList(new NewTopic("foo", 2, (short)3), new NewTopic("bar", 2, (short)3))).all().get();
                TestUtils$.MODULE$.waitForAllPartitionsMetadata(CollectionConverters$.MODULE$.CollectionHasAsScala(cluster.brokers().values()).asScala().toSeq(), "foo", 2);
                TestUtils$.MODULE$.waitForAllPartitionsMetadata(CollectionConverters$.MODULE$.CollectionHasAsScala(cluster.brokers().values()).asScala().toSeq(), "bar", 2);
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "bar")), (Object)Nil$.MODULE$)}))), false);
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)new .colon.colon((Object)new ApiError(Errors.INVALID_CONFIG, "Unknown topic config name: not.a.real.topic.config"), (List)new .colon.colon((Object)new ApiError(Errors.UNKNOWN_TOPIC_OR_PARTITION, "The topic 'baz' does not exist."), (List)Nil$.MODULE$))), this.incrementalAlter(admin, (scala.collection.immutable.Seq<Tuple2<ConfigResource, scala.collection.immutable.Seq<AlterConfigOp>>>)new .colon.colon((Object)new Tuple2((Object)new ConfigResource(ConfigResource.Type.TOPIC, "foo"), (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("segment.jitter.ms", "345"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new Tuple2((Object)new ConfigResource(ConfigResource.Type.TOPIC, "bar"), (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("not.a.real.topic.config", "789"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new Tuple2((Object)new ConfigResource(ConfigResource.Type.TOPIC, "baz"), (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("segment.jitter.ms", "678"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "foo")), (Object)new .colon.colon((Object)new Tuple2((Object)"segment.jitter.ms", (Object)"345"), (List)Nil$.MODULE$))}))), false);
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)Nil$.MODULE$), this.incrementalAlter(admin, (scala.collection.immutable.Seq<Tuple2<ConfigResource, scala.collection.immutable.Seq<AlterConfigOp>>>)new .colon.colon((Object)new Tuple2((Object)new ConfigResource(ConfigResource.Type.BROKER, "2"), (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("max.connections.per.ip", "7"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.BROKER, "2")), (Object)new .colon.colon((Object)new Tuple2((Object)"max.connections.per.ip", (Object)"7"), (List)Nil$.MODULE$))}))), false);
            }
        }
    }

    @Test
    public void testSetLog4jConfigurations() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                new .colon.colon((Object)this.log(), (List)new .colon.colon((Object)this.log2(), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)x$12 -> {
                    x$12.debug("setting log4j");
                    return BoxedUnit.UNIT;
                });
                ConfigResource broker2 = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, "2");
                ConfigResource broker3 = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, "3");
                scala.collection.immutable.Map<ConfigResource, java.util.Map<String, String>> initialLog4j = this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker2), (Object)Nil$.MODULE$)}))), false);
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)new .colon.colon((Object)new ApiError(Errors.INVALID_REQUEST, "APPEND operation is not allowed for the BROKER_LOGGER resource"), (List)Nil$.MODULE$)), this.incrementalAlter(admin, (scala.collection.immutable.Seq<Tuple2<ConfigResource, scala.collection.immutable.Seq<AlterConfigOp>>>)new .colon.colon((Object)new Tuple2((Object)broker2, (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log().getName(), "TRACE"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log2().getName(), "TRACE"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$))), (List)new .colon.colon((Object)new Tuple2((Object)broker3, (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log().getName(), "TRACE"), AlterConfigOp.OpType.APPEND), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log2().getName(), "TRACE"), AlterConfigOp.OpType.APPEND), (List)Nil$.MODULE$))), (List)Nil$.MODULE$))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker2), (Object)new .colon.colon((Object)new Tuple2((Object)this.log().getName(), (Object)"TRACE"), (List)new .colon.colon((Object)new Tuple2((Object)this.log2().getName(), (Object)"TRACE"), (List)Nil$.MODULE$)))}))), false);
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)new .colon.colon((Object)new ApiError(Errors.INVALID_REQUEST, "SUBTRACT operation is not allowed for the BROKER_LOGGER resource"), (List)Nil$.MODULE$)), this.incrementalAlter(admin, (scala.collection.immutable.Seq<Tuple2<ConfigResource, scala.collection.immutable.Seq<AlterConfigOp>>>)new .colon.colon((Object)new Tuple2((Object)broker2, (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log().getName(), ""), AlterConfigOp.OpType.DELETE), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log2().getName(), ""), AlterConfigOp.OpType.DELETE), (List)Nil$.MODULE$))), (List)new .colon.colon((Object)new Tuple2((Object)broker3, (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log().getName(), "TRACE"), AlterConfigOp.OpType.SUBTRACT), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log2().getName(), "TRACE"), AlterConfigOp.OpType.SUBTRACT), (List)Nil$.MODULE$))), (List)Nil$.MODULE$))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker2), (Object)new .colon.colon((Object)new Tuple2((Object)this.log().getName(), ((java.util.Map)initialLog4j.apply((Object)broker2)).get(this.log().getName())), (List)new .colon.colon((Object)new Tuple2((Object)this.log2().getName(), ((java.util.Map)initialLog4j.apply((Object)broker2)).get(this.log2().getName())), (List)Nil$.MODULE$)))}))), false);
            }
        }
    }

    public scala.collection.immutable.Seq<ApiError> legacyAlter(Admin admin, scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<ConfigEntry>> resources) {
        HashMap configs = new HashMap();
        resources.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                ConfigResource resource = (ConfigResource)x0$1._1();
                scala.collection.immutable.Seq entries = (scala.collection.immutable.Seq)x0$1._2();
                return configs.put(resource, new Config((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)entries).asJava()));
            }
            throw new MatchError(null);
        });
        java.util.Map values = admin.alterConfigs(configs).values();
        return ((IterableOnceOps)resources.map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                ConfigResource resource = (ConfigResource)x0$2._1();
                try {
                    ((KafkaFuture)values.get(resource)).get();
                    return ApiError.NONE;
                }
                catch (ExecutionException executionException) {
                    return ApiError.fromThrowable((Throwable)executionException.getCause());
                }
                catch (Throwable throwable) {
                    return ApiError.fromThrowable((Throwable)throwable);
                }
            }
            throw new MatchError(null);
        })).toSeq();
    }

    @Test
    public void testLegacyAlterConfigs() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                ConfigResource defaultBroker = new ConfigResource(ConfigResource.Type.BROKER, "");
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)Nil$.MODULE$), this.legacyAlter(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<ConfigEntry>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultBroker), (Object)new .colon.colon((Object)new ConfigEntry("log.roll.ms", "1234567"), (List)new .colon.colon((Object)new ConfigEntry("max.connections.per.ip", "6"), (List)Nil$.MODULE$)))})))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultBroker), (Object)new .colon.colon((Object)new Tuple2((Object)"log.roll.ms", (Object)"1234567"), (List)new .colon.colon((Object)new Tuple2((Object)"max.connections.per.ip", (Object)"6"), (List)Nil$.MODULE$)))}))), true);
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)Nil$.MODULE$), this.legacyAlter(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<ConfigEntry>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultBroker), (Object)new .colon.colon((Object)new ConfigEntry("log.roll.ms", "1234567"), (List)Nil$.MODULE$))})))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultBroker), (Object)new .colon.colon((Object)new Tuple2((Object)"log.roll.ms", (Object)"1234567"), (List)Nil$.MODULE$))}))), true);
                admin.createTopics(Arrays.asList(new NewTopic("foo", 2, (short)3), new NewTopic("bar", 2, (short)3))).all().get();
                TestUtils$.MODULE$.waitForAllPartitionsMetadata(CollectionConverters$.MODULE$.CollectionHasAsScala(cluster.brokers().values()).asScala().toSeq(), "foo", 2);
                TestUtils$.MODULE$.waitForAllPartitionsMetadata(CollectionConverters$.MODULE$.CollectionHasAsScala(cluster.brokers().values()).asScala().toSeq(), "bar", 2);
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)new .colon.colon((Object)new ApiError(Errors.INVALID_CONFIG, "Unknown topic config name: not.a.real.topic.config"), (List)new .colon.colon((Object)new ApiError(Errors.UNKNOWN_TOPIC_OR_PARTITION, "The topic 'baz' does not exist."), (List)Nil$.MODULE$))), this.legacyAlter(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<ConfigEntry>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "foo")), (Object)new .colon.colon((Object)new ConfigEntry("segment.jitter.ms", "345"), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "bar")), (Object)new .colon.colon((Object)new ConfigEntry("not.a.real.topic.config", "789"), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "baz")), (Object)new .colon.colon((Object)new ConfigEntry("segment.jitter.ms", "678"), (List)Nil$.MODULE$))})))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "foo")), (Object)new .colon.colon((Object)new Tuple2((Object)"segment.jitter.ms", (Object)"345"), (List)Nil$.MODULE$))}))), false);
            }
        }
    }

    private ClusterImage clusterImage(KafkaClusterTestKit cluster, int brokerId) {
        return cluster.brokers().get(BoxesRunTime.boxToInteger((int)brokerId)).metadataCache().currentImage().cluster();
    }

    private boolean brokerIsUnfenced(ClusterImage image, int brokerId) {
        Option option = Option$.MODULE$.apply(image.brokers().get(BoxesRunTime.boxToInteger((int)brokerId)));
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            return !((BrokerRegistration)((Some)option).value()).fenced();
        }
        throw new MatchError((Object)option);
    }

    private boolean brokerIsAbsent(ClusterImage image, int brokerId) {
        return Option$.MODULE$.apply(image.brokers().get(BoxesRunTime.boxToInteger((int)brokerId))).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUnregisterBroker() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!this.brokerIsUnfenced(this.clusterImage(cluster, 1), 0)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for broker 0 to be unfenced.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            cluster.brokers().get(BoxesRunTime.boxToInteger((int)0)).shutdown();
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testUnregisterBroker$3(this, cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"Timed out waiting for broker 0 to be fenced.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                admin.unregisterBroker(0);
            }
            long l3 = 100L;
            long waitUntilTrue_waitTimeMs3 = 15000L;
            long waitUntilTrue_startTime3 = System.currentTimeMillis();
            while (!this.brokerIsAbsent(this.clusterImage(cluster, 1), 0)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                    Assertions.fail((String)"Timed out waiting for broker 0 to be fenced.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
            }
        }
    }

    public Admin createAdminClient(KafkaClusterTestKit cluster) {
        Properties props = cluster.clientProperties();
        props.put("client.id", this.getClass().getName());
        return Admin.create((Properties)props);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeQuorumRequestToBrokers() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                long l = 100L;
                long waitUntilTrue_waitTimeMs = 15000L;
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$2(cluster, i)) {
                    void waitUntilTrue_pause;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)"Broker Never started up");
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
            });
            try (Admin admin = this.createAdminClient(cluster);){
                void var7_15;
                Tuple2 tuple2;
                void var5_9;
                Tuple2 tuple22;
                QuorumInfo quorumInfo = (QuorumInfo)admin.describeMetadataQuorum(new DescribeMetadataQuorumOptions()).quorumInfo().get();
                Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsScala(cluster.controllers()).asScala().keySet(), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(quorumInfo.voters()).asScala().map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13.replicaId()))).toSet());
                Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.MapHasAsScala(cluster.controllers()).asScala().keySet().contains((Object)Predef$.MODULE$.int2Integer(quorumInfo.leaderId())), (String)new StringBuilder(35).append("Leader ID ").append(quorumInfo.leaderId()).append(" was not a controller ID.").toString());
                long l = 100L;
                long computeUntilTrue_waitTime = 15000L;
                long computeUntilTrue_startTime = System.currentTimeMillis();
                while (true) {
                    void computeUntilTrue_pause;
                    java.util.List computeUntilTrue_result;
                    if (KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$6(computeUntilTrue_result = KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$5(admin))) {
                        tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                        break;
                    }
                    if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                        tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                        break;
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
                }
                Object var16_7 = null;
                Tuple2 tuple23 = tuple22;
                if (tuple23 == null) {
                    throw new MatchError(null);
                }
                java.util.List voters = (java.util.List)tuple23._1();
                Assertions.assertTrue((boolean)tuple23._2$mcZ$sp(), (String)new StringBuilder(111).append("At least one voter did not return the expected state within timeout.").append("The responses gathered for all the voters: ").append(var5_9.toString()).toString());
                long l2 = 100L;
                long computeUntilTrue_waitTime2 = 15000L;
                long computeUntilTrue_startTime2 = System.currentTimeMillis();
                while (true) {
                    void computeUntilTrue_pause;
                    java.util.List computeUntilTrue_result;
                    if (KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$9(cluster, computeUntilTrue_result = KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$8(admin))) {
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                        break;
                    }
                    if (System.currentTimeMillis() > computeUntilTrue_startTime2 + computeUntilTrue_waitTime2) {
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                        break;
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime2), (long)computeUntilTrue_pause));
                }
                Object var23_13 = null;
                Tuple2 tuple24 = tuple2;
                if (tuple24 == null) {
                    throw new MatchError(null);
                }
                java.util.List observers = (java.util.List)tuple24._1();
                Assertions.assertTrue((boolean)tuple24._2$mcZ$sp(), (String)new StringBuilder(117).append("At least one observer did not return the expected state within timeout.").append("The responses gathered for all the observers: ").append(var7_15.toString()).toString());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUpdateMetadataVersion() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.MINIMUM_BOOTSTRAP_VERSION).setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                admin.updateFeatures(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.version"), (Object)new FeatureUpdate(MetadataVersion.latest().featureLevel(), FeatureUpdate.UpgradeType.UPGRADE))}))).asJava(), new UpdateFeaturesOptions());
            }
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testUpdateMetadataVersion$1(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for metadata version update.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
    }

    @Test
    public void testRemoteLogManagerInstantiation() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).setConfigProp("remote.log.storage.system.enable", Boolean.toString(true)).setConfigProp("remote.log.metadata.manager.class.name", "org.apache.kafka.server.log.remote.storage.NoOpRemoteLogMetadataManager").setConfigProp("remote.log.storage.manager.class.name", "org.apache.kafka.server.log.remote.storage.NoOpRemoteStorageManager").build();){
            cluster.format();
            cluster.startup();
            cluster.brokers().forEach((x$17, server) -> {
                Option option = server.remoteLogManagerOpt();
                if (option instanceof Some) {
                    return;
                }
                if (None$.MODULE$.equals(option)) {
                    BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"RemoteLogManager should be initialized");
                    return;
                }
                throw new MatchError((Object)option);
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSnapshotCount() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp("metadata.log.max.snapshot.interval.ms", "500").setConfigProp("metadata.max.idle.interval.ms", "50").build();){
            cluster.format();
            cluster.startup();
            Path metaLog = FileSystems.getDefault().getPath(cluster.controllers().get(BoxesRunTime.boxToInteger((int)3000)).config().metadataLogDir(), "__cluster_metadata-0");
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testSnapshotCount$2(metaLog)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Failed to see at least one snapshot");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Thread.sleep(5000L);
            long countAfterTenIntervals = KRaftClusterTest.snapshotCounter$1(metaLog);
            Assertions.assertTrue((countAfterTenIntervals > 1L ? 1 : 0) != 0, (String)new StringBuilder(48).append("Expected to see at least one more snapshot, saw ").append(countAfterTenIntervals).toString());
            Assertions.assertTrue((countAfterTenIntervals < 20L ? 1 : 0) != 0, (String)new StringBuilder(83).append("Did not expect to see more than twice as many snapshots as snapshot intervals, saw ").append(countAfterTenIntervals).toString());
        }
    }

    @Test
    public void testAuthorizerFailureFoundInControllerStartup() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumControllerNodes(3).build()).setConfigProp("authorizer.class.name", BadAuthorizer.class.getName()).build();){
            cluster.format();
            ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> cluster.startup());
            Assertions.assertEquals((Object)"java.lang.IllegalStateException: test authorizer exception", (Object)exception.getMessage());
            cluster.fatalFaultHandler().setIgnore(true);
        }
    }

    @Test
    public void testSingleControllerSingleBrokerCluster() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.MINIMUM_BOOTSTRAP_VERSION).setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testReconfigureControllerClientQuotas(boolean combinedController) {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setCombined(combinedController).setNumControllerNodes(1).build()).setConfigProp("client.quota.callback.class", DummyClientQuotaCallback.class.getName()).setConfigProp(DummyClientQuotaCallback$.MODULE$.dummyClientQuotaCallbackValueConfigKey(), "0").build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            KRaftClusterTest.assertConfigValue$1(0, cluster);
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                admin.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, ""), Collections.singletonList(new AlterConfigOp(new ConfigEntry(DummyClientQuotaCallback$.MODULE$.dummyClientQuotaCallbackValueConfigKey(), "1"), AlterConfigOp.OpType.SET)))).all().get();
            }
            KRaftClusterTest.assertConfigValue$1(1, cluster);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testReconfigureControllerAuthorizer(boolean combinedMode) {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setCombined(combinedMode).setNumControllerNodes(1).build()).setConfigProp("authorizer.class.name", FakeConfigurableAuthorizer.class.getName()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            KRaftClusterTest.assertFoobarValue$1(0, cluster);
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                admin.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, ""), Collections.singletonList(new AlterConfigOp(new ConfigEntry(FakeConfigurableAuthorizer$.MODULE$.foobarConfigKey(), "123"), AlterConfigOp.OpType.SET)))).all().get();
            }
            KRaftClusterTest.assertFoobarValue$1(123, cluster);
        }
    }

    @Test
    public void testOverlyLargeCreateTopics() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                ArrayList newTopics = new ArrayList();
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 10000).foreach((Function1)(JFunction1.mcZI.sp & Serializable)i -> newTopics.add(new NewTopic(new StringBuilder(3).append("foo").append(i).toString(), 100000, (short)1)));
                ExecutionException executionException = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> admin.createTopics((Collection)newTopics).all().get());
                Assertions.assertNotNull((Object)executionException.getCause());
                Assertions.assertEquals(PolicyViolationException.class, executionException.getCause().getClass());
                Assertions.assertEquals((Object)"Unable to perform excessively large batch operation.", (Object)executionException.getCause().getMessage());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTimedOutHeartbeats() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(3).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.BrokerHeartbeatIntervalMsProp(), Integer.toString(10)).setConfigProp(KafkaConfig$.MODULE$.BrokerSessionTimeoutMsProp(), Integer.toString(1000)).build();){
            cluster.format();
            cluster.startup();
            ControllerServer controller = cluster.controllers().values().iterator().next();
            controller.controller().waitForReadyBrokers(3).get();
            long l = 60000L;
            TestUtils$ retry_this = TestUtils$.MODULE$;
            long l2 = 1L;
            long retry_startTime = System.currentTimeMillis();
            while (true) {
                try {
                    KRaftClusterTest.$anonfun$testTimedOutHeartbeats$1(controller);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this.logger().underlying().isInfoEnabled()) {
                        String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                        Object var10_9 = null;
                        retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                    }
                    Thread.sleep(l2);
                    l2 += package$.MODULE$.min(l2, 1000L);
                    continue;
                }
                break;
            }
            Object var4_4 = null;
            Object var9_8 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testStartupWithNonDefaultKControllerDynamicConfiguration() {
        java.util.List<ApiMessageAndVersion> bootstrapRecords = Arrays.asList(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(MetadataVersion.IBP_3_6_IV2.featureLevel()), (short)0), new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("").setName("num.io.threads").setValue("9"), (short)0));
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadata(BootstrapMetadata.fromRecords(bootstrapRecords, (String)"testRecords")).setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            ControllerServer controller = cluster.controllers().values().iterator().next();
            long l = 60000L;
            TestUtils$ retry_this = TestUtils$.MODULE$;
            long l2 = 1L;
            long retry_startTime = System.currentTimeMillis();
            while (true) {
                try {
                    KRaftClusterTest.$anonfun$testStartupWithNonDefaultKControllerDynamicConfiguration$1(controller);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this.logger().underlying().isInfoEnabled()) {
                        String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                        Object var11_10 = null;
                        retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                    }
                    Thread.sleep(l2);
                    l2 += package$.MODULE$.min(l2, 1000L);
                    continue;
                }
                break;
            }
            Object var5_5 = null;
            Object var10_9 = null;
        }
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndRestartControllerNode$1(ControllerServer x$1) {
        return x$1.controller().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndRestartControllerNode$3(ControllerServer x$2) {
        return x$2.controller().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndRestartControllerNode$2(KafkaClusterTestKit cluster$1) {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(cluster$1.controllers().values().iterator()).asScala().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$testCreateClusterAndRestartControllerNode$3(x$2)));
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndRestartControllerNode$4() {
        return "Timeout waiting for new controller election";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndWaitForBrokerInRunningState$1(KafkaClusterTestKit cluster$2) {
        BrokerState brokerState = cluster$2.brokers().get(BoxesRunTime.boxToInteger((int)0)).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndWaitForBrokerInRunningState$2() {
        return "Broker never made it to RUNNING state.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndWaitForBrokerInRunningState$3(KafkaClusterTestKit cluster$2) {
        return cluster$2.raftManagers().get(BoxesRunTime.boxToInteger((int)0)).client().leaderAndEpoch().leaderId().isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndWaitForBrokerInRunningState$4() {
        return "RaftManager was not initialized.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndCreateListDeleteTopic$1(KafkaClusterTestKit cluster$3) {
        BrokerState brokerState = cluster$3.brokers().get(BoxesRunTime.boxToInteger((int)0)).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndCreateListDeleteTopic$2() {
        return "Broker never made it to RUNNING state.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndCreateListDeleteTopic$3(KafkaClusterTestKit cluster$3) {
        return cluster$3.raftManagers().get(BoxesRunTime.boxToInteger((int)0)).client().leaderAndEpoch().leaderId().isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndCreateListDeleteTopic$4() {
        return "RaftManager was not initialized.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndCreateAndManyTopics$1(KafkaClusterTestKit cluster$4) {
        BrokerState brokerState = cluster$4.brokers().get(BoxesRunTime.boxToInteger((int)0)).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndCreateAndManyTopics$2() {
        return "Broker never made it to RUNNING state.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndCreateAndManyTopics$3(KafkaClusterTestKit cluster$4) {
        return cluster$4.raftManagers().get(BoxesRunTime.boxToInteger((int)0)).client().leaderAndEpoch().leaderId().isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndCreateAndManyTopics$4() {
        return "RaftManager was not initialized.";
    }

    public static final /* synthetic */ boolean $anonfun$testClientQuotas$1(KafkaClusterTestKit cluster$5) {
        BrokerState brokerState = cluster$5.brokers().get(BoxesRunTime.boxToInteger((int)0)).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testClientQuotas$2() {
        return "Broker never made it to RUNNING state.";
    }

    private static final java.util.Map describeOrFail$1(ClientQuotaFilter filter, Admin admin$1) {
        try {
            return (java.util.Map)admin$1.describeClientQuotas(filter).entities().get();
        }
        catch (Throwable t) {
            return (java.util.Map)Assertions.fail((String)"DescribeClientQuotas request failed", (Throwable)t);
        }
    }

    public static final /* synthetic */ java.util.Map $anonfun$testClientQuotas$3(ClientQuotaFilter filter$1, Admin admin$1) {
        return KRaftClusterTest.describeOrFail$1(filter$1, admin$1);
    }

    public static final /* synthetic */ boolean $anonfun$testClientQuotas$4(ClientQuotaEntity entity$1, int expectCount$1, java.util.Map results) {
        return results.getOrDefault(entity$1, Collections.emptyMap()).size() == expectCount$1;
    }

    /*
     * WARNING - void declaration
     */
    private static final java.util.Map alterThenDescribe$1(ClientQuotaEntity entity, scala.collection.immutable.Seq quotas, ClientQuotaFilter filter, int expectCount, Admin admin$1) {
        void var7_11;
        Tuple2 tuple2;
        try {
            admin$1.alterClientQuotas((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration(entity, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)quotas).asJava()), (List)Nil$.MODULE$)).asJava()).all().get();
        }
        catch (Throwable t) {
            Assertions.fail((String)"AlterClientQuotas request failed", (Throwable)t);
        }
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            java.util.Map computeUntilTrue_result;
            if (KRaftClusterTest.$anonfun$testClientQuotas$4(entity, expectCount, computeUntilTrue_result = KRaftClusterTest.describeOrFail$1(filter, admin$1))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var14_9 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        java.util.Map describeResult = (java.util.Map)tuple22._1();
        Assertions.assertTrue((boolean)tuple22._2$mcZ$sp(), (String)"Broker never saw new client quotas");
        return var7_11;
    }

    public static final /* synthetic */ void $anonfun$testClientQuotas$5(Admin admin$1, ObjectRef filter$2, ClientQuotaEntity entity$2, ClientQuotaEntity entity2$1) {
        java.util.Map results = (java.util.Map)admin$1.describeClientQuotas((ClientQuotaFilter)filter$2.elem).entities().get();
        Assertions.assertEquals((int)2, (int)results.size(), (String)"Broker did not see two client quotas");
        Assertions.assertEquals((double)9999.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)results.get(entity$2)).get("producer_byte_rate")), (double)1.0E-6);
        Assertions.assertEquals((double)9998.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)results.get(entity2$1)).get("producer_byte_rate")), (double)1.0E-6);
    }

    public static final /* synthetic */ long $anonfun$getConsumerByteRates$2(HashMap results$1, ClientQuotaEntity entity$3, Double x0$2) {
        return BoxesRunTime.unboxToLong((Object)results$1.put(entity$3, BoxesRunTime.boxToLong((long)x0$2.longValue())));
    }

    public static final /* synthetic */ boolean $anonfun$testDefaultClientQuotas$1(KafkaClusterTestKit cluster$6) {
        BrokerState brokerState = cluster$6.brokers().get(BoxesRunTime.boxToInteger((int)0)).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testDefaultClientQuotas$2() {
        return "Broker never made it to RUNNING state.";
    }

    public static final /* synthetic */ void $anonfun$testDefaultClientQuotas$3(KRaftClusterTest $this, Admin admin$2) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$), $this.getConsumerByteRates(admin$2));
    }

    public static final /* synthetic */ void $anonfun$testDefaultClientQuotas$4(KRaftClusterTest $this, ClientQuotaEntity defaultUser$1, Admin admin$2) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultUser$1), (Object)BoxesRunTime.boxToLong((long)100L))})), $this.getConsumerByteRates(admin$2));
    }

    public static final /* synthetic */ void $anonfun$testDefaultClientQuotas$5(KRaftClusterTest $this, ClientQuotaEntity defaultUser$1, ClientQuotaEntity bobUser$1, Admin admin$2) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultUser$1), (Object)BoxesRunTime.boxToLong((long)100L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bobUser$1), (Object)BoxesRunTime.boxToLong((long)1000L))})), $this.getConsumerByteRates(admin$2));
    }

    public static final /* synthetic */ void $anonfun$testCreateClusterWithAdvertisedPortZero$2(KRaftClusterTest $this, KafkaClusterTestKit cluster) {
        $this.sendDescribeClusterRequestToBoundPortUntilAllBrokersPropagated(cluster.nodes().externalListenerName(), scala.concurrent.duration.package$.MODULE$.pairLongToDuration(new Tuple2((Object)BoxesRunTime.boxToLong((long)15L), (Object)TimeUnit.SECONDS)), cluster).nodes().values().forEach(broker -> {
            Assertions.assertEquals((Object)"localhost", (Object)broker.host(), (String)"Did not advertise configured advertised host");
            Assertions.assertEquals((int)cluster.brokers().get(BoxesRunTime.boxToInteger((int)broker.id())).socketServer().boundPort(cluster.nodes().externalListenerName()), (int)broker.port(), (String)"Did not advertise bound socket port");
        });
    }

    public static final /* synthetic */ void $anonfun$testCreateClusterWithAdvertisedHostAndPortDifferentFromSocketServer$2(KRaftClusterTest $this, KafkaClusterTestKit cluster) {
        $this.sendDescribeClusterRequestToBoundPortUntilAllBrokersPropagated(cluster.nodes().externalListenerName(), scala.concurrent.duration.package$.MODULE$.pairLongToDuration(new Tuple2((Object)BoxesRunTime.boxToLong((long)15L), (Object)TimeUnit.SECONDS)), cluster).nodes().values().forEach(broker -> {
            Assertions.assertEquals((Object)new StringBuilder(16).append("advertised-host-").append(broker.id()).toString(), (Object)broker.host(), (String)"Did not advertise configured advertised host");
            Assertions.assertEquals((int)(broker.id() + 100), (int)broker.port(), (String)"Did not advertise configured advertised port");
        });
    }

    public static final /* synthetic */ boolean $anonfun$waitForRunningBrokers$1(BrokerServer brokerServer) {
        BrokerState brokerState = brokerServer.brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    private static final scala.collection.immutable.Seq getRunningBrokerServers$1(KafkaClusterTestKit cluster$8) {
        return (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.CollectionHasAsScala(cluster$8.brokers().values()).asScala().toSeq().filter((Function1 & Serializable)brokerServer -> BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$waitForRunningBrokers$1(brokerServer)));
    }

    public static final /* synthetic */ scala.collection.immutable.Seq $anonfun$waitForRunningBrokers$2(KafkaClusterTestKit cluster$8) {
        return KRaftClusterTest.getRunningBrokerServers$1(cluster$8);
    }

    public static final /* synthetic */ boolean $anonfun$sendDescribeClusterRequestToBoundPortUntilBrokersPropagated$2(int expectedBrokerCount$1, DescribeClusterResponse response) {
        return response.nodes().size() == expectedBrokerCount$1;
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndPerformReassignment$1(Admin admin$3) {
        return ((java.util.Map)admin$3.listPartitionReassignments().reassignments().get()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndPerformReassignment$2() {
        return "The reassignment never completed.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndPerformReassignment$3(KRaftClusterTest $this, Admin admin$3, ObjectRef currentMapping$1, scala.collection.immutable.Seq expectedMapping$1) {
        java.util.Map topicInfoMap = (java.util.Map)admin$3.describeTopics(Collections.singleton("foo")).allTopicNames().get();
        if (topicInfoMap.containsKey("foo")) {
            currentMapping$1.elem = $this.translatePartitionInfoToSeq(((TopicDescription)topicInfoMap.get("foo")).partitions());
            return expectedMapping$1.equals((Object)((scala.collection.immutable.Seq)currentMapping$1.elem));
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndPerformReassignment$4(scala.collection.immutable.Seq expectedMapping$1, ObjectRef currentMapping$1) {
        return new StringBuilder(72).append("Timed out waiting for replica assignments for topic foo. ").append("Wanted: ").append(expectedMapping$1).append(". Got: ").append((scala.collection.immutable.Seq)currentMapping$1.elem).toString();
    }

    public static final /* synthetic */ boolean $anonfun$checkReplicaManager$1(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$checkReplicaManager$3(Tuple2 check$ifrefutable$2) {
        return check$ifrefutable$2 != null;
    }

    public static final /* synthetic */ void $anonfun$checkReplicaManager$4(BrokerServer broker$1, Tuple2 x$8) {
        if (x$8 != null) {
            boolean isHosted = x$8._1$mcZ$sp();
            int partitionId = x$8._2$mcI$sp();
            TopicPartition topicPartition = new TopicPartition("foo", partitionId);
            if (isHosted) {
                Assertions.assertNotEquals((Object)HostedPartition.None$.MODULE$, (Object)broker$1.replicaManager().getPartition(topicPartition), (String)new StringBuilder(17).append("topicPartition = ").append(topicPartition).toString());
                return;
            }
            Assertions.assertEquals((Object)HostedPartition.None$.MODULE$, (Object)broker$1.replicaManager().getPartition(topicPartition), (String)new StringBuilder(17).append("topicPartition = ").append(topicPartition).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$checkReplicaManager$2(KafkaClusterTestKit cluster$10, Tuple2 x$9) {
        if (x$9 != null) {
            int brokerId = x$9._1$mcI$sp();
            List partitionsIsHosted = (List)x$9._2();
            BrokerServer broker = cluster$10.brokers().get(BoxesRunTime.boxToInteger((int)brokerId));
            ((IterableOps)partitionsIsHosted.zipWithIndex()).withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$checkReplicaManager$3(check$ifrefutable$2))).foreach((Function1 & Serializable)x$8 -> {
                KRaftClusterTest.$anonfun$checkReplicaManager$4(broker, x$8);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$waitForTopicListing$2(Admin admin$4, HashSet topicsNotFound$1, ObjectRef extraTopics$1, scala.collection.immutable.Seq expectedAbsent$1) {
        ((Iterable)admin$4.listTopics().names().get()).forEach(name -> topicsNotFound$1.remove(name));
        extraTopics$1.elem = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala((java.util.Set)admin$4.listTopics().names().get()).asScala().filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)expectedAbsent$1.contains((Object)x$11)));
        return topicsNotFound$1.isEmpty() && ((scala.collection.mutable.Set)extraTopics$1.elem).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$waitForTopicListing$5(HashSet topicsNotFound$1, ObjectRef extraTopics$1) {
        return new StringBuilder(49).append("Failed to find topic(s): ").append(CollectionConverters$.MODULE$.SetHasAsScala((java.util.Set)topicsNotFound$1).asScala()).append(" and NOT find topic(s): ").append((scala.collection.mutable.Set)extraTopics$1.elem).toString();
    }

    public static final /* synthetic */ void $anonfun$validateConfigs$1(KRaftClusterTest $this, Admin admin$5, scala.collection.immutable.Map expected$1, scala.collection.mutable.HashMap results$2, boolean exhaustive$1) {
        try {
            java.util.Map values = admin$5.describeConfigs((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)expected$1.keySet()).asJava()).values();
            results$2.clear();
            Assertions.assertEquals((Object)expected$1.keySet(), (Object)CollectionConverters$.MODULE$.SetHasAsScala(values.keySet()).asScala());
            expected$1.foreach((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    ConfigResource resource = (ConfigResource)x0$1._1();
                    scala.collection.immutable.Seq pairs = (scala.collection.immutable.Seq)x0$1._2();
                    Config config = (Config)((KafkaFuture)values.get(resource)).get();
                    TreeMap actual = new TreeMap();
                    TreeMap expected = new TreeMap();
                    config.entries().forEach(x0$2 -> {
                        actual.put(x0$2.name(), x0$2.value());
                        if (!exhaustive$1) {
                            expected.put(x0$2.name(), x0$2.value());
                            return;
                        }
                    });
                    pairs.foreach((Function1 & Serializable)x0$3 -> {
                        if (x0$3 != null) {
                            String k = (String)x0$3._1();
                            String v = (String)x0$3._2();
                            return expected.put(k, v);
                        }
                        throw new MatchError(null);
                    });
                    Assertions.assertEquals(expected, actual);
                    return results$2.put((Object)resource, actual);
                }
                throw new MatchError(null);
            });
            return;
        }
        catch (Throwable t) {
            $this.log().warn(new StringBuilder(27).append("Unable to describeConfigs(").append(CollectionConverters$.MODULE$.SetHasAsJava((Set)expected$1.keySet()).asJava()).append(")").toString(), t);
            throw t;
        }
    }

    public static final /* synthetic */ String $anonfun$testUnregisterBroker$2() {
        return "Timed out waiting for broker 0 to be unfenced.";
    }

    public static final /* synthetic */ boolean $anonfun$testUnregisterBroker$3(KRaftClusterTest $this, KafkaClusterTestKit cluster$11) {
        return !$this.brokerIsUnfenced($this.clusterImage(cluster$11, 1), 0);
    }

    public static final /* synthetic */ String $anonfun$testUnregisterBroker$4() {
        return "Timed out waiting for broker 0 to be fenced.";
    }

    public static final /* synthetic */ String $anonfun$testUnregisterBroker$6() {
        return "Timed out waiting for broker 0 to be fenced.";
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorumRequestToBrokers$2(KafkaClusterTestKit cluster$12, int i$1) {
        BrokerState brokerState = cluster$12.brokers().get(BoxesRunTime.boxToInteger((int)i$1)).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testDescribeQuorumRequestToBrokers$3() {
        return "Broker Never started up";
    }

    public static final /* synthetic */ java.util.List $anonfun$testDescribeQuorumRequestToBrokers$5(Admin admin$6) {
        return ((QuorumInfo)admin$6.describeMetadataQuorum(new DescribeMetadataQuorumOptions()).quorumInfo().get()).voters();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorumRequestToBrokers$6(java.util.List voters) {
        return voters.stream().allMatch(voter -> {
            if (voter.logEndOffset() > 0L) {
                OptionalLong optionalLong = voter.lastFetchTimestamp();
                OptionalLong optionalLong2 = OptionalLong.empty();
                if (optionalLong == null ? optionalLong2 != null : !((Object)optionalLong).equals(optionalLong2)) {
                    OptionalLong optionalLong3 = voter.lastCaughtUpTimestamp();
                    OptionalLong optionalLong4 = OptionalLong.empty();
                    if (optionalLong3 == null ? optionalLong4 != null : !((Object)optionalLong3).equals(optionalLong4)) {
                        return true;
                    }
                }
            }
            return false;
        });
    }

    public static final /* synthetic */ java.util.List $anonfun$testDescribeQuorumRequestToBrokers$8(Admin admin$6) {
        return ((QuorumInfo)admin$6.describeMetadataQuorum(new DescribeMetadataQuorumOptions()).quorumInfo().get()).observers();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorumRequestToBrokers$9(KafkaClusterTestKit cluster$12, java.util.List observers) {
        Set set = CollectionConverters$.MODULE$.MapHasAsScala(cluster$12.brokers()).asScala().keySet();
        scala.collection.immutable.Set set2 = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(observers).asScala().map((Function1 & Serializable)x$15 -> BoxesRunTime.boxToInteger((int)x$15.replicaId()))).toSet();
        return !(set != null ? !set.equals(set2) : set2 != null) && observers.stream().allMatch(observer -> {
            if (observer.logEndOffset() > 0L) {
                OptionalLong optionalLong = observer.lastFetchTimestamp();
                OptionalLong optionalLong2 = OptionalLong.empty();
                if (optionalLong == null ? optionalLong2 != null : !((Object)optionalLong).equals(optionalLong2)) {
                    OptionalLong optionalLong3 = observer.lastCaughtUpTimestamp();
                    OptionalLong optionalLong4 = OptionalLong.empty();
                    if (optionalLong3 == null ? optionalLong4 != null : !((Object)optionalLong3).equals(optionalLong4)) {
                        return true;
                    }
                }
            }
            return false;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testUpdateMetadataVersion$1(KafkaClusterTestKit cluster$13) {
        return cluster$13.brokers().get(BoxesRunTime.boxToInteger((int)1)).metadataCache().currentImage().features().metadataVersion().equals((Object)MetadataVersion.latest());
    }

    public static final /* synthetic */ String $anonfun$testUpdateMetadataVersion$2() {
        return "Timed out waiting for metadata version update.";
    }

    private static final long snapshotCounter$1(Path path) {
        return path.toFile().listFiles((x$18, name) -> name.toLowerCase().endsWith("checkpoint")).length;
    }

    public static final /* synthetic */ boolean $anonfun$testSnapshotCount$2(Path metaLog$1) {
        return KRaftClusterTest.snapshotCounter$1(metaLog$1) > 0L;
    }

    public static final /* synthetic */ String $anonfun$testSnapshotCount$3() {
        return "Failed to see at least one snapshot";
    }

    public static final /* synthetic */ void $anonfun$testReconfigureControllerClientQuotas$1(int expected$3, KafkaClusterTestKit cluster$15) {
        Assertions.assertEquals((int)expected$3, (int)((DummyClientQuotaCallback)cluster$15.controllers().values().iterator().next().quotaManagers().clientQuotaCallback().get()).value());
        Assertions.assertEquals((int)expected$3, (int)((DummyClientQuotaCallback)cluster$15.brokers().values().iterator().next().quotaManagers().clientQuotaCallback().get()).value());
    }

    private static final void assertConfigValue$1(int expected, KafkaClusterTestKit cluster$15) {
        long retry_maxWaitMs = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                KRaftClusterTest.$anonfun$testReconfigureControllerClientQuotas$1(expected, cluster$15);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l).append(", and then retrying.").toString();
                    Object var8_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += package$.MODULE$.min(l, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$testReconfigureControllerAuthorizer$1(int expected$4, KafkaClusterTestKit cluster$16) {
        Assertions.assertEquals((int)expected$4, (int)((FakeConfigurableAuthorizer)cluster$16.controllers().values().iterator().next().authorizer().get()).foobar().get());
        Assertions.assertEquals((int)expected$4, (int)((FakeConfigurableAuthorizer)cluster$16.brokers().values().iterator().next().authorizer().get()).foobar().get());
    }

    private static final void assertFoobarValue$1(int expected, KafkaClusterTestKit cluster$16) {
        long retry_maxWaitMs = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                KRaftClusterTest.$anonfun$testReconfigureControllerAuthorizer$1(expected, cluster$16);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l).append(", and then retrying.").toString();
                    Object var8_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += package$.MODULE$.min(l, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$testTimedOutHeartbeats$1(ControllerServer controller$1) {
        CountDownLatch latch = QuorumControllerIntegrationTestUtils.pause((QuorumController)((QuorumController)controller$1.controller()));
        Thread.sleep(1001L);
        latch.countDown();
        Assertions.assertEquals((int)0, (int)controller$1.sharedServer().controllerServerMetrics().fencedBrokerCount());
        Assertions.assertTrue((controller$1.quorumControllerMetrics().timedOutHeartbeats() > 0L ? 1 : 0) != 0, (String)"Expected timedOutHeartbeats to be greater than 0.");
    }

    public static final /* synthetic */ void $anonfun$testStartupWithNonDefaultKControllerDynamicConfiguration$1(ControllerServer controller$2) {
        Assertions.assertNotNull((Object)controller$2.controllerApisHandlerPool());
        Assertions.assertEquals((int)9, (int)controller$2.controllerApisHandlerPool().threadPoolSize().get());
    }

    public static final /* synthetic */ Object $anonfun$waitForRunningBrokers$3$adapted(scala.collection.immutable.Seq x$5) {
        return BoxesRunTime.boxToBoolean((boolean)x$5.nonEmpty());
    }

    public static final /* synthetic */ Object $anonfun$sendDescribeClusterRequestToBoundPortUntilBrokersPropagated$2$adapted(int expectedBrokerCount$1, DescribeClusterResponse response) {
        return BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$sendDescribeClusterRequestToBoundPortUntilBrokersPropagated$2(expectedBrokerCount$1, response));
    }

    public static final /* synthetic */ Object $anonfun$testDescribeQuorumRequestToBrokers$6$adapted(java.util.List voters) {
        return BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$6(voters));
    }

    public static final /* synthetic */ Object $anonfun$testDescribeQuorumRequestToBrokers$9$adapted(KafkaClusterTestKit cluster$12, java.util.List observers) {
        return BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$9(cluster$12, observers));
    }

    public static final /* synthetic */ Object $anonfun$testClientQuotas$4$adapted(ClientQuotaEntity entity$1, int expectCount$1, java.util.Map results) {
        return BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$testClientQuotas$4(entity$1, expectCount$1, results));
    }
}

