/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.server.ConfigHelper;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.ZkAdminManager$;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.ZkConfigRepository;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.DescribeConfigsRequestData;
import org.apache.kafka.common.message.DescribeConfigsResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005]4Aa\u0005\u000b\u00013!)\u0001\u0005\u0001C\u0001C!9A\u0005\u0001b\u0001\n\u0013)\u0003B\u0002\u0017\u0001A\u0003%a\u0005C\u0004.\u0001\t\u0007I\u0011\u0002\u0018\t\rm\u0002\u0001\u0015!\u00030\u0011\u001da\u0004A1A\u0005\nuBa!\u0011\u0001!\u0002\u0013q\u0004b\u0002\"\u0001\u0005\u0004%Ia\u0011\u0005\u0007\u0019\u0002\u0001\u000b\u0011\u0002#\t\u000f5\u0003!\u0019!C\u0005\u001d\"1!\u000b\u0001Q\u0001\n=CQa\u0015\u0001\u0005\u0002QCQa\u0019\u0001\u0005\u0002\u0011DQA\u001b\u0001\u0005\u0002QCQa\u001c\u0001\u0005\u0002QCQ!\u001d\u0001\u0005\u0002QCQa\u001d\u0001\u0005\u0002QCQ!\u001e\u0001\u0005\u0002Q\u0013!CW6BI6Lg.T1oC\u001e,'\u000fV3ti*\u0011QCF\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003]\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00015A\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0012\u0011\u0005\r\u0002Q\"\u0001\u000b\u0002\u0011i\\7\t\\5f]R,\u0012A\n\t\u0003O)j\u0011\u0001\u000b\u0006\u0003SY\t!A_6\n\u0005-B#!D&bM.\f'l[\"mS\u0016tG/A\u0005{W\u000ec\u0017.\u001a8uA\u00059Q.\u001a;sS\u000e\u001cX#A\u0018\u0011\u0005AJT\"A\u0019\u000b\u00055\u0012$BA\u001a5\u0003\u0019\u0019w.\\7p]*\u0011q#\u000e\u0006\u0003m]\na!\u00199bG\",'\"\u0001\u001d\u0002\u0007=\u0014x-\u0003\u0002;c\t9Q*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012A\u0010\t\u00037}J!\u0001\u0011\u000f\u0003\u0007%sG/A\u0005ce>\\WM]%eA\u0005)Ao\u001c9jGV\tA\t\u0005\u0002F\u00156\taI\u0003\u0002H\u0011\u0006!A.\u00198h\u0015\u0005I\u0015\u0001\u00026bm\u0006L!a\u0013$\u0003\rM#(/\u001b8h\u0003\u0019!x\u000e]5dA\u0005iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016,\u0012a\u0014\t\u0003GAK!!\u0015\u000b\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f\u00039iW\r^1eCR\f7)Y2iK\u0002\n\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002+B\u00111DV\u0005\u0003/r\u0011A!\u00168ji\"\u0012A\"\u0017\t\u00035\u0006l\u0011a\u0017\u0006\u00039v\u000b1!\u00199j\u0015\tqv,A\u0004kkBLG/\u001a:\u000b\u0005\u0001<\u0014!\u00026v]&$\u0018B\u00012\\\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\nde\u0016\fG/Z\"p]\u001aLw\rS3ma\u0016\u0014HcA3iSB\u00111EZ\u0005\u0003OR\u0011AbQ8oM&<\u0007*\u001a7qKJDQ!T\u0007A\u0002=CQ\u0001J\u0007A\u0002\u0019\nq\u0003^3ti\u000ec\u0017.\u001a8u#V|G/Y:U_B\u0013x\u000e]:)\u00059a\u0007C\u0001.n\u0013\tq7L\u0001\u0003UKN$\u0018\u0001\f;fgR$Um]2sS\n,7i\u001c8gS\u001e\u001cx+\u001b;i\u001dVdGnQ8oM&<WO]1uS>t7*Z=tQ\tyA.A\u0017uKN$H)Z:de&\u0014WmQ8oM&<7oV5uQ\u0016k\u0007\u000f^=D_:4\u0017nZ;sCRLwN\\&fsND#\u0001\u00057\u0002QQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3D_:4\u0017nZ:XSRD7i\u001c8gS\u001e,(/\u0019;j_:\\U-_:)\u0005Ea\u0017\u0001\n;fgR$Um]2sS\n,7i\u001c8gS\u001e\u001cx+\u001b;i\t>\u001cW/\\3oi\u0006$\u0018n\u001c8)\u0005Ia\u0007")
public class ZkAdminManagerTest {
    private final KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
    private final Metrics metrics = new Metrics();
    private final int brokerId;
    private final String topic;
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);

    private KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private String topic() {
        return this.topic;
    }

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    @AfterEach
    public void tearDown() {
        this.metrics().close();
    }

    public ConfigHelper createConfigHelper(MetadataCache metadataCache, KafkaZkClient zkClient) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zk", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        return new ConfigHelper(metadataCache, KafkaConfig$.MODULE$.fromProps(props), (ConfigRepository)new ZkConfigRepository(new AdminZkClient(zkClient, (Option)None$.MODULE$)));
    }

    @Test
    public void testClientQuotasToProps() {
        Map emptyProps = ZkAdminManager$.MODULE$.clientQuotaPropsToDoubleMap((Map)Predef$.MODULE$.Map().empty());
        Assertions.assertEquals((int)0, (int)emptyProps.size());
        Map oneProp = ZkAdminManager$.MODULE$.clientQuotaPropsToDoubleMap((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)"1234")})));
        Assertions.assertEquals((int)1, (int)oneProp.size());
        Assertions.assertEquals((double)1234.0, (double)BoxesRunTime.unboxToDouble((Object)oneProp.apply((Object)"foo")));
        Map emptyKey = ZkAdminManager$.MODULE$.clientQuotaPropsToDoubleMap((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), (Object)"-42.1")})));
        Assertions.assertEquals((int)1, (int)emptyKey.size());
        Assertions.assertEquals((double)-42.1, (double)BoxesRunTime.unboxToDouble((Object)emptyKey.apply((Object)"")));
        Map manyProps = ZkAdminManager$.MODULE$.clientQuotaPropsToDoubleMap((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)"1234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spam"), (Object)"-1234.56")})));
        Assertions.assertEquals((int)3, (int)manyProps.size());
        Assertions.assertThrows(NullPointerException.class, () -> ZkAdminManager$.MODULE$.clientQuotaPropsToDoubleMap((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), null)}))));
        Assertions.assertThrows(IllegalStateException.class, () -> ZkAdminManager$.MODULE$.clientQuotaPropsToDoubleMap((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)"bar")}))));
        Assertions.assertThrows(IllegalStateException.class, () -> ZkAdminManager$.MODULE$.clientQuotaPropsToDoubleMap((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)"")}))));
    }

    @Test
    public void testDescribeConfigsWithNullConfigurationKeys() {
        Mockito.when((Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic())).thenReturn((Object)TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zk", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataCache().contains(this.topic()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        .colon.colon resources = new .colon.colon((Object)new DescribeConfigsRequestData.DescribeConfigsResource().setResourceName(this.topic()).setResourceType(ConfigResource.Type.TOPIC.id()).setConfigurationKeys(null), (List)Nil$.MODULE$);
        List results = this.createConfigHelper(this.metadataCache(), this.zkClient()).describeConfigs((List)resources, true, true);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((DescribeConfigsResponseData.DescribeConfigsResult)results.head()).errorCode());
        Assertions.assertFalse((boolean)((DescribeConfigsResponseData.DescribeConfigsResult)results.head()).configs().isEmpty(), (String)"Should return configs");
    }

    @Test
    public void testDescribeConfigsWithEmptyConfigurationKeys() {
        Mockito.when((Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic())).thenReturn((Object)TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zk", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataCache().contains(this.topic()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        .colon.colon resources = new .colon.colon((Object)new DescribeConfigsRequestData.DescribeConfigsResource().setResourceName(this.topic()).setResourceType(ConfigResource.Type.TOPIC.id()), (List)Nil$.MODULE$);
        List results = this.createConfigHelper(this.metadataCache(), this.zkClient()).describeConfigs((List)resources, true, true);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((DescribeConfigsResponseData.DescribeConfigsResult)results.head()).errorCode());
        Assertions.assertFalse((boolean)((DescribeConfigsResponseData.DescribeConfigsResult)results.head()).configs().isEmpty(), (String)"Should return configs");
    }

    @Test
    public void testDescribeConfigsWithConfigurationKeys() {
        Mockito.when((Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic())).thenReturn((Object)TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zk", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataCache().contains(this.topic()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        .colon.colon resources = new .colon.colon((Object)new DescribeConfigsRequestData.DescribeConfigsResource().setResourceName(this.topic()).setResourceType(ConfigResource.Type.TOPIC.id()).setConfigurationKeys(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"retention.ms", (List)new .colon.colon((Object)"retention.bytes", (List)new .colon.colon((Object)"segment.bytes", (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$);
        List results = this.createConfigHelper(this.metadataCache(), this.zkClient()).describeConfigs((List)resources, true, true);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((DescribeConfigsResponseData.DescribeConfigsResult)results.head()).errorCode());
        Set resultConfigKeys = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(((DescribeConfigsResponseData.DescribeConfigsResult)results.head()).configs()).asScala().map((Function1 & Serializable)r -> r.name())).toSet();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"retention.ms", "retention.bytes", "segment.bytes"})), (Object)resultConfigKeys);
    }

    @Test
    public void testDescribeConfigsWithDocumentation() {
        Mockito.when((Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic())).thenReturn((Object)new Properties());
        Mockito.when((Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Broker(), Integer.toString(this.brokerId()))).thenReturn((Object)new Properties());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataCache().contains(this.topic()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        ConfigHelper configHelper = this.createConfigHelper(this.metadataCache(), this.zkClient());
        .colon.colon resources = new .colon.colon((Object)new DescribeConfigsRequestData.DescribeConfigsResource().setResourceName(this.topic()).setResourceType(ConfigResource.Type.TOPIC.id()), (List)new .colon.colon((Object)new DescribeConfigsRequestData.DescribeConfigsResource().setResourceName(Integer.toString(this.brokerId())).setResourceType(ConfigResource.Type.BROKER.id()), (List)Nil$.MODULE$));
        List results = configHelper.describeConfigs((List)resources, true, true);
        Assertions.assertEquals((int)2, (int)results.size());
        results.foreach((Function1 & Serializable)r -> {
            ZkAdminManagerTest.$anonfun$testDescribeConfigsWithDocumentation$1(r);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testDescribeConfigsWithDocumentation$1(DescribeConfigsResponseData.DescribeConfigsResult r) {
        Assertions.assertEquals((short)Errors.NONE.code(), (short)r.errorCode());
        Assertions.assertFalse((boolean)r.configs().isEmpty(), (String)"Should return configs");
        r.configs().forEach(c -> {
            Assertions.assertNotNull((Object)c.documentation(), (String)new StringBuilder(42).append("Config ").append(c.name()).append(" should have non null documentation").toString());
            Assertions.assertNotEquals((Object)new StringBuilder(43).append("Config ").append(c.name()).append(" should have non blank documentation").toString(), (Object)"", (String)c.documentation().trim());
        });
    }

    public ZkAdminManagerTest() {
        this.brokerId = 1;
        this.topic = "topic-1";
    }
}

