/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kdc.identitybackend;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.util.GeneralizedTime;
import org.apache.kerby.kerberos.kerb.spec.KerberosTime;
import org.apache.kerby.kerberos.kerb.spec.base.EncryptionKey;
import org.apache.kerby.kerberos.kerb.spec.base.PrincipalName;

public class LdapIdentityGetHelper {
    private Entry entry;

    public LdapIdentityGetHelper(Entry entry) {
        this.entry = entry;
    }

    public PrincipalName getPrincipalName() throws LdapInvalidAttributeValueException {
        String principalNameStr = this.entry.get("krb5PrincipalName").getString();
        PrincipalName principalName = new PrincipalName(principalNameStr);
        return principalName;
    }

    public int getKeyVersion() throws LdapInvalidAttributeValueException {
        String keyVersionStr = this.entry.get("krb5KeyVersionNumber").getString();
        int keyVersion = Integer.parseInt(keyVersionStr);
        return keyVersion;
    }

    public List<EncryptionKey> getKeys() throws IOException {
        Iterator iterator1 = this.entry.get("krb5Key").iterator();
        ArrayList<EncryptionKey> keys = new ArrayList<EncryptionKey>();
        while (iterator1.hasNext()) {
            byte[] encryKey = ((Value)iterator1.next()).getBytes();
            EncryptionKey key = new EncryptionKey();
            key.decode(encryKey);
            key.setKvno(1);
            keys.add(key);
        }
        return keys;
    }

    public KerberosTime getCreatedTime() throws LdapInvalidAttributeValueException, ParseException {
        String createTime = this.entry.get("createTimestamp").getString();
        return this.createKerberosTime(createTime);
    }

    public KerberosTime getExpireTime() throws LdapInvalidAttributeValueException, ParseException {
        String expirationTime = this.entry.get("krb5AccountExpirationTime").getString();
        return this.createKerberosTime(expirationTime);
    }

    public boolean getDisabled() throws LdapInvalidAttributeValueException {
        String disabled = this.entry.get("krb5AccountDisabled").getString();
        return Boolean.parseBoolean(disabled);
    }

    public int getKdcFlags() throws LdapInvalidAttributeValueException {
        String krb5KDCFlags = this.entry.get("krb5KDCFlags").getString();
        return Integer.parseInt(krb5KDCFlags);
    }

    public boolean getLocked() throws LdapInvalidAttributeValueException {
        String lockedOut = this.entry.get("krb5AccountLockedOut").getString();
        return Boolean.parseBoolean(lockedOut);
    }

    private KerberosTime createKerberosTime(String generalizedTime) throws ParseException {
        long time = new GeneralizedTime(generalizedTime).getTime();
        return new KerberosTime(time);
    }
}

